/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadmin;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class ResourceClassProperties {
    String entryPath = null;
    ZipFile zip = null;
    Properties editorProperties = null;
    String[] helperClasses = new String[0];
    Hashtable helperProperties = null;
    Hashtable attributeProperties = null;

    static String[] getStringArray(Properties properties, String string) {
        String string2 = (String)properties.get(string);
        if (string2 == null) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    boolean aggregateHelpers() {
        if (this.editorProperties == null) {
            return true;
        }
        String string = (String)this.editorProperties.get("aggregateHelpers");
        return string != null && string.equalsIgnoreCase("true");
    }

    boolean aggregateAttributes() {
        if (this.editorProperties == null) {
            return true;
        }
        String string = (String)this.editorProperties.get("aggregateAttributes");
        return string != null && string.equalsIgnoreCase("true");
    }

    boolean aggregateAttributeProperties() {
        return false;
    }

    void loadPropertyDirectory(Hashtable hashtable, ZipFile zipFile, String string) {
        try {
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string2 = zipEntry.getName();
                if (!string2.startsWith(string) || !string2.endsWith(".p")) continue;
                Properties properties = new Properties();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                properties.load(bufferedInputStream);
                ((InputStream)bufferedInputStream).close();
                hashtable.put(string2.substring(string.length() + 1, string2.length() - 2), properties);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void initialize() {
        try {
            ZipEntry zipEntry = this.zip.getEntry(this.entryPath + "properties");
            if (zipEntry != null) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(this.zip.getInputStream(zipEntry));
                this.editorProperties = new Properties();
                this.editorProperties.load(bufferedInputStream);
                ((InputStream)bufferedInputStream).close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.editorProperties != null) {
            this.helperClasses = ResourceClassProperties.getStringArray(this.editorProperties, "helpers");
        }
        this.helperProperties = new Hashtable(11);
        this.loadPropertyDirectory(this.helperProperties, this.zip, this.entryPath + "helpers");
        this.attributeProperties = new Hashtable(11);
        this.loadPropertyDirectory(this.attributeProperties, this.zip, this.entryPath + "attrs");
    }

    String[] getHelperClasses() {
        return this.helperClasses;
    }

    Properties getHelperProperties(String string) {
        Properties properties = (Properties)this.helperProperties.get(string);
        return properties;
    }

    Properties getAttributeProperties(String string) {
        Properties properties = (Properties)this.attributeProperties.get(string);
        return properties;
    }

    Properties getEditorProperties() {
        return this.editorProperties;
    }

    String getEditorClass() {
        if (this.editorProperties == null) {
            return null;
        }
        return (String)this.editorProperties.get("class");
    }

    boolean isEditable() {
        if (this.editorProperties == null) {
            return true;
        }
        String string = (String)this.editorProperties.get("editable");
        if (string == null) {
            return true;
        }
        return !string.equalsIgnoreCase("false");
    }

    boolean isExtensible() {
        if (this.editorProperties == null) {
            return true;
        }
        String string = (String)this.editorProperties.get("extensible");
        if (string == null) {
            return true;
        }
        return !string.equalsIgnoreCase("false");
    }

    ResourceClassProperties(String string, ZipFile zipFile) {
        this.entryPath = string;
        this.zip = zipFile;
        this.initialize();
    }
}

