/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadmin.editors;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.w3c.jigadmin.PropertyManager;
import org.w3c.jigadmin.RemoteResourceWrapper;
import org.w3c.jigadmin.editors.AttributesHelper;
import org.w3c.jigadmin.editors.ServerHelperInterface;
import org.w3c.jigadmin.gui.Message;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.tools.sorter.Sorter;
import org.w3c.tools.widgets.Utilities;

public class PropertiesServerHelper
extends JPanel
implements ServerHelperInterface,
ChangeListener {
    protected String name = null;
    protected String tooltip = null;
    protected RemoteResourceWrapper root = null;
    protected String[] properties = null;
    protected JPanel cards = null;
    protected Hashtable helpers = null;
    protected String selected = null;

    public void initialize(String string, RemoteResourceWrapper remoteResourceWrapper, Properties properties) {
        this.name = string;
        this.root = remoteResourceWrapper;
        this.tooltip = (String)properties.get("tooltip");
        this.build();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JTabbedPane jTabbedPane;
        Object object = changeEvent.getSource();
        if (object instanceof JTabbedPane && (jTabbedPane = (JTabbedPane)object).getSelectedComponent() == this) {
            this.removeAll();
            this.invalidate();
            this.build();
            if (this.selected != null) {
                this.select(this.selected);
            }
            this.validate();
        }
    }

    protected void build() {
        int n = 0;
        JButton jButton = null;
        this.helpers = new Hashtable();
        try {
            this.properties = this.root.getResource().enumerateResourceIdentifiers();
            Sorter.sortStringArray((String[])this.properties, (boolean)true);
        }
        catch (RemoteAccessException remoteAccessException) {
            Message.showErrorMessage((Component)this, remoteAccessException);
        }
        if (this.properties == null) {
            return;
        }
        this.setLayout(new BorderLayout());
        n = this.properties.length;
        JPanel jPanel = new JPanel(new GridLayout(n, 1));
        this.cards = new JPanel(new CardLayout());
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertiesServerHelper.this.root.getServerBrowser().setCursor(3);
                String string = actionEvent.getActionCommand();
                PropertiesServerHelper.this.select(string);
                PropertiesServerHelper.this.root.getServerBrowser().setCursor(0);
            }
        };
        for (int i = 0; i < n; ++i) {
            String string = this.properties[i];
            jButton = new JButton(string);
            jButton.setVerticalTextPosition(0);
            jButton.setHorizontalTextPosition(0);
            jButton.setActionCommand(string);
            jButton.addActionListener(actionListener);
            jButton.setMargin(Utilities.insets2);
            jPanel.add(jButton);
            JPanel jPanel2 = new JPanel(new GridLayout(1, 1));
            jPanel2.setBorder(BorderFactory.createTitledBorder(string));
            this.helpers.put(string, jPanel2);
            this.cards.add(string, jPanel2);
        }
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel, "North");
        jPanel3.setBorder(BorderFactory.createTitledBorder("Properties"));
        this.add((Component)jPanel3, "West");
        this.add((Component)this.cards, "Center");
    }

    protected void select(String string) {
        this.selected = string;
        JPanel jPanel = (JPanel)this.helpers.get(string);
        jPanel.removeAll();
        try {
            RemoteResourceWrapper remoteResourceWrapper = this.root.getChildResource(string);
            AttributesHelper attributesHelper = new AttributesHelper();
            PropertyManager propertyManager = PropertyManager.getPropertyManager();
            Properties properties = propertyManager.getEditorProperties(remoteResourceWrapper);
            attributesHelper.initialize(remoteResourceWrapper, properties);
            jPanel.add(attributesHelper.getComponent());
            jPanel.invalidate();
            jPanel.validate();
        }
        catch (RemoteAccessException remoteAccessException) {
            Message.showErrorMessage((Component)this, remoteAccessException);
        }
        ((CardLayout)this.cards.getLayout()).show(this.cards, string);
    }

    public String getName() {
        return this.name;
    }

    public String getToolTip() {
        return this.tooltip;
    }

    public Component getComponent() {
        return this;
    }
}

