/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadmin.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.w3c.jigadmin.gui.AboutJigAdmin;
import org.w3c.jigadmin.gui.ServerBrowser;
import org.w3c.jigadmin.gui.WindowCloser;

class ServerMenu
extends JMenuBar
implements ActionListener {
    ServerBrowser browser = null;

    protected String getAdminURL() {
        String string = JOptionPane.showInputDialog(this, "Admin server URL", "Open", -1);
        if (string != null && !string.startsWith("http://")) {
            string = "http://" + string;
        }
        return string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("open")) {
            String string2 = this.getAdminURL();
            if (string2 == null) {
                return;
            }
            try {
                URL uRL = new URL(string2);
                this.browser.open(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                JOptionPane.showMessageDialog(this, string2 + " is not a valid URL", "Invalid URL", 0);
            }
        } else if (string.equals("new")) {
            String string3 = this.getAdminURL();
            if (string3 == null) {
                return;
            }
            URL uRL = null;
            try {
                uRL = new URL(string3);
            }
            catch (MalformedURLException malformedURLException) {
                JOptionPane.showMessageDialog(this, string3 + " is not a valid URL", "Invalid URL", 0);
            }
            JFrame jFrame = new JFrame("Server Browser: " + string3);
            ServerBrowser serverBrowser = new ServerBrowser(jFrame);
            jFrame.getContentPane().add((Component)serverBrowser, "Center");
            jFrame.setVisible(true);
            serverBrowser.open(uRL);
            ++WindowCloser.windows;
        } else if (string.equals("close")) {
            JFrame jFrame = this.browser.frame;
            jFrame.setVisible(false);
            jFrame.dispose();
            if (--WindowCloser.windows < 0) {
                System.exit(0);
            }
        } else if (string.equals("quit")) {
            JFrame jFrame = this.browser.frame;
            jFrame.setVisible(false);
            jFrame.dispose();
            WindowCloser.windows = 0;
            System.exit(0);
        } else if (string.equals("about")) {
            AboutJigAdmin.show(this);
        }
    }

    ServerMenu(ServerBrowser serverBrowser) {
        this.browser = serverBrowser;
        JMenu jMenu = new JMenu("JigAdmin");
        this.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("About JigAdmin");
        jMenuItem.setActionCommand("about");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem("Open");
        jMenuItem2.setActionCommand("open");
        jMenuItem2.addActionListener(this);
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Open in new window");
        jMenuItem3.setActionCommand("new");
        jMenuItem3.addActionListener(this);
        jMenu.add(jMenuItem3);
        jMenu.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem("Close window");
        jMenuItem4.setActionCommand("close");
        jMenuItem4.addActionListener(this);
        jMenu.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem("Exit");
        jMenuItem5.setActionCommand("quit");
        jMenuItem5.addActionListener(this);
        jMenu.add(jMenuItem5);
    }
}

