/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.frames;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import org.w3c.jigsaw.forms.URLDecoder;
import org.w3c.jigsaw.forms.URLDecoderException;
import org.w3c.jigsaw.frames.HTTPFrame;
import org.w3c.jigsaw.html.HtmlGenerator;
import org.w3c.jigsaw.http.Client;
import org.w3c.jigsaw.http.ClientException;
import org.w3c.jigsaw.http.HTTPException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.BooleanAttribute;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ResourceException;
import org.w3c.www.http.HttpFactory;
import org.w3c.www.http.HttpTokenList;
import org.w3c.www.mime.MimeType;

public class PostableFrame
extends HTTPFrame {
    private static MimeType type = MimeType.APPLICATION_X_WWW_FORM_URLENCODED;
    protected static int ATTR_OVERIDE = -1;
    protected static int ATTR_CONVERT_GET = -1;

    public boolean getConvertGetFlag() {
        return this.getBoolean(ATTR_CONVERT_GET, false);
    }

    public boolean getOverrideFlag() {
        return this.getBoolean(ATTR_OVERIDE, true);
    }

    protected HttpTokenList getAllow() {
        if (this.allowed != null) {
            return this.allowed;
        }
        int n = 5;
        if (this.getPutableFlag()) {
            ++n;
        }
        if (this.getAllowDeleteFlag()) {
            ++n;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        if (this.getAllowDeleteFlag()) {
            stringArray[n2++] = "DELETE";
        }
        stringArray[n2++] = "HEAD";
        stringArray[n2++] = "GET";
        stringArray[n2++] = "OPTIONS";
        stringArray[n2++] = "POST";
        if (this.getPutableFlag()) {
            stringArray[n2++] = "PUT";
        }
        stringArray[n2] = "TRACE";
        this.allowed = HttpFactory.makeStringList(stringArray);
        return this.allowed;
    }

    public Reply get(Request request) throws ProtocolException, ResourceException {
        if (!this.getConvertGetFlag() || !request.hasState("query")) {
            return super.get(request);
        }
        String string = request.getQueryString();
        StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(string);
        URLDecoder uRLDecoder = new URLDecoder(stringBufferInputStream, this.getOverrideFlag());
        try {
            uRLDecoder.parse();
        }
        catch (URLDecoderException uRLDecoderException) {
            Reply reply = request.makeReply(400);
            reply.setContent("Invalid request:unable to decode form data.");
            throw new HTTPException(reply);
        }
        catch (IOException iOException) {
            Reply reply = request.makeReply(400);
            reply.setContent("Invalid request: unable to read form data.");
            throw new HTTPException(reply);
        }
        return this.handle(request, uRLDecoder);
    }

    public Reply post(Request request) throws ProtocolException, ResourceException {
        boolean bl = false;
        if (request.hasContentType()) {
            bl = type.match(request.getContentType()) == 4;
        }
        URLDecoder uRLDecoder = null;
        if (bl) {
            try {
                InputStream inputStream = request.getInputStream();
                Client client = request.getClient();
                if (client != null) {
                    client.sendContinue();
                }
                uRLDecoder = new URLDecoder(inputStream, this.getOverrideFlag());
                uRLDecoder.parse();
            }
            catch (URLDecoderException uRLDecoderException) {
                Reply reply = request.makeReply(400);
                reply.setContent("Invalid request: unable to decode form data.");
                throw new HTTPException(reply);
            }
            catch (IOException iOException) {
                Reply reply = request.makeReply(400);
                reply.setContent("Invalid request: unable to read form data.");
                throw new ClientException(request.getClient(), iOException);
            }
        }
        return this.handle(request, uRLDecoder);
    }

    public Reply handle(Request request, URLDecoder uRLDecoder) throws ProtocolException {
        Object object;
        HtmlGenerator htmlGenerator = new HtmlGenerator("Form decoded values");
        if (uRLDecoder != null) {
            object = uRLDecoder.keys();
            htmlGenerator.append("<p>List of variables and values:</p><ul>");
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                htmlGenerator.append("<li><em>" + string + "</em> = <b>" + uRLDecoder.getValue(string) + "</b></li>");
            }
            htmlGenerator.append("</ul>");
        } else {
            htmlGenerator.append("<p>Not with the application/x-www-form-urlencoded mime type");
        }
        object = request.makeReply(200);
        ((Reply)object).setStream(htmlGenerator);
        return object;
    }

    static {
        BooleanAttribute booleanAttribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.frames.PostableFrame");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        booleanAttribute = new BooleanAttribute("override", Boolean.FALSE, 2);
        ATTR_OVERIDE = AttributeRegistry.registerAttribute(clazz, booleanAttribute);
        booleanAttribute = new BooleanAttribute("convert-get", Boolean.TRUE, 2);
        ATTR_CONVERT_GET = AttributeRegistry.registerAttribute(clazz, booleanAttribute);
    }
}

