/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.html;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.w3c.jigsaw.html.HtmlHead;
import org.w3c.jigsaw.html.HtmlLink;
import org.w3c.www.mime.MimeType;

public class HtmlGenerator {
    private static MimeType defaultType = MimeType.TEXT_HTML;
    HtmlHead head = null;
    StringBuffer body = null;
    String content = null;
    boolean bodytag = true;
    String encoding = null;
    private MimeType type = null;

    public MimeType getMimeType() {
        return this.type == null ? defaultType : this.type;
    }

    public void emitBODYTag(boolean bl) {
        this.bodytag = bl;
    }

    public void appendAndEscape(String string) {
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    this.body.append("&lt;");
                    continue block5;
                }
                case '>': {
                    this.body.append("&gt;");
                    continue block5;
                }
                case '&': {
                    this.body.append("&amp;");
                    continue block5;
                }
                default: {
                    this.body.append(c);
                }
            }
        }
    }

    public void addBase(String string) {
        this.head.addBase(string);
    }

    public void addStyle(String string) {
        this.head.addStyle(string);
    }

    public void addStyle(MimeType mimeType, String string) {
        this.head.addStyle(mimeType, string);
    }

    public void addScript(String string) {
        this.head.addScript(string);
    }

    public void addScript(String string, String string2) {
        this.head.addScript(string, string2);
    }

    public void addLink(HtmlLink htmlLink) {
        this.head.addLink(htmlLink);
    }

    public void append(String string) {
        this.body.append(string);
    }

    public void append(String string, String string2) {
        this.body.append(string);
        this.body.append(string2);
    }

    public void append(String string, String string2, String string3) {
        this.body.append(string);
        this.body.append(string2);
        this.body.append(string3);
    }

    public int length() {
        if (this.content == null) {
            this.close();
        }
        return this.content.length();
    }

    public void close() {
        if (this.content != null) {
            return;
        }
        this.content = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n               \"http://www.w3.org/TR/html4/loose.dtd\">\n<html>\n" + this.head.toString() + "\n" + (this.bodytag ? "<body>\n" + this.body.toString() + "</body>\n" : this.body.toString()) + "</html>";
    }

    public void addMeta(String string, String string2) {
        this.head.addMeta(string, string2);
    }

    public void meta(String string, String string2) {
        this.addMeta(string, string2);
    }

    public InputStream getInputStream() {
        this.close();
        try {
            return new ByteArrayInputStream(this.content.getBytes(this.encoding));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(this.getClass().getName() + "[getInputStream] Unable to convert" + "properly char to bytes");
        }
    }

    public HtmlGenerator(String string, String string2) {
        this.head = new HtmlHead(string);
        this.body = new StringBuffer();
        this.encoding = string2;
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[1];
        stringArray[0] = "charset";
        stringArray2[0] = string2;
        this.type = new MimeType("text", "html", stringArray, stringArray2);
    }

    public HtmlGenerator(String string) {
        this(string, "ISO-8859-1");
    }
}

