/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.http.httpd;
import org.w3c.jigsaw.servlet.JigsawHttpServletRequest;
import org.w3c.jigsaw.servlet.JigsawHttpServletResponse;
import org.w3c.jigsaw.servlet.JigsawServletContext;
import org.w3c.jigsaw.servlet.ServletDirectoryFrame;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.LookupResult;
import org.w3c.tools.resources.LookupState;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceException;
import org.w3c.tools.resources.ResourceReference;

public class JigsawRequestDispatcher
implements RequestDispatcher {
    public static final String REQUEST_URI_P = "javax.servlet.include.request_uri";
    public static final String CONTEXT_PATH_P = "javax.servlet.include.context_path";
    public static final String SERVLET_PATH_P = "javax.servlet.include.servlet_path";
    public static final String PATH_INFO_P = "javax.servlet.include.path_info";
    public static final String QUERY_STRING_P = "javax.servlet.include.query_string";
    private httpd server = null;
    private String urlpath = null;

    public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        JigsawHttpServletResponse jigsawHttpServletResponse = (JigsawHttpServletResponse)servletResponse;
        JigsawHttpServletRequest jigsawHttpServletRequest = (JigsawHttpServletRequest)servletRequest;
        if (jigsawHttpServletResponse.isStreamObtained()) {
            throw new IllegalStateException("Can't Forward! OutputStream or Writer has allready been obtained.");
        }
        Request request = (Request)jigsawHttpServletRequest.getRequest().getClone();
        String string = request.getHost();
        try {
            if (string == null) {
                request.setURL(new URL(this.server.getURL(), this.urlpath));
            } else {
                request.setURL(new URL(this.server.getURL().getProtocol(), string, this.urlpath));
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        jigsawHttpServletResponse.getReply().setStatus(1001);
        Reply reply = null;
        try {
            reply = (Reply)this.server.perform(request);
        }
        catch (ResourceException resourceException) {
            reply = request.makeReply(500);
            reply.setContent(resourceException.getMessage());
        }
        catch (ProtocolException protocolException) {
            if (protocolException.hasReply()) {
                reply = (Reply)protocolException.getReply();
            }
            reply = request.makeReply(500);
            reply.setContent(protocolException.getMessage());
        }
        if (reply.hasStream()) {
            jigsawHttpServletResponse.getReply().setStatus(reply.getStatus());
            InputStream inputStream = reply.openStream();
            try {
                ServletOutputStream servletOutputStream = jigsawHttpServletResponse.getOutputStream();
                byte[] byArray = new byte[512];
                int n = -1;
                while ((n = inputStream.read(byArray, 0, 512)) != -1) {
                    servletOutputStream.write(byArray, 0, n);
                }
            }
            catch (IllegalStateException illegalStateException) {
                PrintWriter printWriter = jigsawHttpServletResponse.getWriter();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                char[] cArray = new char[512];
                int n = -1;
                while ((n = ((Reader)inputStreamReader).read(cArray, 0, 512)) != -1) {
                    ((Writer)printWriter).write(cArray, 0, n);
                }
            }
        }
    }

    public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        JigsawHttpServletResponse jigsawHttpServletResponse = (JigsawHttpServletResponse)servletResponse;
        JigsawHttpServletRequest jigsawHttpServletRequest = (JigsawHttpServletRequest)servletRequest;
        Request request = (Request)jigsawHttpServletRequest.getRequest().getClone();
        String string = request.getHost();
        try {
            if (string == null) {
                request.setURL(new URL(this.server.getURL(), this.urlpath));
            } else {
                request.setURL(new URL(this.server.getURL().getProtocol(), string, this.urlpath));
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        jigsawHttpServletResponse.flushStream(false);
        Reply reply = null;
        try {
            request.setState(REQUEST_URI_P, jigsawHttpServletRequest.getRequestURI());
            request.setState(SERVLET_PATH_P, jigsawHttpServletRequest.getServletPath());
            request.setState(PATH_INFO_P, jigsawHttpServletRequest.getPathInfo());
            request.setState(QUERY_STRING_P, jigsawHttpServletRequest.getQueryString());
            request.setState("org.w3c.jigsaw.servlet.included", Boolean.TRUE);
            reply = (Reply)this.server.perform(request);
        }
        catch (ResourceException resourceException) {
            reply = request.makeReply(500);
            reply.setContent(resourceException.getMessage());
        }
        catch (ProtocolException protocolException) {
            if (protocolException.hasReply()) {
                reply = (Reply)protocolException.getReply();
            }
            reply = request.makeReply(500);
            reply.setContent(protocolException.getMessage());
        }
        if (reply.hasStream()) {
            InputStream inputStream = reply.openStream();
            try {
                ServletOutputStream servletOutputStream = jigsawHttpServletResponse.getOutputStream();
                byte[] byArray = new byte[512];
                int n = -1;
                while ((n = inputStream.read(byArray, 0, 512)) != -1) {
                    servletOutputStream.write(byArray, 0, n);
                }
            }
            catch (IllegalStateException illegalStateException) {
                PrintWriter printWriter = jigsawHttpServletResponse.getWriter();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                char[] cArray = new char[512];
                int n = -1;
                while ((n = ((Reader)inputStreamReader).read(cArray, 0, 512)) != -1) {
                    ((Writer)printWriter).write(cArray, 0, n);
                }
            }
        }
    }

    protected JigsawRequestDispatcher(String string, httpd httpd2) {
        this.server = httpd2;
        this.urlpath = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RequestDispatcher getRequestDispatcher(String string, ResourceReference resourceReference, httpd httpd2) {
        try {
            Resource resource = resourceReference.lock();
            if (!(resource instanceof ServletDirectoryFrame)) {
                throw new IllegalArgumentException("Not a servlet container!");
            }
            ServletDirectoryFrame servletDirectoryFrame = (ServletDirectoryFrame)resource;
            if (servletDirectoryFrame.isServletLoaded(string)) {
                String string2 = servletDirectoryFrame.getResource().getURLPath();
                string2 = string2.endsWith("/") ? string2 + string : string2 + "/" + string;
                JigsawRequestDispatcher jigsawRequestDispatcher = new JigsawRequestDispatcher(string2, httpd2);
                return jigsawRequestDispatcher;
            }
        }
        catch (InvalidResourceException invalidResourceException) {
            RequestDispatcher requestDispatcher = null;
            return requestDispatcher;
        }
        finally {
            resourceReference.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RequestDispatcher getRequestDispatcher(String string, httpd httpd2, ResourceReference resourceReference) {
        Object object;
        ResourceReference resourceReference2 = null;
        FramedResource framedResource = null;
        resourceReference2 = JigsawServletContext.getLocalRoot(httpd2.getRootReference(), resourceReference);
        try {
            framedResource = (FramedResource)resourceReference2.lock();
            ResourceReference resourceReference3 = null;
            try {
                object = new LookupState(string);
                LookupResult lookupResult = new LookupResult(resourceReference2);
                framedResource.lookup((LookupState)object, lookupResult);
                resourceReference3 = lookupResult.getTarget();
            }
            catch (Exception exception) {
                resourceReference3 = null;
            }
            if (resourceReference3 == null) {
                object = null;
                return object;
            }
            object = new JigsawRequestDispatcher(string, httpd2);
            return object;
        }
        catch (InvalidResourceException invalidResourceException) {
            object = null;
            return object;
        }
        finally {
            resourceReference2.unlock();
        }
    }
}

