/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.servlet;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.http.httpd;
import org.w3c.jigsaw.servlet.AutoReloadServletLoader;
import org.w3c.jigsaw.servlet.JigsawHttpServletRequest;
import org.w3c.jigsaw.servlet.JigsawHttpServletResponse;
import org.w3c.jigsaw.servlet.JigsawHttpSessionContext;
import org.w3c.jigsaw.servlet.JigsawServletContext;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.IntegerAttribute;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.LongAttribute;
import org.w3c.tools.resources.ObjectAttribute;
import org.w3c.tools.resources.PropertiesAttribute;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.StringAttribute;
import org.w3c.tools.timers.EventHandler;
import org.w3c.tools.timers.EventManager;
import org.w3c.util.ArrayDictionary;
import org.w3c.util.EmptyEnumeration;
import org.w3c.util.ThreadCache;

public class ServletWrapper
extends FramedResource
implements ServletConfig {
    static final ThreadCache threadCache = new ThreadCache("servlet-runner");
    static int global = 0;
    private int local = 0;
    public static final String RUNNER = "org.w3c.jigsaw.servlet.runner";
    public static final String ENDED = "org.w3c.jigsaw.servlet.ended";
    protected TimeoutManager timeoutManager = null;
    protected static final boolean debug = false;
    protected static int ATTR_SERVLET_CLASS;
    protected static int ATTR_SERVLET_TIMEOUT;
    protected static int ATTR_SERVLET_INSTANCEMAX;
    protected static int ATTR_PARAMETERS;
    protected static int ATTR_SERVLET_CONTEXT;
    protected static int ATTR_SESSION_CONTEXT;
    protected final ServletPool servletPool = new ServletPool();
    protected boolean inited = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void tuneCache(int n) {
        int n2 = n - this.local;
        if (n2 != 0) {
            this.local = n;
            ThreadCache threadCache = ServletWrapper.threadCache;
            synchronized (threadCache) {
                global = Math.max(global + n2, 0);
                ServletWrapper.threadCache.setCachesize(global);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getServletDirectory() {
        ResourceReference resourceReference = this.getParent();
        if (resourceReference != null) {
            try {
                Resource resource = resourceReference.lock();
                if (resource.definesAttribute("directory")) {
                    File file = (File)resource.getValue("directory", null);
                    return file;
                }
            }
            catch (InvalidResourceException invalidResourceException) {
                invalidResourceException.printStackTrace();
            }
            finally {
                resourceReference.unlock();
            }
        }
        return null;
    }

    public synchronized String getInitParameter(String string) {
        ArrayDictionary arrayDictionary = this.getServletParameters();
        String string2 = arrayDictionary != null ? (String)arrayDictionary.get(string) : null;
        return string2;
    }

    public synchronized Enumeration getInitParameterNames() {
        ArrayDictionary arrayDictionary = this.getServletParameters();
        return arrayDictionary != null ? arrayDictionary.keys() : new EmptyEnumeration();
    }

    public ServletContext getServletContext() {
        ServletContext servletContext = (ServletContext)this.getValue(ATTR_SERVLET_CONTEXT, null);
        return servletContext;
    }

    public JigsawHttpSessionContext getSessionContext() {
        return (JigsawHttpSessionContext)this.getValue(ATTR_SESSION_CONTEXT, null);
    }

    protected long getServletTimeout() {
        long l = this.getLong(ATTR_SERVLET_TIMEOUT, 0L);
        if (l == 0L) {
            JigsawServletContext jigsawServletContext = (JigsawServletContext)this.getServletContext();
            l = jigsawServletContext.getServletTimeout();
        }
        return l;
    }

    protected int getInstanceMax() {
        int n = this.getInt(ATTR_SERVLET_INSTANCEMAX, 0);
        if (n == 0) {
            JigsawServletContext jigsawServletContext = (JigsawServletContext)this.getServletContext();
            n = jigsawServletContext.getServletInstanceMax();
        }
        return n;
    }

    protected void invalidateAllSession() {
        JigsawHttpSessionContext jigsawHttpSessionContext = this.getSessionContext();
        Enumeration enumeration = jigsawHttpSessionContext.getIds();
        while (enumeration.hasMoreElements()) {
            jigsawHttpSessionContext.getSession((String)enumeration.nextElement()).invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkServlet() throws ClassNotFoundException, ServletException {
        ServletPool servletPool = this.servletPool;
        synchronized (servletPool) {
            boolean bl = this.getLocalServletLoader().classChanged(this.getServletClass());
            if (!this.inited || bl || this.servletPool.getLoadedClass() != this.getLocalServletLoader().loadClass(this.getServletClass())) {
                this.inited = this.launchServlet();
            }
        }
    }

    protected boolean isInited() {
        return this.inited;
    }

    public boolean isServletLoaded() {
        try {
            this.checkServlet();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.inited;
    }

    protected void service(Request request, Reply reply) throws ServletException, IOException {
        JigsawHttpServletResponse jigsawHttpServletResponse = null;
        JigsawHttpServletRequest jigsawHttpServletRequest = null;
        jigsawHttpServletResponse = new JigsawHttpServletResponse(request, reply);
        Servlet servlet = this.servletPool.takeServlet();
        JigsawServletContext jigsawServletContext = (JigsawServletContext)this.getServletContext();
        jigsawHttpServletRequest = new JigsawHttpServletRequest(servlet, jigsawServletContext, request, jigsawHttpServletResponse, this.getSessionContext());
        jigsawHttpServletResponse.setServletRequest(jigsawHttpServletRequest);
        ServletRunner servletRunner = new ServletRunner(servlet, jigsawHttpServletRequest, jigsawHttpServletResponse);
        reply.setState(RUNNER, servletRunner);
        threadCache.getThread(servletRunner, true);
        this.timeoutManager.restart();
    }

    public String getServletClass() {
        String string;
        String string2 = this.getString(ATTR_SERVLET_CLASS, null);
        if (string2 == null && (string = this.getIdentifier()).endsWith(".class")) {
            string2 = string;
        }
        return string2;
    }

    public ArrayDictionary getServletParameters() {
        return (ArrayDictionary)this.getValue(ATTR_PARAMETERS, null);
    }

    protected void setValueOfSuperClass(int n, Object object) {
        super.setValue(n, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(int n, Object object) {
        super.setValue(n, object);
        if (n == ATTR_SERVLET_CLASS && object != null || n == ATTR_PARAMETERS) {
            try {
                ServletPool servletPool = this.servletPool;
                synchronized (servletPool) {
                    this.inited = this.launchServlet();
                }
            }
            catch (Exception exception) {
                String string = "unable to set servlet class \"" + this.getServletClass() + "\" : " + exception.getMessage();
                this.getServer().errlog(string);
            }
        }
        if (n == ATTR_SERVLET_TIMEOUT) {
            this.timeoutManager.restart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyServlet() {
        RuntimeException runtimeException = null;
        ServletPool servletPool = this.servletPool;
        synchronized (servletPool) {
            Servlet servlet = this.servletPool.remove();
            while (servlet != null) {
                try {
                    ClassLoader classLoader = ServletWrapper.switchContext(servlet);
                    try {
                        servlet.destroy();
                    }
                    finally {
                        ServletWrapper.resetContext(classLoader);
                    }
                }
                catch (RuntimeException runtimeException2) {
                    if (runtimeException == null) continue;
                    runtimeException = runtimeException2;
                }
                finally {
                    servlet = this.servletPool.remove();
                }
            }
            boolean bl = this.inited = this.servletPool.getLoadedClass() != null;
            if (!this.inited) {
                this.servletPool.clean(0L);
                this.tuneCache(0);
            }
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
    }

    public Servlet getServlet() {
        try {
            this.checkServlet();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.servletPool.getRepresentative();
    }

    private static final ClassLoader switchContext(Servlet servlet) {
        if (servlet != null) {
            Thread thread;
            ClassLoader classLoader;
            ClassLoader classLoader2 = servlet.getClass().getClassLoader();
            if (classLoader2 != (classLoader = (thread = Thread.currentThread()).getContextClassLoader())) {
                thread.setContextClassLoader(classLoader2);
                return classLoader;
            }
            return null;
        }
        return null;
    }

    private static final void resetContext(ClassLoader classLoader) {
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean launchServlet(Class clazz) throws ServletException {
        Servlet servlet = null;
        try {
            servlet = (Servlet)clazz.newInstance();
            ClassLoader classLoader = ServletWrapper.switchContext(servlet);
            try {
                servlet.init((ServletConfig)this);
            }
            finally {
                ServletWrapper.resetContext(classLoader);
            }
            this.timeoutManager.restart();
            return this.servletPool.add(servlet);
        }
        catch (IllegalAccessException illegalAccessException) {
            String string = "Illegal access during servlet instantiation, " + illegalAccessException.getClass().getName() + ": " + illegalAccessException.getMessage();
            this.getServer().errlog(this, string);
            throw new ServletException(string, (Throwable)illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            String string = "unable to instantiate servlet, " + instantiationException.getClass().getName() + ": " + instantiationException.getMessage();
            this.getServer().errlog(this, string);
            throw new ServletException(string, (Throwable)instantiationException);
        }
        catch (ServletException servletException) {
            String string = "Error while initializing servlet";
            this.getServer().errlog(this, string);
            this.getServer().errlog(this, string);
            throw servletException;
        }
        catch (Exception exception) {
            String string = "Error while loading servlet";
            this.getServer().errlog(this, string);
            this.getServer().errlog(this, string);
            throw new ServletException(string, (Throwable)exception);
        }
    }

    protected boolean isWrappingAServlet() {
        String string = this.getServletClass();
        if (string == null) {
            return false;
        }
        Class clazz = null;
        try {
            clazz = this.getLocalServletLoader().loadClass(string, true);
            Object t = clazz.newInstance();
            return t instanceof Servlet;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean launchServlet() throws ClassNotFoundException, ServletException {
        this.destroyServlet();
        if (this.inited) {
            String string = "relaunching servlet failed due to incomplete \"" + this.getServletClass() + "\" cleanup.";
            this.getServer().errlog(this, string);
            return false;
        }
        String string = this.getServletClass();
        if (string == null) {
            this.getServer().errlog(this, "no servlet class attribute defined.");
            return false;
        }
        Class clazz = null;
        try {
            if (this.getLocalServletLoader().classChanged(string)) {
                this.createNewLocalServletLoader(true);
                this.invalidateAllSession();
            }
            clazz = this.getLocalServletLoader().loadClass(string, true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string2 = "unable to find servlet class \"" + this.getServletClass() + "\"";
            this.getServer().errlog(string2);
            throw classNotFoundException;
        }
        return clazz != null ? this.launchServlet(clazz) : false;
    }

    public boolean acceptUnload() {
        return !this.inited;
    }

    public void notifyUnload() {
        if (this.timeoutManager != null) {
            this.timeoutManager.stop();
        }
        this.destroyServlet();
    }

    protected AutoReloadServletLoader getLocalServletLoader() {
        JigsawServletContext jigsawServletContext = (JigsawServletContext)this.getServletContext();
        return jigsawServletContext.getLocalServletLoader();
    }

    protected AutoReloadServletLoader createNewLocalServletLoader(boolean bl) {
        JigsawServletContext jigsawServletContext = (JigsawServletContext)this.getServletContext();
        return jigsawServletContext.createNewLocalServletLoader(bl);
    }

    public String getServletName() {
        return this.getIdentifier();
    }

    public void initialize(Object[] objectArray) {
        super.initialize(objectArray);
        if (this.getServletContext() != null) {
            this.timeoutManager = new TimeoutManager((httpd)this.getServer());
            this.timeoutManager.start();
        }
        try {
            this.registerFrameIfNone("org.w3c.jigsaw.servlet.ServletWrapperFrame", "servlet-wrapper-frame");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        threadCache.setCachesize(global);
        threadCache.setGrowAsNeeded(true);
        threadCache.initialize();
        ATTR_SERVLET_CLASS = -1;
        ATTR_SERVLET_TIMEOUT = -1;
        ATTR_SERVLET_INSTANCEMAX = -1;
        ATTR_PARAMETERS = 1;
        ATTR_SERVLET_CONTEXT = -1;
        ATTR_SESSION_CONTEXT = -1;
        Attribute attribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.servlet.ServletWrapper");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
        attribute = new StringAttribute("servlet-class", null, 6);
        ATTR_SERVLET_CLASS = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new PropertiesAttribute("servlet-parameters", null, 2);
        ATTR_PARAMETERS = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new ObjectAttribute("servlet-context", "org.w3c.jigsaw.servlet.JigsawServletContext", null, 8);
        ATTR_SERVLET_CONTEXT = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new ObjectAttribute("session-context", "org.w3c.jigsaw.servlet.JigsawHttpSessionContext", null, 8);
        ATTR_SESSION_CONTEXT = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new LongAttribute("servlet-timeout", null, 2);
        ATTR_SERVLET_TIMEOUT = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new IntegerAttribute("servlet-instancemax", null, 2);
        ATTR_SERVLET_INSTANCEMAX = AttributeRegistry.registerAttribute(clazz, attribute);
    }

    protected class ServletRunner
    implements Runnable,
    EventHandler {
        Servlet srServlet = null;
        JigsawHttpServletRequest srReq = null;
        JigsawHttpServletResponse srResp = null;
        Thread t = null;
        private Object stimer = null;
        private httpd server = (httpd)ServletWrapper.this.getServer();

        public void handleTimerEvent(Object object, long l) {
            this.signalTimeout();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void signalTimeout() {
            ServletRunner servletRunner = this;
            synchronized (servletRunner) {
                this.stimer = null;
                if (this.t != null) {
                    this.t.interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block70: {
                Object object;
                long l;
                block67: {
                    ServletRunner servletRunner = this;
                    synchronized (servletRunner) {
                        this.t = Thread.currentThread();
                    }
                    l = System.currentTimeMillis();
                    this.stimer = this.server.timer.registerTimer(this.server.getRequestTimeOut(), this, null);
                    object = null;
                    try {
                        Reply reply = this.srResp.getReply();
                        if (reply != null) {
                            object = reply.getState("org.w3c.jigsaw.servlet.monitor");
                        }
                        ClassLoader classLoader = ServletWrapper.switchContext(this.srServlet);
                        try {
                            this.srServlet.service((ServletRequest)this.srReq, (ServletResponse)this.srResp);
                        }
                        finally {
                            ServletWrapper.resetContext(classLoader);
                        }
                        try {
                            int n = (int)Math.min(System.currentTimeMillis() - l, Integer.MAX_VALUE);
                            ServletWrapper.this.servletPool.releaseServlet(this.srServlet, n);
                        }
                        finally {
                            this.srServlet = null;
                        }
                        if (this.stimer != null) {
                            this.server.timer.recallTimer(this.stimer);
                            this.stimer = null;
                        }
                        this.srResp.flushStream(true);
                        Object var10_22 = null;
                        if (this.stimer == null) break block67;
                        this.server.timer.recallTimer(this.stimer);
                    }
                    catch (Throwable throwable) {
                        Object var10_25 = null;
                        if (this.stimer != null) {
                            this.server.timer.recallTimer(this.stimer);
                            this.stimer = null;
                        }
                        if (this.srServlet != null) {
                            try {
                                int n = (int)Math.min(System.currentTimeMillis() - l, Integer.MAX_VALUE);
                                ServletWrapper.this.servletPool.releaseServlet(this.srServlet, n);
                            }
                            catch (ServletException servletException) {
                                // empty catch block
                            }
                        }
                        if (object != null) {
                            Object object2 = object;
                            synchronized (object2) {
                                object.notifyAll();
                            }
                        }
                        this.srServlet = null;
                        this.srReq = null;
                        Reply reply = this.srResp.getReply();
                        if (reply != null) {
                            reply.setState(ServletWrapper.ENDED, new Object());
                        }
                        this.srResp = null;
                        throw throwable;
                    }
                    this.stimer = null;
                }
                if (this.srServlet != null) {
                    try {
                        int n = (int)Math.min(System.currentTimeMillis() - l, Integer.MAX_VALUE);
                        ServletWrapper.this.servletPool.releaseServlet(this.srServlet, n);
                    }
                    catch (ServletException servletException) {
                        // empty catch block
                    }
                }
                if (object != null) {
                    Object object3 = object;
                    synchronized (object3) {
                        object.notifyAll();
                    }
                }
                this.srServlet = null;
                this.srReq = null;
                Reply reply = this.srResp.getReply();
                if (reply != null) {
                    reply.setState(ServletWrapper.ENDED, new Object());
                }
                this.srResp = null;
                {
                    break block70;
                    catch (UnavailableException unavailableException) {
                        String string = null;
                        this.srResp.setStatus(503);
                        if (unavailableException.isPermanent()) {
                            string = "<h2>The servlet is permanently unavailable :</h2>Details: <b>" + unavailableException.getMessage() + "</b>";
                            try {
                                this.srResp.sendError(503, string);
                            }
                            catch (IOException iOException) {}
                        } else {
                            int n = unavailableException.getUnavailableSeconds();
                            if (n > 0) {
                                string = "<h2>The servlet is temporarily unavailable :</h2>Delay : " + n + " seconds<br><br>Details: <b>" + unavailableException.getMessage() + "</b>";
                                this.srResp.getReply().setRetryAfter(n);
                                try {
                                    this.srResp.sendError(503, string);
                                }
                                catch (IOException iOException) {}
                            } else {
                                string = "<h2>The servlet is temporarily unavailable :</h2>Details: <b>" + unavailableException.getMessage() + "</b>";
                                try {
                                    this.srResp.sendError(503, string);
                                }
                                catch (IOException iOException) {
                                }
                            }
                        }
                        Object var10_23 = null;
                        if (this.stimer != null) {
                            this.server.timer.recallTimer(this.stimer);
                            this.stimer = null;
                        }
                        if (this.srServlet != null) {
                            try {
                                int n = (int)Math.min(System.currentTimeMillis() - l, Integer.MAX_VALUE);
                                ServletWrapper.this.servletPool.releaseServlet(this.srServlet, n);
                            }
                            catch (ServletException servletException) {
                                // empty catch block
                            }
                        }
                        if (object != null) {
                            Object object4 = object;
                            synchronized (object4) {
                                object.notifyAll();
                            }
                        }
                        this.srServlet = null;
                        this.srReq = null;
                        Reply reply2 = this.srResp.getReply();
                        if (reply2 != null) {
                            reply2.setState(ServletWrapper.ENDED, new Object());
                        }
                        this.srResp = null;
                        break block70;
                    }
                    catch (Exception exception) {
                        if (this.srResp.isStreamObtained()) {
                            try {
                                this.srResp.flushStream(false);
                                OutputStream outputStream = this.srResp.getRawOutputStream();
                                if (outputStream != null) {
                                    OutputStream outputStream2 = outputStream;
                                    synchronized (outputStream2) {
                                        PrintWriter printWriter = new PrintWriter(outputStream);
                                        exception.printStackTrace(printWriter);
                                        printWriter.flush();
                                    }
                                }
                                this.srResp.flushStream(true);
                            }
                            catch (IOException iOException) {}
                        } else {
                            try {
                                this.srResp.sendError(500, "Servlet has thrown exception:" + exception.toString());
                            }
                            catch (IOException iOException) {
                            }
                        }
                        Object var10_24 = null;
                        if (this.stimer != null) {
                            this.server.timer.recallTimer(this.stimer);
                            this.stimer = null;
                        }
                        if (this.srServlet != null) {
                            try {
                                int n = (int)Math.min(System.currentTimeMillis() - l, Integer.MAX_VALUE);
                                ServletWrapper.this.servletPool.releaseServlet(this.srServlet, n);
                            }
                            catch (ServletException servletException) {
                                // empty catch block
                            }
                        }
                        if (object != null) {
                            Object object5 = object;
                            synchronized (object5) {
                                object.notifyAll();
                            }
                        }
                        this.srServlet = null;
                        this.srReq = null;
                        Reply reply3 = this.srResp.getReply();
                        if (reply3 != null) {
                            reply3.setState(ServletWrapper.ENDED, new Object());
                        }
                        this.srResp = null;
                    }
                }
            }
        }

        ServletRunner(Servlet servlet, JigsawHttpServletRequest jigsawHttpServletRequest, JigsawHttpServletResponse jigsawHttpServletResponse) {
            this.srServlet = servlet;
            this.srReq = jigsawHttpServletRequest;
            this.srResp = jigsawHttpServletResponse;
        }
    }

    private class ServletPool
    implements EventHandler {
        private static final int MINWAIT = 5000;
        private int idletime = 5000;
        private long nexttime = -1L;
        private int maximum = 0;
        private int capacity = 0;
        private int usage = 0;
        private final ArrayList pool = new ArrayList();
        private boolean singleThreaded = false;
        private Class loadedClass = null;
        private Object cleanup = null;

        private ServletPool() {
        }

        private final boolean requiresInitialization() {
            return !ServletWrapper.this.inited || this.capacity < 1 || this.loadedClass == null;
        }

        protected Class getLoadedClass() {
            return this.loadedClass;
        }

        protected boolean add(Servlet servlet) {
            if (this.requiresInitialization()) {
                this.singleThreaded = servlet instanceof SingleThreadModel;
                this.maximum = this.singleThreaded ? ServletWrapper.this.getInstanceMax() : 1;
                if (this.maximum > 0) {
                    this.pool.ensureCapacity(this.maximum);
                }
                this.loadedClass = servlet.getClass();
            }
            if (this.maximum < 1 || this.capacity < this.maximum) {
                boolean bl = this.pool.add(servlet);
                this.capacity = this.pool.size();
                return bl;
            }
            return false;
        }

        protected Servlet remove() {
            if (this.capacity > 0 && (this.usage < 1 || this.singleThreaded && this.capacity > this.usage)) {
                Servlet servlet = (Servlet)this.pool.remove(0);
                this.capacity = this.pool.size();
                if (this.capacity < 1) {
                    this.loadedClass = null;
                }
                return servlet;
            }
            return null;
        }

        protected void clean(long l) {
            EventManager eventManager = ((httpd)ServletWrapper.this.getServer()).timer;
            if (this.cleanup != null) {
                eventManager.recallTimer(this.cleanup);
            }
            if (l > 0L) {
                this.cleanup = eventManager.registerTimer(l, this, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void tune(boolean bl) {
            int n = this.capacity >> 1;
            if (bl) {
                if (this.usage > n) {
                    this.nexttime = -1L;
                    if (this.usage >= this.capacity) {
                        ServletWrapper.this.tuneCache(this.capacity);
                    }
                }
            } else if (this.usage < n) {
                long l = System.currentTimeMillis();
                if (this.nexttime < 0L) {
                    this.nexttime = l + (long)this.idletime;
                } else {
                    long l2 = this.nexttime - l;
                    if (l2 <= 0L) {
                        if (this.singleThreaded) {
                            Servlet servlet;
                            for (int i = this.capacity; i > n && (servlet = this.remove()) != null; --i) {
                                ClassLoader classLoader = ServletWrapper.switchContext(servlet);
                                try {
                                    servlet.destroy();
                                    continue;
                                }
                                finally {
                                    ServletWrapper.resetContext(classLoader);
                                }
                            }
                        } else {
                            this.capacity = n;
                        }
                        this.nexttime = -1L;
                        ServletWrapper.this.tuneCache(this.capacity);
                    }
                }
                if (this.usage < 1) {
                    this.clean(this.idletime << 1);
                }
            }
        }

        public synchronized void handleTimerEvent(Object object, long l) {
            this.cleanup = null;
            if (this.usage < 1) {
                this.tune(false);
            }
        }

        protected synchronized Servlet takeServlet() throws ServletException, IOException {
            if (this.requiresInitialization()) {
                throw new ServletException("Accessing servlet without initialization.");
            }
            if (this.singleThreaded) {
                try {
                    while (true) {
                        if (this.usage < this.capacity) {
                            Servlet servlet = (Servlet)this.pool.get(this.usage++);
                            this.tune(true);
                            return servlet;
                        }
                        if (this.maximum < 1 || this.capacity < this.maximum) {
                            if (ServletWrapper.this.launchServlet(this.loadedClass)) {
                                this.notifyAll();
                                Thread.currentThread();
                                Thread.yield();
                                continue;
                            }
                            this.wait();
                            continue;
                        }
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException("Waiting for a free servlet instance interrupted.");
                }
            }
            ++this.usage;
            this.capacity = Math.max(this.capacity, this.usage);
            Servlet servlet = (Servlet)this.pool.get(0);
            this.tune(true);
            return servlet;
        }

        protected synchronized void releaseServlet(Servlet servlet, int n) throws ServletException {
            if (this.requiresInitialization()) {
                throw new ServletException("Releasing servlet without initialization.");
            }
            this.idletime = Math.max(this.idletime, n);
            if (this.usage > 0) {
                if (this.singleThreaded) {
                    this.pool.set(--this.usage, servlet);
                    this.tune(false);
                    this.notifyAll();
                } else {
                    --this.usage;
                    this.tune(false);
                }
            } else {
                throw new ServletException("Incorrect servlet release occurred.");
            }
        }

        protected synchronized Servlet getRepresentative() {
            if (this.requiresInitialization()) {
                return null;
            }
            if (this.singleThreaded) {
                return null;
            }
            return (Servlet)this.pool.get(0);
        }
    }

    protected class TimeoutManager
    implements EventHandler {
        private Object timer = null;
        private httpd server = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleTimerEvent(Object object, long l) {
            TimeoutManager timeoutManager = this;
            synchronized (timeoutManager) {
                this.timer = null;
            }
            ServletWrapper.this.destroyServlet();
        }

        private synchronized void setTimer(long l) {
            if (this.timer != null) {
                this.server.timer.recallTimer(this.timer);
                this.timer = null;
            }
            this.timer = this.server.timer.registerTimer(l, this, null);
        }

        protected void restart() {
            this.start();
        }

        protected void start() {
            long l = ServletWrapper.this.getServletTimeout();
            if (l != -1L) {
                this.setTimer(l);
            }
        }

        protected synchronized void stop() {
            if (this.timer != null) {
                this.server.timer.recallTimer(this.timer);
                this.timer = null;
            }
        }

        TimeoutManager(httpd httpd2) {
            this.server = httpd2;
        }
    }
}

