/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.ssi.commands;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.net.InetAddress;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import org.w3c.jigsaw.forms.URLDecoder;
import org.w3c.jigsaw.forms.URLDecoderException;
import org.w3c.jigsaw.http.Client;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.ssi.SSIFrame;
import org.w3c.jigsaw.ssi.commands.BasicCommandRegistry;
import org.w3c.jigsaw.ssi.commands.Command;
import org.w3c.jigsaw.ssi.commands.ConfigCommand;
import org.w3c.jigsaw.ssi.commands.CookieCommand;
import org.w3c.jigsaw.ssi.commands.CountCommand;
import org.w3c.jigsaw.ssi.commands.CounterCommand;
import org.w3c.jigsaw.ssi.commands.EchoCommand;
import org.w3c.jigsaw.ssi.commands.ElseCommand;
import org.w3c.jigsaw.ssi.commands.EndifCommand;
import org.w3c.jigsaw.ssi.commands.EndloopCommand;
import org.w3c.jigsaw.ssi.commands.ExecCommand;
import org.w3c.jigsaw.ssi.commands.ExitloopCommand;
import org.w3c.jigsaw.ssi.commands.FLastModCommand;
import org.w3c.jigsaw.ssi.commands.FSizeCommand;
import org.w3c.jigsaw.ssi.commands.IfCommand;
import org.w3c.jigsaw.ssi.commands.IncludeCommand;
import org.w3c.jigsaw.ssi.commands.LoopCommand;
import org.w3c.jigsaw.ssi.commands.SampleCommand;
import org.w3c.jigsaw.ssi.jdbc.jdbcCommand;
import org.w3c.jigsaw.ssi.servlets.ServletCommand;
import org.w3c.util.ArrayDictionary;
import org.w3c.www.http.HeaderValue;
import org.w3c.www.mime.MimeType;

public class DefaultCommandRegistry
extends BasicCommandRegistry {
    private static final boolean[] needsEscape = new boolean[256];
    private static MimeType type = MimeType.APPLICATION_X_WWW_FORM_URLENCODED;
    private static Command[] cmds = new Command[]{new ConfigCommand(), new IncludeCommand(), new EchoCommand(), new FSizeCommand(), new FLastModCommand(), new ExecCommand(), new SampleCommand(), new CounterCommand(), new CountCommand(), new CookieCommand(), new jdbcCommand(), new LoopCommand(), new EndloopCommand(), new ExitloopCommand(), new IfCommand(), new ElseCommand(), new EndifCommand(), new ServletCommand()};

    private String unescape(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
        for (int i = 0; i < string.length(); ++i) {
            if (needsEscape[(byte)string.charAt(i)]) {
                stringBuffer.append('\\');
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    public DefaultCommandRegistry() {
        for (int i = 0; i < cmds.length; ++i) {
            this.registerCommand(cmds[i]);
        }
    }

    public Dictionary initVariables(SSIFrame sSIFrame, Request request, Dictionary hashtable) {
        HeaderValue headerValue;
        if ((hashtable = super.initVariables(sSIFrame, request, hashtable)) == null) {
            hashtable = new Hashtable<String, Object>(5);
        }
        DefaultCommandRegistry.safePut(hashtable, "sizefmt", "abbrev");
        DefaultCommandRegistry.safePut(hashtable, "datefmt", "%c");
        ArrayDictionary arrayDictionary = new ArrayDictionary(22);
        DefaultCommandRegistry.safePut(arrayDictionary, "DOCUMENT_NAME", sSIFrame.getFileResource().getFilename());
        DefaultCommandRegistry.safePut(arrayDictionary, "DOCUMENT_URI", request.getURL().toString());
        DefaultCommandRegistry.safePut(arrayDictionary, "QUERY_STRING_UNESCAPED", this.unescape(request.getQueryString()));
        DefaultCommandRegistry.safePut(arrayDictionary, "SERVER_SOFTWARE", sSIFrame.getFileResource().getServer().getSoftware());
        DefaultCommandRegistry.safePut(arrayDictionary, "SERVER_NAME", "jigsaw");
        DefaultCommandRegistry.safePut(arrayDictionary, "GATEWAY_INTERFACE", "org.w3c.jigsaw.ssi.SSIFrame");
        DefaultCommandRegistry.safePut(arrayDictionary, "SERVER_PROTOCOL", request.getVersion());
        DefaultCommandRegistry.safePut(arrayDictionary, "SERVER_PORT", String.valueOf(sSIFrame.getFileResource().getServer().getLocalPort()));
        DefaultCommandRegistry.safePut(arrayDictionary, "REQUEST_METHOD", request.getMethod());
        DefaultCommandRegistry.safePut(arrayDictionary, "PATH_INFO", "");
        DefaultCommandRegistry.safePut(arrayDictionary, "PATH_TRANSLATED", "");
        DefaultCommandRegistry.safePut(arrayDictionary, "SCRIPT_NAME", "org.w3c.jigsaw.ssi.SSIFrame");
        String string = request.getQueryString();
        DefaultCommandRegistry.safePut(arrayDictionary, "QUERY_STRING", string);
        InetAddress inetAddress = request.getClient().getInetAddress();
        DefaultCommandRegistry.safePut(arrayDictionary, "REMOTE_HOST", inetAddress.getHostName());
        String string2 = inetAddress.toString();
        byte[] byArray = inetAddress.getAddress();
        int n = string2.indexOf(47);
        DefaultCommandRegistry.safePut(arrayDictionary, "REMOTE_ADDR", n == -1 ? string2 : string2.substring(n + 1));
        DefaultCommandRegistry.safePut(arrayDictionary, "REMOTE_USER", request.getState("org.w3c.jigsaw.auth.AuthFilter.user"));
        DefaultCommandRegistry.safePut(arrayDictionary, "AUTH_TYPE", request.getState("org.w3c.jigsaw.auth.AuthFilter.type"));
        DefaultCommandRegistry.safePut(arrayDictionary, "REMOTE_IDENT", "");
        DefaultCommandRegistry.safePut(arrayDictionary, "CONTENT_TYPE", request.getContentType());
        int n2 = request.getContentLength();
        if (n2 != -1) {
            arrayDictionary.put("CONTENT_LENGTH", String.valueOf(n2));
        }
        if ((headerValue = request.getHeaderValue(Request.H_ACCEPT)) != null) {
            arrayDictionary.put("HTTP_ACCEPT", headerValue.toExternalForm());
        }
        DefaultCommandRegistry.safePut(arrayDictionary, "HTTP_USER_AGENT", request.getUserAgent());
        DefaultCommandRegistry.safePut(arrayDictionary, "X_LAST_MODIFIED", new Date(sSIFrame.getFileResource().getFile().lastModified()));
        DefaultCommandRegistry.safePut(arrayDictionary, "X_FILE_SIZE", new Long(sSIFrame.getFileResource().getFile().length()));
        ((Dictionary)hashtable).put("ssiVars", arrayDictionary);
        if (((Dictionary)hashtable).get("topSsiVars") == null) {
            ((Dictionary)hashtable).put("topSsiVars", arrayDictionary);
        }
        try {
            Object object;
            InputStream inputStream = null;
            if (request.getMethod().equals("POST") && type.match(request.getContentType()) >= 0) {
                object = request.getClient();
                if (object != null) {
                    ((Client)object).sendContinue();
                }
                inputStream = request.getInputStream();
            } else if (string != null) {
                inputStream = new StringBufferInputStream(string);
            }
            if (inputStream != null) {
                object = new URLDecoder(inputStream);
                ((URLDecoder)object).parse();
                ((Dictionary)hashtable).put("formData", object);
            }
        }
        catch (IOException iOException) {
        }
        catch (URLDecoderException uRLDecoderException) {
            // empty catch block
        }
        return hashtable;
    }

    private static final void safePut(Dictionary dictionary, Object object, Object object2) {
        if (object == null || object2 == null) {
            return;
        }
        dictionary.put(object, object2);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            DefaultCommandRegistry.needsEscape[i] = false;
        }
        DefaultCommandRegistry.needsEscape[92] = true;
        DefaultCommandRegistry.needsEscape[36] = true;
        DefaultCommandRegistry.needsEscape[125] = true;
        DefaultCommandRegistry.needsEscape[123] = true;
        DefaultCommandRegistry.needsEscape[93] = true;
        DefaultCommandRegistry.needsEscape[91] = true;
        DefaultCommandRegistry.needsEscape[41] = true;
        DefaultCommandRegistry.needsEscape[40] = true;
        DefaultCommandRegistry.needsEscape[94] = true;
        DefaultCommandRegistry.needsEscape[62] = true;
        DefaultCommandRegistry.needsEscape[60] = true;
        DefaultCommandRegistry.needsEscape[126] = true;
        DefaultCommandRegistry.needsEscape[63] = true;
        DefaultCommandRegistry.needsEscape[42] = true;
        DefaultCommandRegistry.needsEscape[124] = true;
        DefaultCommandRegistry.needsEscape[34] = true;
        DefaultCommandRegistry.needsEscape[96] = true;
        DefaultCommandRegistry.needsEscape[39] = true;
        DefaultCommandRegistry.needsEscape[59] = true;
        DefaultCommandRegistry.needsEscape[38] = true;
    }
}

