/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.jpeg;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import org.w3c.tools.jpeg.Exif;
import org.w3c.tools.jpeg.Jpeg;
import org.w3c.tools.jpeg.JpegException;

public class JpegHeaders
implements Jpeg {
    protected File jpegfile = null;
    protected InputStream in = null;
    protected Vector vcom = null;
    protected Vector[] vacom = new Vector[16];
    protected String[] comments = null;
    protected byte[][] appcomments = null;
    protected Exif exif = null;
    protected int compression = -1;
    protected int bitsPerPixel = -1;
    protected int height = -1;
    protected int width = -1;
    protected int numComponents = -1;

    public String[] getComments() {
        if (this.comments == null) {
            this.comments = new String[this.vcom.size()];
            this.vcom.copyInto(this.comments);
        }
        return this.comments;
    }

    public String[] getStringAPPComments(int n) {
        if (n < 224 || n > 239) {
            return null;
        }
        int n2 = n - 224;
        int n3 = this.vacom[n2].size();
        if (this.appcomments == null) {
            this.appcomments = new byte[n3][];
            this.vacom[n2].copyInto((Object[])this.appcomments);
        }
        String[] stringArray = new String[n3];
        for (int i = 0; i < n3; ++i) {
            try {
                stringArray[i] = new String(this.appcomments[i], "ISO-8859-1");
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return stringArray;
    }

    public String[] getStringAppComments() {
        return this.getStringAPPComments(236);
    }

    public String getXMP() throws IOException, JpegException {
        String string = "W5M0MpCehiHzreSzNTczkc9d";
        char[] cArray = string.toCharArray();
        String string2 = "<?xpacket";
        char[] cArray2 = string2.toCharArray();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        char[] cArray3 = new char[256];
        String[] stringArray = this.getStringAPPComments(225);
        String string3 = new String();
        boolean bl = false;
        for (n = 0; n < stringArray.length; ++n) {
            if (!bl && stringArray[n].indexOf(string) != -1) {
                bl = true;
                string3 = string3.concat(stringArray[n]);
                continue;
            }
            if (!bl) continue;
            string3 = string3.concat(stringArray[n]);
        }
        StringReader stringReader = new StringReader(string3);
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = this.read2bytes(stringReader);
        if (n4 < 2) {
            throw new JpegException("Erroneous JPEG marker length");
        }
        n4 -= 2;
        stringReader = new StringReader(string3);
        while (n4 > 0 && n3 < cArray.length) {
            cArray3[n2] = (char)stringReader.read();
            if (cArray3[n2] == '\uffffffff') {
                throw new JpegException("Premature EOF in JPEG file");
            }
            n3 = cArray3[n2] == cArray[n3] ? ++n3 : 0;
            n2 = (n2 + 1) % 100;
            --n4;
        }
        if (n3 == cArray.length) {
            char c;
            int n5 = n2;
            while (cArray3[n2 = (n2 + 100 - 1) % 100] != '<' || cArray3[(n2 + 1) % 100] != '?' || cArray3[(n2 + 2) % 100] != 'x' || cArray3[(n2 + 3) % 100] != 'p') {
            }
            while (n2 != n5) {
                stringBuffer.append(cArray3[n2]);
                n2 = (n2 + 1) % 100;
            }
            n3 = 0;
            while (n4 > 0 && n3 < cArray2.length) {
                c = (char)stringReader.read();
                if (c == '\uffffffff') {
                    throw new JpegException("Premature EOF in JPEG file");
                }
                n3 = c == cArray2[n3] ? ++n3 : 0;
                stringBuffer.append(c);
                --n4;
            }
            while (n4 > 0) {
                c = (char)stringReader.read();
                if (c == '\uffffffff') {
                    throw new JpegException("Premature EOF in JPEG file");
                }
                stringBuffer.append(c);
                --n4;
                if (c != '>') continue;
            }
        }
        while (n4 > 0) {
            stringReader.read();
            --n4;
        }
        return stringBuffer.toString();
    }

    public byte[][] getByteArrayAPPComment() {
        return null;
    }

    public String[] getAppComments() {
        return this.getStringAppComments();
    }

    protected int scanHeaders() throws IOException, JpegException {
        this.vcom = new Vector(1);
        this.vacom = new Vector[16];
        for (int i = 0; i < 16; ++i) {
            this.vacom[i] = new Vector(1);
        }
        if (this.firstMarker() != 216) {
            throw new JpegException("Expected SOI marker first");
        }
        block8: while (true) {
            int n = this.nextMarker();
            switch (n) {
                case 192: 
                case 193: 
                case 194: 
                case 195: 
                case 197: 
                case 198: 
                case 199: 
                case 201: 
                case 202: 
                case 203: 
                case 205: 
                case 206: 
                case 207: {
                    this.compression = n;
                    this.readImageInfo();
                    continue block8;
                }
                case 218: {
                    this.skipVariable();
                    this.updateExif();
                    return n;
                }
                case 217: {
                    this.updateExif();
                    return n;
                }
                case 254: {
                    this.vcom.addElement(new String(this.processComment(), "ISO-8859-1"));
                    continue block8;
                }
                case 224: 
                case 225: 
                case 226: 
                case 227: 
                case 228: 
                case 229: 
                case 230: 
                case 231: 
                case 232: 
                case 233: 
                case 234: 
                case 235: 
                case 236: 
                case 237: 
                case 238: 
                case 239: {
                    byte[] byArray = this.processComment();
                    this.vacom[n - 224].addElement(byArray);
                    if (n != 225 || this.exif == null) continue block8;
                    this.exif.parseExif(byArray);
                    continue block8;
                }
            }
            this.skipVariable();
        }
    }

    protected void updateExif() {
        if (this.exif == null) {
            return;
        }
        if (this.compression >= 0) {
            switch (this.compression) {
                case -1: {
                    break;
                }
                case 192: {
                    this.exif.setCompression("Baseline");
                    break;
                }
                case 193: {
                    this.exif.setCompression("Extended sequential");
                    break;
                }
                case 194: {
                    this.exif.setCompression("Progressive");
                    break;
                }
                case 195: {
                    this.exif.setCompression("Lossless");
                    break;
                }
                case 197: {
                    this.exif.setCompression("Differential sequential");
                    break;
                }
                case 198: {
                    this.exif.setCompression("Differential progressive");
                    break;
                }
                case 199: {
                    this.exif.setCompression("Differential lossless");
                    break;
                }
                case 201: {
                    this.exif.setCompression("Extended sequential, arithmetic coding");
                    break;
                }
                case 202: {
                    this.exif.setCompression("Progressive, arithmetic coding");
                    break;
                }
                case 203: {
                    this.exif.setCompression("Lossless, arithmetic coding");
                    break;
                }
                case 205: {
                    this.exif.setCompression("Differential sequential, arithmetic coding");
                    break;
                }
                case 206: {
                    this.exif.setCompression("Differential progressive, arithmetic coding");
                    break;
                }
                case 207: {
                    this.exif.setCompression("Differential lossless, arithmetic coding");
                    break;
                }
                default: {
                    this.exif.setCompression("Unknown" + this.compression);
                }
            }
        }
        if (this.bitsPerPixel >= 0) {
            this.exif.setBPP(this.bitsPerPixel);
        }
        if (this.height >= 0) {
            this.exif.setHeight(this.height);
        }
        if (this.width >= 0) {
            this.exif.setWidth(this.width);
        }
        if (this.numComponents >= 0) {
            this.exif.setNumCC(this.numComponents);
        }
    }

    protected byte[] processComment() throws IOException, JpegException {
        int n = this.read2bytes();
        if (n < 2) {
            throw new JpegException("Erroneous JPEG marker length");
        }
        StringBuffer stringBuffer = new StringBuffer(n -= 2);
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n > 0) {
            int n3 = this.in.read(byArray, n2, n);
            if (n3 < 0) {
                throw new JpegException("EOF while reading jpeg comment");
            }
            n2 += n3;
            n -= n3;
        }
        return byArray;
    }

    protected int read2bytes() throws IOException, JpegException {
        int n = this.in.read();
        if (n == -1) {
            throw new JpegException("Premature EOF in JPEG file");
        }
        int n2 = this.in.read();
        if (n2 == -1) {
            throw new JpegException("Premature EOF in JPEG file");
        }
        return (n << 8) + n2;
    }

    protected int read2bytes(StringReader stringReader) throws IOException, JpegException {
        int n = stringReader.read();
        if (n == -1) {
            throw new JpegException("Premature EOF in JPEG file");
        }
        int n2 = stringReader.read();
        if (n2 == -1) {
            throw new JpegException("Premature EOF in JPEG file");
        }
        return (n << 8) + n2;
    }

    protected void skipVariable() throws IOException, JpegException {
        long l = (long)this.read2bytes() - 2L;
        if (l < 0L) {
            throw new JpegException("Erroneous JPEG marker length");
        }
        while (l > 0L) {
            long l2 = this.in.skip(l);
            if (l2 < 0L) {
                throw new IOException("Error while reading jpeg stream");
            }
            l -= l2;
        }
    }

    protected void readImageInfo() throws IOException, JpegException {
        long l = (long)this.read2bytes() - 2L;
        if (l < 0L) {
            throw new JpegException("Erroneous JPEG marker length");
        }
        this.bitsPerPixel = this.in.read();
        --l;
        this.height = this.read2bytes();
        l -= 2L;
        this.width = this.read2bytes();
        l -= 2L;
        this.numComponents = this.in.read();
        --l;
        while (l > 0L) {
            long l2 = this.in.skip(l);
            if (l2 < 0L) {
                throw new IOException("Error while reading jpeg stream");
            }
            l -= l2;
        }
    }

    protected int firstMarker() throws IOException, JpegException {
        int n = this.in.read();
        int n2 = this.in.read();
        if (n != 255 || n2 != 216) {
            throw new JpegException("Not a JPEG file");
        }
        return n2;
    }

    protected int nextMarker() throws IOException {
        boolean bl = false;
        int n = this.in.read();
        while (n != 255) {
            n = this.in.read();
        }
        while ((n = this.in.read()) == 255) {
        }
        return n;
    }

    public JpegHeaders(File file) throws FileNotFoundException, JpegException, IOException {
        this.parseJpeg(file, null);
    }

    public JpegHeaders(File file, Exif exif) throws FileNotFoundException, JpegException, IOException {
        this.parseJpeg(file, exif);
    }

    public JpegHeaders(InputStream inputStream) throws JpegException, IOException {
        this.in = inputStream;
        this.scanHeaders();
    }

    public JpegHeaders(InputStream inputStream, Exif exif) throws JpegException, IOException {
        this.exif = exif;
        this.in = inputStream;
        this.scanHeaders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseJpeg(File file, Exif exif) throws FileNotFoundException, JpegException, IOException {
        this.exif = exif;
        this.jpegfile = file;
        this.in = new BufferedInputStream(new FileInputStream(file));
        try {
            this.scanHeaders();
        }
        finally {
            try {
                this.in.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void main(String[] stringArray) {
        try {
            JpegHeaders jpegHeaders = new JpegHeaders(new File(stringArray[0]));
            String[] stringArray2 = jpegHeaders.getComments();
            if (stringArray2 != null) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    System.out.println(stringArray2[i]);
                }
            }
            System.out.println(jpegHeaders.getXMP());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

