/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import java.util.Vector;
import org.w3c.www.http.BasicValue;
import org.w3c.www.http.HttpBuffer;
import org.w3c.www.http.HttpParser;
import org.w3c.www.http.HttpWarning;
import org.w3c.www.http.ParseState;

public class HttpWarningList
extends BasicValue {
    HttpWarning[] warnings = null;

    protected void parse() {
        Vector<HttpWarning> vector = new Vector<HttpWarning>(4);
        ParseState parseState = new ParseState(this.roff, this.rlen);
        parseState.spaceIsSep = false;
        while (HttpParser.nextItem(this.raw, parseState) >= 0) {
            vector.addElement(new HttpWarning(this, this.raw, parseState.start, parseState.end));
            parseState.prepare();
        }
        this.warnings = new HttpWarning[vector.size()];
        vector.copyInto(this.warnings);
    }

    protected void updateByteValue() {
        HttpBuffer httpBuffer = new HttpBuffer();
        for (int i = 0; i < this.warnings.length; ++i) {
            if (i > 0) {
                httpBuffer.append(',');
            }
            this.warnings[i].appendValue(httpBuffer);
        }
        this.raw = httpBuffer.getByteCopy();
        this.roff = 0;
        this.rlen = this.raw.length;
    }

    public Object getValue() {
        this.validate();
        return this.warnings;
    }

    public void addWarning(HttpWarning httpWarning) {
        if (this.warnings == null) {
            this.warnings = new HttpWarning[1];
            this.warnings[0] = httpWarning;
        } else {
            int n = this.warnings.length;
            HttpWarning[] httpWarningArray = new HttpWarning[n + 1];
            System.arraycopy(this.warnings, 0, httpWarningArray, 0, n);
            httpWarningArray[n] = httpWarning;
            this.warnings = httpWarningArray;
        }
    }

    HttpWarningList() {
        this.isValid = false;
    }

    HttpWarningList(HttpWarning[] httpWarningArray) {
        this.isValid = true;
        this.warnings = httpWarningArray;
    }

    HttpWarningList(HttpWarning httpWarning) {
        this.isValid = true;
        this.warnings = new HttpWarning[1];
        this.warnings[0] = httpWarning;
    }
}

