/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.cache.push;

import org.w3c.www.protocol.http.HttpException;
import org.w3c.www.protocol.http.HttpManager;
import org.w3c.www.protocol.http.PropRequestFilterException;
import org.w3c.www.protocol.http.Reply;
import org.w3c.www.protocol.http.Request;
import org.w3c.www.protocol.http.cache.ActiveStream;
import org.w3c.www.protocol.http.cache.CacheFilter;
import org.w3c.www.protocol.http.cache.CacheSerializer;
import org.w3c.www.protocol.http.cache.CacheSweeper;
import org.w3c.www.protocol.http.cache.CacheValidator;
import org.w3c.www.protocol.http.cache.CachedResource;
import org.w3c.www.protocol.http.cache.EntityCachedResource;
import org.w3c.www.protocol.http.cache.InvalidCacheException;
import org.w3c.www.protocol.http.cache.push.PushCacheListener;
import org.w3c.www.protocol.http.cache.push.PushCacheManager;
import org.w3c.www.protocol.http.cache.push.PushCacheStore;

public class PushCacheFilter
extends CacheFilter {
    public static final String PORT_NUM_P = "org.w3c.www.protocol.http.cache.push.portnumber";
    public static final int DEFAULT_PORT_NUM = 9876;

    public PushCacheStore getPushCacheStore() {
        return (PushCacheStore)super.getStore();
    }

    public boolean canUseCache(Request request) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reply ingoingFilter(Request request) throws HttpException {
        Cloneable cloneable;
        if (!this.canUseCache(request)) {
            if (this.debug) {
                this.trace(request, "*** Can't use cache");
            }
            if (this.connected) {
                CachedResource cachedResource = null;
                CachedResource cachedResource2 = null;
                try {
                    String string = request.getURL().toExternalForm();
                    cachedResource = this.store.getCachedResourceReference(string);
                    if (cachedResource != null) {
                        cachedResource2 = (EntityCachedResource)cachedResource.lookupResource(request);
                    }
                }
                catch (InvalidCacheException invalidCacheException) {
                    cachedResource2 = null;
                }
                if (cachedResource2 != null) {
                    cachedResource2.setWillRevalidate(true);
                }
                request.setState("org.w3c.www.protocol.http.cache.dont", Boolean.TRUE);
                return null;
            }
            Reply reply = request.makeReply(504);
            reply.setContent("The cache cannot be use for <p><code>" + request.getMethod() + "</code> " + "<strong>" + request.getURL() + "</strong>" + ". <p>It is disconnected.");
            return reply;
        }
        String string = request.getURL().toExternalForm();
        if (this.precache.containsKey(string)) {
            if (this.debug) {
                System.out.println("*** Already downloading: " + string);
            }
            try {
                CachedResource cachedResource = (CachedResource)this.precache.get(string);
                return cachedResource.perform(request);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        CachedResource cachedResource = null;
        try {
            cachedResource = this.store.getCachedResourceReference(string);
        }
        catch (InvalidCacheException invalidCacheException) {
            cachedResource = null;
        }
        try {
            if (PushCacheManager.instance().isPushResource(cachedResource) && (cloneable = (EntityCachedResource)cachedResource.lookupResource(request)) != null) {
                Reply reply = ((EntityCachedResource)cloneable).perform(request);
                return reply;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (request.checkOnlyIfCached() || !this.connected) {
            cloneable = null;
            if (cachedResource != null) {
                cloneable = (EntityCachedResource)cachedResource.lookupResource(request);
            }
            if (cachedResource == null || cloneable == null) {
                if (this.debug) {
                    this.trace(request, "unavailable (disconnected).");
                }
                Reply reply = request.makeReply(504);
                reply.setContent("The cache doesn't have an entry for <p><strong>" + request.getURL() + "</strong>" + ". <p>And it is disconnected.");
                return reply;
            }
            if (this.debug) {
                this.trace(request, this.connected ? " hit - only if cached" : " hit while disconneced");
            }
            if (!this.validator.isValid((CachedResource)cloneable, request)) {
                this.addWarning(request, WARN_STALE);
            }
            this.addWarning(request, WARN_DISCONNECTED);
            Reply reply = ((EntityCachedResource)cloneable).perform(request);
            this.setWarnings(request, reply);
            return reply;
        }
        if (cachedResource != null) {
            if (cachedResource.getLoadState() == 2 || cachedResource.getLoadState() == 4) {
                this.setRequestRevalidation(cachedResource, request);
                return null;
            }
            if (this.validator.isValid(cachedResource, request)) {
                try {
                    this.store.updateResourceGeneration(cachedResource);
                }
                catch (InvalidCacheException invalidCacheException) {
                    // empty catch block
                }
                cloneable = cachedResource.perform(request);
                return cloneable;
            }
            if (this.debug) {
                System.out.println("*** Revalidation asked for " + string);
            }
            this.setRequestRevalidation(cachedResource, request);
            return null;
        }
        while (this.uritable.containsKey(string)) {
            cloneable = this.uritable;
            synchronized (cloneable) {
                try {
                    this.uritable.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.precache.containsKey(string)) {
                if (this.debug) {
                    System.out.println("*** Already downloading: " + string);
                }
                cloneable = (CachedResource)this.precache.get(string);
                return ((CachedResource)cloneable).perform(request);
            }
            this.uritable.put(string, string);
        }
        return null;
    }

    public void initialize(HttpManager httpManager) throws PropRequestFilterException {
        try {
            block6: {
                this.props = httpManager.getProperties();
                this.shared = this.props.getBoolean("org.w3c.www.protocol.http.cache.shared", false);
                this.connected = this.props.getBoolean("org.w3c.www.protocol.http.cache.connected", true);
                this.debug = this.props.getBoolean("org.w3c.www.protocol.http.cache.debug", false);
                String string = this.props.getString("org.w3c.www.protocol.http.cache.validatorclass", "org.w3c.www.protocol.http.cache.SimpleCacheValidator");
                String string2 = this.props.getString("org.w3c.www.protocol.http.cache.sweeperclass", "org.w3c.www.protocol.http.cache.SimpleCacheSweeper");
                String string3 = this.props.getString("org.w3c.www.protocol.http.cache.serializerclass", "org.w3c.www.protocol.http.cache.SimpleCacheSerializer");
                try {
                    Class<?> clazz = Class.forName(string);
                    this.validator = (CacheValidator)clazz.newInstance();
                    this.validator.initialize(this);
                    clazz = Class.forName(string2);
                    this.sweeper = (CacheSweeper)clazz.newInstance();
                    this.sweeper.initialize(this);
                    clazz = Class.forName(string3);
                    this.serializer = (CacheSerializer)clazz.newInstance();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new PropRequestFilterException("Unable to start cache");
                }
                this.store = new PushCacheStore();
                try {
                    this.store.initialize(this);
                }
                catch (InvalidCacheException invalidCacheException) {
                    if (!this.debug) break block6;
                    invalidCacheException.printStackTrace();
                }
            }
            this.sweeper.start();
            ActiveStream.initialize();
            this.props.registerObserver(this);
            httpManager.setFilter(this);
            int n = this.props.getInteger(PORT_NUM_P, 9876);
            PushCacheListener pushCacheListener = new PushCacheListener(n);
            pushCacheListener.start();
            PushCacheManager.instance().registerFilter(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

