/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.webdav.xml;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.www.webdav.xml.DAVMultiStatus;
import org.w3c.www.webdav.xml.DAVNode;
import org.w3c.www.webdav.xml.DAVPropAction;
import org.w3c.www.webdav.xml.DAVPropStat;
import org.w3c.www.webdav.xml.DAVProperties;
import org.w3c.www.webdav.xml.DAVPropertyUpdate;
import org.w3c.www.webdav.xml.DAVResponse;

public class DAVFactory {
    protected static Element createDAVElement(Document document, String string) {
        Element element = document.createElementNS("DAV:", "D:" + string);
        return element;
    }

    public static DAVNode createDAVNode(Element element) {
        return new DAVNode(element);
    }

    public static DAVProperties createProperties(Document document) {
        Element element = DAVFactory.createDAVElement(document, "prop");
        return new DAVProperties(element);
    }

    public static DAVProperties createProperties(Element element) {
        return new DAVProperties(element);
    }

    public static DAVPropStat createPropStat(String string, Document document) {
        Element element = DAVFactory.createDAVElement(document, "propstat");
        DAVPropStat dAVPropStat = new DAVPropStat(element);
        dAVPropStat.setStatus(string);
        return dAVPropStat;
    }

    public static DAVPropStat createPropStat(String string, String string2, Document document) {
        Element element = DAVFactory.createDAVElement(document, "propstat");
        DAVPropStat dAVPropStat = new DAVPropStat(element);
        dAVPropStat.setStatus(string);
        DAVProperties dAVProperties = DAVFactory.createProperties(document);
        dAVProperties.addProperty(string2);
        dAVPropStat.addDAVNode(dAVProperties);
        return dAVPropStat;
    }

    public static DAVPropStat createPropStatNS(String string, Node node, Document document) {
        Element element = DAVFactory.createDAVElement(document, "propstat");
        DAVPropStat dAVPropStat = new DAVPropStat(element);
        dAVPropStat.setStatus(string);
        DAVProperties dAVProperties = DAVFactory.createProperties(document);
        dAVProperties.addNodeNS(node);
        dAVPropStat.addDAVNode(dAVProperties);
        return dAVPropStat;
    }

    public static DAVPropStat createPropStat(String string, DAVProperties dAVProperties, Document document) {
        Element element = DAVFactory.createDAVElement(document, "propstat");
        DAVPropStat dAVPropStat = new DAVPropStat(element);
        dAVPropStat.setStatus(string);
        dAVPropStat.addDAVNode(dAVProperties);
        return dAVPropStat;
    }

    public static DAVResponse createResponse(String string, Document document) {
        Element element = DAVFactory.createDAVElement(document, "response");
        DAVResponse dAVResponse = new DAVResponse(element);
        dAVResponse.addDAVNode("href", string);
        return dAVResponse;
    }

    public static DAVResponse createResponse(String string, String string2, Document document) {
        Element element = DAVFactory.createDAVElement(document, "response");
        DAVResponse dAVResponse = new DAVResponse(element);
        dAVResponse.addDAVNode("href", string);
        dAVResponse.addDAVNode("status", string2);
        return dAVResponse;
    }

    public static DAVResponse createResponse(String string, String string2, String string3, Document document) {
        Element element = DAVFactory.createDAVElement(document, "response");
        DAVResponse dAVResponse = new DAVResponse(element);
        dAVResponse.addDAVNode("href", string);
        dAVResponse.addDAVNode("status", string2);
        dAVResponse.addDAVNode("responsedescription", string3);
        return dAVResponse;
    }

    public static DAVResponse createPropStatResponse(String string, String string2, DAVProperties dAVProperties, Document document) {
        DAVPropStat dAVPropStat = DAVFactory.createPropStat(string2, dAVProperties, document);
        Element element = DAVFactory.createDAVElement(document, "response");
        DAVResponse dAVResponse = new DAVResponse(element);
        dAVResponse.addDAVNode("href", string);
        dAVResponse.addDAVNode(dAVPropStat);
        return dAVResponse;
    }

    public static DAVPropAction createPropAction(int n, DAVProperties dAVProperties, Document document) {
        Element element = null;
        element = n == 1 ? DAVFactory.createDAVElement(document, "set") : DAVFactory.createDAVElement(document, "remove");
        element.appendChild(dAVProperties.getNode());
        return new DAVPropAction(element);
    }

    public static DAVPropertyUpdate createPropertyUpdate(DAVPropAction[] dAVPropActionArray, Document document) {
        Element element = DAVFactory.createDAVElement(document, "propertyupdate");
        DAVPropertyUpdate dAVPropertyUpdate = new DAVPropertyUpdate(element);
        dAVPropertyUpdate.setActions(dAVPropActionArray);
        return dAVPropertyUpdate;
    }

    public static DAVPropertyUpdate createPropertyUpdate(DAVPropAction dAVPropAction, Document document) {
        Element element = DAVFactory.createDAVElement(document, "propertyupdate");
        DAVPropertyUpdate dAVPropertyUpdate = new DAVPropertyUpdate(element);
        DAVPropAction[] dAVPropActionArray = new DAVPropAction[]{dAVPropAction};
        dAVPropertyUpdate.setActions(dAVPropActionArray);
        return dAVPropertyUpdate;
    }

    public static DAVPropertyUpdate createPropertyUpdate(Element element, DAVPropAction dAVPropAction) {
        DAVPropertyUpdate dAVPropertyUpdate = new DAVPropertyUpdate(element);
        DAVPropAction[] dAVPropActionArray = new DAVPropAction[]{dAVPropAction};
        dAVPropertyUpdate.setActions(dAVPropActionArray);
        return dAVPropertyUpdate;
    }

    public static DAVMultiStatus createMultiStatus(Element element) {
        return new DAVMultiStatus(element);
    }
}

