/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane;

import com.hbworks.dirpane.FileSystem;
import com.hbworks.dirpane.resources.LocalizedStringTable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;

public abstract class BasicFileSystem
extends FileSystem {
    public static FileSystem windowsFileSystem = null;
    public static FileSystem unixFileSystem = null;
    public static FileSystem macFileSystem = null;
    public static FileSystem genericFileSystem = null;
    private Class fileSubType = class$java$io$File == null ? (class$java$io$File = BasicFileSystem.class$("java.io.File")) : class$java$io$File;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$String;

    public static FileSystem getFileSystem() {
        if (File.separatorChar == '\\') {
            if (windowsFileSystem == null) {
                windowsFileSystem = new WindowsFileSystem();
            }
            return windowsFileSystem;
        }
        if (File.separatorChar == '/') {
            if (unixFileSystem == null) {
                unixFileSystem = new UnixFileSystem();
            }
            return unixFileSystem;
        }
        if (File.separatorChar == ':') {
            if (macFileSystem == null) {
                macFileSystem = new MacFileSystem();
            }
            return macFileSystem;
        }
        if (genericFileSystem == null) {
            genericFileSystem = new GenericFileSystem();
        }
        return genericFileSystem;
    }

    public void setFileSubType(Class type) {
        if (!this.isFileSubType(type)) {
            return;
        }
        this.fileSubType = type;
    }

    public Class getFileSubType() {
        return this.fileSubType;
    }

    public File createFileObject(String path) {
        File file;
        Constructor constructor = null;
        Class[] param = new Class[]{class$java$lang$String == null ? (class$java$lang$String = BasicFileSystem.class$("java.lang.String")) : class$java$lang$String};
        try {
            constructor = this.getFileSubType().getConstructor(param);
        }
        catch (NoSuchMethodException e) {
            return this.createDefaultFileObject(path);
        }
        try {
            Object[] args = new String[]{path};
            file = (File)constructor.newInstance(args);
        }
        catch (Exception e) {
            file = new File(path);
        }
        return file;
    }

    public File createFileObject(String path, String filename) {
        File file;
        Constructor constructor = null;
        Class[] param = new Class[]{class$java$lang$String == null ? (class$java$lang$String = BasicFileSystem.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = BasicFileSystem.class$("java.lang.String")) : class$java$lang$String};
        try {
            constructor = this.getFileSubType().getConstructor(param);
        }
        catch (NoSuchMethodException e) {
            return this.createDefaultFileObject(path, filename);
        }
        try {
            Object[] args = new String[]{path};
            file = (File)constructor.newInstance(args);
        }
        catch (Exception e) {
            file = new File(path, filename);
        }
        return file;
    }

    public File createFileObject(File dir, String filename) {
        File file;
        Constructor constructor1 = null;
        Constructor constructor2 = null;
        Class[] param1 = new Class[]{class$java$lang$String == null ? (class$java$lang$String = BasicFileSystem.class$("java.lang.String")) : class$java$lang$String};
        try {
            constructor1 = this.getFileSubType().getConstructor(param1);
        }
        catch (NoSuchMethodException e) {
            return this.createDefaultFileObject(dir, filename);
        }
        Class[] param2 = new Class[]{class$java$io$File == null ? (class$java$io$File = BasicFileSystem.class$("java.io.File")) : class$java$io$File, class$java$lang$String == null ? (class$java$lang$String = BasicFileSystem.class$("java.lang.String")) : class$java$lang$String};
        try {
            constructor2 = this.getFileSubType().getConstructor(param2);
        }
        catch (NoSuchMethodException e) {
            return this.createDefaultFileObject(dir, filename);
        }
        if (dir == null) {
            File file2;
            try {
                Object[] args = new String[]{filename};
                file2 = (File)constructor1.newInstance(args);
            }
            catch (Exception e) {
                file2 = new File(filename);
            }
            return file2;
        }
        try {
            Object[] args = new Object[]{dir, filename};
            file = (File)constructor2.newInstance(args);
        }
        catch (Exception e) {
            file = new File(dir, filename);
        }
        return file;
    }

    public File createDefaultFileObject(String path) {
        return new File(path);
    }

    public File createDefaultFileObject(String path, String filename) {
        return new File(path, filename);
    }

    public File createDefaultFileObject(File dir, String path) {
        if (dir == null) {
            return new File(path);
        }
        return new File(dir, path);
    }

    public File getHomeDirectory() {
        return this.createFileObject(System.getProperty("user.home"));
    }

    public File getWorkingDirectory() {
        return this.createFileObject(System.getProperty("user.dir"));
    }

    public File getParentDirectory(File dir) {
        String parentFilename;
        if (dir != null && (parentFilename = dir.getParent()) != null) {
            return this.createFileObject(parentFilename);
        }
        return null;
    }

    public File loadIntoFileSystem(Object obj, File parentDir, boolean overwritePermissionGranted) throws IOException {
        if (overwritePermissionGranted) {
            return null;
        }
        if (this.doesFileExist((File)obj)) {
            return null;
        }
        return null;
    }

    public Object retrieveFromFileSystem(File holder) throws IOException {
        return null;
    }

    public File[] getFiles(File dir, boolean useFileHiding) {
        Vector<File> files = new Vector<File>();
        String[] names = dir.list();
        int nameCount = names == null ? 0 : names.length;
        int i = 0;
        while (i < nameCount) {
            File f = this.createFileObject(dir, names[i]);
            if (useFileHiding) {
                if (!this.isHiddenFile(f)) {
                    files.addElement(f);
                }
            } else {
                files.addElement(f);
            }
            ++i;
        }
        Object[] fileArray = new File[files.size()];
        files.copyInto(fileArray);
        return fileArray;
    }

    public boolean doesFileExist(File file) {
        return file.exists();
    }

    public boolean isReadOnly(File file) {
        return !file.canWrite();
    }

    public boolean isProtected(File file) {
        return !file.canRead();
    }

    public boolean isTraversable(File file) {
        return file.isDirectory();
    }

    public boolean isRegularFile(File file) {
        return file.isFile();
    }

    public boolean isAbsolute(File file) {
        return file.isAbsolute();
    }

    public long getLength(File file) {
        return file.length();
    }

    public String getAbsolutePath(File file) {
        return file.getAbsolutePath();
    }

    public String getCanonicalPath(File file) throws IOException {
        return file.getCanonicalPath();
    }

    public long getLastModifiedTime(File file) {
        return file.lastModified();
    }

    public boolean createDirectory(File file) {
        return file.mkdir();
    }

    public boolean createDirectories(File file) {
        return file.mkdirs();
    }

    public boolean deleteFile(File file) {
        return file.delete();
    }

    public boolean renameFile(File file, File dest) {
        return file.renameTo(dest);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class WindowsDrive
    extends File {
        private File winroot;
        private String drivename;

        protected WindowsDrive(File root, String drive) {
            super(drive);
            this.drivename = drive;
            this.winroot = root;
        }

        public boolean canRead() {
            return true;
        }

        public boolean canWrite() {
            return true;
        }

        public boolean delete() {
            return false;
        }

        public boolean exists() {
            return true;
        }

        public String getAbsolutePath() {
            return this.drivename;
        }

        public String getCanonicalPath() throws IOException {
            throw new IOException();
        }

        public String getName() {
            return this.drivename;
        }

        public String getParent() {
            return this.winroot.getPath();
        }

        public String getPath() {
            return this.drivename;
        }

        public boolean isAbsolute() {
            return true;
        }

        public boolean isDirectory() {
            return true;
        }

        public boolean isFile() {
            return false;
        }

        public long lastModified() {
            return 0L;
        }

        public long length() {
            return 0L;
        }

        public boolean renameTo() {
            return false;
        }
    }

    public static class WindowsRoot
    extends File {
        private static final Object[] noArgs = new Object[0];
        private static final Class[] noArgTypes = new Class[0];
        private static Method listRootsMethod = null;
        private static boolean listRootsMethodChecked = false;
        static /* synthetic */ Class class$java$io$File;

        protected WindowsRoot() {
            super("");
        }

        public boolean canRead() {
            return true;
        }

        public boolean canWrite() {
            return false;
        }

        public boolean delete() {
            return false;
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        public boolean exists() {
            return true;
        }

        public String getAbsolutePath() {
            return this.getName();
        }

        public String getCanonicalPath() throws IOException {
            throw new IOException();
        }

        public String getName() {
            String hostName = LocalizedStringTable.getString("WindowsRoot.hostName");
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            return hostName;
        }

        public String getParent() {
            return null;
        }

        public String getPath() {
            return this.getName();
        }

        public boolean isAbsolute() {
            return true;
        }

        public boolean isDirectory() {
            return true;
        }

        public boolean isFile() {
            return false;
        }

        public long lastModified() {
            return 0L;
        }

        public long length() {
            return 0L;
        }

        public String[] list() {
            return this.list(null);
        }

        public String[] list(FilenameFilter filter) {
            if (!listRootsMethodChecked) {
                try {
                    Object var4_2;
                    try {
                        listRootsMethod = (class$java$io$File == null ? (class$java$io$File = WindowsRoot.class$("java.io.File")) : class$java$io$File).getMethod("listRoots", noArgTypes);
                    }
                    catch (NoSuchMethodException e) {
                        var4_2 = null;
                        listRootsMethodChecked = true;
                    }
                    var4_2 = null;
                    listRootsMethodChecked = true;
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    listRootsMethodChecked = true;
                    throw throwable;
                }
            }
            if (listRootsMethod != null) {
                SecurityManager sm = System.getSecurityManager();
                System.setSecurityManager(null);
                try {
                    File[] roots = (File[])listRootsMethod.invoke(null, noArgs);
                    String[] drives = new String[roots.length];
                    int idx = 0;
                    while (idx < roots.length) {
                        drives[idx] = roots[idx].toString();
                        ++idx;
                    }
                    return drives;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.setSecurityManager(sm);
                }
            } else {
                Vector<String> driveVector = new Vector<String>();
                String floppy = "A:\\";
                driveVector.addElement(floppy);
                char c = 'C';
                while (c <= 'Z') {
                    char[] drv = new char[]{c, ':', '\\'};
                    String drvName = new String(drv);
                    File drvFile = new File(drvName);
                    if (drvFile != null && drvFile.exists()) {
                        driveVector.addElement(drvName);
                    }
                    c = (char)(c + 1);
                }
                Object[] drives = new String[driveVector.size()];
                driveVector.copyInto(drives);
                return drives;
            }
            return null;
        }

        public boolean mkdir() {
            return false;
        }

        public boolean mkdirs() {
            return false;
        }

        public boolean renameTo() {
            return false;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class GenericFileSystem
    extends BasicFileSystem {
        public String getFileSeparator() {
            return "/";
        }

        public boolean isFileSystemRoot(File f) {
            if (!f.isAbsolute()) {
                return false;
            }
            String parentPath = f.getParent();
            if (parentPath == null) {
                return true;
            }
            File parent = this.createFileObject(parentPath);
            return parent.equals(f);
        }

        public boolean isHiddenFile(File f) {
            return false;
        }

        public int getDirectoryType(File dir) {
            return 3;
        }

        public File createFileObject(String path) {
            return super.createFileObject(path);
        }

        public File getFileSystemRoot() {
            File home;
            File root = home = this.createFileObject(System.getProperty("user.home"));
            String parentPath = home.getParent();
            while (parentPath != null) {
                root = this.createFileObject(parentPath);
                parentPath = root.getParent();
            }
            return root;
        }
    }

    public static class WindowsFileSystem
    extends BasicFileSystem {
        Vector drivenames = new Vector();
        String floppy = "A:\\";
        File winroot;

        public WindowsFileSystem() {
            char c = 'C';
            while (c <= 'Z') {
                char[] device = new char[]{c, ':', '\\'};
                String devName = new String(device);
                this.drivenames.addElement(devName);
                c = (char)(c + 1);
            }
            this.winroot = new WindowsRoot();
        }

        public String getFileSeparator() {
            return "\\";
        }

        public boolean isFileSystemRoot(File f) {
            return f == this.winroot;
        }

        public File getFileSystemRoot() {
            return this.winroot;
        }

        public boolean isHiddenFile(File f) {
            return false;
        }

        public int getDirectoryType(File dir) {
            if (dir == this.winroot) {
                return 0;
            }
            if (dir.getName().toUpperCase().equals(this.floppy)) {
                return 1;
            }
            if (this.drivenames.contains(dir.getName().toUpperCase())) {
                return 2;
            }
            return 3;
        }

        public File createFileObject(File dir, String filename) {
            return super.createFileObject(dir, filename);
        }

        public File createFileObject(String path) {
            if (path == null || path.toLowerCase().equals(this.winroot.getName().toLowerCase())) {
                return this.winroot;
            }
            if (path.toUpperCase().equals(this.floppy) || this.drivenames.contains(path.toUpperCase())) {
                return this.createWindowsDrive(path);
            }
            return super.createFileObject(path);
        }

        public File[] getFiles(File dir, boolean useFileHiding) {
            Vector<File> files = new Vector<File>();
            String[] names = dir.list();
            int nameCount = names == null ? 0 : names.length;
            int i = 0;
            while (i < nameCount) {
                File f = dir == this.winroot ? this.createWindowsDrive(names[i]) : this.createFileObject(dir, names[i]);
                if (useFileHiding) {
                    if (!this.isHiddenFile(f)) {
                        files.addElement(f);
                    }
                } else {
                    files.addElement(f);
                }
                ++i;
            }
            Object[] fileArray = new File[files.size()];
            files.copyInto(fileArray);
            return fileArray;
        }

        public File createWindowsDrive(String drive) {
            return new WindowsDrive(this.winroot, drive);
        }

        public File getParentDirectory(File dir) {
            if (dir != null && dir != this.winroot) {
                if (dir instanceof WindowsDrive) {
                    return this.winroot;
                }
                String parentFilename = dir.getParent();
                if (parentFilename != null) {
                    return this.createFileObject(parentFilename);
                }
            }
            return null;
        }
    }

    public static class MacFileSystem
    extends BasicFileSystem {
        public String getFileSeparator() {
            return ":";
        }

        public boolean isFileSystemRoot(File f) {
            String path = f.getAbsolutePath();
            return path.length() == 1 && path.charAt(0) == '/';
        }

        public File getFileSystemRoot() {
            File root = this.createFileObject("/");
            if (super.doesFileExist(root) && root.isDirectory()) {
                return root;
            }
            return null;
        }

        public boolean isHiddenFile(File f) {
            return false;
        }

        public File createFileObject(String path) {
            return super.createFileObject(path);
        }

        public int getDirectoryType(File dir) {
            if (this.isFileSystemRoot(dir)) {
                return 0;
            }
            if (this.isFileSystemRoot(this.getParentDirectory(dir))) {
                return 2;
            }
            return 3;
        }

        public File getParentDirectory(File dir) {
            return super.getParentDirectory(dir);
        }
    }

    public static class UnixFileSystem
    extends BasicFileSystem {
        public String getFileSeparator() {
            return "/";
        }

        public boolean isFileSystemRoot(File f) {
            String path = f.getAbsolutePath();
            return path.length() == 1 && path.charAt(0) == '/';
        }

        public File getFileSystemRoot() {
            File root = this.createFileObject("/");
            if (super.doesFileExist(root) && root.isDirectory()) {
                return root;
            }
            return null;
        }

        public boolean isHiddenFile(File f) {
            if (f != null) {
                String filename = f.getName();
                return filename.charAt(0) == '.';
            }
            return false;
        }

        public File createFileObject(String path) {
            return super.createFileObject(path);
        }

        public int getDirectoryType(File dir) {
            return 3;
        }
    }
}

