/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane;

import com.hbworks.dirpane.BasicFileSystem;
import com.hbworks.dirpane.FileSystem;
import com.hbworks.dirpane.FileType;
import com.hbworks.dirpane.TableDirectoryModel;
import com.hbworks.dirpane.TableDirectoryPane;
import com.hbworks.dirpane.resources.LocalizedStringTable;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Date;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class DefaultTableDirectoryModel
extends TableDirectoryModel {
    protected transient int totalAccepted;
    protected transient LoadDirsThread loadDirsThread = null;
    protected transient LoadFilesThread loadFilesThread = null;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$com$hbworks$dirpane$FileType;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$io$File;

    public DefaultTableDirectoryModel(TableDirectoryPane pane, Class[] columnTypes, String[] columnNames) {
        super(pane, columnTypes, columnNames);
        this.validateRowsCache(this.getCurrentDirectory());
    }

    protected FileSystem createFileSystem() {
        return BasicFileSystem.getFileSystem();
    }

    protected String[] createDefaultColumnNames(Vector v) {
        String file_columnname = LocalizedStringTable.getString("DefaultTableDirectoryModel.file_columnname");
        String length_columnname = LocalizedStringTable.getString("DefaultTableDirectoryModel.length_columnname");
        String type_columnname = LocalizedStringTable.getString("DefaultTableDirectoryModel.type_columnname");
        String modified_columnname = LocalizedStringTable.getString("DefaultTableDirectoryModel.modified_columnname");
        String readonly_columnname = LocalizedStringTable.getString("DefaultTableDirectoryModel.readonly_columnname");
        String[] array = new String[v.size()];
        array[0] = file_columnname;
        int i = 1;
        while (i < v.size()) {
            int j;
            String classname = ((Class)v.elementAt(i)).getName();
            String id = classname.substring((j = classname.lastIndexOf(".")) + 1);
            array[i] = id.equals("Long") ? length_columnname : (id.equals("FileType") ? type_columnname : (id.equals("Date") ? modified_columnname : (id.equals("Boolean") ? readonly_columnname : id)));
            ++i;
        }
        return array;
    }

    public void propertyChange(PropertyChangeEvent e) {
        Object oldvalue = e.getOldValue();
        Object newvalue = e.getNewValue();
        String name = e.getPropertyName();
        if (name == "fileViewChanged" || name == "fileSorterChanged" || name == "fileHidingChanged" || name == "fileFilterChanged" || name == "fileSelectionModeChanged") {
            this.directoryPane.refresh();
        } else if (name == "directoryChanged" || name == "syncSlaveDirectory") {
            File newDir = (File)newvalue;
            this.directoryPane.refresh(newDir);
        }
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        File oldFile = this.getFileAtRow(rowIndex);
        File newFile = (File)aValue;
        Object[] newrow = this.createRowForFile(newFile);
        this.replaceRow(newrow, rowIndex);
    }

    public void fileAdded(File f) {
        File parent = this.getParentDirectory(f);
        if (!parent.equals(this.getCurrentDirectory())) {
            return;
        }
        Object[] row = this.createRowForFile(f);
        this.addRow(row);
        this.directoryPane.resetAutoRefresher(parent);
    }

    public void fileDeleted(File delFile) {
        Object[] row = this.getRowForFile(delFile);
        if (row == null) {
            return;
        }
        this.removeRow(row);
        this.directoryPane.removeFromAutoRefresher(delFile);
        this.directoryPane.resetAutoRefresher(this.getParentDirectory(delFile));
    }

    public void fileRenamed(File oldFile, File newFile) {
        Object[] oldrow = this.getRowForFile(oldFile);
        if (oldrow == null) {
            return;
        }
        int index = this.getRowIndexOfFile(oldFile);
        this.setValueAt(newFile, index, 0);
        this.directoryPane.removeFromAutoRefresher(oldFile);
        this.directoryPane.addToAutoRefresher(newFile);
        this.directoryPane.resetAutoRefresher(this.getParentDirectory(newFile));
    }

    protected boolean deleteDirectory(File dir) {
        boolean wiped = true;
        File[] contents = this.getFiles(dir, this.directoryPane.isFileHidingEnabled());
        int i = 0;
        while (i < contents.length) {
            File f = contents[i];
            if (this.isTraversable(f)) {
                this.deleteDirectory(f);
            } else {
                wiped &= this.directoryPane.deleteFile(f);
            }
            ++i;
        }
        if (wiped &= this.deleteFile(dir)) {
            this.fileDeleted(dir);
        }
        return wiped;
    }

    protected void setCurrentDirectory(File newDir) {
        if (newDir == null) {
            super.setCurrentDirectory(this.getWorkingDirectory());
        } else {
            if (!this.directoryCanBeCurrent(newDir)) {
                if (this.currentDirectory == null) {
                    super.setCurrentDirectory(this.getWorkingDirectory());
                }
                return;
            }
            File prev = null;
            while (!this.isTraversable(newDir) && prev != newDir && !this.isFileSystemRoot(newDir)) {
                prev = newDir;
                newDir = this.getParentDirectory(newDir);
            }
            super.setCurrentDirectory(newDir);
        }
    }

    protected Object[] createRowForFile(File file) {
        Long size = new Long(this.getLength(file));
        String ext = null;
        String t = file.getName();
        if (t != null) {
            int dot = t.lastIndexOf(".");
            ext = dot != -1 ? t.substring(dot + 1, t.length()) : t;
        }
        this.directoryPane.putTypeDescription(file, ext);
        FileType type = new FileType(this.directoryPane.getTypeDescription(file), this.directoryPane.getTypeIcon(file));
        type.setHidden(this.isHiddenFile(file));
        type.setTraversable(this.isTraversable(file));
        type.setReadOnly(this.isReadOnly(file));
        String path = file.getPath();
        Date date = new Date(this.getLastModifiedTime(file));
        Boolean readonly = new Boolean(this.isReadOnly(file));
        int s = this.getColumnTypesVector().size();
        Object[] row = new Object[s];
        row[0] = file;
        int i1 = this.getColumnTypesVector().indexOf(class$java$lang$Long == null ? (class$java$lang$Long = DefaultTableDirectoryModel.class$("java.lang.Long")) : class$java$lang$Long);
        int i2 = this.getColumnTypesVector().indexOf(class$com$hbworks$dirpane$FileType == null ? (class$com$hbworks$dirpane$FileType = DefaultTableDirectoryModel.class$("com.hbworks.dirpane.FileType")) : class$com$hbworks$dirpane$FileType);
        int i3 = this.getColumnTypesVector().indexOf(class$java$util$Date == null ? (class$java$util$Date = DefaultTableDirectoryModel.class$("java.util.Date")) : class$java$util$Date);
        int i4 = this.getColumnTypesVector().indexOf(class$java$lang$String == null ? (class$java$lang$String = DefaultTableDirectoryModel.class$("java.lang.String")) : class$java$lang$String);
        int i5 = this.getColumnTypesVector().indexOf(class$java$lang$Boolean == null ? (class$java$lang$Boolean = DefaultTableDirectoryModel.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        if (i1 > 0 && i1 < s) {
            row[i1] = size;
        }
        if (i2 > 0 && i2 < s) {
            row[i2] = type;
        }
        if (i3 > 0 && i3 < s) {
            row[i3] = date;
        }
        if (i4 > 0 && i4 < s) {
            row[i4] = path;
        }
        if (i5 > 0 && i5 < s) {
            row[i5] = readonly;
        }
        return row;
    }

    protected void validateRowsCache(final File curDir) {
        if (curDir == null) {
            this.invalidateRowsCache();
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (DefaultTableDirectoryModel.this.loadDirsThread != null) {
                    DefaultTableDirectoryModel.this.loadDirsThread.interrupt();
                }
                if (DefaultTableDirectoryModel.this.loadFilesThread != null) {
                    DefaultTableDirectoryModel.this.loadFilesThread.interrupt();
                }
                DefaultTableDirectoryModel.this.directoryRowsCache = new Vector();
                DefaultTableDirectoryModel.this.fileRowsCache = new Vector();
                DefaultTableDirectoryModel.this.loadDirsThread = new LoadDirsThread(curDir);
                DefaultTableDirectoryModel.this.loadDirsThread.start();
            }
        });
    }

    public int compareRowsByColumn(Object[] row1, Object[] row2, int column) {
        Object v2;
        String s2;
        Class type = this.getColumnClass(column);
        Object o1 = row1[column];
        Object o2 = row2[column];
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (type == (class$java$io$File == null ? (class$java$io$File = DefaultTableDirectoryModel.class$("java.io.File")) : class$java$io$File)) {
            String n2;
            File f1 = (File)row1[column];
            File f2 = (File)row2[column];
            String n1 = this.directoryPane.getName(f1).toLowerCase();
            int result = n1.compareTo(n2 = this.directoryPane.getName(f2).toLowerCase());
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
        if (type == (class$java$lang$Long == null ? (class$java$lang$Long = DefaultTableDirectoryModel.class$("java.lang.Long")) : class$java$lang$Long)) {
            Long n2;
            long l2;
            Long n1 = (Long)row1[column];
            long l1 = n1;
            if (l1 < (l2 = (n2 = (Long)row2[column]).longValue())) {
                return -1;
            }
            if (l1 > l2) {
                return 1;
            }
            return 0;
        }
        if (type == (class$com$hbworks$dirpane$FileType == null ? (class$com$hbworks$dirpane$FileType = DefaultTableDirectoryModel.class$("com.hbworks.dirpane.FileType")) : class$com$hbworks$dirpane$FileType)) {
            String s22;
            FileType t1 = (FileType)row1[column];
            FileType t2 = (FileType)row2[column];
            String s1 = t1.getFileTypeDescription().toLowerCase();
            int result = s1.compareTo(s22 = t2.getFileTypeDescription().toLowerCase());
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
        if (type == (class$java$util$Date == null ? (class$java$util$Date = DefaultTableDirectoryModel.class$("java.util.Date")) : class$java$util$Date)) {
            Date d1 = (Date)row1[column];
            Date d2 = (Date)row2[column];
            if (d1.before(d2)) {
                return -1;
            }
            if (d1.after(d2)) {
                return 1;
            }
            return 0;
        }
        if (type == (class$java$lang$String == null ? (class$java$lang$String = DefaultTableDirectoryModel.class$("java.lang.String")) : class$java$lang$String)) {
            String s1 = (String)row1[column];
            String s23 = (String)row2[column];
            int result = s1.compareTo(s23);
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
        if (type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = DefaultTableDirectoryModel.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            Boolean bool2;
            boolean b2;
            Boolean bool1 = (Boolean)row1[column];
            boolean b1 = bool1;
            if (b1 == (b2 = (bool2 = (Boolean)row2[column]).booleanValue())) {
                return 0;
            }
            if (b1) {
                return 1;
            }
            return -1;
        }
        Object v1 = row1[column];
        String s1 = v1.toString();
        int result = s1.compareTo(s2 = (v2 = row2[column]).toString());
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return 1;
        }
        return 0;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.fileSystem = BasicFileSystem.getFileSystem();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DoChangeFileContents
    implements Runnable {
        private Vector rows;
        private boolean doFire = true;
        private Object lock = new Object();

        public DoChangeFileContents(Vector rows) {
            this.rows = rows;
        }

        synchronized void cancel() {
            Object object = this.lock;
            synchronized (object) {
                this.doFire = false;
            }
        }

        public void run() {
            if (DefaultTableDirectoryModel.this.directoryRowsCache == null || DefaultTableDirectoryModel.this.fileRowsCache == null) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                int count = this.rows.size();
                int firstRow = DefaultTableDirectoryModel.this.directoryRowsCache.size() + DefaultTableDirectoryModel.this.fileRowsCache.size();
                int lastRow = firstRow + count - 1;
                if (this.doFire) {
                    int i = 0;
                    while (i < count) {
                        Object[] row = (Object[])this.rows.elementAt(i);
                        DefaultTableDirectoryModel.this.fileRowsCache.addElement(row);
                        ++i;
                    }
                    DefaultTableDirectoryModel.this.fireTableRowsInserted(firstRow, lastRow);
                }
            }
            if (DefaultTableDirectoryModel.this.directoryRowsCache.size() + DefaultTableDirectoryModel.this.fileRowsCache.size() == DefaultTableDirectoryModel.this.totalAccepted) {
                DefaultTableDirectoryModel.this.fireLoadingEnded(DefaultTableDirectoryModel.this.currentDirectory);
            }
        }
    }

    private class DoChangeDirContents
    implements Runnable {
        private Vector rows;
        private boolean doFire = true;
        private Object lock = new Object();

        public DoChangeDirContents(Vector rows) {
            this.rows = rows;
        }

        synchronized void cancel() {
            Object object = this.lock;
            synchronized (object) {
                this.doFire = false;
            }
        }

        public void run() {
            if (DefaultTableDirectoryModel.this.directoryRowsCache == null || DefaultTableDirectoryModel.this.fileRowsCache == null) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                int count = this.rows.size();
                int firstRow = DefaultTableDirectoryModel.this.directoryRowsCache.size();
                int lastRow = firstRow + count - 1;
                if (this.doFire) {
                    int i = 0;
                    while (i < count) {
                        Object[] row = (Object[])this.rows.elementAt(i);
                        DefaultTableDirectoryModel.this.directoryRowsCache.addElement(row);
                        ++i;
                    }
                    DefaultTableDirectoryModel.this.fireTableRowsInserted(firstRow, lastRow);
                }
            }
            if (DefaultTableDirectoryModel.this.directoryRowsCache.size() + DefaultTableDirectoryModel.this.fileRowsCache.size() == DefaultTableDirectoryModel.this.totalAccepted) {
                DefaultTableDirectoryModel.this.fireLoadingEnded(DefaultTableDirectoryModel.this.currentDirectory);
            }
        }
    }

    private class LoadFilesThread
    extends Thread {
        Vector fileRunnables;
        Vector acceptedFiles;
        File curDir;
        int toLoad;

        public LoadFilesThread(File curDir, Vector acceptedFiles) {
            super("Basic L&F Files Loading Thread");
            this.curDir = curDir;
            this.acceptedFiles = acceptedFiles;
            this.toLoad = acceptedFiles.size();
            this.setPriority(8);
        }

        public void run() {
            try {
                DefaultTableDirectoryModel.this.loadDirsThread.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            Vector<Object[]> files = new Vector<Object[]>(10);
            this.fileRunnables = new Vector(this.toLoad);
            int i = 0;
            while (i < this.toLoad) {
                if (this.isInterrupted()) {
                    this.cancel();
                    DefaultTableDirectoryModel.this.fireLoadingEnded(this.curDir);
                    return;
                }
                File f = (File)this.acceptedFiles.elementAt(i);
                Object[] row = DefaultTableDirectoryModel.this.createRowForFile(f);
                files.addElement(row);
                if (files.size() == 10 || i == this.toLoad - 1) {
                    DoChangeFileContents runnable = new DoChangeFileContents(files);
                    this.fileRunnables.addElement(runnable);
                    SwingUtilities.invokeLater(runnable);
                    files = new Vector(10);
                }
                ++i;
            }
        }

        public void cancel() {
            int i = 0;
            while (i < this.fileRunnables.size()) {
                ((DoChangeFileContents)this.fileRunnables.elementAt(i)).cancel();
                ++i;
            }
        }
    }

    private class LoadDirsThread
    extends Thread {
        Vector dirRunnables;
        File[] filelist;
        File curDir;

        public LoadDirsThread(File curDir) {
            super("Basic L&F Dirs Loading Thread");
            this.curDir = curDir;
            this.setPriority(8);
        }

        public void run() {
            DefaultTableDirectoryModel.this.fireLoadingStarted(this.curDir);
            File[] contents = DefaultTableDirectoryModel.this.getFiles(this.curDir, DefaultTableDirectoryModel.this.directoryPane.isFileHidingEnabled());
            if (DefaultTableDirectoryModel.this.fileSorter != null) {
                DefaultTableDirectoryModel.this.fileSorter.sort(contents);
            }
            Vector<Object[]> directories = new Vector<Object[]>(10);
            Vector<File> files = new Vector<File>();
            this.dirRunnables = new Vector(contents.length);
            int selectionMode = DefaultTableDirectoryModel.this.directoryPane.getFileSelectionMode();
            DefaultTableDirectoryModel.this.totalAccepted = 0;
            switch (selectionMode) {
                case 2: {
                    DefaultTableDirectoryModel.this.totalAccepted = contents.length;
                    break;
                }
                case 1: {
                    int i = 0;
                    while (i < contents.length) {
                        if (DefaultTableDirectoryModel.this.isTraversable(contents[i])) {
                            ++DefaultTableDirectoryModel.this.totalAccepted;
                        }
                        ++i;
                    }
                    break;
                }
                case 0: {
                    int i = 0;
                    while (i < contents.length) {
                        if (!DefaultTableDirectoryModel.this.isTraversable(contents[i])) {
                            ++DefaultTableDirectoryModel.this.totalAccepted;
                        }
                        ++i;
                    }
                    break;
                }
            }
            if (DefaultTableDirectoryModel.this.totalAccepted == 0) {
                DefaultTableDirectoryModel.this.fireLoadingEnded(this.curDir);
                return;
            }
            int i = 0;
            while (i < contents.length) {
                if (this.isInterrupted()) {
                    this.cancel();
                    DefaultTableDirectoryModel.this.fireLoadingEnded(this.curDir);
                    return;
                }
                File f = contents[i];
                switch (selectionMode) {
                    case 2: {
                        Object[] row;
                        if (DefaultTableDirectoryModel.this.isTraversable(f)) {
                            if (DefaultTableDirectoryModel.this.directoryPane.accept(f)) {
                                row = DefaultTableDirectoryModel.this.createRowForFile(f);
                                directories.addElement(row);
                                break;
                            }
                            --DefaultTableDirectoryModel.this.totalAccepted;
                            break;
                        }
                        if (DefaultTableDirectoryModel.this.directoryPane.accept(f)) {
                            files.addElement(f);
                            break;
                        }
                        --DefaultTableDirectoryModel.this.totalAccepted;
                        break;
                    }
                    case 1: {
                        Object[] row;
                        if (!DefaultTableDirectoryModel.this.isTraversable(f)) break;
                        if (DefaultTableDirectoryModel.this.directoryPane.accept(f)) {
                            row = DefaultTableDirectoryModel.this.createRowForFile(f);
                            directories.addElement(row);
                            break;
                        }
                        --DefaultTableDirectoryModel.this.totalAccepted;
                        break;
                    }
                    case 0: {
                        if (DefaultTableDirectoryModel.this.isTraversable(f)) break;
                        if (DefaultTableDirectoryModel.this.directoryPane.accept(f)) {
                            files.addElement(f);
                            break;
                        }
                        --DefaultTableDirectoryModel.this.totalAccepted;
                    }
                }
                if (directories.size() == 10 || i == contents.length - 1) {
                    DoChangeDirContents runnable = new DoChangeDirContents(directories);
                    this.dirRunnables.addElement(runnable);
                    SwingUtilities.invokeLater(runnable);
                    directories = new Vector(10);
                }
                ++i;
            }
            DefaultTableDirectoryModel.this.loadFilesThread = new LoadFilesThread(this.curDir, files);
            DefaultTableDirectoryModel.this.loadFilesThread.start();
        }

        public void cancel() {
            int i = 0;
            while (i < this.dirRunnables.size()) {
                ((DoChangeDirContents)this.dirRunnables.elementAt(i)).cancel();
                ++i;
            }
        }
    }
}

