/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane;

import com.hbworks.dirpane.BasicFileSystem;
import com.hbworks.dirpane.FileNode;
import com.hbworks.dirpane.FileSystem;
import com.hbworks.dirpane.LoadQueue;
import com.hbworks.dirpane.TreeDirectoryPane;
import com.hbworks.dirpane.TreeFileSystemModel;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class DefaultTreeFileSystemModel
extends TreeFileSystemModel {
    protected transient LoadQueue loadQueue = new LoadQueue(this);
    protected LoadFilesThread loadFilesThread = null;
    protected LoadDirsThread loadDirsThread = null;
    public boolean loadWindows_A_Drive = false;

    public DefaultTreeFileSystemModel(TreeDirectoryPane pane) {
        this(pane, null);
    }

    public DefaultTreeFileSystemModel(TreeDirectoryPane pane, String rootPath) {
        super(pane, rootPath);
    }

    protected FileSystem createFileSystem() {
        return BasicFileSystem.getFileSystem();
    }

    public void propertyChange(PropertyChangeEvent e) {
        Object oldvalue = e.getOldValue();
        Object newvalue = e.getNewValue();
        String name = e.getPropertyName();
        if (name == "fileViewChanged" || name == "fileSorterChanged" || name == "fileHidingChanged" || name == "fileSelectionModeChanged" || name == "fileFilterChanged") {
            this.refreshAll();
        } else if (name == "directoryChanged") {
            File newDir = (File)newvalue;
            if (newDir instanceof BasicFileSystem.WindowsDrive && newDir.getPath().equals("A:\\")) {
                this.loadWindows_A_Drive = true;
            }
            this.loadPath(newDir, 0);
        } else if (name == "syncSlaveDirectory") {
            File slaveDir = (File)newvalue;
            if (slaveDir instanceof BasicFileSystem.WindowsDrive && slaveDir.getPath().equals("A:\\")) {
                this.loadWindows_A_Drive = true;
            }
            this.loadPath(slaveDir, 1);
        }
    }

    private void loadPath(File dir, int loadType) {
        if (dir == null) {
            throw new IllegalArgumentException("Can't load a null directory.");
        }
        FileNode node = this.getFromTableOfNodes(dir.getPath());
        if (node == null) {
            node = this.createFileNode(dir);
        }
        this.loadPath(node, loadType);
    }

    protected void loadPath(FileNode newNode, int loadType) {
        Object[] nodes = this.getPathToRoot(newNode);
        Vector<Object> nodesToLoad = new Vector<Object>(nodes.length);
        TreePath path = new TreePath(nodes);
        int counter = 0;
        int i = 0;
        while (i < nodes.length) {
            Object node = nodes[i];
            if (i == nodes.length - 1 && ((FileNode)node).getFile() instanceof BasicFileSystem.WindowsDrive && ((FileNode)node).getPathString().equals("A:\\")) {
                this.removeDescendantsOfNode((FileNode)node);
            }
            if (!((FileNode)node).isLoading() && !((FileNode)node).hasChildrenLoaded()) {
                nodesToLoad.addElement(node);
                ++counter;
            }
            ++i;
        }
        if (counter > 0) {
            this.fireLoadingStarted(path);
            this.loadQueue.add(nodesToLoad, loadType);
            this.loadQueue.load((FileNode)nodesToLoad.firstElement());
        } else {
            this.fireLoadingEnded(newNode, loadType);
        }
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        File oldfile = this.getFile(path);
        this.directoryPane.renameFile(oldfile, (String)newValue);
    }

    public void fileAdded(File newFile) {
        if (!this.belongsToFileSystem(newFile)) {
            return;
        }
        FileNode newNode = this.createFileNode(newFile);
        if (newNode == null) {
            return;
        }
        FileNode parent = (FileNode)newNode.getParent();
        if (parent == null || this.isLeaf(parent)) {
            return;
        }
        this.addNodeTo(newNode, parent);
        File[] contents = this.getContentsOfFile(parent.getFile());
        parent.setContents(contents);
        this.directoryPane.resetAutoRefresher(parent.getFile());
    }

    public void fileDeleted(File delFile) {
        String parentString = delFile.getParent();
        FileNode parent = this.getFromTableOfNodes(parentString);
        FileNode delnode = this.getFromTableOfNodes(delFile.getPath());
        if (parent == null || delnode == null) {
            return;
        }
        int index = parent.getIndex(delnode);
        boolean wasLast = index == parent.getChildCount() - 1;
        boolean selected = this.directoryPane.isPathSelected(new TreePath(delnode.getPath()));
        boolean delLeaf = delnode.isLeaf();
        this.removeDescendantsOfNode(delnode);
        this.removeNodeFromParent(delnode);
        this.removeFromTableOfNodes(delFile.getPath());
        this.directoryPane.removeFromAutoRefresher(delFile);
        if (!delLeaf) {
            this.directoryPane.setCurrentDirectory(parentString);
        } else if (selected) {
            if (parent.getFileChildCount() == 0) {
                this.directoryPane.setSelectionPath(new TreePath(parent.getPath()));
            } else {
                if (wasLast) {
                    index = parent.getChildCount() - 1;
                }
                FileNode nextNode = (FileNode)parent.getChildAt(index);
                this.directoryPane.setSelectionPath(new TreePath(nextNode.getPath()));
            }
        }
        File[] contents = this.getContentsOfFile(parent.getFile());
        parent.setContents(contents);
    }

    public void fileRenamed(File oldFile, File newFile) {
        FileNode editedNode = this.getFromTableOfNodes(oldFile.getPath());
        if (editedNode == null) {
            return;
        }
        FileNode parent = (FileNode)editedNode.getParent();
        if (parent == null) {
            return;
        }
        if (this.getIndexOfChild(parent, editedNode) < 0) {
            return;
        }
        boolean wasCurrent = this.directoryPane.isPathSelected(new TreePath(editedNode.getPath()));
        this.removeFromTableOfNodes(oldFile.getPath());
        editedNode.setUserObject(newFile);
        this.putIntoTableOfNodes(newFile.getPath(), editedNode);
        File[] parentContents = this.getContentsOfFile(parent.getFile());
        parent.setContents(parentContents);
        this.nodeChanged(editedNode);
        if (!editedNode.isLeaf()) {
            File[] contents = this.getContentsOfFile(newFile);
            editedNode.setContents(contents);
            if (editedNode.hasChildrenLoaded()) {
                FileNode[] children = editedNode.getChildrenAsArray();
                File[] orderedContents = this.orderContents(contents);
                this.updateChildren(editedNode, children, orderedContents);
            }
            if (wasCurrent) {
                this.directoryPane.setCurrentDirectory(editedNode.getPathString());
            }
        }
        this.directoryPane.removeFromAutoRefresher(oldFile);
        this.directoryPane.addToAutoRefresher(newFile);
        this.directoryPane.resetAutoRefresher(parent.getFile());
    }

    private File[] orderContents(File[] contents) {
        Object[] ordered = new File[contents.length];
        Vector<File> dirs = new Vector<File>();
        Vector<File> files = new Vector<File>();
        int i = 0;
        while (i < contents.length) {
            File f = contents[i];
            if (this.directoryPane.isTraversable(f)) {
                dirs.addElement(f);
            } else {
                files.addElement(f);
            }
            ++i;
        }
        Vector<File> all = dirs;
        int i2 = 0;
        while (i2 < files.size()) {
            all.addElement((File)files.elementAt(i2));
            ++i2;
        }
        all.copyInto(ordered);
        return ordered;
    }

    private void updateChildren(FileNode parent, FileNode[] children, File[] parentContents) {
        int i = 0;
        while (i < children.length) {
            FileNode child = children[i];
            File newFile = parentContents[i];
            File oldFile = child.getFile();
            this.removeFromTableOfNodes(oldFile.getPath());
            child.setUserObject(newFile);
            this.putIntoTableOfNodes(newFile.getPath(), child);
            this.nodeChanged(child);
            if (!child.isLeaf()) {
                File[] contents = this.getContentsOfFile(newFile);
                child.setContents(contents);
                if (child.hasChildrenLoaded()) {
                    FileNode[] grandChildren = child.getChildrenAsArray();
                    File[] orderedContents = this.orderContents(contents);
                    this.updateChildren(child, grandChildren, orderedContents);
                }
            }
            ++i;
        }
    }

    protected void setFileSystem(FileSystem system) {
        this.loadQueue = new LoadQueue(this);
        super.setFileSystem(system);
    }

    protected void setRoot(String newRootPath) {
        this.loadQueue = new LoadQueue(this);
        super.setRoot(newRootPath);
    }

    protected boolean deleteDirectory(File dir) {
        boolean wiped = true;
        File[] contents = this.getFiles(dir, this.directoryPane.isFileHidingEnabled());
        int i = 0;
        while (i < contents.length) {
            File f = contents[i];
            if (this.isTraversable(f)) {
                this.deleteDirectory(f);
            } else {
                wiped &= this.directoryPane.deleteFile(f);
            }
            ++i;
        }
        if (wiped &= this.deleteFile(dir)) {
            this.fileDeleted(dir);
        }
        return wiped;
    }

    protected FileNode createFileNode(File file) {
        if (file == null) {
            return null;
        }
        FileNode fileNode = null;
        String path = file.getPath();
        String parentPath = null;
        File parentFile = null;
        if (this.isDescendantOfRoot(this.getParentDirectory(file))) {
            parentPath = file.getParent();
            parentFile = this.getParentDirectory(file);
        }
        if (!this.isTraversable(file)) {
            fileNode = new FileNode(file, this.fileSorter);
        } else {
            fileNode = new FileNode(file, this.fileSorter, false);
            File[] contents = file instanceof BasicFileSystem.WindowsDrive && path.equals("A:\\") ? new File[]{} : this.getContentsOfFile(file);
            fileNode.setEmpty(contents.length == 0);
            fileNode.setContents(contents);
        }
        this.putIntoTableOfNodes(path, fileNode);
        if (fileNode.getParent() == null && parentFile != null && parentPath != null) {
            FileNode parentNode = this.getFromTableOfNodes(parentPath);
            if (parentNode == null) {
                parentNode = this.createFileNode(parentFile);
            }
            fileNode.setParent(parentNode);
        }
        return fileNode;
    }

    protected void setCurrentDirectory(File newDir) {
        if (newDir == null) {
            super.setCurrentDirectory(this.getWorkingDirectory());
        } else {
            if (!this.directoryCanBeCurrent(newDir)) {
                if (this.currentDirectory == null) {
                    super.setCurrentDirectory(this.getWorkingDirectory());
                }
                return;
            }
            File prev = null;
            while (!this.isTraversable(newDir) && prev != newDir && !this.isFileSystemRoot(newDir)) {
                prev = newDir;
                newDir = this.getParentDirectory(newDir);
            }
            super.setCurrentDirectory(newDir);
        }
    }

    protected void loadChildren(FileNode parentNode) {
        parentNode.setLoading(true);
        this.loadDirsThread = new LoadDirsThread(parentNode);
        this.loadDirsThread.start();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.fileSystem = this.createFileSystem();
        this.loadQueue = new LoadQueue(this);
    }

    private class DoChangeFileContents
    implements Runnable {
        private FileNode parentNode;
        private Vector childNodes;
        private int totalToLoad;
        private boolean doFire = true;
        private Object lock = new Object();

        public DoChangeFileContents(FileNode parentNode, Vector childNodes, int totalToLoad) {
            this.parentNode = parentNode;
            this.childNodes = childNodes;
            this.totalToLoad = totalToLoad;
        }

        synchronized void cancel() {
            Object object = this.lock;
            synchronized (object) {
                this.doFire = false;
            }
        }

        public synchronized void run() {
            Object object = this.lock;
            synchronized (object) {
                int count = this.childNodes.size();
                int dirOffset = this.parentNode.getDirectoryChildCount();
                int index = this.parentNode.getFileChildCount() + dirOffset;
                int[] indices = new int[count];
                if (this.doFire) {
                    int i = 0;
                    while (i < count) {
                        FileNode node = (FileNode)this.childNodes.elementAt(i);
                        this.parentNode.add(node);
                        indices[i] = index++;
                        ++i;
                    }
                    DefaultTreeFileSystemModel.this.nodesWereInserted(this.parentNode, indices);
                    if (this.parentNode.getChildCount() == this.totalToLoad && this.parentNode.isLoading()) {
                        this.parentNode.setLoading(false);
                        this.parentNode.setChildrenLoaded(true);
                        this.parentNode.setSorted(true);
                        if (DefaultTreeFileSystemModel.this.loadQueue != null) {
                            Runnable r = new Runnable(this){
                                private final /* synthetic */ DoChangeFileContents this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void run() {
                                    DoChangeFileContents.access$300((DoChangeFileContents)this.this$1).loadQueue.nodeLoaded(DoChangeFileContents.access$200(this.this$1));
                                }
                            };
                            Thread t = new Thread(r);
                            t.start();
                        }
                    }
                }
            }
        }

        static /* synthetic */ FileNode access$200(DoChangeFileContents x0) {
            return x0.parentNode;
        }

        static /* synthetic */ DefaultTreeFileSystemModel access$300(DoChangeFileContents x0) {
            return x0.DefaultTreeFileSystemModel.this;
        }
    }

    private class DoChangeDirContents
    implements Runnable {
        private FileNode parentNode;
        private Vector childNodes;
        private int totalToLoad;
        private boolean doFire = true;
        private Object lock = new Object();

        public DoChangeDirContents(FileNode parentNode, Vector childNodes, int totalToLoad) {
            this.parentNode = parentNode;
            this.childNodes = childNodes;
            this.totalToLoad = totalToLoad;
        }

        synchronized void cancel() {
            Object object = this.lock;
            synchronized (object) {
                this.doFire = false;
            }
        }

        public synchronized void run() {
            Object object = this.lock;
            synchronized (object) {
                int count = this.childNodes.size();
                int index = this.parentNode.getDirectoryChildCount();
                int[] indices = new int[count];
                if (this.doFire) {
                    int i = 0;
                    while (i < count) {
                        FileNode node = (FileNode)this.childNodes.elementAt(i);
                        this.parentNode.add(node);
                        indices[i] = index++;
                        ++i;
                    }
                    DefaultTreeFileSystemModel.this.nodesWereInserted(this.parentNode, indices);
                    if (this.parentNode.getChildCount() == this.totalToLoad && this.parentNode.isLoading()) {
                        this.parentNode.setLoading(false);
                        this.parentNode.setChildrenLoaded(true);
                        this.parentNode.setSorted(true);
                        DefaultTreeFileSystemModel.this.directoryPane.resetAutoRefresher(this.parentNode.getFile());
                        if (DefaultTreeFileSystemModel.this.loadQueue != null) {
                            Runnable r = new Runnable(this){
                                private final /* synthetic */ DoChangeDirContents this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void run() {
                                    DoChangeDirContents.access$100((DoChangeDirContents)this.this$1).loadQueue.nodeLoaded(DoChangeDirContents.access$000(this.this$1));
                                }
                            };
                            Thread t = new Thread(r);
                            t.start();
                        }
                    }
                }
            }
        }

        static /* synthetic */ FileNode access$000(DoChangeDirContents x0) {
            return x0.parentNode;
        }

        static /* synthetic */ DefaultTreeFileSystemModel access$100(DoChangeDirContents x0) {
            return x0.DefaultTreeFileSystemModel.this;
        }
    }

    private class LoadFilesThread
    extends Thread {
        FileNode parentNode;
        Vector fileRunnables;
        Vector filelist;
        int totalToLoad;

        public LoadFilesThread(FileNode parentNode, Vector filelist, int totalToLoad) {
            super("Basic L&F FileNode Files Loading Thread");
            this.parentNode = parentNode;
            this.filelist = filelist;
            this.totalToLoad = totalToLoad;
            this.setPriority(8);
        }

        public void run() {
            Vector<FileNode> files = new Vector<FileNode>(10);
            int toLoad = this.filelist.size();
            this.fileRunnables = new Vector(toLoad);
            int i = 0;
            while (i < toLoad) {
                if (this.isInterrupted()) {
                    this.cancel();
                    DefaultTreeFileSystemModel.this.directoryPane.setLoading(false);
                    this.parentNode.setChildrenLoaded(false);
                    this.parentNode.setSorted(false);
                    if (DefaultTreeFileSystemModel.this.loadQueue != null) {
                        DefaultTreeFileSystemModel.this.loadQueue.nodeLoaded(this.parentNode);
                    }
                    return;
                }
                File f = (File)this.filelist.elementAt(i);
                FileNode node = DefaultTreeFileSystemModel.this.createFileNode(f);
                files.addElement(node);
                if (files.size() == 10 || i == toLoad - 1) {
                    DoChangeFileContents runnable = new DoChangeFileContents(this.parentNode, files, this.totalToLoad);
                    this.fileRunnables.addElement(runnable);
                    SwingUtilities.invokeLater(runnable);
                    files = new Vector(10);
                }
                ++i;
            }
        }

        public void cancel() {
            int i = 0;
            while (i < this.fileRunnables.size()) {
                ((DoChangeFileContents)this.fileRunnables.elementAt(i)).cancel();
                ++i;
            }
        }
    }

    private class LoadDirsThread
    extends Thread {
        FileNode parentNode;
        Vector dirRunnables;

        public LoadDirsThread(FileNode parentNode) {
            super("Basic L&F FileNode Directory Loading Thread");
            this.parentNode = parentNode;
            this.setPriority(8);
        }

        public void run() {
            File[] contents = this.parentNode.getContents();
            if (this.parentNode.getFile() instanceof BasicFileSystem.WindowsDrive && this.parentNode.getPathString().equals("A:\\")) {
                if (DefaultTreeFileSystemModel.this.loadWindows_A_Drive) {
                    contents = DefaultTreeFileSystemModel.this.getContentsOfFile(this.parentNode.getFile());
                    this.parentNode.setEmpty(contents.length == 0);
                    DefaultTreeFileSystemModel.this.loadWindows_A_Drive = false;
                }
            } else if (contents.length == 0) {
                contents = DefaultTreeFileSystemModel.this.getContentsOfFile(this.parentNode.getFile());
                this.parentNode.setEmpty(contents.length == 0);
            }
            if (contents.length == 0) {
                this.parentNode.setLoading(false);
                this.parentNode.setChildrenLoaded(true);
                this.parentNode.setSorted(true);
                if (DefaultTreeFileSystemModel.this.loadQueue != null) {
                    DefaultTreeFileSystemModel.this.loadQueue.nodeLoaded(this.parentNode);
                }
                DefaultTreeFileSystemModel.this.directoryPane.resetAutoRefresher(this.parentNode.getFile());
                return;
            }
            int totalToLoad = contents.length;
            Vector<FileNode> directories = new Vector<FileNode>(10);
            Vector<File> filelist = new Vector<File>();
            this.dirRunnables = new Vector(totalToLoad);
            int i = 0;
            while (i < totalToLoad) {
                if (this.isInterrupted()) {
                    this.cancel();
                    DefaultTreeFileSystemModel.this.directoryPane.setLoading(false);
                    this.parentNode.setChildrenLoaded(false);
                    this.parentNode.setSorted(false);
                    if (DefaultTreeFileSystemModel.this.loadQueue != null) {
                        DefaultTreeFileSystemModel.this.loadQueue.nodeLoaded(this.parentNode);
                    }
                    return;
                }
                File f = contents[i];
                if (DefaultTreeFileSystemModel.this.isTraversable(f)) {
                    FileNode node = DefaultTreeFileSystemModel.this.getFromTableOfNodes(f.getPath());
                    if (node == null) {
                        node = DefaultTreeFileSystemModel.this.createFileNode(f);
                    }
                    directories.addElement(node);
                } else {
                    filelist.addElement(f);
                }
                if (directories.size() == 10 || i == totalToLoad - 1) {
                    DoChangeDirContents runnable = new DoChangeDirContents(this.parentNode, directories, totalToLoad);
                    this.dirRunnables.addElement(runnable);
                    SwingUtilities.invokeLater(runnable);
                    directories = new Vector(10);
                }
                ++i;
            }
            DefaultTreeFileSystemModel.this.loadFilesThread = new LoadFilesThread(this.parentNode, filelist, totalToLoad);
            DefaultTreeFileSystemModel.this.loadFilesThread.start();
        }

        public void cancel() {
            int i = 0;
            while (i < this.dirRunnables.size()) {
                ((DoChangeDirContents)this.dirRunnables.elementAt(i)).cancel();
                ++i;
            }
        }
    }
}

