/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane;

import com.hbworks.dirpane.FileSorter;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class FileNode
extends DefaultMutableTreeNode {
    protected Vector dirCache = new Vector();
    protected Vector fileCache = new Vector();
    protected boolean isLeaf = false;
    protected boolean isEmpty = true;
    protected boolean hasChildrenLoaded = false;
    protected boolean isLoading = false;
    protected boolean isSorted = false;
    protected File[] contents = null;
    protected FileSorter fileSorter = null;

    public FileNode(File userObject) {
        this(userObject, null, true);
    }

    public FileNode(File userObject, boolean isLeaf) {
        this(userObject, null, isLeaf);
    }

    public FileNode(File userObject, FileSorter fileSorter) {
        this(userObject, fileSorter, true);
    }

    public FileNode(File userObject, FileSorter fileSorter, boolean isLeaf) {
        super(userObject, !isLeaf);
        this.fileSorter = fileSorter;
        this.isLeaf = isLeaf;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void setContents(File[] contents) {
        this.contents = contents;
    }

    public File[] getContents() {
        return this.contents;
    }

    public void setFileSorter(FileSorter sorter) {
        this.fileSorter = sorter;
    }

    public FileSorter getFileSorter() {
        return this.fileSorter;
    }

    public void setEmpty(boolean b) {
        this.isEmpty = b;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public File getFile() {
        return (File)this.userObject;
    }

    public String getName() {
        if (this.userObject == null) {
            return null;
        }
        return ((File)this.userObject).getName();
    }

    public String getPathString() {
        return ((File)this.userObject).getPath();
    }

    public String toString() {
        return this.getName();
    }

    public void setSorted(boolean sorted) {
        this.isSorted = sorted;
    }

    public boolean isSorted() {
        return this.isSorted;
    }

    public void setLoading(boolean loading) {
        this.isLoading = loading;
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    public void setChildrenLoaded(boolean loaded) {
        this.hasChildrenLoaded = loaded;
    }

    public boolean hasChildrenLoaded() {
        return this.hasChildrenLoaded;
    }

    public void sortChildren() {
        if (!this.dirCache.isEmpty()) {
            this.dirCache = this.sortFileNodes(this.dirCache);
        }
        if (!this.fileCache.isEmpty()) {
            this.fileCache = this.sortFileNodes(this.fileCache);
        }
        this.setSorted(true);
    }

    public synchronized int getChildCount() {
        return this.getDirectoryChildCount() + this.getFileChildCount();
    }

    public TreeNode getChildAt(int childIndex) {
        if (this.dirCache.isEmpty() && this.fileCache.isEmpty()) {
            this.notifyAll();
            throw new ArrayIndexOutOfBoundsException("Node has no children");
        }
        if (childIndex < this.getDirectoryChildCount()) {
            return (FileNode)this.dirCache.elementAt(childIndex);
        }
        int fileIndex = childIndex - this.getDirectoryChildCount();
        return (FileNode)this.fileCache.elementAt(fileIndex);
    }

    public DefaultMutableTreeNode getFirstLeaf() {
        if (this.fileCache.size() <= 0) {
            return null;
        }
        return (FileNode)this.fileCache.elementAt(0);
    }

    public DefaultMutableTreeNode getLastLeaf() {
        if (this.fileCache.size() <= 0) {
            return null;
        }
        return (FileNode)this.fileCache.elementAt(this.fileCache.size() - 1);
    }

    public int getIndex(FileNode aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("Can't get index of a null.");
        }
        if (!this.dirCache.contains(aChild) && !this.fileCache.contains(aChild)) {
            return -1;
        }
        if (aChild.isLeaf()) {
            return this.fileCache.indexOf(aChild) + this.getDirectoryChildCount();
        }
        return this.dirCache.indexOf(aChild);
    }

    public FileNode[] getChildrenAsArray() {
        FileNode[] array = new FileNode[this.getDirectoryChildCount() + this.getFileChildCount()];
        Enumeration<TreeNode> en = this.children();
        int count = 0;
        while (en.hasMoreElements()) {
            array[count] = (FileNode)en.nextElement();
            ++count;
        }
        return array;
    }

    public void add(FileNode newChild) {
        int index;
        if (newChild == null) {
            throw new IllegalArgumentException("New child to add is null");
        }
        FileNode oldParent = (FileNode)newChild.getParent();
        if (oldParent != null && (index = oldParent.getIndex(newChild)) > -1) {
            oldParent.remove(newChild);
        }
        newChild.setParent(this);
        if (this.children == null) {
            this.children = new Vector();
        }
        if (newChild.isLeaf()) {
            this.fileCache.addElement(newChild);
            this.children.addElement(newChild);
        } else {
            int i = this.getDirectoryChildCount();
            this.dirCache.addElement(newChild);
            this.children.insertElementAt(newChild, i);
        }
    }

    public void insert(FileNode newChild, int childIndex) {
        int index;
        if (newChild == null) {
            throw new IllegalArgumentException("New child to insert is null");
        }
        FileNode oldParent = (FileNode)newChild.getParent();
        if (oldParent != null && (index = oldParent.getIndex(newChild)) > -1) {
            oldParent.remove(newChild);
        }
        newChild.setParent(this);
        if (this.children == null) {
            this.children = new Vector();
        }
        if (childIndex < this.getDirectoryChildCount()) {
            this.dirCache.insertElementAt(newChild, childIndex);
        } else {
            int fileIndex = childIndex - this.getDirectoryChildCount();
            this.fileCache.insertElementAt(newChild, fileIndex);
        }
        this.children.insertElementAt(newChild, childIndex);
    }

    public void replace(FileNode newChild, int childIndex) {
        int index;
        if (newChild == null) {
            throw new IllegalArgumentException("New child to replace another one is null");
        }
        MutableTreeNode oldNode = (MutableTreeNode)this.getChildAt(childIndex);
        oldNode.setParent(null);
        FileNode oldParent = (FileNode)newChild.getParent();
        if (oldParent != null && (index = oldParent.getIndex(newChild)) > -1) {
            oldParent.remove(newChild);
        }
        newChild.setParent(this);
        if (this.children == null) {
            this.children = new Vector();
        }
        if (childIndex < this.getDirectoryChildCount()) {
            this.dirCache.setElementAt(newChild, childIndex);
        } else {
            int fileIndex = childIndex - this.getDirectoryChildCount();
            this.fileCache.setElementAt(newChild, fileIndex);
        }
        this.children.setElementAt(newChild, childIndex);
    }

    public void remove(int childIndex) {
        MutableTreeNode child = (MutableTreeNode)this.getChildAt(childIndex);
        if (childIndex < this.getDirectoryChildCount()) {
            this.dirCache.removeElementAt(childIndex);
        } else {
            int fileIndex = childIndex - this.getDirectoryChildCount();
            this.fileCache.removeElementAt(fileIndex);
        }
        this.children.removeElementAt(childIndex);
        child.setParent(null);
    }

    public void remove(FileNode aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("Can't remove a null child.");
        }
        if (!this.dirCache.contains(aChild) && !this.fileCache.contains(aChild)) {
            throw new IllegalArgumentException("Can't remove a node that is not a child of this FileNode.");
        }
        this.remove(this.getIndex(aChild));
    }

    public void removeAllChildren() {
        int i = this.getChildCount() - 1;
        while (i >= 0) {
            this.remove(i);
            --i;
        }
    }

    public int getDirectoryChildCount() {
        if (this.dirCache != null) {
            return this.dirCache.size();
        }
        return 0;
    }

    public int getFileChildCount() {
        if (this.fileCache != null) {
            return this.fileCache.size();
        }
        return 0;
    }

    public int hashCode() {
        return this.getFile().hashCode();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        return that != null && that instanceof FileNode && this.getFile().equals(((FileNode)that).getFile());
    }

    private Vector sortFileNodes(Vector childNodes) {
        int c = childNodes.size();
        Object[] array = new FileNode[c];
        childNodes.copyInto(array);
        if (this.fileSorter != null) {
            this.fileSorter.sort((FileNode[])array);
        }
        Vector<Object> v = new Vector<Object>();
        int i = 0;
        while (i < array.length) {
            v.addElement(array[i]);
            ++i;
        }
        return v;
    }
}

