/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane;

import com.hbworks.dirpane.CellEditorContainer;
import com.hbworks.dirpane.FileNameCellEditor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TableDirectoryPaneCellEditor
extends CellEditorContainer
implements ActionListener,
ListSelectionListener {
    protected boolean canEdit;
    protected JTable table;
    protected int lastRow = -1;
    protected Timer timer;

    public TableDirectoryPaneCellEditor(JTable uiTable, JTextField editor, Component renderer) {
        super(null, renderer);
        this.setTable(uiTable);
        this.realEditor = new FileNameCellEditor(editor);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.setTable(table);
        Component returnValue = super.getTableCellEditorComponent(table, value, isSelected, row, column);
        boolean bl = this.canEdit = table.isRowSelected(row) && this.lastRow != -1 && row != -1 && this.lastRow == row;
        if (this.timer != null) {
            this.timer.stop();
        }
        return returnValue;
    }

    public boolean isCellEditable(EventObject event) {
        if (event == null || event instanceof MouseEvent && (SwingUtilities.isRightMouseButton((MouseEvent)event) || ((MouseEvent)event).getClickCount() > 2)) {
            return super.isCellEditable(event);
        }
        if (this.canEdit && ((MouseEvent)event).getClickCount() == 1) {
            if (this.timer == null) {
                this.timer = new Timer(400, this);
                this.timer.setRepeats(false);
            }
            this.timer.start();
        }
        return false;
    }

    protected void setTable(JTable newTable) {
        ListSelectionModel sm;
        if (this.table != null) {
            sm = this.table.getSelectionModel();
            sm.removeListSelectionListener(this);
        }
        this.table = newTable;
        if (this.table != null) {
            sm = this.table.getSelectionModel();
            sm.addListSelectionListener(this);
        }
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (this.table != null) {
            if (e.getFirstIndex() == -1 && e.getLastIndex() == -1) {
                this.lastRow = -1;
                return;
            }
            this.lastRow = this.table.getSelectedRowCount() == 1 ? this.table.getSelectedRow() : -1;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.table != null && this.lastRow != -1) {
            this.table.editCellAt(this.lastRow, this.table.convertColumnIndexToView(0));
        }
    }
}

