/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane;

import com.hbworks.dirpane.TableSelectionModel;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TableDirectoryPaneSelectionModel
implements TableSelectionModel,
Cloneable,
Serializable {
    private static final int MIN = -1;
    private static final int MAX = Integer.MAX_VALUE;
    private int selectionMode = 2;
    private int minIndex = Integer.MAX_VALUE;
    private int maxIndex = -1;
    private int anchorIndex = -1;
    private int leadIndex = -1;
    private int firstAdjustedIndex = Integer.MAX_VALUE;
    private int lastAdjustedIndex = -1;
    private boolean isAdjusting = false;
    private int firstChangedIndex = Integer.MAX_VALUE;
    private int lastChangedIndex = -1;
    private BitSet value = new BitSet(32);
    private int[] storedState = new int[9];
    private BitSet storedValue = new BitSet(32);
    private int[] selectedIndices;
    protected EventListenerList listenerList = new EventListenerList();
    protected boolean leadAnchorNotificationEnabled = true;
    static /* synthetic */ Class class$javax$swing$event$ListSelectionListener;

    public int getMinSelectionIndex() {
        return this.isSelectionEmpty() ? -1 : this.minIndex;
    }

    public int getMaxSelectionIndex() {
        return this.maxIndex;
    }

    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(int selectionMode) {
        switch (selectionMode) {
            case 0: 
            case 1: 
            case 2: {
                this.selectionMode = selectionMode;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid selectionMode");
            }
        }
    }

    public boolean isSelectedIndex(int index) {
        return index < this.minIndex || index > this.maxIndex ? false : this.value.get(index);
    }

    public boolean isSelectionEmpty() {
        return this.minIndex > this.maxIndex;
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.listenerList.add(class$javax$swing$event$ListSelectionListener == null ? (class$javax$swing$event$ListSelectionListener = TableDirectoryPaneSelectionModel.class$("javax.swing.event.ListSelectionListener")) : class$javax$swing$event$ListSelectionListener, l);
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        this.listenerList.remove(class$javax$swing$event$ListSelectionListener == null ? (class$javax$swing$event$ListSelectionListener = TableDirectoryPaneSelectionModel.class$("javax.swing.event.ListSelectionListener")) : class$javax$swing$event$ListSelectionListener, l);
    }

    protected void fireValueChanged(boolean isAdjusting) {
        if (this.lastChangedIndex == -1) {
            return;
        }
        int oldFirstChangedIndex = this.firstChangedIndex;
        int oldLastChangedIndex = this.lastChangedIndex;
        this.firstChangedIndex = Integer.MAX_VALUE;
        this.lastChangedIndex = -1;
        this.fireValueChanged(oldFirstChangedIndex, oldLastChangedIndex, isAdjusting);
    }

    protected void fireValueChanged(int firstIndex, int lastIndex) {
        this.fireValueChanged(firstIndex, lastIndex, this.getValueIsAdjusting());
    }

    protected void fireValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
        Object[] listeners = this.listenerList.getListenerList();
        ListSelectionEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$javax$swing$event$ListSelectionListener == null ? TableDirectoryPaneSelectionModel.class$("javax.swing.event.ListSelectionListener") : class$javax$swing$event$ListSelectionListener)) {
                if (e == null) {
                    e = new ListSelectionEvent(this, firstIndex, lastIndex, isAdjusting);
                }
                ((ListSelectionListener)listeners[i + 1]).valueChanged(e);
            }
            i -= 2;
        }
    }

    private void fireValueChanged() {
        if (this.lastAdjustedIndex == -1) {
            return;
        }
        if (this.getValueIsAdjusting()) {
            this.firstChangedIndex = Math.min(this.firstChangedIndex, this.firstAdjustedIndex);
            this.lastChangedIndex = Math.max(this.lastChangedIndex, this.lastAdjustedIndex);
        }
        int oldFirstAdjustedIndex = this.firstAdjustedIndex;
        int oldLastAdjustedIndex = this.lastAdjustedIndex;
        this.firstAdjustedIndex = Integer.MAX_VALUE;
        this.lastAdjustedIndex = -1;
        this.fireValueChanged(oldFirstAdjustedIndex, oldLastAdjustedIndex);
    }

    private void markAsDirty(int r) {
        this.firstAdjustedIndex = Math.min(this.firstAdjustedIndex, r);
        this.lastAdjustedIndex = Math.max(this.lastAdjustedIndex, r);
    }

    private void set(int r) {
        if (this.value.get(r)) {
            return;
        }
        this.value.set(r);
        this.markAsDirty(r);
        this.minIndex = Math.min(this.minIndex, r);
        this.maxIndex = Math.max(this.maxIndex, r);
    }

    private void clear(int r) {
        if (!this.value.get(r)) {
            return;
        }
        this.value.clear(r);
        this.markAsDirty(r);
        if (r == this.minIndex) {
            ++this.minIndex;
            while (this.minIndex <= this.maxIndex) {
                if (this.value.get(this.minIndex)) break;
                ++this.minIndex;
            }
        }
        if (r == this.maxIndex) {
            --this.maxIndex;
            while (this.minIndex <= this.maxIndex) {
                if (this.value.get(this.maxIndex)) break;
                --this.maxIndex;
            }
        }
        if (this.isSelectionEmpty()) {
            this.minIndex = Integer.MAX_VALUE;
            this.maxIndex = -1;
        }
    }

    public void setLeadAnchorNotificationEnabled(boolean flag) {
        this.leadAnchorNotificationEnabled = flag;
    }

    public boolean isLeadAnchorNotificationEnabled() {
        return this.leadAnchorNotificationEnabled;
    }

    private void updateLeadAnchorIndices(int anchorIndex, int leadIndex) {
        if (this.leadAnchorNotificationEnabled) {
            if (this.anchorIndex != anchorIndex) {
                if (this.anchorIndex != -1) {
                    this.markAsDirty(this.anchorIndex);
                }
                this.markAsDirty(anchorIndex);
            }
            if (this.leadIndex != leadIndex) {
                if (this.leadIndex != -1) {
                    this.markAsDirty(this.leadIndex);
                }
                this.markAsDirty(leadIndex);
            }
        }
        this.anchorIndex = anchorIndex;
        this.leadIndex = leadIndex;
    }

    private boolean contains(int a, int b, int i) {
        return i >= a && i <= b;
    }

    private void changeSelection(int clearMin, int clearMax, int setMin, int setMax, boolean clearFirst) {
        int i = Math.min(setMin, clearMin);
        while (i <= Math.max(setMax, clearMax)) {
            boolean shouldClear = this.contains(clearMin, clearMax, i);
            boolean shouldSet = this.contains(setMin, setMax, i);
            if (shouldSet && shouldClear) {
                if (clearFirst) {
                    shouldClear = false;
                } else {
                    shouldSet = false;
                }
            }
            if (shouldSet) {
                this.set(i);
            }
            if (shouldClear) {
                this.clear(i);
            }
            ++i;
        }
        this.updateSelectedIndices();
        this.fireValueChanged();
    }

    private void changeSelection(int clearMin, int clearMax, int setMin, int setMax) {
        this.changeSelection(clearMin, clearMax, setMin, setMax, true);
    }

    public void clearSelection() {
        this.clearSelection(true);
    }

    private void clearSelection(boolean sendEvent) {
        this.storeState();
        this.value = new BitSet(32);
        this.minIndex = Integer.MAX_VALUE;
        this.maxIndex = -1;
        this.anchorIndex = -1;
        this.leadIndex = -1;
        this.firstAdjustedIndex = Integer.MAX_VALUE;
        this.lastAdjustedIndex = -1;
        this.isAdjusting = false;
        this.firstChangedIndex = Integer.MAX_VALUE;
        this.lastChangedIndex = -1;
        this.updateSelectedIndices();
        if (sendEvent) {
            this.fireValueChanged(-1, -1, false);
        }
    }

    public void undoClearSelection() {
        this.reloadState();
        this.updateSelectedIndices();
        this.fireValueChanged();
    }

    public void updateSelection(int[] indices, int anchor, int lead) {
        this.clearSelection(false);
        this.anchorIndex = anchor;
        this.leadIndex = lead;
        int i = 0;
        while (i < indices.length) {
            this.minIndex = Math.min(this.minIndex, indices[i]);
            this.maxIndex = Math.max(this.maxIndex, indices[i]);
            this.value.set(indices[i]);
            this.markAsDirty(indices[i]);
            ++i;
        }
        this.updateSelectedIndices();
        this.fireValueChanged();
    }

    public void undoUpdateSelection() {
        this.reloadState();
        this.updateSelectedIndices();
        this.fireValueChanged();
    }

    private void storeState() {
        this.storedValue = new BitSet(32);
        this.storedValue.or(this.value);
        this.storedState[0] = this.selectionMode;
        this.storedState[1] = this.minIndex;
        this.storedState[2] = this.maxIndex;
        this.storedState[3] = this.anchorIndex;
        this.storedState[4] = this.leadIndex;
        this.storedState[5] = this.firstAdjustedIndex;
        this.storedState[6] = this.lastAdjustedIndex;
        this.storedState[7] = this.firstChangedIndex;
        this.storedState[8] = this.lastChangedIndex;
    }

    private void reloadState() {
        this.value = new BitSet(32);
        this.value.or(this.storedValue);
        this.selectionMode = this.storedState[0];
        this.minIndex = this.storedState[1];
        this.maxIndex = this.storedState[2];
        this.anchorIndex = this.storedState[3];
        this.leadIndex = this.storedState[4];
        this.firstAdjustedIndex = this.storedState[5];
        this.lastAdjustedIndex = this.storedState[6];
        this.firstChangedIndex = this.storedState[7];
        this.lastChangedIndex = this.storedState[8];
    }

    public int[] getSelectedIndices() {
        return this.selectedIndices;
    }

    private void updateSelectedIndices() {
        Vector<Integer> v = new Vector<Integer>();
        int i = 0;
        while (i < this.value.size()) {
            if (this.value.get(i)) {
                v.addElement(new Integer(i));
            }
            ++i;
        }
        this.selectedIndices = new int[v.size()];
        int i2 = 0;
        while (i2 < v.size()) {
            this.selectedIndices[i2] = (Integer)v.elementAt(i2);
            ++i2;
        }
    }

    public void setSelectionInterval(int index0, int index1) {
        if (index0 == -1 || index1 == -1) {
            return;
        }
        if (this.getSelectionMode() == 0) {
            index0 = index1;
        }
        this.updateLeadAnchorIndices(index0, index1);
        int clearMin = this.minIndex;
        int clearMax = this.maxIndex;
        int setMin = Math.min(index0, index1);
        int setMax = Math.max(index0, index1);
        this.changeSelection(clearMin, clearMax, setMin, setMax);
    }

    public void addSelectionInterval(int index0, int index1) {
        if (index0 == -1 || index1 == -1) {
            return;
        }
        if (this.getSelectionMode() != 2) {
            this.setSelectionInterval(index0, index1);
            return;
        }
        this.updateLeadAnchorIndices(index0, index1);
        int clearMin = Integer.MAX_VALUE;
        int clearMax = -1;
        int setMin = Math.min(index0, index1);
        int setMax = Math.max(index0, index1);
        this.changeSelection(clearMin, clearMax, setMin, setMax);
    }

    public void removeSelectionInterval(int index0, int index1) {
        if (index0 == -1 || index1 == -1) {
            return;
        }
        this.updateLeadAnchorIndices(index0, index1);
        int clearMin = Math.min(index0, index1);
        int clearMax = Math.max(index0, index1);
        int setMin = Integer.MAX_VALUE;
        int setMax = -1;
        this.changeSelection(clearMin, clearMax, setMin, setMax);
    }

    private void setState(int index, boolean state) {
        if (state) {
            this.set(index);
        } else {
            this.clear(index);
        }
    }

    public void insertIndexInterval(int index, int length, boolean before) {
        int insMinIndex = before ? index : index + 1;
        int insMaxIndex = insMinIndex + length - 1;
        int i = this.maxIndex;
        while (i >= insMinIndex) {
            this.setState(i + length, this.value.get(i));
            --i;
        }
        boolean setInsertedValues = this.value.get(index);
        int i2 = insMinIndex;
        while (i2 <= insMaxIndex) {
            this.setState(i2, setInsertedValues);
            ++i2;
        }
        this.updateSelectedIndices();
    }

    public void removeIndexInterval(int index0, int index1) {
        int rmMinIndex = Math.min(index0, index1);
        int rmMaxIndex = Math.max(index0, index1);
        int gapLength = rmMaxIndex - rmMinIndex + 1;
        int i = rmMinIndex;
        while (i <= this.maxIndex) {
            this.setState(i, this.value.get(i + gapLength));
            ++i;
        }
        this.updateSelectedIndices();
    }

    public void setValueIsAdjusting(boolean isAdjusting) {
        if (isAdjusting != this.isAdjusting) {
            this.isAdjusting = isAdjusting;
            this.fireValueChanged(isAdjusting);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        TableDirectoryPaneSelectionModel clone = (TableDirectoryPaneSelectionModel)super.clone();
        clone.value = (BitSet)this.value.clone();
        clone.listenerList = new EventListenerList();
        return clone;
    }

    public int getAnchorSelectionIndex() {
        return this.anchorIndex;
    }

    public int getLeadSelectionIndex() {
        return this.leadIndex;
    }

    public void setAnchorSelectionIndex(int anchorIndex) {
        this.updateLeadAnchorIndices(anchorIndex, this.leadIndex);
        this.anchorIndex = anchorIndex;
        this.fireValueChanged();
    }

    public void setLeadSelectionIndex(int leadIndex) {
        int anchorIndex = this.anchorIndex;
        if (this.getSelectionMode() == 0) {
            anchorIndex = leadIndex;
        }
        int oldMin = Math.min(this.anchorIndex, this.minIndex);
        int oldMax = Math.max(this.anchorIndex, this.maxIndex);
        int newMin = Math.min(anchorIndex, leadIndex);
        int newMax = Math.max(anchorIndex, leadIndex);
        this.changeSelection(oldMin, oldMax, newMin, newMax);
        this.anchorIndex = anchorIndex;
        this.leadIndex = leadIndex;
    }

    public void updateLeadSelectionIndex(int newLeadIndex) {
        int anchorIndex = this.anchorIndex;
        if (this.getSelectionMode() == 0) {
            anchorIndex = this.leadIndex;
        }
        this.updateLeadAnchorIndices(anchorIndex, newLeadIndex);
        this.fireValueChanged();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

