/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane.comp;

import com.hbworks.dirpane.DirectoryPane;
import com.hbworks.dirpane.plaf.mac.MacIconFactory;
import com.hbworks.dirpane.plaf.metal.MetalIconFactory;
import com.hbworks.dirpane.plaf.motif.MotifIconFactory;
import com.hbworks.dirpane.plaf.windows.WindowsIconFactory;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class GoHomeButton
extends JButton {
    static final long serialVersionUID = -6304165488696290746L;
    public static final String DIRECTORYPANE_PROPERTY = "directoryPane";
    DirectoryPane pane;

    public GoHomeButton() {
        this((DirectoryPane)null);
    }

    public GoHomeButton(DirectoryPane pane) {
        if (pane != null) {
            this.pane = pane;
            this.addActionListener(pane.getGoHomeAction());
        }
    }

    public void setDirectoryPane(DirectoryPane newpane) {
        DirectoryPane newprop;
        if (newpane == null) {
            throw new IllegalArgumentException("Can not set a null DirectoryPane");
        }
        DirectoryPane oldprop = this.pane;
        this.pane = newprop = newpane;
        this.addActionListener(this.pane.getGoHomeAction());
        this.firePropertyChange(DIRECTORYPANE_PROPERTY, oldprop, newprop);
    }

    public DirectoryPane getDirectoryPane() {
        return this.pane;
    }

    public Icon getIcon() {
        LookAndFeel lf = UIManager.getLookAndFeel();
        if (lf.getID().equals("Metal")) {
            return MetalIconFactory.getHomeFolderIcon();
        }
        if (lf.getID().equals("Windows")) {
            return WindowsIconFactory.getHomeFolderIcon();
        }
        if (lf.getID().equals("Motif")) {
            return MotifIconFactory.getHomeFolderIcon();
        }
        if (lf.getID().equals("Platinum")) {
            return MacIconFactory.getHomeFolderIcon();
        }
        return UIManager.getIcon("FileChooser.homeFolderIcon");
    }

    public Icon getDisabledIcon() {
        try {
            Image image = ((ImageIcon)this.getIcon()).getImage();
            Image disabledImage = GrayFilter.createDisabledImage(image);
            return new ImageIcon(disabledImage);
        }
        catch (ClassCastException e) {
            return this.getIcon();
        }
    }

    public Insets getMargin() {
        return new Insets(1, 1, 1, 1);
    }

    public float getAlignmentY() {
        return 0.5f;
    }
}

