/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane.plaf.basic;

import com.hbworks.dirpane.FileNode;
import com.hbworks.dirpane.TreeFileSystemModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.UIResource;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.FixedHeightLayoutCache;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.tree.VariableHeightLayoutCache;

public class BasicPaneTreeUI
extends TreeUI {
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    protected transient Icon collapsedIcon;
    protected transient Icon expandedIcon;
    private Color hashColor;
    protected int leftChildIndent;
    protected int rightChildIndent;
    protected int totalChildIndent;
    protected Dimension preferredMinSize;
    protected int lastSelectedRow;
    protected JTree tree;
    protected transient TreeCellRenderer currentCellRenderer;
    protected boolean createdRenderer;
    protected transient TreeCellEditor cellEditor;
    protected boolean createdCellEditor;
    protected boolean stopEditingInCompleteEditing;
    protected CellRendererPane rendererPane;
    protected Dimension preferredSize;
    protected boolean validCachedPreferredSize;
    protected AbstractLayoutCache treeState;
    protected Hashtable drawingCache;
    protected boolean largeModel;
    protected AbstractLayoutCache.NodeDimensions nodeDimensions;
    protected TreeFileSystemModel treeModel;
    protected TreeSelectionModel treeSelectionModel;
    protected int depthOffset;
    protected Component editingComponent;
    protected TreePath editingPath;
    protected int editingRow;
    protected boolean editorHasDifferentSize;
    private TreePath anchorPath;
    private TreePath leadPath;
    private int leadRow;
    private boolean changeSelectionWithFocus;
    private Vector keyActions;
    private PropertyChangeListener propertyChangeListener;
    private PropertyChangeListener selectionModelPropertyChangeListener;
    private MouseListener mouseListener;
    private FocusListener focusListener;
    private KeyListener keyListener;
    private ComponentListener componentListener;
    private CellEditorListener cellEditorListener;
    private TreeSelectionListener treeSelectionListener;
    private TreeModelListener treeModelListener;
    private TreeExpansionListener treeExpansionListener;

    public static ComponentUI createUI(JComponent x) {
        return new BasicPaneTreeUI();
    }

    protected Color getHashColor() {
        return this.hashColor;
    }

    protected void setHashColor(Color color) {
        this.hashColor = color;
    }

    public void setLeftChildIndent(int newAmount) {
        this.leftChildIndent = newAmount;
        this.totalChildIndent = this.leftChildIndent + this.rightChildIndent;
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
        }
        this.updateSize();
    }

    public int getLeftChildIndent() {
        return this.leftChildIndent;
    }

    public void setRightChildIndent(int newAmount) {
        this.rightChildIndent = newAmount;
        this.totalChildIndent = this.leftChildIndent + this.rightChildIndent;
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
        }
        this.updateSize();
    }

    public int getRightChildIndent() {
        return this.rightChildIndent;
    }

    public void setExpandedIcon(Icon newG) {
        this.expandedIcon = newG;
    }

    public Icon getExpandedIcon() {
        return this.expandedIcon;
    }

    public void setCollapsedIcon(Icon newG) {
        this.collapsedIcon = newG;
    }

    public Icon getCollapsedIcon() {
        return this.collapsedIcon;
    }

    protected void setLargeModel(boolean largeModel) {
        if (this.getRowHeight() < 1) {
            largeModel = false;
        }
        if (this.largeModel != largeModel) {
            this.completeEditing();
            this.largeModel = largeModel;
            this.treeState = this.createLayoutCache();
            this.configureLayoutCache();
            this.updateLayoutCacheExpandedNodes();
            this.updateSize();
        }
    }

    protected boolean isLargeModel() {
        return this.largeModel;
    }

    protected void setRowHeight(int rowHeight) {
        this.completeEditing();
        if (this.treeState != null) {
            this.setLargeModel(this.tree.isLargeModel());
            this.treeState.setRowHeight(rowHeight);
            this.updateSize();
        }
    }

    protected int getRowHeight() {
        return this.tree == null ? -1 : this.tree.getRowHeight();
    }

    protected void setCellRenderer(TreeCellRenderer tcr) {
        this.completeEditing();
        this.updateRenderer();
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
            this.updateSize();
        }
    }

    protected TreeCellRenderer getCellRenderer() {
        return this.currentCellRenderer;
    }

    protected void setModel(TreeFileSystemModel model) {
        this.completeEditing();
        if (this.treeModel != null && this.treeModelListener != null) {
            this.treeModel.removeTreeModelListener(this.treeModelListener);
        }
        this.treeModel = model;
        if (this.treeModel != null && this.treeModelListener != null) {
            this.treeModel.addTreeModelListener(this.treeModelListener);
        }
        if (this.treeState != null) {
            this.treeState.setModel(model);
            this.updateLayoutCacheExpandedNodes();
            this.updateSize();
        }
    }

    protected TreeFileSystemModel getModel() {
        return this.treeModel;
    }

    protected void setRootVisible(boolean newValue) {
        this.completeEditing();
        this.updateDepthOffset();
        if (this.treeState != null) {
            this.treeState.setRootVisible(newValue);
            this.treeState.invalidateSizes();
            this.updateSize();
        }
    }

    protected boolean isRootVisible() {
        return this.tree != null ? this.tree.isRootVisible() : false;
    }

    protected void setShowsRootHandles(boolean newValue) {
        this.completeEditing();
        this.updateDepthOffset();
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
            this.updateSize();
        }
    }

    protected boolean getShowsRootHandles() {
        return this.tree != null ? this.tree.getShowsRootHandles() : false;
    }

    protected void setCellEditor(TreeCellEditor editor) {
        this.updateCellEditor();
    }

    protected TreeCellEditor getCellEditor() {
        return this.tree != null ? this.tree.getCellEditor() : null;
    }

    protected void setEditable(boolean newValue) {
        this.updateCellEditor();
    }

    protected boolean isEditable() {
        return this.tree != null ? this.tree.isEditable() : false;
    }

    protected void setSelectionModel(TreeSelectionModel newLSM) {
        this.completeEditing();
        if (this.selectionModelPropertyChangeListener != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.removePropertyChangeListener(this.selectionModelPropertyChangeListener);
        }
        if (this.treeSelectionListener != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.removeTreeSelectionListener(this.treeSelectionListener);
        }
        this.treeSelectionModel = newLSM;
        if (this.treeSelectionModel != null) {
            if (this.selectionModelPropertyChangeListener != null) {
                this.treeSelectionModel.addPropertyChangeListener(this.selectionModelPropertyChangeListener);
            }
            if (this.treeSelectionListener != null) {
                this.treeSelectionModel.addTreeSelectionListener(this.treeSelectionListener);
            }
            if (this.treeState != null) {
                this.treeState.setSelectionModel(this.treeSelectionModel);
            }
        } else if (this.treeState != null) {
            this.treeState.setSelectionModel(null);
        }
        if (this.tree != null) {
            this.tree.repaint();
        }
    }

    protected TreeSelectionModel getSelectionModel() {
        return this.treeSelectionModel;
    }

    public Rectangle getPathBounds(JTree tree, TreePath path) {
        if (tree != null && this.treeState != null) {
            Insets i = tree.getInsets();
            Rectangle bounds = this.treeState.getBounds(path, null);
            if (bounds != null && i != null) {
                bounds.x += i.left;
                bounds.y += i.top;
            }
            return bounds;
        }
        return null;
    }

    public TreePath getPathForRow(JTree tree, int row) {
        return this.treeState != null ? this.treeState.getPathForRow(row) : null;
    }

    public int getRowForPath(JTree tree, TreePath path) {
        return this.treeState != null ? this.treeState.getRowForPath(path) : -1;
    }

    public int getRowCount(JTree tree) {
        return this.treeState != null ? this.treeState.getRowCount() : 0;
    }

    public TreePath getClosestPathForLocation(JTree tree, int x, int y) {
        if (tree != null && this.treeState != null) {
            Insets i = tree.getInsets();
            if (i == null) {
                i = EMPTY_INSETS;
            }
            return this.treeState.getPathClosestTo(x - i.left, y - i.top);
        }
        return null;
    }

    public boolean isEditing(JTree tree) {
        return this.editingComponent != null;
    }

    public boolean stopEditing(JTree tree) {
        if (this.editingComponent != null && this.cellEditor.stopCellEditing()) {
            this.completeEditing(false, false, true);
            return true;
        }
        return false;
    }

    public void cancelEditing(JTree tree) {
        if (this.editingComponent != null) {
            this.completeEditing(false, true, false);
        }
    }

    public void startEditingAtPath(JTree tree, TreePath path) {
        tree.scrollPathToVisible(path);
        if (path != null && tree.isVisible(path)) {
            this.startEditing(path, null);
        }
    }

    public TreePath getEditingPath(JTree tree) {
        return this.editingPath;
    }

    public void installUI(JComponent c) {
        if (c == null) {
            throw new NullPointerException("null component passed to BasicPaneTreeUI.installUI()");
        }
        this.tree = (JTree)c;
        this.prepareForUIInstall();
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
        this.installComponents();
        this.completeUIInstall();
    }

    protected void prepareForUIInstall() {
        this.drawingCache = new Hashtable(7);
        this.stopEditingInCompleteEditing = true;
        this.lastSelectedRow = -1;
        this.anchorPath = null;
        this.leadPath = null;
        this.leadRow = -1;
        this.preferredSize = new Dimension();
        this.tree.setRowHeight(UIManager.getInt("Tree.rowHeight"));
        Object b = UIManager.get("Tree.scrollsOnExpand");
        if (b != null) {
            this.tree.setScrollsOnExpand((Boolean)b);
        }
        this.largeModel = this.tree.isLargeModel();
        if (this.getRowHeight() <= 0) {
            this.largeModel = false;
        }
        this.setModel((TreeFileSystemModel)this.tree.getModel());
    }

    protected void completeUIInstall() {
        this.setShowsRootHandles(this.tree.getShowsRootHandles());
        this.updateRenderer();
        this.updateDepthOffset();
        this.setSelectionModel(this.tree.getSelectionModel());
        this.treeState = this.createLayoutCache();
        this.configureLayoutCache();
        this.updateSize();
    }

    protected void installDefaults() {
        if (this.tree.getBackground() == null || this.tree.getBackground() instanceof UIResource) {
            this.tree.setBackground(UIManager.getColor("Tree.background"));
        }
        if (this.getHashColor() == null || this.getHashColor() instanceof UIResource) {
            this.setHashColor(UIManager.getColor("Tree.hash"));
        }
        if (this.tree.getFont() == null || this.tree.getFont() instanceof UIResource) {
            this.tree.setFont(UIManager.getFont("Tree.font"));
        }
        this.setExpandedIcon((Icon)UIManager.get("Tree.expandedIcon"));
        this.setCollapsedIcon((Icon)UIManager.get("Tree.collapsedIcon"));
        this.setLeftChildIndent((Integer)UIManager.get("Tree.leftChildIndent"));
        this.setRightChildIndent((Integer)UIManager.get("Tree.rightChildIndent"));
        this.changeSelectionWithFocus = (Boolean)UIManager.get("Tree.changeSelectionWithFocus");
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.tree.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.mouseListener = this.createMouseListener()) != null) {
            this.tree.addMouseListener(this.mouseListener);
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.tree.addFocusListener(this.focusListener);
        }
        if ((this.keyListener = this.createKeyListener()) != null) {
            this.tree.addKeyListener(this.keyListener);
        }
        if ((this.treeExpansionListener = this.createTreeExpansionListener()) != null) {
            this.tree.addTreeExpansionListener(this.treeExpansionListener);
        }
        if ((this.treeModelListener = this.createTreeModelListener()) != null && this.treeModel != null) {
            this.treeModel.addTreeModelListener(this.treeModelListener);
        }
        if ((this.selectionModelPropertyChangeListener = this.createSelectionModelPropertyChangeListener()) != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.addPropertyChangeListener(this.selectionModelPropertyChangeListener);
        }
        if ((this.treeSelectionListener = this.createTreeSelectionListener()) != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.addTreeSelectionListener(this.treeSelectionListener);
        }
    }

    private void registerKeyAction(ActionListener action, KeyStroke ks) {
        if (action == null || ks == null) {
            return;
        }
        this.keyActions.addElement(ks);
        this.tree.registerKeyboardAction(action, ks, 0);
    }

    protected void installKeyboardActions() {
        boolean changeSelection = this.changeSelectionWithFocus();
        this.keyActions = new Vector(43);
        this.registerKeyAction(new TreeIncrementAction(-1, "UP", false, changeSelection), KeyStroke.getKeyStroke(38, 0));
        this.registerKeyAction(new TreeIncrementAction(-1, "UP", false, changeSelection), KeyStroke.getKeyStroke("KP_UP"));
        this.registerKeyAction(new TreeIncrementAction(-1, "SELECT_UP", true, true), KeyStroke.getKeyStroke(38, 1));
        this.registerKeyAction(new TreeIncrementAction(-1, "SELECT_UP", true, true), KeyStroke.getKeyStroke("shift KP_UP"));
        this.registerKeyAction(new TreeIncrementAction(1, "DOWN", false, changeSelection), KeyStroke.getKeyStroke(40, 0));
        this.registerKeyAction(new TreeIncrementAction(1, "DOWN", false, changeSelection), KeyStroke.getKeyStroke("KP_DOWN"));
        this.registerKeyAction(new TreeIncrementAction(1, "SELECT_DOWN", true, true), KeyStroke.getKeyStroke(40, 1));
        this.registerKeyAction(new TreeIncrementAction(1, "SELECT_DOWN", true, true), KeyStroke.getKeyStroke("shift KP_DOWN"));
        this.registerKeyAction(new TreeTraverseAction(1, "RIGHT", changeSelection), KeyStroke.getKeyStroke(39, 0));
        this.registerKeyAction(new TreeTraverseAction(1, "RIGHT", changeSelection), KeyStroke.getKeyStroke("KP_RIGHT"));
        this.registerKeyAction(new TreeTraverseAction(-1, "LEFT", changeSelection), KeyStroke.getKeyStroke(37, 0));
        this.registerKeyAction(new TreeTraverseAction(-1, "LEFT", changeSelection), KeyStroke.getKeyStroke("KP_LEFT"));
        this.registerKeyAction(new TreePageAction(-1, "P_UP", false, changeSelection), KeyStroke.getKeyStroke(33, 0));
        this.registerKeyAction(new TreePageAction(-1, "SELECT_P_UP", true, true), KeyStroke.getKeyStroke(33, 1));
        this.registerKeyAction(new TreePageAction(1, "P_DOWN", false, changeSelection), KeyStroke.getKeyStroke(34, 0));
        this.registerKeyAction(new TreePageAction(1, "SELECT_P_DOWN", true, true), KeyStroke.getKeyStroke(34, 1));
        this.registerKeyAction(new TreeHomeAction(1, "END", false, changeSelection), KeyStroke.getKeyStroke(35, 0));
        this.registerKeyAction(new TreeHomeAction(1, "SELECT_END", false, changeSelection), KeyStroke.getKeyStroke(35, 1));
        this.registerKeyAction(new TreeToggleAction("TOGGLE"), KeyStroke.getKeyStroke(10, 0));
        this.registerKeyAction(new TreeEditAction("EDIT_NODE"), KeyStroke.getKeyStroke(113, 0));
        TreeSelectAllAction saAction = new TreeSelectAllAction("SELECT_ALL", true);
        this.registerKeyAction(saAction, KeyStroke.getKeyStroke(65, 2));
        this.registerKeyAction(new TreeSelectAllAction("UNSELECT_ALL", false), KeyStroke.getKeyStroke(65, 3));
        this.registerKeyAction(new TreeAddSelectionAction("SELECT_NODE", false), KeyStroke.getKeyStroke(32, 2));
        this.registerKeyAction(new TreeExtendSelectionAction("EXTEND_SELECTION"), KeyStroke.getKeyStroke(32, 1));
        if (changeSelection) {
            this.registerKeyAction(new TreeHomeAction(1, "END", false, false), KeyStroke.getKeyStroke(35, 2));
            this.registerKeyAction(new TreeIncrementAction(-1, "UP", false, false), KeyStroke.getKeyStroke(38, 2));
            this.registerKeyAction(new TreeIncrementAction(-1, "UP", false, false), KeyStroke.getKeyStroke("ctrl KP_UP"));
            this.registerKeyAction(new TreeIncrementAction(1, "DOWN", false, false), KeyStroke.getKeyStroke(40, 2));
            this.registerKeyAction(new TreeIncrementAction(1, "DOWN", false, false), KeyStroke.getKeyStroke("ctrl KP_DOWN"));
            this.registerKeyAction(new TreePageAction(1, "LEAD_P_DOWN", false, false), KeyStroke.getKeyStroke(34, 2));
            this.registerKeyAction(new TreePageAction(-1, "LEAD_P_UP", false, false), KeyStroke.getKeyStroke(33, 2));
            this.registerKeyAction(new ScrollAction(this.tree, 0, -10), KeyStroke.getKeyStroke(37, 2));
            this.registerKeyAction(new ScrollAction(this.tree, 0, -10), KeyStroke.getKeyStroke("ctrl KP_LEFT"));
            this.registerKeyAction(new ScrollAction(this.tree, 0, 10), KeyStroke.getKeyStroke(39, 2));
            this.registerKeyAction(new ScrollAction(this.tree, 0, 10), KeyStroke.getKeyStroke("ctrl KP_RIGHT"));
            this.registerKeyAction(new TreeAddSelectionAction("SELECT_NODE", false), KeyStroke.getKeyStroke(32, 0));
        } else {
            this.registerKeyAction(new TreeScrollLRAction(1, "CTRL_P_DOWN", false), KeyStroke.getKeyStroke(34, 2));
            this.registerKeyAction(new TreeScrollLRAction(-1, "CTRL_P_UP", false), KeyStroke.getKeyStroke(33, 2));
            this.registerKeyAction(new TreeScrollLRAction(-1, "SELECT_CTRL_P_UP", true), KeyStroke.getKeyStroke(33, 3));
            this.registerKeyAction(new TreeScrollLRAction(1, "SELECT_CTRL_P_DOWN", true), KeyStroke.getKeyStroke(34, 3));
            this.registerKeyAction(new TreeAddSelectionAction("SELECT_NODE", true), KeyStroke.getKeyStroke(32, 0));
        }
    }

    protected void installComponents() {
        this.rendererPane = this.createCellRendererPane();
        if (this.rendererPane != null) {
            this.tree.add(this.rendererPane);
        }
    }

    protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
        return new NodeDimensionsHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    protected FocusListener createFocusListener() {
        return new EmptyFocusHandler();
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler();
    }

    protected PropertyChangeListener createSelectionModelPropertyChangeListener() {
        return new SelectionModelPropertyChangeHandler();
    }

    protected TreeSelectionListener createTreeSelectionListener() {
        return new TreeSelectionHandler();
    }

    protected CellEditorListener createCellEditorListener() {
        return new CellEditorHandler();
    }

    protected ComponentListener createComponentListener() {
        return new ComponentHandler();
    }

    protected TreeExpansionListener createTreeExpansionListener() {
        return new TreeExpansionHandler();
    }

    protected AbstractLayoutCache createLayoutCache() {
        if (this.isLargeModel() && this.getRowHeight() > 0) {
            return new FixedHeightLayoutCache();
        }
        return new VariableHeightLayoutCache();
    }

    protected CellRendererPane createCellRendererPane() {
        return new CellRendererPane();
    }

    protected TreeCellEditor createDefaultCellEditor() {
        if (this.currentCellRenderer != null && this.currentCellRenderer instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellEditor editor = new DefaultTreeCellEditor(this.tree, (DefaultTreeCellRenderer)this.currentCellRenderer);
            return editor;
        }
        return new DefaultTreeCellEditor(this.tree, null);
    }

    protected TreeCellRenderer createDefaultCellRenderer() {
        return new DefaultTreeCellRenderer();
    }

    protected TreeModelListener createTreeModelListener() {
        return new TreeModelHandler();
    }

    public void uninstallUI(JComponent c) {
        this.completeEditing();
        this.prepareForUIUninstall();
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallComponents();
        this.completeUIUninstall();
    }

    protected void prepareForUIUninstall() {
    }

    protected void completeUIUninstall() {
        if (this.createdRenderer) {
            this.tree.setCellRenderer(null);
        }
        if (this.createdCellEditor) {
            this.tree.setCellEditor(null);
        }
        this.cellEditor = null;
        this.currentCellRenderer = null;
        this.rendererPane = null;
        this.componentListener = null;
        this.propertyChangeListener = null;
        this.mouseListener = null;
        this.focusListener = null;
        this.keyListener = null;
        this.treeState = null;
        this.setSelectionModel(null);
        this.drawingCache = null;
        this.selectionModelPropertyChangeListener = null;
        this.tree = null;
        this.treeModel = null;
        this.treeSelectionModel = null;
        this.treeSelectionListener = null;
        this.treeExpansionListener = null;
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallListeners() {
        if (this.componentListener != null) {
            this.tree.removeComponentListener(this.componentListener);
        }
        if (this.propertyChangeListener != null) {
            this.tree.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.mouseListener != null) {
            this.tree.removeMouseListener(this.mouseListener);
        }
        if (this.focusListener != null) {
            this.tree.removeFocusListener(this.focusListener);
        }
        if (this.keyListener != null) {
            this.tree.removeKeyListener(this.keyListener);
        }
        if (this.treeExpansionListener != null) {
            this.tree.removeTreeExpansionListener(this.treeExpansionListener);
        }
        if (this.treeModel != null && this.treeModelListener != null) {
            this.treeModel.removeTreeModelListener(this.treeModelListener);
        }
        if (this.selectionModelPropertyChangeListener != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.removePropertyChangeListener(this.selectionModelPropertyChangeListener);
        }
        if (this.treeSelectionListener != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.removeTreeSelectionListener(this.treeSelectionListener);
        }
    }

    protected void uninstallKeyboardActions() {
        int counter = this.keyActions.size() - 1;
        while (counter >= 0) {
            this.tree.unregisterKeyboardAction((KeyStroke)this.keyActions.elementAt(counter));
            --counter;
        }
        this.keyActions = null;
    }

    protected void uninstallComponents() {
        if (this.rendererPane != null) {
            this.tree.remove(this.rendererPane);
        }
    }

    public void paint(Graphics g, JComponent c) {
        if (this.tree != c) {
            throw new InternalError("incorrect component");
        }
        if (this.treeState == null) {
            return;
        }
        Rectangle paintBounds = g.getClipBounds();
        Insets insets = this.tree.getInsets();
        if (insets == null) {
            insets = EMPTY_INSETS;
        }
        TreePath initialPath = this.getClosestPathForLocation(this.tree, 0, paintBounds.y);
        Enumeration<TreePath> paintingEnumerator = this.treeState.getVisiblePathsFrom(initialPath);
        int row = this.treeState.getRowForPath(initialPath);
        int endY = paintBounds.y + paintBounds.height;
        this.drawingCache.clear();
        if (initialPath != null && paintingEnumerator != null) {
            TreePath parentPath = initialPath;
            parentPath = parentPath.getParentPath();
            while (parentPath != null) {
                this.paintVerticalPartOfLeg(g, paintBounds, insets, parentPath);
                this.drawingCache.put(parentPath, Boolean.TRUE);
                parentPath = parentPath.getParentPath();
            }
            boolean done = false;
            Rectangle boundsBuffer = new Rectangle();
            boolean rootVisible = this.isRootVisible();
            while (!done && paintingEnumerator.hasMoreElements()) {
                TreePath path = paintingEnumerator.nextElement();
                if (path != null) {
                    boolean isExpanded;
                    boolean hasBeenExpanded;
                    boolean isLeaf = this.treeModel.isLeaf(path.getLastPathComponent());
                    if (isLeaf) {
                        hasBeenExpanded = false;
                        isExpanded = false;
                    } else {
                        isExpanded = this.treeState.getExpandedState(path);
                        hasBeenExpanded = this.tree.hasBeenExpanded(path);
                    }
                    Rectangle bounds = this.treeState.getBounds(path, boundsBuffer);
                    if (bounds == null) {
                        return;
                    }
                    bounds.x += insets.left;
                    bounds.y += insets.top;
                    parentPath = path.getParentPath();
                    if (parentPath != null) {
                        if (this.drawingCache.get(parentPath) == null) {
                            this.paintVerticalPartOfLeg(g, paintBounds, insets, parentPath);
                            this.drawingCache.put(parentPath, Boolean.TRUE);
                        }
                        this.paintHorizontalPartOfLeg(g, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    } else if (rootVisible && row == 0) {
                        this.paintHorizontalPartOfLeg(g, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    }
                    if (this.shouldPaintExpandControl(path, row, isExpanded, hasBeenExpanded, isLeaf)) {
                        this.paintExpandControl(g, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    }
                    this.paintRow(g, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    if (bounds.y + bounds.height >= endY) {
                        done = true;
                    }
                } else {
                    done = true;
                }
                ++row;
            }
        }
    }

    protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        int clipLeft = clipBounds.x;
        int clipRight = clipBounds.x + (clipBounds.width - 1);
        int clipTop = clipBounds.y;
        int clipBottom = clipBounds.y + (clipBounds.height - 1);
        int lineY = bounds.y + bounds.height / 2;
        int leftX = bounds.x - this.totalChildIndent + 8;
        int nodeX = bounds.x - this.getHorizontalLegBuffer();
        if (lineY > clipTop && lineY < clipBottom && nodeX > clipLeft && leftX < clipRight) {
            leftX = Math.max(leftX, clipLeft);
            nodeX = Math.min(nodeX, clipRight);
            g.setColor(this.getHashColor());
            this.paintHorizontalLine(g, this.tree, lineY, leftX, nodeX);
        }
    }

    protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
        int lineX = (path.getPathCount() - 1 + this.depthOffset) * this.totalChildIndent + 8 + insets.left;
        int clipLeft = clipBounds.x;
        int clipRight = clipBounds.x + (clipBounds.width - 1);
        if (lineX > clipLeft && lineX < clipRight) {
            Object root;
            TreeFileSystemModel model;
            int clipTop = clipBounds.y;
            int clipBottom = clipBounds.y + clipBounds.height;
            Rectangle parentBounds = this.getPathBounds(this.tree, path);
            Rectangle lastChildBounds = this.getPathBounds(this.tree, this.getLastChildPath(path));
            if (lastChildBounds == null) {
                return;
            }
            int top = parentBounds == null ? Math.max(insets.top + this.getVerticalLegBuffer(), clipTop) : Math.max(parentBounds.y + parentBounds.height + this.getVerticalLegBuffer(), clipTop);
            if (path.getPathCount() == 1 && !this.isRootVisible() && (model = this.getModel()) != null && model.getChildCount(root = model.getRoot()) > 0 && (parentBounds = this.getPathBounds(this.tree, path.pathByAddingChild(model.getChild(root, 0)))) != null) {
                top = Math.max(insets.top + this.getVerticalLegBuffer(), parentBounds.y + parentBounds.height / 2);
            }
            int bottom = Math.min(lastChildBounds.y + lastChildBounds.height / 2, clipBottom);
            g.setColor(this.getHashColor());
            this.paintVerticalLine(g, this.tree, lineX, top, bottom);
        }
    }

    protected void paintExpandControl(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        Object value = path.getLastPathComponent();
        if (!(isLeaf || hasBeenExpanded && this.treeModel.getChildCount(value) <= 0)) {
            int middleXOfKnob = bounds.x - (this.getRightChildIndent() - 1);
            int middleYOfKnob = bounds.y + bounds.height / 2;
            if (isExpanded) {
                Icon expandedIcon = this.getExpandedIcon();
                if (expandedIcon != null) {
                    this.drawCentered(this.tree, g, expandedIcon, middleXOfKnob, middleYOfKnob);
                }
            } else {
                Icon collapsedIcon = this.getCollapsedIcon();
                if (collapsedIcon != null) {
                    this.drawCentered(this.tree, g, collapsedIcon, middleXOfKnob, middleYOfKnob);
                }
            }
        }
    }

    protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (this.editingComponent != null && this.editingRow == row) {
            return;
        }
        int leadIndex = this.tree.hasFocus() ? this.getLeadRow() : -1;
        Component component = this.currentCellRenderer.getTreeCellRendererComponent(this.tree, path.getLastPathComponent(), this.tree.isRowSelected(row), isExpanded, isLeaf, row, leadIndex == row);
        this.rendererPane.paintComponent(g, component, this.tree, bounds.x, bounds.y, bounds.width, bounds.height, true);
    }

    protected boolean shouldPaintExpandControl(TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (isLeaf) {
            return false;
        }
        int depth = path.getPathCount() - 1;
        if (!this.getShowsRootHandles() && (depth == 0 || depth == 1 && !this.isRootVisible())) {
            return false;
        }
        return !this.treeModel.isEmpty(path.getLastPathComponent());
    }

    protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom) {
        g.drawLine(x, top, x, bottom);
    }

    protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right) {
        g.drawLine(left, y, right, y);
    }

    protected int getVerticalLegBuffer() {
        return 0;
    }

    protected int getHorizontalLegBuffer() {
        return 0;
    }

    protected void drawCentered(Component c, Graphics graphics, Icon icon, int x, int y) {
        icon.paintIcon(c, graphics, x - icon.getIconWidth() / 2, y - icon.getIconHeight() / 2);
    }

    protected void drawDashedHorizontalLine(Graphics g, int y, int x1, int x2) {
        x1 += x1 % 2;
        int x = x1;
        while (x <= x2) {
            g.drawLine(x, y, x, y);
            x += 2;
        }
    }

    protected void drawDashedVerticalLine(Graphics g, int x, int y1, int y2) {
        y1 += y1 % 2;
        int y = y1;
        while (y <= y2) {
            g.drawLine(x, y, x, y);
            y += 2;
        }
    }

    protected void updateLayoutCacheExpandedNodes() {
        if (this.treeModel != null) {
            this.updateExpandedDescendants(new TreePath(this.treeModel.getRoot()));
        }
    }

    protected void updateExpandedDescendants(TreePath path) {
        this.completeEditing();
        if (this.treeState != null) {
            this.treeState.setExpandedState(path, true);
            Enumeration<TreePath> descendants = this.tree.getExpandedDescendants(path);
            if (descendants != null) {
                while (descendants.hasMoreElements()) {
                    path = descendants.nextElement();
                    this.treeState.setExpandedState(path, true);
                }
            }
            this.setLeadPath(path);
            this.updateSize();
        }
    }

    protected TreePath getLastChildPath(TreePath parent) {
        int childCount;
        if (this.treeModel != null && (childCount = this.treeModel.getChildCount(parent.getLastPathComponent())) > 0) {
            return parent.pathByAddingChild(this.treeModel.getChild(parent.getLastPathComponent(), childCount - 1));
        }
        return null;
    }

    protected void updateDepthOffset() {
        this.depthOffset = this.isRootVisible() ? (this.getShowsRootHandles() ? 1 : 0) : (!this.getShowsRootHandles() ? -1 : 0);
    }

    protected void updateCellEditor() {
        TreeCellEditor newEditor;
        this.completeEditing();
        if (this.tree == null) {
            newEditor = null;
        } else if (this.tree.isEditable()) {
            newEditor = this.tree.getCellEditor();
            if (newEditor == null && (newEditor = this.createDefaultCellEditor()) != null) {
                this.tree.setCellEditor(newEditor);
                this.createdCellEditor = true;
            }
        } else {
            newEditor = null;
        }
        if (newEditor != this.cellEditor) {
            if (this.cellEditor != null && this.cellEditorListener != null) {
                this.cellEditor.removeCellEditorListener(this.cellEditorListener);
            }
            this.cellEditor = newEditor;
            if (this.cellEditorListener == null) {
                this.cellEditorListener = this.createCellEditorListener();
            }
            if (newEditor != null && this.cellEditorListener != null) {
                newEditor.addCellEditorListener(this.cellEditorListener);
            }
            this.createdCellEditor = false;
        }
    }

    protected void updateRenderer() {
        if (this.tree != null) {
            TreeCellRenderer newCellRenderer = this.tree.getCellRenderer();
            if (newCellRenderer == null) {
                this.tree.setCellRenderer(this.createDefaultCellRenderer());
                this.createdRenderer = true;
            } else {
                this.createdRenderer = false;
                this.currentCellRenderer = newCellRenderer;
                if (this.createdCellEditor) {
                    this.tree.setCellEditor(null);
                }
            }
        } else {
            this.createdRenderer = false;
            this.currentCellRenderer = null;
        }
        this.updateCellEditor();
    }

    protected void configureLayoutCache() {
        if (this.treeState != null && this.tree != null) {
            if (this.nodeDimensions == null) {
                this.nodeDimensions = this.createNodeDimensions();
            }
            this.treeState.setNodeDimensions(this.nodeDimensions);
            this.treeState.setRootVisible(this.tree.isRootVisible());
            this.treeState.setRowHeight(this.tree.getRowHeight());
            this.treeState.setSelectionModel(this.getSelectionModel());
            if (this.treeState.getModel() != this.tree.getModel()) {
                this.treeState.setModel((TreeFileSystemModel)this.tree.getModel());
            }
            this.updateLayoutCacheExpandedNodes();
            if (this.isLargeModel()) {
                if (this.componentListener == null) {
                    this.componentListener = this.createComponentListener();
                    if (this.componentListener != null) {
                        this.tree.addComponentListener(this.componentListener);
                    }
                }
            } else if (this.componentListener != null) {
                this.tree.removeComponentListener(this.componentListener);
                this.componentListener = null;
            }
        } else if (this.componentListener != null) {
            this.tree.removeComponentListener(this.componentListener);
            this.componentListener = null;
        }
    }

    protected void updateSize() {
        this.validCachedPreferredSize = false;
        this.tree.treeDidChange();
    }

    protected void updateCachedPreferredSize() {
        if (this.treeState != null) {
            Insets i = this.tree.getInsets();
            if (this.isLargeModel()) {
                Rectangle visRect = this.tree.getVisibleRect();
                if (i != null) {
                    visRect.x -= i.left;
                    visRect.y -= i.top;
                }
                this.preferredSize.width = this.treeState.getPreferredWidth(visRect);
            } else {
                this.preferredSize.width = this.treeState.getPreferredWidth(null);
            }
            this.preferredSize.height = this.treeState.getPreferredHeight();
            if (i != null) {
                this.preferredSize.width += i.left + i.right;
                this.preferredSize.height += i.top + i.bottom;
            }
        }
        this.validCachedPreferredSize = true;
    }

    protected void pathWasExpanded(TreePath path) {
        if (this.tree != null) {
            this.tree.fireTreeExpanded(path);
        }
    }

    protected void pathWasCollapsed(TreePath path) {
        if (this.tree != null) {
            this.tree.fireTreeCollapsed(path);
        }
    }

    protected void ensureRowsAreVisible(int beginRow, int endRow) {
        if (this.tree != null && beginRow >= 0 && endRow < this.getRowCount(this.tree)) {
            if (beginRow == endRow) {
                Rectangle scrollBounds = this.getPathBounds(this.tree, this.getPathForRow(this.tree, beginRow));
                if (scrollBounds != null) {
                    scrollBounds.width += scrollBounds.x;
                    scrollBounds.x = 0;
                    this.tree.scrollRectToVisible(scrollBounds);
                }
            } else {
                Rectangle beginRect = this.getPathBounds(this.tree, this.getPathForRow(this.tree, beginRow));
                Rectangle visRect = this.tree.getVisibleRect();
                Rectangle testRect = beginRect;
                int beginY = beginRect.y;
                int maxY = beginY + visRect.height;
                int counter = beginRow + 1;
                while (counter <= endRow) {
                    testRect = this.getPathBounds(this.tree, this.getPathForRow(this.tree, counter));
                    if (testRect.y + testRect.height > maxY) {
                        counter = endRow;
                    }
                    ++counter;
                }
                this.tree.scrollRectToVisible(new Rectangle(visRect.x, beginY, 1, testRect.y + testRect.height - beginY));
            }
        }
    }

    public void setPreferredMinSize(Dimension newSize) {
        this.preferredMinSize = newSize;
    }

    public Dimension getPreferredMinSize() {
        if (this.preferredMinSize == null) {
            return null;
        }
        return new Dimension(this.preferredMinSize);
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.getPreferredSize(c, true);
    }

    public Dimension getPreferredSize(JComponent c, boolean checkConsistancy) {
        Dimension pSize = this.getPreferredMinSize();
        if (!this.validCachedPreferredSize) {
            this.updateCachedPreferredSize();
        }
        if (this.tree != null) {
            if (pSize != null) {
                return new Dimension(Math.max(pSize.width, this.preferredSize.width), Math.max(pSize.height, this.preferredSize.height));
            }
            return new Dimension(this.preferredSize.width, this.preferredSize.height);
        }
        if (pSize != null) {
            return pSize;
        }
        return new Dimension(0, 0);
    }

    public Dimension getMinimumSize(JComponent c) {
        if (this.getPreferredMinSize() != null) {
            return this.getPreferredMinSize();
        }
        return new Dimension(0, 0);
    }

    public Dimension getMaximumSize(JComponent c) {
        if (this.tree != null) {
            return this.getPreferredSize(this.tree);
        }
        if (this.getPreferredMinSize() != null) {
            return this.getPreferredMinSize();
        }
        return new Dimension(0, 0);
    }

    protected void completeEditing() {
        if (this.tree.getInvokesStopCellEditing() && this.stopEditingInCompleteEditing && this.editingComponent != null) {
            this.cellEditor.stopCellEditing();
        }
        this.completeEditing(false, true, false);
    }

    protected void completeEditing(boolean messageStop, boolean messageCancel, boolean messageTree) {
        if (this.stopEditingInCompleteEditing && this.editingComponent != null) {
            Component oldComponent = this.editingComponent;
            TreePath oldPath = this.editingPath;
            TreeCellEditor oldEditor = this.cellEditor;
            Object newValue = oldEditor.getCellEditorValue();
            Rectangle editingBounds = this.getPathBounds(this.tree, this.editingPath);
            boolean requestFocus = this.tree != null && (this.tree.hasFocus() || SwingUtilities.findFocusOwner(this.editingComponent) != null);
            this.editingComponent = null;
            this.editingPath = null;
            if (messageStop) {
                oldEditor.stopCellEditing();
            } else if (messageCancel) {
                oldEditor.cancelCellEditing();
            }
            this.tree.remove(oldComponent);
            if (this.editorHasDifferentSize) {
                this.treeState.invalidatePathBounds(oldPath);
                this.updateSize();
            } else {
                editingBounds.x = 0;
                editingBounds.width = this.tree.getSize().width;
                this.tree.repaint(editingBounds);
            }
            if (requestFocus) {
                this.tree.requestFocus();
            }
            if (messageTree) {
                this.treeModel.valueForPathChanged(oldPath, newValue);
            }
        }
    }

    protected boolean startEditing(TreePath path, MouseEvent event) {
        this.completeEditing();
        if (this.cellEditor != null && this.tree.isPathEditable(path)) {
            int row = this.getRowForPath(this.tree, path);
            this.editingComponent = this.cellEditor.getTreeCellEditorComponent(this.tree, path.getLastPathComponent(), this.tree.isPathSelected(path), this.tree.isExpanded(path), this.treeModel.isLeaf(path.getLastPathComponent()), row);
            if (this.cellEditor.isCellEditable(event)) {
                Rectangle nodeBounds = this.getPathBounds(this.tree, path);
                this.editingRow = row;
                Dimension editorSize = this.editingComponent.getPreferredSize();
                if (editorSize.height != nodeBounds.height && this.getRowHeight() > 0) {
                    editorSize.height = this.getRowHeight();
                }
                if (editorSize.width != nodeBounds.width || editorSize.height != nodeBounds.height) {
                    this.editorHasDifferentSize = true;
                    this.treeState.invalidatePathBounds(path);
                    this.updateSize();
                } else {
                    this.editorHasDifferentSize = false;
                }
                this.editingComponent.setBounds(nodeBounds.x, nodeBounds.y, editorSize.width, editorSize.height);
                this.tree.add(this.editingComponent);
                this.editingComponent.validate();
                this.editingComponent.requestFocus();
                this.editingPath = path;
                Rectangle visRect = this.tree.getVisibleRect();
                this.tree.paintImmediately(nodeBounds.x, nodeBounds.y, visRect.width + visRect.x - nodeBounds.x, editorSize.height);
                if (this.cellEditor.shouldSelectCell(event)) {
                    this.stopEditingInCompleteEditing = false;
                    try {
                        this.tree.setSelectionRow(row);
                    }
                    catch (Exception e) {
                        System.err.println("Editing exception: " + e);
                    }
                    this.stopEditingInCompleteEditing = true;
                }
                if (event != null && event instanceof MouseEvent) {
                    Point componentPoint = SwingUtilities.convertPoint(this.tree, new Point(event.getX(), event.getY()), this.editingComponent);
                    new MouseInputHandler(this.tree, SwingUtilities.getDeepestComponentAt(this.editingComponent, componentPoint.x, componentPoint.y), event);
                }
                return true;
            }
            this.editingComponent = null;
        }
        return false;
    }

    protected void checkForClickInExpandControl(TreePath path, int mouseX, int mouseY) {
        if (this.isLocationInExpandControl(path, mouseX, mouseY)) {
            this.handleExpandControlClick(path, mouseX, mouseY);
        }
    }

    public boolean isLocationInExpandControl(TreePath path, int mouseX, int mouseY) {
        if (path != null && !this.treeModel.isLeaf(path.getLastPathComponent())) {
            Insets i = this.tree.getInsets();
            int boxWidth = this.getExpandedIcon() != null ? this.getExpandedIcon().getIconWidth() : 8;
            int boxLeftX = i != null ? i.left : 0;
            int boxRightX = (boxLeftX += (path.getPathCount() + this.depthOffset - 2) * this.totalChildIndent + this.getLeftChildIndent() - boxWidth / 2) + boxWidth;
            return mouseX >= boxLeftX && mouseX <= boxRightX;
        }
        return false;
    }

    protected void handleExpandControlClick(TreePath path, int mouseX, int mouseY) {
        this.toggleExpandState(path);
    }

    protected void toggleExpandState(TreePath path) {
        if (!this.tree.isExpanded(path)) {
            int row = this.getRowForPath(this.tree, path);
            this.tree.expandPath(path);
            this.updateSize();
            if (row != -1) {
                if (this.tree.getScrollsOnExpand()) {
                    this.ensureRowsAreVisible(row, row + this.treeState.getVisibleChildCount(path));
                } else {
                    this.ensureRowsAreVisible(row, row);
                }
            }
        } else {
            this.tree.collapsePath(path);
            this.updateSize();
        }
    }

    protected boolean isToggleSelectionEvent(MouseEvent event) {
        return SwingUtilities.isLeftMouseButton(event) && event.isControlDown();
    }

    protected boolean isMultiSelectEvent(MouseEvent event) {
        return SwingUtilities.isLeftMouseButton(event) && event.isShiftDown();
    }

    protected boolean isToggleEvent(MouseEvent event) {
        if (!SwingUtilities.isLeftMouseButton(event)) {
            return false;
        }
        int clickCount = 2;
        if (clickCount <= 0) {
            return false;
        }
        return event.getClickCount() == clickCount;
    }

    protected void selectPathForEvent(TreePath path, MouseEvent event) {
        FileNode leadNode = (FileNode)path.getLastPathComponent();
        if (this.isToggleSelectionEvent(event) & leadNode.isLeaf()) {
            if (this.tree.isPathSelected(path)) {
                this.tree.removeSelectionPath(path);
            } else {
                this.tree.addSelectionPath(path);
            }
            this.lastSelectedRow = this.getRowForPath(this.tree, path);
            this.setAnchorPath(path);
            this.setLeadPath(path);
        } else if (this.isMultiSelectEvent(event) & leadNode.isLeaf()) {
            FileNode leadParent = (FileNode)leadNode.getParent();
            int newIndex = this.getRowForPath(this.tree, path);
            TreePath anchorPath = this.getAnchorPath();
            if (anchorPath != null) {
                FileNode anchorNode = (FileNode)anchorPath.getLastPathComponent();
                FileNode anchorParent = (FileNode)anchorNode.getParent();
                if (!anchorNode.isLeaf() || !anchorParent.equals(leadParent)) {
                    anchorNode = (FileNode)leadParent.getFirstLeaf();
                }
                anchorPath = anchorNode != null ? new TreePath(anchorNode.getPath()) : null;
            } else {
                FileNode anchorNode = (FileNode)leadParent.getFirstLeaf();
                if (anchorNode != null) {
                    anchorPath = new TreePath(anchorNode.getPath());
                }
            }
            int anchorRow = -1;
            if (anchorPath != null) {
                anchorRow = this.getRowForPath(this.tree, anchorPath);
                this.tree.setSelectionPath(anchorPath);
            }
            if (anchorRow > -1) {
                if (anchorRow < newIndex) {
                    this.tree.setSelectionInterval(anchorRow, newIndex);
                } else {
                    this.tree.setSelectionInterval(newIndex, anchorRow);
                }
            }
            this.setAnchorPath(anchorPath);
            this.setLeadPath(path);
        } else if (SwingUtilities.isLeftMouseButton(event)) {
            this.tree.setSelectionPath(path);
            this.setAnchorPath(path);
            this.setLeadPath(path);
            if (this.isToggleEvent(event)) {
                this.toggleExpandState(path);
            }
        }
    }

    protected boolean isLeaf(int row) {
        TreePath path = this.getPathForRow(this.tree, row);
        if (path != null) {
            return this.treeModel.isLeaf(path.getLastPathComponent());
        }
        return true;
    }

    private void setAnchorPath(TreePath newPath) {
        this.anchorPath = newPath;
    }

    private TreePath getAnchorPath() {
        return this.anchorPath;
    }

    private void setLeadPath(TreePath newPath) {
        this.setLeadPath(newPath, false);
    }

    private void setLeadPath(TreePath newPath, boolean repaint) {
        Rectangle bounds = repaint ? this.getPathBounds(this.tree, this.leadPath) : null;
        this.leadPath = newPath;
        this.leadRow = this.getRowForPath(this.tree, this.leadPath);
        if (repaint) {
            if (bounds != null) {
                this.tree.repaint(bounds);
            }
            if ((bounds = this.getPathBounds(this.tree, this.leadPath)) != null) {
                this.tree.repaint(bounds);
            }
        }
    }

    private TreePath getLeadPath() {
        return this.leadPath;
    }

    private void updateLeadRow() {
        this.leadRow = this.getRowForPath(this.tree, this.leadPath);
    }

    private int getLeadRow() {
        return this.leadRow;
    }

    private boolean changeSelectionWithFocus() {
        return this.changeSelectionWithFocus;
    }

    private void extendSelection(TreePath newLead, int direction) {
        FileNode leadNode = (FileNode)newLead.getLastPathComponent();
        FileNode leadParent = (FileNode)leadNode.getParent();
        int newIndex = this.getRowForPath(this.tree, newLead);
        TreePath anchorPath = this.getAnchorPath();
        FileNode anchorNode = null;
        if (anchorPath != null) {
            anchorNode = (FileNode)anchorPath.getLastPathComponent();
            FileNode anchorParent = (FileNode)anchorNode.getParent();
            if (!anchorNode.isLeaf() || !anchorParent.equals(leadParent)) {
                if (leadParent != null) {
                    anchorNode = direction == 1 ? (FileNode)leadParent.getFirstLeaf() : (FileNode)leadParent.getLastLeaf();
                }
                anchorPath = anchorNode != null ? new TreePath(anchorNode.getPath()) : null;
            }
        } else {
            anchorNode = direction == 1 ? (FileNode)leadParent.getFirstLeaf() : (FileNode)leadParent.getLastLeaf();
            if (anchorNode != null) {
                anchorPath = new TreePath(anchorNode.getPath());
            }
        }
        int anchorRow = -1;
        if (anchorPath != null) {
            anchorRow = this.getRowForPath(this.tree, anchorPath);
            this.tree.setSelectionPath(anchorPath);
        }
        if (!leadNode.isLeaf() || anchorRow == -1) {
            this.tree.setSelectionInterval(newIndex, newIndex);
            this.setAnchorPath(newLead);
            this.setLeadPath(newLead);
        } else if (leadNode.isLeaf()) {
            if (anchorRow < newIndex) {
                this.tree.setSelectionInterval(anchorRow, newIndex);
            } else {
                this.tree.setSelectionInterval(newIndex, anchorRow);
            }
            this.setAnchorPath(anchorPath);
            this.setLeadPath(newLead);
        }
    }

    class MouseInputHandler
    implements MouseInputListener {
        protected Component source;
        protected Component destination;

        public MouseInputHandler(Component source, Component destination, MouseEvent event) {
            this.source = source;
            this.destination = destination;
            this.source.addMouseListener(this);
            this.source.addMouseMotionListener(this);
            destination.dispatchEvent(SwingUtilities.convertMouseEvent(source, event, destination));
        }

        public void mouseClicked(MouseEvent e) {
            if (this.destination != null) {
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, e, this.destination));
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            if (this.destination != null) {
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, e, this.destination));
            }
            this.removeFromSource();
        }

        public void mouseEntered(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                this.removeFromSource();
            }
        }

        public void mouseExited(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                this.removeFromSource();
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (this.destination != null) {
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, e, this.destination));
            }
        }

        public void mouseMoved(MouseEvent e) {
            this.removeFromSource();
        }

        protected void removeFromSource() {
            if (this.source != null) {
                this.source.removeMouseListener(this);
                this.source.removeMouseMotionListener(this);
            }
            this.destination = null;
            this.source = null;
        }
    }

    private class TreeExtendSelectionAction
    implements ActionListener {
        public TreeExtendSelectionAction(String name) {
        }

        public void actionPerformed(ActionEvent ae) {
            if (BasicPaneTreeUI.this.tree != null && BasicPaneTreeUI.this.getRowCount(BasicPaneTreeUI.this.tree) > 0) {
                int newIndex = BasicPaneTreeUI.this.getLeadRow();
                TreePath newLead = BasicPaneTreeUI.this.getPathForRow(BasicPaneTreeUI.this.tree, newIndex);
                FileNode leadNode = (FileNode)newLead.getLastPathComponent();
                FileNode leadParent = (FileNode)leadNode.getParent();
                TreePath anchorPath = BasicPaneTreeUI.this.getAnchorPath();
                FileNode anchorNode = null;
                if (anchorPath != null) {
                    anchorNode = (FileNode)anchorPath.getLastPathComponent();
                    FileNode anchorParent = (FileNode)anchorNode.getParent();
                    if (!anchorNode.isLeaf() || !anchorParent.equals(leadParent)) {
                        if (leadParent != null) {
                            anchorNode = (FileNode)leadParent.getFirstLeaf();
                        }
                        anchorPath = anchorNode != null ? new TreePath(anchorNode.getPath()) : null;
                    }
                } else {
                    anchorNode = (FileNode)leadParent.getFirstLeaf();
                    if (anchorNode != null) {
                        anchorPath = new TreePath(anchorNode.getPath());
                    }
                }
                int anchorRow = -1;
                if (anchorPath != null) {
                    anchorRow = BasicPaneTreeUI.this.getRowForPath(BasicPaneTreeUI.this.tree, anchorPath);
                    BasicPaneTreeUI.this.tree.setSelectionPath(anchorPath);
                }
                if (leadNode.isLeaf()) {
                    if (anchorRow < newIndex) {
                        BasicPaneTreeUI.this.tree.setSelectionInterval(anchorRow, newIndex);
                    } else {
                        BasicPaneTreeUI.this.tree.setSelectionInterval(newIndex, anchorRow);
                    }
                    BasicPaneTreeUI.this.setAnchorPath(anchorPath);
                    BasicPaneTreeUI.this.setLeadPath(newLead);
                }
            }
        }

        public boolean isEnabled() {
            return BasicPaneTreeUI.this.tree != null && BasicPaneTreeUI.this.tree.isEnabled();
        }
    }

    private class TreeAddSelectionAction
    implements ActionListener {
        private boolean changeAnchor;

        public TreeAddSelectionAction(String name, boolean changeAnchor) {
            this.changeAnchor = changeAnchor;
        }

        public void actionPerformed(ActionEvent ae) {
            if (BasicPaneTreeUI.this.tree != null && BasicPaneTreeUI.this.getRowCount(BasicPaneTreeUI.this.tree) > 0) {
                FileNode leadNode;
                int lead = BasicPaneTreeUI.this.getLeadRow();
                TreePath anchorPath = BasicPaneTreeUI.this.getAnchorPath();
                TreePath leadPath = BasicPaneTreeUI.this.getLeadPath();
                if (lead <= -1) {
                    FileNode parentNode;
                    if (anchorPath != null) {
                        FileNode anchorNode = (FileNode)anchorPath.getLastPathComponent();
                        parentNode = (FileNode)anchorNode.getParent();
                    } else {
                        parentNode = BasicPaneTreeUI.this.treeModel.getCurrentNode();
                    }
                    leadNode = (FileNode)parentNode.getFirstLeaf();
                    leadPath = new TreePath(leadNode.getPath());
                    lead = BasicPaneTreeUI.this.getRowForPath(BasicPaneTreeUI.this.tree, leadPath);
                } else {
                    leadNode = (FileNode)leadPath.getLastPathComponent();
                }
                if (!this.changeAnchor && leadNode.isLeaf()) {
                    if (BasicPaneTreeUI.this.tree.isRowSelected(lead)) {
                        BasicPaneTreeUI.this.tree.removeSelectionRow(lead);
                    } else if (lead > -1) {
                        BasicPaneTreeUI.this.tree.addSelectionRow(lead);
                    }
                } else if (lead > -1) {
                    BasicPaneTreeUI.this.tree.setSelectionRow(lead);
                }
                BasicPaneTreeUI.this.setAnchorPath(anchorPath);
                BasicPaneTreeUI.this.setLeadPath(leadPath);
            }
        }

        public boolean isEnabled() {
            return BasicPaneTreeUI.this.tree != null && BasicPaneTreeUI.this.tree.isEnabled();
        }
    }

    private class TreeSelectAllAction
    implements ActionListener {
        private boolean selectAll;

        public TreeSelectAllAction(String name, boolean selectAll) {
            this.selectAll = selectAll;
        }

        public void actionPerformed(ActionEvent ae) {
            if (this.selectAll) {
                TreePath currentPath = BasicPaneTreeUI.this.treeModel.getCurrentPath();
                BasicPaneTreeUI.this.tree.expandPath(currentPath);
                FileNode currentNode = BasicPaneTreeUI.this.treeModel.getCurrentNode();
                if (currentNode.getFileChildCount() > 0) {
                    FileNode firstNode = (FileNode)currentNode.getFirstLeaf();
                    FileNode lastNode = (FileNode)currentNode.getLastLeaf();
                    TreePath anchorPath = new TreePath(firstNode.getPath());
                    TreePath leadPath = new TreePath(lastNode.getPath());
                    BasicPaneTreeUI.this.tree.setSelectionInterval(BasicPaneTreeUI.this.getRowForPath(BasicPaneTreeUI.this.tree, anchorPath), BasicPaneTreeUI.this.getRowForPath(BasicPaneTreeUI.this.tree, leadPath));
                    BasicPaneTreeUI.this.setAnchorPath(anchorPath);
                    BasicPaneTreeUI.this.setLeadPath(leadPath);
                }
            } else {
                TreePath lastPath = BasicPaneTreeUI.this.getLeadPath();
                TreePath aPath = BasicPaneTreeUI.this.getAnchorPath();
                BasicPaneTreeUI.this.tree.clearSelection();
                BasicPaneTreeUI.this.setAnchorPath(aPath);
                BasicPaneTreeUI.this.setLeadPath(lastPath);
            }
        }

        public boolean isEnabled() {
            return BasicPaneTreeUI.this.tree != null && BasicPaneTreeUI.this.tree.isEnabled();
        }
    }

    private class TreeEditAction
    implements ActionListener {
        public TreeEditAction(String name) {
        }

        public void actionPerformed(ActionEvent ae) {
            if (BasicPaneTreeUI.this.tree != null && BasicPaneTreeUI.this.tree.isEnabled()) {
                int editRow;
                TreePath lead = BasicPaneTreeUI.this.getLeadPath();
                int n = editRow = lead != null ? BasicPaneTreeUI.this.getRowForPath(BasicPaneTreeUI.this.tree, lead) : -1;
                if (editRow != -1) {
                    BasicPaneTreeUI.this.tree.startEditingAtPath(lead);
                }
            }
        }

        public boolean isEnabled() {
            return BasicPaneTreeUI.this.tree != null && BasicPaneTreeUI.this.tree.isEnabled();
        }
    }

    class TreeCancelEditingAction
    implements ActionListener {
        public TreeCancelEditingAction(String name) {
        }

        public void actionPerformed(ActionEvent e) {
            if (BasicPaneTreeUI.this.tree != null) {
                BasicPaneTreeUI.this.tree.cancelEditing();
            }
        }

        public boolean isEnabled() {
            return BasicPaneTreeUI.this.tree != null && BasicPaneTreeUI.this.tree.isEnabled();
        }
    }

    private static class ScrollAction
    implements ActionListener {
        private JComponent component;
        private int direction;
        private int amount;

        public ScrollAction(JComponent component, int direction, int amount) {
            this.component = component;
            this.direction = direction;
            this.amount = amount;
        }

        public void actionPerformed(ActionEvent e) {
            Rectangle visRect = this.component.getVisibleRect();
            Dimension size = this.component.getSize();
            if (this.direction == 0) {
                visRect.x += this.amount;
                visRect.x = Math.max(0, visRect.x);
                visRect.x = Math.min(Math.max(0, size.width - visRect.width), visRect.x);
            } else {
                visRect.y += this.amount;
                visRect.y = Math.max(0, visRect.y);
                visRect.y = Math.min(Math.max(0, size.width - visRect.height), visRect.y);
            }
            this.component.scrollRectToVisible(visRect);
        }

        public boolean isEnabled() {
            return true;
        }
    }

    class TreeToggleAction
    implements ActionListener {
        public TreeToggleAction(String name) {
        }

        public void actionPerformed(ActionEvent e) {
            int selRow;
            if (BasicPaneTreeUI.this.tree != null && (selRow = BasicPaneTreeUI.this.getLeadRow()) != -1 && !BasicPaneTreeUI.this.isLeaf(selRow)) {
                TreePath aPath = BasicPaneTreeUI.this.getAnchorPath();
                TreePath lPath = BasicPaneTreeUI.this.getLeadPath();
                BasicPaneTreeUI.this.toggleExpandState(BasicPaneTreeUI.this.getPathForRow(BasicPaneTreeUI.this.tree, selRow));
                BasicPaneTreeUI.this.setAnchorPath(aPath);
                BasicPaneTreeUI.this.setLeadPath(lPath);
            }
        }

        public boolean isEnabled() {
            return BasicPaneTreeUI.this.tree != null && BasicPaneTreeUI.this.tree.isEnabled();
        }
    }

    class TreeHomeAction
    implements ActionListener {
        protected int direction;
        private boolean addToSelection;
        private boolean changeSelection;

        public TreeHomeAction(int direction, String name) {
            this(direction, name, false, true);
        }

        public TreeHomeAction(int direction, String name, boolean addToSelection, boolean changeSelection) {
            this.direction = direction;
            this.changeSelection = changeSelection;
            this.addToSelection = addToSelection;
        }

        public void actionPerformed(ActionEvent e) {
            int rowCount = BasicPaneTreeUI.this.getRowCount(BasicPaneTreeUI.this.tree);
            if (BasicPaneTreeUI.this.tree != null && rowCount > 0) {
                if (this.direction == -1) {
                    BasicPaneTreeUI.this.ensureRowsAreVisible(0, 0);
                    if (this.addToSelection) {
                        int aRow;
                        TreePath aPath = BasicPaneTreeUI.this.getAnchorPath();
                        int n = aRow = aPath == null ? -1 : BasicPaneTreeUI.this.getRowForPath(BasicPaneTreeUI.this.tree, aPath);
                        if (aRow == -1) {
                            BasicPaneTreeUI.this.tree.setSelectionInterval(0, 0);
                        } else {
                            BasicPaneTreeUI.this.tree.setSelectionInterval(0, aRow);
                            BasicPaneTreeUI.this.setAnchorPath(BasicPaneTreeUI.this.getPathForRow(BasicPaneTreeUI.this.tree, 0));
                            BasicPaneTreeUI.this.setLeadPath(BasicPaneTreeUI.this.getPathForRow(BasicPaneTreeUI.this.tree, 0));
                        }
                    } else if (this.changeSelection) {
                        BasicPaneTreeUI.this.tree.setSelectionInterval(0, 0);
                        BasicPaneTreeUI.this.setAnchorPath(BasicPaneTreeUI.this.getPathForRow(BasicPaneTreeUI.this.tree, 0));
                        BasicPaneTreeUI.this.setLeadPath(BasicPaneTreeUI.this.getPathForRow(BasicPaneTreeUI.this.tree, 0));
                    } else {
                        BasicPaneTreeUI.this.setLeadPath(BasicPaneTreeUI.this.getPathForRow(BasicPaneTreeUI.this.tree, 0), true);
                    }
                } else {
                    BasicPaneTreeUI.this.ensureRowsAreVisible(rowCount - 1, rowCount - 1);
                    if (this.addToSelection) {
                        int aRow;
                        TreePath aPath = BasicPaneTreeUI.this.getAnchorPath();
                        int n = aRow = aPath == null ? -1 : BasicPaneTreeUI.this.getRowForPath(BasicPaneTreeUI.this.tree, aPath);
                        if (aRow == -1) {
                            BasicPaneTreeUI.this.tree.setSelectionInterval(rowCount - 1, rowCount - 1);
                        } else {
                            BasicPaneTreeUI.this.tree.setSelectionInterval(aRow, rowCount - 1);
                            BasicPaneTreeUI.this.setAnchorPath(BasicPaneTreeUI.this.getPathForRow(BasicPaneTreeUI.this.tree, rowCount - 1));
                            BasicPaneTreeUI.this.setLeadPath(BasicPaneTreeUI.this.getPathForRow(BasicPaneTreeUI.this.tree, rowCount - 1));
                        }
                    } else if (this.changeSelection) {
                        BasicPaneTreeUI.this.tree.setSelectionInterval(rowCount - 1, rowCount - 1);
                        BasicPaneTreeUI.this.setAnchorPath(BasicPaneTreeUI.this.getPathForRow(BasicPaneTreeUI.this.tree, rowCount - 1));
                        BasicPaneTreeUI.this.setLeadPath(BasicPaneTreeUI.this.getPathForRow(BasicPaneTreeUI.this.tree, rowCount - 1));
                    } else {
                        BasicPaneTreeUI.this.setLeadPath(BasicPaneTreeUI.this.getPathForRow(BasicPaneTreeUI.this.tree, rowCount - 1), true);
                    }
                }
            }
        }

        public boolean isEnabled() {
            return BasicPaneTreeUI.this.tree != null && BasicPaneTreeUI.this.tree.isEnabled();
        }
    }

    class TreeIncrementAction
    implements ActionListener {
        protected int direction;
        private boolean addToSelection;
        private boolean changeSelection;
        private boolean modeBuffer;

        public TreeIncrementAction(int direction, String name) {
            this(direction, name, false, true);
        }

        public TreeIncrementAction(int direction, String name, boolean addToSelection, boolean changeSelection) {
            this.direction = direction;
            this.addToSelection = addToSelection;
            this.changeSelection = changeSelection;
            this.modeBuffer = addToSelection;
        }

        public void actionPerformed(ActionEvent e) {
            int rowCount;
            if (BasicPaneTreeUI.this.tree != null && BasicPaneTreeUI.this.treeSelectionModel != null && (rowCount = BasicPaneTreeUI.this.getRowCount(BasicPaneTreeUI.this.tree)) > 0) {
                int selIndex = BasicPaneTreeUI.this.getLeadRow();
                int newIndex = selIndex == -1 ? (this.direction == 1 ? 0 : rowCount - 1) : Math.min(rowCount - 1, Math.max(0, selIndex + this.direction));
                TreePath newPath = BasicPaneTreeUI.this.getPathForRow(BasicPaneTreeUI.this.tree, newIndex);
                FileNode newNode = (FileNode)newPath.getLastPathComponent();
                this.addToSelection = !newNode.isLeaf() ? false : this.modeBuffer;
                if (this.addToSelection) {
                    BasicPaneTreeUI.this.extendSelection(BasicPaneTreeUI.this.getPathForRow(BasicPaneTreeUI.this.tree, newIndex), this.direction);
                } else if (this.changeSelection) {
                    BasicPaneTreeUI.this.tree.setSelectionInterval(newIndex, newIndex);
                    BasicPaneTreeUI.this.setAnchorPath(BasicPaneTreeUI.this.getPathForRow(BasicPaneTreeUI.this.tree, newIndex));
                    BasicPaneTreeUI.this.setLeadPath(BasicPaneTreeUI.this.getPathForRow(BasicPaneTreeUI.this.tree, newIndex));
                } else {
                    BasicPaneTreeUI.this.setLeadPath(BasicPaneTreeUI.this.getPathForRow(BasicPaneTreeUI.this.tree, newIndex), true);
                }
                BasicPaneTreeUI.this.ensureRowsAreVisible(newIndex, newIndex);
                BasicPaneTreeUI.this.lastSelectedRow = newIndex;
            }
        }

        public boolean isEnabled() {
            return BasicPaneTreeUI.this.tree != null && BasicPaneTreeUI.this.tree.isEnabled();
        }
    }

    private class TreeScrollLRAction
    implements ActionListener {
        protected int direction;
        private boolean addToSelection;
        private boolean modeBuffer;

        public TreeScrollLRAction(int direction, String name, boolean addToSelection) {
            this.direction = direction;
            this.addToSelection = addToSelection;
            this.modeBuffer = addToSelection;
        }

        public void actionPerformed(ActionEvent e) {
            int rowCount;
            if (BasicPaneTreeUI.this.tree != null && (rowCount = BasicPaneTreeUI.this.getRowCount(BasicPaneTreeUI.this.tree)) > 0 && BasicPaneTreeUI.this.treeSelectionModel != null) {
                TreePath newPath;
                Rectangle visRect = BasicPaneTreeUI.this.tree.getVisibleRect();
                if (this.direction == -1) {
                    newPath = BasicPaneTreeUI.this.getClosestPathForLocation(BasicPaneTreeUI.this.tree, visRect.x, visRect.y);
                    visRect.x = Math.max(0, visRect.x - visRect.width);
                } else {
                    visRect.x = Math.min(Math.max(0, BasicPaneTreeUI.this.tree.getWidth() - visRect.width), visRect.x + visRect.width);
                    newPath = BasicPaneTreeUI.this.getClosestPathForLocation(BasicPaneTreeUI.this.tree, visRect.x, visRect.y + visRect.height);
                }
                FileNode newNode = (FileNode)newPath.getLastPathComponent();
                this.addToSelection = !newNode.isLeaf() ? false : this.modeBuffer;
                BasicPaneTreeUI.this.tree.scrollRectToVisible(visRect);
                if (this.addToSelection) {
                    BasicPaneTreeUI.this.extendSelection(newPath, this.direction);
                } else if (BasicPaneTreeUI.this.changeSelectionWithFocus()) {
                    BasicPaneTreeUI.this.tree.setSelectionPath(newPath);
                    BasicPaneTreeUI.this.setAnchorPath(newPath);
                    BasicPaneTreeUI.this.setLeadPath(newPath);
                } else {
                    BasicPaneTreeUI.this.setLeadPath(newPath, true);
                }
            }
        }

        public boolean isEnabled() {
            return BasicPaneTreeUI.this.tree != null && BasicPaneTreeUI.this.tree.isEnabled();
        }
    }

    class TreePageAction
    implements ActionListener {
        protected int direction;
        private boolean addToSelection;
        private boolean changeSelection;
        private boolean modeBuffer;

        public TreePageAction(int direction, String name) {
            this(direction, name, false, true);
        }

        public TreePageAction(int direction, String name, boolean addToSelection, boolean changeSelection) {
            this.direction = direction;
            this.addToSelection = addToSelection;
            this.changeSelection = changeSelection;
            this.modeBuffer = addToSelection;
        }

        public void actionPerformed(ActionEvent e) {
            int rowCount;
            if (BasicPaneTreeUI.this.tree != null && (rowCount = BasicPaneTreeUI.this.getRowCount(BasicPaneTreeUI.this.tree)) > 0 && BasicPaneTreeUI.this.treeSelectionModel != null) {
                TreePath newPath;
                Dimension maxSize = BasicPaneTreeUI.this.tree.getSize();
                TreePath lead = BasicPaneTreeUI.this.getLeadPath();
                Rectangle visRect = BasicPaneTreeUI.this.tree.getVisibleRect();
                if (this.direction == -1) {
                    newPath = BasicPaneTreeUI.this.getClosestPathForLocation(BasicPaneTreeUI.this.tree, visRect.x, visRect.y);
                    if (newPath.equals(lead)) {
                        visRect.y = Math.max(0, visRect.y - visRect.height);
                        newPath = BasicPaneTreeUI.this.tree.getClosestPathForLocation(visRect.x, visRect.y);
                    }
                } else {
                    visRect.y = Math.min(maxSize.height, visRect.y + visRect.height - 1);
                    newPath = BasicPaneTreeUI.this.tree.getClosestPathForLocation(visRect.x, visRect.y);
                    if (newPath.equals(lead)) {
                        visRect.y = Math.min(maxSize.height, visRect.y + visRect.height - 1);
                        newPath = BasicPaneTreeUI.this.tree.getClosestPathForLocation(visRect.x, visRect.y);
                    }
                }
                Rectangle newRect = BasicPaneTreeUI.this.getPathBounds(BasicPaneTreeUI.this.tree, newPath);
                newRect.x = visRect.x;
                newRect.width = visRect.width;
                if (this.direction == -1) {
                    newRect.height = visRect.height;
                } else {
                    newRect.y -= visRect.height - newRect.height;
                    newRect.height = visRect.height;
                }
                FileNode newNode = (FileNode)newPath.getLastPathComponent();
                this.addToSelection = !newNode.isLeaf() ? false : this.modeBuffer;
                if (this.addToSelection) {
                    BasicPaneTreeUI.this.extendSelection(newPath, this.direction);
                } else if (this.changeSelection) {
                    BasicPaneTreeUI.this.tree.setSelectionPath(newPath);
                    BasicPaneTreeUI.this.setAnchorPath(newPath);
                    BasicPaneTreeUI.this.setLeadPath(newPath);
                } else {
                    BasicPaneTreeUI.this.setLeadPath(newPath, true);
                }
                BasicPaneTreeUI.this.tree.scrollRectToVisible(newRect);
            }
        }

        public boolean isEnabled() {
            return BasicPaneTreeUI.this.tree != null && BasicPaneTreeUI.this.tree.isEnabled();
        }
    }

    class TreeTraverseAction
    implements ActionListener {
        protected int direction;
        private boolean changeSelection;

        public TreeTraverseAction(int direction, String name) {
            this(direction, name, true);
        }

        public TreeTraverseAction(int direction, String name, boolean changeSelection) {
            this.direction = direction;
            this.changeSelection = changeSelection;
        }

        public void actionPerformed(ActionEvent e) {
            int rowCount;
            if (BasicPaneTreeUI.this.tree != null && (rowCount = BasicPaneTreeUI.this.getRowCount(BasicPaneTreeUI.this.tree)) > 0) {
                int newIndex;
                int minSelIndex = BasicPaneTreeUI.this.getLeadRow();
                if (minSelIndex == -1) {
                    newIndex = 0;
                } else if (this.direction == 1) {
                    if (!BasicPaneTreeUI.this.isLeaf(minSelIndex) && !BasicPaneTreeUI.this.tree.isExpanded(minSelIndex)) {
                        BasicPaneTreeUI.this.toggleExpandState(BasicPaneTreeUI.this.getPathForRow(BasicPaneTreeUI.this.tree, minSelIndex));
                        newIndex = -1;
                    } else {
                        newIndex = Math.min(minSelIndex + 1, rowCount - 1);
                    }
                } else if (!BasicPaneTreeUI.this.isLeaf(minSelIndex) && BasicPaneTreeUI.this.tree.isExpanded(minSelIndex)) {
                    BasicPaneTreeUI.this.toggleExpandState(BasicPaneTreeUI.this.getPathForRow(BasicPaneTreeUI.this.tree, minSelIndex));
                    newIndex = -1;
                } else {
                    TreePath path = BasicPaneTreeUI.this.getPathForRow(BasicPaneTreeUI.this.tree, minSelIndex);
                    newIndex = path != null && path.getPathCount() > 1 ? BasicPaneTreeUI.this.getRowForPath(BasicPaneTreeUI.this.tree, path.getParentPath()) : -1;
                }
                if (newIndex != -1) {
                    if (this.changeSelection) {
                        BasicPaneTreeUI.this.tree.setSelectionInterval(newIndex, newIndex);
                        BasicPaneTreeUI.this.setAnchorPath(BasicPaneTreeUI.this.getPathForRow(BasicPaneTreeUI.this.tree, newIndex));
                        BasicPaneTreeUI.this.setLeadPath(BasicPaneTreeUI.this.getPathForRow(BasicPaneTreeUI.this.tree, newIndex));
                    } else {
                        BasicPaneTreeUI.this.setLeadPath(BasicPaneTreeUI.this.getPathForRow(BasicPaneTreeUI.this.tree, newIndex), true);
                    }
                    BasicPaneTreeUI.this.ensureRowsAreVisible(newIndex, newIndex);
                }
            }
        }

        public boolean isEnabled() {
            return BasicPaneTreeUI.this.tree != null && BasicPaneTreeUI.this.tree.isEnabled();
        }
    }

    class SelectionModelPropertyChangeHandler
    implements PropertyChangeListener {
        SelectionModelPropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getSource() == BasicPaneTreeUI.this.treeSelectionModel) {
                BasicPaneTreeUI.this.treeSelectionModel.resetRowSelection();
            }
        }
    }

    class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getSource() == BasicPaneTreeUI.this.tree) {
                String changeName = event.getPropertyName();
                if (changeName.equals("cellRenderer")) {
                    BasicPaneTreeUI.this.setCellRenderer((TreeCellRenderer)event.getNewValue());
                } else if (changeName.equals("model")) {
                    BasicPaneTreeUI.this.setModel((TreeFileSystemModel)event.getNewValue());
                } else if (changeName.equals("rootVisible")) {
                    BasicPaneTreeUI.this.setRootVisible((Boolean)event.getNewValue());
                } else if (changeName.equals("showsRootHandles")) {
                    BasicPaneTreeUI.this.setShowsRootHandles((Boolean)event.getNewValue());
                } else if (changeName.equals("rowHeight")) {
                    BasicPaneTreeUI.this.setRowHeight((Integer)event.getNewValue());
                } else if (changeName.equals("cellEditor")) {
                    BasicPaneTreeUI.this.setCellEditor((TreeCellEditor)event.getNewValue());
                } else if (changeName.equals("editable")) {
                    BasicPaneTreeUI.this.setEditable((Boolean)event.getNewValue());
                } else if (changeName.equals("largeModel")) {
                    BasicPaneTreeUI.this.setLargeModel(BasicPaneTreeUI.this.tree.isLargeModel());
                } else if (changeName.equals("selectionModel")) {
                    BasicPaneTreeUI.this.setSelectionModel(BasicPaneTreeUI.this.tree.getSelectionModel());
                } else if (changeName.equals("font")) {
                    BasicPaneTreeUI.this.completeEditing();
                    if (BasicPaneTreeUI.this.treeState != null) {
                        BasicPaneTreeUI.this.treeState.invalidateSizes();
                    }
                    BasicPaneTreeUI.this.updateSize();
                }
            }
        }
    }

    public class MouseHandler
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            if (BasicPaneTreeUI.this.tree != null && BasicPaneTreeUI.this.tree.isEnabled()) {
                BasicPaneTreeUI.this.tree.requestFocus();
                TreePath path = BasicPaneTreeUI.this.getClosestPathForLocation(BasicPaneTreeUI.this.tree, e.getX(), e.getY());
                if (path != null) {
                    int x;
                    Rectangle bounds = BasicPaneTreeUI.this.getPathBounds(BasicPaneTreeUI.this.tree, path);
                    if (e.getY() > bounds.y + bounds.height) {
                        return;
                    }
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        BasicPaneTreeUI.this.checkForClickInExpandControl(path, e.getX(), e.getY());
                    }
                    if ((x = e.getX()) > bounds.x && x <= bounds.x + bounds.width && !BasicPaneTreeUI.this.startEditing(path, e)) {
                        BasicPaneTreeUI.this.selectPathForEvent(path, e);
                    }
                }
            }
        }
    }

    class NodeDimensionsHandler
    extends AbstractLayoutCache.NodeDimensions {
        NodeDimensionsHandler() {
        }

        public Rectangle getNodeDimensions(Object value, int row, int depth, boolean expanded, Rectangle size) {
            if (BasicPaneTreeUI.this.editingComponent != null && BasicPaneTreeUI.this.editingRow == row) {
                Dimension prefSize = BasicPaneTreeUI.this.editingComponent.getPreferredSize();
                int rh = BasicPaneTreeUI.this.getRowHeight();
                if (rh > 0 && rh != prefSize.height) {
                    prefSize.height = rh;
                }
                if (size != null) {
                    size.x = this.getRowX(row, depth);
                    size.width = prefSize.width;
                    size.height = prefSize.height;
                } else {
                    size = new Rectangle(this.getRowX(row, depth), 0, prefSize.width, prefSize.height);
                }
                return size;
            }
            if (BasicPaneTreeUI.this.currentCellRenderer != null) {
                Component aComponent = BasicPaneTreeUI.this.currentCellRenderer.getTreeCellRendererComponent(BasicPaneTreeUI.this.tree, value, BasicPaneTreeUI.this.tree.isRowSelected(row), expanded, BasicPaneTreeUI.this.treeModel.isLeaf(value), row, false);
                if (BasicPaneTreeUI.this.tree != null) {
                    BasicPaneTreeUI.this.rendererPane.add(aComponent);
                    aComponent.validate();
                }
                Dimension prefSize = aComponent.getPreferredSize();
                if (size != null) {
                    size.x = this.getRowX(row, depth);
                    size.width = prefSize.width;
                    size.height = prefSize.height;
                } else {
                    size = new Rectangle(this.getRowX(row, depth), 0, prefSize.width, prefSize.height);
                }
                return size;
            }
            return null;
        }

        protected int getRowX(int row, int depth) {
            return BasicPaneTreeUI.this.totalChildIndent * (depth + BasicPaneTreeUI.this.depthOffset);
        }
    }

    class FocusHandler
    implements FocusListener {
        FocusHandler() {
        }

        public void focusGained(FocusEvent e) {
            if (BasicPaneTreeUI.this.tree != null) {
                Rectangle pBounds = BasicPaneTreeUI.this.getPathBounds(BasicPaneTreeUI.this.tree, BasicPaneTreeUI.this.tree.getLeadSelectionPath());
                if (pBounds != null) {
                    BasicPaneTreeUI.this.tree.repaint(pBounds);
                }
                if ((pBounds = BasicPaneTreeUI.this.getPathBounds(BasicPaneTreeUI.this.tree, BasicPaneTreeUI.this.getLeadPath())) != null) {
                    BasicPaneTreeUI.this.tree.repaint(pBounds);
                }
            }
        }

        public void focusLost(FocusEvent e) {
            this.focusGained(e);
        }
    }

    class EmptyFocusHandler
    implements FocusListener {
        EmptyFocusHandler() {
        }

        public void focusGained(FocusEvent ignored) {
        }

        public void focusLost(FocusEvent ignored) {
        }
    }

    class KeyHandler
    extends KeyAdapter {
        protected ActionListener repeatKeyAction;
        protected boolean isKeyDown;

        KeyHandler() {
        }

        public void keyPressed(KeyEvent e) {
            if (BasicPaneTreeUI.this.tree.hasFocus() && BasicPaneTreeUI.this.tree.isEnabled()) {
                ActionListener listener;
                KeyStroke keyStroke = KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers());
                this.repeatKeyAction = BasicPaneTreeUI.this.tree.getConditionForKeyStroke(keyStroke) == 0 ? ((listener = BasicPaneTreeUI.this.tree.getActionForKeyStroke(keyStroke)) instanceof ActionListener ? listener : null) : null;
                if (this.isKeyDown && this.repeatKeyAction != null) {
                    this.repeatKeyAction.actionPerformed(null);
                    e.consume();
                } else {
                    this.isKeyDown = true;
                }
            }
        }

        public void keyReleased(KeyEvent e) {
            this.isKeyDown = false;
        }
    }

    class CellEditorHandler
    implements CellEditorListener {
        CellEditorHandler() {
        }

        public void editingStopped(ChangeEvent e) {
            BasicPaneTreeUI.this.completeEditing(false, false, true);
        }

        public void editingCanceled(ChangeEvent e) {
            BasicPaneTreeUI.this.completeEditing(false, false, false);
        }
    }

    class TreeSelectionHandler
    implements TreeSelectionListener {
        TreeSelectionHandler() {
        }

        public void valueChanged(TreeSelectionEvent event) {
            Rectangle nodeBounds;
            TreePath[] paths;
            BasicPaneTreeUI.this.completeEditing();
            if (BasicPaneTreeUI.this.treeSelectionModel != null && (paths = BasicPaneTreeUI.this.treeSelectionModel.getSelectionPaths()) != null) {
                int counter = paths.length - 1;
                while (counter >= 0) {
                    BasicPaneTreeUI.this.tree.makeVisible(paths[counter]);
                    --counter;
                }
            }
            TreePath oldLead = BasicPaneTreeUI.this.leadPath;
            BasicPaneTreeUI.this.lastSelectedRow = BasicPaneTreeUI.this.tree.getMinSelectionRow();
            TreePath lead = event.getNewLeadSelectionPath();
            BasicPaneTreeUI.this.setLeadPath(lead, true);
            TreePath[] changedPaths = event.getPaths();
            Rectangle visRect = BasicPaneTreeUI.this.tree.getVisibleRect();
            boolean paintPaths = true;
            int nWidth = BasicPaneTreeUI.this.tree.getSize().width;
            if (changedPaths != null) {
                int maxCounter = changedPaths.length;
                if (maxCounter > 4) {
                    BasicPaneTreeUI.this.tree.repaint();
                    paintPaths = false;
                } else {
                    int counter = 0;
                    while (counter < maxCounter) {
                        nodeBounds = BasicPaneTreeUI.this.getPathBounds(BasicPaneTreeUI.this.tree, changedPaths[counter]);
                        if (nodeBounds != null && visRect.intersects(nodeBounds)) {
                            BasicPaneTreeUI.this.tree.repaint(0, nodeBounds.y, nWidth, nodeBounds.height);
                        }
                        ++counter;
                    }
                }
            }
            if (paintPaths) {
                nodeBounds = BasicPaneTreeUI.this.getPathBounds(BasicPaneTreeUI.this.tree, event.getOldLeadSelectionPath());
                if (nodeBounds != null && visRect.intersects(nodeBounds)) {
                    BasicPaneTreeUI.this.tree.repaint(0, nodeBounds.y, nWidth, nodeBounds.height);
                }
                if ((nodeBounds = BasicPaneTreeUI.this.getPathBounds(BasicPaneTreeUI.this.tree, event.getNewLeadSelectionPath())) != null && visRect.intersects(nodeBounds)) {
                    BasicPaneTreeUI.this.tree.repaint(0, nodeBounds.y, nWidth, nodeBounds.height);
                }
                if ((nodeBounds = BasicPaneTreeUI.this.getPathBounds(BasicPaneTreeUI.this.tree, oldLead)) != null && visRect.intersects(nodeBounds)) {
                    BasicPaneTreeUI.this.tree.repaint(0, nodeBounds.y, nWidth, nodeBounds.height);
                }
            }
        }
    }

    class TreeModelHandler
    implements TreeModelListener {
        TreeModelHandler() {
        }

        public void treeNodesChanged(TreeModelEvent e) {
            if (BasicPaneTreeUI.this.treeState != null && e != null) {
                BasicPaneTreeUI.this.treeState.treeNodesChanged(e);
                TreePath pPath = e.getTreePath().getParentPath();
                if (pPath == null || BasicPaneTreeUI.this.treeState.isExpanded(pPath)) {
                    BasicPaneTreeUI.this.updateSize();
                }
            }
        }

        public void treeNodesInserted(TreeModelEvent e) {
            if (BasicPaneTreeUI.this.treeState != null && e != null) {
                BasicPaneTreeUI.this.treeState.treeNodesInserted(e);
                BasicPaneTreeUI.this.updateLeadRow();
                TreePath path = e.getTreePath();
                if (BasicPaneTreeUI.this.treeState.isExpanded(path)) {
                    BasicPaneTreeUI.this.updateSize();
                } else {
                    int[] indices = e.getChildIndices();
                    int childCount = BasicPaneTreeUI.this.treeModel.getChildCount(path.getLastPathComponent());
                    if (indices != null && childCount - indices.length == 0) {
                        BasicPaneTreeUI.this.updateSize();
                    }
                }
            }
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            if (BasicPaneTreeUI.this.treeState != null && e != null) {
                BasicPaneTreeUI.this.treeState.treeNodesRemoved(e);
                BasicPaneTreeUI.this.updateLeadRow();
                TreePath path = e.getTreePath();
                if (BasicPaneTreeUI.this.treeState.isExpanded(path) || BasicPaneTreeUI.this.treeModel.getChildCount(path.getLastPathComponent()) == 0) {
                    BasicPaneTreeUI.this.updateSize();
                }
            }
        }

        public void treeStructureChanged(TreeModelEvent e) {
            if (BasicPaneTreeUI.this.treeState != null && e != null) {
                BasicPaneTreeUI.this.treeState.treeStructureChanged(e);
                BasicPaneTreeUI.this.updateLeadRow();
                TreePath pPath = e.getTreePath().getParentPath();
                if (pPath == null || BasicPaneTreeUI.this.treeState.isExpanded(pPath)) {
                    BasicPaneTreeUI.this.updateSize();
                }
            }
        }
    }

    class ComponentHandler
    extends ComponentAdapter
    implements ActionListener {
        protected Timer timer;
        protected JScrollBar scrollBar;

        ComponentHandler() {
        }

        public void componentMoved(ComponentEvent e) {
            if (this.timer == null) {
                JScrollPane scrollPane = this.getScrollPane();
                if (scrollPane == null) {
                    BasicPaneTreeUI.this.updateSize();
                } else {
                    this.scrollBar = scrollPane.getVerticalScrollBar();
                    if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                        this.scrollBar = scrollPane.getHorizontalScrollBar();
                        if (this.scrollBar != null && this.scrollBar.getValueIsAdjusting()) {
                            this.startTimer();
                        } else {
                            BasicPaneTreeUI.this.updateSize();
                        }
                    } else {
                        this.startTimer();
                    }
                }
            }
        }

        protected void startTimer() {
            if (this.timer == null) {
                this.timer = new Timer(200, this);
                this.timer.setRepeats(true);
            }
            this.timer.start();
        }

        protected JScrollPane getScrollPane() {
            Container c = BasicPaneTreeUI.this.tree.getParent();
            while (c != null && !(c instanceof JScrollPane)) {
                c = c.getParent();
            }
            if (c instanceof JScrollPane) {
                return (JScrollPane)c;
            }
            return null;
        }

        public void actionPerformed(ActionEvent ae) {
            if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                if (this.timer != null) {
                    this.timer.stop();
                }
                BasicPaneTreeUI.this.updateSize();
                this.timer = null;
                this.scrollBar = null;
            }
        }
    }

    class TreeExpansionHandler
    implements TreeExpansionListener {
        TreeExpansionHandler() {
        }

        public void treeExpanded(TreeExpansionEvent event) {
            if (event != null && BasicPaneTreeUI.this.tree != null) {
                TreePath path = event.getPath();
                BasicPaneTreeUI.this.updateExpandedDescendants(path);
            }
        }

        public void treeCollapsed(TreeExpansionEvent event) {
            if (event != null && BasicPaneTreeUI.this.tree != null) {
                TreePath path = event.getPath();
                BasicPaneTreeUI.this.completeEditing();
                if (path != null && BasicPaneTreeUI.this.tree.isVisible(path)) {
                    BasicPaneTreeUI.this.treeState.setExpandedState(path, false);
                    BasicPaneTreeUI.this.updateLeadRow();
                    BasicPaneTreeUI.this.updateSize();
                }
            }
        }
    }
}

