/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane.plaf.basic;

import com.hbworks.dirpane.CellEditorTextField;
import com.hbworks.dirpane.DefaultFileView;
import com.hbworks.dirpane.FileType;
import com.hbworks.dirpane.FocusDispatcher;
import com.hbworks.dirpane.TableDirectoryModel;
import com.hbworks.dirpane.TableDirectoryPane;
import com.hbworks.dirpane.TableDirectoryPaneCellEditor;
import com.hbworks.dirpane.TableSelectionModel;
import com.hbworks.dirpane.event.LoadingEvent;
import com.hbworks.dirpane.event.LoadingListener;
import com.hbworks.dirpane.plaf.DirectoryPaneUI;
import com.hbworks.dirpane.plaf.TableDirectoryPaneUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.ComponentUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class BasicTableDirectoryPaneUI
extends TableDirectoryPaneUI
implements PropertyChangeListener {
    private static final int SORTING_NOT_ACTIVE = -1;
    private static final int SORTED_DESC = 0;
    private static final int SORTED_ASC = 1;
    private static final String CustomTable_uiClassID = "PaneTableUI";
    private JScrollPane scroller = null;
    private TableCellEditor editor = null;
    private OverlayLayout overlayLayout = null;
    private Class columnClass = null;
    private String columnName = null;
    private Object columnId = null;
    private TableColumn newColumn = null;
    private TableCellRenderer renderer = null;
    private Hashtable defaultRenderers = null;
    private JComponent glass = null;
    private TableDirectoryModel directoryModel = null;
    private TableSelectionModel tableSelectionModel = null;
    private TableColumnModel columnModel = null;
    private MouseListener tableMouseListener = null;
    private MouseListener sortColumnListener = null;
    private FocusListener tableFocusListener = null;
    private LoadingListener tableLoadingListener = null;
    private PropertyChangeListener columnWidthListener = null;
    private PropertyChangeListener isActivePaneListener = null;
    private FocusDispatcher focusDispatcher = null;
    private Hashtable columnWidthCache = null;
    private String viewCache = null;
    private Hashtable columnViewIndices = new Hashtable();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$javax$swing$Icon;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$com$hbworks$dirpane$FileType;
    static /* synthetic */ Class class$java$util$Date;

    public static ComponentUI createUI(JComponent c) {
        return new BasicTableDirectoryPaneUI();
    }

    public void installUI(JComponent c) {
        this.directoryPane = (TableDirectoryPane)c;
        this.paneFont = this.directoryPane.getFont() == null ? DirectoryPaneUI.makeFontSmaller(UIManager.getFont("Table.font")) : this.directoryPane.getFont();
        this.viewCache = this.directoryPane.getViewMode();
        this.isGrayoutEnabled = this.directoryPane.isGrayoutEnabled();
        this.columnWidthListener = this.directoryPane.getColumnWidthListener();
        this.columnWidthCache = this.directoryPane.getColumnWidthCache();
        DefaultFileView defaultFileView = this.directoryPane.getDefaultFileView();
        super.installUI(c);
        this.installModels();
        this.installDefaultRenderers();
        this.installDefaultIcons(defaultFileView);
        this.installView();
        this.configureTable();
        this.installKeyboardActions(c);
        this.installComponents();
        this.installListeners();
        this.invokeAutoResizer();
    }

    public void uninstallUI(JComponent c) {
        if (c != this.directoryPane) {
            throw new IllegalComponentStateException(this + " was asked to deinstall() " + c + " when it only knows about " + this.directoryPane + ".");
        }
        this.uninstallDefaultRenderers();
        this.uninstallListeners();
        this.uninstallModels();
        this.uninstallKeyboardActions(c);
        this.uninstallComponents();
        super.uninstallUI(c);
    }

    protected void installModels() {
        this.directoryModel = (TableDirectoryModel)this.directoryPane.getModel();
        this.tableSelectionModel = this.directoryPane.getSelectionModel();
        this.columnModel = this.directoryPane.createTableColumnModel();
    }

    protected void installDefaultRenderers() {
        this.defaultRenderers = new Hashtable();
        this.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = BasicTableDirectoryPaneUI.class$("java.lang.Object")) : class$java$lang$Object, this.createGenericRenderer());
        this.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = BasicTableDirectoryPaneUI.class$("java.lang.String")) : class$java$lang$String, this.createStringRenderer());
        this.setDefaultRenderer(class$java$lang$Boolean == null ? (class$java$lang$Boolean = BasicTableDirectoryPaneUI.class$("java.lang.Boolean")) : class$java$lang$Boolean, this.createCheckBoxRenderer());
        this.setDefaultRenderer(class$java$lang$Number == null ? (class$java$lang$Number = BasicTableDirectoryPaneUI.class$("java.lang.Number")) : class$java$lang$Number, this.createNumberRenderer());
        this.setDefaultRenderer(class$javax$swing$Icon == null ? (class$javax$swing$Icon = BasicTableDirectoryPaneUI.class$("javax.swing.Icon")) : class$javax$swing$Icon, this.createIconRenderer());
        Class fileSubType = this.directoryModel.getFileSubType();
        this.setDefaultRenderer(fileSubType, this.createFileNameRenderer());
        this.setDefaultRenderer(class$java$lang$Long == null ? (class$java$lang$Long = BasicTableDirectoryPaneUI.class$("java.lang.Long")) : class$java$lang$Long, this.createFileLengthRenderer());
        this.setDefaultRenderer(class$com$hbworks$dirpane$FileType == null ? (class$com$hbworks$dirpane$FileType = BasicTableDirectoryPaneUI.class$("com.hbworks.dirpane.FileType")) : class$com$hbworks$dirpane$FileType, this.createFileTypeRenderer());
        this.setDefaultRenderer(class$java$util$Date == null ? (class$java$util$Date = BasicTableDirectoryPaneUI.class$("java.util.Date")) : class$java$util$Date, this.createFileDateRenderer());
        this.addCustomRenderers();
    }

    protected void installDefaultIcons(DefaultFileView fileView) {
        Icon customFileIcon = this.directoryPane.getCustomFileIcon();
        if (customFileIcon != null) {
            fileView.setDefaultFileIcon(customFileIcon);
        } else {
            fileView.setDefaultFileIcon(this.getFileIcon());
        }
        Icon customDirectoryIcon = this.directoryPane.getCustomDirectoryIcon();
        if (customDirectoryIcon != null) {
            fileView.setDefaultDirectoryIcon(customDirectoryIcon);
        } else {
            fileView.setDefaultDirectoryIcon(this.getDirectoryIcon());
        }
        Icon customOpenDirectoryIcon = this.directoryPane.getCustomOpenDirectoryIcon();
        if (customOpenDirectoryIcon != null) {
            fileView.setDefaultOpenDirectoryIcon(customOpenDirectoryIcon);
        } else {
            fileView.setDefaultOpenDirectoryIcon(this.getOpenDirectoryIcon());
        }
        Icon customFloppyDriveIcon = this.directoryPane.getCustomFloppyDriveIcon();
        if (customFloppyDriveIcon != null) {
            fileView.setDefaultFloppyDriveIcon(customFloppyDriveIcon);
        } else {
            fileView.setDefaultFloppyDriveIcon(this.getFloppyDriveIcon());
        }
        Icon customHardDriveIcon = this.directoryPane.getCustomHardDriveIcon();
        if (customHardDriveIcon != null) {
            fileView.setDefaultHardDriveIcon(customHardDriveIcon);
        } else {
            fileView.setDefaultHardDriveIcon(this.getHardDriveIcon());
        }
        Icon customComputerIcon = this.directoryPane.getCustomComputerIcon();
        if (customComputerIcon != null) {
            fileView.setDefaultComputerIcon(customComputerIcon);
        } else {
            fileView.setDefaultComputerIcon(this.getComputerIcon());
        }
    }

    protected void installView() {
        if (this.viewCache.equals("listview")) {
            this.populateListColumnModel();
        } else if (this.viewCache.equals("detailsview")) {
            this.populateDetailsColumnModel();
        } else {
            System.out.println("Unknown viewMode : " + this.viewCache + ".Used " + "detailsview" + " instead.");
            this.populateDetailsColumnModel();
        }
    }

    protected void configureTable() {
        this.table = this.createUITable();
        this.table.setAutoResizeMode(0);
        this.table.setRowHeight(this.directoryPane.getRowHeight());
        this.table.setAutoCreateColumnsFromModel(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setShowGrid(false);
        this.table.setToolTipText(null);
        this.table.setBackground(this.getPaneBackground());
        this.table.setCellSelectionEnabled(false);
        this.table.registerKeyboardAction(this.directoryPane.getGoUpAction(), KeyStroke.getKeyStroke(8, 0), 0);
        this.editor = this.createTableCellEditor();
        int viewcolumn = this.getUITable().convertColumnIndexToView(0);
        this.columnModel.getColumn(viewcolumn).setCellEditor(this.editor);
    }

    protected void installKeyboardActions(JComponent c) {
        c.registerKeyboardAction(this.directoryPane.getNewFolderAction(), KeyStroke.getKeyStroke(155, 0), 1);
        c.registerKeyboardAction(this.directoryPane.getGoHomeAction(), KeyStroke.getKeyStroke(36, 0), 1);
        c.registerKeyboardAction(this.directoryPane.getDoubleClickAction(), KeyStroke.getKeyStroke(10, 0), 1);
    }

    protected void populateDetailsColumnModel() {
        this.removeColumns();
        this.columnModel.setColumnMargin(0);
        this.columnModel.setColumnSelectionAllowed(false);
        Vector<TableColumn> tempCols = new Vector<TableColumn>();
        int i = 0;
        while (i < this.directoryModel.getColumnCount()) {
            int[] lastSortedInfo;
            this.columnName = this.directoryModel.getColumnName(i);
            this.columnId = this.directoryModel.getColumnIdentifier(i);
            this.newColumn = new TableColumn(i);
            this.newColumn.setIdentifier(this.columnId);
            if (this.columnWidthCache != null && this.columnWidthCache.containsKey(this.columnId)) {
                int width = (Integer)this.columnWidthCache.get(this.columnId);
                this.newColumn.setPreferredWidth(width);
            }
            if (this.newColumn.getHeaderValue() == null) {
                this.newColumn.setHeaderValue(this.columnName);
            }
            if ((lastSortedInfo = this.directoryPane.getLastSortedColumnInfo()) != null) {
                if (i == lastSortedInfo[0]) {
                    this.newColumn.setHeaderRenderer(new HeaderRenderer(lastSortedInfo[1]));
                } else {
                    this.newColumn.setHeaderRenderer(new HeaderRenderer());
                }
            } else if (i == 0) {
                this.newColumn.setHeaderRenderer(new HeaderRenderer(1));
            } else {
                this.newColumn.setHeaderRenderer(new HeaderRenderer());
            }
            this.columnClass = this.directoryModel.getColumnClass(i);
            this.renderer = this.getDefaultRenderer(this.columnClass);
            this.newColumn.setCellRenderer(this.renderer);
            if (this.columnWidthListener != null) {
                this.newColumn.addPropertyChangeListener(this.columnWidthListener);
            }
            tempCols.addElement(this.newColumn);
            ++i;
        }
        TableColumn[] cols = new TableColumn[tempCols.size()];
        int i2 = 0;
        while (i2 < tempCols.size()) {
            TableColumn c = (TableColumn)tempCols.elementAt(i2);
            Object id = c.getIdentifier();
            int index = this.columnViewIndices.containsKey(id) ? (Integer)this.columnViewIndices.get(id) : i2;
            cols[index] = c;
            ++i2;
        }
        int i3 = 0;
        while (i3 < cols.length) {
            this.columnModel.addColumn(cols[i3]);
            ++i3;
        }
    }

    protected void populateListColumnModel() {
        Enumeration<TableColumn> en = this.columnModel.getColumns();
        while (en.hasMoreElements()) {
            Object id = en.nextElement().getIdentifier();
            Integer viewIndex = new Integer(this.columnModel.getColumnIndex(id));
            this.columnViewIndices.put(id, viewIndex);
        }
        this.removeColumns();
        this.columnModel.setColumnMargin(0);
        this.columnModel.setColumnSelectionAllowed(false);
        this.columnClass = this.directoryModel.getColumnClass(0);
        this.columnId = this.directoryModel.getColumnIdentifier(0);
        this.newColumn = new TableColumn(0);
        this.newColumn.setIdentifier(this.columnId);
        this.renderer = this.getDefaultRenderer(this.columnClass);
        this.newColumn.setCellRenderer(this.renderer);
        this.columnModel.addColumn(this.newColumn);
    }

    protected void installComponents() {
        this.scroller = new JScrollPane(this.table);
        this.scroller.setBackground(this.paneBackground);
        if (!this.isGrayoutEnabled()) {
            this.directoryPane.setLayout(new BorderLayout());
            this.directoryPane.add((Component)this.scroller, "Center");
        } else {
            this.overlayLayout = new OverlayLayout(this.directoryPane);
            this.directoryPane.setLayout(this.overlayLayout);
            this.glass = this.createGlassPaneFor(this.scroller);
            if (this.directoryPane.isActivePane()) {
                this.glass.setVisible(false);
            } else {
                this.glass.setVisible(true);
            }
            this.directoryPane.add(this.glass);
            this.directoryPane.add(this.scroller);
        }
    }

    protected void installListeners() {
        this.directoryPane.addPropertyChangeListener(this);
        if (this.isGrayoutEnabled()) {
            this.isActivePaneListener = this.createIsActivePaneListener();
            this.directoryPane.addPropertyChangeListener(this.isActivePaneListener);
        }
        this.directoryModel.addTableModelListener(this.table);
        this.focusDispatcher = new FocusDispatcher(this.directoryPane, this.table);
        this.directoryPane.addPropertyChangeListener(this.focusDispatcher);
        this.tableMouseListener = this.createUITableMouseListener();
        this.table.addMouseListener(this.tableMouseListener);
        this.tableFocusListener = this.createUITableFocusListener();
        this.table.addFocusListener(this.tableFocusListener);
        this.sortColumnListener = this.createSortColumnListener();
        JTableHeader th = this.table.getTableHeader();
        th.addMouseListener(this.sortColumnListener);
        this.tableLoadingListener = this.createLoadingListener();
        this.directoryModel.addLoadingListener(this.tableLoadingListener);
    }

    protected void removeColumns() {
        while (this.columnModel.getColumnCount() > 0) {
            TableColumn col = this.columnModel.getColumn(0);
            if (this.columnWidthListener != null) {
                col.removePropertyChangeListener(this.columnWidthListener);
            }
            this.columnModel.removeColumn(col);
            Object var1_1 = null;
        }
    }

    protected void uninstallModels() {
        this.directoryModel = null;
        this.tableSelectionModel = null;
        this.columnModel = null;
    }

    protected void uninstallKeyboardActions(JComponent c) {
        c.unregisterKeyboardAction(KeyStroke.getKeyStroke(155, 0));
        c.unregisterKeyboardAction(KeyStroke.getKeyStroke(36, 0));
        c.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
    }

    protected void uninstallListeners() {
        if (this.isActivePaneListener != null) {
            this.directoryPane.removePropertyChangeListener(this.isActivePaneListener);
            this.isActivePaneListener = null;
        }
        this.directoryModel.removeTableModelListener(this.table);
        this.directoryPane.removePropertyChangeListener(this);
        this.directoryPane.removePropertyChangeListener(this.focusDispatcher);
        this.focusDispatcher = null;
        this.table.removeMouseListener(this.tableMouseListener);
        this.tableMouseListener = null;
        this.table.removeFocusListener(this.tableFocusListener);
        this.tableFocusListener = null;
        JTableHeader th = this.table.getTableHeader();
        th.removeMouseListener(this.sortColumnListener);
        this.sortColumnListener = null;
        th = null;
        this.directoryModel.removeLoadingListener(this.tableLoadingListener);
        this.tableLoadingListener = null;
        this.removeColumns();
        this.columnWidthListener = null;
    }

    protected void uninstallComponents() {
        if (this.glass != null) {
            this.directoryPane.remove(this.glass);
        }
        this.directoryPane.removeAll();
        this.directoryPane.setLayout(null);
        this.directoryPane = null;
        this.overlayLayout = null;
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(8, 0));
        this.table = null;
        this.scroller = null;
        this.glass = null;
        this.editor = null;
        this.columnWidthCache = null;
        this.viewCache = null;
        this.paneFont = null;
        this.columnClass = null;
        this.columnName = null;
        this.columnId = null;
        this.newColumn = null;
        this.renderer = null;
    }

    protected void uninstallDefaultRenderers() {
        if (this.defaultRenderers != null) {
            this.defaultRenderers.clear();
        }
        this.defaultRenderers = null;
    }

    public void propertyChange(PropertyChangeEvent e) {
        Object newvalue = e.getNewValue();
        String name = e.getPropertyName();
        if (name == "viewChanged") {
            String viewMode = (String)newvalue;
            this.table.setAutoResizeMode(0);
            this.setViewCache(viewMode);
            this.installView();
            this.updateScrollerHeader();
            this.table.sizeColumnsToFit(-1);
            this.invokeAutoResizer();
            if (this.editor != null) {
                int viewcolumn = this.getUITable().convertColumnIndexToView(0);
                this.columnModel.getColumn(viewcolumn).setCellEditor(this.editor);
            }
        } else if (name == "autoresizeColumns") {
            int mode = (Integer)newvalue;
            this.invokeAutoResizer(mode);
        } else if (name == "selectionForegroundChangedProperty") {
            Color sfg = (Color)newvalue;
            if (sfg == null) {
                this.setPaneSelectionForeground(UIManager.getColor("Table.selectionForeground"));
            } else {
                this.setPaneSelectionForeground(sfg);
            }
            this.table.repaint();
        } else if (name == "selectionBackgroundChanged") {
            Color sbg = (Color)newvalue;
            if (sbg == null) {
                this.setPaneSelectionBackground(UIManager.getColor("Table.selectionBackground"));
            } else {
                this.setPaneSelectionBackground(sbg);
            }
            this.table.repaint();
        } else if (name == "foregroundChanged") {
            Color fg = (Color)newvalue;
            if (fg == null) {
                this.setPaneForeground(UIManager.getColor("Table.foreground"));
            } else {
                this.setPaneForeground(fg);
            }
            this.table.repaint();
        } else if (name == "backgroundChanged") {
            Color bg = (Color)newvalue;
            if (bg == null) {
                this.setPaneBackground(UIManager.getColor("Table.background"));
                this.setPaneActiveBackground(UIManager.getColor("Table.background"));
            } else {
                this.setPaneBackground(bg);
                this.setPaneActiveBackground(bg);
            }
            this.scroller.setBackground(this.getPaneBackground());
            this.table.setBackground(this.getPaneBackground());
        } else if (name == "fontChanged") {
            Font f = (Font)newvalue;
            if (f == null) {
                this.setPaneFont(DirectoryPaneUI.makeFontSmaller(UIManager.getFont("Table.font")));
            } else {
                this.setPaneFont(f);
            }
        } else if (name == "rowHeightChanged") {
            int h = (Integer)newvalue;
            this.table.setRowHeight(h);
        } else if (name == "directoryChanged") {
            this.initializeScrollBars();
            if (this.editor != null) {
                this.editor.cancelCellEditing();
            }
        } else if (name == "canGrayoutPane") {
            boolean canGrayout = (Boolean)newvalue;
            this.setGrayoutEnabled(canGrayout);
        } else if (name == "isBusy") {
            boolean busy = (Boolean)newvalue;
            if (busy) {
                this.setWaitCursor();
            } else {
                this.setDefaultCursor();
            }
        }
    }

    protected void setDefaultRenderer(Class columnClass, TableCellRenderer renderer) {
        if (renderer != null) {
            this.defaultRenderers.put(columnClass, renderer);
        } else {
            this.defaultRenderers.remove(columnClass);
        }
    }

    protected TableCellRenderer getDefaultRenderer(Class columnClass) {
        if (columnClass == null || this.defaultRenderers == null) {
            return null;
        }
        Object renderer = this.defaultRenderers.get(columnClass);
        if (renderer != null) {
            return (TableCellRenderer)renderer;
        }
        return this.getDefaultRenderer(columnClass.getSuperclass());
    }

    /*
     * Unable to fully structure code
     */
    protected void addCustomRenderers() {
        e = this.directoryPane.getKeysInCustomRenderersTable();
        if (e != null) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            c = (Class)e.nextElement();
            r = this.directoryPane.getCustomRenderer(c);
            this.setDefaultRenderer(c, r);
lbl7:
            // 2 sources

            ** while (e.hasMoreElements())
        }
lbl8:
        // 1 sources

    }

    protected TableCellRenderer createGenericRenderer() {
        return new GenericRenderer();
    }

    protected TableCellRenderer createStringRenderer() {
        return new StringRenderer();
    }

    protected TableCellRenderer createCheckBoxRenderer() {
        return new CheckBoxRenderer();
    }

    protected TableCellRenderer createNumberRenderer() {
        return new NumberRenderer();
    }

    protected TableCellRenderer createIconRenderer() {
        return new IconRenderer();
    }

    protected TableCellRenderer createFileNameRenderer() {
        return new FileNameRenderer();
    }

    protected TableCellRenderer createFileLengthRenderer() {
        return new FileLengthRenderer();
    }

    protected TableCellRenderer createFileTypeRenderer() {
        return new FileTypeRenderer();
    }

    protected TableCellRenderer createFileDateRenderer() {
        return new FileDateRenderer();
    }

    protected TableDirectoryModel getDirectoryModel() {
        return this.directoryModel;
    }

    protected TableColumnModel getTableColumnModel() {
        return this.columnModel;
    }

    protected TableSelectionModel getTableSelectionModel() {
        return this.tableSelectionModel;
    }

    protected JScrollPane getUIScroller() {
        return this.scroller;
    }

    protected JComponent getUIGlass() {
        return this.glass;
    }

    protected Hashtable getColumnWidthCache() {
        return this.columnWidthCache;
    }

    protected void setViewCache(String viewMode) {
        this.viewCache = viewMode;
    }

    protected String getViewCache() {
        return this.viewCache;
    }

    protected void setGrayoutEnabled(boolean b) {
        if (b && this.isGrayoutEnabled()) {
            return;
        }
        if (!b && !this.isGrayoutEnabled()) {
            return;
        }
        if (!b && this.isGrayoutEnabled()) {
            this.directoryPane.setLayout(null);
            this.overlayLayout = null;
            this.directoryPane.removeAll();
            this.glass = null;
            this.scroller = null;
            if (this.isActivePaneListener != null) {
                this.directoryPane.removePropertyChangeListener(this.isActivePaneListener);
                this.isActivePaneListener = null;
            }
            this.scroller = new JScrollPane(this.table);
            this.scroller.setBackground(this.paneBackground);
            this.directoryPane.setLayout(new BorderLayout());
            this.directoryPane.add((Component)this.scroller, "Center");
            this.directoryPane.validate();
        } else if (b && !this.isGrayoutEnabled()) {
            this.directoryPane.setLayout(null);
            this.directoryPane.removeAll();
            this.glass = null;
            this.scroller = null;
            this.overlayLayout = new OverlayLayout(this.directoryPane);
            this.directoryPane.setLayout(this.overlayLayout);
            this.scroller = new JScrollPane(this.table);
            this.scroller.setBackground(this.paneBackground);
            this.glass = this.createGlassPaneFor(this.scroller);
            if (this.directoryPane.isActivePane()) {
                this.glass.setVisible(false);
            } else {
                this.glass.setVisible(true);
            }
            this.isActivePaneListener = this.createIsActivePaneListener();
            this.directoryPane.addPropertyChangeListener(this.isActivePaneListener);
            this.directoryPane.add(this.glass);
            this.directoryPane.add(this.scroller);
            this.directoryPane.validate();
        }
        this.isGrayoutEnabled = b;
    }

    protected void setPaneBackground(Color c) {
        this.paneBackground = c;
    }

    protected void setPaneActiveBackground(Color c) {
        this.paneActiveBackground = c;
    }

    protected void setPaneNotActiveBackground(Color c) {
        this.paneNotActiveBackground = c;
    }

    protected void setPaneForeground(Color c) {
        this.paneForeground = c;
    }

    protected void setPaneSelectionForeground(Color c) {
        this.paneSelectionForeground = c;
    }

    protected void setPaneSelectionBackground(Color c) {
        this.paneSelectionBackground = c;
    }

    protected void setPaneFont(Font f) {
        this.paneFont = f;
    }

    protected JTable createUITable() {
        return new CustomTable(this.directoryModel, this.columnModel, this.tableSelectionModel);
    }

    protected MouseListener createSortColumnListener() {
        return new SortColumnListener();
    }

    protected MouseListener createUITableMouseListener() {
        return new UITableMouseListener();
    }

    protected FocusListener createUITableFocusListener() {
        return new UITableFocusListener();
    }

    protected LoadingListener createLoadingListener() {
        return new TableLoadingListener();
    }

    protected PropertyChangeListener createIsActivePaneListener() {
        return new IsActivePaneListener();
    }

    protected TableCellEditor createTableCellEditor() {
        CellEditorTextField editorfield = new CellEditorTextField(this.directoryPane);
        Class fileSubType = this.directoryModel.getFileSubType();
        TableCellRenderer fileNameRenderer = this.getDefaultRenderer(fileSubType);
        return new TableDirectoryPaneCellEditor(this.table, editorfield, (Component)((Object)fileNameRenderer));
    }

    protected void invokeAutoResizer() {
        JTable t = this.table;
        int mode = this.directoryPane.getAutoResizeMode();
        if (t != null) {
            AutoResizer resizer = new AutoResizer(t, mode);
            SwingUtilities.invokeLater(resizer);
        }
    }

    protected void invokeAutoResizer(int mode) {
        JTable t = this.table;
        if (t != null) {
            AutoResizer resizer = new AutoResizer(t, mode);
            SwingUtilities.invokeLater(resizer);
        }
    }

    public void setWaitCursor() {
        Window w = SwingUtilities.windowForComponent(this.directoryPane);
        if (w != null) {
            w.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public void setDefaultCursor() {
        Window w = SwingUtilities.windowForComponent(this.directoryPane);
        if (w != null) {
            w.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected void updateScrollerHeader() {
        if (this.viewCache.equals("detailsview")) {
            this.scroller.setColumnHeaderView(this.table.getTableHeader());
        } else if (this.viewCache.equals("listview")) {
            this.scroller.setColumnHeaderView(null);
        }
    }

    protected void initializeScrollBars() {
        JScrollBar vbar = this.scroller.getVerticalScrollBar();
        JScrollBar hbar = this.scroller.getHorizontalScrollBar();
        if (vbar != null) {
            vbar.setValue(0);
        }
        if (hbar != null) {
            hbar.setValue(0);
        }
    }

    private int[] getSortedSelectionIndices(Vector selectionBuffer) {
        int[] mappedIndices = new int[selectionBuffer.size()];
        int i = 0;
        while (i < selectionBuffer.size()) {
            int index;
            mappedIndices[i] = index = this.directoryModel.indexOf((Object[])selectionBuffer.elementAt(i));
            ++i;
        }
        return mappedIndices;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        protected CheckBoxRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setSelected(value != null && (Boolean)value != false);
            if (isSelected) {
                this.setBackground(BasicTableDirectoryPaneUI.this.getPaneSelectionBackground());
            } else {
                this.setBackground(BasicTableDirectoryPaneUI.this.getPaneBackground());
            }
            if (hasFocus) {
                LineBorder focusBorder = (LineBorder)UIManager.getBorder("Table.focusCellHighlightBorder");
                this.setBorder(new MatteBorder(1, 0, 1, 0, focusBorder.getLineColor()));
            } else {
                this.setBorder(new EmptyBorder(1, 0, 1, 0));
            }
            return this;
        }
    }

    protected class FileDateRenderer
    extends GeneralLabelRenderer {
        protected FileDateRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Date date = (Date)value;
            DateFormat df = DateFormat.getDateInstance(3);
            DateFormat tf = DateFormat.getTimeInstance(3);
            FieldPosition dayPos = new FieldPosition(3);
            FieldPosition monthPos = new FieldPosition(2);
            FieldPosition yearPos = new FieldPosition(1);
            FieldPosition AMPMPos = new FieldPosition(14);
            FieldPosition hour0Pos = new FieldPosition(5);
            FieldPosition hour1Pos = new FieldPosition(15);
            FieldPosition minPos = new FieldPosition(6);
            StringBuffer buf = new StringBuffer();
            df.format(date, buf, dayPos);
            int daysBeginIndex = dayPos.getBeginIndex();
            int daysEndIndex = dayPos.getEndIndex();
            String days = new String(buf).substring(daysBeginIndex, daysEndIndex);
            buf = new StringBuffer();
            df.format(date, buf, monthPos);
            int monthsBeginIndex = monthPos.getBeginIndex();
            int monthsEndIndex = monthPos.getEndIndex();
            String months = new String(buf).substring(monthsBeginIndex, monthsEndIndex);
            buf = new StringBuffer();
            df.format(date, buf, yearPos);
            int yearBeginIndex = yearPos.getBeginIndex();
            int yearEndIndex = yearPos.getEndIndex();
            String year = new String(buf).substring(yearBeginIndex, yearEndIndex);
            if (days.length() < 2) {
                buf.insert(daysBeginIndex, '0');
            }
            if (months.length() < 2) {
                buf.insert(monthsBeginIndex, '0');
            }
            if (year.length() < 2) {
                buf.insert(yearBeginIndex, '0');
            }
            String dateString = new String(buf);
            buf = new StringBuffer();
            tf.format(date, buf, AMPMPos);
            int AMPMBeginIndex = AMPMPos.getBeginIndex();
            FieldPosition hourPos = AMPMBeginIndex > 0 ? hour1Pos : hour0Pos;
            buf = new StringBuffer();
            tf.format(date, buf, hourPos);
            int hourBeginIndex = hourPos.getBeginIndex();
            int hourEndIndex = hourPos.getEndIndex();
            String hours = new String(buf).substring(hourBeginIndex, hourEndIndex);
            buf = new StringBuffer();
            tf.format(date, buf, minPos);
            int minBeginIndex = minPos.getBeginIndex();
            int minEndIndex = minPos.getEndIndex();
            String minutes = new String(buf).substring(minBeginIndex, minEndIndex);
            if (hours.length() < 2) {
                buf.insert(hourBeginIndex, '0');
            }
            if (minutes.length() < 2) {
                buf.insert(minBeginIndex, '0');
            }
            String timeString = new String(buf);
            this.setHorizontalAlignment(2);
            this.setText(" " + dateString + "  " + timeString);
            return this;
        }
    }

    protected class FileTypeRenderer
    extends GeneralLabelRenderer {
        protected FileTypeRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            FileType t = (FileType)value;
            String type = t.getFileTypeDescription();
            this.setHorizontalAlignment(2);
            this.setText("  " + type + " ");
            return this;
        }
    }

    protected class FileLengthRenderer
    extends GeneralLabelRenderer {
        protected FileLengthRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            File f = this.pane.getFileAtRow(row);
            if (!this.pane.isTraversable(f)) {
                long len = (Long)value;
                NumberFormat nf = NumberFormat.getInstance();
                nf.setMaximumFractionDigits(1);
                this.setHorizontalAlignment(4);
                if (len >= 1024L && len < 1024000L) {
                    this.setText(nf.format((double)len / 1024.0) + " " + BasicTableDirectoryPaneUI.this.getKbytesString() + "  ");
                } else if (len >= 1024000L) {
                    this.setText(nf.format((double)len / 1024000.0) + " " + BasicTableDirectoryPaneUI.this.getMbytesString() + "  ");
                } else {
                    this.setText(len + "  ");
                }
            } else {
                this.setText("");
            }
            return this;
        }
    }

    protected class FileNameRenderer
    extends GeneralLabelRenderer {
        protected FileNameRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            File f = (File)value;
            String name = this.pane.getName(f);
            this.setHorizontalAlignment(2);
            this.setText(name);
            Icon icon = null;
            icon = this.pane.getTypeIcon(f);
            if (icon != null) {
                this.setIcon(icon);
            }
            return this;
        }
    }

    protected class IconRenderer
    extends GeneralLabelRenderer {
        protected IconRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Icon icon = (Icon)value;
            this.setHorizontalAlignment(0);
            this.setIcon(icon);
            return this;
        }
    }

    protected class NumberRenderer
    extends GeneralLabelRenderer {
        protected NumberRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Number num = (Number)value;
            this.setHorizontalAlignment(4);
            NumberFormat formatter = NumberFormat.getInstance();
            this.setText(formatter.format(num));
            return this;
        }
    }

    protected class StringRenderer
    extends GeneralLabelRenderer {
        protected StringRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String s = (String)value;
            this.setHorizontalAlignment(2);
            this.setText("  " + s + " ");
            return this;
        }
    }

    protected class GenericRenderer
    extends GeneralLabelRenderer {
        protected GenericRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String s = value.toString();
            this.setHorizontalAlignment(2);
            this.setText("  " + s + " ");
            return this;
        }
    }

    protected class GeneralLabelRenderer
    extends JLabel
    implements TableCellRenderer {
        protected final TableDirectoryPane pane;
        protected boolean isSelected;
        protected Color bColor;

        public GeneralLabelRenderer() {
            this.pane = BasicTableDirectoryPaneUI.this.getDirectoryPane();
            this.setOpaque(false);
        }

        protected void setLabelColors() {
            this.setBackground(BasicTableDirectoryPaneUI.this.getPaneBackground());
            if (this.pane.isPaintSelectionOnlyWhenActive()) {
                if (this.pane.isActivePane() && this.isSelected) {
                    this.setForeground(BasicTableDirectoryPaneUI.this.getPaneSelectionForeground());
                    this.bColor = BasicTableDirectoryPaneUI.this.getPaneSelectionBackground();
                } else {
                    this.setForeground(BasicTableDirectoryPaneUI.this.getPaneForeground());
                    this.bColor = BasicTableDirectoryPaneUI.this.getPaneBackground();
                }
            } else if (this.isSelected) {
                this.setForeground(BasicTableDirectoryPaneUI.this.getPaneSelectionForeground());
                this.bColor = BasicTableDirectoryPaneUI.this.getPaneSelectionBackground();
            } else {
                this.setForeground(BasicTableDirectoryPaneUI.this.getPaneForeground());
                this.bColor = BasicTableDirectoryPaneUI.this.getPaneBackground();
            }
        }

        public void paint(Graphics g) {
            if (this.bColor != null) {
                g.setColor(this.bColor);
                Icon currentI = this.getIcon();
                if (currentI != null && this.getText() != null) {
                    int offset = currentI.getIconWidth() + this.getIconTextGap() - 2;
                    g.fillRect(offset, 0, this.getWidth() - offset, this.getHeight());
                } else {
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
            }
            super.paint(g);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.isSelected = isSelected;
            if (hasFocus) {
                LineBorder focusBorder = (LineBorder)UIManager.getBorder("Table.focusCellHighlightBorder");
                this.setBorder(new MatteBorder(1, 0, 1, 0, focusBorder.getLineColor()));
            } else {
                this.setBorder(new EmptyBorder(1, 0, 1, 0));
            }
            this.setFont(BasicTableDirectoryPaneUI.this.getPaneFont());
            this.setLabelColors();
            return this;
        }
    }

    protected class CustomTable
    extends JTable {
        private String viewMode;
        private final TableDirectoryPane pane;

        public CustomTable(TableModel tm, TableColumnModel cm, TableSelectionModel sm) {
            super(tm, cm, sm);
            this.pane = BasicTableDirectoryPaneUI.this.getDirectoryPane();
            this.viewMode = BasicTableDirectoryPaneUI.this.getViewCache();
            this.getModel().removeTableModelListener(this);
        }

        public String getUIClassID() {
            return BasicTableDirectoryPaneUI.CustomTable_uiClassID;
        }

        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            boolean result = false;
            if (this.editorComp == null) {
                condition = 0;
            }
            result = super.processKeyBinding(ks, e, condition, pressed);
            return result;
        }

        protected void configureEnclosingScrollPane() {
            Container gp;
            Container p = this.getParent();
            if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
                JScrollPane scrollPane = (JScrollPane)gp;
                JViewport viewport = scrollPane.getViewport();
                if (viewport == null || viewport.getView() != this) {
                    return;
                }
                if (this.viewMode.equals("detailsview")) {
                    scrollPane.setColumnHeaderView(this.getTableHeader());
                } else if (this.viewMode.equals("listview")) {
                    scrollPane.setColumnHeaderView(null);
                }
                scrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            int firstIndex = e.getFirstIndex();
            int lastIndex = e.getLastIndex();
            if (firstIndex == -1 && lastIndex == -1) {
                this.repaint();
                return;
            }
            Rectangle firstRowRect = this.getCellRect(firstIndex, 0, false);
            Rectangle lastRowRect = this.getCellRect(lastIndex, this.getColumnCount(), false);
            Rectangle dirtyRegion = firstRowRect.union(lastRowRect);
            this.repaint(dirtyRegion.x, dirtyRegion.y, dirtyRegion.width, dirtyRegion.height);
            int[] indices = ((TableSelectionModel)this.getSelectionModel()).getSelectedIndices();
            if (indices.length > 0) {
                firstRowRect = this.getCellRect(indices[0], 0, false);
                lastRowRect = this.getCellRect(indices[indices.length - 1], this.getColumnCount(), false);
                dirtyRegion = firstRowRect.union(lastRowRect);
                this.repaint(dirtyRegion.x, dirtyRegion.y, dirtyRegion.width, dirtyRegion.height);
            }
        }

        public boolean getScrollableTracksViewportHeight() {
            if (this.getParent() instanceof JViewport) {
                return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
            }
            return false;
        }

        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Object value = this.getValueAt(row, column);
            boolean isSelected = this.isRowSelected(row);
            boolean rowIsLead = this.getSelectionModel().getLeadSelectionIndex() == row;
            boolean hasFocus = rowIsLead && (this.hasFocus() || this.isEditing());
            return renderer.getTableCellRendererComponent(this, value, isSelected, hasFocus, row, column);
        }

        public boolean editCellAt(int row, int column, EventObject e) {
            TableColumn tableColumn;
            TableCellEditor editor;
            if (!this.isCellEditable(row, column) || this.getSelectionModel().getLeadSelectionIndex() != row) {
                return false;
            }
            if (this.isEditing() && this.cellEditor != null) {
                this.cellEditor.cancelCellEditing();
            }
            if ((editor = (tableColumn = this.getColumnModel().getColumn(column)).getCellEditor()) == null) {
                editor = this.getDefaultEditor(this.getColumnClass(column));
            }
            if (editor != null) {
                this.editorComp = this.prepareEditor(editor, row, column);
                if (editor.isCellEditable(e)) {
                    this.editorComp.setBounds(this.getCellRect(row, column, false));
                    this.add(this.editorComp);
                    this.editorComp.validate();
                    this.editorComp.requestFocus();
                    boolean shouldSelect = editor.shouldSelectCell(e);
                    this.setCellEditor(editor);
                    this.setEditingRow(row);
                    this.setEditingColumn(column);
                    editor.addCellEditorListener(this);
                    this.repaint();
                    return true;
                }
            }
            return false;
        }

        public void editingStopped(ChangeEvent e) {
            if (this.cellEditor != null) {
                Object value = this.cellEditor.getCellEditorValue();
                File oldFile = BasicTableDirectoryPaneUI.this.getDirectoryPane().getFileAtRow(this.editingRow);
                BasicTableDirectoryPaneUI.this.getDirectoryPane().renameFile(oldFile, (String)value);
                this.removeEditor();
            }
        }

        public void removeEditor() {
            TableCellEditor editor = this.getCellEditor();
            if (editor != null) {
                editor.removeCellEditorListener(this);
                this.remove(this.editorComp);
                if (this.pane.isActivePane() && (!(this.editorComp instanceof JComponent) || ((JComponent)this.editorComp).hasFocus())) {
                    this.requestFocus();
                }
                Rectangle cellRect = this.getCellRect(this.editingRow, this.editingColumn, false);
                this.setCellEditor(null);
                this.setEditingColumn(-1);
                this.setEditingRow(-1);
                this.editorComp = null;
                this.repaint(cellRect);
            }
        }

        public void tableChanged(TableModelEvent e) {
            Rectangle dirtyRegion;
            if (e == null || e.getFirstRow() == -1) {
                this.clearSelection();
                if (this.getAutoCreateColumnsFromModel()) {
                    this.createDefaultColumnsFromModel();
                }
                this.resizeAndRepaint();
                if (this.tableHeader != null) {
                    this.tableHeader.resizeAndRepaint();
                }
                return;
            }
            if (e.getType() == 1) {
                this.tableRowsInserted(e);
                return;
            }
            if (e.getType() == -1) {
                this.tableRowsDeleted(e);
                return;
            }
            int modelColumn = e.getColumn();
            int start = e.getFirstRow();
            int end = e.getLastRow();
            if (start == -1) {
                start = 0;
                end = Integer.MAX_VALUE;
            }
            int rowHeight = this.getRowHeight() + this.rowMargin;
            if (modelColumn == -1) {
                dirtyRegion = new Rectangle(0, start * rowHeight, this.getColumnModel().getTotalColumnWidth(), 0);
            } else {
                int column = this.convertColumnIndexToView(modelColumn);
                dirtyRegion = this.getCellRect(start, column, false);
            }
            if (end != Integer.MAX_VALUE) {
                dirtyRegion.height = (end - start + 1) * rowHeight;
                this.repaint(dirtyRegion.x, dirtyRegion.y, dirtyRegion.width, dirtyRegion.height);
            } else {
                this.resizeAndRepaint();
            }
        }

        private void tableRowsInserted(TableModelEvent e) {
            int start = e.getFirstRow();
            int end = e.getLastRow();
            if (start < 0) {
                start = 0;
            }
            int rowHeight = this.getRowHeight() + this.rowMargin;
            Rectangle drawRect = new Rectangle(0, start * rowHeight, this.getColumnModel().getTotalColumnWidth(), (this.getRowCount() - start) * rowHeight);
            if (this.selectionModel != null) {
                if (end < 0) {
                    end = this.getRowCount() - 1;
                }
                int length = end - start + 1;
                this.selectionModel.insertIndexInterval(start, length, true);
            }
            this.revalidate();
            this.repaint(drawRect);
        }

        private void tableRowsDeleted(TableModelEvent e) {
            int start = e.getFirstRow();
            int end = e.getLastRow();
            if (start < 0) {
                start = 0;
            }
            if (this.isEditing() && start <= this.getEditingRow() && this.getEditingRow() <= end) {
                this.getCellEditor().cancelCellEditing();
            }
            int deletedCount = e.getLastRow() - end + 1;
            int previousRowCount = this.getRowCount() + deletedCount;
            int rowHeight = this.getRowHeight() + this.rowMargin;
            Rectangle drawRect = new Rectangle(0, start * rowHeight, this.getColumnModel().getTotalColumnWidth(), (previousRowCount - start) * rowHeight);
            if (this.selectionModel != null) {
                if (end < 0) {
                    end = this.getRowCount() - 1;
                }
                this.selectionModel.removeIndexInterval(start, end);
            }
            this.revalidate();
            this.repaint(drawRect);
        }
    }

    class AutoResizer
    implements Runnable {
        private int autoResizeMode;
        private JTable uitable;

        public AutoResizer(JTable t, int mode) {
            this.uitable = t;
            this.autoResizeMode = mode;
        }

        public void run() {
            if (this.uitable != null) {
                this.uitable.setAutoResizeMode(this.autoResizeMode);
            }
        }
    }

    protected class HeaderRenderer
    implements TableCellRenderer {
        private int sortType = -1;
        private Font normalFont = DirectoryPaneUI.makeFontSmaller(UIManager.getFont("TableHeader.font"));
        private Font boldFont = new Font(this.normalFont.getName(), 1, this.normalFont.getSize());
        private Font font;

        public HeaderRenderer() {
            this(-1);
        }

        public HeaderRenderer(int sortType) {
            this.setSortType(sortType);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = new JLabel(" " + (String)value);
            label.setFont(this.font);
            label.setBorder(BorderFactory.createRaisedBevelBorder());
            label.setBackground(UIManager.getColor("TableHeader.background"));
            label.setOpaque(true);
            return label;
        }

        public void setSortType(int type) {
            switch (type) {
                case -1: {
                    this.font = this.normalFont;
                    this.sortType = type;
                    break;
                }
                case 0: {
                    this.font = this.boldFont;
                    this.sortType = type;
                    break;
                }
                case 1: {
                    this.font = this.boldFont;
                    this.sortType = type;
                    break;
                }
                default: {
                    this.font = this.normalFont;
                    this.sortType = -1;
                }
            }
        }

        public int getSortType() {
            return this.sortType;
        }
    }

    protected class IsActivePaneListener
    implements PropertyChangeListener {
        protected IsActivePaneListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            JTable t = BasicTableDirectoryPaneUI.this.getUITable();
            Object newvalue = e.getNewValue();
            String name = e.getPropertyName();
            if (name == "isActivePane") {
                boolean active = (Boolean)newvalue;
                if (active) {
                    JComponent g = BasicTableDirectoryPaneUI.this.getUIGlass();
                    if (g != null) {
                        g.setVisible(false);
                    }
                    Color activeBG = BasicTableDirectoryPaneUI.this.getDirectoryPane().getBackground();
                    BasicTableDirectoryPaneUI.this.setPaneActiveBackground(activeBG);
                    BasicTableDirectoryPaneUI.this.setPaneBackground(activeBG);
                    BasicTableDirectoryPaneUI.this.getUIScroller().setBackground(activeBG);
                    t.setBackground(activeBG);
                    t.requestFocus();
                } else {
                    JComponent g;
                    if (t.isEditing()) {
                        t.removeEditor();
                    }
                    if ((g = BasicTableDirectoryPaneUI.this.getUIGlass()) != null) {
                        g.setVisible(true);
                    }
                    Color notActiveBG = BasicTableDirectoryPaneUI.this.getDirectoryPane().getNotActiveBackground();
                    BasicTableDirectoryPaneUI.this.setPaneNotActiveBackground(notActiveBG);
                    BasicTableDirectoryPaneUI.this.setPaneBackground(notActiveBG);
                    BasicTableDirectoryPaneUI.this.getUIScroller().setBackground(notActiveBG);
                    t.setBackground(notActiveBG);
                }
            }
        }
    }

    protected class TableLoadingListener
    implements LoadingListener {
        protected TableLoadingListener() {
        }

        public void loadingChanged(LoadingEvent e) {
            int eventType = e.getType();
            TableDirectoryPane pane = BasicTableDirectoryPaneUI.this.getDirectoryPane();
            if (eventType == 0) {
                pane.setLoading(true);
                BasicTableDirectoryPaneUI.this.setWaitCursor();
            } else if (eventType == 1) {
                pane.setLoading(false);
                if (BasicTableDirectoryPaneUI.this.viewCache.equals("listview")) {
                    BasicTableDirectoryPaneUI.this.setDefaultCursor();
                    return;
                }
                int[] info = new int[]{0, 1};
                pane.setLastSortedColumnInfo(info);
                int viewcolumn = BasicTableDirectoryPaneUI.this.getUITable().convertColumnIndexToView(0);
                TableColumn col = BasicTableDirectoryPaneUI.this.columnModel.getColumn(viewcolumn);
                HeaderRenderer renderer = (HeaderRenderer)col.getHeaderRenderer();
                renderer.setSortType(1);
                int count = BasicTableDirectoryPaneUI.this.columnModel.getColumnCount();
                int i = 0;
                while (i < count) {
                    TableColumn c = BasicTableDirectoryPaneUI.this.columnModel.getColumn(i);
                    HeaderRenderer r = (HeaderRenderer)c.getHeaderRenderer();
                    if (i != viewcolumn) {
                        r.setSortType(-1);
                    }
                    ++i;
                }
                BasicTableDirectoryPaneUI.this.getUITable().getTableHeader().repaint();
                BasicTableDirectoryPaneUI.this.setDefaultCursor();
            }
        }
    }

    protected class UITableFocusListener
    extends FocusAdapter {
        protected UITableFocusListener() {
        }

        public void focusGained(FocusEvent ignored) {
            if (!BasicTableDirectoryPaneUI.this.getDirectoryPane().isActivePane()) {
                BasicTableDirectoryPaneUI.this.getDirectoryPane().setActivePane(true);
            }
        }
    }

    protected class UITableMouseListener
    extends MouseAdapter {
        protected UITableMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            Point p = e.getPoint();
            int selRow = BasicTableDirectoryPaneUI.this.getUITable().rowAtPoint(p);
            if (selRow > -1 && !SwingUtilities.isRightMouseButton(e) && e.getClickCount() == 2) {
                BasicTableDirectoryPaneUI.this.getDirectoryPane().performDoubleClick();
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) && BasicTableDirectoryPaneUI.this.getDirectoryPane().hasPopupMenu()) {
                JPopupMenu popup = BasicTableDirectoryPaneUI.this.getDirectoryPane().getPopupMenu();
                MouseEvent popevent = SwingUtilities.convertMouseEvent(BasicTableDirectoryPaneUI.this.getUITable(), e, popup.getInvoker());
                popup.show(popup.getInvoker(), popevent.getX(), popevent.getY());
            }
        }

        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) && BasicTableDirectoryPaneUI.this.getDirectoryPane().hasPopupMenu()) {
                JPopupMenu popup = BasicTableDirectoryPaneUI.this.getDirectoryPane().getPopupMenu();
                MouseEvent popevent = SwingUtilities.convertMouseEvent(BasicTableDirectoryPaneUI.this.getUITable(), e, popup.getInvoker());
                popup.show(popup.getInvoker(), popevent.getX(), popevent.getY());
            }
        }
    }

    protected class SortColumnListener
    extends MouseAdapter {
        protected SortColumnListener() {
        }

        public void mouseClicked(MouseEvent e) {
            JTable t = BasicTableDirectoryPaneUI.this.getUITable();
            BasicTableDirectoryPaneUI.this.getDirectoryPane().setActivePane(true);
            JTableHeader header = (JTableHeader)e.getSource();
            TableColumnModel cm = t.getColumnModel();
            int viewcolumn = cm.getColumnIndexAtX(e.getX());
            int column = t.convertColumnIndexToModel(viewcolumn);
            int count = cm.getColumnCount();
            if (column != -1) {
                boolean ascending;
                BasicTableDirectoryPaneUI.this.setWaitCursor();
                TableColumn col = cm.getColumn(viewcolumn);
                HeaderRenderer renderer = (HeaderRenderer)col.getHeaderRenderer();
                int state = renderer.getSortType();
                switch (state) {
                    case -1: {
                        renderer.setSortType(1);
                        ascending = true;
                        break;
                    }
                    case 0: {
                        renderer.setSortType(1);
                        ascending = true;
                        break;
                    }
                    case 1: {
                        renderer.setSortType(0);
                        ascending = false;
                        break;
                    }
                    default: {
                        renderer.setSortType(1);
                        ascending = true;
                    }
                }
                int[] lastSortedInfo = new int[]{column, ((HeaderRenderer)col.getHeaderRenderer()).getSortType()};
                BasicTableDirectoryPaneUI.this.getDirectoryPane().setLastSortedColumnInfo(lastSortedInfo);
                int i = 0;
                while (i < count) {
                    TableColumn c = cm.getColumn(i);
                    HeaderRenderer r = (HeaderRenderer)c.getHeaderRenderer();
                    if (i != viewcolumn) {
                        r.setSortType(-1);
                    }
                    ++i;
                }
                header.repaint();
                Vector selbuf = BasicTableDirectoryPaneUI.this.getDirectoryPane().getSelectedRows();
                Object[] anchor = null;
                Object[] lead = null;
                if (BasicTableDirectoryPaneUI.this.getDirectoryPane().getAnchorSelectionIndex() > -1) {
                    anchor = BasicTableDirectoryPaneUI.this.directoryModel.getRowAt(BasicTableDirectoryPaneUI.this.getDirectoryPane().getAnchorSelectionIndex());
                }
                if (BasicTableDirectoryPaneUI.this.getDirectoryPane().getLeadSelectionIndex() > -1) {
                    lead = BasicTableDirectoryPaneUI.this.directoryModel.getRowAt(BasicTableDirectoryPaneUI.this.getDirectoryPane().getLeadSelectionIndex());
                }
                if (t.isEditing() && BasicTableDirectoryPaneUI.this.editor != null) {
                    BasicTableDirectoryPaneUI.this.editor.cancelCellEditing();
                }
                BasicTableDirectoryPaneUI.this.directoryModel.sortModelByColumn(column, ascending);
                int anchorIndex = -1;
                int leadIndex = -1;
                if (anchor != null) {
                    anchorIndex = BasicTableDirectoryPaneUI.this.directoryModel.indexOf(anchor);
                }
                if (lead != null) {
                    leadIndex = BasicTableDirectoryPaneUI.this.directoryModel.indexOf(lead);
                }
                BasicTableDirectoryPaneUI.this.tableSelectionModel.updateSelection(BasicTableDirectoryPaneUI.this.getSortedSelectionIndices(selbuf), anchorIndex, leadIndex);
                BasicTableDirectoryPaneUI.this.setDefaultCursor();
            }
        }
    }
}

