/*
 * Decompiled with CFR 0.152.
 */
package fontviewer;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class ApplicationProperties {
    public static final String propertiesFilename = "fontviewer_properties.ini";
    public static final String HEIGHT_PROP = "height";
    public static final String WIDTH_PROP = "width";
    public static final String X_PROP = "x";
    public static final String Y_PROP = "y";
    public static final String LOCALE_LANGUAGE = "language";
    public static final String LOCALE_COUNTRY = "country";
    public static final String FONT_PATHS = "font.paths";
    public static final String FONT_PATH_NAME = "font.path.";
    public static final String SKIN = "skin";
    public static final String SPLIT_LOCATION = "split.location";
    public static final String EXTENDED_STATE = "extended.state";
    private Properties props = new Properties();

    public ApplicationProperties() {
        try {
            FileInputStream fileInputStream = new FileInputStream(System.getProperty("user.home") + System.getProperty("file.separator") + propertiesFilename);
            this.props.load(fileInputStream);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.loadDefaultProperties();
        }
        catch (IOException iOException) {
            this.loadDefaultProperties();
        }
    }

    public void clearProperties() {
        this.props.clear();
    }

    public String getProperty(String string) {
        return this.props.getProperty(string);
    }

    private void loadDefaultProperties() {
        this.props.setProperty(WIDTH_PROP, "640");
        this.props.setProperty(HEIGHT_PROP, "480");
        this.props.setProperty(X_PROP, "100");
        this.props.setProperty(Y_PROP, "100");
        this.props.setProperty(LOCALE_LANGUAGE, "en");
        this.props.setProperty(LOCALE_COUNTRY, "US");
        this.props.setProperty(FONT_PATHS, "0");
        this.props.setProperty(SKIN, "org.pushingpixels.substance.api.skin.SubstanceCremeLookAndFeel");
        this.props.setProperty(SPLIT_LOCATION, "-1");
        this.props.setProperty(EXTENDED_STATE, "0");
    }

    public void saveProperties() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(System.getProperty("user.home") + System.getProperty("file.separator") + propertiesFilename);
            this.props.store(fileOutputStream, "FontViewer Properties");
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException.getLocalizedMessage());
        }
    }

    public void setProperty(String string, String string2) {
        this.props.setProperty(string, string2);
    }
}

