/*
 * Created on 12.09.2006
 */
package de.ssfuture.tools.jfonttools.fontanalyser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/**
 * @author Sebastian Schleemilch
 */
public class FontStudio extends JPanel implements ChangeListener, ActionListener {
	JTextArea area = new JTextArea();
	JSlider fontsize = new JSlider(1, 250);
	JToggleButton fontstyle_bold = new JToggleButton("bold");
	JToggleButton fontstyle_italic = new JToggleButton("italic");
	JButton bgcolor = new JButton("BG");
	JButton fgcolor = new JButton("FG");
	
	public FontStudio(Font font) {
		super(new BorderLayout());
		area.setText( "Edit me: " + font.getName() );
		area.setFont( font.deriveFont( (float) 12.0 ) );
		area.setBackground(Color.white);
		area.setForeground(Color.black);
		
		fontsize.addChangeListener(this);
		fontsize.setValue(12);
		
		fontstyle_bold.addChangeListener(this);
		fontstyle_italic.addChangeListener(this);
		
		bgcolor.setToolTipText("Background color");
		bgcolor.setForeground(Color.white);
		bgcolor.setBackground(invert(Color.white));
		bgcolor.addActionListener(this);
		fgcolor.setToolTipText("Foreground color");
		fgcolor.setForeground(Color.black);
		fgcolor.setBackground(invert(Color.black));
		fgcolor.addActionListener(this);
		
		
		JPanel buttonpanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
		buttonpanel.add(fontstyle_bold);
		buttonpanel.add(fontstyle_italic);
		buttonpanel.add(bgcolor);
		buttonpanel.add(fgcolor);
		
		JPanel toolpanel = new JPanel();
		toolpanel.add(buttonpanel, "North");
		toolpanel.add(fontsize, "South");
		
		add(toolpanel, "North");
		add(new JScrollPane(area), "Center");
				
	}
	
	public void stateChanged(ChangeEvent e) {
		Object src = e.getSource();
		if(src.equals(fontsize)) {
			area.setFont( 
					area.getFont().deriveFont((float)fontsize.getValue())
			);
			fontsize.setToolTipText("Font size: " + fontsize.getValue());
		}
		else if(src.equals(fontstyle_bold) || src.equals(fontstyle_italic)) {
			int style = 0;
			if(fontstyle_bold.isSelected())
				style = Font.BOLD;
			if(fontstyle_italic.isSelected())
				style += Font.ITALIC;
			if(style == 0) style = Font.PLAIN;
			area.setFont(
					area.getFont().deriveFont(style)
			);
		}
	}
	
	public void actionPerformed(ActionEvent e) {
		Object src = e.getSource();
		if(src.equals(bgcolor)) {
			Color color = JColorChooser.showDialog(
					this, "Select background color", area.getBackground());
			if(color != null) {
				bgcolor.setForeground(color);
				bgcolor.setBackground(invert(color));
				area.setBackground(color);
			}
		}
		else if(src.equals(fgcolor)) {
			Color color = JColorChooser.showDialog(
					this, "Select foreground color", area.getForeground());
			if(color != null) {
				fgcolor.setForeground(color);
				fgcolor.setBackground(invert(color));
				area.setForeground(color);
			}
		}
	}
	
	public Color invert(Color origin) {
		return new Color( origin.getRGB() ^ 0xFFFFFF );
	}
}
