/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import java.io.IOException;
import java.io.OutputStream;
import mindbright.security.Cipher;
import mindbright.ssh.SSHChannelController;
import mindbright.ssh.SSHClient;
import mindbright.ssh.SSHConsole;
import mindbright.terminal.Terminal;

public final class SSHCaptureConsole
implements SSHConsole {
    SSHConsole realConsole;
    OutputStream captureOut;
    SSHClient client;

    public SSHCaptureConsole(SSHClient sSHClient, OutputStream outputStream) {
        this.realConsole = sSHClient.getConsole();
        this.captureOut = outputStream;
        this.client = sSHClient;
        sSHClient.setConsole(this);
    }

    public Terminal getTerminal() {
        return this.realConsole.getTerminal();
    }

    public void stdoutWriteString(byte[] byArray) {
        this.capture(new String(byArray));
        this.realConsole.stdoutWriteString(byArray);
    }

    public void stderrWriteString(byte[] byArray) {
        this.capture(new String(byArray));
        this.realConsole.stderrWriteString(byArray);
    }

    public void print(String string) {
        this.capture(string);
        this.realConsole.print(string);
    }

    public void println(String string) {
        this.capture(string);
        this.realConsole.println(string);
    }

    void capture(String string) {
        try {
            this.captureOut.write(string.getBytes());
            this.captureOut.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void endCapture() {
        this.client.setConsole(this.realConsole);
        try {
            this.captureOut.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void serverConnect(SSHChannelController sSHChannelController, Cipher cipher) {
        this.realConsole.serverConnect(sSHChannelController, cipher);
    }

    public void serverDisconnect(String string) {
        this.realConsole.serverDisconnect(string);
    }
}

