/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.UnknownHostException;
import mindbright.net.WebProxyException;
import mindbright.ssh.SSH;
import mindbright.ssh.SSHChannelController;
import mindbright.ssh.SSHClient;
import mindbright.ssh.SSHInteractor;
import mindbright.ssh.SSHMenuHandler;
import mindbright.ssh.SSHPduOutputStream;
import mindbright.ssh.SSHPropertyHandler;
import mindbright.ssh.SSHStdIO;
import mindbright.terminal.Terminal;
import mindbright.terminal.TerminalWin;

public final class SSHInteractiveClient
extends SSHClient
implements Runnable,
SSHInteractor {
    public static final boolean expires = false;
    public static final boolean licensed = false;
    public static final String licenseMessage = "This copy of MindTerm is licensed to ";
    public static final String licensee = "nobody";
    public static final long validFrom = 981400361829L;
    public static final long validTime = 2851200000L;
    public static boolean wantHelpInfo = true;
    public static String customStartMessage = null;
    Thread dumbConsoleThread;
    SSHMenuHandler menus;
    SSHStdIO sshStdIO;
    SSHPropertyHandler propsHandler;
    public boolean quiet;
    boolean initQuiet;

    public SSHStdIO getIO() {
        return this.sshStdIO;
    }

    public static String copyright() {
        return "Copyright (c) 1998-2000 by Mindbright Technology AB, Stockholm, Sweden\r\nSCP modifications copyright (c) 2001 by ISNetworks, Seattle, WA";
    }

    public SSHInteractiveClient(boolean bl, boolean bl2, SSHPropertyHandler sSHPropertyHandler) {
        super(sSHPropertyHandler, sSHPropertyHandler);
        this.propsHandler = sSHPropertyHandler;
        this.interactor = this;
        sSHPropertyHandler.setInteractor(this);
        sSHPropertyHandler.setClient(this);
        this.quiet = bl;
        this.initQuiet = bl;
        this.setConsole(new SSHStdIO());
        this.sshStdIO = (SSHStdIO)this.console;
        this.sshStdIO.setClient(this);
        this.sshStdIO.enableCommandShell(bl2);
    }

    public SSHInteractiveClient(SSHInteractiveClient sSHInteractiveClient) {
        this(true, sSHInteractiveClient.sshStdIO.hasCommandShell(), new SSHPropertyHandler(sSHInteractiveClient.propsHandler));
        this.activateTunnels = false;
    }

    public void setMenus(SSHMenuHandler sSHMenuHandler) {
        this.menus = sSHMenuHandler;
    }

    public SSHPropertyHandler getPropertyHandler() {
        return this.propsHandler;
    }

    public void updateMenus() {
        if (this.menus != null) {
            this.menus.update();
        }
    }

    public void printCopyright() {
        this.console.println(SSHInteractiveClient.copyright());
        if (customStartMessage != null) {
            this.console.println(customStartMessage);
        }
    }

    void printHelpInfo() {
        if (!wantHelpInfo) {
            return;
        }
        if (this.propsHandler.getSSHHomeDir() != null) {
            this.console.println("MindTerm home: " + this.propsHandler.getSSHHomeDir());
        }
        if (this.sshStdIO.hasCommandShell()) {
            this.console.println("\tpress <ctrl> + 'D' to enter local command shell");
            if (this.isDumb()) {
                this.console.println("\t(...you might have to press ENTER also...)");
            }
        }
        if (this.menus != null && this.menus.havePopupMenu) {
            this.console.println("\tpress <ctrl> + <mouse-" + this.menus.getPopupButton() + "> for main-menu");
        }
        this.console.println("");
    }

    boolean hasExpired() {
        boolean bl = false;
        long l = System.currentTimeMillis();
        int n = (int)((l - 981400361829L) / 86400000L);
        this.console.println("");
        this.console.println("This is a demo version of MindTerm, it is " + n + " days old.");
        this.console.println("Please go to http://www.mindbright.se/mindterm/");
        this.console.println("\tto check for new versions of the MindBright release now and then");
        this.console.println("Or go to http://www.isnetworks.com/ssh/");
        this.console.println("\tto check for new versions of the ISNetworks modifications");
        this.console.println("");
        return bl;
    }

    void initRandomSeed() {
        this.console.print("Initializing random generator, please wait...");
        SSH.initSeedGenerator();
        this.console.println("done");
    }

    public void doSingleCommand(String string, boolean bl, long l) throws IOException {
        boolean bl2 = this.propsHandler.wantPTY() && this.isDumb();
        this.initRandomSeed();
        this.console.println("");
        this.printHelpInfo();
        this.commandLine = string;
        this.bootSSH(false);
        if (bl2) {
            this.startDumbConsole();
        }
        if (bl) {
            this.startExitMonitor(l);
        } else {
            this.waitForExit(l);
        }
        if (bl2) {
            this.stopDumbConsole();
        }
    }

    public void run() {
        this.initRandomSeed();
        if (this.hasExpired()) {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(100000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        boolean bl = true;
        while (bl) {
            boolean bl2 = false;
            boolean bl3 = false;
            try {
                this.console.println("");
                this.printHelpInfo();
                this.bootSSH(true);
                if (this.isDumb()) {
                    this.startDumbConsole();
                }
                this.controller.waitForExit();
                if (this.isDumb()) {
                    this.stopDumbConsole();
                }
                if (this.sshStdIO.isConnected()) {
                    this.sshStdIO.serverDisconnect("\n\r\n\rServer died or connection lost");
                }
                Thread.sleep(1000L);
                try {
                    this.propsHandler.checkSave();
                }
                catch (IOException iOException) {
                    this.alert("Error saving settings!");
                }
            }
            catch (SSHClient.AuthFailException authFailException) {
                this.console.println("");
                this.console.println(authFailException.getMessage());
                this.propsHandler.clearPasswords();
            }
            catch (WebProxyException webProxyException) {
                this.console.println("");
                this.console.println(webProxyException.getMessage());
                this.propsHandler.clearPasswords();
            }
            catch (SSHStdIO.CtrlDPressedException ctrlDPressedException) {
                bl2 = true;
            }
            catch (SSHStdIO.SSHExternalMessage sSHExternalMessage) {
                bl3 = true;
                this.console.println("");
                this.console.println(sSHExternalMessage.getMessage());
            }
            catch (UnknownHostException unknownHostException) {
                String string = unknownHostException.getMessage();
                if (this.propsHandler.getProperty("proxytype").equals("none")) {
                    this.console.println("Unknown host: " + string);
                } else {
                    this.console.println("Unknown proxy host: " + string);
                }
                this.propsHandler.clearServerSetting();
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.console.println("File not found: " + fileNotFoundException.getMessage());
            }
            catch (Exception exception) {
                String string = exception.getMessage();
                if (string == null || string.trim().length() == 0) {
                    string = exception.toString();
                }
                this.console.println("");
                this.console.println("Error connecting to " + this.propsHandler.getProperty("server") + ", reason:");
                this.console.println("-> " + string);
                if (SSH.DEBUGMORE) {
                    System.out.println("If an error occured, please send the below stacktrace to mats@mindbright.se");
                    exception.printStackTrace();
                }
            }
            catch (ThreadDeath threadDeath) {
                if (this.controller != null) {
                    this.controller.killAll();
                }
                this.controller = null;
                throw threadDeath;
            }
            this.propsHandler.passivateProperties();
            this.activateTunnels = true;
            this.propsHandler.currentPropsFile = null;
            if (!this.propsHandler.savePasswords || this.usedOTP) {
                this.propsHandler.clearPasswords();
            }
            if (!bl3) {
                if (!this.propsHandler.autoLoadProps) {
                    this.propsHandler.clearPasswords();
                    this.initQuiet = false;
                }
                this.quiet = false;
            }
            this.controller = null;
            TerminalWin terminalWin = this.getTerminalWin();
            if (terminalWin != null) {
                terminalWin.setTitle(null);
            }
            if (!bl2 || !this.sshStdIO.hasCommandShell()) continue;
            bl = this.sshStdIO.commandShell.doCommandShell();
        }
    }

    public boolean isDumb() {
        return this.console.getTerminal() == null;
    }

    public TerminalWin getTerminalWin() {
        Terminal terminal = this.console.getTerminal();
        if (terminal != null && terminal instanceof TerminalWin) {
            return (TerminalWin)terminal;
        }
        return null;
    }

    public void startDumbConsole() {
        DumbConsoleThread dumbConsoleThread = new DumbConsoleThread(this.controller, this.sshStdIO);
        this.dumbConsoleThread = new Thread(SSH.getThreadGroup(), dumbConsoleThread);
        this.dumbConsoleThread.start();
    }

    public void stopDumbConsole() {
        this.dumbConsoleThread.stop();
    }

    public void updateTitle() {
        this.sshStdIO.updateTitle();
    }

    public void propsStateChanged(SSHPropertyHandler sSHPropertyHandler) {
        this.updateMenus();
    }

    public void startNewSession(SSHClient sSHClient) {
    }

    public void sessionStarted(SSHClient sSHClient) {
        this.quiet = this.initQuiet;
    }

    public boolean quietPrompts() {
        return this.commandLine != null || this.quiet;
    }

    public boolean isVerbose() {
        return wantHelpInfo;
    }

    public String promptLine(String string, String string2) throws IOException {
        return this.sshStdIO.promptLine(string, string2, false);
    }

    public String promptPassword(String string) throws IOException {
        return this.sshStdIO.promptLine(string, "", true);
    }

    public boolean askConfirmation(String string, boolean bl) {
        boolean bl2 = false;
        try {
            bl2 = this.askConfirmation(string, true, bl);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl2;
    }

    public boolean askConfirmation(String string, boolean bl, boolean bl2) throws IOException {
        boolean bl3 = false;
        if (this.menus != null && bl) {
            bl3 = this.menus.confirmDialog(string, bl2);
        } else {
            String string2 = this.promptLine(string + (bl2 ? " ([yes]/no) " : "(yes/[no]) "), "");
            if (string2.equalsIgnoreCase("yes") || string2.equals("y")) {
                bl3 = true;
            } else if (string2.equals("")) {
                bl3 = bl2;
            }
        }
        return bl3;
    }

    public void connected(SSHClient sSHClient) {
        this.updateMenus();
        if (wantHelpInfo) {
            this.console.println("Connected to server running " + this.srvVersionStr);
            if (this.sshStdIO.hasCommandShell()) {
                this.console.println("(command shell escape-sequence is '" + this.sshStdIO.commandShell.escapeString() + "')");
            }
            this.console.println("");
        }
    }

    public void open(SSHClient sSHClient) {
        this.updateMenus();
        this.updateTitle();
    }

    public void disconnected(SSHClient sSHClient, boolean bl) {
        this.sshStdIO.breakPromptLine("Login aborted by user");
        this.updateMenus();
        this.updateTitle();
    }

    public void report(String string) {
        this.console.println(string);
        this.console.println("");
    }

    public void alert(String string) {
        if (this.menus != null) {
            if (string.length() < 35) {
                this.menus.alertDialog(string);
            } else {
                this.menus.textDialog("MindTerm - Alert", string, 4, 38, true);
            }
        } else {
            this.report(string);
        }
    }

    public static class DumbConsoleThread
    implements Runnable {
        SSHChannelController controller;
        SSHStdIO console;

        public DumbConsoleThread(SSHChannelController sSHChannelController, SSHStdIO sSHStdIO) {
            this.controller = sSHChannelController;
            this.console = sSHStdIO;
        }

        public void run() {
            try {
                while (true) {
                    String string = this.console.promptLine("", "", false);
                    SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(16, this.console.sndCipher);
                    sSHPduOutputStream.writeString(string + "\n");
                    this.controller.transmit(sSHPduOutputStream);
                    Thread.sleep(400L);
                }
            }
            catch (SSHStdIO.CtrlDPressedException ctrlDPressedException) {
                this.controller.sendDisconnect("exit");
            }
            catch (Exception exception) {
                this.controller.alert("Error in console-thread: " + exception.toString());
            }
        }
    }
}

