/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import mindbright.ssh.SSHPdu;

public final class SSHPduQueue {
    static final int SSH_QUEUE_DEPTH = 512;
    static final int SSH_QUEUE_HIWATER = 384;
    Object[] queue = new Object[513];
    Object queueLock = new Object();
    boolean isWaitGet = false;
    boolean isWaitPut = false;
    int rOffset = 0;
    int wOffset = 0;
    int maxQueueDepth = 512;

    public void setMaxDepth(int n) {
        Object object = this.queueLock;
        synchronized (object) {
            this.maxQueueDepth = n;
        }
    }

    public void putLast(SSHPdu sSHPdu) {
        Object object = this.queueLock;
        synchronized (object) {
            this.putFlowControl();
            this.queue[this.wOffset++] = sSHPdu;
            if (this.wOffset == 513) {
                this.wOffset = 0;
            }
            if (this.isWaitGet) {
                this.queueLock.notify();
            }
        }
    }

    public void putFirst(SSHPdu sSHPdu) {
        Object object = this.queueLock;
        synchronized (object) {
            this.putFlowControl();
            --this.rOffset;
            if (this.rOffset == -1) {
                this.rOffset = 512;
            }
            this.queue[this.rOffset] = sSHPdu;
            if (this.isWaitGet) {
                this.queueLock.notify();
            }
        }
    }

    public void release() {
        Object object = this.queueLock;
        synchronized (object) {
            if (this.isWaitGet) {
                this.queueLock.notify();
            }
        }
    }

    public boolean isEmpty() {
        boolean bl;
        Object object = this.queueLock;
        synchronized (object) {
            bl = this.rOffset == this.wOffset;
        }
        return bl;
    }

    private final void putFlowControl() {
        int n = this.freeSpace();
        if (n == 512 - this.maxQueueDepth) {
            this.isWaitPut = true;
        }
        if (this.isWaitPut) {
            try {
                this.queueLock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private final int freeSpace() {
        int n = this.rOffset - this.wOffset;
        if (n <= 0) {
            n += 513;
        }
        return --n;
    }

    public SSHPdu getFirst() {
        SSHPdu sSHPdu = null;
        Object object = this.queueLock;
        synchronized (object) {
            if (this.isEmpty()) {
                this.isWaitGet = true;
                try {
                    this.queueLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.isWaitGet = false;
            sSHPdu = (SSHPdu)this.queue[this.rOffset];
            this.queue[this.rOffset++] = null;
            if (this.rOffset == 513) {
                this.rOffset = 0;
            }
            if (this.isWaitPut && this.freeSpace() > 128) {
                this.queueLock.notifyAll();
                this.isWaitPut = false;
            }
        }
        return sSHPdu;
    }
}

