/*
 * Decompiled with CFR 0.152.
 */
package mindbright.terminal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import mindbright.terminal.TerminalListener;
import mindbright.terminal.TerminalWin;
import mindbright.terminal.TerminalXTerm;

public final class LineReaderTerminal
implements TerminalListener {
    TerminalWin terminal;
    StringBuffer readLineStr;
    boolean echoStar;
    boolean isReadingLine;
    ExternalMessageException extMsg;

    public LineReaderTerminal(TerminalWin terminalWin) {
        this.terminal = terminalWin;
        terminalWin.addTerminalListener(this);
    }

    public void print(String string) {
        if (this.terminal != null) {
            this.terminal.write(string);
        } else {
            System.out.print(string);
        }
    }

    public void println(String string) {
        if (this.terminal != null) {
            this.terminal.write(string + "\n\r");
        } else {
            System.out.println(string);
        }
    }

    public void breakPromptLine(String string) {
        if (this.isReadingLine) {
            LineReaderTerminal lineReaderTerminal = this;
            synchronized (lineReaderTerminal) {
                this.extMsg = new ExternalMessageException(string);
                this.notify();
            }
        }
    }

    public String readLine(String string) {
        LineReaderTerminal lineReaderTerminal = this;
        synchronized (lineReaderTerminal) {
            if (string != null) {
                this.readLineStr = new StringBuffer(string);
                this.terminal.write(string);
            } else {
                this.readLineStr = new StringBuffer();
            }
            this.isReadingLine = true;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.isReadingLine = false;
        }
        return this.readLineStr.toString();
    }

    public String promptLine(String string, String string2, boolean bl) throws ExternalMessageException {
        String string3 = null;
        if (this.terminal != null) {
            this.terminal.setAttribute(1, true);
            this.terminal.write(string);
            this.terminal.setAttribute(1, false);
            this.echoStar = bl;
            string3 = this.readLine(string2);
            this.echoStar = false;
        }
        if (this.extMsg != null) {
            ExternalMessageException externalMessageException = this.extMsg;
            this.extMsg = null;
            throw externalMessageException;
        }
        return string3;
    }

    public synchronized void typedChar(char c) {
        if (this.isReadingLine) {
            if (c == '\u007f' || c == '\b') {
                if (this.readLineStr.length() > 0) {
                    boolean bl = false;
                    if (this.readLineStr.charAt(this.readLineStr.length() - 1) < ' ') {
                        bl = true;
                    }
                    this.readLineStr.setLength(this.readLineStr.length() - 1);
                    this.terminal.write('\b');
                    if (bl) {
                        this.terminal.write('\b');
                    }
                    this.terminal.write(' ');
                    if (bl) {
                        this.terminal.write(' ');
                    }
                    this.terminal.write('\b');
                    if (bl) {
                        this.terminal.write('\b');
                    }
                } else {
                    this.terminal.doBell();
                }
            } else if (c == '\r') {
                this.notify();
                this.terminal.write("\n\r");
            } else {
                this.readLineStr.append(c);
                if (this.echoStar) {
                    this.terminal.write('*');
                } else {
                    this.terminal.write(c);
                }
            }
        }
    }

    public void sendBytes(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            this.typedChar((char)byArray[n]);
            ++n;
        }
    }

    public void signalWindowChanged(int n, int n2, int n3, int n4) {
    }

    public void setSelection(String string) {
    }

    public String getSelection() {
        return null;
    }

    public void selectionAvailable(boolean bl) {
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame();
        TerminalWin terminalWin = new TerminalWin(frame, new TerminalXTerm());
        LineReaderTerminal lineReaderTerminal = new LineReaderTerminal(terminalWin);
        frame.setLayout(new BorderLayout());
        frame.add((Component)terminalWin.getPanelWithScrollbar(), "Center");
        frame.pack();
        frame.show();
        lineReaderTerminal.println("Now entering lines...");
        try {
            while (true) {
                String string = lineReaderTerminal.promptLine("prompt> ", "", false);
                System.out.println("line: " + string);
            }
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception);
            return;
        }
    }

    public static class ExternalMessageException
    extends Exception {
        public ExternalMessageException(String string) {
            super(string);
        }
    }
}

