/*
 * Decompiled with CFR 0.152.
 */
package mindbright.security;

public abstract class MessageDigest {
    public static boolean useNative = false;

    public static MessageDigest getInstance(String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (useNative) {
            try {
                Class<?> clazz = Class.forName("java.security.MessageDigest");
                Class<?> clazz2 = Class.forName("mindbright.security.NativeHashState");
                MessageDigest messageDigest = (MessageDigest)clazz2.newInstance();
                messageDigest.init(string);
                return messageDigest;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        Class<?> clazz = Class.forName("mindbright.security." + string);
        return (MessageDigest)clazz.newInstance();
    }

    protected void init(String string) throws Exception {
    }

    public abstract String getName();

    public abstract void reset();

    public abstract void update(byte[] var1, int var2, int var3);

    public abstract byte[] digest();

    public abstract int blockSize();

    public abstract int hashSize();

    public final void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public int digestInto(byte[] byArray, int n) {
        byte[] byArray2 = this.digest();
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    public Object clone() throws CloneNotSupportedException {
        if (this instanceof Cloneable) {
            return super.clone();
        }
        throw new CloneNotSupportedException();
    }
}

