/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import mindbright.net.ProxyAuthenticator;
import mindbright.net.SocksProxySocket;
import mindbright.net.WebProxyTunnelSocket;
import mindbright.security.AccessDeniedException;
import mindbright.security.RSAPublicKey;
import mindbright.security.SecureRandom;
import mindbright.ssh.SSH;
import mindbright.ssh.SSHAuthenticator;
import mindbright.ssh.SSHClient;
import mindbright.ssh.SSHClientUser;
import mindbright.ssh.SSHInteractor;
import mindbright.ssh.SSHListenChannel;
import mindbright.ssh.SSHProtocolPlugin;
import mindbright.ssh.SSHRSAKeyFile;
import mindbright.ssh.SSHRSAPublicKeyFile;
import mindbright.terminal.Terminal;
import mindbright.terminal.TerminalDefProps;
import mindbright.util.EncryptedProperties;
import netscape.security.ForbiddenTargetException;
import netscape.security.PrivilegeManager;

public final class SSHPropertyHandler
implements SSHClientUser,
SSHAuthenticator,
ProxyAuthenticator {
    public static final int PROP_NAME = 0;
    public static final int PROP_VALUE = 1;
    public static final int PROP_DESC = 2;
    public static final int PROP_ALLOWED = 3;
    public static final String PROPS_FILE_EXT = ".mtp";
    public static final String GLOB_PROPS_FILE = "mindterm.mtp";
    public static final String DEF_IDFILE = "identity";
    public static final Properties defaultProperties = new Properties();
    public static final Hashtable defaultPropertyNames = new Hashtable();
    public static final String[][] defaultPropDesc = new String[][]{{"server", null, "name of server to connect to", ""}, {"realsrv", null, "real address of sshd if it is behind a firewall", ""}, {"localhst", "0.0.0.0", "address to use as localhost", ""}, {"port", String.valueOf(22), "port on server to connect to", ""}, {"proxytype", "none", "type of proxy server to connect through", SSH.listSupportedProxyTypes()}, {"proxyhost", null, "name of proxy server to connect through", ""}, {"proxyport", null, "port on proxy server to connect through", ""}, {"proxyuser", null, "username for authentication on proxy server", ""}, {"proxyproto", null, "protocol for proxy connection (e.g. 'http://')", ""}, {"usrname", null, "username to login as", ""}, {"password", null, "password for normal authentication", ""}, {"tispassword", null, "password for TIS authentication", ""}, {"rsapassword", null, "password for RSA authentication (key file)", ""}, {"prxpassword", null, "password for proxy authentication", ""}, {"cipher", SSH.getCipherName(3), "name of block cipher to use", "( " + SSH.listSupportedCiphers() + ")"}, {"authtyp", "passwd", "method of authentication", "( " + SSH.listSupportedAuthTypes() + ")"}, {"idfile", "identity", "name of file containing identity (rsa key)", ""}, {"display", "localhost:0", "local display definition (i.e. <host>:<screen>)", ""}, {"mtu", "0", "maximum packet size to use (0 means use default)", "(4096 - 256k)"}, {"escseq", "~$", "sequence of characters to type to enter local command shell", ""}, {"secrand", "0", "level of security in random seed (for generating session key)", "(0-2, 0=low and 2=high)"}, {"alive", "0", "Connection keep-alive interval in seconds (0 means none)", "(0-600)"}, {"x11fwd", "false", "indicates whether X11 display is forwarded or not", "(true/false)"}, {"prvport", "false", "indicates whether to use a privileged port or not (locally)", "(true/false)"}, {"forcpty", "true", "indicates whether to allocate a pty or not", "(true/false)"}, {"remfwd", "false", "indicates whether we allow remote connects to local forwards", "(true/false)"}, {"idhost", "true", "indicates whether to check host's host key in 'known_hosts'", "(true/false)"}, {"portftp", "false", "indicates whether to enable ftp 'PORT' command support", "(true/false)"}};
    String sshHomeDir;
    String knownHosts = "known_hosts";
    SSHRSAKeyFile keyFile;
    SSHClient client;
    SSHInteractor interactor;
    EncryptedProperties props;
    boolean activeProps;
    protected String currentPropsFile;
    protected String currentAlias;
    boolean autoSaveProps;
    boolean autoLoadProps;
    boolean savePasswords;
    boolean readonly;
    private String propertyPassword;
    public Properties initTermProps;
    protected boolean propsChanged;

    public SSHPropertyHandler(Properties properties) {
        this.setProperties(properties);
        this.activeProps = false;
        this.propsChanged = false;
    }

    public SSHPropertyHandler(SSHPropertyHandler sSHPropertyHandler) {
        this(sSHPropertyHandler.props);
        this.sshHomeDir = sSHPropertyHandler.sshHomeDir;
        this.keyFile = sSHPropertyHandler.keyFile;
        this.initTermProps = sSHPropertyHandler.initTermProps;
        this.propertyPassword = sSHPropertyHandler.propertyPassword;
        this.readonly = true;
    }

    public static SSHPropertyHandler fromFile(String string, String string2) throws IOException {
        SSHPropertyHandler sSHPropertyHandler = new SSHPropertyHandler(new Properties());
        sSHPropertyHandler.setPropertyPassword(string2);
        sSHPropertyHandler.loadAbsoluteFile(string, false);
        return sSHPropertyHandler;
    }

    public void setInteractor(SSHInteractor sSHInteractor) {
        this.interactor = sSHInteractor;
    }

    public void setClient(SSHClient sSHClient) {
        this.client = sSHClient;
    }

    public void setAutoLoadProps(boolean bl) {
        if (this.sshHomeDir != null) {
            this.autoLoadProps = bl;
        }
    }

    public void setAutoSaveProps(boolean bl) {
        if (this.sshHomeDir != null) {
            this.autoSaveProps = bl;
        }
    }

    public void setSavePasswords(boolean bl) {
        this.savePasswords = bl;
    }

    public void setReadOnly(boolean bl) {
        this.readonly = bl;
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    public void setPropertyPassword(String string) {
        if (string != null) {
            this.propertyPassword = string;
        }
    }

    public boolean emptyPropertyPassword() {
        return this.propertyPassword == null;
    }

    public void setSSHHomeDir(String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        if (string != null && !string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        try {
            PrivilegeManager.enablePrivilege("UniversalFileAccess");
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            // empty catch block
        }
        try {
            File file = new File(string.substring(0, string.length() - 1));
            if (!file.exists()) {
                if (this.interactor.askConfirmation("MindTerm home directory: '" + string + "' does not exist, create it?", true)) {
                    try {
                        file.mkdir();
                    }
                    catch (Throwable throwable) {
                        this.interactor.alert("Could not create home directory, file operations disabled.");
                        string = null;
                    }
                } else {
                    this.interactor.report("No home directory, file operations disabled.");
                    string = null;
                }
            }
        }
        catch (Throwable throwable) {
            if (this.interactor != null && this.interactor.isVerbose()) {
                this.interactor.report("Can't access local file system, file operations disabled.");
            }
            string = null;
        }
        this.sshHomeDir = string;
        if (this.sshHomeDir == null) {
            this.autoSaveProps = false;
            this.autoLoadProps = false;
        }
        if (this.interactor != null) {
            this.interactor.propsStateChanged(this);
        }
    }

    public String getSSHHomeDir() {
        return this.sshHomeDir;
    }

    public static boolean isProperty(String string) {
        return defaultPropertyNames.containsKey(string) || string.indexOf("local") == 0 || string.indexOf("remote") == 0;
    }

    public String getProperty(String string) {
        return this.props.getProperty(string);
    }

    public void setProperty(String string, String string2) throws IllegalArgumentException, NoSuchElementException {
        if (string2 == null) {
            return;
        }
        boolean bl = !string2.equals(this.getProperty(string));
        this.validateProperty(string, string2);
        if (this.activeProps) {
            this.activateProperty(string, string2);
        }
        if (bl) {
            if (this.interactor != null) {
                this.interactor.propsStateChanged(this);
            }
            this.propsChanged = bl;
        }
        ((Hashtable)this.props).put(string, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void validateProperty(String string, String string2) throws IllegalArgumentException, NoSuchElementException {
        if (string.equals("cipher")) {
            if (SSH.getCipherType(string2) != 8) return;
            throw new IllegalArgumentException("Cipher " + string2 + " not supported");
        }
        if (string.equals("authtyp")) {
            SSH.getAuthTypes(string2);
            return;
        } else {
            if (string.equals("x11fwd") || string.equals("prvport") || string.equals("forcpty") || string.equals("remfwd") || string.equals("idhost") || string.equals("portftp")) {
                if (string2.equals("true") || string2.equals("false")) return;
                throw new IllegalArgumentException("Value for " + string + " must be 'true' or 'false'");
            }
            if (string.equals("port") || string.equals("proxyport") || string.equals("mtu") || string.equals("secrand") || string.equals("alive")) {
                try {
                    int n = Integer.valueOf(string2);
                    if ((string.equals("port") || string.equals("proxyport")) && (n > 65535 || n < 0)) {
                        throw new IllegalArgumentException("Not a valid port number: " + string2);
                    }
                    if (string.equals("mtu") && n != 0 && (n > 262144 || n < 4096)) {
                        throw new IllegalArgumentException("Mtu must be between 4k and 256k");
                    }
                    if (string.equals("alive")) {
                        if (n >= 0 && n <= 600) return;
                        throw new IllegalArgumentException("Alive interval must be 0-600");
                    }
                    if (!string.equals("secrand") || n >= 0 && n <= 2) return;
                    throw new IllegalArgumentException("Secrand must be 0-2");
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Value for " + string + " must be an integer");
                }
            } else {
                if (string.equals("server")) {
                    if (this.client == null || !this.client.isOpened()) return;
                    throw new IllegalArgumentException("Server can only be set while not connected");
                }
                if (string.equals("realsrv") || string.equals("localhst")) {
                    try {
                        InetAddress.getByName(string2);
                        return;
                    }
                    catch (UnknownHostException unknownHostException) {
                        throw new IllegalArgumentException(string + " address must be a legal/known host name");
                    }
                } else if (string.equals("proxytype")) {
                    SSH.getProxyType(string2);
                    return;
                } else if (string.startsWith("local") || string.startsWith("remote")) {
                    try {
                        if (string2.startsWith("/general/")) {
                            string2 = string2.substring(9);
                        }
                        if (string.startsWith("local")) {
                            this.addLocalPortForward(string2, false);
                            return;
                        }
                        this.addRemotePortForward(string2, false);
                        return;
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException("Not a valid port forward: " + string + " : " + string2);
                    }
                } else {
                    if (SSHPropertyHandler.isProperty(string)) return;
                    throw new NoSuchElementException("Unknown ssh property '" + string + "'");
                }
            }
        }
    }

    void activateProperty(String string, String string2) {
        block29: {
            if (string.equals("remfwd")) {
                try {
                    SSHListenChannel.setAllowRemoteConnect(new Boolean(string2));
                }
                catch (Throwable throwable) {}
            } else if (string.equals("portftp")) {
                this.client.havePORTFtp = new Boolean(string2);
                if (this.client.havePORTFtp && SSHProtocolPlugin.getPlugin("ftp") != null) {
                    SSHProtocolPlugin.getPlugin("ftp").initiate(this.client);
                }
            } else if (string.equals("alive")) {
                this.client.setAliveInterval(Integer.valueOf(string2));
            } else if (string.equals("secrand")) {
                SecureRandom.secureLevel = Integer.valueOf(string2);
            } else if (string.equals("realsrv")) {
                try {
                    if (string2 != null && string2.length() > 0) {
                        this.client.setServerRealAddr(InetAddress.getByName(string2));
                        break block29;
                    }
                    this.client.setServerRealAddr(null);
                }
                catch (UnknownHostException unknownHostException) {}
            } else {
                if (string.equals("localhst")) {
                    try {
                        this.client.setLocalAddr(string2);
                    }
                    catch (UnknownHostException unknownHostException) {
                        throw new IllegalArgumentException("localhost address must be a legal/known host name");
                    }
                }
                if (string.startsWith("local")) {
                    int n = Integer.parseInt(string.substring(5));
                    if (n > this.client.localForwards.size()) {
                        throw new IllegalArgumentException("Port forwards must be given in unbroken sequence");
                    }
                    if (string2.startsWith("/general/")) {
                        string2 = string2.substring(9);
                    }
                    try {
                        this.addLocalPortForward(string2, true);
                    }
                    catch (IOException iOException) {
                        throw new IllegalArgumentException("Error creating tunnel: " + iOException.getMessage());
                    }
                }
                if (string.startsWith("remote")) {
                    try {
                        int n = Integer.parseInt(string.substring(6));
                        if (n > this.client.remoteForwards.size()) {
                            throw new IllegalArgumentException("Port forwards must be given in unbroken sequence");
                        }
                        if (string2.startsWith("/general/")) {
                            string2 = string2.substring(9);
                        }
                        this.addRemotePortForward(string2, true);
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException("Not a valid port forward: " + string + " : " + string2);
                    }
                }
            }
        }
    }

    public void setProperties(Properties properties) throws IllegalArgumentException, NoSuchElementException {
        this.props = new EncryptedProperties(defaultProperties);
        this.mergeProperties(properties);
    }

    public Properties getProperties() {
        return this.props;
    }

    public void mergeProperties(Properties properties) throws IllegalArgumentException, NoSuchElementException {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            if (!SSHPropertyHandler.isProperty(string)) {
                throw new NoSuchElementException("Unknown ssh property '" + string + "'");
            }
            ((Hashtable)this.props).put(string, string2);
        }
    }

    public Properties getInitTerminalProperties() {
        return this.initTermProps;
    }

    public void activateProperties() {
        String string;
        if (this.activeProps) {
            return;
        }
        Enumeration enumeration = defaultPropertyNames.keys();
        this.activeProps = true;
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            string = this.props.getProperty(string2);
            if (string == null) continue;
            this.activateProperty(string2, string);
        }
        int n = 0;
        while ((string = this.props.getProperty("local" + n)) != null) {
            this.activateProperty("local" + n, string);
            ++n;
        }
        n = 0;
        while ((string = this.props.getProperty("remote" + n)) != null) {
            this.activateProperty("remote" + n, string);
            ++n;
        }
    }

    public void passivateProperties() {
        this.activeProps = false;
    }

    private void saveProperties(String string) throws IOException {
        String string2;
        String string3;
        Object object;
        Terminal terminal = this.getTerminal();
        Properties properties = terminal != null ? terminal.getProperties() : null;
        try {
            PrivilegeManager.enablePrivilege("UniversalFileAccess");
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            // empty catch block
        }
        if (properties != null) {
            object = ((Hashtable)properties).keys();
            while (object.hasMoreElements()) {
                string3 = (String)object.nextElement();
                string2 = properties.getProperty(string3);
                ((Hashtable)this.props).put(string3, string2);
            }
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        if (this.savePasswords) {
            if (this.propertyPassword == null) {
                this.propertyPassword = "";
            }
            this.props.save(fileOutputStream, "MindTerm ssh settings", this.propertyPassword, SSH.cipherClasses[3][0]);
        } else {
            string3 = this.props.getProperty("password");
            object = this.props.getProperty("prxpassword");
            string2 = this.props.getProperty("tispassword");
            String string4 = this.props.getProperty("rsapassword");
            this.clearPasswords();
            this.props.save(fileOutputStream, "MindTerm ssh settings");
            if (string3 != null) {
                ((Hashtable)this.props).put("password", string3);
            }
            if (object != null) {
                ((Hashtable)this.props).put("prxpassword", object);
            }
            if (string2 != null) {
                ((Hashtable)this.props).put("tispassword", string2);
            }
            if (string4 != null) {
                ((Hashtable)this.props).put("rsapassword", string4);
            }
        }
        fileOutputStream.close();
        this.propsChanged = false;
        if (terminal != null) {
            terminal.setPropsChanged(false);
        }
        this.interactor.propsStateChanged(this);
    }

    private void loadProperties(String string, boolean bl) throws IOException {
        EncryptedProperties encryptedProperties;
        Terminal terminal;
        block16: {
            terminal = this.getTerminal();
            try {
                PrivilegeManager.enablePrivilege("UniversalFileAccess");
            }
            catch (ForbiddenTargetException forbiddenTargetException) {
                // empty catch block
            }
            FileInputStream fileInputStream = new FileInputStream(string);
            byte[] byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            fileInputStream.close();
            encryptedProperties = new EncryptedProperties();
            try {
                encryptedProperties.load(byteArrayInputStream, "");
            }
            catch (AccessDeniedException accessDeniedException) {
                try {
                    byteArrayInputStream.reset();
                    encryptedProperties.load(byteArrayInputStream, this.propertyPassword);
                }
                catch (AccessDeniedException accessDeniedException2) {
                    try {
                        if (bl) {
                            byteArrayInputStream.reset();
                            this.propertyPassword = this.interactor.promptPassword("File " + string + " password: ");
                            encryptedProperties.load(byteArrayInputStream, this.propertyPassword);
                            break block16;
                        }
                        throw new AccessDeniedException("");
                    }
                    catch (AccessDeniedException accessDeniedException3) {
                        this.clearServerSetting();
                        throw new SSHClient.AuthFailException("Access denied for '" + string + "'");
                    }
                }
            }
        }
        this.savePasswords = !encryptedProperties.isNormalPropsFile();
        Properties properties = new Properties();
        Properties properties2 = new Properties();
        Enumeration enumeration = ((Hashtable)encryptedProperties).keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (SSHPropertyHandler.isProperty(string2)) {
                ((Hashtable)properties).put(string2, encryptedProperties.getProperty(string2));
                continue;
            }
            if (TerminalDefProps.isProperty(string2)) {
                ((Hashtable)properties2).put(string2, encryptedProperties.getProperty(string2));
                continue;
            }
            if (this.interactor != null) {
                this.interactor.report("Unknown property '" + string2 + "' found in file: " + string);
                continue;
            }
            System.out.println("Unknown property '" + string2 + "' found in file: " + string);
        }
        if (this.client != null) {
            this.client.clearAllForwards();
        }
        this.passivateProperties();
        this.setProperties(properties);
        this.initTermProps = properties2;
        if (terminal != null) {
            terminal.setProperties(this.initTermProps, false);
            terminal.setPropsChanged(false);
        }
        this.propsChanged = false;
        if (this.interactor != null) {
            this.interactor.propsStateChanged(this);
        }
    }

    final void clearPasswords() {
        ((Hashtable)this.props).remove("password");
        ((Hashtable)this.props).remove("tispassword");
        ((Hashtable)this.props).remove("rsapassword");
        ((Hashtable)this.props).remove("prxpassword");
    }

    final void clearServerSetting() {
        this.setProperty("server", "");
        this.currentPropsFile = null;
        this.currentAlias = null;
        if (this.interactor != null) {
            this.interactor.propsStateChanged(this);
        }
    }

    final void clearAllForwards() {
        String string;
        int n = 0;
        if (this.client != null) {
            this.client.clearAllForwards();
        }
        n = 0;
        while (n < 1024) {
            string = "local" + n;
            if (!((Hashtable)this.props).containsKey(string)) break;
            ((Hashtable)this.props).remove(string);
            ++n;
        }
        n = 0;
        while (n < 1024) {
            string = "remote" + n;
            if (!((Hashtable)this.props).containsKey(string)) break;
            ((Hashtable)this.props).remove(string);
            ++n;
        }
    }

    public boolean wantSave() {
        boolean bl = this.propsChanged || (this.getTerminal() != null ? this.getTerminal().getPropsChanged() : false);
        return !this.isReadOnly() && bl && this.sshHomeDir != null && this.currentAlias != null;
    }

    public final void checkSave() throws IOException {
        if (this.autoSaveProps) {
            this.saveCurrentFile();
        }
    }

    public void saveCurrentFile() throws IOException {
        if (this.currentPropsFile != null && this.wantSave()) {
            this.saveProperties(this.currentPropsFile);
        }
    }

    public void saveAsCurrentFile(String string) throws IOException {
        this.propsChanged = true;
        this.currentPropsFile = string;
        this.saveCurrentFile();
        this.currentAlias = null;
    }

    public void loadAbsoluteFile(String string, boolean bl) throws IOException {
        this.currentAlias = null;
        this.currentPropsFile = string;
        this.loadProperties(this.currentPropsFile, bl);
        if (this.interactor != null) {
            this.interactor.propsStateChanged(this);
        }
    }

    public void setAlias(String string) {
        if (this.sshHomeDir == null) {
            return;
        }
        this.currentAlias = string;
        this.currentPropsFile = this.sshHomeDir + string + PROPS_FILE_EXT;
    }

    public String getAlias() {
        return this.currentAlias;
    }

    public void loadAliasFile(String string, boolean bl) throws IOException {
        String string2 = this.currentAlias;
        this.setAlias(string);
        if (string2 == null || !string2.equals(string)) {
            this.loadProperties(this.currentPropsFile, bl);
        }
    }

    public String[] availableAliases() {
        if (this.sshHomeDir == null) {
            return null;
        }
        try {
            PrivilegeManager.enablePrivilege("UniversalFileAccess");
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            // empty catch block
        }
        File file = new File(this.sshHomeDir.substring(0, this.sshHomeDir.length() - 1));
        int n = 0;
        String[] stringArray = file.list();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (!stringArray[n2].endsWith(PROPS_FILE_EXT)) {
                stringArray[n2] = null;
                ++n;
            }
            ++n2;
        }
        if (n == stringArray.length) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length - n];
        n = 0;
        n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2] != null) {
                int n3 = stringArray[n2].lastIndexOf(PROPS_FILE_EXT);
                stringArray2[n++] = stringArray[n2].substring(0, n3);
            }
            ++n2;
        }
        return stringArray2;
    }

    public boolean isAlias(String string) {
        String[] stringArray = this.availableAliases();
        boolean bl = false;
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (string.equals(stringArray[n])) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    public boolean isAbsolutFile(String string) {
        if (this.sshHomeDir == null) {
            return false;
        }
        try {
            PrivilegeManager.enablePrivilege("UniversalFileAccess");
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            // empty catch block
        }
        File file = new File(string);
        return file.isFile() && file.exists();
    }

    public Terminal getTerminal() {
        if (this.client == null || this.client.console == null) {
            return null;
        }
        Terminal terminal = this.client.console.getTerminal();
        return terminal;
    }

    public void removeLocalTunnelAt(int n, boolean bl) {
        int n2 = this.client.localForwards.size();
        ((Hashtable)this.props).remove("local" + n);
        int n3 = n;
        while (n3 < n2 - 1) {
            ((Hashtable)this.props).put("local" + n, ((Hashtable)this.props).get("local" + (n + 1)));
            ((Hashtable)this.props).remove("local" + n + 1);
            ++n3;
        }
        this.propsChanged = true;
        if (bl) {
            SSHClient.LocalForward localForward = (SSHClient.LocalForward)this.client.localForwards.elementAt(n);
            this.client.delLocalPortForward(localForward.localHost, localForward.localPort);
        } else {
            this.client.localForwards.removeElementAt(n);
        }
    }

    public void removeRemoteTunnelAt(int n) {
        int n2 = this.client.remoteForwards.size();
        ((Hashtable)this.props).remove("remote" + n);
        int n3 = n;
        while (n3 < n2 - 1) {
            ((Hashtable)this.props).put("remote" + n, ((Hashtable)this.props).get("remote" + (n + 1)));
            ((Hashtable)this.props).remove("remote" + n + 1);
            ++n3;
        }
        this.propsChanged = true;
        this.client.remoteForwards.removeElementAt(n);
    }

    public void addLocalPortForward(String string, boolean bl) throws IllegalArgumentException, IOException {
        String string2;
        int n;
        String string3;
        String string4 = null;
        if (string.charAt(0) == '/') {
            int n2 = string.lastIndexOf(47);
            if (n2 == 0) {
                throw new IllegalArgumentException("Invalid port forward spec. " + string);
            }
            string3 = string.substring(1, n2);
            string = string.substring(n2 + 1);
        } else {
            string3 = "general";
        }
        int n3 = string.indexOf(58);
        int n4 = string.lastIndexOf(58);
        if (n3 == n4) {
            throw new IllegalArgumentException("Invalid port forward spec. " + string);
        }
        int n5 = string.indexOf(58, n3 + 1);
        if (n5 != n4) {
            string4 = string.substring(0, n3);
            n = Integer.parseInt(string.substring(n3 + 1, n5));
            string2 = string.substring(n5 + 1, n4);
        } else {
            n = Integer.parseInt(string.substring(0, n3));
            string2 = string.substring(n3 + 1, n4);
        }
        String string5 = string.substring(n4 + 1);
        int n6 = Integer.parseInt(string5);
        if (bl) {
            if (string4 == null) {
                this.client.addLocalPortForward(n, string2, n6, string3);
            } else {
                this.client.addLocalPortForward(string4, n, string2, n6, string3);
            }
        }
    }

    public void addRemotePortForward(String string, boolean bl) throws IllegalArgumentException {
        String string2;
        if (string.charAt(0) == '/') {
            int n = string.lastIndexOf(47);
            if (n == 0) {
                throw new IllegalArgumentException("Invalid port forward spec.");
            }
            string2 = string.substring(1, n);
            string = string.substring(n + 1);
        } else {
            string2 = "general";
        }
        int n = string.indexOf(58);
        int n2 = string.lastIndexOf(58);
        if (n == n2) {
            throw new IllegalArgumentException("Invalid port forward spec.");
        }
        String string3 = string.substring(0, n);
        int n3 = Integer.parseInt(string3);
        String string4 = string.substring(n + 1, n2);
        string3 = string.substring(n2 + 1);
        int n4 = Integer.parseInt(string3);
        if (bl) {
            this.client.addRemotePortForward(n3, string4, n4, string2);
        }
    }

    public String getUsername(SSHClientUser sSHClientUser) throws IOException {
        String string = this.getProperty("usrname");
        if (!this.interactor.quietPrompts() || string == null || string.equals("")) {
            String string2 = this.interactor.promptLine(this.getProperty("server") + " login: ", string);
            if (!string2.equals(string)) {
                this.clearPasswords();
                string = string2;
            }
            this.setProperty("usrname", string);
        }
        return string;
    }

    public String getPassword(SSHClientUser sSHClientUser) throws IOException {
        String string = this.getProperty("password");
        if (string == null) {
            string = this.interactor.promptPassword(this.getProperty("usrname") + "@" + this.getProperty("server") + "'s password: ");
            this.setProperty("password", string);
        }
        return string;
    }

    public String getChallengeResponse(SSHClientUser sSHClientUser, String string) throws IOException {
        String string2 = this.getProperty("tispassword");
        if (string2 == null) {
            string2 = this.interactor.promptPassword(string);
            this.setProperty("tispassword", string2);
        }
        return string2;
    }

    public int[] getAuthTypes(SSHClientUser sSHClientUser) {
        return SSH.getAuthTypes(this.getProperty("authtyp"));
    }

    public int getCipher(SSHClientUser sSHClientUser) {
        return SSH.getCipherType(this.getProperty("cipher"));
    }

    public SSHRSAKeyFile getIdentityFile(SSHClientUser sSHClientUser) throws IOException {
        String string = this.getProperty("idfile");
        if (string.indexOf(File.separator) == -1) {
            string = this.sshHomeDir + string;
        }
        try {
            PrivilegeManager.enablePrivilege("UniversalFileAccess");
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            // empty catch block
        }
        this.keyFile = new SSHRSAKeyFile(string);
        return this.keyFile;
    }

    public String getIdentityPassword(SSHClientUser sSHClientUser) throws IOException {
        String string = this.getProperty("rsapassword");
        if (string == null) {
            string = this.interactor.promptPassword("key file '" + this.keyFile.getComment() + "' password: ");
            this.setProperty("rsapassword", string);
        }
        return string;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verifyKnownHosts(RSAPublicKey var1_1) throws IOException {
        block35: {
            block36: {
                block30: {
                    block34: {
                        block33: {
                            block32: {
                                block31: {
                                    if (!Boolean.valueOf(this.getProperty("idhost")).booleanValue()) {
                                        return true;
                                    }
                                    var3_2 = null;
                                    var4_3 = null;
                                    var5_4 = 0;
                                    var6_5 = true;
                                    var7_6 = null;
                                    var4_3 = this.getClass().getResourceAsStream("/defaults/known_hosts.txt");
                                    try {
                                        block37: {
                                            block29: {
                                                var8_7 = true;
                                                while (true) {
                                                    if (!var8_7) {
                                                        if (var5_4 != true) break block29;
                                                        if (this.interactor.isVerbose()) {
                                                            this.interactor.report("Host key not found from the list of known hosts.");
                                                        }
                                                        if (this.interactor.askConfirmation("Do you want to add this host to your set of known hosts", true)) break;
                                                        this.interactor.report("Verification of server key disabled in this session.");
                                                        var9_14 = true;
                                                        break block30;
                                                    }
                                                    if (var4_3 != null) {
                                                        var3_2 = "<resource>/defaults/known_hosts.txt";
                                                        if (this.interactor.isVerbose()) {
                                                            this.interactor.report("Found preinstalled 'known_hosts' file.");
                                                        }
                                                    } else {
                                                        var8_7 = false;
                                                        if (this.sshHomeDir == null) {
                                                            if (this.interactor.isVerbose()) {
                                                                this.interactor.report("File operations disabled, server identity can't be verified");
                                                            }
                                                            var9_10 = true;
                                                            var12_16 = null;
                                                            break block31;
                                                        }
                                                        try {
                                                            PrivilegeManager.enablePrivilege("UniversalFileAccess");
                                                            PrivilegeManager.enablePrivilege("UniversalThreadGroupAccess");
                                                        }
                                                        catch (ForbiddenTargetException var9_11) {
                                                            // empty catch block
                                                        }
                                                        var3_2 = this.sshHomeDir + this.knownHosts;
                                                        var2_8 = new File(var3_2);
                                                        if (!var2_8.exists()) {
                                                            if (!this.interactor.askConfirmation("File '" + var3_2 + "' not found, create it?", true)) {
                                                                this.interactor.report("Verification of server key disabled in this session.");
                                                                var9_12 = true;
                                                                break block32;
                                                            }
                                                            var9_9 = new FileOutputStream(var2_8);
                                                            var9_9.close();
                                                        }
                                                        var4_3 = new FileInputStream(var3_2);
                                                    }
                                                    if ((var5_4 = (var7_6 = new SSHRSAPublicKeyFile(var4_3, var3_2, true)).checkPublic(var1_1.getN(), this.getProperty("server"))) == 0) {
                                                        var9_13 = true;
                                                        break block33;
                                                    }
                                                    if (var8_7 && !this.interactor.askConfirmation("Host was not found in preinstalled 'known_hosts' file! Continue anyway?", false)) {
                                                        var10_32 = false;
                                                        break block34;
                                                    }
                                                    var4_3 = null;
                                                }
                                                var6_5 = true;
                                                break block37;
                                            }
                                            this.interactor.alert("WARNING: HOST IDENTIFICATION HAS CHANGED! IT IS POSSIBLE THAT SOMEONE IS DOING SOMETHING NASTY, ONLY PROCEED IF YOU KNOW WHAT YOU ARE DOING!");
                                            var6_5 = this.interactor.askConfirmation("Do you want to replace the identification of this host?", false);
                                            var7_6.removePublic(this.getProperty("server"));
                                        }
                                        if (var6_5) {
                                            var7_6.addPublic(this.getProperty("server"), null, var1_1.getE(), var1_1.getN());
                                            var2_8 = new File(var3_2 + ".tmp");
                                            var9_9 = new File(var3_2);
                                            var9_9.renameTo(var2_8);
                                            try {
                                                var7_6.saveToFile(var3_2);
                                            }
                                            catch (IOException var10_33) {
                                                var9_9 = new File(var3_2);
                                                var2_8.renameTo((File)var9_9);
                                                throw var10_33;
                                            }
                                            var2_8.delete();
                                            break block35;
                                        }
                                        var9_15 = false;
                                        break block36;
                                    }
                                    catch (Throwable var11_34) {
                                        var12_23 = null;
                                        try {
                                            var4_3.close();
                                            throw var11_34;
                                        }
                                        catch (Exception var13_31) {
                                            // empty catch block
                                        }
                                        throw var11_34;
                                    }
                                }
                                ** try [egrp 3[TRYBLOCK] [3 : 590->598)] { 
lbl99:
                                // 1 sources

                                var4_3.close();
                                return var9_10;
lbl101:
                                // 1 sources

                                catch (Exception var13_24) {
                                    // empty catch block
                                }
                                return var9_10;
                            }
                            var12_17 = null;
                            ** try [egrp 3[TRYBLOCK] [3 : 590->598)] { 
lbl107:
                            // 1 sources

                            var4_3.close();
                            return var9_12;
lbl109:
                            // 1 sources

                            catch (Exception var13_25) {
                                // empty catch block
                            }
                            return var9_12;
                        }
                        var12_18 = null;
                        ** try [egrp 3[TRYBLOCK] [3 : 590->598)] { 
lbl115:
                        // 1 sources

                        var4_3.close();
                        return var9_13;
lbl117:
                        // 1 sources

                        catch (Exception var13_26) {
                            // empty catch block
                        }
                        return var9_13;
                    }
                    var12_19 = null;
                    ** try [egrp 3[TRYBLOCK] [3 : 590->598)] { 
lbl123:
                    // 1 sources

                    var4_3.close();
                    return var10_32;
lbl125:
                    // 1 sources

                    catch (Exception var13_27) {
                        // empty catch block
                    }
                    return var10_32;
                }
                var12_20 = null;
                ** try [egrp 3[TRYBLOCK] [3 : 590->598)] { 
lbl131:
                // 1 sources

                var4_3.close();
                return var9_14;
lbl133:
                // 1 sources

                catch (Exception var13_28) {
                    // empty catch block
                }
                return var9_14;
            }
            var12_21 = null;
            ** try [egrp 3[TRYBLOCK] [3 : 590->598)] { 
lbl139:
            // 1 sources

            var4_3.close();
            return var9_15;
lbl141:
            // 1 sources

            catch (Exception var13_29) {
                // empty catch block
            }
            return var9_15;
        }
        var12_22 = null;
        try {}
        catch (Exception var13_30) {
            return true;
        }
        var4_3.close();
        return true;
    }

    public String getProxyUsername(String string, String string2) throws IOException {
        String string3 = this.getProperty("proxyuser");
        if (!this.interactor.quietPrompts() || string3 == null || string3.equals("")) {
            String string4 = string2 != null ? " '" + string2 + "'" : "";
            string3 = this.interactor.promptLine(string + string4 + " username: ", string3);
            this.setProperty("proxyuser", string3);
        }
        return string3;
    }

    public String getProxyPassword(String string, String string2) throws IOException {
        String string3 = this.getProperty("prxpassword");
        if (string3 == null) {
            String string4 = string2 != null ? " '" + string2 + "'" : "";
            string3 = this.interactor.promptPassword(string + string4 + " password: ");
            this.setProperty("prxpassword", string3);
        }
        return string3;
    }

    public String getSrvHost() throws IOException {
        String string = this.getProperty("server");
        if (!this.interactor.quietPrompts() || string == null || string.equals("")) {
            if (this.currentAlias != null) {
                string = this.currentAlias;
            }
            do {
                string = this.interactor.promptLine("SSH Server/Alias: ", string);
            } while ("".equals(string = string.trim()));
            if (this.autoLoadProps) {
                if (this.isAlias(string)) {
                    this.loadAliasFile(string, true);
                } else if (this.isAbsolutFile(string)) {
                    this.loadAbsoluteFile(string, true);
                } else if (this.sshHomeDir != null) {
                    String string2;
                    String string3 = "";
                    do {
                        string2 = this.interactor.promptLine("No settings file for " + string + " found.\n\rSave as alias: ", string);
                        string2 = string2.trim();
                        if (!this.savePasswords || (string3 = this.interactor.promptPassword(string2 + " file password: ")).length() <= 0) continue;
                        this.propertyPassword = this.interactor.promptPassword(string2 + " password again: ");
                    } while ("".equals(string2) || !string3.equals("") && !string3.equals(this.propertyPassword));
                    this.setAlias(string2);
                    this.setProperty("server", string);
                    this.clearPasswords();
                    this.clearAllForwards();
                    ((Hashtable)this.props).remove("usrname");
                    this.propsChanged = true;
                }
                string = this.getProperty("server");
            } else {
                this.setProperty("server", string);
            }
        }
        this.activateProperties();
        return string;
    }

    public int getSrvPort() {
        return Integer.valueOf(this.getProperty("port"));
    }

    public Socket getProxyConnection() throws IOException {
        String string = this.getProperty("proxytype");
        int n = 0;
        try {
            n = SSH.getProxyType(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException.getMessage());
        }
        if (n == 0) {
            return null;
        }
        String string2 = this.getProperty("proxyhost");
        int n2 = -1;
        try {
            n2 = Integer.valueOf(this.getProperty("proxyport"));
        }
        catch (Exception exception) {
            n2 = -1;
        }
        if (string2 == null || n2 == -1) {
            throw new IOException("When 'proxytype' is set, 'proxyhost' and 'proxyport' must also be set");
        }
        String string3 = this.getProperty("server");
        int n3 = this.getSrvPort();
        String string4 = this.getProperty("proxyproto");
        Socket socket = null;
        switch (n) {
            case 1: {
                socket = WebProxyTunnelSocket.getProxy(string3, n3, string2, n2, string4, this, "MindTerm/$Name:  $");
                break;
            }
            case 2: {
                socket = SocksProxySocket.getSocks4Proxy(string3, n3, string2, n2, this.getProxyUsername("SOCKS4", null));
                break;
            }
            case 3: {
                socket = SocksProxySocket.getSocks5Proxy(string3, n3, string2, n2, false, this);
                break;
            }
            case 4: {
                socket = SocksProxySocket.getSocks5Proxy(string3, n3, string2, n2, true, this);
            }
        }
        return socket;
    }

    public String getDisplay() {
        return this.getProperty("display");
    }

    public int getMaxPacketSz() {
        return Integer.valueOf(this.getProperty("mtu"));
    }

    public int getAliveInterval() {
        return Integer.valueOf(this.getProperty("alive"));
    }

    public boolean wantX11Forward() {
        return Boolean.valueOf(this.getProperty("x11fwd"));
    }

    public boolean wantPrivileged() {
        return Boolean.valueOf(this.getProperty("prvport"));
    }

    public boolean wantPTY() {
        return Boolean.valueOf(this.getProperty("forcpty"));
    }

    public SSHInteractor getInteractor() {
        return this.interactor;
    }

    static {
        int n = 0;
        while (n < defaultPropDesc.length) {
            String string = defaultPropDesc[n][0];
            String string2 = defaultPropDesc[n][1];
            defaultPropertyNames.put(string, "");
            if (string2 != null) {
                ((Hashtable)defaultProperties).put(string, string2);
            }
            ++n;
        }
    }
}

