/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import mindbright.gui.ProgressBar;
import mindbright.ssh.SSH;
import mindbright.ssh.SSHAuthenticator;
import mindbright.ssh.SSHClientUser;
import mindbright.ssh.SSHInteractor;
import mindbright.ssh.SSHSCP;
import mindbright.ssh.SSHSCPDialog;
import mindbright.ssh.SSHSCPIndicator;
import mindbright.util.AWTConvenience;
import netscape.security.ForbiddenTargetException;
import netscape.security.PrivilegeManager;

public final class SSHSCPGUIThread
implements Runnable,
SSHSCPIndicator {
    String curDir;
    String localFile;
    String remoteFile;
    String remoteHost;
    int remotePort;
    SSHAuthenticator authenticator;
    SSHClientUser mainUser;
    SSHInteractor interactor;
    boolean recursive;
    boolean background;
    boolean toRemote;
    Frame parent;
    SSHSCPDialog mRefreshDialog;
    String[] localFileList;
    Dialog copyIndicator;
    ProgressBar progress;
    SSHSCP scp;
    Thread copyThread;
    Label srcLbl;
    Label dstLbl;
    Label sizeLbl;
    Label nameLbl;
    Label speedLbl;
    Button cancB;
    long startTime;
    long lastTime;
    int totTransSize;
    int fileTransSize;
    int curFileSize;
    int lastSize;
    int fileCnt;
    boolean doneCopying;

    public SSHSCPGUIThread(String string, int n, SSHAuthenticator sSHAuthenticator, SSHClientUser sSHClientUser, SSHInteractor sSHInteractor, Frame frame, String string2, String string3, String string4, boolean bl, boolean bl2, boolean bl3, SSHSCPDialog sSHSCPDialog) throws Exception {
        try {
            PrivilegeManager.enablePrivilege("UniversalFileAccess");
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            // empty catch block
        }
        this.localFileList = SSHSCPGUIThread.spaceSplit(string3);
        if (this.localFileList == null) {
            throw new Exception("Unbalanced quotes in local files list");
        }
        File file = new File(this.localFileList[0]);
        if (file.isAbsolute() && (string2 = file.getParent()) == null) {
            string2 = file.getAbsolutePath();
        }
        this.localFileList = SSHSCPGUIThread.starExpand(this.localFileList, string2);
        if (!bl3) {
            string3 = this.localFileList[0];
        }
        this.remoteHost = string;
        this.curDir = string2;
        this.remotePort = n;
        this.authenticator = sSHAuthenticator;
        this.mainUser = sSHClientUser;
        this.interactor = sSHInteractor;
        this.parent = frame;
        this.localFile = string3;
        this.remoteFile = string4;
        this.recursive = bl;
        this.background = bl2;
        this.toRemote = bl3;
        this.fileCnt = 0;
        this.doneCopying = false;
        this.startTime = 0L;
        this.lastTime = 0L;
        this.totTransSize = 0;
        this.fileTransSize = 0;
        this.lastSize = 0;
        this.mRefreshDialog = sSHSCPDialog;
    }

    private void setupDialog() {
        Object object;
        String string = "localhost:" + this.localFile;
        String string2 = this.remoteHost + ":" + this.remoteFile;
        if (!this.toRemote) {
            object = string;
            string = string2;
            string2 = object;
        }
        this.copyIndicator = new Dialog(this.parent, "MindTerm - File Transfer", false);
        object = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.copyIndicator.setLayout((LayoutManager)object);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        Label label = new Label("Source:");
        ((GridBagLayout)object).setConstraints(label, gridBagConstraints);
        this.copyIndicator.add(label);
        gridBagConstraints.gridwidth = 4;
        this.srcLbl = new Label(this.cutName(string, 32));
        ((GridBagLayout)object).setConstraints(this.srcLbl, gridBagConstraints);
        this.copyIndicator.add(this.srcLbl);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        label = new Label("Destination:");
        ((GridBagLayout)object).setConstraints(label, gridBagConstraints);
        this.copyIndicator.add(label);
        gridBagConstraints.gridwidth = 4;
        this.dstLbl = new Label(this.cutName(string2, 32));
        ((GridBagLayout)object).setConstraints(this.dstLbl, gridBagConstraints);
        this.copyIndicator.add(this.dstLbl);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        label = new Label("Current:");
        ((GridBagLayout)object).setConstraints(label, gridBagConstraints);
        this.copyIndicator.add(label);
        gridBagConstraints.gridwidth = 3;
        this.nameLbl = new Label("connecting...");
        ((GridBagLayout)object).setConstraints(this.nameLbl, gridBagConstraints);
        this.copyIndicator.add(this.nameLbl);
        gridBagConstraints.gridwidth = 1;
        this.sizeLbl = new Label("");
        ((GridBagLayout)object).setConstraints(this.sizeLbl, gridBagConstraints);
        this.copyIndicator.add(this.sizeLbl);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(4, 12, 4, 4);
        this.progress = new ProgressBar(512, 160, 20);
        ((GridBagLayout)object).setConstraints(this.progress, gridBagConstraints);
        this.copyIndicator.add(this.progress);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.fill = 2;
        this.speedLbl = new Label("0.0 kB/sec", 1);
        ((GridBagLayout)object).setConstraints(this.speedLbl, gridBagConstraints);
        this.copyIndicator.add(this.speedLbl);
        gridBagConstraints.gridy = 4;
        this.cancB = new Button("Cancel");
        this.cancB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!SSHSCPGUIThread.this.doneCopying) {
                    if (SSHSCPGUIThread.this.copyThread != null) {
                        SSHSCPGUIThread.this.copyThread.stop();
                    }
                    if (SSHSCPGUIThread.this.scp != null) {
                        SSHSCPGUIThread.this.scp.abort();
                    }
                }
                ((Component)SSHSCPGUIThread.this.copyIndicator).setVisible(false);
            }
        });
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.ipadx = 2;
        ((GridBagLayout)object).setConstraints(this.cancB, gridBagConstraints);
        this.copyIndicator.add(this.cancB);
        AWTConvenience.setBackgroundOfChildren(this.copyIndicator);
        Dimension dimension = this.speedLbl.getSize();
        dimension.width += dimension.width * 2;
        this.speedLbl.setSize(dimension);
        this.sizeLbl.setSize(dimension);
        this.copyIndicator.setResizable(true);
        this.copyIndicator.pack();
        AWTConvenience.placeDialog(this.copyIndicator);
    }

    public void run() {
        this.setupDialog();
        try {
            PrivilegeManager.enablePrivilege("UniversalThreadGroupAccess");
            PrivilegeManager.enablePrivilege("UniversalThreadAccess");
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            forbiddenTargetException.printStackTrace();
        }
        this.copyThread = new Thread(SSH.getThreadGroup(), new Runnable(){

            public void run() {
                block8: {
                    try {
                        PrivilegeManager.enablePrivilege("UniversalFileAccess");
                    }
                    catch (ForbiddenTargetException forbiddenTargetException) {
                        // empty catch block
                    }
                    try {
                        PrivilegeManager.enablePrivilege("TerminalEmulator");
                    }
                    catch (ForbiddenTargetException forbiddenTargetException) {
                        // empty catch block
                    }
                    try {
                        SSHSCPGUIThread.this.scp = new SSHSCP(SSHSCPGUIThread.this.remoteHost, SSHSCPGUIThread.this.remotePort, SSHSCPGUIThread.this.authenticator, new File(SSHSCPGUIThread.this.curDir), SSHSCPGUIThread.this.recursive, false);
                        SSHSCPGUIThread.this.scp.setClientUser(SSHSCPGUIThread.this.mainUser);
                        SSHSCPGUIThread.this.scp.setInteractor(SSHSCPGUIThread.this.interactor);
                        SSHSCPGUIThread.this.scp.setIndicator(SSHSCPGUIThread.this);
                        if (SSHSCPGUIThread.this.toRemote) {
                            SSHSCPGUIThread.this.scp.copyToRemote(SSHSCPGUIThread.this.localFileList, SSHSCPGUIThread.this.remoteFile);
                        } else {
                            SSHSCPGUIThread.this.scp.copyToLocal(SSHSCPGUIThread.this.localFileList, SSHSCPGUIThread.this.remoteFile);
                        }
                        SSHSCPGUIThread.this.copyThread.setPriority(5);
                        Toolkit.getDefaultToolkit().beep();
                    }
                    catch (Exception exception) {
                        SSHSCPGUIThread.this.interactor.alert("SCP Error: " + exception.getMessage());
                        if (!SSH.DEBUGMORE) break block8;
                        System.out.println("SCP Error:");
                        exception.printStackTrace();
                    }
                }
                SSHSCPGUIThread.this.nameLbl.setText("Copied " + SSHSCPGUIThread.this.fileCnt + " file" + (SSHSCPGUIThread.this.fileCnt != 1 ? "s" : "") + ".");
                double d = (double)SSHSCPGUIThread.this.totTransSize / 1024.0;
                SSHSCPGUIThread.this.sizeLbl.setText(SSHSCPGUIThread.this.round(d) + " kB");
                SSHSCPGUIThread.this.doneCopying = true;
                SSHSCPGUIThread.this.cancB.setLabel("Done");
                SSHSCPGUIThread.this.mRefreshDialog.refresh();
                AWTConvenience.setKeyListenerOfChildren(SSHSCPGUIThread.this.copyIndicator, new AWTConvenience.OKCancelAdapter(SSHSCPGUIThread.this.cancB, SSHSCPGUIThread.this.cancB), null);
            }
        });
        if (this.background) {
            this.copyThread.setPriority(1);
        }
        this.copyThread.start();
        ((Component)this.copyIndicator).setVisible(true);
    }

    public static String[] spaceSplit(String string) {
        String string2;
        int n;
        int n2 = 0;
        int n3 = 0;
        String[] stringArray = new String[string.length() / 2];
        boolean bl = false;
        string = string.trim();
        block0: while ((n = string.indexOf(32, n2)) >= 0) {
            if (string.charAt(n2) == '\"' && (n = string.indexOf(34, ++n2)) == -1) {
                return null;
            }
            string2 = string.substring(n2, n);
            if (string2.endsWith(File.separator)) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            stringArray[n3++] = string2;
            n2 = n;
            do {
                if (++n2 != string.length()) continue;
                bl = true;
                continue block0;
            } while (string.charAt(n2) == ' ');
        }
        if (!bl) {
            if (string.charAt(n2) == '\"' && (n = string.indexOf(34, ++n2)) == -1) {
                return null;
            }
            string2 = string.substring(n2);
            if (string2.endsWith(File.separator)) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            stringArray[n3++] = string2;
        }
        int n4 = 0;
        while (n4 < n3) {
            if (stringArray[n4].endsWith("\"")) {
                stringArray[n4] = stringArray[n4].substring(0, stringArray[n4].length() - 1);
            }
            ++n4;
        }
        String[] stringArray2 = stringArray;
        stringArray = new String[n3];
        System.arraycopy(stringArray2, 0, stringArray, 0, n3);
        return stringArray;
    }

    public static String[] starExpand(String[] stringArray, String string) {
        String[] stringArray2;
        int n = 0;
        String[] stringArray3 = new String[4096];
        String[] stringArray4 = new File(string).list();
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string2 = stringArray[n2];
            String string3 = "";
            int n3 = string2.indexOf(42);
            if (n3 == -1) {
                n = SSHSCPGUIThread.addUnique(stringArray3, string2, n);
            } else {
                String string4;
                File file = new File(string2);
                if (!file.isAbsolute()) {
                    stringArray2 = stringArray4;
                } else {
                    string4 = file.getParent();
                    if (string4 == null) {
                        string4 = new String(File.separator);
                    }
                    stringArray2 = new File(string4).list();
                    string2 = file.getName();
                    string3 = string4 + File.separator;
                    n3 = string2.indexOf(42);
                }
                string4 = string2.substring(0, n3);
                String string5 = string2.substring(n3 + 1);
                int n4 = 0;
                while (n4 < stringArray2.length) {
                    String string6 = stringArray2[n4];
                    if (string6.startsWith(string4) && string6.endsWith(string5)) {
                        n = SSHSCPGUIThread.addUnique(stringArray3, string3 + string6, n);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        stringArray2 = stringArray3;
        stringArray3 = new String[n];
        System.arraycopy(stringArray2, 0, stringArray3, 0, n);
        return stringArray3;
    }

    static int addUnique(String[] stringArray, String string, int n) {
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2].equals(string)) break;
            ++n2;
        }
        if (n2 == n) {
            stringArray[n++] = string;
        }
        return n;
    }

    public void connected(String string) {
        this.nameLbl.setText("...connected");
    }

    public void startFile(String string, int n) {
        double d = (double)n / 1024.0;
        this.sizeLbl.setText(this.round(d) + " kB");
        this.nameLbl.setText(string);
        if (this.toRemote) {
            this.srcLbl.setText(this.cutName("localhost:" + string, 32));
        } else {
            this.dstLbl.setText(this.cutName("localhost:" + string, 32));
        }
        this.progress.setMax(n, true);
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
        this.curFileSize = n;
        this.fileTransSize = 0;
        ++this.fileCnt;
    }

    public void startDir(String string) {
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
        if (string.length() > this.curDir.length()) {
            string = string.substring(this.curDir.length());
        }
        if (this.toRemote) {
            this.srcLbl.setText(this.cutName("localhost:" + string, 32));
        } else {
            this.dstLbl.setText(this.cutName("localhost:" + string, 32));
        }
    }

    public void endFile() {
        this.progress.setValue(this.curFileSize, true);
    }

    public void endDir() {
    }

    public void progress(int n) {
        this.totTransSize += n;
        this.fileTransSize += n;
        if (this.curFileSize > 0 && (this.totTransSize - this.lastSize) * 100 / this.curFileSize >= 1) {
            this.progress.setValue(this.fileTransSize, !this.background);
            long l = System.currentTimeMillis();
            long l2 = (l - this.startTime) / 1000L;
            double d = l2 != 0L ? (double)this.totTransSize / 1024.0 / (double)l2 : 0.0;
            l2 = l - this.lastTime;
            if (l2 != 0L) {
                double d2 = (double)(this.totTransSize - this.lastSize) / 1024.0 / (double)l2;
                d = (d + d2) / 2.0;
            }
            this.speedLbl.setText("" + this.round(d) + " kB/sec");
            this.lastSize = this.totTransSize;
            this.lastTime = l;
        }
    }

    double round(double d) {
        d *= 10.0;
        d = Math.floor(d);
        return d /= 10.0;
    }

    String cutName(String string, int n) {
        if (string.length() > n) {
            String string2 = string.substring(0, (n -= 3) / 2);
            String string3 = string.substring(string.length() - n / 2);
            string = string2 + "..." + string3;
        }
        return string;
    }
}

