/*
 *      INSTALL.CMD - EuroCalc for OS/2 V1.03 - C.Langanke 1998,1999
 *
 *      installs EuroCalc WPS folder
 */
/* The first comment is used as online help text */

 SIGNAL ON HALT NAME HALT

 TitleLine = STRIP(SUBSTR(SourceLine(2), 3));
 PARSE VAR TitleLine CmdName'.CMD 'Info
 env       = 'OS2ENVIRONMENT';
 TRUE      = (1 = 1);
 FALSE     = (0 = 1);
 CrLf      = '0d0a'x;
 Redirection = '1>NUL 2>&1';
 '@ECHO OFF'
 Title = CmdName Info;

 /* some OS/2 Error codes */
 ERROR.NO_ERROR           =  0;
 ERROR.INVALID_FUNCTION   =  1;
 ERROR.FILE_NOT_FOUND     =  2;
 ERROR.PATH_NOT_FOUND     =  3;
 ERROR.ACCESS_DENIED      =  5;
 ERROR.NOT_ENOUGH_MEMORY  =  8;
 ERROR.INVALID_FORMAT     = 11;
 ERROR.INVALID_DATA       = 13;
 ERROR.NO_MORE_FILES      = 18;
 ERROR.WRITE_FAULT        = 29;
 ERROR.READ_FAULT         = 30;
 ERROR.SHARING_VIOLATION  = 32;
 ERROR.GEN_FAILURE        = 31;
 ERROR.INVALID_PARAMETER  = 87;

 GlobalVars = 'Title CmdName env TRUE FALSE CrLf Redirection ERROR.';

 /* load RexxUtil */
 CALL RxFuncAdd    'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs';
 CALL SysLoadFuncs;

 /* INI vars */
 Ini.FileName      = 'OS2.INI'
 Ini.Error         = 'ERROR:';
 Ini.All           = 'ALL:';
 Ini.Delete        = 'DELETE:';
 AppName           = 'EUROCALC';
 KeyCountryCode    = 'COUNTRY_CODE';
 KeyCurrencySymbol = 'CURRENCY_SYMBOL';
 KeyCurrencyCourse = 'CURRENCY_COURSE';

 /* defaults */
 SyslevelFile = 'sl.ecl';
 CallDir = GetCallDir();
 PARSE VAR Title . '- 'AppTitle' -';
 PARSE VAR AppTitle IconTitle .

 CurrencySymbol = '';
 CurrencyCourse = '';

 DO UNTIL (TRUE)
    /* show Title */
    SAY;
    SAY Title;
    SAY;

    /* set the values */
    rcx = SysIni( , AppName, KeyCurrencySymbol, CurrencySymbol);
    rcx = SysIni( , AppName, KeyCurrencyCourse, CurrencyCourse);

    /* make syslevel file available */
    CALL CHAROUT, 'Copying syslevel file ... ';
    'COPY' SyslevelFile 'syslevel.*' Redirection;
    SAY 'Ok.';

    /* load RexxUtil */
    CALL RxFuncAdd    'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs';
    CALL SysLoadFuncs;

    /* create object */
    CALL CHAROUT, 'Creating program objects ... ';
    rc = SysCreateObject( 'WPFolder',  AppTitle,          '<WP_DESKTOP>',      'CCVIEW=NO;OBJECTID=<EUROCALC_FOLDER>;', 'U');
    rc = SysCreateObject( 'WPProgram', IconTitle,         '<EUROCALC_FOLDER>', 'CCVIEW=NO;PROGTYPE=PM;EXENAME='CallDir'\EUROCALC.EXE;OBJECTID=<EUROCALC_PROGRAM>;', 'U');
    rc = SysCreateObject( 'WPProgram', 'Eurocalc Readme', '<EUROCALC_FOLDER>', 'CCVIEW=NO;PROGTYPE=PM;EXENAME=E.EXE;PARAMETERS='CallDir'\Readme;OBJECTID=<EUROCALC_README>;', 'U');
    SAY 'Ok.';

    rc = SysOpenObject('<EUROCALC_FOLDER>', 'DEFAULT', 1);
    rc = SysOpenObject('<EUROCALC_FOLDER>', 'DEFAULT', 1);
    rc = SysOpenObject('<EUROCALC_README>', 'DEFAULT', 1);
    rc = SysOpenObject('<EUROCALC_README>', 'DEFAULT', 1);

 END;

 EXIT(rc);

/* ------------------------------------------------------------------------- */

HALT:
 SAY;
 SAY 'Interrupted by user.';
 EXIT(ERROR.GEN_FAILURE);

/* ------------------------------------------------------------------------- */
ShowHelp: PROCEDURE EXPOSE (GlobalVars)

 SAY;
 SAY Title
 SAY;

 PARSE SOURCE . . ThisFile

 /* skip header */
 DO i = 1 TO 3
    rc = LINEIN(ThisFile);
 END;

 /* show help */
 DO WHILE (ThisLine \= ' */')
    ThisLine = LINEIN(Thisfile);
    SAY SUBSTR(ThisLine, 7);
 END;

 /* close file */
 rc = LINEOUT(Thisfile);

 RETURN('');

/* ========================================================================= */
PullVariable: PROCEDURE EXPOSE (GlobalVars)
 PARSE ARG Default, Message

 SAY;
 CALL CHAROUT, Message '['Default'] : ';
 PARSE PULL PullVar;
 IF (LENGTH(PullVar) > 0) THEN
    RETURN(PullVar);
 ELSE
    RETURN(Default);

/* ------------------------------------------------------------------------- */
GetCalldir: PROCEDURE  EXPOSE (GlobalVars)
PARSE SOURCE . . CallName
 CallDir = FILESPEC('Drive', CallName)||FILESPEC('Path', CallName);
 RETURN(LEFT(CallDir, LENGTH(CallDir) - 1));

