#include<os2.h>
#include"Module.h"
#include"sintable.h"
#include<math.h>
#include<stdio.h>

#define RADIOUS_LARGE	0.06
#define RADIOUS_SMALL	0.02
#define R	(1.0-RADIOUS_LARGE)

#define GAP 3

#define M_PI 3.14159265358979323846

struct Analog{
    int		oldMin, oldHour;
    LONG	colorShadow, ptnShadow;
    LONG	colorCircle, lcolorCircle, ptnCircle;
    LONG	colorNeedle, lcolorNeedle, ptnNeedle;
    };

// TƂ̑傫

void drawCircles
	( HPS hps, ULONG orgX, ULONG orgY, ULONG half, LONG dro )
{
    for( int i=0; i<60; i+=5 ){
	POINTL pt;
	LONG r = (LONG)((float)half * R);
	pt.x = (ULONG)((LONG)(r * Cos[i])>>16) + orgX;
	pt.y = (ULONG)((LONG)(r * Sin[i])>>16) + orgY;
	GpiMove( hps, &pt );
	float a = half * RADIOUS_LARGE;
	GpiFullArc( hps, dro, ((ULONG)a)<<16 );
	}
};


// PƂ̓_
void drawDots
	( HPS hps, ULONG orgX, ULONG orgY, ULONG half, LONG dro )
{
    for( int i=0; i<60; i++ ){
	if( i%5 == 0 ) continue;
	POINTL pt;
	LONG r = (LONG)((float)half * R);
	pt.x = (ULONG)((LONG)(r * Cos[i])>>16) + orgX;
	pt.y = (ULONG)((LONG)(r * Sin[i])>>16) + orgY;
	GpiMove( hps, &pt );
	float a = half * RADIOUS_SMALL;
	GpiFullArc( hps, dro, ((ULONG)a)<<16 );
	}
};


void rotate
	( const POLYGON& src, POLYGON& dest,
	  double orgX, double orgY, double magnify, double min )
{
    double Sin = sin( M_PI*min/30.0 );
    double Cos = cos( M_PI*min/30.0 );

    dest.ulPoints = src.ulPoints;
    for( int i=0; i<src.ulPoints; i++ ){
	double x, y;
	x = magnify * src.aPointl[i].x;
	y = magnify * src.aPointl[i].y;
	dest.aPointl[i].x = (ULONG)(  x * Cos + y * Sin + orgX);
	dest.aPointl[i].y = (ULONG)( -x * Sin + y * Cos + orgY);
	}
};


// j
#define LNDL_POINTS 5	// j`̓_
#define SNDL_POINTS 5	// Zj`̓_
const static POINTL needleL[LNDL_POINTS] = {	// j
	{  0, 100 },
	{ -8, 0 },
	{  0,-20 },
	{  8, 0 },
	{  0, 100 }
	};
const static POLYGON ndlL = { LNDL_POINTS, needleL };

const static POINTL needleS[LNDL_POINTS] = {	// Zj
	{  0, 70 },
	{ -10, 0 },
	{  0,-15 },
	{  10, 0 },
	{  0, 70 }
	};
const static  POLYGON ndlS = { SNDL_POINTS, needleS };

void drawNeedle
	( HPS hps, ULONG orgX, ULONG orgY, ULONG half, 
	  ModuleInfo* info, BOOL real )
{
    POINTL rotNeedleL[LNDL_POINTS];
    POLYGON rotNdlL;
    rotNdlL.aPointl = rotNeedleL;
    POINTL rotNeedleS[SNDL_POINTS];
    POLYGON rotNdlS;
    rotNdlS.aPointl = rotNeedleS;

    double hour = info->datetime.hours;
    double min = info->datetime.minutes;

    // ]̍W𓾂
    rotate( ndlS, rotNdlS,
	(double)orgX, (double)orgY, (double)half/100.0, 
	hour*5.0 + min/12.0 );
    rotate( ndlL, rotNdlL,
	(double)orgX, (double)orgY, (double)half/100.0,
	min );

    // Zj`
    GpiMove( hps, rotNdlS.aPointl );
    rotNdlS.ulPoints--;
    rotNdlS.aPointl++;
    if( real ){
	GpiSetPattern ( hps, ((Analog*)info->buffer)->ptnShadow ) ;
	GpiSetColor( hps, ((Analog*)info->buffer)->colorNeedle );
	GpiPolygons( hps, 1, &rotNdlS, POLYGON_BOUNDARY, POLYGON_INCL );
	GpiSetColor( hps, ((Analog*)info->buffer)->lcolorNeedle );
	GpiPolyLine( hps, rotNdlS.ulPoints, rotNdlS.aPointl );
    }else{
	GpiSetPattern ( hps, ((Analog*)info->buffer)->ptnShadow ) ;
	GpiSetColor( hps, ((Analog*)info->buffer)->colorShadow );
	GpiPolygons( hps, 1, &rotNdlS, POLYGON_BOUNDARY, POLYGON_INCL );
	}

    // j`
    GpiMove( hps, rotNdlL.aPointl );
    rotNdlL.ulPoints--;
    rotNdlL.aPointl++;
    if( real ){
	GpiSetPattern ( hps, ((Analog*)info->buffer)->ptnNeedle ) ;
	GpiSetColor( hps, ((Analog*)info->buffer)->colorNeedle );
	GpiPolygons( hps, 1, &rotNdlL, POLYGON_BOUNDARY, POLYGON_INCL );
	GpiSetColor( hps, ((Analog*)info->buffer)->lcolorNeedle );
	GpiPolyLine( hps, rotNdlL.ulPoints, rotNdlL.aPointl );
    }else{
	GpiSetPattern ( hps, ((Analog*)info->buffer)->ptnShadow ) ;
	GpiSetColor( hps, ((Analog*)info->buffer)->colorShadow );
	GpiPolygons( hps, 1, &rotNdlL, POLYGON_BOUNDARY, POLYGON_INCL );
	}
};

