/* ^Cgo[̂ȂEBhE */
/*   1996.3.3 -  by Akishi.Murata */

#include "PicPanel.h"
#include "About.h"
#include <string.h>
#include <stdio.h>
#include "message.h"


#define FT_UNKNOWN	0
#define FT_ERROR	1
#define FT_BMP		2

static int filetype( char* filename )
{
    FILE *fp = fopen( filename, "rb" );
    if( fp == NULL ) return FT_ERROR;
    char header[16];
    fread( header, 16, 1, fp );

    if( header[0] == 'B' && header[1] == 'M' )
	{ fclose(fp); return FT_BMP; }

    fclose( fp );
    return FT_UNKNOWN;
}


PicturePanel :: PicturePanel( ClockManager* mgr, HAB aHab )
	: NoTitlebarWindow( aHab )
{
  this->manager = mgr;
  this->init();
};


PicturePanel :: PicturePanel(  ClockManager* mgr, HAB aHab, HWND parent )
	: NoTitlebarWindow( aHab, parent)
{
  this->manager = mgr;
  this->init();
};


PicturePanel :: PicturePanel
	( ClockManager* mgr, HAB aHab, HWND parent, ULONG clientStyle )
		: NoTitlebarWindow( aHab, parent, clientStyle )
{
  this->manager = mgr;
  this->init();
};


PicturePanel :: PicturePanel
	( ClockManager* mgr, 
	  HAB aHab,HWND parent,ULONG clientStyle,ULONG frameStyle )
		: NoTitlebarWindow( aHab, parent, clientStyle, frameStyle)
{
  this->manager = mgr;
  this->init();
};


PicturePanel :: ~PicturePanel()
{
    WinStopTimer( hab, this->hwndClient, 1 );
};


void PicturePanel :: init()
{
  WinStartTimer( hab, this->hwndClient, 1, 1000 );
  this->hwndMenu =
    WinLoadMenu( this->hwndClient, NULLHANDLE, IDR_MAINPOPUP );
};


MRESULT EXPENTRY PicturePanel :: frameProc
    ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  switch( msg ){
  case WM_BUTTON1DOWN:
    this->relocate( TF_MOVE );
    return (MRESULT)TRUE;

  case WM_ACTIVATE:
    {
      SWP swp;
      WinQueryWindowPos( this->hwndFrame, &swp );
      WinSetWindowPos
	(this->hwndFrame, HWND_TOP, swp.x, swp.y, swp.cx, swp.cy, SWP_ZORDER );
      return 0;
    }
  }

  // ʃNX̏ɔC
  return NoTitlebarWindow::frameProc( hwnd, msg, mp1, mp2 );
}


MRESULT EXPENTRY PicturePanel :: clientProc
    ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
    static ULONG result;

    switch( msg ){
      case WM_TIMER:
	WinBroadcastMsg( this->hwndClient, msg, mp1, mp2,
				BMSG_POST|BMSG_DESCENDANTS );
	return (MRESULT)0;

      // _uNbNŃAvIib[uj
      case WM_BUTTON1DBLCLK:
	WinPostMsg( this->hwndFrame, WM_QUIT, 0, 0 );
	return (MRESULT)TRUE;

      case WM_BUTTON2DOWN:
	{
	  POINTL ptl;
	  ptl.x = SHORT1FROMMP(mp1);
	  ptl.y = SHORT2FROMMP(mp1);
	  WinMapWindowPoints( this->hwndClient, HWND_DESKTOP, &ptl, 1 );
	  WinPopupMenu(HWND_DESKTOP, this->hwndClient, this->hwndMenu,
		       ptl.x, ptl.y, IDC_QUIT,
		       PU_HCONSTRAIN|PU_VCONSTRAIN|PU_SELECTITEM
		       |PU_MOUSEBUTTON1 );
	  return 0;
	}

      case WM_PAINT:
	{
	if( bmp->Hbm == NULLHANDLE ) return (MRESULT)TRUE;

	RECTL retc;
	HPS localHps;

	localHps = WinBeginPaint( this->hwndClient, NULLHANDLE, NULL );

	RECTL rect;
	POINTL point;
	rect.xLeft = rect.yBottom = 0;
	rect.xRight = bmp->width();
	rect.yTop = bmp->height();
	point.x = point.y = 0;
	WinDrawBitmap( localHps, bmp->Hbm(), &rect, &point,
		DBM_IMAGEATTRS, DBM_IMAGEATTRS, DBM_NORMAL );

	ULONG pcclr;
	WinRealizePalette( this->hwndClient, localHps, &pcclr );
	WinEndPaint( localHps );

	return (MRESULT)0;
	}

      case WM_COMMAND:
	switch( COMMANDMSG(&msg)->cmd ){
	case IDC_QUIT:
	  WinPostMsg( this->hwndFrame, WM_QUIT, 0, 0 );
	  return (MRESULT)0;
	case IDC_SAVESET:
	  ((ClockManager*)this->manager)->saveSettings();
	  return 0;
	case IDC_MODULESELECT:
	  ((ClockManager*)this->manager)->openModuleSelecter();
	  return 0;
	case IDC_VERSION:
	  openAboutPanel( this->hab );
	  return 0;
	}
	  
      // Bitmap󂯕t
      case DM_DRAGOVER:
      case DM_DROP:
	{
	PDRAGINFO pDraginfo = (PDRAGINFO)mp1;
	if( DrgAccessDraginfo( pDraginfo ) == FALSE ) break;
	// t@C͂P̂
	if( DrgQueryDragitemCount( pDraginfo ) != 1 ) break;

	// Bitmapǂ
	PDRAGITEM pDragItem = DrgQueryDragitemPtr( pDraginfo, 0 );
	unsigned char string[1024];
	DrgQueryStrName( pDragItem->hstrRMF, 1024, (PSZ)string );
	if( strstr( (const char*)string, "DRM_OS2FILE" ) == 0 ) break;
//printf( "File type : %s\n", string );
//	if( strstr( string, "DRF_BITMAP" ) == 0
//	 && strstr( string, "DRF_DIB" ) == 0 ) break;
	char fname[512];
	DrgQueryStrName( pDragItem->hstrContainerName, 512, (PSZ)string );
//printf( "ContainerName : %s\n", string );
	DrgQueryStrName( pDragItem->hstrSourceName, 512, (PSZ)fname );
	strcat( (char*)string, fname );
//printf( " FileName : %s\n", string );
/*
DrgQueryStrName( pDragItem->hstrTargetName, 1024, (PSZ)string );
printf( "TargetName : %s\n", string );
*/
	if( filetype( (char*)string ) != FT_BMP ) break;
	if( msg == DM_DRAGOVER ) return MRFROM2SHORT(DOR_DROP,DO_LINK);

	// rbg}bvt@Chbvꂽ
	BMP* bmp = (BMP*)(manager->Bitmap());
	bmp->read( this->hab, string );
	if( bmp->Hbm() != NULLHANDLE ) this->pictureChanged( bmp );
	return (MRESULT)0;
	}
      }

    // ̃bZ[W͏ʃNXɔC
    return NoTitlebarWindow :: clientProc( hwnd, msg, mp1, mp2 );
}


void PicturePanel :: pictureChanged( void )
{
    this->pictureChanged( (BMP*)(manager->Bitmap()) );
}


void PicturePanel :: pictureChanged( BMP* newPicture )
{
    if( newPicture->Hbm == NULLHANDLE ) return;
    this->bmp = newPicture;

    SWP swp;
    WinQueryWindowPos( this->hwndFrame, &swp );
    WinSetWindowPos(
	this->hwndFrame,
	swp.hwndInsertBehind,
	swp.x,	swp.y,
	newPicture->width(),	newPicture->height(),
	SWP_SIZE | SWP_SHOW );
}


void PicturePanel :: init( HINI hini )
{
  char string[1024];
  int x, y;

  PrfQueryProfileString(
    hini, "Panel1.0", "WinPosition", "0 0", string, 1024 );
  sscanf( string, "%d %d", &x, &y );
  WinSetWindowPos(
    this->hwndFrame,
    HWND_TOP,
    x, y, 100, 100,
    SWP_NOADJUST | SWP_MOVE );
}


void PicturePanel :: writeIni( HINI hini )
{
  char string[1024];
  SWP swp;

  WinQueryWindowPos( this->hwndFrame, &swp );
  sprintf( string, "%d %d", swp.x, swp. y );
  PrfWriteProfileString( hini, "Panel1.0", "WinPosition", string );
}
