/* ------------------------------------------------------------------------
 *
 *       BBBBBBBB    IIIIIIIIII  NN      NN  DDDDDDDD
 *       BB     BB       II      NNN     NN  DD     DD
 *       BB      BB      II      NNNN    NN  DD      DD
 *       BB     BB       II      NN NN   NN  DD      DD
 *       BBBBBBBB        II      NN  NN  NN  DD      DD
 *       BB     BB       II      NN   NN NN  DD      DD
 *       BB      BB      II      NN    NNNN  DD      DD
 *       BB     BB       II      NN     NNN  DD     DD
 *       BBBBBBBB    IIIIIIIIII  NN      NN  DDDDDDDD
 *
 *       Copyright 1998 by ELSA AG, Aachen (Germany)
 *
 *       @Project : Win32 uart routinen-header
 *       @System  :
 *       @Modul   : w32uart.h
 *       @Prefix  : xW32Uart
 *       @Hardware: Intel
 *       @Compiler: MSVC 6.0
 *       @Library : %
 *       @Author  : wf
 *       @Info    : Erstellt fr serielle CAPI
 *       @Status  : %
 *
 * ------------------------------------------------------------------------
 *       @History :
 * 141298 /wf       - Angelegt
 * ------------------------------------------------------------------------ */

#include "..\common.src\bastypes.h"
#include "windows.h"

/*--------------------------------------------------------------------------*/

tU32    xW32UartOpen         (tU8 *, tU32, tU32, tU32, tU32, tU32*);
/* Result codes: */
#define W32UART_OPEN_SUCCESS                  0
#define W32UART_OPEN_ERROR_CREATE_FILE        1
#define W32UART_OPEN_ERROR_GET_COMM_STATE     2
#define W32UART_OPEN_ERROR_SET_COMM_STATE     3
#define W32UART_OPEN_ERROR_GET_COMM_TIMEOUTS  4
#define W32UART_OPEN_ERROR_SET_COMM_TIMEOUTS  5
#define W32UART_OPEN_PURGE_RXTX_BUFF_ERROR    6

#define W32UART_COM1                          "COM1:"
#define W32UART_COM2                          "COM2:"
#define W32UART_COM3                          "COM3:"
#define W32UART_COM4                          "COM4:"
#define W32UART_COM5                          "COM5:"
#define W32UART_COM6                          "COM6:"
#define W32UART_COM7                          "COM7:"
#define W32UART_COM8                          "COM8:"

#define W32UART_BIT_PER_SEC_115200       115200
#define W32UART_BIT_PER_SEC_57600         57600
#define W32UART_BIT_PER_SEC_38400         38400
#define W32UART_BIT_PER_SEC_19200         19200
#define W32UART_BIT_PER_SEC_9600           9600
#define W32UART_BIT_PER_SEC_4800           4800
#define W32UART_BIT_PER_SEC_2400           2400
#define W32UART_BIT_PER_SEC_1200           1200
#define W32UART_BIT_PER_SEC_600             600
#define W32UART_BIT_PER_SEC_300             300
#define W32UART_BIT_PER_SEC_150             150

#define W32UART_BYTE_SIZE_8                   8
#define W32UART_BYTE_SIZE_7                   7

#define W32UART_NO_PARITY                     0
#define W32UART_ODD_PARITY                    1
#define W32UART_EVEN_PARITY                   2
#define W32UART_MARK_PARITY                   3
#define W32UART_SPACE_PARITY                  4

#define W32UART_ONE_STOPBIT                   0
#define W32UART_ONEDOTFIVE_STOPBIT            1
#define W32UART_TWO_STOPBIT                   2


/*--------------------------------------------------------------------------*/

tU32    xW32UartClose        (tU32);
/* Result codes: */
#define W32UART_CLOSE_SUCCESS                 0
#define W32UART_CLOSE_PURGE_RXTX_BUFF_ERROR   1
#define W32UART_CLOSE_CLOSE_HANDLE_ERROR      2

/*--------------------------------------------------------------------------*/

tU32    xW32UartDcd          (tU32);
/* Result codes: */
/* TRUE or FALSE */

/*--------------------------------------------------------------------------*/

tU32    xW32UartDsr          (tU32);
/* Result codes: */
/* TRUE or FALSE */

/*--------------------------------------------------------------------------*/

tU32    xW32UartRing         (tU32);
/* Result codes: */
/* TRUE or FALSE */

/*--------------------------------------------------------------------------*/

tU32    xW32UartCts          (tU32);
/* Result codes: */
/* TRUE or FALSE */

/*--------------------------------------------------------------------------*/

tU32    xW32UartWriteChar    (tU8, void (*)(void *), tU32);
/* Result codes: */
#define W32UART_WRITE_CHAR_SUCCESS            0
#define W32UART_WRITE_CHAR_ERROR              1

/*--------------------------------------------------------------------------*/

tU32    xW32UartWriteBlock   (tU8 *, tU32, void (*)(void *), tU32);
/* Result codes: */
#define W32UART_WRITE_BLOCK_SUCCESS           0
#define W32UART_WRITE_BLOCK_ERROR             1

/*--------------------------------------------------------------------------*/

tU32    xW32UartDataAvailable(tU32);
/* Result codes:   */
/* Number of Bytes */

/*--------------------------------------------------------------------------*/

tU32    xW32UartReadChar     (tU8 *, void (*)(void *), tU32);
/* Result codes: */
#define W32UART_READ_CHAR_SUCCESS             0
#define W32UART_READ_CHAR_ERROR               1

/*--------------------------------------------------------------------------*/

tU32    xW32UartReadBlock    (tU8 *, tU32, void (*)(void *), tU32);
/* Result codes: */
#define W32UART_READ_BLOCK_SUCCESS            0
#define W32UART_READ_BLOCK_ERROR              1

/*--------------------------------------------------------------------------*/

tU32    xW32UartPurgeRxBuff  (tU32);
/* Result codes: */
#define W32UART_PURGE_RX_BUFF_SUCCESS         0
#define W32UART_PURGE_RX_BUFF_ERROR           1

/*--------------------------------------------------------------------------*/

tU32    xW32UartPurgeTxBuff  (tU32);
/* Result codes: */
#define W32UART_PURGE_TX_BUFF_SUCCESS         0
#define W32UART_PURGE_TX_BUFF_ERROR           1

/*--------------------------------------------------------------------------*/

tU32    xW32UartPurgeRxTxBuff(tU32);
/* Result codes: */
#define W32UART_PURGE_RXTX_BUFF_SUCCESS       0
#define W32UART_PURGE_RXTX_BUFF_ERROR         1

/*--------------------------------------------------------------------------*/

tU32    xW32UartSetEventProc (tU32, void (*)(void), tU32);
/* Result codes: */
#define W32UART_SET_EVENT_PROC_SUCCESS        0
#define W32UART_SET_EVENT_PROC_ERROR          1
/* Possible events: */
#define W32UART_EVENT_CTS                     0
#define W32UART_EVENT_CTS_ON                  1
#define W32UART_EVENT_CTS_OFF                 2

#define W32UART_EVENT_DSR                     3
#define W32UART_EVENT_DSR_ON                  4
#define W32UART_EVENT_DSR_OFF                 5

#define W32UART_EVENT_DCD                     6
#define W32UART_EVENT_DCD_ON                  7
#define W32UART_EVENT_DCD_OFF                 8

#define W32UART_EVENT_RING                    9
#define W32UART_EVENT_BREAK                  10
#define W32UART_EVENT_ERROR                  11
#define W32UART_EVENT_RX_CHAR                12
#define W32UART_EVENT_RX_FLAG                13
#define W32UART_EVENT_RX80_FULL              14
#define W32UART_EVENT_TX_EMPTY               15

/*--------------------------------------------------------------------------*/

void    xW32UartClearDtr (tU32);

/*--------------------------------------------------------------------------*/

void    xW32UartSetDtr   (tU32);

/*--------------------------------------------------------------------------*/

void    xW32UartClearRts (tU32);

/*--------------------------------------------------------------------------*/

void    xW32UartSetRts   (tU32);

/*--------------------------------------------------------------------------*/

HANDLE  xW32UartGetPortHandle (tU32);

/*--------------------------------------------------------------------------*/

tU32    xW32UartCts (tU32);

/*--------------------------------------------------------------------------*/

