MODULE PhoneAt4;


(*# call(same_ds => off) *)
(*# data(heap_size=> 3000) *)
(*# data(stack_size=> 8192) *)


IMPORT Dos, Str, Lib, Process, OS2DEF, Win, Gpi, Vio, IO, FIO;

FROM OS2IO  IMPORT In, Out;

FROM OS2DEF IMPORT HDC, HRGN, HAB, HPS, HBITMAP, HWND, HMODULE, HSEM,
                   POINTL, RECTL, PID, TID, LSET, NULL,
                   COLOR, NullVar, NullStr, BOOL;


TYPE
  PhoneRec      = RECORD
                    Name        : ARRAY [1..40] OF CHAR;
                    Number      : ARRAY [1..40] OF CHAR;
                    Voice       : BOOLEAN;
                    Reserv      : ARRAY [1..943] OF CHAR;
                  END;


CONST
  WindowId       = 1;
  ClassName      = 'PhoneAtt';
  Fname          = 'PHONEATT.DIR';

  ID_RESOURCE    =   1;
  TID_DIAL       =   1;
  MNU_DIAL       =  10;

  DLG_PHONEPOP   = 100;
  DLG_PHONEBOOK  = 200;
  DLG_ENTRY      = 300;
  DLG_DIAL       = 400;
  LIS_PHONEBOOK  = 201;
  BUT_DIAL       = 202;
  BUT_ADD        = 203;
  BUT_DELETE     = 204;
  BUT_CANCEL     = 205;
  BUT_CHANGE     = 206;
  BUT_OK         = 305;
  ENT_NAME       = 303;
  ENT_PHONE      = 304;
  BUT_VOICE      = 306;
  BUT_DATA       = 307;

  TXT_TEXT       = 401;


(*# save,
    data(volatile => on) *)


VAR
  Hab            : HAB;
  IOAdr          : CARDINAL;
  WinRect        : RECTL;
  Client         : HWND;
  Frame          : HWND;
  Popping        : BOOLEAN;
  PhoneVar       : PhoneRec;

(*# restore *)

  TmpStr         : ARRAY [1..10] OF CHAR;
  OK             : BOOLEAN;


PROCEDURE PlayTone(Ch : CHAR; Len : CHAR; Tempo : CARDINAL);
  VAR
    Duration    : CARDINAL;
  BEGIN
    Duration := (ORD(Len) - 48) * Tempo;
    CASE Ch OF
      | 'p' : Dos.Sleep(LONGCARD(Duration));          (* pause *)
      | 'a' : Dos.Beep(220, Duration);
      | 'b' : Dos.Beep(233, Duration);
      | 'h' : Dos.Beep(247, Duration);
      | 'c' : Dos.Beep(262, Duration);
      | 'd' : Dos.Beep(294, Duration);
      | '4' : Dos.Beep(311, Duration);      (* bE *)
      | 'e' : Dos.Beep(330, Duration);
      | 'f' : Dos.Beep(349, Duration);
      | 'g' : Dos.Beep(392, Duration);
      | 'A' : Dos.Beep(440, Duration);
      | 'B' : Dos.Beep(466, Duration);
      | 'H' : Dos.Beep(494, Duration);
      | 'C' : Dos.Beep(523, Duration);
      | '2' : Dos.Beep(554, Duration);      (* #C *)
      | 'D' : Dos.Beep(587, Duration);
      | '3' : Dos.Beep(622, Duration);      (* #D *)
      | 'E' : Dos.Beep(659, Duration);
      | 'F' : Dos.Beep(698, Duration);
      | 'G' : Dos.Beep(784, Duration);
      | '1' : Dos.Beep(932, Duration);      (* Hgt B *)

    END;
  END PlayTone;


PROCEDURE Melody;
  CONST
    BeetViol    = 'CpgCEGpHpC';
    BeetViolLen = '1142211111';
  VAR
    Count       : CARDINAL;
  BEGIN
    FOR Count := 1 TO Str.Length(BeetViol) DO
      PlayTone(BeetViol[Count], BeetViolLen[Count], 133);
    END;
  END Melody;


PROCEDURE ScanModem;
  VAR
    Count          : CARDINAL;
    Sts            : SHORTCARD;
    PopMode        : CARDINAL;
    Temp           : CARDINAL;
    InfoSeg        : CARDINAL;
    LInfoSeg       : CARDINAL;
    CurrentSession : POINTER TO SHORTCARD;
  BEGIN
    Dos.GetInfoSeg(InfoSeg,LInfoSeg);
    CurrentSession := [InfoSeg:24];
    LOOP
      Out(IOAdr + 4, SHORTCARD({0,1,3}));
      FOR Count := 1 TO 100 DO
        Sts := In(IOAdr + 6);
        IF (6 IN BITSET(Sts)) AND (Sts <> 0) AND (Sts <> 255) AND (NOT Popping) THEN
          IF CurrentSession^ <> 1 THEN
            Temp := 0;
            IF Vio.PopUp(Temp, 0) = 0 THEN
              IO.WrStr('ͻ');   IO.WrLn;
              IO.WrStr(' The phone is ringing! ');   IO.WrLn;
              IO.WrStr('ͼ');   IO.WrLn;
              Melody;
              IO.WrStr('Press any key to exit...');
              Sts := 0;
              WHILE (Sts < 100) AND (NOT IO.KeyPressed()) DO
                Dos.Sleep(100);
                INC(Sts);
              END;
              Vio.EndPopUp(0);
            END;
          ELSE
            Win.PostMsg(Client,Win.WM_USER,0,0);
            Melody;
          END;
        END;
        Dos.Sleep(100);
      END;
    END;
  END ScanModem;


PROCEDURE SendStr(Txt : ARRAY OF CHAR);
  VAR
    Count       : CARDINAL;
  BEGIN
    IF Str.Length(Txt) > 0 THEN
      FOR Count := 0 TO Str.Length(Txt) - 1 DO
        Out(IOAdr, SHORTCARD(ORD(Txt[Count])));
        Dos.Sleep(100);
      END;
    END;
  END SendStr;


(*# save,
    call(near_call=>off, reg_param=>(), reg_saved=>(di,si,ds,es,st1,st2)) *)


PROCEDURE Dialling(hwnd         : HWND;
                   msg          : CARDINAL;
                   mp1,
                   mp2          : Win.MPARAM) : Win.MRESULT;
 VAR
   TmpStr       : ARRAY [1..25] OF CHAR;
   CharCell     : Vio.CHARCELL;
   OK           : BOOLEAN;
 BEGIN
   CASE msg OF
      | Win.WM_INITDLG  : IF Str.Length(PhoneVar.Name) > 20 THEN
                            Str.Slice(TmpStr, PhoneVar.Name, 0, 20);
                            Str.Concat(TmpStr, TmpStr, '...');
                          ELSE
                            Str.Copy(TmpStr, PhoneVar.Name);
                          END;
                          Win.SetWindowText(Win.WindowFromID(hwnd, TXT_TEXT),
                                            TmpStr);
                          Win.StartTimer(Hab,
                                         hwnd,
                                         TID_DIAL,
                                         500);
      | Win.WM_TIMER    : CASE CARDINAL(mp1) OF
                            | TID_DIAL    : Win.StopTimer(Hab,
                                                          hwnd,
                                                          TID_DIAL);
                                            IF Str.Length(PhoneVar.Number) > 0 THEN
                                              SendStr('ATD');
                                              SendStr(PhoneVar.Number);
                                              SendStr(CHR(13));
                                              IF PhoneVar.Voice THEN
                                                Win.MessageBox(Win.HWND_DESKTOP,
                                                               hwnd,
                                                               "Press OK to pick phone!",
                                                               ClassName,
                                                               0,
                                                               Win.MB_OK + Win.MB_ICONEXCLAMATION);
                                                SendStr(CHR(13));
                                              END;
                                            END;
                                            Win.DismissDlg(hwnd,
                                                           Win.MPARAM(TRUE));
                              ELSE          RETURN Win.DefDlgProc(hwnd, msg, mp1, mp2);
                          END;
        ELSE              RETURN Win.DefDlgProc(hwnd, msg, mp1, mp2);
   END;
   RETURN Win.MPARAM(FALSE);
 END Dialling;


PROCEDURE AddPhone(hwnd         : HWND;
                   msg          : CARDINAL;
                   mp1,
                   mp2          : Win.MPARAM) : Win.MRESULT;
  BEGIN
    CASE msg OF
      | Win.WM_INITDLG  : Win.SendMsg(Win.WindowFromID(hwnd, ENT_NAME),
                                      Win.EM_SETTEXTLIMIT,
                                      Win.MPARAM(SIZE(PhoneVar.Name)),
                                      NULL);
                          Win.SendMsg(Win.WindowFromID(hwnd, ENT_PHONE),
                                      Win.EM_SETTEXTLIMIT,
                                      Win.MPARAM(SIZE(PhoneVar.Number)),
                                      NULL);
                          Win.SetWindowText(Win.WindowFromID(hwnd, ENT_NAME),
                                            PhoneVar.Name);
                          Win.SetWindowText(Win.WindowFromID(hwnd, ENT_PHONE),
                                            PhoneVar.Number);
                          IF PhoneVar.Voice THEN
                            Win.SendMsg(Win.WindowFromID(hwnd, BUT_VOICE),
                                        Win.BM_SETCHECK,
                                        Win.MPARAM(1),
                                        NULL);
                          ELSE
                            Win.SendMsg(Win.WindowFromID(hwnd, BUT_DATA),
                                        Win.BM_SETCHECK,
                                        Win.MPARAM(1),
                                        NULL);
                          END;
      | Win.WM_CONTROL  : CASE CARDINAL(mp1 MOD 65536) OF
                            | BUT_VOICE  : PhoneVar.Voice := TRUE;
                            | BUT_DATA   : PhoneVar.Voice := FALSE;
                              ELSE         RETURN Win.DefDlgProc(hwnd, msg, mp1, mp2);
                          END;
      | Win.WM_COMMAND  : CASE Win.COMMANDMSG(mp2).cmd OF
                            | BUT_OK           : Win.QueryWindowText(Win.WindowFromID(hwnd, ENT_NAME),
                                                                     SIZE(PhoneVar.Name),
                                                                     PhoneVar.Name);
                                                 Win.QueryWindowText(Win.WindowFromID(hwnd, ENT_PHONE),
                                                                     SIZE(PhoneVar.Number),
                                                                     PhoneVar.Number);
                                                 Win.DismissDlg(hwnd,
                                                                Win.MPARAM(BUT_OK));
                            | BUT_CANCEL       : Win.DismissDlg(hwnd,
                                                                Win.MPARAM(BUT_CANCEL));
                              ELSE               RETURN Win.DefDlgProc(hwnd, msg, mp1, mp2);
                          END;
        ELSE              RETURN Win.DefDlgProc(hwnd, msg, mp1, mp2);
    END;
    RETURN Win.MPARAM(FALSE);
  END AddPhone;


PROCEDURE PhoneBook(hwnd        : HWND;
                    msg         : CARDINAL;
                    mp1,
                    mp2         : Win.MPARAM) : Win.MRESULT;
  VAR
    PhoneFile   : FIO.File;
    Result      : CARDINAL;
    Selection   : LONGCARD;
    Error       : ARRAY [1..80] OF CHAR;
  BEGIN
    CASE msg OF
      | Win.WM_INITDLG  : PhoneFile := FIO.Open(Fname);
                          IF FIO.IOresult() = 0 THEN
                            FIO.Seek(PhoneFile, 1024);
                            WHILE FIO.RdBin(PhoneFile, PhoneVar, SIZE(PhoneRec)) = SIZE(PhoneRec) DO
                              Win.SendDlgItemMsg(hwnd,
                                                 LIS_PHONEBOOK,
                                                 Win.LM_INSERTITEM,
                                                 Win.LIT_END,
                                                 Win.MPARAM(ADR(PhoneVar.Name)));
                            END;
                            FIO.Close(PhoneFile);
                            Win.SendDlgItemMsg(hwnd,
                                               LIS_PHONEBOOK,
                                               Win.LM_SELECTITEM,
                                               0,
                                               Win.MPARAM(TRUE));
                          END;
      | Win.WM_COMMAND  : CASE Win.COMMANDMSG(mp2).cmd OF
                            | BUT_OK          : Win.DismissDlg(hwnd,
                                                               Win.MPARAM(TRUE));
                            | BUT_DELETE      : IF Win.MessageBox(Win.HWND_DESKTOP,
                                                                  hwnd,
                                                                  "Are you sure you want to delete this entry?",
                                                                  ClassName,
                                                                  0,
                                                                  Win.MB_YESNO + Win.MB_ICONEXCLAMATION) = Win.MBID_YES THEN
                                                  Selection := Win.SendDlgItemMsg(hwnd,
                                                                                  LIS_PHONEBOOK,
                                                                                  Win.LM_QUERYSELECTION,
                                                                                  NULL,
                                                                                  NULL);
                                                  PhoneFile := FIO.Open(Fname);
                                                  IF FIO.IOresult() = 0 THEN
                                                    FIO.Seek(PhoneFile,(Selection + 1) * SIZE(PhoneVar) + 1024);
                                                    WHILE FIO.RdBin(PhoneFile, PhoneVar, SIZE(PhoneVar)) = SIZE(PhoneVar) DO
                                                      FIO.Seek(PhoneFile, FIO.GetPos(PhoneFile) - 2 * SIZE(PhoneVar));
                                                      FIO.WrBin(PhoneFile, PhoneVar, SIZE(PhoneVar));
                                                      FIO.Seek(PhoneFile, FIO.GetPos(PhoneFile) + SIZE(PhoneVar));
                                                    END;
                                                    FIO.Seek(PhoneFile, FIO.GetPos(PhoneFile) - SIZE(PhoneVar));
                                                    IF FIO.GetPos(PhoneFile) >= 1024 THEN
                                                      FIO.Truncate(PhoneFile);
                                                    END;
                                                    FIO.Close(PhoneFile);
                                                    Win.SendDlgItemMsg(hwnd,
                                                                       LIS_PHONEBOOK,
                                                                       Win.LM_DELETEITEM,
                                                                       Selection,
                                                                       NULL);
                                                    Win.SendDlgItemMsg(hwnd,
                                                                       LIS_PHONEBOOK,
                                                                       Win.LM_SELECTITEM,
                                                                       Selection,
                                                                       Win.MPARAM(TRUE));
                                                  END;
                                                END;
                          | BUT_DIAL        :   Error := 'Can not read phonebook entry!';
                                                Selection := Win.SendDlgItemMsg(hwnd,
                                                                                LIS_PHONEBOOK,
                                                                                Win.LM_QUERYSELECTION,
                                                                                NULL,
                                                                                NULL);
                                                PhoneFile := FIO.Open(Fname);
                                                IF FIO.IOresult() = 0 THEN
                                                  FIO.Seek(PhoneFile, Selection * SIZE(PhoneVar) + 1024);
                                                  IF FIO.IOresult() = 0 THEN
                                                    IF FIO.RdBin(PhoneFile, PhoneVar, SIZE(PhoneVar)) = SIZE(PhoneVar) THEN
                                                      Error := '';
                                                      Win.DlgBox(Win.HWND_DESKTOP,
                                                                 hwnd,
                                                                 Dialling,
                                                                 NULL,
                                                                 DLG_DIAL,
                                                                 ADR(Dos.NULL));
                                                    END;
                                                  END;
                                                  FIO.Close(PhoneFile);
                                                END;
                                                IF Str.Length(Error) > 0 THEN
                                                  Win.MessageBox(Win.HWND_DESKTOP,
                                                                 hwnd,
                                                                 Error,
                                                                 ClassName,
                                                                 0,
                                                                 Win.MB_OK + Win.MB_ICONEXCLAMATION);
                                                END;
                            | BUT_CHANGE      : Selection := Win.SendDlgItemMsg(hwnd,
                                                                                LIS_PHONEBOOK,
                                                                                Win.LM_QUERYSELECTION,
                                                                                NULL,
                                                                                NULL);
                                                IF Selection <> LONGCARD(Win.LIT_NONE) THEN
                                                  PhoneFile := FIO.Open(Fname);
                                                  IF FIO.IOresult() <> 0 THEN
                                                    PhoneFile := FIO.Create(Fname);
                                                    FIO.WrCharRep(PhoneFile, CHR(0), 1024);
                                                  END;
                                                  IF FIO.IOresult() = 0 THEN
                                                    FIO.Seek(PhoneFile,Selection * SIZE(PhoneVar) + 1024);
                                                    IF FIO.IOresult() = 0 THEN
                                                      IF FIO.RdBin(PhoneFile,PhoneVar,SIZE(PhoneVar)) = SIZE(PhoneVar) THEN
                                                        Win.DlgBox(Win.HWND_DESKTOP,
                                                                   hwnd,
                                                                   AddPhone,
                                                                   NULL,
                                                                   DLG_ENTRY,
                                                                   ADR(Dos.NULL));
                                                        FIO.Seek(PhoneFile,Selection * SIZE(PhoneVar) + 1024);
                                                        FIO.WrBin(PhoneFile, PhoneVar, SIZE(PhoneVar));
                                                        IF FIO.IOresult() = 0 THEN
                                                          Win.SendDlgItemMsg(hwnd,
                                                                             LIS_PHONEBOOK,
                                                                             Win.LM_DELETEITEM,
                                                                             Selection,
                                                                             NULL);
                                                          Win.SendDlgItemMsg(hwnd,
                                                                             LIS_PHONEBOOK,
                                                                             Win.LM_INSERTITEM,
                                                                             Selection,
                                                                             Win.MPARAM(ADR(PhoneVar.Name)));
                                                          Win.SendDlgItemMsg(hwnd,
                                                                             LIS_PHONEBOOK,
                                                                             Win.LM_SELECTITEM,
                                                                             Selection,
                                                                             Win.MPARAM(TRUE));
                                                        END;
                                                        RETURN Win.MPARAM(FALSE);
                                                      END;
                                                    END;
                                                    FIO.Close(PhoneFile);
                                                  END;
                                                  Win.COMMANDMSG(mp2).cmd := BUT_ADD;
                                                  Win.SendMsg(hwnd, Win.WM_COMMAND, mp1, mp2);
                                                END;
                            | BUT_ADD         : PhoneVar.Name     := '';
                                                PhoneVar.Number   := '';
                                                PhoneVar.Voice    := TRUE;
                                                Result := Win.DlgBox(Win.HWND_DESKTOP,
                                                                     hwnd,
                                                                     AddPhone,
                                                                     NULL,
                                                                     DLG_ENTRY,
                                                                     ADR(Dos.NULL));
                                                IF Result = BUT_OK THEN
                                                  PhoneFile := FIO.Append(Fname);
                                                  IF FIO.IOresult() <> 0 THEN
                                                    PhoneFile := FIO.Create(Fname);
                                                    FIO.WrCharRep(PhoneFile, CHR(0), 1024);
                                                  END;
                                                  IF FIO.IOresult() = 0 THEN
                                                    FIO.WrBin(PhoneFile, PhoneVar, SIZE(PhoneVar));
                                                    FIO.Close(PhoneFile);
                                                    Selection := Win.SendDlgItemMsg(hwnd,
                                                                                    LIS_PHONEBOOK,
                                                                                    Win.LM_INSERTITEM,
                                                                                    Win.LIT_END,
                                                                                    Win.MPARAM(ADR(PhoneVar.Name)));
                                                    Win.SendDlgItemMsg(hwnd,
                                                                       LIS_PHONEBOOK,
                                                                       Win.LM_SELECTITEM,
                                                                       Selection,
                                                                       Win.MPARAM(TRUE));
                                                  END;
                                                END;
                              ELSE              RETURN Win.DefDlgProc(hwnd, msg, mp1, mp2);
                          END;
      | Win.WM_CONTROL  : CASE CARDINAL(mp1 DIV 65536) OF
                            | Win.LN_ENTER : Win.COMMANDMSG(mp2).cmd := BUT_DIAL;
                                             msg := Win.WM_COMMAND;
                                             mp2 := 1;
                                             Win.PostMsg(hwnd, msg, mp1, mp2);
                              ELSE           RETURN Win.DefDlgProc(hwnd, msg, mp1, mp2);
                          END;
        ELSE              RETURN Win.DefDlgProc(hwnd, msg, mp1, mp2);
    END;
    RETURN Win.MPARAM(FALSE);
  END PhoneBook;



PROCEDURE PopMess(hwnd       : HWND;
                  msg        : CARDINAL;
                  mp1,
                  mp2        : Win.MPARAM) : Win.MRESULT;
 VAR
   LineCtrl     : SHORTCARD;
   SpeedDiv     : CARDINAL;
 BEGIN
   CASE msg OF
     | Win.WM_COMMAND  : CASE Win.COMMANDMSG(mp2).cmd OF
                           | BUT_OK : Win.DismissDlg(hwnd, Win.MPARAM(TRUE));
                             ELSE     RETURN Win.DefDlgProc(hwnd, msg, mp1, mp2);
                         END;
       ELSE              RETURN Win.DefDlgProc(hwnd, msg, mp1, mp2);
   END;
   RETURN Win.MPARAM(FALSE);
 END PopMess;


PROCEDURE WindowProc(hwnd       : HWND;
                     msg        : CARDINAL;
                     mp1,
                     mp2        : Win.MPARAM) : Win.MRESULT;
  VAR
    Rc          : RECTL;
    Hps         : HPS;
    Hbm         : HBITMAP;
    Swp         : POINTER TO Win.SWP;
    BitmapPoint : POINTL;
    BitmapRect  : POINTER TO RECTL;
  BEGIN
    CASE msg OF
      | Win.WM_PAINT            : Hps := Win.BeginPaint(hwnd, NULL, Rc);
                                  BitmapPoint.x := 0;
                                  BitmapPoint.y := 0;
                                  BitmapRect    := [0:0];
                                  Hbm := Gpi.LoadBitmap(Hps, NULL, ID_RESOURCE, WinRect.xRight - WinRect.xLeft, WinRect.yTop - WinRect.yBottom);
                                  Win.DrawBitmap(Hps, Hbm, BitmapRect^, BitmapPoint, 0, 0, Win.DBM_STRETCH);
                                  Win.EndPaint(Hps);
      | Win.WM_SIZE             : WinRect.xRight := WinRect.xLeft   + LONGINT(mp2 MOD 65536);
                                  WinRect.yTop   := WinRect.yBottom + LONGINT(mp2 DIV 65536);
                                  BitmapRect     := [0:0];
                                  Win.InvalidateRect(hwnd, BitmapRect^, B_FALSE);
      | Win.WM_COMMAND          : CASE Win.COMMANDMSG(mp2).cmd OF
                                    | MNU_DIAL       : Win.DlgBox(Win.HWND_DESKTOP,
                                                                  hwnd,
                                                                  PhoneBook,
                                                                  NULL,
                                                                  DLG_PHONEBOOK,
                                                                  ADR(Dos.NULL));
                                  END;
      | Win.WM_USER             : Popping := TRUE;
                                  Win.MessageBox(Win.HWND_DESKTOP,
                                                 hwnd,
                                                 "Phone is ringing!",
                                                 ClassName,
                                                 0,
                                                 Win.MB_OK + Win.MB_ICONEXCLAMATION);
                                  Popping := FALSE;
        ELSE                      RETURN Win.DefWindowProc(hwnd, msg, mp1, mp2);
    END;
    RETURN Win.MPARAM(FALSE);
  END WindowProc;


(*# restore *)



PROCEDURE Main;
  VAR
    Hmq         : Win.HMQ;
    Qmsg        : Win.QMSG;
    Createfl    : LSET;
    r           : Win.MRESULT;
  BEGIN
    Hab := Win.Initialize(NULL);
    Hmq := Win.CreateMsgQueue(Hab, 0);

    Win.RegisterClass(Hab,
                      ADR(ClassName),
                      WindowProc,
                      0,
                      0);

    Createfl := Win.FCF_TITLEBAR   + Win.FCF_SYSMENU + Win.FCF_MINMAX +
                Win.FCF_SIZEBORDER + Win.FCF_SHELLPOSITION +
                Win.FCF_TASKLIST   + Win.FCF_ICON    + Win.FCF_MENU;

    Frame := Win.CreateStdWindow(Win.HWND_DESKTOP,
                                 Win.WS_MAXIMIZED,
                                 Createfl,
                                 ADR(ClassName),
                                 ' - Phone Attentioning utility',
                                 Win.WS_VISIBLE + Win.WS_CLIPCHILDREN,
                                 NULL,
                                 WindowId,
                                 Client);

    Win.SetWindowPos(Frame,
                     Win.HWND_TOP,
                     10,
                     10,
                     200,
                     200,
                     Win.SWP_MINIMIZE + Win.SWP_SHOW + Win.SWP_SIZE);

    Process.StartProcess(ScanModem,8192,1);
    Process.StartScheduler;

    WHILE(Win.GetMsg(Hab, Qmsg, HWND(NULL), 0, 0)) DO
      r := Win.DispatchMsg(Hab, Qmsg);
    END;

    Process.StopScheduler;

    Win.DestroyWindow(Frame);
    Win.DestroyMsgQueue(Hmq);
    Win.Terminate(Hab);
  END Main;


BEGIN
  IOAdr       := 3F8H;
  Popping     := FALSE;
  FIO.IOcheck := FALSE;
  IF Lib.ParamCount() > 0 THEN
    Lib.ParamStr(TmpStr, 1);
    Str.Caps(TmpStr);
    IOAdr := CARDINAL(Str.StrToCard(TmpStr, 16, OK));
  END;
  Main;
END PhoneAt4.
