@echo off
set DISK=%1
set FLOPPY=%2
set NUM=%3

if "%DISK%"=="" goto usage
if "%FLOPPY%"=="" goto usage
goto %DISK%

:PGM
    if EXIST %FLOPPY%\*.EXE (
        echo Floppy in drive %FLOPPY% must be empty!
        goto end
    )
    echo ********** Program disk
    copy/b INSTALL.EXE* %FLOPPY%
    if errorlevel 1 goto bad
    copy/b INSTALL.DAT* %FLOPPY%
    if errorlevel 1 goto bad
    copy/b FX???.LOP* %FLOPPY%
    if errorlevel 1 goto bad
    copy/b FAX??.ADP* %FLOPPY%
    if errorlevel 1 goto bad
    if EXIST FMD.SYS copy/b FMD.SYS* %FLOPPY%
    if errorlevel 1 goto bad
    if EXIST MFEXE.EXE copy/b MFEXE.EXE* %FLOPPY%
    if errorlevel 1 goto bad
    if EXIST *.DLL copy/b *.DLL %FLOPPY%
    if errorlevel 1 goto bad
    copy/b README.DOC* %FLOPPY%
    if errorlevel 1 goto bad

    if EXIST ADD.EXE copy/b ADD.EXE* %FLOPPY%
    if errorlevel 1 goto bad
    if EXIST FX.NOP copy/b FX.NOP* %FLOPPY%
    if errorlevel 1 goto bad

    if EXIST FX*.FOP copy/b FX*.FOP* %FLOPPY%
    if errorlevel 1 goto bad

    if NOT EXIST FXRDR.EXE goto nordr
    copy/b FXRDR.EXE* %FLOPPY%
    if errorlevel 1 goto bad
    if EXIST FXVIM.EXE copy/b FXVIM.EXE* %FLOPPY%
    if errorlevel 1 goto bad
    copy/b FXRTE.EXE* %FLOPPY%
    if errorlevel 1 goto bad
    copy/b FXNFY.EXE* %FLOPPY%
    if errorlevel 1 goto bad
    echo PGM+LAN>fxlabel
    label %FLOPPY%<fxlabel
    if errorlevel 1 goto bad
    del fxlabel
    goto OK

:nordr
    echo PGM>fxlabel
    label %FLOPPY%<fxlabel
    if errorlevel 1 goto bad
    del fxlabel
    goto OK

:SUP
    if EXIST %FLOPPY%\*.EXE (
        echo Floppy in drive %FLOPPY% must be empty!
        goto end
    )
    echo ********** Supplemental disk
    copy/b FAX.EXE* %FLOPPY%
    if errorlevel 1 goto bad
    copy/b FXFILE.SOM* %FLOPPY%
    if errorlevel 1 goto bad
    copy/b FXRCV.EXE* %FLOPPY%
    if errorlevel 1 goto bad
    copy/b FXPRINT.DRV* %FLOPPY%
    if errorlevel 1 goto bad
    copy/b FXPRINT.EA2* %FLOPPY%
    if errorlevel 1 goto bad
    if EXIST FX*.POP copy/b FX*.POP* %FLOPPY%
    if errorlevel 1 goto bad
    copy/b FX???.HLP* %FLOPPY%
    if errorlevel 1 goto bad
    copy/b FAX.LOG* %FLOPPY%
    if errorlevel 1 goto bad
    copy/b FAX.IDX* %FLOPPY%
    if errorlevel 1 goto bad
    copy/b FX*.FAX* %FLOPPY%
    if errorlevel 1 goto bad
    copy/b *.PBK* %FLOPPY%
    if errorlevel 1 goto bad
    if EXIST *.BMP copy/b *.BMP* %FLOPPY%
    if errorlevel 1 goto bad
    if EXIST *.TIF copy/b *.TIF* %FLOPPY%
    if errorlevel 1 goto bad
    if EXIST *.TXT copy/b *.TXT* %FLOPPY%
    if errorlevel 1 goto bad

    echo SUP>fxlabel
    label %FLOPPY%<fxlabel
    if errorlevel 1 goto bad
    del fxlabel
    goto OK

:CRS
    if EXIST %FLOPPY%\*.EXE (
        echo Floppy in drive %FLOPPY% must be empty!
        goto end
    )
    echo ********** CRSzip OCR-engine disk
    copy/b CRSZIP.EXE* %FLOPPY%

    echo CRSZIP>fxlabel
    label %FLOPPY%<fxlabel
    if errorlevel 1 goto bad
    del fxlabel
    goto OK

:CGI
    if EXIST %FLOPPY%\*.EXE (
        echo Floppy in drive %FLOPPY% must be empty!
        goto end
    )
    echo ********** CGIzip PCL-engine disk
    copy/b CGIZIP.EXE* %FLOPPY%

    echo CGIZIP>fxlabel
    label %FLOPPY%<fxlabel
    if errorlevel 1 goto bad
    del fxlabel
    goto OK

:LTE
    if EXIST %FLOPPY%\*.EXE (
        echo Floppy in drive %FLOPPY% must be empty!
        goto end
    )
    echo ********** Lite disk
    if EXIST FXRCV.EXE (
        echo ONLY Lite program files should be in current directory!
        goto bad
    )
    copy/b INSTALL.EXE* %FLOPPY%
    if errorlevel 1 goto bad
    copy/b INSTALL.DAT* %FLOPPY%
    if errorlevel 1 goto bad
    copy/b FAX.EXE* %FLOPPY%
    if errorlevel 1 goto bad
    copy/b FAX.ADP* %FLOPPY%
    if errorlevel 1 goto bad
    copy/b FMD.SYS* %FLOPPY%
    if errorlevel 1 goto bad
    copy/b FX???.LOL* %FLOPPY%
    if errorlevel 1 goto bad
    copy/b FX???.HLP* %FLOPPY%
    if errorlevel 1 goto bad
    copy/b FXFILE.SOM* %FLOPPY%
    if errorlevel 1 goto bad
    copy/b ReadMe.DOC* %FLOPPY%
    if errorlevel 1 goto bad
    copy/b FXPRINT.DRV* %FLOPPY%
    if errorlevel 1 goto bad
    copy/b FXPRINT.EA2* %FLOPPY%
    if errorlevel 1 goto bad
    copy/b FAX.LOG* %FLOPPY%
    if errorlevel 1 goto bad
    copy/b FAX.IDX* %FLOPPY%
    if errorlevel 1 goto bad
    copy/b FX*.FAX* %FLOPPY%
    if errorlevel 1 goto bad
    copy/b FAX.PBK* %FLOPPY%
    if errorlevel 1 goto bad

    echo LITE>fxlabel
    label %FLOPPY%<fxlabel
    if errorlevel 1 goto bad
    del fxlabel
    goto OK

:usage
    echo usage:
    echo   FxDisk PGM A:       -- makes Fax Program disk
    echo   FxDisk SUP A:       -- makes Supplemental disk
    echo.
    echo   FxDisk CRS A:       -- makes CRSzip.exe disk (OCR engine)
    echo   FxDisk CGI A:       -- makes CGIzip.exe disk (PCL engine)
    echo.
    echo   FxDisk LTE A:       -- makes Fax Lite disk
    echo.
    echo Notes:
    echo     Floppy disks must already be formatted.
    echo     Unpack one of LAN, Multiline, Pro, or Lite into currect directory.
    echo     Optionally unpack any upgrade files into current directory.
    echo     Optionally unpack any ISV/OEM file into current directory.
    echo     Then run FxDisk to make disks.
    goto end
:bad
    echo.
    echo Failed! Please check command arguments and files in current directory.
    goto end
:OK
    echo.
    echo OK!
:end
