/* Installationsskript zum Elektronischen Tagebuch fr OS/2 */
SIGNAL ON ERROR NAME Fehler

SAY " "

/* REXXUTIL laden */
CALL rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
CALL sysloadfuncs

/* Abfrage, in welchem Pfad wir sind */
CALL SysFileTree 'DIARY2.*', datei, 'FO'
IF datei.0 < 2 THEN
DO
   SAY "Anscheinend haben sie das Archiv DIARY*.* noch nicht entpackt."
   SAY "Bitte erledigen Sie dies und beginnen Sie dann nochmal."
   EXIT
END

/* Den Pfad und die Platte extrahieren */
pfad = FILESPEC("path",datei.1)
disk = FILESPEC("drive",datei.1)
path = OVERLAY(pfad,disk,3)

SAY "Installationsscript zum Elektronischen Tagbuch fr OS/2"
SAY "======================================================="
SAY " "

/* Ansonsten Daten erfragen */
Abfrage:
SAY "In welchem Pfad soll das Elektronische Tagebuch installiert werden ?"
SAY "(z.B. C:\DIARY)  "
PARSE PULL pfad
IF pfad = "" THEN pfad="C:\DIARY"
SAY " "
SAY "Das Elektronische Tagebuch wird im Pfad " pfad " installiert."
SAY " "
SAY "Geben sie <return> fr weiter ein, <K> fr Korrektur oder <A> fr Abbruch!"
PULL antwort

/* Auswerten */
IF antwort = "A" THEN SIGNAL Abbruch
IF antwort = "K" THEN SIGNAL Abfrage

SAY "Danke...."

weiter:
/* Jetzt ggf. das Verzeichnis erzeugen */
rc = SysMkDir(pfad)

/* und die dort ntigen Dateien hinverschieben */
INTERPRET "'COPY DIARY2.EXE 'pfad'\*.*'"
INTERPRET "'COPY DIARY2.HLP  'pfad'\*.*'"
INTERPRET "'COPY DIARY.DOC 'pfad'\*.*'"
INTERPRET "'COPY DIARY.EXP 'pfad'\*.*'"
INTERPRET "'COPY DIARY2.ICO 'pfad'\*.*'"

/* Anlegen des Ordners auf der WPS */
SAY " "
SAY "Soll ein Programmobjekt fr das Elektronische Tagebuch erstellt werden?"
SAY "Geben sie <J> oder <N> ein!"
PULL antwort

/* Auswerten */
IF antwort = "N" THEN SIGNAL Ende
SAY " "
SAY "WPS-Objekte werden erzeugt..."

/* Das Programmobjekt anlegen */
klasse='WPProgram'
titel='Das Elektronische Tagebuch'
ort='<WP_DESKTOP>'
param='EXENAME='pfad'\DIARY2.EXE;ICONFILE='pfad'\DIARY2.ICO;STARTUPDIR='pfad';'
mode='fail'
rc = SysCreateObject(klasse,titel,ort,param,mode)

/* Ende-Meldung */
Ende:
SAY "Das Elektronische Tagebuch ist jetzt installiert!"
EXIT

/* Standard-Fehlerhandler */
Fehler:
SAY "Es ist ein Fehler aufgetreten. Bitte versuchen Sie's nochmal!"
EXIT

/* Abbruch des scripts */
Abbruch:
SAY "Schade, da Sie das Installationsprogramm abgebrochen haben!"
EXIT

