/*
 * INFCAT.CMD
 *
 * Catalogs INF files and builds a folder with them
 *
 * (c) 2003 Stephan Dahl
 * Permission granted to use for any purpose.
 * Author disclaims any usefulness whatsoever.
 */

parse arg rootfolder .

if rootfolder='' then
  CALL Error('Usage: INFCAT folder');

/* Load system functions. */
Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs

FolderTitle = "INF Library"

Rc = SysCreateObject("WPFolder",FolderTitle,"<WP_DESKTOP>","OBJECTID=<INFFOLDER>;ICONVIEW=NONFLOWED,NORMAL");
If Rc=1  Then
  Say 'Created' FolderTitle 'on the Desktop'
Else
  Say 'Unable to create "'FolderTitle'" on Desktop - may exist?';

Rc = SysFileTree(rootfolder'*.INF',files,'ST');

do i = 1 to files.0;

  parse var files.i fdatetime fsize fattr ffname .;
  Shortname = FILESPEC("name",ffname);
  Path = FILESPEC("path",ffname);
  PARSE VAR Shortname Shortname'.'suffix;
  "@INFTITLE "ffname" | RXQUEUE";
  PARSE PULL Title;
  If Title = 'Not an INF file!' Then Do;
    Say ffname Title' - skipped';
    ITERATE;
  End;
  Setup = "EXENAME=VIEW.EXE;PARAMETERS="ffname;
  Title = Path''Shortname' 'Title;

  Rc= SysCreateObject("WPProgram", Title, "<INFFOLDER>", Setup);
  if Rc=1 Then
    Say 'Created "'Title'"';
  Else
    Say 'Unable to create "'Title'" - may exist?';
End;

Exit(0);

Error:
 Say 'Error: 'Arg(1);
 Exit(16);
