/*
 * INFTITLE.C
 *
 * Extracts the title from an INF file
 *
 * (c) 2003 Stephan Dahl
 * Permission granted to use for any purpose.
 * Author disclaims any usefulness whatsoever.
 */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#define TITLEPOS      0x6B
#define TITLELENGTH   48
#define FILEID        "\x48\x53\x50\x01"
#define FILEIDLENGTH  4

int main(int argc, char **argv) {
  FILE *fin;                /* input files */
  int  rc;
  char buf[TITLELENGTH+1];

  if (argc!=2) {
    printf("Usage: INFTITLE inffile\n");
    exit(8);
  }
  if (!(fin = fopen(argv[1],"rb"))) {
    fprintf(stderr,"Unable to open file %s\n",argv[1]);
    exit(12);
  }
  fgets(buf,FILEIDLENGTH+1,fin);
  if (strncmp(buf,FILEID,4)!=0) {
    printf("Not an INF file!");
    exit(12);
  }

  rc = fseek(fin,TITLEPOS,SEEK_SET);
  if (rc!=0) {
    fprintf(stderr,"Unable to seek in file %s\n",argv[1]);
    exit(12);
  }
  fgets(buf,TITLELENGTH,fin);
  if (buf[0]==0)
    printf("(no title)");
  else
    printf(buf);
  return 0;
}

