/**********************************************************************/
/*                                                                    */
/*	CRISP - Programmable editor                                   */
/*	===========================                                   */
/*                                                                    */
/*  File:          brief.cr                                           */
/*  Author:        P. D. Fox                                          */
/*  Created:       31 May 1991                     		      */
/*                                                                    */
/*  Copyright (c) 1990, 1991 Paul Fox                                 */
/*                All Rights Reserved.                                */
/*                                                                    */
/*                                                                    */
/*--------------------------------------------------------------------*/
/*  Description:  Macros emulating BRIEF primitives                   */
/*                                                                    */
/*   This  file  contains macros which emulate BRIEF functions based  */
/*   on  the  functions  available  in CRISP. The justification here  */
/*   is  that  we  want  CRISP/CRUNCH to look more like ANSI/POSIX C  */
/*   environment rather than emulate crappy old DOS.		      */
/**********************************************************************/

/* SCCS ID: %Z% %M% %R%.%L% */
int
del(string name)
{

	return remove(name) >= 0 ? 1 : -1;
}
int
dos(string cmd, int use_shell, string callback)
{
	return shell(cmd, use_shell, callback);
}
int
inq_brief_level()
{
	return atoi(getenv("BLEVEL"));
}
