

# include	"crisp.h"
 
list months =
{
	"Jan", "Feb", "Mar", "Apr", "May", "Jun",
	"Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
};
		
/**************************************************************/
/*    Copyright notice.										  */
/**************************************************************/

void
ccopyr()
{
	int		old_insert_mode,
			line,
			column,
			d,
			m,
			y;
	string	ok,
			file_name,
			ext,
			description,
			buf;
	
	old_insert_mode = insert_mode(1);
	inq_position(line, column);
	top_of_buffer();
	refresh();
	if (re_search(NULL, "/\\*  File: ") > 0)
	{
		top_of_buffer();
		drop_anchor(MK_LINE);
		re_search(NULL, "< \\*\\*");
		refresh();
		get_parm(NULL, ok, "OK to delete marked region (y/n) ? ");
		if (ok == "y")
			delete_block();
		else
		{
			raise_anchor();
			refresh();
			insert_mode(old_insert_mode);
			return;
		}
	}

	top_of_buffer();
	inq_names(NULL, ext, file_name);
	file_name = substr(file_name, rindex(file_name, "/") + 1);
	insert("/*************************************************************************/\n");
	insert("/*                                                                       */\n");
	insert("/*        File: fn                                                       */\n");
	insert_subst("fn", file_name);
	insert("/*     Created: X                                                        */\n");
	date(y, m, d);
	sprintf(buf, "%d %s %d", d, months[m - 1], y);
	insert_subst("X", buf);
	insert("/* Description: mcm                                                      */\n");
	insert("/*                                                                       */\n");
	insert("/*************************************************************************/\n");
	insert("\n");
	
	top_of_buffer();
	re_search(NULL, "mcm");
	get_parm(0, description, "Enter description: ", 50);
	delete_char(strlen(description));

	insert(description);
	insert_mode(old_insert_mode);
	goto_old_line(line);
	beginning_of_line();
	move_rel(0, column);
}


void
revision()
{	int	year, month, day, i;
	string date_string, initials, comment, ok;
	
	top_of_buffer();
	if (re_search(NULL, "Copyright ") <= 0) {
		get_parm(NULL, ok, "Generate copyright notice (y/n) ? ");
		if (ok != "y")
			return;
		copyr();
		}
		
	top_of_buffer();
	if (re_search(NULL, "Revision") <= 0) {
		get_parm(NULL, ok, "Generate revision history (y/n) ? ");
		if (ok != "y")
			return;
		}
	re_search(NULL, "{SCCS}|{sccs}|{\\@(#)}");
	end_of_line();
	insert("\n\n/\* Revision History\n \* ================\n \*\n \*/\n");
	re_search(SF_BACKWARDS, "Revision");
	re_search(NULL, "\*/");
	move_rel(-1);
	end_of_line();
	date(year, month, day);
	sprintf(date_string, "\n *  %d-%d-%d", day, month, year);
	insert(date_string);
	i = 17 - strlen(date_string);
	insert(" ", i);

	get_parm(0, initials, "Enter your initials: ", 6);
	insert(initials);
	insert(" ", 8 - strlen(initials));
	insert(": ");
	get_parm(0, comment, "Enter comment: ", 40);
	insert(comment);
}

void
fn()
{	string	f;
	string	name;
	int	i, j;
	
	beginning_of_line();
	
	f = compress(trim(ltrim(read())));
	i = index(f, "(");
	name = substr(f, 1, i - 1);
	f = substr(f, i + 1);
	save_position();
	insert("/***********************************************************/\n");
	insert("/*							   */\n");
	insert("/*  Function:  X        				   */\n");
	insert_subst("X", name);
	insert("/*							   */\n");
	insert("/*  Description:					   */\n");
	insert("/*							   */\n");
	insert("/*     X                                                   */\n");
	insert("/*							   */\n");
	if (substr(f, 1, 1) != ")") {
		insert("/*  Parameters: 					   */\n");
		insert("/*							   */\n");
		while (f != "" && substr(f, 1, 1) != ")") {
			i = index(f, ",");
			j = index(f, ")");
			if (i < 1 || j < i)
				i = j;
			name = trim(ltrim(substr(f, 1, i - 1)));
			f = ltrim(substr(f, i + 1));
			insert("/*     X             --                                    */\n");
			insert_subst("X", name);
			insert("/*                                                         */\n");
			}
		}
	insert("/*							   */\n");
	insert("/***********************************************************/\n");
	restore_position();
	up();
	set_top_of_window();
}


void
insert_subst(string old, string new)
{

	up();
	re_search(NULL, old);
	delete_char(strlen(new));
	insert(new);
	down();
	beginning_of_line();
}
