/********************************************************************
 *                                                                  *
 *      CRISP - Custom Reduced Instruction Set Programmers Editor   *
 *                                                                  *
 *      (C) Paul Fox, 1989                                          *
 *                                                                  *
 *    Please See COPYRIGHT notice.                                  *
 *                                                                  *
/*  Terminal descriptor for OS/2 vio sessions                       */
/********************************************************************/

# include	"tty.h"

void
main()
{

	/***********************************************/
	/*   Set   characters   used   for   extended  */
	/*   graphics support when drawing windows.    */
	/***********************************************/
	set_term_characters(
		213,		/* Top left of window.			   */
		184,		/* Top right of window.			   */
		212,		/* Bottom left of window.		   */
		190,		/* Bottom right of window.		   */
		179,		/* Vertical bar for window sides.	   */
		205,		/* Top and bottom horizontal bar for window.*/
		0xd1,		/* Top join.				    */
		0xcf,		/* Bottom join.				    */
		0xd8,		/* Window 4-way intersection.		    */
		0xb5,		/* Left hand join.			    */
		0xc6		/* Right hand join.			    */
		);

	/***********************************************/
	/*   Define   escape   sequences   used   for  */
	/*   special optimisations on output.	       */
	/***********************************************/
	set_term_features(
		NULL,			/* Sequence to clear 'n' spaces.    */
		"%c",			/* Sequence to print characters     */
					/* with top bit set.		    */
		"\x1B[23m",		/* Insert-mode cursor.		    */
		"\x1B[24m",		/* Overwrite-mode cursor.	    */
		"\x1B[28;10;13m",	/* Insert-mode cursor (on virtual space).    */
		"\x1B[28;1;8m",		/* Overwrite-mode cursor (on virtual space). */
		"\x1B\x1B",		/* Print ESCAPE character graphically.	     */
		"\x[%b",		/* Escape sequence to repeat last character. */
		TRUE,			/* ESC [0m resets color.	    */
		TRUE,			/* Terminal supports color.	    */
		"\x1B[%dC"		/* Move cursor %d columns	    */
					/* (Not available in termcap).	    */
		);
	set_term_keyboard(
		KEY_DEL,	"\xD4",
		KEYPAD_0_9, quote_list(
				"\xCA", "\xCB", "\xCC", "\xCD",
				"\xCE", "\xCF", "\xD0", "\xD1",
				"\xD2", "\xD3"),
		CTRL_KEYPAD_0_9, quote_list(
				"\x0",  "\xD9", "\x0",  "\xDB",
				"\xDC", "\x0",  "\xDE", "\xDF",
				"\x0",  "\xE1"),
		ALT_0_9, quote_list(
				"\x0", "\x0", "\x0", "\x0",
				"\x0", "\x0", "\x0", "\x0",
				"\x0", "\x0")
		);
	assign_to_key("<Mouse>", "mouse");
}

/* --------------------------------------------------------------------- */

/*
 * Routines to support a mouse under os/2
 */

# define	LEFT_EDGE		1
# define	RIGHT_EDGE		2
# define	TOP_EDGE		3
# define	BOTTOM_EDGE		4
# define	INSIDE_WINDOW	5
# define	TITLE			6

int	old_b1 = 0,
	old_b2 = 0,
	old_b3 = 0;
int	old_x  = -1,
	old_y  = -1,
	old_w  = -1;
int	old_wh = -1;
int mouse_cnt = 0;
extern int popup_level;
int	sel_warpable = FALSE;

void
button_1_down (int win, int where, int x, int y)
{
	int curwin = inq_window();
	int line, col, buf;
	int lines, cols;
	int total;

	if (win < 0)				/* Outside of window region */
	{

	}
	else
	{
		if (win != curwin)
		{
			if (popup_level)				/* Stay in context if in popup */
				return;
			if (win >= 0)								 /* Switch windows */
			{
				buf = inq_window_buf(win);
				set_window(win);
				set_buffer(buf);
			}
		}
		inq_top_left(line, col, win);
		inq_window_size (lines, cols);
		total = inq_lines ();
		switch (where)
		{
		case INSIDE_WINDOW:
			if (win == curwin)
			{				/* If we clicked in current, move cursor there */
				line += y - 1;		  		  /* Calc new position in file */
				col  += x;
				move_abs(line, col);				  /* .. and move there */
				if (sel_warpable)		  /* If doing popup do cursor line */
					sel_warp();
			}					   /* Otherwise we already changed windows */
			break;
		case TITLE:
			if (popup_level == 0)  /* Click on title, switches to next file */
				edit_next_buffer();
			break;
		case LEFT_EDGE:
			break;
		case RIGHT_EDGE:
			if (win == curwin && total > lines)
			{
				line = (y * total) / lines;
				move_abs(line, col);
			}
			break;
		case TOP_EDGE:
			break;
		case BOTTOM_EDGE:
			break;
		}
	}
}

void
button_2_down ()
{
}

void
mouse(int winid, int where, int x, int y, int b1, int b2, int b3)
{

	++mouse_cnt;
	if (b1 && b2)
		help ();
	else if (!old_b1 && b1)
		button_1_down (winid, where, x, y);
	old_w  = winid;
	old_x  = x;
	old_y  = y;
	old_b1 = b1;
	old_b2 = b2;
	old_b3 = b3;
	old_wh = where;
	refresh();
}

