/*
$VerboseHistory: api.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:07:29a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 07:29a
 * Comment:
 * Added Explorer style open dialog support
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:32p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:43p
 * Comment:
 * Adding new 3.0 stuff
*/
#include 'slick.sh'

//4:07pm 5/10/1996 (actually started earlier this week)
//Api Apprentice
/*

   Decoding
      aaa00tbULONGULONG ul;       //COMMENTtbintint i; //comment i
      DDCMDEntryPointULONG00tbPDDCMDCOMMONpParmInPDDCMDCOMMON pParmIn     // Pointer to DDCMDCOMMON.
   FunctionName<A1>ReturnType<A1>LangSpecTabIndex<A1>ClassNameIndex
      <A1>twoLetterCtrlType|ParamType<A2>
      ListEntry1<A2>
      ListEntry2<A2>
      ...
      ListEntry
      <A3>comment<A1>


   Code below parses record data

   status=edit("G:\\vslick20\\os2.api");
   if (status) return;
   SkipToFirstEntry();
   get_line(line);
   parse line with FunctionName "\1" ReturnType "\1" LangSpecTabIndex "\1" ClassNameIndex \
     "\1" ParamList;
   messageNwait("defmain: FunctionName="FunctionName);
   messageNwait("defmain: ReturnType="ReturnType);
   messageNwait("defmain: LangSpecTabIndex="LangSpecTabIndex);
   messageNwait("defmain: ClassNameIndex="ClassNameIndex);

   // Loop through parameter data
   for (;;){
       parse ParamList with param "\1" ParamList
       if (param=="") break;
       parse param with ParamType "\2" list "\3" comment
       twoLetterCtrlType=substr(ParamType,1,2);
       ParamType=substr(ParamType,3);
       messageNwait("defmain: twoLetterCtrlType="twoLetterCtrlType" ParamType="ParamType" comment="comment);
       // Loop through list box items
       for (;;) {
           parse list with item "\2" list;
           if (item=="") break;
           messageNwait("defmain: item="item);
       }
   }


*/
/*

p_user's:
_api_form:

   _ctlok.p_user is the Language Specific Info Table entry for this item
   _ctlview_file.p_user is the Text height of the smallest frame
   _ctlhelp.p_user is used to remember when to throw away the on_got_focus event for
                   controls on the _api_form.  This is a fix for OS/2.

_api_editor_from:

   _api_editor_from.p_user is a pointer to the table of all api entries

   _ctlfunction_list.p_user is a copy of the current entry out of the main table.

   _ctlpframe.p_user is the index of the parameter currently being edited(displayed).

   _ctlval_list.p_user is the modify flag for the entry being edited(displayed).

   _ctltest.p_user is the modify flag for the database that is open.

   _ctlleft.p_user is a flags used to avoid processing on_change events while
                   filling in the contents of the text box.

   _ctlreturn_type.p_user is the last line that was selected in the _ctlfunction_list

   _ctldescription.p_user is the view id of the open file.

   _ctldelim.p_user is the the Language Specific Info Table.

   _ctlclass_name.p_user is the Class Name Table
*/
static int TypeConstTable:[]=
   {
      "tb"  => OI_TEXT_BOX
      ,"xb" => OI_CHECK_BOX
      ,"cb" => OI_COMBO_BOX
      ,"rb" => OI_RADIO_BUTTON
   };
#define API_CHECK_BOX_STR      'xb'
#define API_COMBO_BOX_STR      'cb'
#define API_TEXT_BOX_STR       'tb'
#define API_RADIO_BUTTON_STR   'rb'

#define ASCII1 "" //I use these to delimit the database file
#define ASCII2 ""
#define ASCII3 ""
#define ASCII4 ""
#define ASCII5 ""

static int gLastControlExtent=0;

struct LANGUAGE_INFO_T {
   _str LParen;
   _str RParen;
   _str Or;
   _str Delim;
};

defeventtab _api_control;

_api_control.on_got_focus()
{
   if(_ctlhelp.p_user==1) {
      return('');
   }
   if (p_parent.p_object==OI_FRAME) {
      picextent=_ctlinner_picture.p_y+p_parent.p_y+p_y+p_height;
      if (picextent>_ctlouter_picture.p_height || p_parent.p_y+_ctlinner_picture.p_y<0) {
         vscroll1.p_value=_ly2dy(p_parent.p_scale_mode,p_parent.p_y);
      }
   }
}

static void NextControl(...)
{
   if (arg(1)=='-') {
      if (p_prev!=p_window_id) {
         p_window_id=p_prev;
      }else{
         p_window_id=p_parent.p_prev;
         if (p_object==OI_FRAME) {//Should be always, but I want to be careful
            p_window_id=p_child;
         }
      }
      _set_focus();
   }else{
      if (p_next!=p_window_id) {
         p_window_id=p_next;
      }else{
         oldti=p_tab_index;
         p_window_id=p_parent.p_next;
         if (p_object==OI_FRAME) {//Should be always, but I want to be careful
            p_window_id=p_child;
         }
         if (p_tab_index<oldti) {
            p_window_id=_control _ctlok;
         }
      }
      _set_focus();
   }
   if (p_object!=OI_RADIO_BUTTON || arg(1)==1) {
      //If the child is a radio button the value is automatically set
      _set_focus();
   }
   if (p_object==OI_TEXT_BOX || p_object==OI_COMBO_BOX) {
      _set_sel(1,length(p_text)+1);
   }
}

_api_control.tab()
{
   NextControl()
}
_api_control.S_TAB()
{
   NextControl('-')
}

defeventtab _api_form;
_api_form.f1()
{
   _ctlhelp.call_event(_ctlhelp,lbutton_up);
}


_api_form.PGUP()
{
   newvalue=vscroll1.p_value-vscroll1.p_large_change;
   if (newvalue<0) {
      vscroll1.p_value=0;
   } else {
      vscroll1.p_value=newvalue;
   }
}

_api_form.PGDN()
{
   newvalue=vscroll1.p_value+vscroll1.p_large_change;
   if (newvalue>vscroll1.p_max) {
      vscroll1.p_value=vscroll1.p_max;
   } else {
      vscroll1.p_value=newvalue;
   }
}

_control _ctlinner_picture
_control _ctlproto_label
//If FileName=='', uses the current view
static int LoadClassTable(_str FileName,_str (&ClassTable)[])
{
   if (FileName!='') {
      inmem=1;
      status=_open_temp_view(FileName,temp_view_id,orig_view_id,'+b');
      if (status) {
         inmem=0;
         status=_open_temp_view(FileName,temp_view_id,orig_view_id);
      }
      if (status) {
         _message_box(nls("Could not open database file '%s'\n\n%s",FileName,get_message(status)));
         return(status);
      }
   }
   p_line=0;
   status=search('^\x2$','r@');
   if (status) {
      return(status);
   }
   i=-1;
   while (!down()) {
      get_line(line);
      if (line==ASCII2) break;
      ClassTable[++i]=line;
   }
   if (FileName!='') {
      if (!inmem) {
         p_view_id=orig_view_id;
         _delete_temp_view(temp_view_id);
      }else{
         p_view_id=temp_view_id;
         _quit_view();
      }
      p_view_id=orig_view_id;
   }
   return(0);
}

_api_form.on_resize()
{
   if (!_ctlouter_picture.p_y) return('');
   form_height=_dy2ly(p_scale_mode,p_active_form.p_client_height);
   buffer=100;

#if 0
   CreateWindowEx
#endif

   //_ctlouter_picture.p_height=_ctlok.p_y-(_ctlouter_picture.p_y+100);
   _ctlouter_picture.p_height=form_height-_ctlouter_picture.p_y;
   _ctlouter_picture.p_height-=(_ctlok.p_height+buffer*2);

   _ctlok.p_y=_ctlouter_picture.p_y+_ctlouter_picture.p_height+buffer;
   vscroll1.p_height=_ctlouter_picture.p_height;
   vscroll1.p_x=p_active_form.p_width-vscroll1.p_width-175;
   buffer=(buffer!=''?0:_ctlview_file.p_user);
   vscroll1.p_large_change=_ly2dy(_ctlouter_picture.p_scale_mode,_ctlouter_picture.p_height-buffer);
   _ctlcancel.p_y=_ctlhelp.p_y=_ctlview_file.p_y=_ctlok.p_y;
   _ctldivider.p_width=p_active_form.p_width+5;
   _ctlouter_picture.p_width=vscroll1.p_x-_ctlouter_picture.p_x;

   form_width=_dx2lx(p_scale_mode,p_active_form.p_client_width);

   ctlheader_inner.p_width=ctlheader_outer.p_width=form_width-(2*ctlheader_outer.p_x);
   _ctlinner_picture.p_width=_ctlouter_picture.p_width=ctlheader_inner.p_width;
}

//If FileName=='', uses the current view
static int LoadLanguageInfoTable(_str FileName,LANGUAGE_INFO_T (&LTable)[])
{
   if (FileName!='') {
      inmem=1;
      status=_open_temp_view(FileName,temp_view_id,orig_view_id,'+b');
      if (status) {
         inmem=0;
         status=_open_temp_view(FileName,temp_view_id,orig_view_id);
      }
      if (status) {
         _message_box(nls("Could not open database file '%s'\n\n%s",FileName,get_message(status)));
         return(status);
      }
   }
   p_line=0;
   while (!down()) {
      get_line(line);
      if (line==_chr(2)) break;
      i=p_line-1;
      parse line with LTable[i].LParen (ASCII1) LTable[i].RParen (ASCII1) LTable[i].Or (ASCII1) LTable[i].Delim (ASCII1);
   }
   if (FileName!='') {
      if (!inmem) {
         p_view_id=orig_view_id;
         _delete_temp_view(temp_view_id);
      }else{
         p_view_id=temp_view_id;
         _quit_view();
      }
      p_view_id=orig_view_id;
   }
   return(0);
}

#define XBUFFER 125
static int CreateFrame(_str TypeName,int FormWid,int &ControlNumber,
                       _str comment)
{
   pwid=FormWid._ctlinner_picture;
   wid=_create_window(OI_FRAME,FormWid._ctlinner_picture,comment,
                      XBUFFER,gLastControlExtent+100,
                      (_dx2lx(pwid.p_scale_mode,pwid.p_client_width)-(2*XBUFFER)),
                      700,
                      CW_CHILD|CW_CLIP_CONTROLS);
   if (wid) {
      wid.p_eventtab=find_index('_api_control',EVENTTAB_TYPE);
      wid.p_tab_stop=0;
      wid.p_tab_index=0;//++ControlNumber;
      wid.p_clip_controls=1;
      wid.p_name=TypeName;
      FormWid._ctlinner_picture.p_height=wid.p_y+wid.p_height+100;
   }else{
      return(0);
   }
   return(wid);
}

_str BuildComment(_str varinfo,_str comment)
{
   parse varinfo with type (ASCII2) varname;
   return(type' 'varname' 'comment);
}

_str BuildLabel(_str type,_str comment)
{
   return(type' 'comment);
}

static AddTextBox(_str data,int FormWid,int &ControlNumber,
                  _str comment)
{
   parse data with typename (ASCII2) initval;
   p=pos(ASCII2,initval);
   if (p) {
      initval=substr(initval,1,p-1);
   }
   //framewid=CreateFrame(typename,FormWid,ControlNumber,BuildComment(data,comment));
   //CreateWindowEx
   framewid=CreateFrame(typename,FormWid,ControlNumber,BuildLabel(typename,comment));
   wid=0;
   if (framewid) {
      wid=_create_window(OI_TEXT_BOX,framewid,"",
                         XBUFFER,XBUFFER+(framewid._text_height() intdiv 2),
                         framewid.p_width-(XBUFFER * 2),
                         framewid.p_height-(XBUFFER * 2),
                         CW_CHILD);
      if (wid) {
         wid.p_eventtab=find_index('_api_control',EVENTTAB_TYPE);
         wid.p_eventtab2=find_index('_ul2_textbox',EVENTTAB_TYPE);
         wid.p_tab_stop=1;
         wid.p_tab_index=++ControlNumber;
         wid.p_name=data;
         wid.p_text=initval;
      }
      gLastControlExtent=framewid.p_y+framewid.p_height;
   }
   //return(ControlNumber+1);
   return(wid);
}

static AddComboBox(_str data,int FormWid,int &ControlNumber,
                   _str comment)
{
   parse data with typename (ASCII2) initval;
   //framewid=CreateFrame(typename,FormWid,ControlNumber,BuildComment(data,comment));
   //CreateWindowEx
   framewid=CreateFrame(typename,FormWid,ControlNumber,BuildLabel(typename,comment));
   wid=0;
   if (framewid) {
      wid=_create_window(OI_COMBO_BOX,framewid,"",
                         XBUFFER,XBUFFER+(framewid._text_height() intdiv 2),
                         framewid.p_width-(XBUFFER * 2),
                         framewid.p_height-(XBUFFER * 2),
                         CW_CHILD);
      if (wid) {
         wid.p_eventtab=find_index('_api_control',EVENTTAB_TYPE);
         wid.p_eventtab2=find_index('_ul2_combobx',EVENTTAB_TYPE);
         wid.p_tab_stop=1;
         wid.p_tab_index=++ControlNumber;
         wid.p_name=data;
         for (;;) {
            parse initval with cbdata (ASCII2) initval;
            if (cbdata=='') break;
            wid.p_cb_list_box._lbadd_item(cbdata);
         }
         oldwid=p_window_id;
         p_window_id=wid.p_cb_list_box;
         //_lbsort();
         _lbtop();
         p_parent.p_text=_lbget_text();
         p_window_id=oldwid;
      }else{
         return(0);
      }
      gLastControlExtent=framewid.p_y+framewid.p_height;
   }
   return(wid);
}

static int AddCheckBoxes(_str data,int FormWid,int &ControlNumber,
                         _str comment)
{
   parse data with typename (ASCII2) data;
   //framewid=CreateFrame(typename,FormWid,ControlNumber,BuildComment(data,comment));
   //CreateWindowEx
   framewid=CreateFrame(typename,FormWid,ControlNumber,BuildLabel(typename,comment));
   i=0;
   xcol1=XBUFFER;
   xcol2=framewid.p_width intdiv 2;
   lastwid=0;
   i=0;
   wid=0;
   y=XBUFFER+(framewid._text_height() intdiv 2);
   for (;;) {
      ++i;
      parse data with cblabel (ASCII2) data;
      if (cblabel=='') break;
      wid=_create_window(OI_CHECK_BOX,framewid,cblabel,
                         XBUFFER,y,
                         framewid.p_width-(XBUFFER * 2),
                         framewid.p_height-(XBUFFER * 2),
                         CW_CHILD);
      if (wid) {
         wid.p_eventtab=find_index('_api_control',EVENTTAB_TYPE);
         wid.p_eventtab2=find_index('_ul2_checkbox',EVENTTAB_TYPE);
         wid.p_width=wid._text_width(wid.p_caption)+300;
         wid.p_height=wid._text_height()+50;
         if (lastwid) {
            if (lastwid.p_x==XBUFFER) {
               wid.p_x=xcol2;
               y=wid.p_y+wid.p_height+XBUFFER;
            }else{
               wid.p_x=XBUFFER;
            }
         }
         lastwid=wid;
         wid.p_tab_stop=1;
         wid.p_tab_index=++ControlNumber;
      }else{
         return(0);
      }
   }
   framewid.p_height=wid.p_y+wid.p_height+XBUFFER;
   gLastControlExtent=framewid.p_y+framewid.p_height;
   return(wid);
}


static int AddRadioButtons(_str data,int FormWid,int &ControlNumber,
                           _str comment)
{
   parse data with typename (ASCII2) data;
   //CreateWindowEx
   framewid=CreateFrame(typename,FormWid,ControlNumber,BuildLabel(typename,comment));
   i=0;
   xcol1=XBUFFER;
   xcol2=framewid.p_width intdiv 2;
   lastwid=0;
   y=XBUFFER+(framewid._text_height() intdiv 2);
   wid=0;
   for (;;) {
      ++i;
      parse data with cblabel (ASCII2) data;
      if (cblabel=='') break;
      wid=_create_window(OI_RADIO_BUTTON,framewid,cblabel,
                         XBUFFER,y,
                         framewid.p_width-(XBUFFER * 2),
                         framewid.p_height-(XBUFFER * 2),
                         CW_CHILD);
      if (wid) {
         wid.p_eventtab=find_index('_api_control',EVENTTAB_TYPE);
         wid.p_width=(framewid.p_width intdiv 2) -100;
         wid.p_height=wid._text_height();
         if (lastwid) {
            if (lastwid.p_x==XBUFFER) {
               wid.p_x=xcol2;
               y=wid.p_y+wid.p_height+XBUFFER;
            }else{
               wid.p_x=XBUFFER;
            }
         }
         lastwid=wid;
         wid.p_tab_stop=1;
         wid.p_tab_index=++ControlNumber;
         if (i==1) wid.p_value=1;
      }else{
         return(0);
      }
   }
   framewid.p_height=wid.p_y+wid.p_height+XBUFFER;
   gLastControlExtent=framewid.p_y+framewid.p_height;
   return(wid);
}


#define gHeaderExtents ctlheader_inner.p_user
//How far down lowest existing label reaches

static void AddArguments(_str Params[],_str Comments[])
{
   parse gHeaderExtents with firstx firsty;
   int max_x=firstx,max_y=firsty,Noflines=0;
   int cur_max_x=firstx,cur_max_y=0;
   int YCoord[];YCoord._makeempty();
   for (i=0;i<Params._length();++i) {
      _str ch='';
      if (i<Params._length()-1 &&
          last_char(Params[i])!=',') {
         ch=',';
      }
      YCoord[YCoord._length()]=cur_max_y;
      p_window_id._CreateBoldItalicLabels(cur_max_x,
                                          cur_max_y,
                                          Noflines,
                                          p_window_id,//Parent wid
                                          Params[i]:+ch,//message
                                          "",//sepchars
                                          firstx,cur_max_y,//startx,starty
                                          100,//maxwidth(doesn't matter)
                                          "",//Font string
                                          p_forecolor,p_backcolor,
                                          0,//Wrap indent
                                          0);//Flags
      //QuickSort writeobject
      //pauseTrue sort swap
      //equals isJavaLetter
      if (cur_max_x>max_x) {
         max_x=cur_max_x;
      }
   }
   
   for (i=0;i<Params._length();++i) {
      cur_max_y2=cur_max_y;
      p_window_id._CreateBoldItalicLabels(cur_max_x,
                                          cur_max_y2,
                                          Noflines,
                                          p_window_id,//Parent wid
                                          "\1<i>"Comments[i]"\1</i>",//message
                                          "",//sepchars
                                          max_x+100,YCoord[i],//startx,starty
                                          100,//maxwidth(doesn't matter)
                                          "",//Font string
                                          p_forecolor,p_backcolor,
                                          0,//Wrap indent
                                          0);//flags
   }
   gHeaderExtents=cur_max_x' 'cur_max_y;
}

static int ProcessField(_str field,int FormWid,int &ControlNumber,
                        _str (&Params)[],_str (&Comments)[])
{
   id=substr(field,1,2);
   data=substr(field,3);
   _str param_name='',comment='';
   parse data with data (ASCII3) Description;
   parse Description with param_name "\t" comment;
   if (param_name=='') {
      param_name=substr(data,2);
      parse data with param_name (ASCII2) comment_data;
   }
   if (param_name=='') {
      param_name=comment_data;
      //Now try to get rid of any comment delimiters
      param_name=stranslate(param_name,'','/*');
      param_name=stranslate(param_name,'','*/');
      param_name=stranslate(param_name,'','//');
      param_name=stranslate(param_name,'','{');
      param_name=stranslate(param_name,'','}');
   }
   Params[Params._length()]=param_name;
   Comments[Comments._length()]=comment;
   switch (id) {
   case API_RADIO_BUTTON_STR:
      wid=AddRadioButtons(data,FormWid,ControlNumber,comment);
      return wid;
   case API_CHECK_BOX_STR:
      wid=AddCheckBoxes(data,FormWid,ControlNumber,comment);
      return wid;
   case API_COMBO_BOX_STR:
      wid=AddComboBox(data,FormWid,ControlNumber,comment);
      return wid;
   case API_TEXT_BOX_STR:
      wid=AddTextBox(data,FormWid,ControlNumber,comment);
      return wid;
   }
   return(0);
}

//If arg(1)==1 it is ok to set focus to a radio button
static void FirstControl(...)
{
   if (p_child) {
      if (p_child.p_object!=OI_RADIO_BUTTON || arg(1)==1) {
         //If the child is a radio button the value is automatically set
         p_window_id=p_child;
         p_child._set_focus();
      }
      if (p_child.p_object==OI_TEXT_BOX || p_child.p_object==OI_COMBO_BOX) {
         p_child._set_sel(1,length(p_child.p_text)+1);
      }
   }
}

//Just does a linear search because this table is not sorted.  Hope that it
//doesn't get to big
static int GetClassTableIndex(_str ClassName,_str ClassTable[])
{
   for (i=0;i<ClassTable._length();++i) {
      if (!stricmp(ClassName,ClassTable[i])) {
         return(i);
      }
   }
   return(-1);
}

static void BlastTabStops()
{
   int wid,firstwid;
   wid=firstwid=p_child;
   for (;;) {
      wid.p_tab_stop=0;wid.p_tab_index=0;
      if (wid.p_child) {
         wid.BlastTabStops();
      }
      wid=wid.p_next;
      if (wid==firstwid) break;
   }
}

/*
Operates on a caption.  Fills in with word wrap and sets height
*/
static void FillInCaption(_str FunctionDescription)
{
   int CurWordWidth=0;
   int CurLineWidth=0;
   _str WholeLine=FunctionDescription;
   _str CurLine='';
   _str Lines[];
   for (;;) {
      parse WholeLine with CurWord WholeLine;
      if (CurWord=='') break;
      CurWordWidth=_text_width(CurWord' ');
      CurLineWidth=_text_width(CurLine);
      if (CurWordWidth+CurLineWidth+100>p_width) {
         Lines[Lines._length()]=CurLine;
         CurLine='';
         CurLineWidth=0;
      }
      CurLine=CurLine' 'CurWord;
   }
   Lines[Lines._length()]= CurLine;
   eol='';
   for (i=0;i<Lines._length();++i) {
      p_caption=p_caption:+eol:+strip(Lines[i]);
      eol="\n";
   }
   p_height=_text_height()*Lines._length()+(30*Lines._length());
}

static void MaybeAddDescription(_str DescriptionTitle,_str Description,
                                int &max_x,int &max_y)
{
   if (Description!='') {
      p_window_id._CreateBoldItalicLabels(max_x,
                                          max_y,
                                          Noflines,
                                          p_window_id,//Parent wid
                                          "\1<b>"DescriptionTitle"\1</b>",
                                          " ",//sepchars
                                          0,max_y,//startx,starty
                                          p_width,//maxwidth(doesn't matter)
                                          "",//Font string
                                          p_forecolor,p_backcolor,
                                          0,//Wrap indent
                                          0);//Flags
      for (;;) {
         parse Description with cur (ASCII1) Description;
         if (cur=='') break;
         cur=strip(cur);
         p_window_id._CreateBoldItalicLabels(max_x,
                                             max_y,
                                             Noflines,
                                             p_window_id,//Parent wid
                                             cur,
                                             " ",//sepchars
                                             0,max_y,//startx,starty
                                             p_width,//maxwidth(doesn't matter)
                                             "",//Font string
                                             p_forecolor,p_backcolor,
                                             0,//Wrap indent
                                             0);//Flags
      }
   }
   gHeaderExtents=max_x' 'max_y;
}

static void AddAllFunctionInfo(_str MarkedUpFunctionTitle,
                               _str Params[],_str Comments[],
                               _str FunctionDescription,
                               _str ReturnInfo,
                               _str SeeInfo,
                               _str DeprecatedInfo,
                               _str SinceInfo,
                               _str AuthorInfo,
                               _str ExceptionInfo,
                               _str LinkInfo)
{
   int max_x=0,max_y=0,Noflines=0;
   p_window_id._CreateBoldItalicLabels(max_x,
                                       max_y,
                                       Noflines,
                                       p_window_id,//Parent wid
                                       strip(MarkedUpFunctionTitle),//message
                                       " ",//sepchars
                                       0,0,//startx,starty
                                       10000,//maxwidth(doesn't matter)
                                       "",//Font string
                                       p_forecolor,p_backcolor,
                                       0,//Wrap indent
                                       0);//Flags
   int FunctionNameMaxX=max_x;
   gHeaderExtents=max_x' 'max_y;
   AddArguments(Params,Comments);
   parse gHeaderExtents with str_max_x str_max_y;
   max_x=(int) str_max_x;
   max_y=(int) str_max_y;
   p_window_id._CreateBoldItalicLabels(max_x,
                                       max_y,
                                       Noflines,
                                       p_window_id,//Parent wid
                                       "\1<b>)\1</b>",//message
                                       "",//sepchars
                                       FunctionNameMaxX,max_y,//startx,starty
                                       100,//maxwidth(doesn't matter)
                                       "",//Font string
                                       p_forecolor,p_backcolor,
                                       0,//Wrap indent
                                       0);//Flags
   gHeaderExtents=max_x' 'max_y;
   MaybeAddDescription("Description:",FunctionDescription,max_x,max_y);
   MaybeAddDescription("Deprecated:",DeprecatedInfo,max_x,max_y);
   MaybeAddDescription("Returns:",ReturnInfo,max_x,max_y);
   MaybeAddDescription("Exception:",ExceptionInfo,max_x,max_y);
   MaybeAddDescription("Since:",SinceInfo,max_x,max_y);
   MaybeAddDescription("See:",SeeInfo,max_x,max_y);
   MaybeAddDescription("Author:",AuthorInfo,max_x,max_y);
   MaybeAddDescription("Link:",LinkInfo,max_x,max_y);
   //QuickSort writeobject
   //pauseTrue sort swap
   //equals isJavaLetter
   //Character
}
//CreateWindowEx
//MessageBoxEx


//This is in twips

#define BEFORE_DIVIDER_BUFFER 100

int ApiApprentice(_str FileName,_str FunctionName,_str ClassName,_str &RVal)
{
   SmallestFrame=0;
   RealFileName=''
   if (file_match(absolute(FileName),1)=='') {
      RealFileName=slick_path_search(FileName);
      if (RealFileName=='') RealFileName=FileName;
   }else{
      RealFileName=FileName;
   }
   inmem=1;
   status=_open_temp_view(RealFileName,temp_view_id,orig_view_id,'+b');
   if (status) {
      inmem=0
      status=_open_temp_view(RealFileName,temp_view_id,orig_view_id);
   }
   if (status) {
      _message_box(nls("Could not find API Assitance database file '%s'",RealFileName));
      return(status);
   }
   p_view_id=temp_view_id;
   LANGUAGE_INFO_T LTable[];
   status=LoadLanguageInfoTable('',LTable);
   if (status) {
      _message_box(nls("Could not load Language specific information table in API Assitance database file '%s'",RealFileName));
      return(status);
   }
   _str ClassTable[];
   status=LoadClassTable('',ClassTable);
   if (status) {
      _message_box(nls("Could not load Class Name table in API Assitance database file '%s'",RealFileName));
      return(status);
   }
   ClassTableIndex=GetClassTableIndex(ClassName,ClassTable);

   if (!status) {
      p_line=0;
      //I added the 'i' option because the indexer upcases everything 9:28pm 5/14/1996
      SkipToFirstEntry();_begin_line();
      /*This RegEx is getting hairy because I now have to include the Class table
        Index in the search, which means that I have to search for any
        possiblility in some other fields 10:51am 5/22/1996*/

      //FunctionNameTypeLInfoIndexCLASSTABLEINDEX???????????????
      SearchRE='^'_escape_re_chars(FunctionName):+ASCII1'?@':+ASCII1'?@':+ASCII1:+ClassTableIndex:+ASCII1'?@$';
      status=search(SearchRE,'@ri');
      if (!status) {
         get_line(line);
      }
   }
   p_view_id=orig_view_id;
   if (!inmem) {
      _delete_temp_view(temp_view_id);
   }else{
      p_view_id=temp_view_id;
      _quit_view();
      p_view_id=orig_view_id;
   }
   if (status) {
      _message_box(nls("Could not find entry for %s in API Assitance database file '%s'",FunctionName,RealFileName));
      return(status);
   }
   wid=show('-hidden _api_form',FunctionName);
   wid.BlastTabStops();
   _control ctlheader_inner;
   wid.ctlheader_inner.p_x=0;
   wid.ctlheader_inner.p_y=0;
   parse line with id (ASCII1) type (ASCII1) LTableIndex (ASCII1) ClassTableIndex (ASCII1) +0 rest;
   wid._ctlok.p_user=LTable[LTableIndex];
   _str FunctionTitle='';
   if (ClassName!='') {
      wid.p_caption=type' 'ClassName'::'id;
   }else{
      wid.p_caption=id;
   }
   id=stranslate(id,'','\(?@\)','r');
   _str MarkedUpFunctionTitle;
   if (type!='') {
      MarkedUpFunctionTitle="\1<b>"strip(type)" "strip(id)"(\1</b>";
   }else{
      MarkedUpFunctionTitle="\1<b>"strip(id)"(\1</b>";
   }
   i=0;
   LastControlWID=0;
   FrameNumber=0;
   //12:38pm 4/23/1998
   //Working on support for new api apprentice stuff
   parse rest with rest (ASCII4) OtherFunctionInfo (ASCII5);//Strip off new stuff...
   parse OtherFunctionInfo with FunctionDescription (ASCII4) ReturnInfo (ASCII4) SeeInfo (ASCII4) DeprecatedInfo (ASCII4) SinceInfo (ASCII4) AuthorInfo (ASCII4) ExceptionInfo (ASCII4) LinkInfo (ASCII5);
   _str Params[],Comments[];
   Params._makeempty();Comments._makeempty();
   for (;;) {
      parse rest with (ASCII1) field (ASCII1) +0 rest;
      if (rest=='') break;
      LastControlWID=ProcessField(field,wid,i,Params,Comments);
      pixheight=_ly2dy(LastControlWID.p_parent.p_scale_mode,LastControlWID.p_parent.p_height);
      if (pixheight<SmallestFrame || !SmallestFrame) {
         SmallestFrame=pixheight;
         //SmallestFrame=_ly2dy(LastControlWID.p_parent.p_scale_mode,LastControlWID.p_parent.p_height);
         //messageNwait(nls('SmallestFrame=%s LastControlWID.p_height=%s',SmallestFrame,LastControlWID.p_height));
         //SmallestFrame=LastControlWID.p_height
      }
      ++FrameNumber;
   }
   wid.ctlheader_inner.AddAllFunctionInfo(MarkedUpFunctionTitle,
                                          Params,
                                          Comments,
                                          FunctionDescription,
                                          ReturnInfo,
                                          SeeInfo,
                                          DeprecatedInfo,
                                          SinceInfo,
                                          AuthorInfo,
                                          ExceptionInfo,
                                          LinkInfo);
   parse wid.gHeaderExtents with max_x max_y;
   _nocheck _control ctlheader_outer;
   wid.ctlheader_inner.p_height=wid.ctlheader_outer.p_height=max_y;
   wid._ctldivider.p_y=wid.ctlheader_outer.p_height+wid.ctlheader_outer.p_y+BEFORE_DIVIDER_BUFFER;
   oldwid=p_window_id;p_window_id=wid;
   int AdjustY=0;

   _ctlok.p_tab_index=_ctlcancel.p_tab_index=_ctlhelp.p_tab_index=0;
   //CreateWindowEx
   if (LastControlWID) {
      _ctlok.p_tab_index=LastControlWID.p_tab_index+1;
      _ctlcancel.p_tab_index=_ctlok.p_tab_index+1;
      _ctlhelp.p_tab_index=_ctlcancel.p_tab_index+1;
      _ctlview_file.p_tab_index=_ctlhelp.p_tab_index+1;
      _ctlcancel.p_tab_stop=1;
      _ctlview_file.p_tab_stop=1;
      _ctlok.p_tab_stop=1;
      _ctlhelp.p_tab_stop=1;
   }

   _ctlinner_picture.p_height=gLastControlExtent+100;
   gLastControlExtent=0;
   parse gHeaderExtents with max_x max_y;
   //_ctldivider.p_y=max_y+ctlheader_outer.p_y+100;
   _ctlouter_picture.p_y=_ctldivider.p_y+_ctldivider.p_height+100;
   if (_ctlinner_picture.p_height<=_ctlouter_picture.p_height) {
      vscroll1.p_enabled=0;
   }
   _ctlouter_picture.p_height=_ctlok.p_y-(_ctlouter_picture.p_y+100);

   vscroll1.p_y=_ctlouter_picture.p_y;
   vscroll1.p_min=1;
   //vscroll1.p_max=(_ctlinner_picture.p_height-LastControlWID.p_parent.p_height-(LastControlWID._text_height() intdiv 2)) intdiv _twips_per_pixel_y();
   if (LastControlWID) {
      LastFrameHeight=_ly2dy(LastControlWID.p_parent.p_scale_mode,LastControlWID.p_parent.p_height+(LastControlWID._text_height() intdiv 2));
   }else{
      LastFrameHeight=0;
   }
   _ctlview_file.p_user=SmallestFrame;
   vscroll1.p_max=_ly2dy(_ctlinner_picture.p_scale_mode,_ctlinner_picture.p_height)-LastFrameHeight;
   vscroll1.p_value=1;
   if (LastControlWID) {
      vscroll1.p_small_change=SmallestFrame;
      vscroll1.p_large_change=_ly2dy(_ctlouter_picture.p_scale_mode,_ctlouter_picture.p_height-LastControlWID.p_parent._text_height());
      _ctlview_file.p_user=LastControlWID.p_parent._text_height();
   }else{
      vscroll1.p_small_change=1;
      vscroll1.p_large_change=_ly2dy(_ctlouter_picture.p_scale_mode,_ctlouter_picture.p_height);
      _ctlview_file.p_user=0;
   }
   vscroll1.p_height=_ctlouter_picture.p_height;
   _ctlinner_picture.FirstControl(1);

   p_visible=1;
   refresh();
   RVal='';
   RVal=_modal_wait(wid);
   if (RVal!='') {
      return(0);
   }
   return(COMMAND_CANCELLED_RC);
}

static int NumberOfLines()
{
   line=p_caption;
   i=0;
   for (;;) {
      parse line with cur "\n" line;
      if (cur=='') break;
      ++i;
   }
   return(i);
}


_ctlok.on_create()
{
   gLastControlExtent=0;
   if (_no_child_windows()) {
      _ctlview_file.p_visible=0;
   }
}

static void APIHelp(_str FunctionName)
{
   parse (machine()=='OS2386')?def_who:def_wh with first ';' second ';' third ';' rest
   _word_help(first,FunctionName,1);
}

_ctlhelp.lbutton_up()
{
   FunctionName=p_active_form.p_caption;
   if (pos('::',FunctionName)) {
      parse FunctionName with '::' FunctionName;
   }
   if (pos('(',FunctionName)) {
      //parse FunctionName with '(' FunctionName;
      parse FunctionName with FunctionName '(' .;
   }
   APIHelp(FunctionName);
}

static int roundup(number)
{
   p=pos('.',number);
   if (p) {
      number=substr(number,1,p-1);
      ++number;
   }
   return(number);
}

vscroll1.on_scroll()
{
   _ctlhelp.p_user=1;
   _ctlinner_picture.p_y=-(p_value*_twips_per_pixel_y());
}
vscroll1.on_change()
{
   _ctlhelp.p_user=1;
   _ctlinner_picture.p_y=-(p_value*_twips_per_pixel_y());
}
vscroll1.on_sb_end_scroll()
{
   _ctlhelp.p_user='';
}

ctlheader_vscroll.on_scroll()
{
   _ctlhelp.p_user=1;
   ctlheader_inner.p_y=-(p_value*_twips_per_pixel_y());
}
ctlheader_vscroll.on_change()
{
   _ctlhelp.p_user=1;
   ctlheader_inner.p_y=-(p_value*_twips_per_pixel_y());
}
ctlheader_vscroll.on_sb_end_scroll()
{
   _ctlhelp.p_user='';
}

static _str GetInfo(LANGUAGE_INFO_T LInfo)
{
   wid=p_window_id;
   p_window_id=p_child;
   switch (p_object) {
   case OI_RADIO_BUTTON:
   case OI_CHECK_BOX:
      str='';
      first=p_window_id;
      for (;;) {
         if (p_value) {
            parse p_caption with val .;
            if (length(LInfo.Or)==1) {
               str=str:+val:+LInfo.Or;
            }else{
               str=str:+val:+' 'LInfo.Or;
            }
         }
         p_window_id=p_next;
         if (p_window_id==first) {
            if (str!='') {
               return(substr(str,1,length(str)-length(LInfo.Or)));
            }else{
               return(0);
            }
         }
      }
   case OI_COMBO_BOX:
   case OI_TEXT_BOX:
      return(p_text);
   }
   p_window_id=wid;
   return('');
}

_str _ctlok.lbutton_up()
{
   LANGUAGE_INFO_T LInfo;
   LInfo=_ctlok.p_user;
   p=pos('(',p_active_form.p_caption);
   if (!p) {
      line=p_active_form.p_caption:+LInfo.LParen;
   }else{
      line=substr(p_active_form.p_caption,1,p-1):+LInfo.LParen;
   }
   if (pos('::',line)) {
      parse line with '::' line;
   }
   firstwid=wid=_ctlinner_picture.p_child;
   for (;wid;) {
      if (wid.p_object!=OI_FRAME) {
         return('');
      }

      line=line:+wid.GetInfo(LInfo):+LInfo.Delim;
      wid=wid.p_next;
      if (wid==firstwid) break;
   }
   //If !wid, there were no frames(function takes no params), so we don't need
   //to strip a LInfo.Delim char from the end.
   numstripchars=(int)wid!=0;

   line=substr(line,1,length(line)-numstripchars)
   while (last_char(line)==LInfo.Delim) {
      line=substr(line,1,length(line)-1);
   }
   line=line:+LInfo.RParen;
   p_active_form._delete_window(line);
   return(line);
}

_ctlview_file.lbutton_up()
{
   if (_no_child_windows()) {
      return('');
   }
   wid=show('-hidden _showbuf_form',_mdi.p_child.p_buf_id);
   wid.p_caption=_mdi.p_child.p_buf_name;
   _nocheck _control list1;

   parse _default_font(CFG_WINDOW_TEXT) with font_name','font_size','font_flags','.;
   wid.list1.p_font_bold=font_flags&F_BOLD;
   wid.list1.p_font_italic=font_flags&F_ITALIC;
   wid.list1.p_font_strike_thru=font_flags&F_STRIKE_THRU;
   wid.list1.p_font_underline=font_flags&F_UNDERLINE;
   wid.list1.p_font_name=font_name;
   wid.list1.p_font_size=font_size;
   wid.list1.top();
   wid.list1.p_line=_mdi.p_child.p_line;
   wid.list1.p_col=_mdi.p_child.p_col;
   wid.p_visible=1;

   _modal_wait(wid);
}

defeventtab _api_editor_form

void _ctlpcomment.on_change()
{
   if (_ctlleft.p_user==1) return;
   SetModifyFlags();
}
void _ctlpname.on_change()
{
   if (_ctlleft.p_user==1) return;
   SetModifyFlags();
}

void _ctlpcomment.on_got_focus()
{
   if (p_text=='' && _ctlpname.p_text!='') {
      p_text=_ctlpname.p_text;
#if 0
      Comment=_ctlpname.p_text;
      if (last_char(Comment)=="\t") {
         Comment=substr(Comment,1,length(Comment)-1);
      }
      Comment=Comment' ';
      Comment=stranslate(Comment,'\t',"\t");
      Comment=stranslate(Comment,',',";");
      Comment=stranslate(Comment,'//',"/* ");
      parse Comment with beg '//' rest;
      Comment=beg'//'upcase(substr(rest,1,1)):+substr(rest,2);
      while (!pos('[a-zA-Z.]',last_char(Comment),'','r')) {
         Comment=substr(Comment,1,length(Comment)-1);
      }
      if (pos('*',Comment)) {
         p=pos('*',Comment);
         type=substr(Comment,1,p);
         name=substr(Comment,p+1);
         parse name with name ',' .;
      }else{
         parse Comment with type name',' .;
      }
      _ctlval_list.get_line(line);
      if (line==''||_ctlval_list.p_Noflines=='') {
         _ctlval_list.replace_line(name);
      }
      p_text=Comment;
      _ctlpname.p_text=type;
      _end_line();
#endif
   }
}

void _ctlapi_help.lbutton_up()
{
   FunctionName=_ctlfunction_list.p_cb_list_box._lbget_text();
   if (pos('(',FunctionName)) {
      parse FunctionName with FunctionName '(' .;
   }
   APIHelp(FunctionName);
}

_ctlclose.lbutton_up()
{
   api_editor_exit();
}
_ctlleft.on_change()
{
   if (_ctlleft.p_user==1) return('');
   SetModifyFlags();
}

struct PARAM_T {
   _str ControlType;
   _str ParamType;
   _str Values[];
   _str Comment;
};

struct API_ENTRY_T {
   _str FunctionName;
   _str Type;
   _str LanguageTableIndex;//This should be an int, but parse ints will not work with parse
   _str ClassTableIndex;//This should be an int, but parse ints will not work with parse
   PARAM_T ParamList[];
   _str ExtendedInfo;
};

/*
struct EXTENDED_INFO{
   _str description;     //General info about function
   _str param[];     //Array of information strings about each parameter(1 string/param)
   _str see[];       //Array of see info for function
   _str author[];    //Array of authors for function
   _str since;       //since info for function
   _str returninfo;  //return info for function
   _str exception[]; //@throws is synonym.  put those in here too
   _str deprecated;
   _str link[];      //html link.  Might as well try it...
}
*/

struct API_ASST_TABLE_T {
   LANGUAGE_INFO_T LInfo[];
   API_ENTRY_T APIEntries[];
   _str FileDescription;
};

#define DOC_DESCRIPTION "Description"
#define DOC_DEPRECATED  "Deprecated"
#define DOC_RETURNS     "Returns"
#define DOC_EXCEPTION   "Exception"
#define DOC_SINCE       "Since"
#define DOC_SEE         "See"
#define DOC_AUTHOR      "Author"
#define DOC_LINK        "Link"

/* parses info out of string extended_info and puts it into a hash table*/
static typeless GetExtendedInfoTable(_str extended_info)
{
   parse extended_info with FunctionDescription (ASCII4) ReturnInfo (ASCII4) SeeInfo (ASCII4) DeprecatedInfo (ASCII4) SinceInfo (ASCII4) AuthorInfo (ASCII4) ExceptionInfo (ASCII4) LinkInfo (ASCII5);
   _str temp:[];
   temp:[DOC_DESCRIPTION]=strip(FunctionDescription);
   temp:[DOC_DEPRECATED]=strip(DeprecatedInfo);
   temp:[DOC_RETURNS]=strip(ReturnInfo);
   temp:[DOC_EXCEPTION]=strip(ExceptionInfo);
   temp:[DOC_SINCE]=strip(SinceInfo);
   temp:[DOC_SEE]=strip(SeeInfo);
   temp:[DOC_AUTHOR]=strip(AuthorInfo);
   temp:[DOC_LINK]=strip(LinkInfo);
   return(temp);
}

static _str GetExtendedInfoStr(_str ExtendedInfoTable:[])
{
   return(ASCII4:+
          ExtendedInfoTable:[DOC_DESCRIPTION]:+ASCII4:+
          ExtendedInfoTable:[DOC_RETURNS]:+ASCII4:+
          ExtendedInfoTable:[DOC_SEE]:+ASCII4:+
          ExtendedInfoTable:[DOC_DEPRECATED]:+ASCII4:+
          ExtendedInfoTable:[DOC_SINCE]:+ASCII4:+
          ExtendedInfoTable:[DOC_AUTHOR]:+ASCII4:+
          ExtendedInfoTable:[DOC_EXCEPTION]:+ASCII4:+
          ExtendedInfoTable:[DOC_LINK]:+ASCII5);
}

static API_ENTRY_T GetEntry(int index)
{
   API_ENTRY_T temp;
   orig_view_id=p_view_id;
   temp_view_id=_ctldescription.p_user
   p_view_id=temp_view_id;
   p_line=0;
   SkipToFirstEntry();
   p_line=p_line+(index-1);//Skip over the LInfo Table, and the file description
   get_line(line);
   parse line with temp.FunctionName (ASCII1) temp.Type (ASCII1) temp.LanguageTableIndex (ASCII1) temp.ClassTableIndex (ASCII1) rest (ASCII4) extended_info (ASCII5);
   p_view_id=orig_view_id;
   ctldocumentation.p_user=GetExtendedInfoTable(extended_info);
   p_view_id=temp_view_id;
   if (rest!='') {
      j=0;
      for (;;) {
         parse rest with cur (ASCII1) rest;
         if (cur=='') break;
         temp.ParamList[j].ControlType=substr(cur,1,2);cur=substr(cur,3);
         parse cur with temp.ParamList[j].ParamType (ASCII2) cur;
         parse cur with cur (ASCII3) temp.ParamList[j].Comment;
         k=0;
         for (;;) {
            parse cur with tempstr (ASCII2) cur;
            if (tempstr=='') break;
            temp.ParamList[j].Values[k]=tempstr;
            ++k;
         }
         ++j;
      }
   }
   p_view_id=orig_view_id;
   return(temp);
}

ctldocumentation.lbutton_up()
{
   _str funcName=_ctlfunction_list.p_cb_list_box._lbget_text();
   temp=ctldocumentation.p_user;
   result=show('-modal _api_documentation_form',ctldocumentation.p_user,funcName);
   if (result!='') {
      _ctlval_list.p_user=1;//Modify flag
      ctldocumentation.p_user=_param1;
   }
}

//This function is global because it is used in helpidx.e
int GetAPIFileDescription(_str FileName,_str &Description)
{
   inmem=1;
   status=_open_temp_view(FileName,temp_view_id,orig_view_id,'+b');
   if (status) {
      inmem=0;
      status=_open_temp_view(FileName,temp_view_id,orig_view_id);
   }
   if (status) return status;
   p_view_id=temp_view_id;
   p_line=0;
   status=SkipToFirstEntry();
   if (status!=BOTTOM_OF_FILE_RC) {
      up();//This is the line with the file description
   }
   get_line(Description);
   p_view_id=orig_view_id;
   if (!inmem) {
      _delete_temp_view(temp_view_id);
   }else{
      p_view_id=temp_view_id;
      _quit_view();
   }
   p_view_id=orig_view_id;
   return(0);
}

static int LoadFunctionNameTable(_str FileName,int wid)
{
   status=_open_temp_view(FileName,temp_view_id,orig_view_id);
   if (status) {
      return(status);
   }
   p_view_id=orig_view_id;
   _ctlfunction_list.p_cb_list_box._lbclear();
   _ctldescription.p_user=temp_view_id;
   p_view_id=temp_view_id;
   p_line=0;
   if (SkipToFirstEntry()) {
      p_view_id=orig_view_id;
      return(0);//There are no entries, but that's ok
   }
   up();//This is the line with the file description
   get_line(line);
   i=0;
   while (!down()) {
      get_line(line);
      parse line with FunctionName (ASCII1).
      wid._lbadd_item(FunctionName);
      ++i;
   }
   p_view_id=orig_view_id;
   return(0);
}

_api_editor_form.on_create()
{
   index=find_index("_api_editor_menu",oi2type(OI_MENU));
   if (index) {
      b4height=p_client_height;
      menu_handle=p_active_form._menu_load(index);
      status=p_active_form._menu_set(menu_handle);
      add=b4height-p_client_height;
      p_height+=add*_twips_per_pixel_y();
   }
   p_active_form.disable_all_controls();
   _ctlpframe.disable_all_controls();
   _ctlclose.p_enabled=1;
}

static int CreateNewDatabase(_str FileName)
{
   orig_view_id=_create_temp_view(temp_view_id);
   p_buf_name=FileName;
   //There have to be some delimiters, so we might as well start with these and
   //Let the user blast them if they need to.
   insert_line('()|,');
   insert_line(ASCII2);//This is the end flag for the Language Info Table
   //There has to be a null entry for the Class Table
   insert_line('');
   insert_line(ASCII2);//This is the end flag for the Class Table
   insert_line('New API Database 'FileName);
   p_view_id=orig_view_id;
   _ctldescription.p_user=temp_view_id;
   _ctltest.p_user=1;//Set the global modify flag
   return(0);
}

//Do not delete this.  This dumps the stuff for the help indexer
_command dump_all_api_entries()
{
   FileName=arg(1);
   if (arg(1)=='') {
      _message_box(nls("This command should only be used to insert API Database files for Indexing."));
      return(COMMAND_CANCELLED_RC);
   }
   if (file_match(maybe_quote_filename(FileName)' -p',1)=='') {
      _message_box(nls("Cannot find API Database file %s",FileName));
      return(FILE_NOT_FOUND_RC);
   }
   inmem=1;
   status=_open_temp_view(FileName,temp_view_id,orig_view_id,'+b');
   if (status) {
      inmem=0;
      status=_open_temp_view(FileName,temp_view_id,orig_view_id);
         if (status) {
            _message_box(nls("Could not open API Database file %s\n\n%s",FileName,get_message(status)));
            return(status);
         }
   }
   p_view_id=temp_view_id;
   _str ClassNameTable[];
   LoadClassTable('',ClassNameTable);
   status=SkipToFirstEntry();
   if (SkipToFirstEntry()){
      p_view_id=orig_view_id;
      _delete_temp_view(temp_view_id);
      return(0);
   }
   up();//Start just above the first entry
   while (!down()) {
      get_line(line);
      parse line with FunctionName (ASCII1) Type (ASCII1) LInfoIndex (ASCII1) ClassNameIndex (ASCII1) .;
      FunctionName=stranslate(FunctionName,'',' ');
      p_view_id=orig_view_id
      if (ClassNameTable[ClassNameIndex]=='') {
         insert_line(' 'FunctionName);
      }else{
         insert_line(' 'FunctionName:+ASCII1:+ClassNameTable[ClassNameIndex]);
      }
      p_view_id=temp_view_id;
   }
   p_view_id=orig_view_id;
   if (!inmem) {
      _delete_temp_view(temp_view_id);
   }else{
      p_view_id=temp_view_id;
      _quit_view();
      p_view_id=orig_view_id;
   }
}

_command int api_editor_open()
{
   if (p_active_form.p_name!='_api_editor_form') {
      _message_box(nls("_api_editor_form must be active to run this command"));
      return(1);
   }
   result=arg(1);
   if (result=="") {
      result=_OpenDialog('-modal '_stdform("_open_form"), "Open API Apprentice Database File",
                  "*.api",
                  'API Files (*.api),All Files ('ALLFILES_RE')',
                  '',//flags
                  'api'//default_ext
                  );
      if (result=='') {
         return(COMMAND_CANCELLED_RC);
      }
   }
   FileName=result;
   mou_hour_glass(1);
   if (file_match(FileName" -p",1)!='') {
      New=0;
   }else{
      New=1;
      FileName=strip(FileName,'B','"');
      CreateNewDatabase(FileName);
   }
   status=LoadFunctionNameTable(FileName,_control _ctlfunction_list.p_cb_list_box);
   LANGUAGE_INFO_T LInfo[];
   FileName=strip(absolute(FileName),'B','"');
   status=LoadLanguageInfoTable(FileName,LInfo);
   if (status) {
      _message_box(nls("Could not load Language Information Table for file %s\n\n%s",FileName,get_message(status)));
      return(status);
   }

   _ctldelim.p_user=LInfo;
   _str ClassTable[];
   status=LoadClassTable(FileName,ClassTable);
   if (status) {
      _message_box(nls("Could not load Class Table for file %s\n\n%s",FileName,get_message(status)));
      return(status);
   }
   _ctlclass_name.p_user=ClassTable;
   mou_hour_glass(0);
   if (status) {
      _message_box(nls("Could not load API Apprentice database file '%s'\n\n%s",FileName,get_message(status)));
      return(status);
   }
   p_active_form.p_caption='API Apprentice Database Editor - 'FileName
   status=GetAPIFileDescription(FileName,FileDescription);
   if (status) {
      _message_box(nls("Could not get description for file %s\n\n",FileName,get_message(status)));
      //Don't know if I should return an error here or not
   }
   _ctldescription.p_text=FileDescription;
   _ctlfunction_list.p_cb_list_box._lbtop();
   _ctlfunction_list.p_cb_list_box._lbselect_line();
   //_ctlfunction_list.call_event(CHANGE_SELECTED,_ctlfunction_list,ON_CHANGE,'w');
   ShowFunction();

   if (!New) {
      p_active_form.disable_all_controls(1);
      EnableOrDisableButtons();
   }else{
      _ctladd.p_enabled=1;
      _ctldescription.p_enabled=1;
   }
   if (!New) {
      _ctltest.p_user='';//Reset the modify flag for the database
   }else{
      _ctltest.p_user=1;//Always want to save new database
   }
   if (!status) {
      _ctlfunction_list._set_focus();
   }
   if (status) return status;
   return(0);
}

static void FillInFunctionList(API_ASST_TABLE_T *pAPITable)
{
   for (i=0;i<pAPITable->APIEntries._length();++i) {
      _ctlfunction_list.p_cb_list_box._lbadd_item(pAPITable->APIEntries[i].FunctionName);
   }
}

_command int api_editor_exit()
{
   if (p_active_form.p_name!='_api_editor_form') {
      _message_box(nls("_api_editor_form must be active to run this command"));
      return(1);
   }
   if (_ctltest.p_user==1 || _ctlval_list.p_modify) {//Global Modify Flag
      parse p_active_form.p_caption with '-' FileName;
      FileName=strip(FileName);
      result=_message_box(nls("Save changes to '%s'",FileName),'',MB_YESNOCANCEL|MB_ICONQUESTION);
      if (result==IDYES) {
         api_editor_save();
      }else if (result==IDCANCEL) {
         return(COMMAND_CANCELLED_RC);
      }
   }
   p_active_form._delete_window(0);
   return(0);
}

_command int api_editor_save() //Don't think we should need name info
{
   if (p_active_form.p_name!='_api_editor_form') {
      _message_box(nls("_api_editor_form must be active to run this command"));
      return(1);
   }

   if (!_ctlfunction_list.p_cb_list_box.p_Noflines) {
      _message_box(nls("No functions to save"));
      return(0);
   }
   //First, we have to take care of the current entry
   API_ENTRY_T Entry;
   SaveParameter();
   Entry=_ctlfunction_list.p_user;
   Entry.Type=_ctlreturn_type.p_text;
   Entry.ClassTableIndex=CreateClassTableIndex(_ctlclass_name.p_text);
   Entry.LanguageTableIndex=GetLInfoTableIndex(strip(_ctlleft.p_text),
                                               strip(_ctlright.p_text),
                                               strip(_ctldelim.p_text),
                                               strip(_ctlor.p_text));
   temp=ctldocumentation.p_user;
   Entry.ExtendedInfo=GetExtendedInfoStr(temp);
   WriteEntry(Entry,_ctlfunction_list.p_cb_list_box.p_line,_ctldescription.p_user);
   //Done with the current entry

   orig_view_id=p_view_id;
   temp_view_id=_ctldescription.p_user;
   Description=_ctldescription.p_text;
   LANGUAGE_INFO_T LInfo[];
   LInfo=_ctldelim.p_user;
   _str ClassTable[];
   ClassTable=_ctlclass_name.p_user;
   p_view_id=temp_view_id;
   mou_hour_glass(1);
   WriteLanguageInfoTable(LInfo,temp_view_id);
   WriteClassNameTable(ClassTable,temp_view_id);
   WriteFileDescription(Description,temp_view_id);
   p_view_id=temp_view_id;
   status=_save_file('+o');
   if (status) {
      _message_box(nls("Could not save file %s\n\n%s",p_buf_name,get_message(status)));
   }else{
      p_view_id=orig_view_id;
      ResetModifyFlags();
   }
   p_view_id=orig_view_id;
   mou_hour_glass(0);
   return(status);
}

static boolean ClassIndexUsed(int ClassIndex)
{
   if (!ClassIndex) return true;
   if (SkipToFirstEntry()) return false;
   up();
   while (!down()) {
      get_line(line);
      parse line with id (ASCII1) type (ASCII1) LTableIndex (ASCII1) CurClassIndex (ASCII1).;
      if (CurClassIndex==ClassIndex) {
         return(true);
      }
   }
   return(false);
}
static boolean LInfoIndexUsed(int LTableIndex)
{
   linenum=p_line;
   status=SkipToFirstEntry();
   if (status) {
      return false;
   }
   up();
   while (!down()) {
      get_line(line);
      parse line with id (ASCII1) type (ASCII1) CurLTableIndex (ASCII1) ClassTableIndex (ASCII1).;
      if (LTableIndex==CurLTableIndex) {
         p_line=linenum;
         return(true);
      }
   }
   p_line=linenum;
   return(false);
}

static void DelItems(typeless (&Array)[],_str list)
{
   list=strip(list);
   for (i=0;;++i) {
      parse list with cur list;
      if (cur=='') break;
      Array._deleteel(cur-i);
   }
}

static void WriteClassNameTable(_str (&ClassTable)[],temp_view_id)
{
   orig_view_id=p_view_id;
   p_view_id=temp_view_id;

#if 0
   list='';
   //Need to do this before we wipe out the table
   for (i=0;i<ClassTable._length();++i) {
      if (!ClassIndexUsed(i)) {
         list=list' 'i;
      }
   }
   DelItems(ClassTable,list);
#endif

   markid=_alloc_selection();
   p_line=1;
   status=search('^\x2$','r@');//find the end of the table Language table
   down();
   _select_line(markid);
   status=search('^\x2$','r@');//find the end of the table ClassName table
   _select_line(markid);
   _delete_selection(markid);
   _free_selection(markid);
   up();
   for (i=0;i<ClassTable._length();++i) {
      insert_line(ClassTable[i]);
   }
   insert_line(ASCII2);
   p_view_id=orig_view_id;
}
static void WriteLanguageInfoTable(LANGUAGE_INFO_T LInfo[],int temp_view_id)
{
   orig_view_id=p_view_id;
   p_view_id=temp_view_id;
   markid=_alloc_selection();
#if 0

   //Need to do this before we wipe out the table
   list='';
   for (i=0;i<LInfo._length();++i) {
      if (!LInfoIndexUsed(i)) {
         list=list' 'i;
      }
   }
   DelItems(LInfo,list);
#endif
   top();
   _select_line(markid);
   status=search('^\x2$','r@');//Mark to the end of the table Language table
   _select_line(markid);
   _delete_selection(markid);
   _free_selection(markid);
   p_line=0;
   for (i=0;i<LInfo._length();++i) {
      insert_line(LInfo[i].LParen:+ASCII1:+LInfo[i].RParen:+ASCII1:+LInfo[i].Or:+ASCII1:+LInfo[i].Delim:+ASCII1);
   }
   insert_line(ASCII2);
   p_view_id=orig_view_id;
}

static void WriteFileDescription(_str Description,int temp_view_id)
{
   orig_view_id=p_view_id;
   p_view_id=temp_view_id;
   top();
   search('^\2$','r@>');
   search('^\2$','r@>');
   if (!down()){
      replace_line(Description);
   }else{
      insert_line(Description);
   }
   p_view_id=orig_view_id;
}

static boolean ReferenceExists(API_ENTRY_T Entries[],int index)
{
   for (i=0;i<Entries._length();++i) {
      if (Entries[i].LanguageTableIndex==index) {
         return(true);
      }
   }
   return(false);
}

static int GetLInfoTableIndex(_str Left,_str Right,_str Delim,_str Or)
{
   LANGUAGE_INFO_T Table[];
   Table=_ctldelim.p_user;
   for (i=0;i<Table._length();++i) {
      if (Left==Table[i].LParen && Right==Table[i].RParen && Or==Table[i].Or &&
          Delim==Table[i].Delim) {
         return(i);
      }
   }
   //Since This delim set was not found, create a new entry and return its index
   Table[i].LParen=Left;
   Table[i].RParen=Right;
   Table[i].Or=Or;
   Table[i].Delim=Delim;
   _ctldelim.p_user=Table;
   return(i);
}
static int CreateClassTableIndex(_str ClassName)
{
   _str Table[];
   Table=_ctlclass_name.p_user;
   for (i=0;i<Table._length();++i) {
      if (ClassName==Table[i]) {
         return(i);
      }
   }
   //Since This delim set was not found, create a new entry and return its index
   Table[i]=ClassName;
   _ctlclass_name.p_user=Table;
   return(i);
}

static void ShowFunction(...)
{
   added=arg(1)==1;
   deleted=arg(1)==2;
   wid=p_window_id;
   p_window_id=_ctlfunction_list.p_cb_list_box;
   API_ENTRY_T Entry,OldEntry;
   if (!p_Noflines) return;
   count=1;
   key=last_event();
   while (test_event('p'):==key && count<20) {
      ++count;get_event();
   }

   if (isinteger(_ctlpframe.p_user)) {
      if (SaveParameter()) {
         if (isinteger(_ctlreturn_type.p_user)) {
            p_line=_ctlreturn_type.p_user;
         }else{
            p_line=1;
         }
         _lbdeselect_all();
         _lbselect_line();
         return;
      }
   }
   OldEntry=_ctlfunction_list.p_user;
   if (OldEntry._varformat()==VF_ARRAY && (_ctlval_list.p_user==1||_ctlval_list.p_modify)
       && !deleted) {
      _ctlval_list.p_user=0;
      result=_message_box(nls("Do you wish to save the changes made to '%s'"
                              ,OldEntry.FunctionName)
                          ,'',MB_YESNO|MB_ICONQUESTION);
      if (result==IDYES) {
         OldEntry.LanguageTableIndex=GetLInfoTableIndex(strip(_ctlleft.p_text),
                                                        strip(_ctlright.p_text),
                                                        strip(_ctldelim.p_text),
                                                        strip(_ctlor.p_text));
         OldEntry.ClassTableIndex=CreateClassTableIndex(strip(_ctlclass_name.p_text));
         OldEntry.Type=_ctlreturn_type.p_text;
         if (!added) {
            index=_ctlreturn_type.p_user;
         }else{
            if (p_line>_ctlreturn_type.p_user) {
               index=_ctlreturn_type.p_user;
            }else{
               index=_ctlreturn_type.p_user+1;
            }
         }
         OldEntry.ExtendedInfo=GetExtendedInfoStr(ctldocumentation.p_user);
         WriteEntry(OldEntry,index,_ctldescription.p_user);
      }
   }
   if (!p_line) {
      _lbselect_line();
   }
   FunctionName=_lbget_text();
   Entry=GetEntry(p_line);
   _ctlfunction_list.p_user=Entry;
   _ctlleft.p_user=1;

   //This causes the delimiter fields to be initalized to whatever the first
   //entry in the table is.  It don't think that its a problem right now, so
   //I am going to leave it that way. 4:25pm 5/17/1996
   LANGUAGE_INFO_T LInfo[];
   LInfo=_ctldelim.p_user;
   _ctlleft.p_text=LInfo[(int)Entry.LanguageTableIndex].LParen;
   _ctlright.p_text=LInfo[(int)Entry.LanguageTableIndex].RParen;
   _ctlor.p_text=LInfo[(int)Entry.LanguageTableIndex].Or;
   _ctldelim.p_text=LInfo[(int)Entry.LanguageTableIndex].Delim;

   _ctlreturn_type.p_text=Entry.Type;
   _str ClassTable[];
   ClassTable=_ctlclass_name.p_user;
   _ctlclass_name.p_text=GetClassName(Entry.ClassTableIndex,ClassTable);
   _ctlpframe.p_user='';
   if (Entry.ParamList._length()) {
      _ctlpframe.disable_all_controls(1);//Enable
      _ctlpframe.p_user=0;
   }
   ShowParameter();
   _ctlleft.p_user=0;
   _ctlreturn_type.p_user=_ctlfunction_list.p_cb_list_box.p_line;
   p_window_id=wid;
}

void _ctlfunction_list.on_change(reason)
{
   switch (reason) {
   case CHANGE_CLINE:
   case CHANGE_OTHER:
      p_cb_list_box._lbselect_line();
      ShowFunction();
      break;
   }
}

static _str GetClassName(int Index,ClassTable)
{
   return(ClassTable[Index]);
}

void _ctlprev_param.lbutton_up()
{
   if (SaveParameter()) return;
   API_ENTRY_T Entry;
   Entry=_ctlfunction_list.p_user;
   if (p_name=='_ctlprev_param') {
      --_ctlpframe.p_user;
   }else{
      ++_ctlpframe.p_user;
   }
   EnableOrDisableButtons();
   ShowParameter();
}

void _ctlup.lbutton_up()
{
   if (SaveParameter()) return;
   API_ENTRY_T Entry;
   PARAM_T temp;

   Entry=_ctlfunction_list.p_user;
   index=_ctlpframe.p_user;
   if (p_name=='_ctlup') {
      offset=-1;
   }else{
      offset=1;
   }
   temp=Entry.ParamList[index+offset];
   Entry.ParamList[index+offset]=Entry.ParamList[index];
   Entry.ParamList[index]=temp;
   _ctlpframe.p_user+=offset;
   _ctlfunction_list.p_user=Entry;
   ShowParameter();
   EnableOrDisableButtons();
   SetModifyFlags();
}

static void EnableOrDisableButtons(...)
{
   oldwid=p_window_id;
   if (arg(1)!='') {
      p_window_id=arg(1);
   }
   API_ENTRY_T Entry;
   Entry=_ctlfunction_list.p_user;

   //We need to check both conditions because there may only be one parameter
   if (!_ctlpframe.p_user) {
      _ctlprev_param.p_enabled=0;
      _ctlup.p_enabled=0;
   }else{
      _ctlprev_param.p_enabled=1;
      _ctlup.p_enabled=1;
   }
   if (_ctlpframe.p_user>=Entry.ParamList._length()-1) {
      _ctlnext_param.p_enabled=0;
      _ctldown.p_enabled=0;
   }else{
      _ctlnext_param.p_enabled=1;
      _ctldown.p_enabled=1;
   }
   if (!_ctlfunction_list.p_cb_list_box.p_Noflines) {
      _ctldelete_entry.p_enabled=0;
      _ctltest.p_enabled=0;
      _ctledit_name.p_enabled=0;
   }else{
      _ctldelete_entry.p_enabled=1;
      _ctltest.p_enabled=1;
      _ctledit_name.p_enabled=1;
   }
   p_window_id=oldwid;
}

static void ShiftArrayUp(typeless (&a)[],int StartIndex)
{
   for (i=a._length()+1;i>=StartIndex;--i) {
      a[i+1]=a[i];
   }
}

static void InitParam(PARAM_T &Param)
{
   Param.ControlType='tb';
   Param.ParamType='';
   Param.Values._makeempty();
   Param.Comment='';
}

void _ctlinsert.lbutton_up()
{
   if (SaveParameter()) return;
   API_ENTRY_T Entry;
   Entry=_ctlfunction_list.p_user;
   if (Entry.ParamList._length()) {
      ShiftArrayUp(Entry.ParamList,_ctlpframe.p_user+1);
      index=_ctlpframe.p_user+1;
      InitParam(Entry.ParamList[index]);
      ++_ctlpframe.p_user;
   }else{
      InitParam(Entry.ParamList[0]);
      _ctlpframe.p_user=0;
   }
   _ctlfunction_list.p_user=Entry;
   _ctlpframe.disable_all_controls(1);//Enable
   ShowParameter();
   EnableOrDisableButtons();
   _ctlpname._set_focus();
   _ctlpname._end_line();
}

static void SetModifyFlags()
{
   _ctlval_list.p_user=1;//Modify flag for this entry
   _ctltest.p_user=1;    //Modify flag for this database
}

static void ResetModifyFlags()
{
   _ctlval_list.p_user=0;//Modify flag for this entry
   _ctlval_list.p_modify=0;
   _ctltest.p_user=0;    //Modify flag for this database
}

void _ctltest.lbutton_up()
{
   API_ENTRY_T Entry;
   SaveParameter();
   Entry=_ctlfunction_list.p_user;
   Entry.LanguageTableIndex=GetLInfoTableIndex(strip(_ctlleft.p_text),
                                               strip(_ctlright.p_text),
                                               strip(_ctldelim.p_text),
                                               strip(_ctlor.p_text));
   Entry.Type=_ctlreturn_type.p_text;
   ClassName=_ctlclass_name.p_text;
   Entry.ClassTableIndex=CreateClassTableIndex(ClassName);
   Entry.ExtendedInfo=GetExtendedInfoStr(ctldocumentation.p_user);
   WriteEntry(Entry,_ctlfunction_list.p_cb_list_box.p_line,_ctldescription.p_user);
   LANGUAGE_INFO_T LInfo[];
   LInfo=_ctldelim.p_user;
   WriteLanguageInfoTable(LInfo,_ctldescription.p_user);
   _str ClassTable[];
   ClassTable=_ctlclass_name.p_user;
   WriteClassNameTable(ClassTable,_ctldescription.p_user);
   orig_view_id=p_view_id;
   p_view_id=_ctldescription.p_user;
   FileName=p_buf_name;
   p_view_id=orig_view_id;
   ApiApprentice(FileName,_ctlfunction_list.p_cb_list_box._lbget_text(),ClassName,junk);
}

static int EntryExists(_str FunctionName)
{
   orig_view_id=p_view_id;
   p_view_id=_ctldescription.p_user;
   line='';
   p_line=0;
   status=SkipToFirstEntry();
   linefound=!search('^'FunctionName:+ASCII1,'@r');
   p_view_id=orig_view_id;
   return(linefound);
}

static int WriteEntry(API_ENTRY_T Entry,int Index,int ViewId)
{
   orig_view_id=p_view_id;
   line='';
   p_view_id=ViewId;
   line=Entry.FunctionName:+ASCII1:+Entry.Type:+ASCII1:+Entry.LanguageTableIndex:+ASCII1:+Entry.ClassTableIndex:+ASCII1;
   for (i=0;i<Entry.ParamList._length();++i) {
      line=line:+Entry.ParamList[i].ControlType:+Entry.ParamList[i].ParamType;
      for (j=0;j<Entry.ParamList[i].Values._length();++j) {
         line=line:+ASCII2:+Entry.ParamList[i].Values[j];
      }
      line=line:+ASCII3:+Entry.ParamList[i].Comment:+ASCII1;
   }
   if (last_char(line)!=ASCII1) {
      line=line:+ASCII1;
   }
   line=line:+Entry.ExtendedInfo;
   p_line=0;
   if (!SkipToFirstEntry()) {
      up();
      p_line+=Index;
      replace_line(line);
   }else{
      insert_line(line);
   }
   p_view_id=orig_view_id;
   return(0);
}

void _ctldelete.lbutton_up()
{
   result=_message_box(nls("Are you sure you wish to delete parameter #%s?",_ctlpframe.p_user+1)
                       ,'',MB_YESNOCANCEL|MB_ICONQUESTION);
   if (result!=IDYES) return;
   API_ENTRY_T Entry;
   Entry=_ctlfunction_list.p_user;
   Entry.ParamList._deleteel(_ctlpframe.p_user);
   --_ctlpframe.p_user;
   if (_ctlpframe.p_user<0) {
      if (Entry.ParamList._length()) {
         ++_ctlpframe.p_user;
      }else{
         _ctlpframe.p_user='';
      }
   }
   EnableOrDisableButtons();
   _ctlfunction_list.p_user=Entry;
   ShowParameter();
   _ctlval_list.p_user=0;//Modify flag for this entry
   _ctltest.p_user=1;    //Modify flag for this database
   _ctlval_list.p_modify=0;
}
static void AddFunctionToListBox(_str FunctionName,int newindex)
{
   wid=p_window_id;
   p_window_id=_ctlfunction_list.p_cb_list_box;
   p_line=newindex;
   _lbadd_item(FunctionName);
   _lbselect_line();
   p_window_id=wid;
}

static void AddFunction(_str FunctionName)
{
   if (pos(' ',FunctionName)) {
      /*We cannot use function names with spaces.  Although we could add them
        this way here, and then just strip the spaces when we index them, the
        indexed version will not have spaces, and will not be able to find
        the appropriate entry.  I have decided not to prompt the user, but to
        just go ahead and pull out the spaces*/
      FunctionName=stranslate(FunctionName,'',' ');
   }
   orig_view_id=p_view_id;
   p_view_id=_ctldescription.p_user;
   index=0;lbindex=0;
   FindNewEntryIndex(FunctionName,index,lbindex);
   p_line=index;
   insert_line(FunctionName:+ASCII1:+ASCII1:+0:+ASCII1:+0:+ASCII1);
   p_view_id=orig_view_id;
   wid=p_window_id;
   p_window_id=_ctlfunction_list.p_cb_list_box;
   p_line=lbindex;
   _lbadd_item(FunctionName);
   _lbdeselect_all();
   _lbselect_line();
   center_line();
   //call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'w');
   ShowFunction(1);
   p_window_id=wid;
   SetModifyFlags();
   p_active_form.disable_all_controls(1);
}

boolean IsValidApiFunctionName(_str FunctionName)
{
   if (FunctionName=='') {
      _message_box(nls("Function names may not be null"));
      return(true);
   }
   if (isnumber(substr(FunctionName,1,1))) {
      _message_box(nls("Function names may not be numbers"));
      return(true);
   }
   return(false);
}

void _ctladd.lbutton_up()
{
   _param1=result=arg(1);
   if (result=="") {
      result=show('-modal _textbox_form',
                'Enter New Function Name',
                0, //Flags
                '',//Width
                '',//Help item
                '',//Reserved
                '',//Retrieve Name
                '-e IsValidApiFunctionName New Function Name:'
                );
   }
   if (result!='') {
      FunctionName=_param1;
      AddFunction(FunctionName);
   }
   p_window_id=_ctlclass_name;
   _set_focus();
}

void _ctledit_name.lbutton_up()
{
   if (!_ctlfunction_list.p_cb_list_box.p_Noflines) {
      p_enabled=0;
      return;
   }
   FunctionName=_ctlfunction_list.p_cb_list_box._lbget_text();
   result=show('-modal _textbox_form',
               'Edit Existing Function Name',
               0, //Flags
               '',//Width
               '',//Help item
               '',//Reserved
               '',//Retrieve Name
               '-e IsValidApiFunctionName New Function Name:'FunctionName
               );
   if (result=='') return;
   NewFunctionName=_param1;
   if (pos(' ',NewFunctionName)) {
      /*We cannot use function names with spaces.  Although we could add them
        this way here, and then just strip the spaces when we index them, the
        indexed version will not have spaces, and will not be able to find
        the appropriate entry.  I have decided not to prompt the user, but to
        just go ahead and pull out the spaces*/
      NewFunctionName=stranslate(FunctionName,'',' ');
   }
   if (NewFunctionName==FunctionName) return;
   _ctltest.p_user=1;    //Modify flag for this database
   wid=p_window_id;
   p_window_id=_ctlfunction_list.p_cb_list_box;
   _lbdelete_item();
   linenum=p_line;
   orig_view_id=p_view_id;
   temp_view_id=_ctldescription.p_user
   p_view_id=temp_view_id;
   status=SkipToFirstEntry();
   p_line+=(linenum-1);
   get_line(line);
   _delete_line();
   index=0;lbindex=0;
   FindNewEntryIndex(NewFunctionName,index,lbindex);
   p_line=index;
   parse line with . (ASCII1) rest;
   line=NewFunctionName:+ASCII1:+rest;
   insert_line(line);
   p_view_id=orig_view_id;
   p_line=lbindex;
   _lbadd_item(NewFunctionName);
   _lbdeselect_all();
   _lbselect_line();
   API_ENTRY_T Entry;
   Entry=_ctlfunction_list.p_user;
   Entry.FunctionName=NewFunctionName;
   _ctlfunction_list.p_user=Entry;
   p_window_id=wid;
}

void _ctldelete_entry.lbutton_up()
{
   API_ENTRY_T Entry;
   Entry=_ctlfunction_list.p_user;
   result=_message_box(nls("Are you sure you wish to delete the function '%s'",Entry.FunctionName),
                       '',MB_YESNOCANCEL|MB_ICONQUESTION);
   if (result!=IDYES) {
      return;
   }
   wid=p_window_id;
   p_window_id=_ctlfunction_list.p_cb_list_box;
   linenum=p_line;
   _lbdelete_item();
   _lbselect_line();
   p_window_id=wid;
   orig_view_id=p_view_id;
   temp_view_id=_ctldescription.p_user
   p_view_id=temp_view_id;
   p_line=0;
   status=SkipToFirstEntry();
   p_line+=(linenum-1);
   _delete_line();
   p_view_id=orig_view_id;
   _ctlleft.p_user=1;
   ShowFunction(2);
   _ctlval_list.p_user=0;//Modify flag for this entry
   _ctltest.p_user=1;    //Modify flag for this database
   _ctlleft.p_user='';
}

//Disables current window id and all children
static void disable_all_controls()
{
   val=(arg(1)=='')?0:arg(1);
   //p_enabled=val;
   wid=p_window_id;
   while (p_child) {
      p_window_id=p_child;
      firstwid=p_window_id;
      for (;;) {
         p_window_id=p_next;
         p_enabled=val;
         if (p_window_id==firstwid) break;
      }
   }
   if (DatabaseOpen() && _ctlfunction_list.p_cb_list_box.p_Noflines) {
      _ctlinsert.p_enabled=1;
   }else{
      _ctlinsert.p_enabled=0;
   }
   if (!val) {
      _ctlpframe.p_caption='';
   }
   p_window_id=wid;
}

static boolean DatabaseOpen()
{
   parse p_active_form.p_caption with 'API Apprentice Database Editor - 'FileName;
   return(FileName!='');
}

static void ShowParameter()
{
   _ctlleft.p_user=1;
   wid=p_window_id;
   if (arg(1)!='') {
      p_window_id=arg(1);
   }
   API_ENTRY_T Entry;
   Entry=_ctlfunction_list.p_user;
   ParamNumber=_ctlpframe.p_user;
   if (ParamNumber=='') {
      ParamNumber=_ctlpframe.p_user=0;
      if (_ctlpframe.p_child.p_enabled) {
         _ctlpname.p_text='';
         _ctlpcomment.p_text='';
         _ctlval_list._lbclear();
         _ctlval_list.insert_line('');
         _ctlval_list.p_modify=0;
         _ctlpframe.disable_all_controls();
         _ctlinsert.p_enabled=1;
      }
      return;
   }
   EnableOrDisableButtons();
   if (_ctlpframe.p_caption!='Parameter 'ParamNumber+1) {
      _ctlpframe.p_caption='Parameter 'ParamNumber+1;
   }
   if (Entry.ParamList._length()) {
      switch (Entry.ParamList[ParamNumber].ControlType) {
      case 'cb':
         _ctlcb.p_value=1;
         _ctlval_label.p_caption='Initial &Values';
         break;
      case 'tb':
         _ctltb.p_value=1;
         _ctlval_label.p_caption='Initial &Value';
         break;
      case 'xb':
         _ctlxb.p_value=1;
         _ctlval_label.p_caption='Checkbox Names';
         break;
      case 'rb':
         _ctlrb.p_value=1;
         _ctlval_label.p_caption='RadioButton Names';
         break;
      }
   }
   _ctlval_list._lbclear();
   _ctlpname.p_text=Entry.ParamList[ParamNumber].ParamType;
   _ctlpcomment.p_text=stranslate(Entry.ParamList[ParamNumber].Comment,'\t',"\t");
   wid=p_window_id;
   p_window_id=_ctlval_list;

   //If there are Entries for the list box insert them, else insert a blank line
   len=Entry.ParamList[ParamNumber].Values._length();
   if (len) {
      for (i=0;i<len;++i) {
         insert_line(Entry.ParamList[ParamNumber].Values[i]);
      }
   }else{
      _ctlval_list.insert_line('');
   }
   top();
   p_window_id=wid;
   _ctlleft.p_user=0;
   _ctlval_list.p_modify=0;
}

static boolean ControlNamesAvailable()
{
   wid=p_window_id;
   p_window_id=_ctlval_list;
   p_line=0;
   //In this case, any nonwhitespace char could be a control name
   status=search('[~ \t]','r@');
   p_window_id=wid;
   return(!status);
}

static int SaveParameter()
{
   //The frame itself has to be enabled for the Insert button to work, so I just
   //pick one of the controls that gets disabled to avoid saving the parameter
   //if there are are actually none.
   if (_ctlpname.p_enabled) {
      API_ENTRY_T Entry;
      Entry=_ctlfunction_list.p_user;
      ParamNumber=_ctlpframe.p_user;
      ct=Entry.ParamList[ParamNumber].ControlType=GetControlType();
      if ((ct=='xb' || ct=='rb') && !ControlNamesAvailable()) {
         _message_box(nls("For Checkboxes and Radio Buttons, you must specify at least one control name."));
         _ctlval_list._set_focus();
         return(1);
      }
      Entry.ParamList[ParamNumber].ParamType=_ctlpname.p_text;
      Entry.ParamList[ParamNumber].Comment=stranslate(_ctlpcomment.p_text,"\t",'\t');
      wid=p_window_id;
      p_window_id=_ctlval_list;
      p_line=0;
      Entry.ParamList[ParamNumber].Values._makeempty();
      while (!down()) {
         get_line(line);
         Entry.ParamList[ParamNumber].Values[p_line-1]=line;
      }
      _ctlfunction_list.p_user=Entry;
      p_window_id=wid;
   }
   return(0);
}

static _str GetControlType()
{
   if (_ctlcb.p_value) {
      return('cb');
   }else if (_ctltb.p_value) {
      return('tb');
   }else if (_ctlxb.p_value) {
      return('xb');
   }else if (_ctlrb.p_value) {
      return('rb');
   }
   return('');
}

static _str BadCommandTable:[]={
   "prev-buffer"  => 1,
   "next-buffer"  => 1,
   "close-buffer" => 1,
   "close-window" => 1,
   "close-all"    => 1,
   "quit"         => 1,
   "pquit"        => 1,
   "quit-view"    => 1,
   }

#if 0
void _ctlval_list.\0-\31,\129-MBUTTON_UP()
{
   SetModifyFlags();//This is a modify flag
   lastevent=last_event();
   key_index=event2index(lastevent);
   root_keys_index=find_index('default-keys',EVENTTAB_TYPE);
   name_index=eventtab_index(root_keys_index,_ctlval_list.p_mode_eventtab,key_index);
   CommandName=name_name(name_index);
   if (BadCommandTable._indexin(CommandName)) {
      return;
   }
   if (name_index) {
      call_index(name_index);
   }
}

_clval_list.\32-\128()
{
   SetModifyFlags();
   keyin(last_event());
}
#endif

_ctldescription.on_destroy()
{
   if (_ctldescription.p_user!='') {
      _delete_temp_view(_ctldescription.p_user);
   }
}

_command api_editor() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_ICON|VSARG2_MARK|VSARG2_READ_ONLY|VSARG2_NOEXIT_SCROLL)
{
   show('-app _api_editor_form');
}

int SkipToFirstEntry()
{
   p_line=0;
   status=search('^\x2$','r@>');
   if (status) return status;
   status=search('^\x2$','r@');
   if (status) return status;
   status=down(2);
   return(status);
}

//Uses binary search to figure out where new items should go.
static int FindNewEntryIndex(_str FunctionName,.../*,int &NewIndex,int &NewLBIndex*/)
{
   FunctionName=upcase(FunctionName);
   top();up();
   status=SkipToFirstEntry();
   if (status) {
      arg(2)=p_line;
      arg(3)=1;
      return(-1);
   }
   lo=p_line;hi=p_Noflines;
   offset=lo-1;

   //First let's just look for it
   found=0;
   for (;;) {
      status=search('^'FunctionName:+ASCII1,'@r>');
      if (status) break;
      found=1;
   }
   if (found) {
      _message_box(nls("Found an existing copy of re '%s'",'^'FunctionName:+ASCII1));
      arg(2)=p_line;
      arg(3)=p_line-offset;
      return(0);
   }

   for (;;) {
      mid=(lo+hi)intdiv 2;
      p_line=mid;
      get_line(line);
      parse line with CurFunctionName (ASCII1) .;
      CurFunctionName=upcase(CurFunctionName);
      if (FunctionName>CurFunctionName) {
         lo=mid+1;
      }else{
         hi=mid-1;
      }
      if (CurFunctionName==FunctionName || (lo>hi)) break;
   }
   arg(2)=mid;
   arg(3)=mid-offset;
   if (CurFunctionName==FunctionName) return mid;
   arg(2)=hi;
   arg(3)=hi-offset;
   return(-1);
}

void _ctlval_list.ENTER()
{
   if (_ctltb.p_value) {
      _ctlcb.p_value=1;
   }
   split_insert_line();
}

void _ctlval_list.DEL()
{
   if (select_active()) {
      delete_selection();
   }else{
      linewrap_delete_char();
   }
   if (p_Noflines<2 && _ctlcb.p_value) {
      _ctltb.p_value=1;
   }
}

void _ctlval_list.BACKSPACE()
{
   if (select_active()) {
      delete_selection();
   }else{
      linewrap_rubout();
   }
   if (p_Noflines<2 && _ctlcb.p_value) {
      _ctltb.p_value=1;
   }
}

defeventtab _api_documentation_form

/* Hash table with indexes same as names in combo box (use the DOC_* constants*/
#define EXTENDED_INFO_TABLE ctldoc_type.p_user
#define IN_ON_CREATE ctlok.p_user
#define GLastIndex edit1.p_user

#define MULTI_LINE_DESCRIPTION "This field may span multiple lines"
#define MULTI_ONE_LINE_DESCRIPTION   "This field may have multiple entries, one per line"

static _str CaptionTable:[]={
   DOC_DESCRIPTION => MULTI_LINE_DESCRIPTION,
   DOC_DEPRECATED  => MULTI_LINE_DESCRIPTION,
   DOC_RETURNS     => MULTI_LINE_DESCRIPTION,
   DOC_EXCEPTION   => MULTI_ONE_LINE_DESCRIPTION,
   DOC_SINCE       => MULTI_LINE_DESCRIPTION,
   DOC_SEE         => MULTI_ONE_LINE_DESCRIPTION,
   DOC_AUTHOR      => MULTI_ONE_LINE_DESCRIPTION,
   DOC_LINK        => MULTI_ONE_LINE_DESCRIPTION
};

void ctlok.on_create()
{
   IN_ON_CREATE=1;
   EXTENDED_INFO_TABLE=arg(1);
   _str functionName=arg(2);
   wid=p_window_id;
   p_window_id=ctldoc_type.p_cb_list_box;
   _lbadd_item(DOC_DESCRIPTION);
   _lbadd_item(DOC_DEPRECATED);
   _lbadd_item(DOC_RETURNS);
   _lbadd_item(DOC_EXCEPTION);
   _lbadd_item(DOC_SINCE);
   _lbadd_item(DOC_SEE);
   _lbadd_item(DOC_AUTHOR);
   _lbadd_item(DOC_LINK);
   _lbsort();
   _lbtop();
   p_parent.p_text=_lbget_text();
   _lbdeselect_all();
   _lbselect_line();
   p_window_id=wid;
   p_active_form.p_caption='Documentation for 'functionName;
   IN_ON_CREATE=0;
   ctldoc_type.call_event(CHANGE_SELECTED,ctldoc_type,ON_CHANGE,'w');
}

static _str GetDocInfoFromEditorControl(_str index)
{
   _str text='';
   switch (index) {
   case DOC_DESCRIPTION:
   case DOC_DEPRECATED:
   case DOC_RETURNS:
   case DOC_SINCE:
      bottom();
      text=get_text(_nrseek(),0);
      text=stranslate(text,' ',p_newline);
      return(strip(text));
   case DOC_EXCEPTION:
   case DOC_SEE:
   case DOC_AUTHOR:
   case DOC_LINK:
      top();up();
      while (!down()) {
         get_line(line)
         if (text=='') {
            text=line;
         }else{
            text=text:+ASCII1:+line;
         }
      }
      return(text);
   }
   return('');
}

static void PutDocIntoFromEditorControl(_str index,_str text)
{
   switch (index) {
   case DOC_DESCRIPTION:
   case DOC_DEPRECATED:
   case DOC_RETURNS:
   case DOC_SINCE:
      _insert_text(text);
      break;
   case DOC_EXCEPTION:
   case DOC_SEE:
   case DOC_AUTHOR:
   case DOC_LINK:
      for (;;) {
         parse text with cur (ASCII1) text;
         if (cur=='') break;
         insert_line(cur);
      }
      break;
   }
   if (!p_Noflines) {
      insert_line('');
   }
}

void ctldoc_type.on_change(reason)
{
   if (IN_ON_CREATE==1) {
      return;
   }
   _str temp:[]=EXTENDED_INFO_TABLE;
   wid=p_window_id;
   _control edit1;
   p_window_id=edit1;
   if (GLastIndex!='') {
      temp:[GLastIndex]=GetDocInfoFromEditorControl(GLastIndex);
   }
   _lbclear();
   //_insert_text(temp:[ctldoc_type.p_text]);
   PutDocIntoFromEditorControl(ctldoc_type.p_text,temp:[ctldoc_type.p_text]);
   p_window_id=wid;
   edit1.top();edit1._begin_line();
   label1.p_caption=CaptionTable:[ctldoc_type.p_text];
   GLastIndex=ctldoc_type.p_text;
   EXTENDED_INFO_TABLE=temp;
}

void ctlok.lbutton_up()
{
   /*
   _delete_window won't take a complex return type, so we'll stuff it into _param1
   */
   ctldoc_type.call_event(CHANGE_SELECTED,ctldoc_type,ON_CHANGE,'w');
   _str temp:[]=EXTENDED_INFO_TABLE;
   p_active_form._delete_window(1);
   _param1=temp;
}
