/*
$VerboseHistory: bookmark.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:07:39a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 07:38a
 * Comment:
 * Removed extra leading space from bookmark dialog
 * list box.
 * This fixed problem where selection characters did not
 * work.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:32p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:43p
 * Comment:
 * Adding new 3.0 stuff
*/
/* @SLICK MA=3 74 3 , TABS=1 4 7 10 13 16 19 22 25 28 31 34 37 40 43 46 49 52 55 58 61 64 67 70 73 76 79 82 85 88 , WWS=1, IWT=0, ST=1, */
/*
  This module provides book marking capabilities.  A bookmark is used to
  remember a location in an active file and attach it to a user supplied
  name or number.

  The maximum number of bookmarks that can be active is dependant on the
  -sv option.  See slick help on invocation.

  bookmark.e last change date 08/14/92

  Changes to bookmark.e as released with 2.2:

   *  A replace option "-R" replaces an existing bookmark without prompting.
      Returns 0 if successful.  1 is returned if bookmark id given could
      not be replaced.
   *  A no menu option "-M" can be used with GOTO-BOOKMARK to prevent a popup
      menu but set a non-zero return code if the mark requested is not
      present.  It can also be used with SET-BOOKMARK to return a non-zero
      value if the bookmark is already set.
   *  Allow for up to unlimited length alpha-numeric bookmarks instead of just
      2 digit.  A user configurable variable "def_bm_max_id" is used to set
      the space reserved for the bookmark id in the bookmark display. Don't
      set this variable to less than a value of 5.
   *  Allow the option and bookmark id to be specified in any order.

  Fixes:

   *  Fix bookmark cancelled on goto bookmark greater then 5 characters

Author(s):  Tom Zartler, AMI, 215 544-0572
            J. Clark Maurer,  MicroEdge Inc.
*/

#include "slick.sh"

#define BEEP   0            /* Set to 1 if you want beep on error */
#define MAX_BMDATA_LINE_LEN 200


#define DATE '08/14/92'

int def_bm_max_id = 5;         /* Field width of bookmark id for display */
                    /* Must be at least 5. */
_str  def_bm_show_line;   // boolean string .  Turn off if you don't want
                          // line number  displayed.
static boolean gSetBMEnabled;


//static _str _bookmark_callback(reason,var result,key);
static _str _goto_bookmark_callback(reason,var result,key)
{
   if (reason==SL_ONINIT) {
      if (!_sellist.p_Noflines) {
         b4.p_enabled=0;
      }
      return ('');
   }
   // Initialize or change selected
   if (reason==SL_ONSELECT) {
      return ('');
   }
   if (reason==SL_ONDEFAULT) {  // Enter key
      // Only call for set book mark case
      bm_id=strip(_sellistcombo.p_text)
            // Don't allow ## option
            if (!isbm_valid(bm_id,1)) {
               p_window_id=_sellistcombo;
               _set_sel(1,length(p_text)+1);
               return ('');
            }
            result=bm_id;
      return (1);
   }
   if (reason==SL_ONUSERBUTTON) {
      orig_wid=p_window_id;
      switch (key) {
      case 4:  // Delete bookmark
         p_window_id=_sellist;
         line=_lbget_text();
         parse line with bm_id .;
         if ( bm_id == '' ) {
            return ('');
         }
         delete_bookmark(bm_id);
         _lbdelete_item();
         if (!p_line) {
            result='';
            return (1);
         } else {
            line=_lbget_text()
                 parse line with bm_id .
                 _sellistcombo.set_command bm_id,1 //,length(bm_id)+1
                 _lbselect_line();
         }
         return ('');
      }
   }
   return ('')
}
static _str _set_bookmark_callback(reason,var result,key)
{
   if (reason==SL_ONINIT) {
      ctlreplace._delete_window();
      ctlgoto.p_enabled=0;
      ctldelete.p_enabled=0;
      _sellistok.p_enabled=gSetBMEnabled;
      return ('');
   }
   // Initialize or change selected
   if (reason==SL_ONSELECT) {
      if (_sellistcombo.p_visible) {
         if (_sellist._lbisline_selected()) {
            ctldelete.p_enabled=1;
            ctlgoto.p_enabled=1;
         } else {
            ctldelete.p_enabled=0;
            ctlgoto.p_enabled=0;
         }
         parse _sellist._lbget_text() with bm_id rest;
         parse _sellistcombo.p_text with tbm_id rest;
         if (!stricmp(bm_id,tbm_id)) {
            _sellistok.p_caption="&Replace";
            //ctlgoto.p_enabled=1;

            if (_sellist._lbisline_selected()) {
               _sellistok.p_default=0;
               ctlgoto.p_default=1;
            }
            _sellistok.p_enabled=gSetBMEnabled;
         } else {
            _sellistok.p_default=1;
            ctlgoto.p_default=0;

            _sellistok.p_enabled=isbm_valid(tbm_id,true) && gSetBMEnabled;
            _sellistok.p_caption="&Add";
            //ctlgoto.p_enabled=0;
         }
         _sellistcombo.p_text=tbm_id;
         return ('');
      }
      return ('');
   }
   /*if (reason==SL_ONCHANGE) {

   } */
   if (reason==SL_ONDEFAULT) {  // Enter key
      if (ctlgoto.p_default) {
         reason=SL_ONUSERBUTTON;
         key=4;
      } else {
         // Only call for set book mark case
         bm_id=strip(_sellistcombo.p_text);
         // Don't allow ## option
         if (!isbm_valid(bm_id,1)) {
            p_window_id=_sellistcombo;
            _set_sel(1,length(p_text)+1);
            return ('');
         }
         result=bm_id;
         _param1=0;  // Set bookmark
         return (1);
      }
   }
   if (reason==SL_ONUSERBUTTON) {
      orig_wid=p_window_id;
      switch (key) {
      case 1:
         // Only call for set book mark case
         bm_id=strip(_sellistcombo.p_text);
         // Don't allow ## option
         if (!isbm_valid(bm_id,1)) {
            p_window_id=_sellistcombo;
            _set_sel(1,length(p_text)+1);
            return ('');
         }
         result=bm_id;
         _param1=0;  // Set bookmark
         return (1);
      case 4:
         line=_sellist._lbget_text();
         parse line with bm_id rest;
         result=bm_id;
         _param1=1;  // Go to bookmark
         return (1);
      case 5:  // Delete bookmark
         p_window_id=_sellist;
         line=_lbget_text();
         parse line with bm_id .;
         if (_sellistcombo.p_visible &&
             stricmp(bm_id,strip(_sellistcombo.p_text))) {
            _message_box(nls('This bookmark does not exist'))
            p_window_id=_sellistcombo;
            _set_sel(1,length(p_text)+1);_set_focus();
            return ('');
         }
         if ( bm_id == '' ) {
            return ''
         }
         delete_bookmark(bm_id);
         _lbdelete_item();
         if (!p_line) {
            if (_sellistcombo.p_visible) {
               //ctldelete.p_enabled=0;
               //ctlgoto.p_enabled=0;
               _set_bookmark_callback(SL_ONSELECT,result,-1);
               return ('');
            }
            result='';
            return (1);
         } else {
            line=_lbget_text()
                 parse line with bm_id .
                 _sellistcombo.set_command bm_id,1 //,length(bm_id)+1
                 _lbselect_line();
         }
         return ('');
      }
   }
   return ('')
}
int _restore_bookmark(_str filename)
{
   if (!(_default_option(VSOPTION_APIFLAGS) & 
         (VSAPIFLAG_MDI_WINDOW|VSAPIFLAG_GOTO_BOOKMARK_RESTORES_BY_FILENAME))) {
      return (1);
   }
   if (filename!='') {
      status=edit('+q 'maybe_quote_filename(filename));
      if (status) {
         if (status==NEW_FILE_RC) {
            quit();
            status=FILE_NOT_FOUND_RC;
         }
         if (status==FILE_NOT_FOUND_RC) {
            _message_box(nls("File %s not found",filename));
            return (status);
         }
         _message_box(nls("Error openning %s.  ",filename):+get_message(status));
         return (status);
      }
      _BookmarkRestore();
   }
   return (0);
}
/*
    This command no longer support + and - options.
*/
_command goto_bookmark, gb(...) name_info(','VSARG2_EDITORCTL)
{
   _macro_delete_line()
   was_recording=_macro();
   status = 1;
   old_buffer_name="";
   if (_isEditorCtl()) {
      old_buffer_name=(p_DocumentName!="")?p_DocumentName:p_buf_name;
   }
   // old subtitle nls("Enter=Select Esc=Cancel '='=Prompt ")
   bm_data = display_bookmarks(
                              nls('Go to Bookmark'),'goto_bookmark',
                              0, arg(1),
                              false
                              );
   if ( bm_data != '' ) {  /* a valid bookmark was selected */
      switch_buffer(old_buffer_name);
      parse bm_data with bm_id mark_id .;
      status=_BookmarkGetInfo(_BookmarkFind(bm_id),
                              bm_id,mark_id,vsbmflags,buf_id,
                              0,RealLineNumber,col,BeginLineROffset,
                              LineData,filename,DocumentName
                             );
      if (status==TEXT_NOT_SELECTED_RC) {
         status=_restore_bookmark(filename);
         if (status) {
            return (status);
         }
      }
      begin_select(mark_id);
      if (p_window_state=='I') {
         p_window_state='N';
      }
      message(nls('At Bookmark %s',bm_id));
      status = 0
               _macro('m',was_recording);
      _macro_call('goto_bookmark', bm_id);
   } else if (arg(1)=='+' || arg(1)=='-' ) {
      message(nls('No bookmark available to goto.'));
   }
   return (status);
}
_command set_bookmark,sb(...) name_info(','VSARG2_EDITORCTL)
{
   _macro_delete_line()
   was_recording=_macro();
   status = 1;
   //old subtitle nls("Enter=Replace Esc=Cancel '='=prompt  0-9,A-Z=Rep/Create"),
   //old_buffer_name=p_buf_name;
   bm_data=display_bookmarks(nls('Bookmarks'),'set_bookmark',
                             1,arg(1),dialogResultGoTo);
   /**************************************************************************
   * The status of bm_data on return from display_bookmarks:                 *
   *  a. If esc was pressed nothing is returned.                             *
   *  b. If the bookmark selected is not in use only the bm_id is returned.  *
   *  c. If the bookmark is already in use the bm_id and the mark_id         *
   *     reference in the .bookmark buffer are returned.                     *
   *  Note: The bm_id is the alpha-numeric name selected for the bookmark.   *
   *        The mark_id is the mark id assigned by Slick.                    *
   **************************************************************************/
   parse bm_data with bm_id mark_id line_ref cmd_option;
   if (dialogResultGoTo) {
      _macro('m',was_recording);
      return (goto_bookmark(bm_id));
#if 0
      switch_buffer(old_buffer_name);
      begin_select(mark_id);
      message(nls('At Bookmark %s',bm_id));
      status= 0;
      _macro('m',was_recording);
      _macro_call('goto_bookmark', bm_id);
      return (0);
#endif
   }
   if ( bm_id != '' && ! (mark_id != '' && cmd_option :== '-M') ) {
      /* allow a new bm, or a current bm if quiet mode is off, to be set */
      //if (mark_id=="") mark_id = _alloc_selection('B');
      
      delete_bookmark(bm_id);
      mark_id = _alloc_selection('B');
      _BookmarkAdd(bm_id,mark_id);
      _deselect(mark_id);
      _select_char(mark_id);
      message(nls('Bookmark %s set',bm_id));
      _macro('m',was_recording);
      _macro_call('set_bookmark', '-r 'bm_id);
      status=0;
   } else if ( cmd_option :== '-M' ) {
      message(nls('Bookmark %s is already set',bm_id));
   }
   return (status)

}
/*
_command int toggle_bookmark() name_info(','VSARG2_READ_ONLY|VSARG2_EDITORCTL)
{
  status = set_bookmark('#');
  return(status)
}
*/

_command next_bookmark,nb(_str direction='+') name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   orig_buf_id=p_buf_id;
   orig_col=p_col;
   parse point() with orig_BeginLineROffset .;
   struct BMINFO {
      long BeginLineROffset;
      int col;
      _str BookmarkName;

      long low_BeginLineROffset;
      int low_col;
      _str low_BookmarkName;
   };
   BMINFO hashtab:[];
   BMINFO found;
   found.BookmarkName="";
   // See if there is a bookmark after/before this one in this buffer
   for (i=0;i<_BookmarkQCount();++i) {
      _BookmarkGetInfo(i,BookmarkName,markid,vsbmflags,
                       buf_id,
                       0,RealLineNumber,col,BeginLineROffset,LineData,
                       filename,DocumentName);
      if (!(vsbmflags & VSBMFLAG_STANDARD)) {
         continue;
      }
      if (hashtab._indexin(buf_id)) {
         BMINFO bminfo;
         bminfo=hashtab:[buf_id];
         if (bminfo.BeginLineROffset<BeginLineROffset ||
             (bminfo.BeginLineROffset==BeginLineROffset && bminfo.col<col)
             ) {
            hashtab:[buf_id].BeginLineROffset=BeginLineROffset;
            hashtab:[buf_id].col=col;
            hashtab:[buf_id].BookmarkName=BookmarkName;
         }
         if (bminfo.low_BeginLineROffset>BeginLineROffset ||
             (bminfo.low_BeginLineROffset==BeginLineROffset && bminfo.low_col>col)
             ) {
            hashtab:[buf_id].low_BeginLineROffset=BeginLineROffset;
            hashtab:[buf_id].low_col=col;
            hashtab:[buf_id].low_BookmarkName=BookmarkName;
         }
      } else {
         hashtab:[buf_id].BeginLineROffset=BeginLineROffset;
         hashtab:[buf_id].col=col;
         hashtab:[buf_id].BookmarkName=BookmarkName;

         hashtab:[buf_id].low_BeginLineROffset=BeginLineROffset;
         hashtab:[buf_id].low_col=col;
         hashtab:[buf_id].low_BookmarkName=BookmarkName;

      }
      if (buf_id==orig_buf_id) {
         if (direction=='+') {
            if (BeginLineROffset>orig_BeginLineROffset ||
                (BeginLineROffset==orig_BeginLineROffset && col>orig_col)
                ) {
               if (found.BookmarkName=="" ||
                   (
                    BeginLineROffset<found.BeginLineROffset ||
                    (BeginLineROffset==found.BeginLineROffset && col<found.col)
                   )

                  ) {
                  found.BeginLineROffset=BeginLineROffset;
                  found.col=col;
                  found.BookmarkName=BookmarkName;
               }
               //messageNwait('found 'BookmarkName' 'BeginLineROffset' 'orig_BeginLineROffset);
            }
         } else {
            if (
                BeginLineROffset<orig_BeginLineROffset ||
                (BeginLineROffset==orig_BeginLineROffset && col<orig_col)

                ) {
               //messageNwait('col='col' 'orig_col);
               if (found.BookmarkName=="" ||
                   (
                    BeginLineROffset>found.BeginLineROffset ||
                    (BeginLineROffset==found.BeginLineROffset && col>found.col)
                   )

                  ) {
                  //message('another');
                  found.BeginLineROffset=BeginLineROffset;
                  found.col=col;
                  found.BookmarkName=BookmarkName;
               }
            }
         }
      }
   }
   BookmarkName=found.BookmarkName;
   if (BookmarkName=="") {
      BookmarkName="";
      for (;;) {
         _next_buffer('rh');
         if (hashtab._indexin(p_buf_id)) {
            break;
         }
         if (p_buf_id==orig_buf_id) {
            break;
         }
      }
      if (hashtab._indexin(p_buf_id)) {
         buf_id=p_buf_id;
         if (direction=='+') {
            BookmarkName=hashtab:[buf_id].low_BookmarkName;
         } else {
            BookmarkName=hashtab:[buf_id].BookmarkName;
         }
#if 0
         if (buf_id==orig_buf_id) {
         } else {
            if (direction=='+') {
               BookmarkName=hashtab:[buf_id].low_BookmarkName;
            } else {
               BookmarkName=hashtab:[buf_id].BookmarkName;
            }
         }
#endif
      } 
      p_buf_id=orig_buf_id;
   }
   if (BookmarkName=="") {
      // No next/prev bookmark
      return(1);
   }
   status= goto_bookmark(BookmarkName);
   return(status)

}
_command prev_bookmark,pb() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   status = next_bookmark('-');
   return (status)

}
_command void alt_bookmark() name_info(','VSARG2_LASTKEY|VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{

   parse event2name(last_event()) with '-' id '-' id2
   if (id2!='') {
      id=id2;
   }
   _macro('m',_macro());
   status=set_bookmark('-r 'id);
   /*Macro Record Stuff in set_bookmark*/
}
_command void alt_gtbookmark() name_info(','VSARG2_LASTKEY|VSARG2_EDITORCTL)
{
   parse event2name(last_event()) with '-' id '-' id2
   if (id2!='') {
      id=id2;
   }
   _macro('m',_macro())
   status=goto_bookmark(id);
   /*Macro Record Stuff in set_bookmark*/
}

/****************************************************************************
   NOTES:
   1. If called from set_bookmark arg(3) = 1 to allow a selection not active
      in the menu. If called from goto_bookmark arg(3) = 0.
   2. The bookmark id, if present, is passed as arg(4). If it is present
      select one of the conditions below.
    a. If not alphanumeric and not '#', '##', '+' or '-' present the
       bookmark menu.
    b. If called from goto-bookmark:
       1. If the id is '+' or '-' return bm_data for next or prev bookmark
       2. If the id is active return the bm_data.
       3. If the id is not active present the bookmark menu.
          If no menu mode (-m), don't present menu.
    c. If called from set-bookmark:
       1. If the id is '#' or '##' set the next available bookmark.
       2. If the id is active present the bookmark menu with the id selected.
          If replace option (-r), replace without prompting.
          If no menu option (-m), don't replace and return non-zero RC.
       3. If the id is inactive return null bm_data.
   3. Delete inactive bookmark entries and free the associated marks.
   4. Check for a buffer name change while building menu buffer. If a
      change has occurred update the .bookmark buffer.
****************************************************************************/
static _str display_bookmarks(_str title,_str retrieve_name,int doSetBM,_str cmdline,boolean &dialogResultGoTo=0)
{
   dialogResultGoTo=false;
   if ( doSetBM == 0 ) {
      goto_bm = 1; set_bm = 0;
   } else {
      goto_bm = 0; set_bm = 1;
      gSetBMEnabled=_isEditorCtl();
   }
   _str cmd_option='';
   parse cmdline with option bm_name .;
   if ( bm_name != '' ) {  /* a bookmark and command option are entered */
      /* expect the option to be first but, if it's not, swap them around */
      if ( pos('-r|-m', option, 1, 'RI')  == 1 ) {  /* option is first */
         cmd_option = upcase(option);
      } else if ( pos('-r|-m', bm_name, 1, 'RI') == 1 ) {  /* option second */
         cmd_option = upcase(bm_name);
         bm_name = option;
      }
   } else {
      bm_name = option;
   }
   bm_err=!isbm_valid(bm_name, set_bm);
   get_view_id view_id    /* remember user's view */
   bm_data=''; max_buf_name_len = 0;
   val_bm1='0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
   active_bm1='';active_bm2='';
   cancel=0;
   for (;;) {
      junk=_create_temp_view(temp_view_id);
      if (junk=='') {
         // Error message already display
         return ('');
      }
      _delete_line();
#if 0
      if ( rc ) {
         message nls('.bookmark buffer not present.')
         return (1)
      }
#endif
      if ( p_line > 0 ) {
         status = sort_buffer('D'); /* sort buffer decending by buffer name length */
      }
      width=76;

      int count=_BookmarkQCount();
      for (i=0;i<count;++i) {
         status=_BookmarkGetInfo(i,bm_id,mark_id,flags,buf_id,0,
                                 RealLineNumber,col,
                                 BeginLineROffset,
                                 LineData,
                                 Filename,
                                 DocumentName
                                );
         //messageNwait('L='RealLineNumber' O='BeginLineROffset);
         if (!(flags &VSBMFLAG_STANDARD)) {
            continue;
         }
         bm=bm_id;
         if (DocumentName!="") {
            Filename=DocumentName;
         }
         buf_name=_build_buf_name2(Filename,buf_id);
         buf_name_len=length(buf_name);
         if ( length(bm) == 1 ) {  /* make lists for auto-bookmark */
            active_bm1 = active_bm1:+bm;
         } else if (length(bm)==2) {
            active_bm2 = active_bm2:+bm;
         }
         if ( max_buf_name_len == 0 ) {
            max_buf_name_len = buf_name_len +1;
         }
         /*if ( buf_name_len != length(buf_name) ) {  /* buffer name len change? */
           //messageNwait('replacing 'buf_name' with ' cur_buf_name'..')
         tline=right_justify(length(buf_name),4) " "bm_id " "mark_id " "bm_line;
         replace_line trunc_line(tline)
       }*/

         /* Find the bmark line number dynamically because editing can move it */
         bm_loc=RealLineNumber;
         if (RealLineNumber<0) {
            bm_loc='---';
         }
         bm_loc= right_justify(bm_loc, 5);

         tline=field(bm_id, def_bm_max_id + 4):+
               right_justify(buf_name,max_buf_name_len):+
               bm_loc' 'LineData;
         _lbadd_item(trunc_line(tline))
         if ( !stricmp(bm_id,bm_name)) {  /* a match occured on selected bookmark */
            bm_data = bm_id' 'mark_id' .  'cmd_option;
            if ( cmd_option :== '-R' ) {
               break;  /* the mark set will automatically be replaced */
            }
         }
      }

      status = sort_buffer('I');
      clear_message();
      if ( set_bm && pos(bm_name, '##') ) { /* auto mark */
         a = verify(val_bm1, active_bm1);
         if ( bm_name :== '#' && a > 0 ) {  /* found an unused single digit bm */
            bm_name = substr(val_bm1, a, 1);
         } else {
            for (hi=1; hi<=10 ; ++hi ) {
               for (lo=1; lo<=10 ; ++lo ) {
                  bm = substr(val_bm1, hi, 1):+substr(val_bm1, lo, 1);
                  b = 1;
                  for (;;) {
                     a = pos(bm, active_bm2, b);
                     if ( a ) {
                        if ( a % 2 == 0 ) {  /* even address - not a real bookmark */
                           b = a + 1;
                           continue;
                        } else {
                           break;
                        }
                     } else {
                        bm_name = bm; lo = 10; hi = 10;
                        break;
                     }
                  }
               }
            }
         }
      }
      finished = 1;
      if ( set_bm && ! bm_err && bm_data:=='' ) {  /* bm not set yet */
         bm_data =bm_name;
      } else if ( set_bm && pos(cmd_option,'-M -R') ) {
         /* bm set and quiet/rep */
         
      } else if ( goto_bm && bm_data :!= '' ) {
         /* bm requested found */
         /* just return */
         
      } else if ( goto_bm && cmd_option :== '-M' ) {  /* no bm and quiet option */
         message nls('bookmark %s not active.',bm_name);
         /* bypass menu and return */
      } else if ( title :== ''  ) {                   /* auto-save function running */
         /* just bypass menu and return */
         
      } else {
         /* present the bookmark menu */
         finished = 0;
         beep_error = 0;
         if ( _on_line0() ) {
            
         } else if ( bm_name :!= '' ) {
            /* pos to selected bm being replaced if set_bm */
            search('^ +:i +'_escape_re_chars(bm_name),'ri');
            if ( rc ) {
               clear_message();
            }
         }
         beep_error=1;
         if ( set_bm && pos(bm_name, '##') ) {  /* auto bookmark being set */
            bm_name = ''; top();
            message(nls('All bookmarks are in use.'));
         } else if ( bm_name :!= '' ) {
            if ( bm_err ) {
               message nls("Bookmark '%s' is not valid.",bm_name);
            } else if ( goto_bm ) {
               message nls('Bookmark %s is not active',bm_name);
            } else if ( set_bm && cmd_option :!= '-R' ) {
               message nls('Bookmark %s is already active',bm_name);
            } else {
               beep_error = 0;
            }
         }
         if (BEEP && beep_error ) {
            /* send bell char to std out */
            _beep();
         }
         height=p_Noflines;
         if ( height > 10 ) {
            height=10;
         }
         if ( height < 3 ) {
            height=3;
         }
         p_modify=0;
         height = '=':+height; /* leave cursor on active bm if set-bookmark */

         if (set_bm) {
            buttons="&Add,&Go To:ctlgoto,&Delete:ctldelete,&Replace:ctlreplace";
            extra_flags=SL_COMBO|SL_DEFAULTCALLBACK|SL_CLOSEBUTTON|SL_SELECTPREFIXMATCH;
         } else {
            buttons="&Go to Bookmark, &Delete";
            extra_flags=SL_SELECTCLINE|SL_CLOSEBUTTON;
         }
         Noflines=p_Noflines;
         activate_view view_id;
         if (!set_bm && !Noflines) {
            bm_data = '';
            _message_box('No bookmarks set');
            _delete_temp_view(temp_view_id);
            break
         }
         // Completion should be added for bookmarks
         if (retrieve_name=='set_bookmark') {
            help_item='Bookmarks dialog box';
            callback=_set_bookmark_callback;
         } else {
            help_item='Go to Bookmark dialog box';
            callback=_goto_bookmark_callback;
         }
         orig_wid=p_window_id;
         wid=show('_sellist_form -hidden',
                  title,
                  extra_flags|SL_VIEWID,
                  temp_view_id,
                  buttons,
                  help_item,             // help item name
                  '',                    // font
                  callback,  // Call back function
                  '',              // Item separator for list_data
                  retrieve_name,       // Retrieve form name
                  ''               // Combo box. Completion property value.
                 );
         if (wid<0) {
            result='';
         } else {
            p_window_id=wid;
            if (set_bm) {
               parse bm_data with bm_id .;
               if (bm_id!='') {
                  _sellistcombo.p_text=bm_id;
                  _sellistcombo._set_sel(1,length(bm_id)+1)
                  _sellist.line_to_bottom();
                  ctlgoto.p_default=0;
                  _sellistok.p_default=1;
               }
            }
            p_visible=1;  /* Make the form visible. */
            result=_modal_wait(wid);
            p_window_id=orig_wid;
            parse result with result .;
            if (result!='') {
               dialogResultGoTo=_param1;
            }
         }
         selected_bm=result;
         cancel= result=='';
         //selected_bm = upcase(selected_bm)
         if ( cancel) {
            bm_data = '';
            // Don't need this message here.
            //message get_message(COMMAND_CANCELLED_RC)
            break;
         } else {
            i=_BookmarkFind(selected_bm);
            if ( i>=0) { /* found bookmark */
               _BookmarkGetInfo(i,selected_bm,mark_id);
               bm_data = selected_bm' 'mark_id' .';
               break;
            } else {
               bm_data = '';
            }
         }
      }
      if ( finished ) {
         _delete_temp_view(temp_view_id);
         break;
      }
      bm_data = '';
      bm_name = selected_bm;
      bm_err = !isbm_valid(bm_name, set_bm);
   }
   // IMPORTANT: Only restore view if user has not selected to edit/cancel the form
   if (!cancel) {
      activate_view view_id;      /* restore user's view */
   }
   return (bm_data)
}
static _str right_justify(string,width)
{
   if ( length(string)>=width ) {
      return (' 'string)
   }
   return (substr('',1,width-length(string))string);
}
void _document_renamed_bookmark(int buf_id,_str old_bufname,_str new_bufname,int buf_flags)
{
   _BookmarkRestore();
}
void _buffer_renamed_bookmark(int buf_id,_str old_bufname,_str new_bufname,int buf_flags)
{
   _BookmarkRestore();
}
void _buffer_add_bookmark()
{
   _BookmarkRestore();
   //messageNwait('got here p_buf_name='p_buf_name)
}
/*
void _restore_all_bookmarks()
{
   orig_view_id=_create_temp_view(temp_view_id);
   temp_buf_id=p_buf_id;
   boolean hashtab:[];
   for (i=0;i<_BookmarkQCount();++i) {
      _BookmarkGetInfo(i,BookmarkName,markid,vsbmflags,
                       bufid,
                       0,RealLineNumber,col,BeginLineROffset,LineData,
                       filename,DocumentName);
      if (!(vsbmflags & VSBMFLAG_STANDARD)) {
         continue;
      }
      if (upcase(_fpos_case)=='I') {
         filename=lowcase(filename);
      }
      if (hashtab._indexin(filename)) {
         continue;
      }
      hashtab:[filename]=true;
      status=load_files("+q +b "filename);
      if (!status) {
         _BookmarkRestore();
         p_buf_id=temp_buf_id;
      }
   }
   _delete_temp_view(temp_view_id);
   activate_view(orig_view_id);
}
*/

_str _srg_bookmark2()
{
   if ( arg(1)=='R' || arg(1)=='N' ) {
      parse arg(2) with Nofbookmarks .;
      for (i=1; i<=Nofbookmarks ; ++i) {
         down();
         get_line(line);
         parse line with BookmarkName \1 vsbmflags \1 RealLineNumber \1 col \1 BeginLineROffset \1 LineData \1 Filename \1 DocumentName;
         markid=_alloc_selection('b');
         _BookmarkAdd(BookmarkName,markid,vsbmflags,RealLineNumber,col,
                      BeginLineROffset,LineData,Filename,DocumentName);
      }
   } else {
      insert_line("");
      orig_line=p_line;
      Nofbookmarks=0;
      for (i=0;i<_BookmarkQCount();++i) {
         _BookmarkGetInfo(i,BookmarkName,markid,vsbmflags,
                          bufid,
                          0,RealLineNumber,col,BeginLineROffset,LineData,
                          Filename,DocumentName);
         if (!(vsbmflags & VSBMFLAG_STANDARD)) {
            continue;
         }
         ++Nofbookmarks;
         LineData=stranslate(LineData,"",\1);
         LineData=stranslate(LineData,"","\n");
         insert_line(BookmarkName \1 vsbmflags \1 RealLineNumber \1 col \1 BeginLineROffset \1 LineData \1 Filename \1 DocumentName);
      }
      orig_line2=p_line;
      p_line=orig_line;
      replace_line("BOOKMARK2: "Nofbookmarks);
      p_line=orig_line2;

      //get_line(line);
      //_message_box(line);
   }
   return (0)

}

static _str trunc_line(line)
{
   if ( length(line)>MAX_LINE ) {
      line=substr(line,1,MAX_LINE);
   }
   return (line);
}
static boolean isbm_valid(_str bm,boolean set_bm)
{
   status=0;
   if ( set_bm && pos(bm, '##') ) {
      status=1;
   } else if ( length(bm) == 1 && isalnum(bm) ) {
      status=1;
   } else if ( strip(bm) :!= '' ) {
      /* allow all alphanumerics and some special chars.*/
      if (bm=='+' || bm=='-') {
         return (0);
      }
      if ( pos('[~A-Za-z0-9_$\-+=@!<>]',bm,1,'r') ) {
         return (status);
      }
      status=1;
   }
   return (status);
}
int delete_bookmark(_str bm_id,int vsbmflags=VSBMFLAG_STANDARD)
{
   i=_BookmarkFind(bm_id,vsbmflags);
   if ( i>=0) { /* found bookmark */
      _BookmarkRemove(i);
      return (0);
   }
   return (1);
}
