#ifndef BREAKPT_H
#define BREAKPT_H
extern "C" {

   /*
     Known limitations in our debug display.
     
        *  When a buffer gets its first debug bitmap displayed,
           pressing undo can either prevent all debug bitmaps
           from being displayed or display debug bitmaps in
           the wrong place.  The is because we let the user
           undo old line number information past the point of 
           entering debug mode.  We could throw away undo
           information when a buffer enters debug mode but
           we think this creates a worse problem.
   */
   /*
       NOTE:   You might want to do your own checking on
       file dates when the users sets break points because
       the debugging info may be out-of-date.
   */

   #define VSBPFLAG_BREAKPOINT        0x00000001    /* Break point on this line*/
   #define VSBPFLAG_EXEC              0x00000002    /* Line about to be executed. */
   #define VSBPFLAG_STACKEXEC         0x00000004    /* Call Stack execution line */
   #define VSBPFLAG_BREAKPOINTDISABLED   0x00000008 /* Break point disabled*/
   
   #define MAXDEBUGBITMAPS  256

   int VSAPI vsBPMSet(int wid,int flags,int mask,int autoadd=1);
   int VSAPI vsBPMSetBL(const char *pszBufName,int RealLineNum,int flags,int mask,int autoadd);
   int VSAPI vsBPMQFlags(int wid);
   void VSAPI vsBPMSetAll(int flags,int mask);
   void VSAPI vsBPMSetPicture(int flags,int index);
   int VSAPI vsBPMQPicture(int flags);
   void VSAPI vsBPMStartDebugMode();  // Start debug mode for all MDI edit buffers
   void VSAPI vsBPMStartDebugModeFor(int wid);   // Start debug mode for a specific editor control
   void VSAPI vsBPMEndDebugMode();  // Frees all editor debug data and removes bitmap display
   void VSAPI vsBPMEndDebugModeFor(int wid);  // Updates old line numbers
   void VSAPI vsBPMEndDebugModeForB(const char *pszBufName); // Updates old line numbers
   void VSAPI vsBPMSetAllFor(int wid,int flags,int mask);
   void VSAPI vsBPMSetAllForB(const char *pszBufName,int flags,int mask);
   int VSAPI vsBPMEnumerate(int wid,int i,int *pFlags,int *pRealLineNum,void *pReserved=0);
   int VSAPI vsBPMEnumerateB(const char *pszBufName,int i,int *pFlags,int *pRealLineNum,void *pReserved=0);
   int VSAPI vsBPMQDefaultPicture(int wid,int RealLineNum,int OldLineNum,int reserved=0);


   inline int VSAPI vsBPMSetBreakPoint(int wid) {return(vsBPMSet(wid,VSBPFLAG_BREAKPOINT,VSBPFLAG_BREAKPOINT));}
   inline int VSAPI vsBPMSetBreakPointBL(const char *pszBufName,int RealLineNum) {return(vsBPMSetBL(pszBufName,RealLineNum,VSBPFLAG_BREAKPOINT,VSBPFLAG_BREAKPOINT|VSBPFLAG_BREAKPOINTDISABLED,1));}
   inline void VSAPI vsBPMRemoveBreakPoint(int wid) {vsBPMSet(wid,0,VSBPFLAG_BREAKPOINT|VSBPFLAG_BREAKPOINTDISABLED,0);}
   inline void VSAPI vsBPMRemoveBreakPointBL(const char *pszBufName,int RealLineNum) {vsBPMSetBL(pszBufName,RealLineNum,0,VSBPFLAG_BREAKPOINT|VSBPFLAG_BREAKPOINTDISABLED,0);};
   inline int VSAPI vsBPMDisableBreakPoint(int wid) {return(vsBPMSet(wid,VSBPFLAG_BREAKPOINTDISABLED,VSBPFLAG_BREAKPOINT|VSBPFLAG_BREAKPOINTDISABLED,1));};
   inline int VSAPI vsBPMDisableBreakPointBL(const char *pszBufName,int RealLineNum) {return(vsBPMSetBL(pszBufName,RealLineNum,VSBPFLAG_BREAKPOINTDISABLED,VSBPFLAG_BREAKPOINT|VSBPFLAG_BREAKPOINTDISABLED,1));};
   inline int VSAPI vsBPMRemoveDisableBreakPoint(int wid) {return(vsBPMSet(wid,0,VSBPFLAG_BREAKPOINTDISABLED,0));};
   inline int VSAPI vsBPMRemoveDisableBreakPointBL(const char *pszBufName,int RealLineNum) {return(vsBPMSetBL(pszBufName,RealLineNum,0,VSBPFLAG_BREAKPOINTDISABLED,0));};

   inline int VSAPI vsBPMToggleBreakPoint(int wid) {
      int status;
      if (vsBPMQFlags(wid) & VSBPFLAG_BREAKPOINT) {
         status=vsBPMSet(wid,0,VSBPFLAG_BREAKPOINT,0);
         //status=vsBPMRemoveBreakPoint(wid);
      } else {
         status=vsBPMSetBreakPoint(wid);
      }
      return(status);
   }

   inline int VSAPI vsBPMSetExecLineBL(const char *pszBufName,int RealLineNum) {return(vsBPMSetBL(pszBufName,RealLineNum,VSBPFLAG_EXEC,VSBPFLAG_EXEC,1));};
   inline int VSAPI vsBPMSetExecLine(int wid) {return(vsBPMSet(wid,VSBPFLAG_EXEC,VSBPFLAG_EXEC,1));};
   inline void VSAPI vsBPMRemoveExecLineBL(const char *pszBufName,int RealLineNum) {vsBPMSetBL(pszBufName,RealLineNum,0,VSBPFLAG_EXEC,0);};
   inline void VSAPI vsBPMRemoveExecLine(int wid) {vsBPMSet(wid,0,VSBPFLAG_EXEC,0);};

   inline int VSAPI vsBPMSetStackExecLineBL(const char *pszBufName,int RealLineNum) {return(vsBPMSetBL(pszBufName,RealLineNum,VSBPFLAG_STACKEXEC,VSBPFLAG_STACKEXEC,1));};
   inline int VSAPI vsBPMSetStackExecLine(int wid) {return(vsBPMSet(wid,VSBPFLAG_STACKEXEC,VSBPFLAG_STACKEXEC,1));};
   inline void VSAPI vsBPMRemoveStackExecLineBL(const char *pszBufName,int RealLineNum) {vsBPMSetBL(pszBufName,RealLineNum,0,VSBPFLAG_STACKEXEC,0);};
   inline void VSAPI vsBPMRemoveStackExecLine(int wid) {vsBPMSet(wid,0,VSBPFLAG_STACKEXEC,0);};

   inline void VSAPI vsBPMClearAllBreakPoints() {vsBPMSetAll(0,VSBPFLAG_BREAKPOINT|VSBPFLAG_BREAKPOINTDISABLED);};
}
#endif
