   /*
$VerboseHistory: deupdate.e$
*/
//
// Add support for a new property requires modifying the
// following functions.
//
//      _deupdate_combo,_defill_cblist,_deupdate_property,
//      _set_property, _get_property, _demerge_props
//
// Not all these functions will need to modified.  Some
// LIST constants that they use may need to be modified.
//
#include 'slick.sh'
   _form _dlge_form;
            //_display_wid is the wid of a selected control or 0 if
            // no controls selected
   int _deform_wid=0; //  Window id of properties form.
   int _decombo_wid;  // Window id of combo box
   int _delist_wid;   // Window id of list box
   _str _depname;      // Current/last property name
   int _deNofselected; // Number of selected
                           // controls
  _control combo;

    const OBJECT_KIND_LIST=\
             '_form='OI_FORM' ':+
             '_text_box='OI_TEXT_BOX' ':+
             '_check_box='OI_CHECK_BOX' ':+
             '_command_button='OI_COMMAND_BUTTON' ':+
             '_radio_button='OI_RADIO_BUTTON' ':+
             '_frame='OI_FRAME' ':+
             '_label='OI_LABEL' ':+
             '_list_box='OI_LIST_BOX' ':+
             '_editor='OI_EDITOR' ':+
             '_vscroll_bar='OI_VSCROLL_BAR' ':+
             '_hscroll_bar='OI_HSCROLL_BAR' ':+
             '_combo_box='OI_COMBO_BOX' ':+
             '_picture_box='OI_PICTURE_BOX' ':+
             '_image='OI_IMAGE' ':+
             '_gauge='OI_GAUGE' ':+
             '_spin='OI_SPIN' ':+
             '_sstab='OI_SSTAB' ':+
             '_tree_view='OI_TREE_VIEW' ';
    //  Color properties are in hex or decimal. combo box
    //  displays picture "...".  Can edit combo text box.
    const COLOR_PROPS=' backcolor forecolor';
    //  Boolean properties.  Show True or False.
    //  Can not edit in text box.
    const BOOLEAN_PROPS= ' ActiveEnabled AlwaysColorCurrent auto_size cancel CaptionClick case_sensitive CheckListBox clip_controls default enabled':+
                   ' font_bold font_italic':+
                   ' font_underline Grabbar max_button min_button PictureOnly':+
                   ' ReadOnly Password ShowRoot stretch tab_stop tool_window visible word_wrap';
    //  Can edit combo text.
    const INCINT_PROPS='font_size LineStyle Orientation value';
    const INT_PROPS='ActiveTab ActiveOrder delay FirstActiveTab font_size height increment large_change LevelIndent max min Nofstates small_change tab_index SpaceY ':+
              'TabsPerRow value width PaddingX PaddingY';
    const MIN_VALUES='font_size=1 height=4 Nofstates=1 tab_index=0 ':+
              'width=4 x=0 y=0';
    const MAX_VALUES='';
    // Properties selectable from combo list.
    const CBLIST_PROPS=' alignment border_style command completion font_name LineStyle max_click mouse_pointer':+
               ' multi_select MultiRow Orientation scroll_bars style ';
    const TRUEFALSE_LIST='FALSE='FALSE' TRUE='TRUE;
    const AL_LIST='AL_LEFT='AL_LEFT' ':+
              'AL_RIGHT='AL_RIGHT' ':+
              'AL_CENTER='AL_CENTER' ':+
              'AL_VCENTER='AL_VCENTER' ':+
              'AL_VCENTERRIGHT='AL_VCENTERRIGHT' ':+
              'AL_CENTERBOTH='AL_CENTERBOTH;
    const AL_CHECK_LIST='AL_LEFT='AL_LEFT' ':+
              'AL_RIGHT='AL_RIGHT;
    const SB_LIST='SB_NONE='SB_NONE' ':+
            'SB_HORIZONTAL='SB_HORIZONTAL' ':+
            'SB_VERTICAL='SB_VERTICAL' ':+
            'SB_BOTH='SB_BOTH;
    const BDS_FORM_LIST='BDS_NONE='BDS_NONE' ':+
               'BDS_FIXED_SINGLE='BDS_FIXED_SINGLE' ':+
               'BDS_SIZABLE='BDS_SIZABLE' ':+
               'BDS_DIALOG_BOX='BDS_DIALOG_BOX;
    const BDS_LIST='BDS_NONE='BDS_NONE' ':+
               'BDS_FIXED_SINGLE='BDS_FIXED_SINGLE;
    // List for label
    const BDS_LIST2='BDS_NONE='BDS_NONE' ':+
             'BDS_FIXED_SINGLE='BDS_FIXED_SINGLE' ':+
             'BDS_SUNKEN='BDS_SUNKEN;
    const SSTAB_MULTIROW_LIST='SSTAB_MULTIROW_NONE='SSTAB_MULTIROW_NONE' ':+
             'SSTAB_MULTIROW_MULTIROW='SSTAB_MULTIROW_MULTIROW' ':+
             'SSTAB_MULTIROW_BESTFIT='SSTAB_MULTIROW_BESTFIT;
#if 0
    const VS_LIST='VS_NONE='VS_NONE' ':+
               'VS_INTEGER='VS_INTEGER;
#endif
    const MC_LIST='MC_SINGLE='MC_SINGLE' ':+
            'MC_DOUBLE='MC_DOUBLE' ':+
            'MC_TRIPLE='MC_TRIPLE;
    const MP_LIST='MP_DEFAULT='MP_DEFAULT' ':+
              'MP_ARROW='MP_ARROW' ':+
              'MP_CROSS='MP_CROSS' ':+
              'MP_IBEAM='MP_IBEAM' ':+
              'MP_ICON='MP_ICON' ':+
              'MP_SIZE='MP_SIZE' ':+
              'MP_SIZENESW='MP_SIZENESW' ':+
              'MP_SIZENS='MP_SIZENS' ':+
              'MP_SIZENWSE='MP_SIZENWSE' ':+
              'MP_SIZEWE='MP_SIZEWE' ':+
              'MP_UP_ARROW='MP_UP_ARROW' ':+
              'MP_HOUR_GLASS='MP_HOUR_GLASS' ':+
              'MP_SIZEHORZ='MP_SIZEHORZ' ':+
              'MP_SIZEVERT='MP_SIZEVERT' ':+
              'MP_LEFTARROW_DROP_TOP='MP_LEFTARROW_DROP_TOP' ':+
              'MP_LEFTARROW_DROP_BOTTOM='MP_LEFTARROW_DROP_BOTTOM' ':+
              'MP_LEFTARROW_DROP_RIGHT='MP_LEFTARROW_DROP_RIGHT' ':+
              'MP_LEFTARROW_DROP_LEFT='MP_LEFTARROW_DROP_LEFT' ':+
              'MP_LEFTARROW='MP_LEFTARROW' ':+
              'MP_RIGHTARROW='MP_RIGHTARROW' ':+
              'MP_MOVETEXT='MP_MOVETEXT;
              /* ' ':+'MP_NODROP='MP_NODROP  No available yet. */
    const MS_LIST='MS_NONE='MS_NONE' ':+
              'MS_SIMPLE_LIST='MS_SIMPLE_LIST' ':+
              'MS_EXTENDED='MS_EXTENDED;
    const MS_LIST_TREEVIEW='MS_NONE='MS_NONE' ':+
              'MS_SIMPLE_LIST='MS_SIMPLE_LIST
    const CP_LIST='NONE_ARG=. ':+
            'FILE_ARG='FILE_ARG' ':+
            'MULTI_FILE_ARG='MULTI_FILE_ARG' ':+
            'BUFFER_ARG='BUFFER_ARG' ':+
            'COMMAND_ARG='COMMAND_ARG' ':+
            'PICTURE_ARG='PICTURE_ARG' ':+
            'FORM_ARG='FORM_ARG' ':+
            'MODULE_ARG='MODULE_ARG' ':+
            'MACRO_ARG='MACRO_ARG' ':+
            'MACROTAG_ARG='MACROTAG_ARG' ':+
            'VAR_ARG='VAR_ARG' ':+
            'ENV_ARG='ENV_ARG' ':+
            'MENU_ARG='MENU_ARG' ':+
            /* 'HELP_ARG='HELP_ARG' ':+ */
            'TAG_ARG='TAG_ARG' ';

    const COMPLETION_LIST='picture='PICTURE_ARG' ':+
                    'CollapsePicture='PICTURE_ARG' ':+
                    'command='COMMAND_ARG' ':+
                    'ExpandPicture='PICTURE_ARG' ':+
                    'help='HELP_ARG' ':+
                    'ActiveHelp='HELP_ARG;

    const PSCH_LIST='PSCH_AUTO2STATE='PSCH_AUTO2STATE' ':+
              'PSCH_AUTO3STATEA='PSCH_AUTO3STATEA' ':+
              'PSCH_AUTO3STATEB='PSCH_AUTO3STATEB;
    const PSCBO_LIST='PSCBO_EDIT='PSCBO_EDIT' ':+
               'PSCBO_LIST_ALWAYS='PSCBO_LIST_ALWAYS' ':+
               'PSCBO_NOEDIT='PSCBO_NOEDIT;
    const PSGA_LIST='PSGA_HORZ_WITH_PERCENT='PSGA_HORZ_WITH_PERCENT' ':+
              'PSGA_VERT_WITH_PERCENT='PSGA_VERT_WITH_PERCENT' ':+
              'PSGA_HORIZONTAL='PSGA_HORIZONTAL' ':+
              'PSGA_VERTICAL='PSGA_VERTICAL;
    const PSPIC_LIST='PSPIC_DEFAULT='PSPIC_DEFAULT' ':+
               'PSPIC_PARTIAL_BUTTON='PSPIC_PARTIAL_BUTTON' ':+
               'PSPIC_AUTO_BUTTON='PSPIC_AUTO_BUTTON' ':+
               'PSPIC_AUTO_CHECK='PSPIC_AUTO_CHECK;
    const PSIMG_LIST='PSPIC_DEFAULT='PSPIC_DEFAULT' ':+
               'PSPIC_BUTTON='PSPIC_BUTTON' ':+
               'PSPIC_AUTO_BUTTON='PSPIC_AUTO_BUTTON' ':+
               'PSPIC_AUTO_CHECK='PSPIC_AUTO_CHECK' ':+
               'PSPIC_SIZEVERT='PSPIC_SIZEVERT' ':+
               'PSPIC_SIZEHORZ='PSPIC_SIZEHORZ' ':+
               'PSPIC_SIZEHORZ='PSPIC_SIZEHORZ' ':+
               'PSPIC_GRABBARVERT='PSPIC_GRABBARVERT' ':+
               'PSPIC_GRABBARHORZ='PSPIC_GRABBARHORZ' ':+
               'PSPIC_TOOLBAR_DIVIDER_VERT='PSPIC_TOOLBAR_DIVIDER_VERT' ':+
               'PSPIC_TOOLBAR_DIVIDER_HORZ='PSPIC_TOOLBAR_DIVIDER_HORZ' ':+
               'PSPIC_FLAT_BUTTON='PSPIC_FLAT_BUTTON
                  ;
    const SSTAB_ORIENTATION_LIST='SSTAB_OTOP='SSTAB_OTOP' ':+
               'SSTAB_OBOTTOM='SSTAB_OBOTTOM;


    const TREE_LINE_LIST='TREE_NO_LINES='TREE_NO_LINES' ':+
        'TREE_DOTTED_LINES='TREE_DOTTED_LINES' ':+
        'TREE_SOLID_LINES='TREE_SOLID_LINES' ';


static _str count=1;

  _control _objectkind;
void _deupdate()
{
   /* messageNwait('_deform_wid='_deform_wid' _display_wid='_display_wid) */
   // IF properties form not displayed, do nothing.
   if (!_deform_wid) {
      return;
   }
   if (!_display_wid) {
      _delist_wid.p_enabled=0
      _decombo_wid.p_enabled=0
      _declear_props()
      _deform_wid.p_caption=nls('Properties')
      _deform_wid._objectkind.p_caption=''
      return;
   }
   _deform_wid._objectkind.p_caption=eq_value2name(_display_wid.p_object,OBJECT_KIND_LIST)
   //_desave_combovalue()
   old_depname=_depname
   _declear_props()
   _depname=old_depname
   _delist_wid.p_enabled=1
   _decombo_wid.p_enabled=1
   orig_wid=p_window_id
   p_window_id=_delist_wid
   if (_deNofselected>1) {
      _demerge_props()
   } else {
      switch (_display_wid.p_object) {
      case OI_FORM:
         _deform_props();
         break;
      case OI_TEXT_BOX:
         _detext_props();
         break;
      case OI_COMMAND_BUTTON:
         _decommand_props();
         break;
      case OI_CHECK_BOX:
         _decheck_props();
         break;
      case OI_RADIO_BUTTON:
         _deradio_props()
         break;
      case OI_FRAME:
         _deframe_props();
         break;
      case OI_LABEL:
         _delabel_props();
         break;
      case OI_LIST_BOX:
         _delist_props();
         break;
      case OI_EDITOR:
         _deeditor_props();
         break;
      case OI_COMBO_BOX:
         _decombo_props();
         break;
      case OI_IMAGE:
         _deimage_props();
         break;
      case OI_PICTURE_BOX:
         _depicture_props();
         break;
      case OI_HSCROLL_BAR:
         _descroll_props();
         break;
      case OI_VSCROLL_BAR:
         _descroll_props();
         break;
      case OI_GAUGE:
         _degauge_props();
         break;
      case OI_SPIN:
         _despin_props();
         break;
      case OI_SSTAB:
         _desstab_props();
         break;
      case OI_TREE_VIEW:
         _detree_props();
         break;
      }
   }
   _post_paint()
   p_window_id=orig_wid
   _deupdate_caption()
   status=0;
   if (_depname!='') {
      _delist_wid.top()
      status=_delist_wid.search('^?'_depname,'@ri')
   }
   if (status || _depname=='') {
      _delist_wid.top();
      _delist_wid._lbselect_line()
   } else {
      _delist_wid._lbselect_line()
   }
   _deupdate_combo()
   //message 'display object='_display_wid.p_object;delay(200)
}
static void _declear_props()
{
   _delist_wid._lbclear()
   _decombo_wid.p_text='';
}
_str _format_color(color)
{
   if (color<0) {
      color=(pow(2,32))+color
   }
   result=dec2hex(color)
   parse result with '0x' rest
   return('0x'substr('',1,8-length(rest),'0'):+rest)
}
const CHECK_BOX_PROPS=' alignment backcolor caption enabled eventtab eventtab2 font_bold':+
               ' font_italic font_name font_size forecolor height help':+
               ' mouse_pointer tab_stop value visible width x y ';

static void _decheck_props()
{
   insert_line(" alignment\t"eq_value2name(_display_wid.p_alignment,AL_LIST))
   insert_line(" backcolor\t"_format_color(_display_wid.p_backcolor))
   insert_line(" caption\t"_display_wid.p_caption)
   insert_line(" enabled\t"_bool2truefalse(_display_wid.p_enabled))
   insert_line(" eventtab\t"translate(name_name(_display_wid.p_eventtab),'_','-'))
   insert_line(" eventtab2\t"translate(name_name(_display_wid.p_eventtab2),'_','-'))
   insert_line(" font_bold\t"_bool2truefalse(_display_wid.p_font_bold))
   insert_line(" font_italic\t"_bool2truefalse(_display_wid.p_font_italic))
   insert_line(" font_name\t"_display_wid.p_font_name)
   insert_line(" font_size\t"_display_wid.p_font_size)
   insert_line(" font_underline\t"_bool2truefalse(_display_wid.p_font_underline))
   insert_line(" forecolor\t"_format_color(_display_wid.p_forecolor))
   insert_line(" height\t"_display_wid.p_height)
   insert_line(" help\t"_display_wid.p_help);
   insert_line(" mouse_pointer\t"eq_value2name(_display_wid.p_mouse_pointer,MP_LIST))
   insert_line(" name\t"_display_wid.p_name)
   insert_line(" style\t"eq_value2name(_display_wid.p_style,PSCH_LIST))
   insert_line(" tab_index\t"_display_wid.p_tab_index)
   insert_line(" tab_stop\t"_bool2truefalse(_display_wid.p_tab_stop))
   insert_line(" value\t"_display_wid.p_value)
   insert_line(" visible\t"_bool2truefalse(_display_wid.p_visible))
   insert_line(" width\t"_display_wid.p_width)
   insert_line(" x\t"_display_wid.p_x)
   insert_line(" y\t"_display_wid.p_y)
}
static safe_insert_line(property,value)
{
   // Macro compiler has 1k limit on string constants
   // here we let the compiler truncate the string
   if (length(property)+length(value)+12>=1000) {
      i=length(value) intdiv 2;
      // It is ok to bisect a dbcs character here.
      half=substr(value,1,i);
      half2=substr(value,i+1);
      insert_line(property:+_quote(half)':+')
      insert_line(substr('',1,length(property)):+_quote(half2))
      return('')
   }
   insert_line(property:+_quote(value))
}
void _insert_check_props(_display_wid,indent,form_name)
{
   insert_line(substr('',1,indent)"p_alignment="eq_value2name(_display_wid.p_alignment,AL_LIST))
   insert_line(substr('',1,indent)"p_backcolor="_format_color(_display_wid.p_backcolor))
   safe_insert_line(substr('',1,indent)"p_caption=",_display_wid.p_caption)
   if(!_display_wid.p_enabled) insert_line(substr('',1,indent)"p_enabled="_bool2truefalse(_display_wid.p_enabled))
   insert_line(substr('',1,indent)"p_font_bold="_bool2truefalse(_display_wid.p_font_bold))
   insert_line(substr('',1,indent)"p_font_italic="_bool2truefalse(_display_wid.p_font_italic))
   insert_line(substr('',1,indent)"p_font_name="_quote(_display_wid.p_font_name))
   insert_line(substr('',1,indent)"p_font_size="_display_wid.p_font_size)
   insert_line(substr('',1,indent)"p_font_underline="_bool2truefalse(_display_wid.p_font_underline))
   insert_line(substr('',1,indent)"p_forecolor="_format_color(_display_wid.p_forecolor))
   insert_line(substr('',1,indent)"p_height="_display_wid.p_height)
   if (_display_wid.p_help!='') safe_insert_line(substr('',1,indent)"p_help=",_display_wid.p_help);
   if(_display_wid.p_mouse_pointer!=MP_DEFAULT) insert_line(substr('',1,indent)"p_mouse_pointer="eq_value2name(_display_wid.p_mouse_pointer,MP_LIST))
   insert_line(substr('',1,indent)"p_style="eq_value2name(_display_wid.p_style,PSCH_LIST))
   insert_line(substr('',1,indent)"p_tab_index="_display_wid.p_tab_index)
   insert_line(substr('',1,indent)"p_tab_stop="_bool2truefalse(_display_wid.p_tab_stop))
   insert_line(substr('',1,indent)"p_value="_display_wid.p_value)
   if (!_display_wid.p_visible) insert_line(substr('',1,indent)"p_visible="_bool2truefalse(_display_wid.p_visible))
   insert_line(substr('',1,indent)"p_width="_display_wid.p_width)
   insert_line(substr('',1,indent)"p_x="_display_wid.p_x)
   insert_line(substr('',1,indent)"p_y="_display_wid.p_y)
   insert_etabs(_display_wid,indent,form_name);
}
const
   RADIO_BUTTON_PROPS=' alignment backcolor caption enabled eventtab eventtab2 font_bold':+
               ' font_italic font_name font_size font_underline':+
               ' forecolor height help mouse_pointer tab_stop value visible':+
               ' width x y ';
static void _deradio_props()
{
   insert_line(" alignment\t"eq_value2name(_display_wid.p_alignment,AL_LIST))
   insert_line(" backcolor\t"_format_color(_display_wid.p_backcolor))
   insert_line(" caption\t"_display_wid.p_caption)
   insert_line(" enabled\t"_bool2truefalse(_display_wid.p_enabled))
   insert_line(" eventtab\t"translate(name_name(_display_wid.p_eventtab),'_','-'))
   insert_line(" eventtab2\t"translate(name_name(_display_wid.p_eventtab2),'_','-'))
   insert_line(" font_bold\t"_bool2truefalse(_display_wid.p_font_bold))
   insert_line(" font_italic\t"_bool2truefalse(_display_wid.p_font_italic))
   insert_line(" font_name\t"_display_wid.p_font_name)
   insert_line(" font_size\t"_display_wid.p_font_size)
   insert_line(" font_underline\t"_bool2truefalse(_display_wid.p_font_underline))
   insert_line(" forecolor\t"_format_color(_display_wid.p_forecolor))
   insert_line(" height\t"_display_wid.p_height)
   insert_line(" help\t"_display_wid.p_help);
   insert_line(" mouse_pointer\t"eq_value2name(_display_wid.p_mouse_pointer,MP_LIST))
   insert_line(" name\t"_display_wid.p_name)
   insert_line(" tab_index\t"_display_wid.p_tab_index)
   insert_line(" tab_stop\t"_bool2truefalse(_display_wid.p_tab_stop))
   insert_line(" value\t"_display_wid.p_value)
   insert_line(" visible\t"_bool2truefalse(_display_wid.p_visible))
   insert_line(" width\t"_display_wid.p_width)
   insert_line(" x\t"_display_wid.p_x)
   insert_line(" y\t"_display_wid.p_y)
}
void _insert_radio_props(_display_wid,indent,form_name)
{
   insert_line(substr('',1,indent)"p_alignment="eq_value2name(_display_wid.p_alignment,AL_LIST))
   insert_line(substr('',1,indent)"p_backcolor="_format_color(_display_wid.p_backcolor))
   safe_insert_line(substr('',1,indent)"p_caption=",_display_wid.p_caption)
   if(!_display_wid.p_enabled) insert_line(substr('',1,indent)"p_enabled="_bool2truefalse(_display_wid.p_enabled))
   insert_line(substr('',1,indent)"p_font_bold="_bool2truefalse(_display_wid.p_font_bold))
   insert_line(substr('',1,indent)"p_font_italic="_bool2truefalse(_display_wid.p_font_italic))
   insert_line(substr('',1,indent)"p_font_name="_quote(_display_wid.p_font_name))
   insert_line(substr('',1,indent)"p_font_size="_display_wid.p_font_size)
   insert_line(substr('',1,indent)"p_font_underline="_bool2truefalse(_display_wid.p_font_underline))
   insert_line(substr('',1,indent)"p_forecolor="_format_color(_display_wid.p_forecolor))
   insert_line(substr('',1,indent)"p_height="_display_wid.p_height)
   if (_display_wid.p_help!='') safe_insert_line(substr('',1,indent)"p_help=",_display_wid.p_help);
   if(_display_wid.p_mouse_pointer!=MP_DEFAULT) insert_line(substr('',1,indent)"p_mouse_pointer="eq_value2name(_display_wid.p_mouse_pointer,MP_LIST))
   insert_line(substr('',1,indent)"p_tab_index="_display_wid.p_tab_index)
   insert_line(substr('',1,indent)"p_tab_stop="_bool2truefalse(_display_wid.p_tab_stop))
   insert_line(substr('',1,indent)"p_value="_display_wid.p_value)
   if (!_display_wid.p_visible) insert_line(substr('',1,indent)"p_visible="_bool2truefalse(_display_wid.p_visible))
   insert_line(substr('',1,indent)"p_width="_display_wid.p_width)
   insert_line(substr('',1,indent)"p_x="_display_wid.p_x)
   insert_line(substr('',1,indent)"p_y="_display_wid.p_y)
   insert_etabs(_display_wid,indent,form_name);
}
const
   FORM_PROPS=' backcolor border_style caption CaptionClick clip_controls enabled eventtab eventtab2':+
              ' forecolor height help max_button mouse_pointer tool_window visible width x y ';
static void _deform_props()
{
   insert_line(" backcolor\t"_format_color(_display_wid.p_backcolor))
   insert_line(" border_style\t"eq_value2name(_display_wid.p_border_style,BDS_FORM_LIST))
   insert_line(" caption\t"_display_wid.p_caption)
   insert_line(" CaptionClick\t"_bool2truefalse(_display_wid.p_CaptionClick))
   insert_line(" clip_controls\t"_bool2truefalse(_display_wid.p_clip_controls))
   insert_line(" enabled\t"_bool2truefalse(_display_wid.p_enabled))
   insert_line(" eventtab\t"translate(name_name(_display_wid.p_eventtab),'_','-'))
   insert_line(" eventtab2\t"translate(name_name(_display_wid.p_eventtab2),'_','-'))
   insert_line(" forecolor\t"_format_color(_display_wid.p_forecolor))
   insert_line(" height\t"_display_wid.p_height)
   insert_line(" help\t"_display_wid.p_help);
   insert_line(" max_button\t"_bool2truefalse(_display_wid.p_max_button))
   //insert_line(" min_button\t"_bool2truefalse(_display_wid.p_min_button))
   insert_line(" mouse_pointer\t"eq_value2name(_display_wid.p_mouse_pointer,MP_LIST))
   insert_line(" name\t"_display_wid.p_name)
   insert_line(" tool_window\t"_bool2truefalse(_display_wid.p_tool_window))
   insert_line(" visible\t"_bool2truefalse(_display_wid.p_visible))
   insert_line(" width\t"_display_wid.p_width)
   insert_line(" x\t"_display_wid.p_x)
   insert_line(" y\t"_display_wid.p_y)
}
static insert_etabs(_display_wid,indent,form_name)
{
   etname=translate(name_name(_display_wid.p_eventtab),'_','-')
   if (_display_wid.p_eventtab &&
       !name_eq(form_name'.'_display_wid.p_name,etname)) {
      insert_line(substr('',1,indent)"p_eventtab="etname)
   }
   if (_display_wid.p_eventtab2) {
      insert_line(substr('',1,indent)"p_eventtab2="translate(name_name(_display_wid.p_eventtab2),'_','-'))
   }
}
void _insert_form_props(_display_wid,indent,form_name)
{
   insert_line(substr('',1,indent)"p_backcolor="_format_color(_display_wid.p_backcolor))
   insert_line(substr('',1,indent)"p_border_style="eq_value2name(_display_wid.p_border_style,BDS_FORM_LIST))
   safe_insert_line(substr('',1,indent)"p_caption=",_display_wid.p_caption)
   if (_display_wid.p_CaptionClick) {
      insert_line(substr('',1,indent)"p_CaptionClick="_bool2truefalse(_display_wid.p_CaptionClick))
   }
   insert_line(substr('',1,indent)"p_clip_controls="_bool2truefalse(_display_wid.p_clip_controls))
   if(!_display_wid.p_enabled) insert_line(substr('',1,indent)"p_enabled="_bool2truefalse(_display_wid.p_enabled))
   insert_line(substr('',1,indent)"p_forecolor="_format_color(_display_wid.p_forecolor))
   insert_line(substr('',1,indent)"p_height="_display_wid.p_height)
   if (_display_wid.p_help!='') safe_insert_line(substr('',1,indent)"p_help=",_display_wid.p_help);
   if(_display_wid.p_max_button) insert_line(substr('',1,indent)"p_max_button="_bool2truefalse(_display_wid.p_max_button));
   //if(_display_wid.p_min_button) insert_line(substr('',1,indent)"p_min_button="_bool2truefalse(_display_wid.p_min_button))
   if(_display_wid.p_mouse_pointer!=MP_DEFAULT) insert_line(substr('',1,indent)"p_mouse_pointer="eq_value2name(_display_wid.p_mouse_pointer,MP_LIST))
   if (_display_wid.p_tool_window) insert_line(substr('',1,indent)"p_tool_window="_bool2truefalse(_display_wid.p_tool_window))
   if (!_display_wid.p_visible) insert_line(substr('',1,indent)"p_visible="_bool2truefalse(_display_wid.p_visible))
   insert_line(substr('',1,indent)"p_width="_display_wid.p_width)
   insert_line(substr('',1,indent)"p_x="_display_wid.p_x)
   insert_line(substr('',1,indent)"p_y="_display_wid.p_y)
   insert_etabs(_display_wid,indent,form_name);
}
const
   TEXT_BOX_PROPS=' auto_size backcolor border_style completion enabled eventtab eventtab2 font_bold':+
                  ' font_italic font_name font_size font_underline forecolor':+
                  ' height help mouse_pointer ReadOnly Password tab_stop text visible width x y ';
static void _detext_props()
{
   insert_line(" auto_size\t"_bool2truefalse(_display_wid.p_auto_size))
   insert_line(" backcolor\t"_format_color(_display_wid.p_backcolor))
   insert_line(" border_style\t"eq_value2name(_display_wid.p_border_style,BDS_LIST))
   insert_line(" completion\t"cp_value2name(_display_wid.p_completion))
   insert_line(" enabled\t"_bool2truefalse(_display_wid.p_enabled))
   insert_line(" eventtab\t"translate(name_name(_display_wid.p_eventtab),'_','-'))
   insert_line(" eventtab2\t"translate(name_name(_display_wid.p_eventtab2),'_','-'))
   insert_line(" font_bold\t"_bool2truefalse(_display_wid.p_font_bold))
   insert_line(" font_italic\t"_bool2truefalse(_display_wid.p_font_italic))
   insert_line(" font_name\t"_display_wid.p_font_name)
   insert_line(" font_size\t"_display_wid.p_font_size)
   insert_line(" font_underline\t"_bool2truefalse(_display_wid.p_font_underline))
   insert_line(" forecolor\t"_format_color(_display_wid.p_forecolor))
   insert_line(" height\t"_display_wid.p_height)
   insert_line(" help\t"_display_wid.p_help);
   insert_line(" mouse_pointer\t"eq_value2name(_display_wid.p_mouse_pointer,MP_LIST))
   insert_line(" name\t"_display_wid.p_name)
   insert_line(" ReadOnly\t"_bool2truefalse(_display_wid.p_ReadOnly))
   insert_line(" Password\t"_bool2truefalse(_display_wid.p_Password))
   insert_line(" tab_index\t"_display_wid.p_tab_index)
   insert_line(" tab_stop\t"_bool2truefalse(_display_wid.p_tab_stop))
   insert_line(" text\t"_display_wid.p_text)
   //insert_line(" validate_style\t"eq_value2name(_display_wid.p_validate_style,VS_LIST))
   insert_line(" visible\t"_bool2truefalse(_display_wid.p_visible))
   insert_line(" width\t"_display_wid.p_width)
   insert_line(" x\t"_display_wid.p_x)
   insert_line(" y\t"_display_wid.p_y)
}
void _insert_text_props(_display_wid,indent,form_name)
{
   insert_line(substr('',1,indent)"p_auto_size="_bool2truefalse(_display_wid.p_auto_size))
   insert_line(substr('',1,indent)"p_backcolor="_format_color(_display_wid.p_backcolor))
   insert_line(substr('',1,indent)"p_border_style="eq_value2name(_display_wid.p_border_style,BDS_LIST))
   insert_line(substr('',1,indent)"p_completion="cp_value2name(_display_wid.p_completion))
   if(!_display_wid.p_enabled) insert_line(substr('',1,indent)"p_enabled="_bool2truefalse(_display_wid.p_enabled))
   insert_line(substr('',1,indent)"p_font_bold="_bool2truefalse(_display_wid.p_font_bold))
   insert_line(substr('',1,indent)"p_font_italic="_bool2truefalse(_display_wid.p_font_italic))
   insert_line(substr('',1,indent)"p_font_name="_quote(_display_wid.p_font_name))
   insert_line(substr('',1,indent)"p_font_size="_display_wid.p_font_size)
   insert_line(substr('',1,indent)"p_font_underline="_bool2truefalse(_display_wid.p_font_underline))
   insert_line(substr('',1,indent)"p_forecolor="_format_color(_display_wid.p_forecolor))
   insert_line(substr('',1,indent)"p_height="_display_wid.p_height)
   if (_display_wid.p_help!='') safe_insert_line(substr('',1,indent)"p_help=",_display_wid.p_help);
   if(_display_wid.p_mouse_pointer!=MP_DEFAULT) insert_line(substr('',1,indent)"p_mouse_pointer="eq_value2name(_display_wid.p_mouse_pointer,MP_LIST));
   if (_display_wid.p_ReadOnly) {
      insert_line(substr('',1,indent)"p_ReadOnly="_bool2truefalse(_display_wid.p_ReadOnly));
   }
   if (_display_wid.p_Password) {
      insert_line(substr('',1,indent)"p_Password="_bool2truefalse(_display_wid.p_Password));
   }
   insert_line(substr('',1,indent)"p_tab_index="_display_wid.p_tab_index)
   insert_line(substr('',1,indent)"p_tab_stop="_bool2truefalse(_display_wid.p_tab_stop))
   if (_display_wid.p_text:!='') insert_line(substr('',1,indent)"p_text="_quote(_display_wid.p_text))
   //insert_line(substr('',1,indent)"p_validate_style="eq_value2name(_display_wid.p_validate_style,VS_LIST))
   if (!_display_wid.p_visible) insert_line(substr('',1,indent)"p_visible="_bool2truefalse(_display_wid.p_visible))
   insert_line(substr('',1,indent)"p_width="_display_wid.p_width)
   insert_line(substr('',1,indent)"p_x="_display_wid.p_x)
   insert_line(substr('',1,indent)"p_y="_display_wid.p_y)
   insert_etabs(_display_wid,indent,form_name);
}
const
   COMMAND_BUTTON_PROPS=' cancel caption command default enabled eventtab eventtab2 font_bold':+
              ' font_italic font_name font_size font_underline':+
              ' height help mouse_pointer tab_stop visible width x y ';

static void _decommand_props()
{
   //insert_line(" backcolor\t"_format_color(_display_wid.p_backcolor))
   insert_line(" cancel\t"_bool2truefalse(_display_wid.p_cancel))
   insert_line(" caption\t"_display_wid.p_caption)
   insert_line(" command\t"_display_wid.p_command)
   insert_line(" default\t"_bool2truefalse(_display_wid.p_default))
   insert_line(" enabled\t"_bool2truefalse(_display_wid.p_enabled))
   insert_line(" eventtab\t"translate(name_name(_display_wid.p_eventtab),'_','-'))
   insert_line(" eventtab2\t"translate(name_name(_display_wid.p_eventtab2),'_','-'))
   insert_line(" font_bold\t"_bool2truefalse(_display_wid.p_font_bold))
   insert_line(" font_italic\t"_bool2truefalse(_display_wid.p_font_italic))
   insert_line(" font_name\t"_display_wid.p_font_name)
   insert_line(" font_size\t"_display_wid.p_font_size)
   insert_line(" font_underline\t"_bool2truefalse(_display_wid.p_font_underline))
   insert_line(" height\t"_display_wid.p_height)
   insert_line(" help\t"_display_wid.p_help);
   insert_line(" mouse_pointer\t"eq_value2name(_display_wid.p_mouse_pointer,MP_LIST))
   insert_line(" name\t"_display_wid.p_name)
   insert_line(" tab_index\t"_display_wid.p_tab_index)
   insert_line(" tab_stop\t"_bool2truefalse(_display_wid.p_tab_stop))
   insert_line(" visible\t"_bool2truefalse(_display_wid.p_visible))
   insert_line(" width\t"_display_wid.p_width)
   insert_line(" x\t"_display_wid.p_x)
   insert_line(" y\t"_display_wid.p_y)
}
void _insert_command_props(_display_wid,indent,form_name)
{
   //insert_line(substr('',1,indent)"p_backcolor="_format_color(_display_wid.p_backcolor))
   insert_line(substr('',1,indent)"p_cancel="_bool2truefalse(_display_wid.p_cancel))
   safe_insert_line(substr('',1,indent)"p_caption=",_display_wid.p_caption)
   if (_display_wid.p_command!="") {
      safe_insert_line(substr('',1,indent)"p_command=",_display_wid.p_command)
   }
   insert_line(substr('',1,indent)"p_default="_bool2truefalse(_display_wid.p_default))
   if(!_display_wid.p_enabled) insert_line(substr('',1,indent)"p_enabled="_bool2truefalse(_display_wid.p_enabled))
   insert_line(substr('',1,indent)"p_font_bold="_bool2truefalse(_display_wid.p_font_bold))
   insert_line(substr('',1,indent)"p_font_italic="_bool2truefalse(_display_wid.p_font_italic))
   insert_line(substr('',1,indent)"p_font_name="_quote(_display_wid.p_font_name))
   insert_line(substr('',1,indent)"p_font_size="_display_wid.p_font_size)
   insert_line(substr('',1,indent)"p_font_underline="_bool2truefalse(_display_wid.p_font_underline))
   insert_line(substr('',1,indent)"p_height="_display_wid.p_height)
   if (_display_wid.p_help!='') safe_insert_line(substr('',1,indent)"p_help=",_display_wid.p_help);
   if(_display_wid.p_mouse_pointer!=MP_DEFAULT) insert_line(substr('',1,indent)"p_mouse_pointer="eq_value2name(_display_wid.p_mouse_pointer,MP_LIST))
   insert_line(substr('',1,indent)"p_tab_index="_display_wid.p_tab_index)
   insert_line(substr('',1,indent)"p_tab_stop="_bool2truefalse(_display_wid.p_tab_stop))
   if (!_display_wid.p_visible) insert_line(substr('',1,indent)"p_visible="_bool2truefalse(_display_wid.p_visible))
   insert_line(substr('',1,indent)"p_width="_display_wid.p_width)
   insert_line(substr('',1,indent)"p_x="_display_wid.p_x)
   insert_line(substr('',1,indent)"p_y="_display_wid.p_y)
   insert_etabs(_display_wid,indent,form_name);
}
const
   FRAME_PROPS=' backcolor caption clip_controls enabled eventtab eventtab2 font_bold font_italic font_name':+
               ' font_size font_underline forecolor height help mouse_pointer':+
               ' visible width x y ';
static void _deframe_props()
{
   insert_line(" backcolor\t"_format_color(_display_wid.p_backcolor))
   insert_line(" caption\t"_display_wid.p_caption)
   insert_line(" clip_controls\t"_bool2truefalse(_display_wid.p_clip_controls))
   insert_line(" enabled\t"_bool2truefalse(_display_wid.p_enabled))
   insert_line(" eventtab\t"translate(name_name(_display_wid.p_eventtab),'_','-'))
   insert_line(" eventtab2\t"translate(name_name(_display_wid.p_eventtab2),'_','-'))
   insert_line(" font_bold\t"_bool2truefalse(_display_wid.p_font_bold))
   insert_line(" font_italic\t"_bool2truefalse(_display_wid.p_font_italic))
   insert_line(" font_name\t"_display_wid.p_font_name)
   insert_line(" font_size\t"_display_wid.p_font_size)
   insert_line(" font_underline\t"_bool2truefalse(_display_wid.p_font_underline))
   insert_line(" forecolor\t"_format_color(_display_wid.p_forecolor))
   insert_line(" height\t"_display_wid.p_height)
   insert_line(" help\t"_display_wid.p_help);
   insert_line(" mouse_pointer\t"eq_value2name(_display_wid.p_mouse_pointer,MP_LIST))
   insert_line(" name\t"_display_wid.p_name)
   insert_line(" tab_index\t"_display_wid.p_tab_index)
   insert_line(" visible\t"_bool2truefalse(_display_wid.p_visible))
   insert_line(" width\t"_display_wid.p_width)
   insert_line(" x\t"_display_wid.p_x)
   insert_line(" y\t"_display_wid.p_y)
}
void _insert_frame_props(_display_wid,indent,form_name)
{
   insert_line(substr('',1,indent)"p_backcolor="_format_color(_display_wid.p_backcolor))
   safe_insert_line(substr('',1,indent)"p_caption=",_display_wid.p_caption)
   insert_line(substr('',1,indent)"p_clip_controls="_bool2truefalse(_display_wid.p_clip_controls))
   if(!_display_wid.p_enabled) insert_line(substr('',1,indent)"p_enabled="_bool2truefalse(_display_wid.p_enabled))
   insert_line(substr('',1,indent)"p_font_bold="_bool2truefalse(_display_wid.p_font_bold))
   insert_line(substr('',1,indent)"p_font_italic="_bool2truefalse(_display_wid.p_font_italic))
   insert_line(substr('',1,indent)"p_font_name="_quote(_display_wid.p_font_name))
   insert_line(substr('',1,indent)"p_font_size="_display_wid.p_font_size)
   insert_line(substr('',1,indent)"p_font_underline="_bool2truefalse(_display_wid.p_font_underline))
   insert_line(substr('',1,indent)"p_forecolor="_format_color(_display_wid.p_forecolor))
   insert_line(substr('',1,indent)"p_height="_display_wid.p_height)
   if (_display_wid.p_help!='') safe_insert_line(substr('',1,indent)"p_help=",_display_wid.p_help);
   if(_display_wid.p_mouse_pointer!=MP_DEFAULT) insert_line(substr('',1,indent)"p_mouse_pointer="eq_value2name(_display_wid.p_mouse_pointer,MP_LIST))
   insert_line(substr('',1,indent)"p_tab_index="_display_wid.p_tab_index)
   if (!_display_wid.p_visible) insert_line(substr('',1,indent)"p_visible="_bool2truefalse(_display_wid.p_visible))
   insert_line(substr('',1,indent)"p_width="_display_wid.p_width)
   insert_line(substr('',1,indent)"p_x="_display_wid.p_x)
   insert_line(substr('',1,indent)"p_y="_display_wid.p_y)
   insert_etabs(_display_wid,indent,form_name);
}
const
   LABEL_PROPS=' alignment auto_size backcolor border_style caption':+
               ' enabled eventtab eventtab2 font_bold font_italic font_name font_size':+
               ' font_underline forecolor height help mouse_pointer':+
               ' visible width word_wrap x y ';
static void _delabel_props()
{
   insert_line(" alignment\t"eq_value2name(_display_wid.p_alignment,AL_LIST))
   insert_line(" auto_size\t"_bool2truefalse(_display_wid.p_auto_size))
   insert_line(" backcolor\t"_format_color(_display_wid.p_backcolor))
   insert_line(" border_style\t"eq_value2name(_display_wid.p_border_style,BDS_LIST2))
   insert_line(" caption\t"_display_wid.p_caption)
   insert_line(" enabled\t"_bool2truefalse(_display_wid.p_enabled))
   insert_line(" eventtab\t"translate(name_name(_display_wid.p_eventtab),'_','-'))
   insert_line(" eventtab2\t"translate(name_name(_display_wid.p_eventtab2),'_','-'))
   insert_line(" font_bold\t"_bool2truefalse(_display_wid.p_font_bold))
   insert_line(" font_italic\t"_bool2truefalse(_display_wid.p_font_italic))
   insert_line(" font_name\t"_display_wid.p_font_name)
   insert_line(" font_size\t"_display_wid.p_font_size)
   insert_line(" font_underline\t"_bool2truefalse(_display_wid.p_font_underline))
   insert_line(" forecolor\t"_format_color(_display_wid.p_forecolor))
   insert_line(" help\t"_display_wid.p_help);
   insert_line(" height\t"_display_wid.p_height)
   insert_line(" mouse_pointer\t"eq_value2name(_display_wid.p_mouse_pointer,MP_LIST))
   insert_line(" name\t"_display_wid.p_name)
   insert_line(" tab_index\t"_display_wid.p_tab_index)
   insert_line(" visible\t"_bool2truefalse(_display_wid.p_visible))
   insert_line(" width\t"_display_wid.p_width)
   insert_line(" word_wrap\t"_bool2truefalse(_display_wid.p_word_wrap))
   insert_line(" x\t"_display_wid.p_x)
   insert_line(" y\t"_display_wid.p_y)
}
void _insert_label_props(_display_wid,indent,form_name)
{
   insert_line(substr('',1,indent)"p_alignment="eq_value2name(_display_wid.p_alignment,AL_LIST))
   insert_line(substr('',1,indent)"p_auto_size="_bool2truefalse(_display_wid.p_auto_size))
   insert_line(substr('',1,indent)"p_backcolor="_format_color(_display_wid.p_backcolor))
   insert_line(substr('',1,indent)"p_border_style="eq_value2name(_display_wid.p_border_style,BDS_LIST2))
   safe_insert_line(substr('',1,indent)"p_caption=",_display_wid.p_caption)
   if(!_display_wid.p_enabled) insert_line(substr('',1,indent)"p_enabled="_bool2truefalse(_display_wid.p_enabled))
   insert_line(substr('',1,indent)"p_font_bold="_bool2truefalse(_display_wid.p_font_bold))
   insert_line(substr('',1,indent)"p_font_italic="_bool2truefalse(_display_wid.p_font_italic))
   insert_line(substr('',1,indent)"p_font_name="_quote(_display_wid.p_font_name))
   insert_line(substr('',1,indent)"p_font_size="_display_wid.p_font_size)
   insert_line(substr('',1,indent)"p_font_underline="_bool2truefalse(_display_wid.p_font_underline))
   insert_line(substr('',1,indent)"p_forecolor="_format_color(_display_wid.p_forecolor))
   insert_line(substr('',1,indent)"p_height="_display_wid.p_height)
   if (_display_wid.p_help!='') safe_insert_line(substr('',1,indent)"p_help=",_display_wid.p_help);
   if(_display_wid.p_mouse_pointer!=MP_DEFAULT) insert_line(substr('',1,indent)"p_mouse_pointer="eq_value2name(_display_wid.p_mouse_pointer,MP_LIST))
   insert_line(substr('',1,indent)"p_tab_index="_display_wid.p_tab_index)
   if (!_display_wid.p_visible) insert_line(substr('',1,indent)"p_visible="_bool2truefalse(_display_wid.p_visible))
   insert_line(substr('',1,indent)"p_width="_display_wid.p_width)
   insert_line(substr('',1,indent)"p_word_wrap="_bool2truefalse(_display_wid.p_word_wrap))
   insert_line(substr('',1,indent)"p_x="_display_wid.p_x)
   insert_line(substr('',1,indent)"p_y="_display_wid.p_y)
   insert_etabs(_display_wid,indent,form_name);
}
const
      TREE_VIEW_PROPS=' AlwaysColorCurrent backcolor border_style CheckListBox CollapsePicture delay enabled ':+
                 'eventtab eventtab2 ExpandPicture font_bold':+
                 ' font_italic font_name font_size font_underline forecolor':+
                 ' height help LevelIndent mouse_pointer multi_select scroll_bars SpaceY ':+
                 ' ShowRoot tab_stop visible width x y ';
static void _detree_props()
{
   //insert_line(" auto_size\t"_bool2truefalse(_display_wid.p_auto_size))
   //insert_line(" backcolor\t"_format_color(_display_wid.p_backcolor))
   insert_line(" after_pic_indent_x\t"_display_wid.p_after_pic_indent_x);
   insert_line(" AlwaysColorCurrent\t"_bool2truefalse(_display_wid.p_AlwaysColorCurrent));
   insert_line(" border_style\t"eq_value2name(_display_wid.p_border_style,BDS_LIST))
   insert_line(" CheckListBox\t"_bool2truefalse(_display_wid.p_CheckListBox));
   insert_line(" CollapsePicture\t"name_name(_display_wid.p_CollapsePicture));
   insert_line(" delay\t"_display_wid.p_delay)
   insert_line(" enabled\t"_bool2truefalse(_display_wid.p_enabled))
   insert_line(" eventtab\t"translate(name_name(_display_wid.p_eventtab),'_','-'))
   insert_line(" eventtab2\t"translate(name_name(_display_wid.p_eventtab2),'_','-'))
   insert_line(" ExpandPicture\t"name_name(_display_wid.p_ExpandPicture));
   insert_line(" font_bold\t"_bool2truefalse(_display_wid.p_font_bold))
   insert_line(" font_italic\t"_bool2truefalse(_display_wid.p_font_italic))
   insert_line(" font_name\t"_display_wid.p_font_name)
   insert_line(" font_size\t"_display_wid.p_font_size)
   insert_line(" font_underline\t"_bool2truefalse(_display_wid.p_font_underline))
   //insert_line(" forecolor\t"_format_color(_display_wid.p_forecolor))
   insert_line(" height\t"_display_wid.p_height)
   insert_line(" help\t"_display_wid.p_help);
   insert_line(" LevelIndent\t"_display_wid.p_LevelIndent)
   insert_line(" LineStyle\t"eq_value2name(_display_wid.p_LineStyle,TREE_LINE_LIST))
   insert_line(" mouse_pointer\t"eq_value2name(_display_wid.p_mouse_pointer,MP_LIST))
   insert_line(" multi_select\t"eq_value2name(_display_wid.p_multi_select,MS_LIST))
   insert_line(" name\t"_display_wid.p_name)
   insert_line(" scroll_bars\t"eq_value2name(_display_wid.p_scroll_bars,SB_LIST))
   insert_line(" ShowRoot\t"_bool2truefalse(_display_wid.p_ShowRoot));
   insert_line(" SpaceY\t"_display_wid.p_SpaceY);
   insert_line(" tab_index\t"_display_wid.p_tab_index)
   insert_line(" tab_stop\t"_bool2truefalse(_display_wid.p_tab_stop))
   insert_line(" visible\t"_bool2truefalse(_display_wid.p_visible))
   insert_line(" width\t"_display_wid.p_width)
   insert_line(" x\t"_display_wid.p_x)
   insert_line(" y\t"_display_wid.p_y)
}
void _insert_tree_props(_display_wid,indent,form_name)
{
   //insert_line(substr('',1,indent)"p_auto_size="_bool2truefalse(_display_wid.p_auto_size))
   insert_line(substr('',1,indent)"p_after_pic_indent_x="_display_wid.p_after_pic_indent_x);
   insert_line(substr('',1,indent)"p_backcolor="_format_color(_display_wid.p_backcolor))
   insert_line(substr('',1,indent)"p_border_style="eq_value2name(_display_wid.p_border_style,BDS_LIST))
   insert_line(substr('',1,indent)"p_CheckListBox="_bool2truefalse(_display_wid.p_CheckListBox))
   insert_line(substr('',1,indent)"p_CollapsePicture="_quote(name_name(_display_wid.p_CollapsePicture)))
   insert_line(substr('',1,indent)"p_delay="_display_wid.p_delay);
   if(!_display_wid.p_enabled) insert_line(substr('',1,indent)"p_enabled="_bool2truefalse(_display_wid.p_enabled));
   insert_line(substr('',1,indent)"p_ExpandPicture="_quote(name_name(_display_wid.p_ExpandPicture)))
   insert_line(substr('',1,indent)"p_font_bold="_bool2truefalse(_display_wid.p_font_bold))
   insert_line(substr('',1,indent)"p_font_italic="_bool2truefalse(_display_wid.p_font_italic))
   insert_line(substr('',1,indent)"p_font_name="_quote(_display_wid.p_font_name))
   insert_line(substr('',1,indent)"p_font_size="_display_wid.p_font_size)
   insert_line(substr('',1,indent)"p_font_underline="_bool2truefalse(_display_wid.p_font_underline))
   insert_line(substr('',1,indent)"p_forecolor="_format_color(_display_wid.p_forecolor))
   insert_line(substr('',1,indent)"p_height="_display_wid.p_height)
   if (_display_wid.p_help!='') safe_insert_line(substr('',1,indent)"p_help=",_display_wid.p_help);
   insert_line(substr('',1,indent)"p_LevelIndent="_display_wid.p_LevelIndent);
   insert_line(substr('',1,indent)"p_LineStyle="eq_value2name(_display_wid.p_LineStyle,TREE_LINE_LIST));
   if(_display_wid.p_mouse_pointer!=MP_DEFAULT) insert_line(substr('',1,indent)"p_mouse_pointer="eq_value2name(_display_wid.p_mouse_pointer,MP_LIST));
   insert_line(substr('',1,indent)"p_multi_select="eq_value2name(_display_wid.p_multi_select,MS_LIST))
#if 0
   if (_display_wid.p_picture) {
      insert_line(substr('',1,indent)"p_picture="_quote(name_name(_display_wid.p_picture)))
      insert_line(substr('',1,indent)"p_pic_space_y="_display_wid.p_pic_space_y)
      insert_line(substr('',1,indent)"p_pic_point_scale="_display_wid.p_pic_point_scale)
   }
#endif
   insert_line(substr('',1,indent)"p_ShowRoot="_bool2truefalse(_display_wid.p_ShowRoot))
   insert_line(substr('',1,indent)"p_AlwaysColorCurrent="_bool2truefalse(_display_wid.p_AlwaysColorCurrent))
   insert_line(substr('',1,indent)"p_SpaceY="_display_wid.p_SpaceY)
   insert_line(substr('',1,indent)"p_scroll_bars="eq_value2name(_display_wid.p_scroll_bars,SB_LIST))
   insert_line(substr('',1,indent)"p_tab_index="_display_wid.p_tab_index)
   insert_line(substr('',1,indent)"p_tab_stop="_bool2truefalse(_display_wid.p_tab_stop))
   if (!_display_wid.p_visible) insert_line(substr('',1,indent)"p_visible="_bool2truefalse(_display_wid.p_visible))
   insert_line(substr('',1,indent)"p_width="_display_wid.p_width)
   insert_line(substr('',1,indent)"p_x="_display_wid.p_x)
   insert_line(substr('',1,indent)"p_y="_display_wid.p_y)
   insert_etabs(_display_wid,indent,form_name);
}

const
   LIST_BOX_PROPS=' auto_size backcolor border_style enabled eventtab eventtab2 font_bold':+
              ' font_italic font_name font_size font_underline forecolor':+
              ' height help mouse_pointer multi_select scroll_bars tab_stop visible':+
              ' width x y ';
static void _delist_props()
{
   insert_line(" auto_size\t"_bool2truefalse(_display_wid.p_auto_size))
   insert_line(" backcolor\t"_format_color(_display_wid.p_backcolor))
   insert_line(" border_style\t"eq_value2name(_display_wid.p_border_style,BDS_LIST))
   insert_line(" enabled\t"_bool2truefalse(_display_wid.p_enabled))
   insert_line(" eventtab\t"translate(name_name(_display_wid.p_eventtab),'_','-'))
   insert_line(" eventtab2\t"translate(name_name(_display_wid.p_eventtab2),'_','-'))
   insert_line(" font_bold\t"_bool2truefalse(_display_wid.p_font_bold))
   insert_line(" font_italic\t"_bool2truefalse(_display_wid.p_font_italic))
   insert_line(" font_name\t"_display_wid.p_font_name)
   insert_line(" font_size\t"_display_wid.p_font_size)
   insert_line(" font_underline\t"_bool2truefalse(_display_wid.p_font_underline))
   insert_line(" forecolor\t"_format_color(_display_wid.p_forecolor))
   insert_line(" height\t"_display_wid.p_height)
   insert_line(" help\t"_display_wid.p_help);
   insert_line(" mouse_pointer\t"eq_value2name(_display_wid.p_mouse_pointer,MP_LIST))
   insert_line(" multi_select\t"eq_value2name(_display_wid.p_multi_select,MS_LIST))
   insert_line(" name\t"_display_wid.p_name)
   insert_line(" scroll_bars\t"eq_value2name(_display_wid.p_scroll_bars,SB_LIST))
   insert_line(" tab_index\t"_display_wid.p_tab_index)
   insert_line(" tab_stop\t"_bool2truefalse(_display_wid.p_tab_stop))
   insert_line(" visible\t"_bool2truefalse(_display_wid.p_visible))
   insert_line(" width\t"_display_wid.p_width)
   insert_line(" x\t"_display_wid.p_x)
   insert_line(" y\t"_display_wid.p_y)
}
void _insert_list_props(_display_wid,indent,form_name)
{
   insert_line(substr('',1,indent)"p_auto_size="_bool2truefalse(_display_wid.p_auto_size))
   insert_line(substr('',1,indent)"p_backcolor="_format_color(_display_wid.p_backcolor))
   insert_line(substr('',1,indent)"p_border_style="eq_value2name(_display_wid.p_border_style,BDS_LIST))
   if(!_display_wid.p_enabled) insert_line(substr('',1,indent)"p_enabled="_bool2truefalse(_display_wid.p_enabled))
   insert_line(substr('',1,indent)"p_font_bold="_bool2truefalse(_display_wid.p_font_bold))
   insert_line(substr('',1,indent)"p_font_italic="_bool2truefalse(_display_wid.p_font_italic))
   insert_line(substr('',1,indent)"p_font_name="_quote(_display_wid.p_font_name))
   insert_line(substr('',1,indent)"p_font_size="_display_wid.p_font_size)
   insert_line(substr('',1,indent)"p_font_underline="_bool2truefalse(_display_wid.p_font_underline))
   insert_line(substr('',1,indent)"p_forecolor="_format_color(_display_wid.p_forecolor))
   insert_line(substr('',1,indent)"p_height="_display_wid.p_height)
   if (_display_wid.p_help!='') safe_insert_line(substr('',1,indent)"p_help=",_display_wid.p_help);
   if(_display_wid.p_mouse_pointer!=MP_DEFAULT) insert_line(substr('',1,indent)"p_mouse_pointer="eq_value2name(_display_wid.p_mouse_pointer,MP_LIST))
   insert_line(substr('',1,indent)"p_multi_select="eq_value2name(_display_wid.p_multi_select,MS_LIST))
   if (_display_wid.p_picture) {
      insert_line(substr('',1,indent)"p_picture="_quote(name_name(_display_wid.p_picture)))
      insert_line(substr('',1,indent)"p_pic_space_y="_display_wid.p_pic_space_y)
      insert_line(substr('',1,indent)"p_pic_point_scale="_display_wid.p_pic_point_scale)
   }
   insert_line(substr('',1,indent)"p_scroll_bars="eq_value2name(_display_wid.p_scroll_bars,SB_LIST))
   insert_line(substr('',1,indent)"p_tab_index="_display_wid.p_tab_index)
   insert_line(substr('',1,indent)"p_tab_stop="_bool2truefalse(_display_wid.p_tab_stop))
   if (!_display_wid.p_visible) insert_line(substr('',1,indent)"p_visible="_bool2truefalse(_display_wid.p_visible))
   insert_line(substr('',1,indent)"p_width="_display_wid.p_width)
   insert_line(substr('',1,indent)"p_x="_display_wid.p_x)
   insert_line(substr('',1,indent)"p_y="_display_wid.p_y)
   insert_etabs(_display_wid,indent,form_name);
}


const
   EDITOR_PROPS=' auto_size backcolor border_style enabled eventtab eventtab2 font_bold':+
              ' font_italic font_name font_size font_underline forecolor':+
              ' height help mouse_pointer scroll_bars tab_stop visible':+
              ' width x y ';
static void _deeditor_props()
{
   insert_line(" auto_size\t"_bool2truefalse(_display_wid.p_auto_size))
   insert_line(" backcolor\t"_format_color(_display_wid.p_backcolor))
   insert_line(" border_style\t"eq_value2name(_display_wid.p_border_style,BDS_LIST))
   insert_line(" enabled\t"_bool2truefalse(_display_wid.p_enabled))
   insert_line(" eventtab\t"translate(name_name(_display_wid.p_eventtab),'_','-'))
   insert_line(" eventtab2\t"translate(name_name(_display_wid.p_eventtab2),'_','-'))
   insert_line(" height\t"_display_wid.p_height)
   insert_line(" help\t"_display_wid.p_help);
   insert_line(" mouse_pointer\t"eq_value2name(_display_wid.p_mouse_pointer,MP_LIST))
   insert_line(" name\t"_display_wid.p_name)
   insert_line(" scroll_bars\t"eq_value2name(_display_wid.p_scroll_bars,SB_LIST))
   insert_line(" tab_index\t"_display_wid.p_tab_index)
   insert_line(" tab_stop\t"_bool2truefalse(_display_wid.p_tab_stop))
   insert_line(" visible\t"_bool2truefalse(_display_wid.p_visible))
   insert_line(" width\t"_display_wid.p_width)
   insert_line(" x\t"_display_wid.p_x)
   insert_line(" y\t"_display_wid.p_y)
}
void _insert_editor_props(_display_wid,indent,form_name)
{
   insert_line(substr('',1,indent)"p_auto_size="_bool2truefalse(_display_wid.p_auto_size))
   insert_line(substr('',1,indent)"p_backcolor="_format_color(_display_wid.p_backcolor))
   insert_line(substr('',1,indent)"p_border_style="eq_value2name(_display_wid.p_border_style,BDS_LIST))
   if(!_display_wid.p_enabled) insert_line(substr('',1,indent)"p_enabled="_bool2truefalse(_display_wid.p_enabled))
   insert_line(substr('',1,indent)"p_height="_display_wid.p_height)
   if (_display_wid.p_help!='') safe_insert_line(substr('',1,indent)"p_help=",_display_wid.p_help);
   if(_display_wid.p_mouse_pointer!=MP_DEFAULT) insert_line(substr('',1,indent)"p_mouse_pointer="eq_value2name(_display_wid.p_mouse_pointer,MP_LIST))
   if (_display_wid.p_picture) {
      insert_line(substr('',1,indent)"p_picture="_quote(name_name(_display_wid.p_picture)))
      insert_line(substr('',1,indent)"p_pic_space_y="_display_wid.p_pic_space_y)
      insert_line(substr('',1,indent)"p_pic_point_scale="_display_wid.p_pic_point_scale)
   }
   insert_line(substr('',1,indent)"p_scroll_bars="eq_value2name(_display_wid.p_scroll_bars,SB_LIST))
   insert_line(substr('',1,indent)"p_tab_index="_display_wid.p_tab_index)
   insert_line(substr('',1,indent)"p_tab_stop="_bool2truefalse(_display_wid.p_tab_stop))
   if (!_display_wid.p_visible) insert_line(substr('',1,indent)"p_visible="_bool2truefalse(_display_wid.p_visible))
   insert_line(substr('',1,indent)"p_width="_display_wid.p_width)
   insert_line(substr('',1,indent)"p_x="_display_wid.p_x)
   insert_line(substr('',1,indent)"p_y="_display_wid.p_y)
   insert_etabs(_display_wid,indent,form_name);
}
const
   COMBO_BOX_PROPS=' backcolor completion enabled eventtab eventtab2 font_bold font_italic font_name':+
             ' font_size font_underline forecolor height help mouse_pointer':+
             ' tab_stop text visible width x y ';
static void _decombo_props()
{
   insert_line(" auto_size\t"_bool2truefalse(_display_wid.p_auto_size))
   insert_line(" backcolor\t"_format_color(_display_wid.p_backcolor))
   insert_line(" case_sensitive\t"_bool2truefalse(_display_wid.p_case_sensitive))
   insert_line(" completion\t"cp_value2name(_display_wid.p_completion))
   insert_line(" enabled\t"_bool2truefalse(_display_wid.p_enabled))
   insert_line(" eventtab\t"translate(name_name(_display_wid.p_eventtab),'_','-'))
   insert_line(" eventtab2\t"translate(name_name(_display_wid.p_eventtab2),'_','-'))
   insert_line(" font_bold\t"_bool2truefalse(_display_wid.p_font_bold))
   insert_line(" font_italic\t"_bool2truefalse(_display_wid.p_font_italic))
   insert_line(" font_name\t"_display_wid.p_font_name)
   insert_line(" font_size\t"_display_wid.p_font_size)
   insert_line(" font_underline\t"_bool2truefalse(_display_wid.p_font_underline))
   insert_line(" forecolor\t"_format_color(_display_wid.p_forecolor))
   insert_line(" height\t"_display_wid.p_height)
   insert_line(" help\t"_display_wid.p_help);
   insert_line(" mouse_pointer\t"eq_value2name(_display_wid.p_mouse_pointer,MP_LIST))
   insert_line(" name\t"_display_wid.p_name)
   insert_line(" style\t"eq_value2name(_display_wid.p_style,PSCBO_LIST))
   insert_line(" tab_index\t"_display_wid.p_tab_index)
   insert_line(" tab_stop\t"_bool2truefalse(_display_wid.p_tab_stop))
   insert_line(" text\t"_display_wid.p_text)
   //insert_line(" validate_style\t"eq_value2name(_display_wid.p_validate_style,VS_LIST))
   insert_line(" visible\t"_bool2truefalse(_display_wid.p_visible))
   insert_line(" width\t"_display_wid.p_width)
   insert_line(" x\t"_display_wid.p_x)
   insert_line(" y\t"_display_wid.p_y)
}
void _insert_combo_props(_display_wid,indent,form_name)
{
   insert_line(substr('',1,indent)"p_auto_size="_bool2truefalse(_display_wid.p_auto_size))
   insert_line(substr('',1,indent)"p_backcolor="_format_color(_display_wid.p_backcolor))
   insert_line(substr('',1,indent)"p_case_sensitive="_bool2truefalse(_display_wid.p_case_sensitive))
   insert_line(substr('',1,indent)"p_completion="cp_value2name(_display_wid.p_completion))
   if(!_display_wid.p_enabled) insert_line(substr('',1,indent)"p_enabled="_bool2truefalse(_display_wid.p_enabled))
   insert_line(substr('',1,indent)"p_font_bold="_bool2truefalse(_display_wid.p_font_bold))
   insert_line(substr('',1,indent)"p_font_italic="_bool2truefalse(_display_wid.p_font_italic))
   insert_line(substr('',1,indent)"p_font_name="_quote(_display_wid.p_font_name))
   insert_line(substr('',1,indent)"p_font_size="_display_wid.p_font_size)
   insert_line(substr('',1,indent)"p_font_underline="_bool2truefalse(_display_wid.p_font_underline))
   insert_line(substr('',1,indent)"p_forecolor="_format_color(_display_wid.p_forecolor))
   insert_line(substr('',1,indent)"p_height="_display_wid.p_height)
   if (_display_wid.p_help!='') safe_insert_line(substr('',1,indent)"p_help=",_display_wid.p_help);
   if(_display_wid.p_mouse_pointer!=MP_DEFAULT) insert_line(substr('',1,indent)"p_mouse_pointer="eq_value2name(_display_wid.p_mouse_pointer,MP_LIST))
   insert_line(substr('',1,indent)"p_style="eq_value2name(_display_wid.p_style,PSCBO_LIST))
   insert_line(substr('',1,indent)"p_tab_index="_display_wid.p_tab_index)
   insert_line(substr('',1,indent)"p_tab_stop="_bool2truefalse(_display_wid.p_tab_stop))
   if (_display_wid.p_text:!='') insert_line(substr('',1,indent)"p_text="_quote(_display_wid.p_text))
   //insert_line(substr('',1,indent)"p_validate_style="eq_value2name(_display_wid.p_validate_style,VS_LIST))
   if (!_display_wid.p_visible) insert_line(substr('',1,indent)"p_visible="_bool2truefalse(_display_wid.p_visible))
   insert_line(substr('',1,indent)"p_width="_display_wid.p_width)
   insert_line(substr('',1,indent)"p_x="_display_wid.p_x)
   insert_line(substr('',1,indent)"p_y="_display_wid.p_y)
   insert_etabs(_display_wid,indent,form_name);
}
#define IMAGE_BUTTON 1
const
   IMAGE_PROPS=' auto_size backcolor border_style caption command enabled eventtab eventtab2':+
#if IMAGE_BUTTON
               ' font_bold font_italic font_name font_size font_underline ':+
               ' height max_click message mouse_pointer Nofstates picture stretch value visible':+
#else
               ' height max_click message mouse_pointer Nofstates picture stretch value visible':+
#endif
               ' width x y ';
static void _deimage_props()
{
   insert_line(" auto_size\t"_bool2truefalse(_display_wid.p_auto_size))
   insert_line(" backcolor\t"_format_color(_display_wid.p_backcolor))
   insert_line(" border_style\t"eq_value2name(_display_wid.p_border_style,BDS_LIST))
#if IMAGE_BUTTON
   insert_line(" caption\t"_display_wid.p_caption)
#endif
   insert_line(" command\t"_display_wid.p_command)
   insert_line(" enabled\t"_bool2truefalse(_display_wid.p_enabled))
   insert_line(" eventtab\t"translate(name_name(_display_wid.p_eventtab),'_','-'))
   insert_line(" eventtab2\t"translate(name_name(_display_wid.p_eventtab2),'_','-'))
#if IMAGE_BUTTON
   insert_line(" font_bold\t"_bool2truefalse(_display_wid.p_font_bold))
   insert_line(" font_italic\t"_bool2truefalse(_display_wid.p_font_italic))
   insert_line(" font_name\t"_display_wid.p_font_name)
   insert_line(" font_size\t"_display_wid.p_font_size)
   insert_line(" font_underline\t"_bool2truefalse(_display_wid.p_font_underline))
#endif
   insert_line(" height\t"_display_wid.p_height)
   insert_line(" help\t"_display_wid.p_help);
   insert_line(" max_click\t"eq_value2name(_display_wid.p_max_click,MC_LIST))
   insert_line(" message\t"_display_wid.p_message)
   insert_line(" mouse_pointer\t"eq_value2name(_display_wid.p_mouse_pointer,MP_LIST))
   insert_line(" name\t"_display_wid.p_name)
   insert_line(" Nofstates\t"_display_wid.p_Nofstates)
   insert_line(" picture\t"name_name(_display_wid.p_picture))
   insert_line(" stretch\t"_bool2truefalse(_display_wid.p_stretch))
   insert_line(" style\t"eq_value2name(_display_wid.p_style,PSIMG_LIST))
   insert_line(" tab_index\t"_display_wid.p_tab_index)
#if 0 
   insert_line(" tab_stop\t"_bool2truefalse(_display_wid.p_tab_stop))
#endif
   insert_line(" value\t"_display_wid.p_value)
   insert_line(" visible\t"_bool2truefalse(_display_wid.p_visible))
   insert_line(" width\t"_display_wid.p_width)
   insert_line(" x\t"_display_wid.p_x)
   insert_line(" y\t"_display_wid.p_y)
}
void _insert_image_props(_display_wid,indent,form_name)
{
   insert_line(substr('',1,indent)"p_auto_size="_bool2truefalse(_display_wid.p_auto_size))
   insert_line(substr('',1,indent)"p_backcolor="_format_color(_display_wid.p_backcolor))
   insert_line(substr('',1,indent)"p_border_style="eq_value2name(_display_wid.p_border_style,BDS_LIST))
#if IMAGE_BUTTON
   if (_display_wid.p_caption!="") {
      safe_insert_line(substr('',1,indent)"p_caption=",_display_wid.p_caption)
   }
#endif
   if (_display_wid.p_command!='') insert_line(substr('',1,indent)"p_command="_quote(_display_wid.p_command))
   if(!_display_wid.p_enabled) insert_line(substr('',1,indent)"p_enabled="_bool2truefalse(_display_wid.p_enabled))
#if IMAGE_BUTTON
   if (_display_wid.p_font_bold) {
      insert_line(substr('',1,indent)"p_font_bold="_bool2truefalse(_display_wid.p_font_bold))
   }
   if (_display_wid.p_font_italic) {
      insert_line(substr('',1,indent)"p_font_italic="_bool2truefalse(_display_wid.p_font_italic))
   }
   if (_display_wid.p_font_name!="" && _display_wid.p_font_name!="MS Sans Serif") {
      insert_line(substr('',1,indent)"p_font_name="_quote(_display_wid.p_font_name))
   }
   if (_display_wid.p_font_size!=8) {
      insert_line(substr('',1,indent)"p_font_size="_display_wid.p_font_size)
   }
   if (_display_wid.p_font_underline) {
      insert_line(substr('',1,indent)"p_font_underline="_bool2truefalse(_display_wid.p_font_underline))
   }
#endif
   insert_line(substr('',1,indent)"p_height="_display_wid.p_height)
   if (_display_wid.p_help!='') safe_insert_line(substr('',1,indent)"p_help=",_display_wid.p_help);
   insert_line(substr('',1,indent)"p_max_click="eq_value2name(_display_wid.p_max_click,MC_LIST))
   if (_display_wid.p_message!='') insert_line(substr('',1,indent)"p_message="_quote(_display_wid.p_message))
   if(_display_wid.p_mouse_pointer!=MP_DEFAULT) insert_line(substr('',1,indent)"p_mouse_pointer="eq_value2name(_display_wid.p_mouse_pointer,MP_LIST))
   insert_line(substr('',1,indent)"p_Nofstates="_display_wid.p_Nofstates)
   insert_line(substr('',1,indent)"p_picture="_quote(name_name(_display_wid.p_picture)))
   insert_line(substr('',1,indent)"p_stretch="_bool2truefalse(_display_wid.p_stretch))
   insert_line(substr('',1,indent)"p_style="eq_value2name(_display_wid.p_style,PSIMG_LIST))
   insert_line(substr('',1,indent)"p_tab_index="_display_wid.p_tab_index)
#if 0
   insert_line(substr('',1,indent)"p_tab_stop="_bool2truefalse(_display_wid.p_tab_stop))
#endif
   insert_line(substr('',1,indent)"p_value="_display_wid.p_value)
   if (!_display_wid.p_visible) insert_line(substr('',1,indent)"p_visible="_bool2truefalse(_display_wid.p_visible))
   insert_line(substr('',1,indent)"p_width="_display_wid.p_width)
   insert_line(substr('',1,indent)"p_x="_display_wid.p_x)
   insert_line(substr('',1,indent)"p_y="_display_wid.p_y)
   insert_etabs(_display_wid,indent,form_name);
}
const
   PICTURE_BOX_PROPS=' auto_size backcolor border_style clip_controls command':+
            ' enabled eventtab eventtab2 forecolor height help max_click message mouse_pointer Nofstates picture':+
            ' stretch value visible width x y ';
static void _depicture_props()
{
   insert_line(" auto_size\t"_bool2truefalse(_display_wid.p_auto_size))
   insert_line(" backcolor\t"_format_color(_display_wid.p_backcolor))
   insert_line(" border_style\t"eq_value2name(_display_wid.p_border_style,BDS_LIST))
   insert_line(" clip_controls\t"_bool2truefalse(_display_wid.p_clip_controls))
   insert_line(" command\t"_display_wid.p_command)
   insert_line(" enabled\t"_bool2truefalse(_display_wid.p_enabled))
   insert_line(" eventtab\t"translate(name_name(_display_wid.p_eventtab),'_','-'))
   insert_line(" eventtab2\t"translate(name_name(_display_wid.p_eventtab2),'_','-'))
   insert_line(" forecolor\t"_format_color(_display_wid.p_forecolor))
   insert_line(" height\t"_display_wid.p_height)
   insert_line(" help\t"_display_wid.p_help);
   insert_line(" max_click\t"eq_value2name(_display_wid.p_max_click,MC_LIST))
   insert_line(" message\t"_display_wid.p_message)
   insert_line(" mouse_pointer\t"eq_value2name(_display_wid.p_mouse_pointer,MP_LIST))
   insert_line(" name\t"_display_wid.p_name)
   insert_line(" Nofstates\t"_display_wid.p_Nofstates)
   insert_line(" picture\t"name_name(_display_wid.p_picture))
   insert_line(" stretch\t"_bool2truefalse(_display_wid.p_stretch))
   insert_line(" style\t"eq_value2name(_display_wid.p_style,PSPIC_LIST))
   insert_line(" tab_index\t"_display_wid.p_tab_index)
   insert_line(" value\t"_display_wid.p_value)
   insert_line(" visible\t"_bool2truefalse(_display_wid.p_visible))
   insert_line(" width\t"_display_wid.p_width)
   insert_line(" x\t"_display_wid.p_x)
   insert_line(" y\t"_display_wid.p_y)
}
void _insert_picture_props(_display_wid,indent,form_name)
{
   insert_line(substr('',1,indent)"p_auto_size="_bool2truefalse(_display_wid.p_auto_size))
   insert_line(substr('',1,indent)"p_backcolor="_format_color(_display_wid.p_backcolor))
   insert_line(substr('',1,indent)"p_border_style="eq_value2name(_display_wid.p_border_style,BDS_LIST))
   insert_line(substr('',1,indent)"p_clip_controls="_bool2truefalse(_display_wid.p_clip_controls))
   if (_display_wid.p_command!='') insert_line(substr('',1,indent)"p_command="_quote(_display_wid.p_command))
   if(!_display_wid.p_enabled) insert_line(substr('',1,indent)"p_enabled="_bool2truefalse(_display_wid.p_enabled))
   insert_line(substr('',1,indent)"p_forecolor="_format_color(_display_wid.p_forecolor))
   insert_line(substr('',1,indent)"p_height="_display_wid.p_height)
   if (_display_wid.p_help!='') safe_insert_line(substr('',1,indent)"p_help=",_display_wid.p_help);
   insert_line(substr('',1,indent)"p_max_click="eq_value2name(_display_wid.p_max_click,MC_LIST))
   if (_display_wid.p_message!='') insert_line(substr('',1,indent)"p_message="_quote(_display_wid.p_message))
   if(_display_wid.p_mouse_pointer!=MP_DEFAULT) insert_line(substr('',1,indent)"p_mouse_pointer="eq_value2name(_display_wid.p_mouse_pointer,MP_LIST))
   insert_line(substr('',1,indent)"p_Nofstates="_display_wid.p_Nofstates)
   insert_line(substr('',1,indent)"p_picture="_quote(name_name(_display_wid.p_picture)))
   insert_line(substr('',1,indent)"p_stretch="_bool2truefalse(_display_wid.p_stretch))
   insert_line(substr('',1,indent)"p_style="eq_value2name(_display_wid.p_style,PSPIC_LIST))
   insert_line(substr('',1,indent)"p_tab_index="_display_wid.p_tab_index)
   insert_line(substr('',1,indent)"p_value="_display_wid.p_value)
   if (!_display_wid.p_visible) insert_line(substr('',1,indent)"p_visible="_bool2truefalse(_display_wid.p_visible))
   insert_line(substr('',1,indent)"p_width="_display_wid.p_width)
   insert_line(substr('',1,indent)"p_x="_display_wid.p_x)
   insert_line(substr('',1,indent)"p_y="_display_wid.p_y)
   insert_etabs(_display_wid,indent,form_name);
}
const
   SCROLL_BAR_PROPS=' auto_size enabled eventtab eventtab2 height help large_change max min':+
                    ' mouse_pointer small_change tab_stop value visible width x y ';
static void _descroll_props()
{
   insert_line(" auto_size\t"_bool2truefalse(_display_wid.p_auto_size))
   insert_line(" enabled\t"_bool2truefalse(_display_wid.p_enabled))
   insert_line(" eventtab\t"translate(name_name(_display_wid.p_eventtab),'_','-'))
   insert_line(" eventtab2\t"translate(name_name(_display_wid.p_eventtab2),'_','-'))
   insert_line(" height\t"_display_wid.p_height)
   insert_line(" help\t"_display_wid.p_help);
   insert_line(" large_change\t"_display_wid.p_large_change)
   insert_line(" max\t"_display_wid.p_max)
   insert_line(" min\t"_display_wid.p_min)
   insert_line(" mouse_pointer\t"eq_value2name(_display_wid.p_mouse_pointer,MP_LIST))
   insert_line(" name\t"_display_wid.p_name)
   insert_line(" small_change\t"_display_wid.p_small_change)
   insert_line(" tab_index\t"_display_wid.p_tab_index)
   insert_line(" tab_stop\t"_bool2truefalse(_display_wid.p_tab_stop))
   insert_line(" value\t"_display_wid.p_value)
   insert_line(" visible\t"_bool2truefalse(_display_wid.p_visible))
   insert_line(" width\t"_display_wid.p_width)
   insert_line(" x\t"_display_wid.p_x)
   insert_line(" y\t"_display_wid.p_y)
}
void _insert_scroll_props(_display_wid,indent,form_name)
{
   insert_line(substr('',1,indent)"p_auto_size="_bool2truefalse(_display_wid.p_auto_size))
   if(!_display_wid.p_enabled) insert_line(substr('',1,indent)"p_enabled="_bool2truefalse(_display_wid.p_enabled))
   insert_line(substr('',1,indent)"p_height="_display_wid.p_height)
   if (_display_wid.p_help!='') safe_insert_line(substr('',1,indent)"p_help=",_display_wid.p_help);
   insert_line(substr('',1,indent)"p_large_change="_display_wid.p_large_change)
   insert_line(substr('',1,indent)"p_max="_display_wid.p_max)
   insert_line(substr('',1,indent)"p_min="_display_wid.p_min)
   if(_display_wid.p_mouse_pointer!=MP_DEFAULT) insert_line(substr('',1,indent)"p_mouse_pointer="eq_value2name(_display_wid.p_mouse_pointer,MP_LIST))
   insert_line(substr('',1,indent)"p_small_change="_display_wid.p_small_change)
   insert_line(substr('',1,indent)"p_tab_index="_display_wid.p_tab_index)
   insert_line(substr('',1,indent)"p_tab_stop="_bool2truefalse(_display_wid.p_tab_stop))
   insert_line(substr('',1,indent)"p_value="_display_wid.p_value)
   if (!_display_wid.p_visible) insert_line(substr('',1,indent)"p_visible="_bool2truefalse(_display_wid.p_visible))
   insert_line(substr('',1,indent)"p_width="_display_wid.p_width)
   insert_line(substr('',1,indent)"p_x="_display_wid.p_x)
   insert_line(substr('',1,indent)"p_y="_display_wid.p_y)
   insert_etabs(_display_wid,indent,form_name);
}
const
   GAUGE_PROPS=' backcolor enabled eventtab eventtab2 forecolor height help max min mouse_pointer':+
               ' tab_stop value visible width x y ';
static void _degauge_props()
{
   //insert_line(" auto_size\t"_bool2truefalse(_display_wid.p_auto_size))
   insert_line(" backcolor\t"_format_color(_display_wid.p_backcolor))
   insert_line(" enabled\t"_bool2truefalse(_display_wid.p_enabled))
   insert_line(" eventtab\t"translate(name_name(_display_wid.p_eventtab),'_','-'))
   insert_line(" eventtab2\t"translate(name_name(_display_wid.p_eventtab2),'_','-'))
   insert_line(" forecolor\t"_format_color(_display_wid.p_forecolor))
   insert_line(" height\t"_display_wid.p_height)
   insert_line(" help\t"_display_wid.p_help);
   insert_line(" max\t"_display_wid.p_max)
   insert_line(" min\t"_display_wid.p_min)
   insert_line(" mouse_pointer\t"eq_value2name(_display_wid.p_mouse_pointer,MP_LIST))
   insert_line(" name\t"_display_wid.p_name)
   insert_line(" style\t"eq_value2name(_display_wid.p_style,PSGA_LIST))
   insert_line(" tab_index\t"_display_wid.p_tab_index)
   insert_line(" tab_stop\t"_bool2truefalse(_display_wid.p_tab_stop))
   insert_line(" value\t"_display_wid.p_value)
   insert_line(" visible\t"_bool2truefalse(_display_wid.p_visible))
   insert_line(" width\t"_display_wid.p_width)
   insert_line(" x\t"_display_wid.p_x)
   insert_line(" y\t"_display_wid.p_y)
}
void _insert_gauge_props(_display_wid,indent,form_name)
{
   //insert_line(substr('',1,indent)"p_auto_size="_bool2truefalse(_display_wid.p_auto_size))
   insert_line(substr('',1,indent)"p_backcolor="_format_color(_display_wid.p_backcolor))
   if(!_display_wid.p_enabled) insert_line(substr('',1,indent)"p_enabled="_bool2truefalse(_display_wid.p_enabled))
   insert_line(substr('',1,indent)"p_forecolor="_format_color(_display_wid.p_forecolor))
   insert_line(substr('',1,indent)"p_height="_display_wid.p_height)
   if (_display_wid.p_help!='') safe_insert_line(substr('',1,indent)"p_help=",_display_wid.p_help);
   insert_line(substr('',1,indent)"p_max="_display_wid.p_max)
   insert_line(substr('',1,indent)"p_min="_display_wid.p_min)
   if(_display_wid.p_mouse_pointer!=MP_DEFAULT) insert_line(substr('',1,indent)"p_mouse_pointer="eq_value2name(_display_wid.p_mouse_pointer,MP_LIST))
   insert_line(substr('',1,indent)"p_style="eq_value2name(_display_wid.p_style,PSGA_LIST))
   insert_line(substr('',1,indent)"p_tab_index="_display_wid.p_tab_index)
   insert_line(substr('',1,indent)"p_tab_stop="_bool2truefalse(_display_wid.p_tab_stop))
   insert_line(substr('',1,indent)"p_value="_display_wid.p_value)
   if (!_display_wid.p_visible) insert_line(substr('',1,indent)"p_visible="_bool2truefalse(_display_wid.p_visible))
   insert_line(substr('',1,indent)"p_width="_display_wid.p_width)
   insert_line(substr('',1,indent)"p_x="_display_wid.p_x)
   insert_line(substr('',1,indent)"p_y="_display_wid.p_y)
   insert_etabs(_display_wid,indent,form_name);
}
const
   SPIN_PROPS=' backcolor delay enabled eventtab eventtab2 forecolor height help increment':+
              ' max min mouse_pointer visible width x y ';
static void _despin_props()
{
   insert_line(" backcolor\t"_format_color(_display_wid.p_backcolor))
   insert_line(" delay\t"_display_wid.p_delay)
   insert_line(" enabled\t"_bool2truefalse(_display_wid.p_enabled))
   insert_line(" eventtab\t"translate(name_name(_display_wid.p_eventtab),'_','-'))
   insert_line(" eventtab2\t"translate(name_name(_display_wid.p_eventtab2),'_','-'))
   insert_line(" forecolor\t"_format_color(_display_wid.p_forecolor))
   insert_line(" height\t"_display_wid.p_height)
   insert_line(" help\t"_display_wid.p_help);
   insert_line(" increment\t"_display_wid.p_increment)
   insert_line(" max\t"_display_wid.p_max)
   insert_line(" min\t"_display_wid.p_min)
   insert_line(" mouse_pointer\t"eq_value2name(_display_wid.p_mouse_pointer,MP_LIST))
   insert_line(" name\t"_display_wid.p_name)
   //insert_line(" style\t"eq_value2name(_display_wid.p_style,PSSP_LIST))
   insert_line(" tab_index\t"_display_wid.p_tab_index)
   //insert_line(" tab_stop\t"_bool2truefalse(_display_wid.p_tab_stop))
   insert_line(" visible\t"_bool2truefalse(_display_wid.p_visible))
   insert_line(" width\t"_display_wid.p_width)
   insert_line(" x\t"_display_wid.p_x)
   insert_line(" y\t"_display_wid.p_y)
}
void _insert_spin_props(_display_wid,indent,form_name)
{
   insert_line(substr('',1,indent)"p_backcolor="_format_color(_display_wid.p_backcolor))
   insert_line(substr('',1,indent)"p_delay="_display_wid.p_delay)
   if(!_display_wid.p_enabled) insert_line(substr('',1,indent)"p_enabled="_bool2truefalse(_display_wid.p_enabled))
   insert_line(substr('',1,indent)"p_forecolor="_format_color(_display_wid.p_forecolor))
   insert_line(substr('',1,indent)"p_height="_display_wid.p_height)
   if (_display_wid.p_help!='') safe_insert_line(substr('',1,indent)"p_help=",_display_wid.p_help);
   insert_line(substr('',1,indent)"p_increment="_display_wid.p_increment)
   insert_line(substr('',1,indent)"p_max="_display_wid.p_max)
   insert_line(substr('',1,indent)"p_min="_display_wid.p_min)
   if(_display_wid.p_mouse_pointer!=MP_DEFAULT) insert_line(substr('',1,indent)"p_mouse_pointer="eq_value2name(_display_wid.p_mouse_pointer,MP_LIST))
   //insert_line(substr('',1,indent)"p_style="eq_value2name(_display_wid.p_style,PSSP_LIST))
   insert_line(substr('',1,indent)"p_tab_index="_display_wid.p_tab_index)
   //insert_line(substr('',1,indent)"p_tab_stop="_bool2truefalse(_display_wid.p_tab_stop))
   if (!_display_wid.p_visible) insert_line(substr('',1,indent)"p_visible="_bool2truefalse(_display_wid.p_visible))
   insert_line(substr('',1,indent)"p_width="_display_wid.p_width)
   insert_line(substr('',1,indent)"p_x="_display_wid.p_x)
   insert_line(substr('',1,indent)"p_y="_display_wid.p_y)
   insert_etabs(_display_wid,indent,form_name);
}
const
      SSTAB_PROPS=' ActiveCaption ActiveEnabled ActiveHelp ActiveOrder ActivePicture ActiveTab backcolor':+
                 ' clip_controls enabled eventtab eventtab2 FirstActiveTab font_bold':+
                 ' font_italic font_name font_size font_underline forecolor Grabbar':+
                 ' height mouse_pointer MultiRow NofTabs Orientation PaddingX PaddingY PictureOnly':+
                 ' tab_stop TabsPerRow visible width x y ';
static void _desstab_props()
{
   insert_line(" ActiveCaption\t"_display_wid.p_ActiveCaption);
   insert_line(" ActiveEnabled\t"_bool2truefalse(_display_wid.p_ActiveEnabled));
   insert_line(" ActiveHelp\t"_display_wid.p_ActiveHelp);
   insert_line(" ActiveOrder\t"_display_wid.p_ActiveOrder);
   insert_line(" ActivePicture\t"name_name(_display_wid.p_ActivePicture));
   insert_line(" ActiveTab\t"_display_wid.p_ActiveTab);
   insert_line(" backcolor\t"_format_color(_display_wid.p_backcolor))
   insert_line(" clip_controls\t"_bool2truefalse(_display_wid.p_clip_controls));
   insert_line(" enabled\t"_bool2truefalse(_display_wid.p_enabled))
   insert_line(" eventtab\t"translate(name_name(_display_wid.p_eventtab),'_','-'))
   insert_line(" eventtab2\t"translate(name_name(_display_wid.p_eventtab2),'_','-'))
   insert_line(" FirstActiveTab\t"_display_wid.p_FirstActiveTab);
   insert_line(" font_bold\t"_bool2truefalse(_display_wid.p_font_bold))
   insert_line(" font_italic\t"_bool2truefalse(_display_wid.p_font_italic))
   insert_line(" font_name\t"_display_wid.p_font_name)
   insert_line(" font_size\t"_display_wid.p_font_size)
   insert_line(" font_underline\t"_bool2truefalse(_display_wid.p_font_underline))
   insert_line(" forecolor\t"_format_color(_display_wid.p_forecolor))
   insert_line(" Grabbar\t"_bool2truefalse(_display_wid.p_Grabbar));
   insert_line(" height\t"_display_wid.p_height)
   insert_line(" mouse_pointer\t"eq_value2name(_display_wid.p_mouse_pointer,MP_LIST))
   insert_line(" MultiRow\t"eq_value2name(_display_wid.p_MultiRow,SSTAB_MULTIROW_LIST));
   insert_line(" name\t"_display_wid.p_name)
   insert_line(" NofTabs\t"_display_wid.p_NofTabs);
   insert_line(" Orientation\t"eq_value2name(_display_wid.p_Orientation,SSTAB_ORIENTATION_LIST));
   insert_line(" PaddingX\t"_display_wid.p_PaddingX);
   insert_line(" PaddingY\t"_display_wid.p_PaddingY);
   insert_line(" PictureOnly\t"_bool2truefalse(_display_wid.p_PictureOnly));
   insert_line(" tab_index\t"_display_wid.p_tab_index)
   insert_line(" tab_stop\t"_bool2truefalse(_display_wid.p_tab_stop))
   insert_line(" TabsPerRow\t"_display_wid.p_TabsPerRow);
   insert_line(" visible\t"_bool2truefalse(_display_wid.p_visible))
   insert_line(" width\t"_display_wid.p_width)
   insert_line(" x\t"_display_wid.p_x)
   insert_line(" y\t"_display_wid.p_y)
}
void _insert_sstab_props(_display_wid,indent,form_name)
{
   insert_line(substr('',1,indent)"p_FirstActiveTab="_display_wid.p_FirstActiveTab);
   insert_line(substr('',1,indent)"p_backcolor="_format_color(_display_wid.p_backcolor))
   insert_line(substr('',1,indent)"p_clip_controls="_bool2truefalse(_display_wid.p_clip_controls));
   if(!_display_wid.p_enabled) insert_line(substr('',1,indent)"p_enabled="_bool2truefalse(_display_wid.p_enabled));
   insert_line(substr('',1,indent)"p_font_bold="_bool2truefalse(_display_wid.p_font_bold))
   insert_line(substr('',1,indent)"p_font_italic="_bool2truefalse(_display_wid.p_font_italic))
   insert_line(substr('',1,indent)"p_font_name="_quote(_display_wid.p_font_name))
   insert_line(substr('',1,indent)"p_font_size="_display_wid.p_font_size)
   insert_line(substr('',1,indent)"p_font_underline="_bool2truefalse(_display_wid.p_font_underline))
   insert_line(substr('',1,indent)"p_forecolor="_format_color(_display_wid.p_forecolor))
   insert_line(substr('',1,indent)"p_Grabbar="_bool2truefalse(_display_wid.p_Grabbar));
   insert_line(substr('',1,indent)"p_height="_display_wid.p_height)
   if(_display_wid.p_mouse_pointer!=MP_DEFAULT) insert_line(substr('',1,indent)"p_mouse_pointer="eq_value2name(_display_wid.p_mouse_pointer,MP_LIST));
   insert_line(substr('',1,indent)"p_MultiRow="eq_value2name(_display_wid.p_MultiRow,SSTAB_MULTIROW_LIST));
   insert_line(substr('',1,indent)"p_NofTabs="_display_wid.p_NofTabs);
   insert_line(substr('',1,indent)"p_Orientation="eq_value2name(_display_wid.p_Orientation,SSTAB_ORIENTATION_LIST));
   insert_line(substr('',1,indent)"p_PaddingX="_display_wid.p_PaddingX);
   insert_line(substr('',1,indent)"p_PaddingY="_display_wid.p_PaddingY);
   insert_line(substr('',1,indent)"p_PictureOnly="_bool2truefalse(_display_wid.p_PictureOnly));
   insert_line(substr('',1,indent)"p_tab_index="_display_wid.p_tab_index)
   insert_line(substr('',1,indent)"p_tab_stop="_bool2truefalse(_display_wid.p_tab_stop))
   insert_line(substr('',1,indent)"p_TabsPerRow="_display_wid.p_TabsPerRow);
   if (!_display_wid.p_visible) insert_line(substr('',1,indent)"p_visible="_bool2truefalse(_display_wid.p_visible))
   insert_line(substr('',1,indent)"p_width="_display_wid.p_width)
   insert_line(substr('',1,indent)"p_x="_display_wid.p_x)
   insert_line(substr('',1,indent)"p_y="_display_wid.p_y)
   insert_etabs(_display_wid,indent,form_name);
}
void _insert_sstab_container_props(_display_wid,indent,form_name)
{
   safe_insert_line(substr('',1,indent)"p_ActiveCaption=",_display_wid.p_ActiveCaption);
   insert_line(substr('',1,indent)"p_ActiveEnabled="_bool2truefalse(_display_wid.p_ActiveEnabled));
   if (_display_wid.p_ActiveHelp!='') safe_insert_line(substr('',1,indent)"p_ActiveHelp=",_display_wid.p_ActiveHelp);
   insert_line(substr('',1,indent)"p_ActiveOrder="_display_wid.p_ActiveOrder);
   if (_display_wid.p_ActivePicture) {
      insert_line(substr('',1,indent)"p_ActivePicture="_quote(name_name(_display_wid.p_ActivePicture)))
   }
   //insert_etabs(_display_wid,indent,form_name);
}
defeventtab _decolor_form
image.lbutton_down()
{
   p_active_form._delete_window(p_backcolor)
}

static _str _ignore_combo_change=0;
_str _deget_ignore_combo_change()
{
   return(_ignore_combo_change);
}
static _bool2truefalse(value)
{
   return((value)?'TRUE':'FALSE')
}
static _truefalse2bool(value)
{
   value=lowcase(value)
   if (value=='true' || value=='1') {
      return(1)
   }
   return(0)
}
_deupdate_combo()
{

   parse _delist_wid._lbget_text() with _depname value
   // Can remove this later when have long line support
   // text in list box can get truncated before label.
   if (lowcase(_depname)=='caption') {
      value=_display_wid.p_caption;
   }
   _decombo_wid.p_eventtab=defeventtab _dlge_form.combo;
   _decombo_wid.p_completion=eq_name2value(_depname,COMPLETION_LIST);
   enabled=0;
   if (pos(' '_depname' ',' 'BOOLEAN_PROPS' ',1,'i')) {
      //_decombo_wid.p_eventtab=defeventtab  _dero_combo
      if (_decombo_wid.p_cb_picture.p_picture!=_pic_cbarrow) {
         _decombo_wid.p_cb_picture.p_picture=_pic_cbarrow
      }
      enabled=1
      cblist_wid=_decombo_wid.p_cb_list_box;
      cblist_wid._lbclear();
   /* } else if(pos(' '_depname' ',' 'INT_PROPS' ',1,'i')){ */
   } else if(lowcase(_depname)=='font_size' && !_isscalable_font(_display_wid.p_font_name,'s')) {
      //_decombo_wid.p_eventtab=defeventtab _dero_combo
      if (_decombo_wid.p_cb_picture.p_picture!=_pic_cbarrow) {
         _decombo_wid.p_cb_picture.p_picture=_pic_cbarrow
      }
      enabled=1
      cblist_wid=_decombo_wid.p_cb_list_box
      cblist_wid._lbclear();
   } else if(pos(' '_depname' ',' 'CBLIST_PROPS' ',1,'i')){
      //_decombo_wid.p_eventtab=defeventtab _dero_combo
      if (_decombo_wid.p_cb_picture.p_picture!=_pic_cbarrow) {
         _decombo_wid.p_cb_picture.p_picture=_pic_cbarrow
      }
      enabled=1
      cblist_wid=_decombo_wid.p_cb_list_box
      cblist_wid._lbclear();
      cblist_wid._post_paint();

   } else if(pos(' 'lowcase(_depname)' ',' activepicture collapsepicture expandpicture picture forecolor backcolor ')){
      if (_decombo_wid.p_cb_picture.p_picture!=_pic_cbdots) {
         _decombo_wid.p_cb_picture.p_picture=_pic_cbdots
      }
      enabled=1;
   } else {
      if (_decombo_wid.p_cb_picture.p_picture!=_pic_cbdis) {
         _decombo_wid.p_cb_picture.p_picture=_pic_cbdis;
      }
   }
   _ignore_combo_change=1
   _decombo_wid.p_text=value
   _ignore_combo_change=0
   _decombo_wid.p_cb_text_box._set_sel(length(value)+1)
   _decombo_wid.p_cb_picture.p_enabled=enabled
}
_defill_cblist()
{
   if (_ignore_combo_change) {
      return('');
   }
   orig_wid=p_window_id
   parse _delist_wid._lbget_text() with _depname value
   ldepname=lowcase(_depname);
   if (ldepname=='command'){
      p_window_id=_decombo_wid.p_cb_list_box
      _insert_name_list COMMAND_TYPE
      _lbsort();
#if 0
   } else if (ldepname=='help'){
      p_window_id=_decombo_wid.p_cb_list_box
      filename=_help_list();
      if (filename!='') {
         get(filename,'','A' /* Insert after. */);
         mark=_alloc_selection();
         if (mark=='') {
            _lbclear();
         } else {
            _lbtop();
            _select_line(mark);
            _lbbottom();
            _select_line(mark);
            //_lbsort();
         }
      }
#endif
   } else if(ldepname=='font_size'){
      if (!_isscalable_font(_display_wid.p_font_name,'s')) {
         p_window_id=_decombo_wid.p_cb_list_box
         mou_hour_glass(1);
         _insert_font_list 's',_display_wid.p_font_name
         mou_hour_glass(0);
         _lbsort('-n');
      }
   } else {
      list=''
      if (pos(' '_depname' ',' 'BOOLEAN_PROPS' ',1,'i')) {
         list='TRUE='TRUE' FALSE='FALSE
      } else if(pos(' '_depname' ',' 'CBLIST_PROPS' ',1,'i')){
         switch (_depname) {
         case 'alignment':
            if (_display_wid.p_object==OI_CHECK_BOX) {
               list=AL_CHECK_LIST;
            } else {
               list=AL_LIST
            }
            break;
         case 'border_style':
            if (_display_wid.p_object==OI_FORM) {
               list=BDS_FORM_LIST;
            } else if (_display_wid.p_object==OI_LABEL) {
               list=BDS_LIST2;
            } else {
               list=BDS_LIST;
            }
            break;
         case 'completion':
            list=CP_LIST
            break;
         case 'font_name':
            mou_hour_glass(1);
            _decombo_wid.p_cb_list_box._insert_font_list()
            mou_hour_glass(0);
            break;
         case 'max_click':
            list=MC_LIST;
            break;
         case 'mouse_pointer':
            list=MP_LIST
            break;
         case 'Orientation':
            list=SSTAB_ORIENTATION_LIST;
            break;
         case 'LineStyle':
            list=TREE_LINE_LIST;
            break;
         case 'multi_select':
            switch(_display_wid.p_object){
            case OI_TREE_VIEW:
               list=MS_LIST_TREEVIEW;
               break;
            default:
               list=MS_LIST;
               break;
            }
            break;
         case 'MultiRow':
            list=SSTAB_MULTIROW_LIST;
            break;
         case 'style':
            switch(_display_wid.p_object){
            case OI_CHECK_BOX:
               list=PSCH_LIST
               break;
            case OI_COMBO_BOX:
               list=PSCBO_LIST
               break;
            case OI_GAUGE:
               list=PSGA_LIST;
               break;
            case OI_PICTURE_BOX:
               list=PSPIC_LIST;
               break;
            case OI_IMAGE:
               list=PSIMG_LIST;
               break;
            }
            break;
         case 'scroll_bars':
            list=SB_LIST;
            break;
   #if 0
         case 'validate_style':
            list=VS_LIST;
            break;
   #endif
         }
      }
      p_window_id=_decombo_wid.p_cb_list_box
      for (;;) {
         parse list with word'='value list
         if (word=='') break;
         _lbadd_item(word)
      }
      _lbsort();
      if (_depname=='font_name') {
         _remove_duplicates();
      }
   }
   p_window_id=orig_wid
   status=_cbi_search();
   if (!status) {  // String found?
      p_cb_list_box._lbselect_line()
   }
}
_str _deupdate_property()
{
   parse _delist_wid._lbget_text() with _depname value
   new_value=_decombo_wid.p_text
   if (value==new_value && arg(1)=='') return('');
   list=''
   /* if (pos(' '_depname' ',' 'BOOLEAN_PROPS' ',1,'i')) { */
      /* list=TRUEFALSE_LIST */
   if(pos(' '_depname' ',' 'INT_PROPS' ',1,'i')){
      if (!isinteger(new_value)) {
         _deupdate_combo()
         _post_call(find_index('popup_message',COMMAND_TYPE),nls('Invalid property value'))
         return('')
      }
      min_value=eq_name2value(_depname,MIN_VALUES)
      if (min_value!='' && new_value<min_value) {
         _deupdate_combo()
         //popup_message(nls('Invalid property value'))
         _post_call(find_index('popup_message',COMMAND_TYPE),nls('Invalid property value'))
         return('')
      }
      max_value=eq_name2value(_depname,MAX_VALUES)
      if (max_value!='' && new_value>max_value) {
         _deupdate_combo()
         _post_call(find_index('popup_message',COMMAND_TYPE),nls('Invalid property value'))
         return('')
      }
      _deset_property(_display_wid,_depname,new_value)
      return('')
   } else if (lowcase(_depname)=='command' || lowcase(_depname)=='help' || lowcase(_depname)=='activehelp'){
   } else if(pos(' '_depname' ',' 'CBLIST_PROPS' ',1,'i') ||
             pos(' '_depname' ',' 'BOOLEAN_PROPS' ',1,'i')){

      if (!_decombo_wid.p_cb_list_box.p_Noflines) {
         _decombo_wid._defill_cblist()
      }
      status=_decombo_wid._cbi_search('','$');
      if (status) {  // String not found?
         _deupdate_combo()
         _post_call(find_index('popup_message',COMMAND_TYPE),nls('Invalid property value'))
         return('')
      }
      _decombo_wid.p_cb_list_box._lbselect_line()
      new_value=_decombo_wid.p_cb_list_box._lbget_text();
   }
   status=_deset_property(_display_wid,_depname,new_value)
   if (status) {
      _deupdate_combo()
   }
   if (lowcase(_depname)=='name'){
      _deupdate_caption();
   }
   return('')
}
static _deupdate_caption()
{
   if (_display_wid.p_object==OI_FORM) {
      title=_display_wid.p_name' Properties'
   } else {
      title=_get_form(_display_wid).p_name'.':+
                            _display_wid.p_name' Properties'
   }
   _deform_wid.p_caption=translate(title,'_','-')
}
static _str _deset_property(_display_wid,pname,value)
{
   status=_set_property(_display_wid,pname,value)
   if (status==1) {
      _deupdate_combo()
      _post_call(find_index('popup_message',COMMAND_TYPE),nls('Invalid property value'))
   } else if (status==2){
      _deupdate_combo()
      _post_call(find_index('popup_message',COMMAND_TYPE),nls('You already have a control with this name'))
   } else if (status==3){
      _deupdate_combo()
      _post_call(find_index('popup_message',COMMAND_TYPE),nls('You already have a form with this name'))
   } else if (status==4){
      _deupdate_combo()
      _post_call(find_index('popup_message',COMMAND_TYPE),nls('Event table not found'))
   } else if (status<0){
      _deupdate_combo()
      _post_call(find_index('popup_message',COMMAND_TYPE),nls('Unable to set property %s to %s',pname,value)'.  'get_message(status))
   } else {
      _delist_wid._lbset_item(pname:+\t:+value)
   }
   _delist_wid._lbselect_line();
   if (!status && _deNofselected>1) {
      _for_each_control(_get_form(_display_wid),
                     '_deset_selprop','',pname,value)
   }
   return(status);
}
_str _deset_selprop(wid,pname,value)
{
   if (wid.p_selected && wid!=_display_wid) {
      _set_property(wid,pname,value)
   }
   return(0)
}

static _str _set_property(_display_wid,_depname,var value)
{
   status=0;
   _suspend();
   if ( rc ) {
      if (isinteger(rc) && rc<0 ) {
         return(1)
      }
      if ( rc==10 ) {  /* No error? */
         return(0)
      }
      return(rc)
   }
   orig_wid=p_window_id
   p_window_id=_display_wid;
   new_value=value;
   switch (_depname) {
   case "ActiveCaption":
      p_ActiveCaption=new_value
      break;
   case "ActiveEnabled":
      if (!isinteger(new_value)) {
         new_value=eq_name2value(new_value,TRUEFALSE_LIST);
      }
      p_ActiveEnabled=new_value;
      break;
   case "ActiveHelp":
      p_ActiveHelp=new_value;
      break;
   case "ActiveOrder":
      p_ActiveOrder=new_value;
      _deupdate();
      break;
   case "ActivePicture":
      if (new_value=='') {
         p_ActivePicture=0
      } else {
         /* Replace or load a picture. */
         index=_update_picture(-1,new_value);
         if (index<0) {
            status=index;
         } else {
            p_ActivePicture=index
            // Set the picture property again to the same value
            // just incase other windows are displaying this
            // picture, the editor will refresh them.
            p_ActivePicture=index
         }
         value=strip_filename(value,'P')
      }
      break;
   case "ActiveTab":
      p_ActiveTab=new_value;
      _deupdate();
      break;
   case "after_pic_indent_x":
      p_after_pic_indent_x=new_value;
      _deupdate();
      break;
   case "alignment":
      old_value=new_value
      if (!isinteger(new_value)) {
         if (_display_wid.p_object==OI_CHECK_BOX) {
            list=AL_CHECK_LIST;
         } else {
            list=AL_LIST
         }
         new_value=eq_name2value(new_value,list);
      }
      p_alignment=new_value;
      break;
   case "auto_size":
      if (!isinteger(new_value)) {
         new_value=eq_name2value(new_value,TRUEFALSE_LIST);
      }
      p_auto_size=new_value;
      break;
   case "backcolor":
      new_value=hex2dec(new_value)
      if (new_value!='') {
         p_backcolor=new_value
         value=_format_color(new_value)
      } else {
         status=1;
      }
      break;
   case 'border_style':
      if (!isinteger(new_value)) {
         if (_display_wid.p_object==OI_FORM) {
            list=BDS_FORM_LIST
         } else if (_display_wid.p_object==OI_LABEL) {
            list=BDS_LIST2;
         } else {
            list=BDS_LIST;
         }
         new_value=eq_name2value(new_value,list)
      }
      p_border_style=new_value;
      break;
   case "cancel":
      if (!isinteger(new_value)) {
         new_value=eq_name2value(new_value,TRUEFALSE_LIST);
      }
      p_cancel=new_value;
      break;
   case "caption":
      p_caption=new_value
      break;
   case "case_sensitive":
      if (!isinteger(new_value)) {
         new_value=eq_name2value(new_value,TRUEFALSE_LIST);
      }
      p_case_sensitive=new_value;
      break;
   case "CaptionClick":
      if (!isinteger(new_value)) {
         new_value=eq_name2value(new_value,TRUEFALSE_LIST);
      }
      p_CaptionClick=new_value;
      break;
   case "CheckListBox":
      new_value=eq_name2value(new_value,TRUEFALSE_LIST);
      p_CheckListBox=new_value;
      break;
   case "clip_controls":
      if (!isinteger(new_value)) {
         new_value=eq_name2value(new_value,TRUEFALSE_LIST);
      }
      p_clip_controls=new_value;
      break;
   case "CollapsePicture":
      if (new_value=='') {
         p_CollapsePicture=0
      } else {
         /* Replace or load a picture. */
         index=_update_picture(-1,new_value);
         if (index<0) {
            status=index;
         } else {
            p_CollapsePicture=index;
            // Set the picture property again to the same value
            // just incase other windows are displaying this
            // picture, the editor will refresh them.
            p_CollapsePicture=index;
         }
         value=strip_filename(value,'P')
      }
      break;
   case "command":
      p_command=new_value;
      break;
   case "completion":
      if (!isinteger(new_value)) {
         new_value=eq_name2value(new_value,CP_LIST);
      }
      if (new_value=='.') new_value='';
      p_completion=new_value;
      break;
   case "default":
      if (!isinteger(new_value)) {
         new_value=eq_name2value(new_value,TRUEFALSE_LIST);
      }
      p_default=new_value;
      break;
   case "delay":
      p_delay=new_value;
      break;
   case "eventtab":
      if (new_value=='') {
         new_value=0;
      } else {
         new_value=find_index(new_value,EVENTTAB_TYPE)
         if (!new_value) {
            status=4;
            break;
         }
      }
      p_eventtab=new_value
      break;
   case "eventtab2":
      if (new_value=='') {
         new_value=0;
      } else {
         new_value=find_index(new_value,EVENTTAB_TYPE)
         if (!new_value) {
            status=4;
            break;
         }
      }
      p_eventtab2=new_value
      break;
   case "enabled":
      if (!isinteger(new_value)) {
         new_value=eq_name2value(new_value,TRUEFALSE_LIST);
      }
      p_enabled=new_value;
      break;
   case "ExpandPicture":
      if (new_value=='') {
         p_ExpandPicture=0
      } else {
         /* Replace or load a picture. */
         index=_update_picture(-1,new_value);
         if (index<0) {
            status=index;
         } else {
            p_ExpandPicture=index;
            // Set the picture property again to the same value
            // just incase other windows are displaying this
            // picture, the editor will refresh them.
            p_ExpandPicture=index;
         }
         value=strip_filename(value,'P')
      }
      break;
   case "FirstActiveTab":
      p_FirstActiveTab=new_value;
      _deupdate();
      break;
   case "font_bold":
      if (!isinteger(new_value)) {
         new_value=eq_name2value(new_value,TRUEFALSE_LIST);
      }
      p_font_bold=new_value;
      break;
   case "font_italic":
      if (!isinteger(new_value)) {
         new_value=eq_name2value(new_value,TRUEFALSE_LIST);
      }
      p_font_italic=new_value;
      break;
   case "font_name":
      p_font_name=new_value;
      break;
   case "font_size":
      p_font_size=new_value;
      break;
   case "font_underline":
      if (!isinteger(new_value)) {
         new_value=eq_name2value(new_value,TRUEFALSE_LIST);
      }
      p_font_underline=new_value;
      break;
   case "forecolor":
      new_value=hex2dec(new_value)
      if (new_value!='') {
         p_forecolor=new_value
         value=_format_color(new_value)
      } else {
         status=1;
      }
      break;
   case "Grabbar":
      if (!isinteger(new_value)) {
         new_value=eq_name2value(new_value,TRUEFALSE_LIST);
      }
      p_Grabbar=new_value;
      break;
   case "height":
      p_height=new_value;
      break;
   case "help":
      p_help=new_value;
      break;
   case "increment":
      p_increment=new_value
      break;
   case "large_change":
      p_large_change=new_value
      break;
   case "LevelIndent":
      p_LevelIndent=new_value;
      break; 
   case "LineStyle":
      p_LineStyle=eq_name2value(new_value,TREE_LINE_LIST);
      break; 
   case "max":
      p_max=new_value;
      break;
   case "max_button":
      if (!isinteger(new_value)) {
         new_value=eq_name2value(new_value,TRUEFALSE_LIST);
      }
      p_max_button=new_value;
      break;
   case "min":
      p_min=new_value;
      break;
   case "max_click":
      if (!isinteger(new_value)) {
         new_value=eq_name2value(new_value,MC_LIST);
      }
      p_max_click=new_value;
      break;
   case "message":
      p_message=new_value;
      break;
   case "mouse_pointer":
      if (!isinteger(new_value)) {
         new_value=eq_name2value(new_value,MP_LIST);
      }
      p_mouse_pointer=new_value;
      break;
   case "multi_select":
      if (!isinteger(new_value)) {
         switch(p_object){
         case OI_TREE_VIEW:
            list=MS_LIST_TREEVIEW;
            break;
         default:
            list=MS_LIST;
            break;
         }
         new_value=eq_name2value(new_value,list);
      }
      p_multi_select=new_value;
      break;
   case "MultiRow":
      if (!isinteger(new_value)) {
         new_value=eq_name2value(new_value,SSTAB_MULTIROW_LIST);
      }
      p_MultiRow=new_value;
      break;
   case "name":
      if (!(new_value=='' && p_object!=OI_FORM) && !isid_valid(new_value)) {
         status=1;
         break;
      }
      if (!name_eq(p_name,new_value)) {
         if (p_object==OI_FORM) {
            index=find_index(new_value,oi2type(OI_FORM));
            if (index && index!=p_template){
               status=3
               break;
            }
         } else {
            wid=_find_control(new_value);
            if (new_value!='' && wid) {
               status=2;
               break;
            }
         }
      }
      p_name=new_value
      break;
   case "Nofstates":
      p_Nofstates=new_value
      break;
   case "NofTabs":
      p_NofTabs=new_value;
      _deupdate();
      break;
   case "Orientation":
      p_Orientation=eq_name2value(new_value,SSTAB_ORIENTATION_LIST);
      break; 
   case "PaddingX":
      p_PaddingX=new_value;
      break;
   case "PaddingY":
      p_PaddingY=new_value;
      break;
   case "picture":
      if (new_value=='') {
         p_picture=0
      } else {
         /* Replace or load a picture. */
         index=_update_picture(-1,new_value);
         if (index<0) {
            status=index;
         } else {
            p_picture=index
            // Set the picture property again to the same value
            // just incase other windows are displaying this
            // picture, the editor will refresh them.
            p_picture=index
         }
         value=strip_filename(value,'P')
      }
      break;
   case "PictureOnly":
      if (!isinteger(new_value)) {
         new_value=eq_name2value(new_value,TRUEFALSE_LIST);
      }
      p_PictureOnly=new_value;
      break;
   case "ReadOnly":
      if (!isinteger(new_value)) {
         new_value=eq_name2value(new_value,TRUEFALSE_LIST);
      }
      p_ReadOnly=new_value;
      break;
   case "Password":
      if (!isinteger(new_value)) {
         new_value=eq_name2value(new_value,TRUEFALSE_LIST);
      }
      p_Password=new_value;
      break;
   case "scroll_bars":
      if (!isinteger(new_value)) {
         new_value=eq_name2value(new_value,SB_LIST);
      }
      p_scroll_bars=new_value;
      break;
   case "ShowRoot":
      new_value=eq_name2value(new_value,TRUEFALSE_LIST);
      p_ShowRoot=new_value;
      break;
   case "AlwaysColorCurrent":
      new_value=eq_name2value(new_value,TRUEFALSE_LIST);
      p_AlwaysColorCurrent=new_value;
      break;
   case "SpaceY":
      p_SpaceY=new_value;
      break;
   case "small_change":
      p_small_change=new_value
      break;
   case "stretch":
      if (!isinteger(new_value)) {
         new_value=eq_name2value(new_value,TRUEFALSE_LIST);
      }
      p_stretch=new_value;
      break;
   case "style":
      if (!isinteger(new_value)) {
         list=''
         switch (p_object) {
         case OI_CHECK_BOX:
            list=PSCH_LIST
            break;
         case OI_COMBO_BOX:
            list=PSCBO_LIST
            break;
         case OI_GAUGE:
            list=PSGA_LIST;
            break;
         case OI_PICTURE_BOX:
            list=PSPIC_LIST;
            break;
         case OI_IMAGE:
            list=PSIMG_LIST;
            break;
         }
         if (list=='') break;
         old_value=new_value
         new_value=eq_name2value(new_value,list)
         if (new_value=='') {
            status=1;
            break;
         }
      }
      p_style=new_value;
      break;
   case "tab_index":
      _set_tab_index(new_value)
      break;
   case "tab_stop":
      if (!isinteger(new_value)) {
         new_value=eq_name2value(new_value,TRUEFALSE_LIST);
      }
      p_tab_stop=new_value;
      break;
   case "TabsPerRow":
      p_TabsPerRow=new_value;
      break;
   case "text":
      p_text=new_value;
      break;
#if 0
   case "validate_style":
      if (!isinteger(new_value)) {
         new_value=eq_name2value(new_value,VS_LIST);
      }
      p_validate_style=new_value;
      break;
#endif
   case "value":
      if (isinteger(new_value)) {
         //max_value=value;
         if (p_object==OI_CHECK_BOX) {
            if (p_style==PSCH_AUTO2STATE) {
               max_value=1;
            } else {
               max_value=2;
            }
            if (value>max_value) {
               value=max_value;
            }
         }
         p_value=value;
      } else {
         status=2;
      }
      break;
   case "tool_window":
      if (!isinteger(new_value)) {
         new_value=eq_name2value(new_value,TRUEFALSE_LIST);
      }
      p_tool_window=new_value;
      break;
   case "visible":
      if (!isinteger(new_value)) {
         new_value=eq_name2value(new_value,TRUEFALSE_LIST);
      }
      p_visible=new_value;
      break;
   case "width":
      p_width=new_value;
      break;
   case "word_wrap":
      if (!isinteger(new_value)) {
         new_value=eq_name2value(new_value,TRUEFALSE_LIST);
      }
      p_word_wrap=new_value;
      break;
   case "x":
      p_x=new_value;
      break;
   case "y":
      p_y=new_value;
      break;
   }
   p_window_id=orig_wid
   if (status) {
      rc=status;_resume();
   }
   rc=10;_resume();

   //We never hit this
   return(0);
}
_delist_dclick()
{
   parse _delist_wid._lbget_text() with _depname value
   if (lowcase(_depname)=='value' &&
       (_display_wid.p_object==OI_CHECK_BOX|| _display_wid.p_object==OI_RADIO_BUTTON)) {
       if (_display_wid.p_style==PSCH_AUTO2STATE||_display_wid.p_object==OI_RADIO_BUTTON) {
          max_value=1;
       } else {
          max_value=2;
       }
       ++value;
       if (value>max_value) {
          value=0;
       }
       _ignore_combo_change=1;
       _decombo_wid.p_text=value
       _ignore_combo_change=0
       _deset_property(_display_wid,_depname,value)
       return('')
   } else if (_decombo_wid.p_cb_picture.p_picture==_pic_cbdots){
      _decombo_wid.p_cb_active=_decombo_wid.p_cb_picture;
      _decombo_wid.call_event(_decombo_wid,LBUTTON_DOWN)

   } else if (lowcase(_depname)=='command' || lowcase(_depname)=='help' || lowcase(_depname)=='activehelp'){
      // The list for a command is too long to go to the next item. */
   } else if((lowcase(_depname)=='font_size' && !_isscalable_font(_display_wid.p_font_name,'s')) ||
              pos(' '_depname' ',' 'CBLIST_PROPS' ',1,'i') ||
             pos(' '_depname' ',' 'BOOLEAN_PROPS' ',1,'i')){

      if (!_decombo_wid.p_cb_list_box.p_Noflines) {
         _decombo_wid._defill_cblist()
      }
      before=_decombo_wid.p_text;
      status=_decombo_wid._cbi_search();
      if (!status) {  // String found?
         status=_decombo_wid.p_cb_list_box.down();
         if (status) {  // Bottom of file?
            _decombo_wid.p_cb_list_box.top();
         }
         value=_decombo_wid.p_cb_list_box._lbget_text();
         _ignore_combo_change=1;
         _decombo_wid.p_text=value
         _ignore_combo_change=0
         _deset_property(_display_wid,_depname,value)
         return('')
      }
   } else if(pos(' '_depname' ',' 'INCINT_PROPS' ',1,'i')){
      if (!isinteger(value)) {
         popup_message(nls('Invalid property value'))
         return('')
      }
      min_value=eq_name2value(_depname,MIN_VALUES)
      max_value=eq_name2value(_depname,MAX_VALUES)
      ++value;
      if (max_value!='' && value>max_value) {
         if (min_value!='') {
            value=min_value;
            _ignore_combo_change=1;
            _decombo_wid.p_text=value
            _ignore_combo_change=0
            _deset_property(_display_wid,_depname,value)
            return('')
         }
         --value;
      } else {
         _ignore_combo_change=1;
         _decombo_wid.p_text=value
         _ignore_combo_change=0
         _deset_property(_display_wid,_depname,value)
         return('')
      }
   }
   p_window_id=_decombo_wid.p_cb_text_box
   _decombo_wid.p_cb_text_box._set_sel(1,length(_decombo_wid.p_cb_text_box.p_text)+1);_set_focus();
   return('')
}
static _deget_object_props(object)
{
   switch (object) {
   case OI_FORM:
      props=FORM_PROPS;
      break;
   case OI_TEXT_BOX:
      props=TEXT_BOX_PROPS;
      break;
   case OI_COMMAND_BUTTON:
      props=COMMAND_BUTTON_PROPS
      break;
   case OI_CHECK_BOX:
      props=CHECK_BOX_PROPS;
      break;
   case OI_RADIO_BUTTON:
      props=RADIO_BUTTON_PROPS;
      break;
   case OI_FRAME:
      props=FRAME_PROPS;
      break;
   case OI_LABEL:
      props=LABEL_PROPS;
      break;
   case OI_LIST_BOX:
      props=LIST_BOX_PROPS;
      break;
   case OI_EDITOR:
      props=EDITOR_PROPS;
      break;
   case OI_SSTAB:
      props=SSTAB_PROPS;
      break;
   case OI_TREE_VIEW:
      props=TREE_VIEW_PROPS;
      break;
   case OI_COMBO_BOX:
      props=COMBO_BOX_PROPS;
      break;
   case OI_IMAGE:
      props=IMAGE_PROPS;
      break;
   case OI_PICTURE_BOX:
      props=PICTURE_BOX_PROPS;
      break;
   case OI_HSCROLL_BAR:
   case OI_VSCROLL_BAR:
      props=SCROLL_BAR_PROPS;
      break;
   case OI_GAUGE:
      props=GAUGE_PROPS;
      break;
   case OI_SPIN:
      props=SPIN_PROPS;
      break;
   }
   return(props)
}
static _demerge_props()
{
   // Create list of objects that are different  OI_??? */
   objects=''
   child=_display_wid;
   hit_label=0;
   for (;;) {
      if (child.p_selected) {
         if (!pos(' 'child.p_object' ',' 'objects' ')) {
            objects=objects' ':+child.p_object
            if (child.p_object==OI_LABEL) {
               hit_label=1;
            }
         }
      }
      child=child.p_next;
      if (child==_display_wid) break;
   }
   parse objects with object objects
   props=_deget_object_props(object)
   // IF there is only one type of object AND this
   // object has a style property
   insert_style=0;
   if (objects=='' && pos(' 'object' ',
       ' 'OI_CHECK_BOX' 'OI_COMBO_BOX' 'OI_GAUGE' 'OI_PICTURE_BOX' 'OI_IMAGE' ')) {
       insert_style=1
   }
   //IF there is more than one type of object AND
   remove_border_property=0;
   if (objects!='' && hit_label) {
      remove_border_property=1;
   }
   for (;;) {
      parse objects with object objects
      if (object=='') break;
      props2=_deget_object_props(object)
      new_props='';
      for (;;) {
         parse props with property props
         if (property=='') break;
         if (pos(' 'property' ',' 'props2' ')) {
            new_props=new_props' 'property
         }
      }
      props=new_props;
   }
   for (;;) {
      parse props with property props;
      if (insert_style && 'style'<property) {
         insert_line(" style\t"_get_property(_display_wid,"style"))
         insert_style=0;
      }
      if (property=='') break;
      if (!remove_border_property || property!='border_style') {
         //say('prop='property' r='_get_property(_display_wid,property));
         insert_line(" "property"\t"_get_property(_display_wid,property))
      }
   }
}
static _str _get_property(_display_wid,property)
{
   switch (property) {
   case "ActiveCaption":
      return(_display_wid.p_ActiveCaption);
   case "ActiveEnabled":
      return(_bool2truefalse(_display_wid.p_ActiveEnabled));
   case "ActiveHelp":
      return(_display_wid.p_ActiveHelp);
   case "ActiveOrder":
      return(_display_wid.p_ActiveOrder);
   case "ActivePicture":
      return(name_name(_display_wid.p_ActivePicture))
   case "ActiveTab":
      return(_display_wid.p_ActiveTab);
   case "after_pic_indent_x":
      return(_display_wid.p_after_pic_indent_x)
   case "alignment":
      return(eq_value2name(_display_wid.p_alignment,AL_LIST))
   case "auto_size":
      return(_bool2truefalse(_display_wid.p_auto_size))
   case "backcolor":
      return(_format_color(_display_wid.p_backcolor));
   case "border_style":
      //say('_display_wid.p_border_style='_display_wid.p_border_style' r='eq_value2name(_display_wid.p_border_style,BDS_LIST));
      if (_display_wid.p_object==OI_LABEL) {
         return(eq_value2name(_display_wid.p_border_style,BDS_LIST2))
      } else {
         return(eq_value2name(_display_wid.p_border_style,BDS_LIST))
      }
   case "cancel":
      return(_bool2truefalse(_display_wid.p_cancel));
   case "caption":
      return(_display_wid.p_caption);
   case "case_sensitive":
      return(_bool2truefalse(_display_wid.p_case_sensitive));
   case "CaptionClick":
      return(_bool2truefalse(_display_wid.p_CaptionClick))
   case "CheckListBox":
      return(_display_wid.p_CheckListBox);
   case "clip_controls":
      return(_bool2truefalse(_display_wid.p_clip_controls))
   case "CollapsePicture":
      return(_display_wid.p_CollapsePicture);
   case "default":
      return(_bool2truefalse(_display_wid.p_default));
   case "delay":
      return(_display_wid.p_delay);
   case "enabled":
      return(_bool2truefalse(_display_wid.p_enabled));
   case "eventtab":
      return(translate(name_name(_display_wid.p_eventtab),'_','-'));
   case "eventtab2":
      return(translate(name_name(_display_wid.p_eventtab2),'_','-'));
   case "ExpandPicture":
      return(_display_wid.p_ExpandPicture);
   case "FirstActiveTab":
      return(_display_wid.p_FirstActiveTab);
   case "font_bold":
      return(_bool2truefalse(_display_wid.p_font_bold));
   case "font_italic":
      return(_bool2truefalse(_display_wid.p_font_italic));
   case "font_name":
      return(_display_wid.p_font_name);
   case "font_size":
      return(_display_wid.p_font_size);
   case "font_underline":
      return(_bool2truefalse(_display_wid.p_font_underline));
   case "forecolor":
      return(_format_color(_display_wid.p_forecolor));
   case "Grabbar":
      return(_bool2truefalse(_display_wid.p_Grabbar));
   case "height":
      return(_display_wid.p_height);
   case "increment":
      return(_display_wid.p_increment);
   case "large_change":
      return(_display_wid.p_large_change);
   case "LevelIndent":
      return(_display_wid.p_LevelIndent);
   case "max":
      return(_display_wid.p_max);
   case "max_button":
      return(_bool2truefalse(_display_wid.p_max_button))
   case "min":
      return(_display_wid.p_min);
   case "max_click":
      return(eq_value2name(_display_wid.p_max_click,MC_LIST));
   case "mouse_pointer":
      return(eq_value2name(_display_wid.p_mouse_pointer,MP_LIST));
   case "multi_select":
      return(eq_value2name(_display_wid.p_multi_select,MS_LIST))
   case "MultiRow":
      return(eq_value2name(_display_wid.p_MultiRow,SSTAB_MULTIROW_LIST));
   /* case "name":  Don't need this for dialog editor */
   case "Nofstates":
      return(_display_wid.p_Nofstates)
   case "NofTabs":
      return(_display_wid.p_NofTabs)
   case "Orientation":
      return(eq_value2name(_display_wid.p_Orientation,SSTAB_ORIENTATION_LIST));
   case "PaddingX":
      return(_display_wid.p_PaddingX);
   case "PaddingY":
      return(_display_wid.p_PaddingY);
   case "picture":
      return(name_name(_display_wid.p_picture))
   case "PictureOnly":
      return(_bool2truefalse(_display_wid.p_PictureOnly));
   case "ReadOnly":
      return(_bool2truefalse(_display_wid.p_ReadOnly));
   case "Password":
      return(_bool2truefalse(_display_wid.p_Password));
   case "scroll_bars":
      return(eq_value2name(_display_wid.p_scroll_bars,SB_LIST))
   case "ShowRoot":
         return(_display_wid.p_ShowRoot);
   case "AlwaysColorCurrent":
         return(_display_wid.p_AlwaysColorCurrent);
   case "small_change":
      return(_display_wid.p_small_change);
   case "SpaceY":
      return(_display_wid.p_SpaceY);
   case "stretch":
      return(_bool2truefalse(_display_wid.p_stretch))
   case "style":
      switch (_display_wid.p_object) {
      case OI_CHECK_BOX:
         list=PSCH_LIST
         break;
      case OI_COMBO_BOX:
         list=PSCBO_LIST
         break;
      case OI_GAUGE:
         list=PSGA_LIST;
         break;
      case OI_PICTURE_BOX:
         list=PSPIC_LIST;
         break;
      case OI_IMAGE:
         list=PSIMG_LIST;
         break;
      }
      return(eq_value2name(_display_wid.p_style,list))
   /* case "tab_index": Don't need this for dialog editor */
   case "tab_stop":
      return(_bool2truefalse(_display_wid.p_tab_stop))
   case "TabsPerRow":
      return(_display_wid.p_TabsPerRow);
   case "text":
      return(_display_wid.p_text)
   case "value":
      return(_display_wid.p_value)
   case "tool_window":
      return(_bool2truefalse(_display_wid.p_visible))
   case "visible":
      return(_bool2truefalse(_display_wid.p_visible))
   case "width":
      return(_display_wid.p_width);
   case "x":
      return(_display_wid.p_x)
   case "y":
      return(_display_wid.p_y)
   }
   return('');
}
static _str cp_value2name(cp_value)
{
   if (cp_value=='') {
      return('NONE_ARG')
   }
   name=eq_value2name(cp_value,CP_LIST)
   return(name);
}

void _insert_menu_source(index,indent,add_indent,form_name)
{
   form_name=translate(form_name,'_','-')
   if (!(index & 0xffff0000)) {
      index=index << 16;
   }
   first_time=!(index & 0xffff);
   if (first_time) {
      insert_line substr('',1,indent):+'_menu 'index.p_name' {'
   } else {
      /* p_caption, p_help, p_message, p_categories */
      insert_menu_strings(substr('',1,indent):+'submenu ',index.p_caption,index.p_help,index.p_message,index.p_categories)
   }
   child=index.p_child
   if (child) {
      first_child=child;
      for (;;) {
         if (child.p_object==OI_MENU) {
            _insert_menu_source(child,indent+add_indent,add_indent,form_name);
         } else {
            insert_menu_strings(substr('',1,indent+add_indent),
                                child.p_caption,
                                child.p_command,
                                child.p_categories,
                                child.p_help,
                                child.p_message
                                )
         }
         child=child.p_next;
         if (child==first_child) break;
      }
   }
   if (first_time) {
      insert_line substr('',1,indent)'}'
   } else {
      insert_line substr('',1,indent)'endsubmenu'
   }
}
static insert_menu_strings(result,a)
{
   for (i=2;i<=arg();++i) {
      special_chars="\b\f\n\r\t"
      string=arg(i);
      if(verify(string,special_chars,'M')) {
         string=_quote(string);
      } else if(!pos('"',string) && !pos('\',string)){
         string='"'string'"';
      }  else {
         string=_quote(string);
      }
      if (i==2) {
         result=result:+string
      } else {
         result=result','string
      }
   }
   if (result!='') {
      insert_line result
   }
}
