/*
$VerboseHistory: filecfg.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:08:56a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 08:55a
 * Comment:
 * 
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:32p
 * Updated in \vault\vsship30\
 * Last Modified: 10/09/1997 02:25p
 * Comment:
 * Adding new 3.0 stuff
*/
#include "slick.sh"

static typeless _settings:[];

defeventtab _file_options_form
static void setDirectoryPathText()
{
   wid=p_window_id;
   result=show('-modal '_stdform('_cd_form'),'Choose Directory',1,1,1);
   if( result=='' ) {
      return;
   }
   p_window_id=wid.p_prev;
   p_text=result;
   end_line();
   _set_focus();
}
void _browsedir2.lbutton_up()
{
   setDirectoryPathText();
}
void _browsedir1.lbutton_up()
{
   setDirectoryPathText();
}
_ctl_ok.on_create()
{
   _macro('m',_macro('s'));

   oncreateLoadOptions();
   
   /* We combine the Save and Backup create events because they both get
    * the def_save_options global variable.
    */
   oncreateSaveBackupOptions();
   oncreateAutoSave();
   oncreateFilters();

   _ctl_fileoptions_sstab._retrieve_value();
}

_ctl_ok.lbutton_up()
{
   oncloseLoadOptions();

   /* We combine the Save and Backup close events because they both set
    * the def_save_options global variable.
    */
   oncloseSaveBackupOptions();

   oncloseAutoSave();
   oncloseFilters();
   
   // Now do all the macro recording
   for( i._makeempty();; ) {
      _settings._nextel(i);
      if( i._isempty() ) break;
      if (substr(i,1,15) == "_default_option") {  // Support for _default_option() calls
         _macro_append(_settings:[i]);
      } else {
         if( !isinteger(_settings:[i]) ) {
            _macro_append(i"="_quote(_settings:[i]));
         } else {
            _macro_append(i"="_settings:[i]);
         }
      }
   }
   
   p_active_form._delete_window(0);
}

_ctl_ok.on_destroy()
{
   // Empty the _settings hash table so it doesn't get stored in the state file
   _settings._makeempty();
   _append_retrieve( _ctl_fileoptions_sstab, _ctl_fileoptions_sstab.p_ActiveTab);
}

#if 1 /* BEGIN Load Options */
static void oncreateLoadOptions()
{
   // Set default load options
   _count.p_user=0;

   // Parse load options in def_load_options
   list = def_load_options;
   for (;;) {
      parse list with option list;
      if (option == '') {
         break;
      }
      option = upcase(option);
      onoff = substr(option, 1, 1);
      ch=substr(option,2,1);

      /*Option is +/-Lx, where x is a suffix, x = {C|Z|NULL}*/
      switch (ch) {
      case 'L':
         //The option is +/-L
         suffix = strip(substr(option, 3));
         if (suffix=='E') {  // Show EOF
            if (onoff == '-') {
               ctlshoweof.p_value = 0;//Option is -L
            }else{
               ctlshoweof.p_value = 1;//Options is +L
            }
         } else if (suffix=='F') {  // Fast line count
            // Fast Line Count option is ignored
            // If load entire file is on.
            if (onoff == '-') {
               ctlfastlinecount.p_value = 0;//Option is -L
            }else{
               ctlfastlinecount.p_value = 1;//Options is +L
            }
         //} else if (suffix=='B') {  // Binary not supported
         } else {
            if (onoff == '-') {
               _entire.p_value = 0;//Option is -L
            }else{
               _entire.p_value = 1;//Options is +L
            }
            parse def_max_loadall with on value;
            _ctlls_load_partial.p_value=(int)(_ctlls_max_loadall.p_enabled=
               _ctlls_max_loadall.p_prev.p_enabled=on);
            _ctlls_max_loadall.p_text=value;
            /*Was Getting an extra space that threw things off*/
            switch (suffix) {
            case 'C':
               //p_user property is set because it is used to remember
               //the last value held in the box before the truncate box
               //was checked
               _count.p_value = _count.p_user = 1;
               break;
            case 'Z':
               _count.p_value = 1;
               _count.p_user  = 0;
               _truncate.p_value = 1;
               break;
            case '':
               break;//Case added so that '' is not cofused with an
                     //Invalid suffix
            default:
               _message_box(suffix' Is Not A Valid Suffix for This Options');
            }
         }
         break;
      case 'B':  //Option is +/- BP
         ch2=substr(option,3,1);
         if (ch2=='P') {
            if (onoff == '+') {
               _reinsert.p_value = 1;
            }
         }
         break;
      case 'N': // Option is +/- N
         if (onoff == '+') {
            ctlfilelocking.p_value = 1;
         }
         break;
      case 'E':
         if (onoff == '+') {
            _load_expand_tabs.p_value = 1;
         }
         break;
      case 'S':
         if (onoff == '+') {
            _unmodified_swapping.p_value = 1;
         }
         break;
      case 'U':
         if (onoff == '+') {
            _undo_on.p_value = 1;
         }
         parse option with option ':' num;
         if (num != '') {
            _undo_num.p_text = num;
         }else{
            _undo_num.p_text = 0;
         }
         if (!_undo_on.p_value) {
            _undo_num.p_next.p_enabled = _undo_num.p_enabled = 0;
         }//Disable control if no undo
         break;
      }

   }

   _maxfiles.p_text= def_max_filepos;
   if (def_max_filepos) {
      _savefilepos.p_value=1;
   }
   if (!_savefilepos.p_value) {
      _maxfiles.p_next.p_enabled = _maxfiles.p_enabled = 0;
   }

   ctlautoreload.p_value=(def_actapp&ACTAPP_AUTORELOADON);
   _reload_prompt.p_value=((def_actapp&ACTAPP_NORELOADPROMPT));
   ctlautoreadonly.p_value=((def_actapp&ACTAPP_AUTOREADONLY));
   if (!ctlautoreload.p_value) {
      ctlautoreadonly.p_enabled=_reload_prompt.p_enabled=0;
   }

   // Disable any controls which have been 'cancelled out'
   if (!_entire.p_value) {
      //_count.p_enabled = _truncate.p_enabled = 0;
      _count.p_enabled = _truncate.p_enabled = _ctlls_max_loadall.p_enabled=\
         _ctlls_load_partial.p_enabled=_ctlls_max_loadall.p_prev.p_enabled=\
         0;
   }
   if (!_undo_on.p_value) {
      _undo_num.p_next.p_enabled = _undo_num.p_enabled = 0;
   }
   if (_truncate.p_value) {
      _count.p_enabled=0;
   }
}

static void oncloseLoadOptions()
{
   load_options = '';
   new_options = '';
   /* +/- L[C|Z] Option */
   if (_entire.p_value) {
      option='+L';
   }else{
      option='-L';
   }
   /*
     Since the count options is actually a subset of the truncate
     option, the count box is only added to the options if the
     truncate box was not
   */
   if (_count.p_value && !_truncate.p_value) {
      option=option'C';
   }
   if (_truncate.p_value) {
      option=option'Z';
   }
   load_options=load_options:+option;
   /* +/-L[C|Z] Option */

   /* +/- BP Option */
   if (_reinsert.p_value) {
      option='+BP';
   }else{
      option='-BP';
   }
   load_options=load_options' 'option;
   /*End +/- BP Option */


   /* +/- N Option */
   if (ctlfilelocking.p_value) {
      option='+N';
   }else{
      option='-N';
   }
   load_options=load_options' 'option;
   /*End +/- N Option */

   /* +/- S Option */
   if (_unmodified_swapping.p_value) {
      option='+S';
   }else{
      option='-S';
   }
   load_options=load_options' 'option;
   /*End +/- S Option */

   /* +/- E Option */
   if (_load_expand_tabs.p_value) {
      option='+E';
   }else{
      option='-E';
   }
   load_options=load_options' 'option;
   /*End +/- E Option */

   /* +- LF Option */
   if (ctlfastlinecount.p_value) {
      option='+LF';
   }else{
      option='-LF';
   }
   load_options=load_options' 'option;
   /* +- LF Option */

   /* +/- LE Option */
   if (ctlshoweof.p_value) {
      option='+LE';
   }else{
      option='-LE';
   }
   load_options=load_options' 'option;
   /* +/- LE Option */

   /* +/- U:[nnn] Option */
   if (_undo_on.p_value) {
      if (!isinteger(_undo_num.p_text)) {
         _message_box('Invalid Number of Undoable Steps');
         return;
      }//Error Message for invalid undo data
      option='+U:'_undo_num.p_text;
   }else{
      option='-U:'_undo_num.p_text;
      /*
      I always save this number so the box is not blank next time
      the form shows
      */
   }
   load_options=load_options' 'option;
   /* +/- U:[nnn] Option */

   def_load_options = load_options;//Set actual load options
   _settings:["def_load_options"]=def_load_options;
   //_macro_append("def_load_options="_quote(def_load_options)";");

   if (_savefilepos.p_value) {
      if (!isinteger(_maxfiles.p_text)) {
         _message_box('Invalid Max Files');
         return;
      }
      def_max_filepos=(int)_maxfiles.p_text;
   } else {
      def_max_filepos=0;
   }
   _settings:["def_max_filepos"]=def_max_filepos;
   //_macro_append("def_max_filepos="def_max_filepos";");

   def_max_loadall=_ctlls_load_partial.p_value' '_ctlls_max_loadall.p_text;
   _settings:["def_max_loadall"]=def_max_loadall;
   //_macro_append("def_max_loadall="_quote(def_max_loadall)";");

   if (ctlautoreload.p_value) {
      def_actapp|=ACTAPP_AUTORELOADON;
   } else {
      def_actapp&=~ACTAPP_AUTORELOADON;
   }
   if (ctlautoreadonly.p_value) {
      def_actapp|=ACTAPP_AUTOREADONLY;
   } else {
      def_actapp&=~ACTAPP_AUTOREADONLY;
   }
   if (_reload_prompt.p_value) {
      def_actapp|=ACTAPP_NORELOADPROMPT;
   } else {
      def_actapp&=~ACTAPP_NORELOADPROMPT;
   }
   _settings:["def_actapp"]=def_actapp;
   //_macro_append("def_actapp="def_actapp";");
   
   _config_modify|=CFGMODIFY_DEFVAR;
}

_ctlls_load_partial.lbutton_up()
{
   _ctlls_max_loadall.p_enabled=_ctlls_max_loadall.p_prev.p_enabled= (p_value!=0);
}

ctlautoreload.lbutton_up()
{
   ctlautoreadonly.p_enabled=_reload_prompt.p_enabled=(ctlautoreload.p_value!=0);
}

_undo_on.lbutton_up()
{
   //Disable or enable controls if depending on state of undo box
   undo_num=p_next.p_next;
   spin=undo_num.p_next;
   spin.p_enabled=undo_num.p_enabled = (p_value!=0);
}

_savefilepos.lbutton_up()
{
   //Disable or enable controls if depending on state of Save/Restore File Pos box
   max_files=p_next.p_next;
   spin=max_files.p_next;
   spin.p_enabled=max_files.p_enabled = (p_value!=0);
}

_entire.lbutton_up()
{
   //name=_ctlls_max_loadall.p_next.p_name;
   _count.p_enabled = _truncate.p_enabled = _ctlls_max_loadall.p_enabled=\
      _ctlls_load_partial.p_enabled=_ctlls_max_loadall.p_prev.p_enabled=\
      (_entire.p_value!=0);
}

_truncate.lbutton_up()
{
   if (_truncate.p_value) {//Box has just been checked
      _count.p_user = _count.p_value;//Save _count's value
      _count.p_value = 1;//Turn on since it is a subset of _truncate
      _count.p_enabled=0;
   }else{//Box has just been un-checked
       _count.p_value = _count.p_user;//Restore _count's value
      _count.p_enabled=1;
   }
}
#endif /* END Load Options */

#if 1 /* BEGIN Save and Backup Options */
static void oncreateSaveBackupOptions()
{
   // Set default save options
   _appendeof.p_value         =0;   // default option -Z
   ctlremoveeof.p_value       =0;   // default option -ZR
   _save_expand_tabs.p_value  =0;   // default option -E
   _strip_spaces.p_value      =1;   // default option +S
   ctlresetlinemodify.p_value =1;   // default option -L
   _savelossfocus.p_value=((def_actapp&ACTAPP_SAVEALLONLOSTFOCUS));
   
   // Parse save options in def_save_options
   list = def_save_options;
   for (;;) {
      parse list with option list;
      option = upcase(option);
      if (option == '') {
         break;
      }
      onoff = substr(option, 1, 1);
      for (i=2;i<=length(option);++i) {
         ch=substr(option,i,1);
         switch (ch) {
         case 'Z':
            ch2=substr(option,i+1,1);
            if (ch2=='R') {
               ++i;
               if (onoff == '-') {
                  ctlremoveeof.p_value = 0;
               }else{
                  ctlremoveeof.p_value = 1;
               }
            } else {
               if (onoff == '-') {
                  _appendeof.p_value = 0;
               }else{
                  _appendeof.p_value = 1;
               }
            }
            break;
         case 'E':
            if (onoff == '-') {
               _save_expand_tabs.p_value = 0;
            }else{
               _save_expand_tabs.p_value = 1;
            }
            break;
         case 'S':
            if (onoff == '-') {
               _strip_spaces.p_value = 0;
            }else{
               _strip_spaces.p_value = 1;
            }
            break;
         case 'L':
            if (onoff == '-') {
               ctlresetlinemodify.p_value = 0;
            }else{
               ctlresetlinemodify.p_value = 1;
            }
            break;
         }
      }

   }
   
   // Set default backup options
   _make_backups.p_value =1;//default option '-O'
   _global_dir.p_value = 1;//default option '+D' (backup style)

   
   // Parse backup options in def_save_options
   list = def_save_options;
   for (;;) {
      parse list with option list;
      option = upcase(option);
      if (option == '') {
         break;
      }
      onoff = substr(option, 1, 1);
      for (i=2;i<=length(option);++i) {
         ch=substr(option,i,1);
         switch (ch) {
         case 'O':
            if (onoff == '-') {
               _make_backups.p_value = 1;
            }else{
               _make_backups.p_value = 0;
            }//This One looks kind of backwards, but its OK
            break;
         case 'D':
            ch2=substr(option,i+1,1);
            if (ch2=='K') {         // +/- DK
               ++i;
               _use_child.p_value = 1;
            }else if(ch2=='B'){     // +/- DB
               ++i;
               _write2same.p_value = 1;
            }else if(onoff=='-'){   // -D
               _global_nested.p_value = 1;
            }else {  // +D
               _global_dir.p_value = 1;
            }
            break;
         }
      }

   }

   // We want UNIX code to be the same here
   backupdir=get_env("VSLICKBACKUP");
   ctlbackupdir.p_user=backupdir;
   ctlbackupdir.p_text=backupdir;
   
   // Disable any controls which have been 'cancelled out'
   if (!_make_backups.p_value) {
      _write2same.p_enabled = _global_dir.p_enabled =
         _global_nested.p_enabled = _use_child.p_enabled = 0;
   }
}

static void oncloseSaveBackupOptions()
{
   save_options = '';
   new_options = '';
   if (_global_dir.p_value || _global_nested.p_value) {
      new_value=strip(ctlbackupdir.p_text,'B','"');
      status=_ConfigEnvVar("VSLICKBACKUP",new_value)
      if (status) {
         return;
      }
      _macro_call("_ConfigEnvVar","VSLICKBACKUP",new_value);
   }

   /* +/- O option*/
   if (_make_backups.p_value) {
      option='-O';
   }else{
      option='+O';
   }
   save_options = save_options:+option;
   /* +/- O option*/

   /* +/- Z option*/
   if (_appendeof.p_value) {
      option='+Z';
   }else{
      option='-Z';
   }
   save_options = save_options' 'option;
   /* +/- Z option*/


   /* +/- ZR option*/
   if (ctlremoveeof.p_value) {
      option='+ZR';
   }else{
      option='-ZR';
   }
   save_options = save_options' 'option;
   /* +/- ZR option*/

   /* +/- E option*/
   if (_save_expand_tabs.p_value) {
      option='+E';
   }else{
      option='-E';
   }
   save_options = save_options' 'option;
   /* +/- E option*/

   /* +/- S option*/
   if (_strip_spaces.p_value) {
      option='+S';
   }else{
      option='-S';
   }
   save_options = save_options' 'option;
   /* +/- S option*/

   /* +/- DB option*/
   if (_write2same.p_value) {
      save_options = save_options' +DB';
   }
   /* +/- DB option*/

   /* +/- DK option*/
   if (_use_child.p_value) {
      save_options = save_options' +DK';
   }
   /* +/- DK option*/

   /* + D option*/
   if (_global_dir.p_value) {
      save_options = save_options' +D';
   }
   /* + D option*/

   /* -D option*/
   if (_global_nested.p_value) {
      save_options = save_options' -D';
   }
   /* -D option */

   /* +L option*/
   if (ctlresetlinemodify.p_value) {
      option='+L';
   } else {
      option='-L';
   }
   save_options = save_options' 'option;
   /* +L */

   def_save_options = save_options;
   _settings:["def_save_options"]=def_save_options;
   //_macro_append("def_save_options="_quote(def_save_options)";");

   if (_savelossfocus.p_value) {
      def_actapp|=ACTAPP_SAVEALLONLOSTFOCUS;
   } else {
      def_actapp&=~ACTAPP_SAVEALLONLOSTFOCUS;
   }
   _settings:["def_actapp"]=def_actapp;
   //_macro_append("def_actapp="def_actapp";");

   _config_modify|=CFGMODIFY_DEFVAR;
}

_write2same.lbutton_up()
{
   if (_global_dir.p_value || _global_nested.p_value) {
      ctlbackupdir.p_enabled=ctlbackupdirlab.p_enabled=1;
   } else {
      ctlbackupdir.p_enabled=ctlbackupdirlab.p_enabled=0;
   }
}

_make_backups.lbutton_up()
{
   _write2same.p_enabled = _global_dir.p_enabled = _global_nested.p_enabled =
      _use_child.p_enabled = (_make_backups.p_value!=0);
}
#endif /* END Save and Backup Options */

#define SMALLEST_INTERVAL   10

      // Every .25 seconds


         // Timer amounts separated by spaces
         // inactive_amount absolute_amount config_amount



static void oncreateAutoSave()
{
   /*
     The inactive_amount and absolute_amount variables come from the
     separation of the def_as_timer_amounts variables.  These two halves
     are prefaced by a 'm' if the unit is minutes, or a 's' if the
     unit is seconds.  This was the easiest way to make the radio
     buttons come up preset right
   */
   _autosave_on.p_user = 0;
   parse def_as_timer_amounts with inactive_amount absolute_amount config_amount .;

   picture1.p_user = 0;

   if (inactive_amount == '') {
      inactive_amount = 'm1';
   }
   _inactive_amount.p_text = substr(inactive_amount, 2);

   chi = substr(inactive_amount,1,1);
   if (chi == 's') {
      _autosave_on.p_user = 1;
      _ia_seconds.p_value = 1;
      _inactive_spin.p_increment = SMALLEST_INTERVAL;
      picture1.p_user |= 0x2;
      _autosave_on.p_user = 0;
   }

   if (_inactive_amount.p_text < 0) {
      _autosave_on.p_user = 1;
      _ia_seconds.p_value = 1;
      _inactive_amount.p_text = ((int)_inactive_amount.p_text*60);
      _autosave_on.p_user = 0;
   }

   if (absolute_amount == '') {
      absolute_amount = 'm1';
   }
   _absolute_amount.p_text = substr(absolute_amount, 2);
   cha = substr(absolute_amount,1,1)
   if (cha == 's') {
      _autosave_on.p_user = 1
      _abs_seconds.p_value = 1;
      _absolute_spin.p_increment = SMALLEST_INTERVAL;
      picture1.p_user |= 0x8;
      _autosave_on.p_user = 0;
   }

   if (_absolute_amount.p_text < 0) {
      _autosave_on.p_user = 1
      _abs_seconds.p_value = 1;
      _absolute_amount.p_text = ((int)_absolute_amount.p_text+60)
      _autosave_on.p_user = 0;
   }

   _autosave_on.p_value = def_as_flags&AS_ON;

   /*
     these are used to change the increment on the spin control
     so that all 4 radio buttons can have one event handler.
     the last 'field' is an id that I use to make sure that the
     most recent button pressed wasn't pressed twice in a row.
     The first and second field are the window id of the spin
     control that corresponds to the radio button and the increment
     amount that will be appropriate once the radio button is pressed
   */
   _ia_minutes.p_user  = _control _inactive_spin' '1' '0x1;
   _ia_seconds.p_user  = _control _inactive_spin' 'SMALLEST_INTERVAL' '0x2;
   _abs_minutes.p_user = _control _absolute_spin' '1' '0x4;
   _abs_seconds.p_user = _control _absolute_spin' 'SMALLEST_INTERVAL' '0x8;

   _directory.p_text = def_as_directory;

   if (def_as_flags&AS_ASDIR) {
      _difdir.p_value = 1;
   }else if(def_as_flags&AS_DIFFERENT_EXT){
      _difext.p_value = 1;
   }else{
      _samefile.p_value = 1;
   }
   _directory.p_enabled = (_difdir.p_value!=0 && _autosave_on.p_value);
   if (config_amount=='') {
      config_amount=20;
   }
   //_config_time.p_text=config_amount;
   //_save_windows.p_value=def_as_flags&AS_SAVE_WINDOWS;
   /*if (!def_auto_restore) {
      _save_windows.p_enabled=0;
   }
   */
   _autosave_on.call_event(_autosave_on,LBUTTON_UP);
   //_asl1.p_enabled=_asl2.p_enabled=_config_time.p_enabled=_config_time_spin.p_enabled=_save_windows.p_value;
   _directory.p_text = def_as_directory;
   _max_file_size.p_text=isinteger(def_max_autosave)?def_max_autosave:100;
}

static void oncloseAutoSave()
{
   if ((!isnumber(_inactive_amount.p_text))) {
      _message_box('Invalid number');
      p_window_id = _control _inactive_amount;
      _set_sel(1, length(_inactive_amount.p_text) +1)
      return;
   }
   if ((!isnumber(_absolute_amount.p_text))) {
      _message_box('Invalid number');
      p_window_id = _control _absolute_amount;
      _set_sel(1, length(_absolute_amount.p_text) +1)
      return;
   }
   if (!isinteger(_max_file_size.p_text)) {
      _message_box('Invalid number');
      p_window_id = _control _max_file_size;
      _set_sel(1, length(_max_file_size.p_text) +1)
      return;
   }
   parse def_as_timer_amounts with inactive_amount absolute_amount config_amount .
   absolute_amount = _absolute_amount.p_text;
   inactive_amount = _inactive_amount.p_text;
   def_as_directory = _directory.p_text;
   _settings:["def_as_directory"]=def_as_directory;
   //_macro_append('def_as_directory = '_quote(_directory.p_text)";");
   _config_modify|= CFGMODIFY_DEFVAR;
   
   if (_ia_minutes.p_value) {
      chi = 'm';
   }else{
      chi = 's';
      if (inactive_amount > 0 && inactive_amount < SMALLEST_INTERVAL) {
         inactive_amount = SMALLEST_INTERVAL
      }
   }
   if (_abs_minutes.p_value) {
      cha = 'm';
   }else{
      cha = 's';
      if (absolute_amount > 0 && absolute_amount < SMALLEST_INTERVAL) {
         absolute_amount = SMALLEST_INTERVAL
      }
   }
   as_flags=def_as_flags;
   as_flags &= ~AS_DIFFERENT_EXT;
   as_flags &= ~AS_SAMEFN;
   as_flags &= ~AS_ASDIR;
   if (_difdir.p_value) {
      as_flags |= AS_ASDIR;
   }else if(_difext.p_value){
      as_flags |= AS_DIFFERENT_EXT;
   }else{
      as_flags |= AS_SAMEFN;
   }
   
   inactive_amount=chi:+inactive_amount;
   absolute_amount=cha:+absolute_amount;
   def_as_timer_amounts = inactive_amount' 'absolute_amount;//' '_config_time.p_text;
   _settings:["def_as_timer_amounts"]=def_as_timer_amounts;
   //_macro_append('def_as_timer_amounts='_quote(def_as_timer_amounts)';')
   _config_modify|= CFGMODIFY_DEFVAR;
   
   if (!_autosave_on.p_value) {
      as_flags &= ~AS_ON;
   } else {
      as_flags |= AS_ON;
   }
   if (!_autosave_on.p_value) {
      _as_allocfree_timer();
   }
   aslast_time = _time('b');
   if (aslast_time == '') {
      return;
   }
   
   /*if (_save_windows.p_value) {
      as_flags|=AS_SAVE_WINDOWS;
   }else{
      as_flags&=~AS_SAVE_WINDOWS;
   } */

   def_as_flags=as_flags;
   _config_modify|= CFGMODIFY_DEFVAR;
   _settings:["def_as_flags"]=def_as_flags;
   //_macro_append("def_as_flags="def_as_flags";");

   _as_allocfree_timer();
   
   def_max_autosave=(int)_max_file_size.p_text;
   _settings:["def_max_autosave"]=def_max_autosave;
   //_macro_append('def_max_autosave='def_max_autosave";");
   _config_modify|= CFGMODIFY_DEFVAR;
}

_samefile.lbutton_up()
{
   _dirlabel.p_enabled = _directory.p_enabled = _difdir.p_value!=0;
}

_ia_minutes.lbutton_up()
{
   if (_autosave_on.p_user) {
      return('')
   }
   if ((!isnumber(_inactive_amount.p_text))) {
      _message_box('Invalid number');
      p_window_id = _control _inactive_amount;
      _set_sel(1, length(_inactive_amount.p_text) +1)
      return('');
   }
   if ((!isnumber(_absolute_amount.p_text))) {
      _message_box('Invalid number');
      p_window_id = _control _absolute_amount;
      _set_sel(1, length(_absolute_amount.p_text) +1)
      return('');
   }
   parse p_user with wid amount id;
   if ((picture1.p_user & id)  || (wid.p_increment == amount)) {
      return('');
   }
   picture1.p_user = id;

   wid.p_increment = amount;
   if (wid.p_name == '_inactive_spin') {
      if (p_caption == 'Minutes') {
         _inactive_amount.p_text = ((int)_inactive_amount.p_text/60);
         _absolute_amount.p_text = trunc(_absolute_amount.p_text,2);
      }else{
         _inactive_amount.p_text = ((int)_inactive_amount.p_text*60);
         _absolute_amount.p_text = trunc(_absolute_amount.p_text,2);
      }
   }else{
      if (p_caption == 'Minutes') {
         _absolute_amount.p_text = ((int)_absolute_amount.p_text/60);
         _absolute_amount.p_text = trunc(_absolute_amount.p_text,2);
      }else{
         _absolute_amount.p_text = ((int)_absolute_amount.p_text*60);
         _absolute_amount.p_text = trunc(_absolute_amount.p_text,2);
      }
   }
}

static trunc(num)
{
   if (arg(2) == '') {
      place = 1
   }else{
      place = arg(2);
   }
   if (pos('.', num)) {
      for (i = 1; i <= place; ++i) {
         num = num:+'0';
      }
      num = num :+ '5';
      if (pos('.', num)) {
         if (pos('.', num)+place > length(num)) {
            num = substr(num, pos('.', num));
         }
         num = substr(num, 1, pos('.', num)+place)
      }
   }
   if (pos('.', num)) {
      if (length(num) == pos('.', num) + 1) {
         return(substr(num, 1, pos('.', num) - 1));
      }
      for (i = pos('.', num); i <= length(num); ++i) {
         if (i != 0) {
            return(num);//Number had REAL decimal places(not 3.0000)
         }
      }
   }
   if (pos('.', num)) {
      num = substr(num, 1, pos('.', num) - 1);
   }
   return(num);
}


_difdir.lbutton_up()
{
   _dirlabel.p_enabled = _directory.p_enabled = p_value!=0;
}

void _autosave_on.lbutton_up()
{
   boolean state;
   state = true;
   if (_autosave_on.p_value == 0) {
      state = false;
   }
   _inactive_amount.p_enabled = state;
   _inactive_spin.p_enabled = state;
   _absolute_amount.p_enabled = state;
   _absolute_spin.p_enabled = state;
   _ia_minutes.p_enabled = state;
   _ia_seconds.p_enabled = state;
   _abs_minutes.p_enabled = state;
   _abs_seconds.p_enabled = state;
   //_save_windows.p_enabled = state;
   _directory.p_enabled = state;
   _browsedir2.p_enabled = state;
   _difdir.p_enabled = state;
   _difext.p_enabled = state;
   _samefile.p_enabled = state;
   _max_file_size.p_enabled = state;
}


#if 1 /* BEGIN Filters */
static void oncreateFilters()
{
   _filters.p_text=def_file_types;
}

static void oncloseFilters()
{
   def_file_types=_filters.p_text;
   _settings:["def_file_types"]=def_file_types;
   //_macro_append("def_file_types="_quote(def_file_types)";");
   _config_modify|=CFGMODIFY_DEFVAR;
}
#endif /* END Filters */

