#include "slick.sh"
#include "sock.sh"
#include "ftp.sh"

static _str _ftpVSProxyPath="";
int _ftpQTimer= -1;

#define _ftpUseShortFilenames ((substr(machine(),1,2)=="NT" && _win32s()==1) || machine()=="OS2386")

#define FTPBM_FTPCDUP "_ftpcdup.bmp"
#define FTPBM_FTPFILE "_ftpfile.bmp"
#define FTPBM_FTPFOLD "_ftpfold.bmp"
#define FTPBM_FTPLFOL "_ftplfol.bmp"
#define FTPBM_FTPLFIL "_ftplfil.bmp"

static int _MaybeLoadPicture(_str filename)
{
   if( filename=="" ) return(-1);

   idx=find_index(filename,PICTURE_TYPE);
   if( !idx ) {
      path=slick_path_search(filename);
      if( path=="" ) return(-1);
      idx=_update_picture(-1,path);
      if( idx<0 ) return(-1);
   }

   return(idx);
}

int gftp_todo_view_id=0;
static boolean gIniInitDone;

_str _ftpUserIniFilename() 
{
   if (gIniInitDone) {
      return(_config_path():+FTP_USER_INI_FILENAME);
   }
   filename=_config_path():+FTP_USER_INI_FILENAME;
   if( filename=="" || file_match("-p "maybe_quote_filename(filename),1)=="" ) {
      IniFilename=_MaybeCreateUserIniFile();
      if( IniFilename=='' ) {
         _message_box('Cannot find or create configuration file "':+filename:+'"',FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
         return(1);
      }
   }
   gIniInitDone=true;
   return(filename);
}

definit()
{
   gIniInitDone=false;

   if( arg(1)!='L' ) {
      gftp_todo_view_id=0;
   }
   
   if( arg(1)!='L' ) {   // Don't blow away list of existing connections if loading
      _ftpCurrentConnections._makeempty();
      _ftpFileHist._makeempty();
      _ftpQ._makeempty();
   }

   // Q timer
   #if 1
   if( arg(1)=='L') {
      if( _ftpQTimer>=0 ) {
         _kill_timer(_ftpQTimer);
      }
   }
   _ftpQTimer=_set_timer(100,_ftpQTimerCallback);
   if( arg(1)=='L' ) {
      /* If we are reloading because a timer died we will want to re-enable
       * all forms.
       */
      call_list('_ftpQIdle_');
   }
   #endif

   if (arg(1)=='L') {
      // Pictures
      _pic_ftpcdup=_MaybeLoadPicture(FTPBM_FTPCDUP);
      _pic_ftpfile=_MaybeLoadPicture(FTPBM_FTPFILE);
      _pic_ftpfold=_MaybeLoadPicture(FTPBM_FTPFOLD);
      _pic_ftplfol=_MaybeLoadPicture(FTPBM_FTPLFOL);
      _pic_ftplfil=_MaybeLoadPicture(FTPBM_FTPLFIL);

   }
   rc=0;
}

/* Used to keep track of tree items even after the user kills the
 * FTP Client toolbar. Very useful if the user starts downloading
 * multiple items and then kills the toolbar.
 */
void _ftpTodoGetList(int tree_wid) 
{
   if( !gftp_todo_view_id ) {
      orig_view_id=_create_temp_view(gftp_todo_view_id);
      p_buf_name=".FTP todo list";
      p_buf_flags|=KEEP_ON_QUIT|THROW_AWAY_CHANGES;
   } else {
      get_view_id(orig_view_id);
      activate_view(gftp_todo_view_id);
      _lbclear();
   }
   ff=1;
   for( ;; ) {
      index=tree_wid._TreeFindSelected(ff);ff=0;
      if( index<0 ) {
         break;
      }
      caption=tree_wid._TreeGetCaption(index);
      userinfo=tree_wid._TreeGetUserInfo(index);
      insert_line(caption""userinfo);
   }
   top();up();
   activate_view(orig_view_id);
   
   return;
}
int _ftpTodoFindNext()
{
   get_view_id(orig_view_id);
   activate_view(gftp_todo_view_id);
   if( down() ) {
      activate_view(orig_view_id);
      return(-1);
   }
   next=p_line;
   activate_view(orig_view_id);
   return(next);
}
void _ftpTodoGetCaption(_str &caption)
{
   get_view_id(orig_view_id);
   activate_view(gftp_todo_view_id);
   get_line(line);
   parse line with caption "" .;
   activate_view(orig_view_id);
   
   return;
}

void _ftpTodoGetUserInfo(_str &userinfo)
{
   get_view_id(orig_view_id);
   activate_view(gftp_todo_view_id);
   get_line(line);
   parse line with . "" userinfo;
   activate_view(orig_view_id);
   
   return;
}

boolean isuncdirectory(_str path)
{
   if( substr(path,1,2)!='\\' ) return(false);
#if __UNIX__
   return(false)
#elif __PCDOS__
   if( last_char(path)!=FILESEP ) path=path:+FILESEP;
   if (file_match('+d ':+maybe_quote_filename(path:+ALLFILES_RE),1)=='') {
      return(false);
   }
#else
   What about this os
#endif

   return(true);
}

/* htindex is the hash table index that this connection was stored under.
 * In most cases htindex will be the same as the ProfileName, except for
 * the case of there being more than one instance of a connection. In this
 * case htindex will be the ProfileName with an instance number appended
 * to it. Example:
 *
 * Sunsite [2]   <--- where the '[2]' represents the 2nd instance of a
 *                    connection to Sunsite
 */
int _ftpAddCurrentConnProfile(ftpConnProfile_t *fcp_p,_str &htindex)
{
   int greatest_instance;

   if( fcp_p->ProfileName=="" ) return(1);

   /* If there is more than one instance of this connection profile,
    * then update the Instance field accordingly. Find the highest
    * Instance number and increment that since the user might have
    * killed instance 3 out of a total 10 instances.
    */
   greatest_instance= -1;
   profile_name=fcp_p->ProfileName;
   htindex=profile_name;
   for( i._makeempty();; ) {
      _ftpCurrentConnections._nextel(i);
      if( i._isempty() ) break;
      if( _ftpCurrentConnections:[i].ProfileName==profile_name ) {
         instance=_ftpCurrentConnections:[i].Instance;
         if( instance>greatest_instance ) {
            greatest_instance=instance;
         }
      }
   }
   fcp_p->Instance=greatest_instance+1;
   if( fcp_p->Instance>0 ) {
      // Remember: Display instances as 1-based starting with the 2nd instance
      instance=fcp_p->Instance+1;
      htindex=htindex:+" [":+instance:+"]";
   }
   fcp_p->PostedCB=0;
   _ftpCurrentConnections:[htindex]= *fcp_p;

   return(0);
}

/* NOTE: If the pointer passed into this function points directly to an
 *       element of the _ftpCurrentConnections:[] hash table, then that
 *       pointer will not be valid after this function returns.
 */
void _ftpRemoveCurrentConnProfile(ftpConnProfile_t *fcp_p)
{
   profile_name=fcp_p->ProfileName;
   if( profile_name=="" ) return;   // This should never happen
   instance=fcp_p->Instance;

   // Find the current connection profile with matching ProfileName and Instance
   for( i._makeempty();; ) {
      _ftpCurrentConnections._nextel(i);
      if( i._isempty() ) break;
      if( _ftpCurrentConnections:[i].ProfileName==profile_name &&
          _ftpCurrentConnections:[i].Instance==instance ) {
         _ftpCurrentConnections:[i]._makeempty();
         break;
      }
   }

   return;
}

ftpConnProfile_t * _ftpIsCurrentConnProfile(_str ProfileName)
{
   if( ProfileName=="" ) return(0);

   if( !_ftpCurrentConnections._isempty() && _ftpCurrentConnections._indexin(ProfileName) ) {
      return(&(_ftpCurrentConnections:[ProfileName]));
   }

   return(0);
}

/* Function Name : _ftpHostNameToCurrentConnection(_str Host, _str (&ProfileName)[])
 *
 * Parameters:
 *   Host        - Name of the host to match
 *   ProfileName - Array of profile names matching Host.
 *
 * Description:
 *   Attempts to find FTP connection profile name(s) that match the host name
 *   passed in. The result is an array of strings which represent a list of
 *   all matching FTP connection profile names.
 *
 * Description:
 *   Attempts to find an FTP connection profile name from the list of current
 *   connections that matches the host name passed in. The result is an array
 *   of strings which represent a list of all matching FTP connection profile
 *   names.
 *
 * Returns:
 *   Returns 0 if match(es) are found. Otherwise non-zero is returned.
 */
int _ftpHostNameToCurrentConnection(_str Host,_str (&ProfileName)[])
{
   _str temparr[];

   // Find all profiles matching Host
   temparr._makeempty();
   for( i._makeempty();; ) {
      _ftpCurrentConnections._nextel(i);
      if( i._isempty() ) break;
      if( _ftpCurrentConnections:[i].Host==Host ) temparr[temparr._length()]=i;
   }
   if( temparr._length() ) {
      ProfileName=temparr;
      return(0);
   }

   return(1);   // No match for Host
}

#define HHWCCP_NEW "[New]"
static _str _hhwccpCallback(int reason,_str &result,_str button)
{
   if( reason==SL_ONDEFAULT ) {  // Enter key
      profile=_sellist._lbget_text();
      result=profile;
      return(1);
   }
   user_button=reason==SL_ONUSERBUTTON;
   if( reason!=SL_ONUSERBUTTON ) return("");
   switch( button ) {
   case 4:
      result=HHWCCP_NEW;
      return(1);
   }

   return("");
}

/* _ftpHHWCreateConnProfile(_str Host,
 *                          _str Port,
 *                          ftpConnProfile_t *fcp_p,
 *                          boolean Connect)
 *
 * Parameters:
 *   Host - Host name
 *   Port - Connection port (e.g. "ftp" or 21)
 *   fcp_p - Pointer to a connection profile structure
 *   Connect - If true then the created connection profile is started
 *             (or maybe restarted if it was in the list of current
 *             connections).
 *
 * Description:
 *   This function attempts to create a connection profile by any means
 *   possible. It checks the list of current connections, the profiles
 *   stored in the user ftp ini file, and then, finally, brings up a
 *   dialog so that the user can create their own.
 *
 *   Note: HHW is short for Heck or High Water
 *
 * Returns:
 *   Returns 0 if connection profile is created successfully. Otherwise
 *   non-zero is returned.
 *
 */
int _ftpHHWCreateConnProfile(_str Host,_str Port,ftpConnProfile_t *fcp_p)
{
   _ftpInitConnProfile(*fcp_p);
   _str profile;

   profile="";

   // Check for current connections matching host
   if( !_ftpHostNameToCurrentConnection(Host,list) ) {
      // There are 1 or more current FTP connections matching this host
      if( list._length()>1 ) {
         // We have more than 1 match, so make user pick
         result=show("-modal _sellist_form","Multiple Matching Connections Found",SL_DEFAULTCALLBACK,list,"OK,&New","?Pick from the list of current connections or create a new connection","",_hhwccpCallback);
         if( result=="" ) return(COMMAND_CANCELLED_RC);
         profile=result;
         if( profile!=HHWCCP_NEW ) {
            *fcp_p=_ftpCurrentConnections:[profile];
         }
      } else {
         *fcp_p=_ftpCurrentConnections:[list[0]];
      }
      if( profile!=HHWCCP_NEW ) {
         if( fcp_p->ProfileName!="" ) {
            return(0);
         } else {
            return(1);
         }
      }
      // Fall thru
   }

   /* If there is not a current connection OR the user specified to create
    * a new connection profile.
    */
   if( fcp_p->ProfileName=="" ) {
      // Prompt for login info
      status=show("-modal _ftpProfileManager_form",fcp_p);
      if( status ) {
         if( status=="" ) {
            // User cancelled
            return(COMMAND_CANCELLED_RC);
         }
         return(status)
      }
   }

   return(0);
}

boolean _ftpIsConnActive(ftpConnProfile_t *fcp_p)
{
   if( fcp_p->sock==INVALID_SOCKET ) return(false);
   if( !vssIsConnectionAlive(fcp_p->sock) ) return(false);
   status=_ftpCommand(fcp_p,true,"NOOP");
   if( status ) return(false);
   status=_ftpCheckResponse(fcp_p,1);   // Pass 1 as arg2 so that response is not logged
   // A bad response from the FTP server does not mean we are disconnected
   if( status && status!=FTP_BAD_RESPONSE_RC ) return(false);

   return(true);
}

void _ftpLog(ftpConnProfile_t *fcp_p,_str buf)
{
   if( fcp_p->LogBufName=="" ) return;

   orig_view_id=p_view_id;
   p_view_id=HIDDEN_VIEW_ID;
   orig_buf_id=p_buf_id;
   for(;;) {
      if( p_buf_name==fcp_p->LogBufName ) {
         bottom();
         break;
      }
      _next_buffer("HR");
      if( p_buf_id==orig_buf_id ) break;   // This should never happen
   }
   if( p_buf_name!=fcp_p->LogBufName ) {
      p_view_id=orig_view_id;
      return;
   }

   // Make sure we log the response on a line of its own
   bottom();
   if( _line_length()!=0 ) {
      insert_line('');
   }
   if( _ftpdebug&FTPDEBUG_TIME_STAMP ) {
      insert_line(_time('M'));
      insert_line('');
   }
   _insert_text(buf);
   if( _ftpdebug&FTPDEBUG_SAVE_LOG ) {
      if( machine()=='OS2386' || _win32s()==1 ) {
         // 8.3
         save_file('ftplog','+o');
      } else {
         save_file('','+o');
      }
   }
   p_view_id=orig_view_id;

   // Make sure we are always at the bottom of the log window on the toolbar
   _control _ctl_ftp_sstab;
   ftpclient_wid=_find_object("_tbFTPClient_form","N");
   if( ftpclient_wid ) {
      sstab_wid=ftpclient_wid._ctl_ftp_sstab;
      for( i=0;i<sstab_wid.p_NofTabs;++i ) {
         text=sstab_wid._getTabInfo(i);
         parse text with enabled order pic partialCaption x1 y1 x2 y2 fa minW maxW theRest;
         caption=stranslate(extractCaption(theRest),'','&');
         if( caption=="Log" ) {
            log_wid=sstab_wid._find_control("_ctl_log");
            if( log_wid ) {
               if( log_wid.p_buf_name==fcp_p->LogBufName ) {
                  // We only refresh the log if it is for this connection
                  log_wid.bottom();
                  log_wid.refresh();
               }
            }
         }
      }
   }

   return;
}

/* Function Name : _ftpCommand(ftpConnProfile_t *fcp_p, boolean quiet,
 *                             typeless cmd [,arg1 [,arg2 ... [,argN]]])
 *
 * Parameters:
 *   fcp_p - Pointer to current connection struct.
 *   quiet - true=Do not log command.
 *   cmd  - Command to send to FTP socket (i.e. - "USER", "PASV", etc.).
 *          If this argument is an array then it is in the format:
 *            cmd[0] = Name of the command
 *            cmd[1] ... cmd[n] = Arguments to the command
 *          and all other argument are ignored.
 *   arg1...argN - Additional arguments to append to cmd.
 *
 * Description:
 *   Send a command to an FTP socket. Handle any error condition sent back
 *   throught the socket. If quiet is true then the command itself is not
 *   logged.
 *
 * Returns:
 *   Returns 0 if successful. Common return codes are:
 *     SOCK_NOT_INIT_RC
 *     SOCK_TIMED_OUT_RC
 */
static int _ftpCommand(ftpConnProfile_t *fcp_p,boolean quiet,typeless cmd,...)
{
   if( !vssIsConnectionAlive(fcp_p->sock) ) {
      _ftpLog(fcp_p,"Connection lost");
      return(FTP_CONNECTION_DEAD_RC);
   }
   if( cmd._varformat()==VF_ARRAY ) {
      // We have an array representing the command and arguments
      line=strip(cmd[0]);
      for( i=1;i<cmd._length();++i ) {
         line=line" "cmd[i];
      }
   } else {
      // Append additional arguments
      line=strip(cmd);
      if( substr(line,length(line),1)=="\n" ) {   // Strip eol
         if( substr(line,length(line)-1,1)=="\r" ) {
            line=substr(line,1,length(line)-2);
         } else {
            line=substr(line,1,length(line)-1);
         }
      }
      for( i=4;i<=arg();++i ) {
         line=line" "arg(i);
      }
   }

   /* Log any responses that may have come in already.
    * This could happen if we aborted a command before we got the
    * response, or if the ftp server spontaneously sent a message.
    */
   ftpQEvent_t event;   // Fake event
   event._makeempty();
   event.event=0;
   event.fcp= *fcp_p;
   event.start=0;
   event.state=0;
   status=_ftpQCheckResponse(&event,false,dummy,false);
   if( status ) {
      // Don't care
   }

   if( !quiet || _ftpdebug) {
      _ftpLog(fcp_p,line);
   }

   //line=line:+EOL;
   line=line:+"\r\n";   // Use telnet NVT protocol linebreak
   status=vssSocketSendZ(fcp_p->sock,line);

   return(status);
}

static int _ftpPass(ftpConnProfile_t *fcp_p,_str pass)
{
   if( !vssIsConnectionAlive(fcp_p->sock) ) {
      _ftpLog(fcp_p,"Connection lost");
      return(FTP_CONNECTION_DEAD_RC);
   }
   //line="PASS ":+pass:+EOL;
   line="PASS ":+pass:+"\r\n";   // Use telnet NVT protocol linebreak
   _ftpLog(fcp_p,"PASS (hidden)");
   status=vssSocketSendZ(fcp_p->sock,line);

   return(status);
}

static int _ftpType(ftpConnProfile_t *fcp_p)
{
   // Ascii or Binary transfer?
   switch( fcp_p->XferType ) {
   case FTPXFER_ASCII:
      status=_ftpCommand(fcp_p,false,"TYPE","A");
      break;
   case FTPXFER_BINARY:
      status=_ftpCommand(fcp_p,false,"TYPE","I");
      break;
   default:
      // Should never get here
      status=_ftpCommand(fcp_p,false,"TYPE","I");
   }
   if( status ) return(status);

   return(0);
}

_str _ftpAbsolute(ftpConnProfile_t *fcp_p,_str remote_path)
{
   if( substr(remote_path,1,1)=='/' ) return(remote_path);   // Already absolute

   cwd=fcp_p->RemoteCWD;
   if( last_char(cwd)!='/' ) cwd=cwd:+'/';
   return(cwd:+remote_path);
}

_str _ftpUploadCase(ftpConnProfile_t *fcp_p,_str filename)
{
   if( fcp_p->UploadCase==FTPFILECASE_LOWER ) {
      return(lowcase(filename));
   } else if( fcp_p->UploadCase==FTPFILECASE_PRESERVE ) {
      return(filename);
   } else {
      // FTPFILECASE_UPPER
      return(upcase(filename));
   }
}

boolean _FilespecMatches(_str filespec,_str filename,...)
{
   fcase="";
   if( arg()>2 ) {
      fcase=arg(3);
   }
   if( fcase=="" ) fcase=_fpos_case;
   filespec=strip(filespec);
   if( filespec=='*' ) return(true);
   filespec_re=stranslate(filespec,'?*','*');
   filespec_re=stranslate(filespec_re,'\\','\');
#if __PCDOS__
   if( substr(filespec_re,length(filespec_re)-2,2)=='.*' ) {
      filespec_re=substr(filespec_re,1,length(filespec_re)-2):+'(.|)?*';
   }
#endif
   filespec_re='^'filespec_re'$';
   p=pos(filespec_re,filename,1,'r'fcase);
   return( p!=0 );
}

// Fill the connection profile's remote directory member with directory data
int _ftpCreateDir(ftpConnProfile_t *fcp_p,_str src_filename)
{
   ftpFile_t file;

   if( src_filename=="" ) return(1);

   orig_view_id=p_view_id;

   status=_open_temp_view(src_filename,temp_view_id,orig_view_id);
   if( status ) {
      msg='Could not open file "':+src_filename:+'".  ':+_ftpGetMessage(status);
      _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return(status);
   }
   p_view_id=temp_view_id;

   // Now massage the directory buffer into an ftp directory struct
   filter=strip(fcp_p->RemoteFileFilter);
   if( filter=="" ) filter=FTP_ALLFILES_RE;
   fcp_p->RemoteDir._makeempty();
   p_view_id=temp_view_id;
   top();
   get_line(line);
   parse line with word .;
   if( length(word)!=length("drwxrwxrwx") ) {
      // Get rid of the "total n" line
      _delete_line();
   }
   status=0;
   top();up();
   for(;;) {
      if( down() ) break;
      if( _line_length(0)==_line_length(1) ) break;   // Last line had no linebreak

      get_line(line);
      if( line=="" ) break;   // Done
      parse line with attribs refs owner group size month day yeartime filename;

      if( attribs=="" ) {
         // This should never happen
         attribs=substr("",1,length("drwxrwxrwx"),'-');
      }
      file.attribs=attribs;
      file.type=0;
      if( lowcase(substr(file.attribs,1,1))=='d' ) {
         // We have a directory
         file.type |= FTPFILETYPE_DIR;
      }
      if( lowcase(substr(file.attribs,1,1))=='l' ) {
         // We have a link
         file.type |= (FTPFILETYPE_DIR|FTPFILETYPE_LINK);
      }

      if( filename=="" ) {
         /* Skip it. This can happen on OS/390 machines with a filename that
          * is all spaces.
          */
         continue;
      }
      if( filename=="." || filename==".." ) continue;
      if( !(file.type&FTPFILETYPE_DIR) &&
          filter!=FTP_ALLFILES_RE ) {
         match=false;
         list=filter;
         while( list!="" ) {
            filespec=parse_file(list);
            filespec=strip(filespec,'B','"');
            if( filespec=="" ) continue;
            if( _FilespecMatches(filespec,filename,'e') ) {
               // Found a match
               match=true;
               break;
            }
         }
         if( !match ) continue;
      }
      file.filename=filename;

      if( !isinteger(size) ) {
         size="0";
      }
      file.size= (int)size;

      if( month=="" ) {
         // This should never happen
         month="???";
      }
      file.month=substr(month,1,3);   // Only allow first 3 chars of month

      if( !isinteger(day) ) {
         day="0";
      }
      file.day= (int)day;

      if( yeartime=="" ) {
         // This should never happen
         yeartime="0:00";
      }
      if( pos(':',yeartime) ) {
         // There is a time instead of a year - use the current year???
         parse _date('U') with . '/' . '/' year;
         time=yeartime;
      } else {
         // There is year instead of a time
         year=yeartime;
         time="0:00";
      }
      file.year= (int)year;
      file.time=time;

      file.owner=owner;

      file.group=group;

      if( !isinteger(refs) ) {
         refs="0";
      }
      file.refs= (int)refs;

      // Add it to the array
      fcp_p->RemoteDir.files[fcp_p->RemoteDir.files._length()]=file;
   }
   _delete_temp_view(temp_view_id);
   p_view_id=orig_view_id;

   return(status);
}

/* This function checks if name is a valid file/directory/link in the connection
 * profile's current working directory. If the file/directory/link exists,
 * then flags are set to the type flags for the matching entry.
 */
boolean _ftpExists(ftpConnProfile_t *fcp_p,_str name,int &flags)
{
   ftpFile_t file;

   len=fcp_p->RemoteDir.files._length();
   for( i=0;i<len;++i ) {
      file=fcp_p->RemoteDir.files[i];
      if( file.filename==name ) {
         flags=file.type;
         return(true);
      }
   }

   return(false);
}

/* Use this function to test whether there is an FTP operation currently
 * in progress. This is an especially useful test to make before exiting
 * the editor.
 */
boolean _ftpInProgress()
{
   if( _ftpQ._length()<1 ) return(false);
   
   for( i=0;i<_ftpQ._length();++i ) {
      if( _ftpQ[i].event!=QE_END_CONN_PROFILE &&
          _ftpQ[i].event!=QE_KEEP_ALIVE ) {
         return(true);
      }
   }
   
   return(false);
}

// Use this to optimize the number of updates
static boolean _in_MaybeUpdate=false;

/* Used to update the session on the FTP Client toolbar.
 * FTP Client session will be updated if its profile matches
 * the one passed in.
 */
void _MaybeUpdateFTPClient(_str profile)
{
   int clientformWid;
   int clientprofileWid;
   
   if( _in_MaybeUpdate ) return;
   
   /* Update the FTP Client toolbar.
    * IF visible AND we can find the profile combo box.
    * IF there is no active connection OR the FTP Client toolbar is showing
    * the same connection as profile name passed in.
    */
   clientformWid=_find_object("_tbFTPClient_form","N");
   if( !clientformWid ) return;
   clientprofileWid=clientformWid._find_control("_ctl_profile");
   if( !clientprofileWid ) return;
   if( profile=="" || clientprofileWid.p_text=="" || clientprofileWid.p_text==profile ) {
      _in_MaybeUpdate=true;
      clientprofileWid.call_event(CHANGE_SELECTED,clientprofileWid,ON_CHANGE,'W');
      #if 1
      // Now synch up the progress labels between the 2 toolbars
      openformWid=_find_object("_tbproject_form","N");
      if( openformWid ) {
         clientlabel1Wid=clientformWid._find_control("_ctl_progress_label1");
         clientlabel2Wid=clientformWid._find_control("_ctl_progress_label2");
         openlabel1Wid=openformWid._find_control("_ctl_operation");
         openlabel2Wid=openformWid._find_control("_ctl_nofbytes");
         if( clientlabel1Wid && clientlabel2Wid && openlabel1Wid && openlabel2Wid ) {
            clientlabel1Wid.p_caption=openlabel1Wid.p_caption;
            clientlabel2Wid.p_caption=openlabel2Wid.p_caption;
         }
      }
      #endif
      _in_MaybeUpdate=false;
   }

   return;
}

/* Used to update the session on the FTP Open tab.
 * FTP Open tab session will be updated if its profile matches
 * the one passed in.
 */
void _MaybeUpdateFTPTab(_str profile)
{
   int openformWid;
   int openprofileWid;
   
   if( _in_MaybeUpdate ) return;
   
   /* Update the FTP Open tab.
    * IF visible AND we can find the profile combo box.
    * IF there is no active connection OR the FTP open tab is showing
    * the same connection as profile name passed in.
    */
   openformWid=_find_object("_tbproject_form","N");
   if( !openformWid ) return;
   openprofileWid=openformWid._find_control("_ctl_profile");
   if( !openprofileWid ) return;
   if( profile=="" || openprofileWid.p_text=="" || openprofileWid.p_text==profile ) {
      _in_MaybeUpdate=true;
      // '1' as the second argument forces a refresh
      openprofileWid.call_event(CHANGE_SELECTED,0,openprofileWid,ON_CHANGE,'W');
      #if 1
      // Now synch up the progress labels between the 2 toolbars
      clientformWid=_find_object("_tbFTPClient_form","N");
      if( clientformWid ) {
         openlabel1Wid=openformWid._find_control("_ctl_operation");
         openlabel2Wid=openformWid._find_control("_ctl_nofbytes");
         clientlabel1Wid=clientformWid._find_control("_ctl_progress_label1");
         clientlabel2Wid=clientformWid._find_control("_ctl_progress_label2");
         if( openlabel1Wid && openlabel2Wid && clientlabel1Wid && clientlabel2Wid ) {
            openlabel1Wid.p_caption=clientlabel1Wid.p_caption;
            openlabel2Wid.p_caption=clientlabel2Wid.p_caption;
         }
      }
      #endif
      _in_MaybeUpdate=false;
   }

   return;
}

_str (*result_p):[];
defeventtab _ftpUserPass_form;
_ctl_ok.on_create()
{
   result_p=0;
   // If this is not a pointer to a hash table, then the results go to never-never land
   if( arg(1)._varformat()==VF_PTR ) {
      result_p=arg(1);
   }
   _ctl_pass.p_Password=true;
   caption=arg(2);
   user=arg(3);
   pass=arg(4);
   if( caption!="" ) {
      p_active_form.p_caption=caption;
   }
   _ctl_user.p_text=user;
   _ctl_pass.p_text=pass;
}

_ftpUserPass_form.on_load()
{
   if( _ctl_user.p_text!="" ) {
      // Put focus on password since that is probably what the user wants
      p_window_id=_ctl_pass;
      _set_sel(1,length(p_text));
      _set_focus();
   }
}

_ctl_ok.lbutton_up()
{
   _str list:[];

   if( result_p ) {
      (*result_p)._makeempty();
      (*result_p):["user"]=_ctl_user.p_text;
      (*result_p):["pass"]=_ctl_pass.p_text;
   }

   p_active_form._delete_window(0);
}

_ctl_cancel.lbutton_up()
{
   p_active_form._delete_window('');
}

defeventtab _ftpUpload_form;
_ctl_yes.on_create()
{
   filename=arg(1);
   xfer_type=0;
   if( isinteger(arg(2)) && arg(2)>0 ) {
      xfer_type=arg(2);
   }

   msg=_ctl_msg.p_caption;
   msg=stranslate(msg,filename,'%s','i');
   _ctl_msg.p_caption=msg;

   if( xfer_type!=FTPXFER_ASCII && xfer_type!=FTPXFER_BINARY ) {
      // Assume it's ascii since the file is opened in a text editor
      xfer_type=FTPXFER_ASCII;
   }
   _ctl_xfer_ascii.p_value=_ctl_xfer_binary.p_value=0;
   if( xfer_type&FTPXFER_ASCII ) {
      _ctl_xfer_ascii.p_value=1;
   } else {
      _ctl_xfer_binary.p_value=1;
   }
}

_ftpUpload_form.on_load()
{
   p_window_id=_ctl_yes;
   _set_focus();
}

void _ctl_yes.lbutton_up()
{
   xfer_type=0;
   if( _ctl_xfer_ascii.p_value ) {
      xfer_type=FTPXFER_ASCII;
   } else if( _ctl_xfer_binary.p_value ) {
      xfer_type=FTPXFER_BINARY;
   } else {
      // This should never happen
      _message_box("You must choose ASCII or BINARY upload","FTP",MB_OK|MB_ICONINFORMATION);
      return;
   }

   p_active_form._delete_window(xfer_type);
}

_ctl_no.lbutton_up()
{
   p_active_form._delete_window('');
}

_ftpUpload_form.'ESC'()
{
   _ctl_no.call_event(_ctl_no,LBUTTON_UP,'W');
}

defeventtab _ftpDownload_form;
_ctl_ok.on_create()
{
   filename=arg(1);
   xfer_type=0;
   if( isinteger(arg(2)) && arg(2)>0 ) {
      xfer_type=arg(2);
   }

   msg=_ctl_msg.p_caption;
   msg=stranslate(msg,filename,'%s','i');
   _ctl_msg.p_caption=msg;

   if( xfer_type!=FTPXFER_ASCII && xfer_type!=FTPXFER_BINARY ) {
      // Assume it's ascii since the file is opened in a text editor
      xfer_type=FTPXFER_ASCII;
   }
   _ctl_xfer_ascii.p_value=_ctl_xfer_binary.p_value=0;
   if( xfer_type&FTPXFER_ASCII ) {
      _ctl_xfer_ascii.p_value=1;
   } else {
      _ctl_xfer_binary.p_value=1;
   }
}

void _ctl_ok.lbutton_up()
{
   xfer_type=0;
   if( _ctl_xfer_ascii.p_value ) {
      xfer_type=FTPXFER_ASCII;
   } else if( _ctl_xfer_binary.p_value ) {
      xfer_type=FTPXFER_BINARY;
   } else {
      // This should never happen
      _message_box("You must choose ASCII or BINARY download","FTP",MB_OK|MB_ICONINFORMATION);
      return;
   }

   p_active_form._delete_window(xfer_type);
}

_ctl_cancel.lbutton_up()
{
   p_active_form._delete_window('');
}

static void _RetrieveFileHist()
{
   _ftpFileHist._makeempty();
   status=_open_temp_view(_ftpUserIniFilename(),ini_view_id,orig_view_id);
   if( status ) return;
   p_view_id=ini_view_id;
   top();
   status=search('^\[sitemap\-','@ir');
   while( !status ) {
      get_line(line);
      parse line with '[' 'sitemap-' host ']';
      host=strip(host);
      if( host=="" ) {
         // This should never happen
         status=repeat_search();
         continue;
      }
      while( !down() ) {
         get_line(line);
         if( line=="" ) continue;
         if( substr(line,1,1)=='[' ) break;   // At next section
         parse line with '"' remote_path '"' '=' '"' local_path '"';
         remote_path=strip(remote_path);
         local_path=strip(local_path);
         if( remote_path=="" || local_path=="" ) continue;   // This should never happen
         _ftpFileHist:[host].files:[remote_path].local_path=local_path;
      }
      status=repeat_search();
   }

   return;
}

static void _SaveFileHist()
{
   typeless host,remote_path;

   orig_view_id=p_view_id;
   if( _create_temp_view(temp_view_id)=="" ) return;
   _delete_line();

   for( host._makeempty();; ) {
      _ftpFileHist._nextel(host);
      if( host._isempty() ) break;
      for( remote_path._makeempty();; ) {
         _ftpFileHist:[host].files._nextel(remote_path);
         if( remote_path._isempty() ) break;
         local_path=_ftpFileHist:[host].files:[remote_path].local_path;
         insert_line('"'remote_path'"="'local_path'"');
      }
   }
}

/* Function Name : _ftpCloseAllConnections()
 *
 * Parameters: none
 *
 * Description:
 *   Closes all current FTP connections.
 */
void _ftpCloseAllConnections()
{
   ftpConnProfile_t *fcp_p;
   
   for( i._makeempty();; ) {
      _ftpCurrentConnections._nextel(i);
      if( i._isempty() ) break;
      fcp_p=_ftpCurrentConnections._indexin(i);
      if( fcp_p->sock!=INVALID_SOCKET ) {
         _ftpCommand(fcp_p,false,"QUIT");
      }
      if( fcp_p->vsproxy_sock!=INVALID_SOCKET ) {
         _ftpVSProxyCommand(fcp_p,"QUIT");
      }
   }
   _ftpCurrentConnections._makeempty();   // Just in case

   return;
}

_command void ftpCloseAllConnections() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   _ftpCloseAllConnections();
}

#define FTPTEMP_DIR 'ftp'
#define FTPTEMP_FILE_PREFIX "vsftp"

// Return the path to save temporary ftp files with the trailing FILESEP
static _str _ftpTempPath()
{
   path=get_env("VSLICKFTP");
   if( path=="" ) {
      // Use defaults
      path=_config_path();
      if( last_char(path)!=FILESEP ) path=path:+FILESEP;
      path=path:+FTPTEMP_DIR;
   }
   if( last_char(path)!=FILESEP ) path=path:+FILESEP;

   return(path);
}

_str _ftpMktemp()
{
   path=_ftpTempPath();
   if( last_char(path)==FILESEP ) path=substr(path,1,length(path)-1);   // Strip trailing FILESEP
   if( file_match('+d +x -p ':+maybe_quote_filename(path),1)=="" ) {
      // The path to save downloaded ftp files is not created yet, so create it
      status=make_path(path);   // make_path() takes care of multiple directories
      if( status ) {
         _message_box('Unable to create ftp temporary path "':+path:+'".  ':+get_message(status),FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
         return("");
      }
   }
   path=path:+FILESEP;   // Tack the trailing FILESEP back on

   prefix=FTPTEMP_FILE_PREFIX;
   if( length(prefix)>=8 ) {
      /* This should not happen. Never pick a prefix as large as the
       * name(no extension) part of an 8.3 filename.
       */
      prefix=substr(prefix,1,7);
   }
   prefix_len=length(prefix);

   maxmajor= (int)substr("",1,8-prefix_len,"9");
   maxminor=999;
   for( i=0;i<maxmajor;++i ) {
      for( j=0;j<maxminor;++j ) {
         name=path:+prefix:+substr("",1,8-prefix_len-length(i),"0"):+i:+".":+substr("",1,3-length(j),"0"):+j;
         if( file_match('-p 'maybe_quote_filename(name),1)=="" ) {
            return(name);
         }
      }
   }

   return("");   // There are a lot of temp files if this happens
}

/* This function expects the name of the file, including the full path, to work.
 * We follow the same algorithm as _ftpMktemp() so that it is easy to change
 * the FTPTEMP_FILE_PREFIX constant.
 */
boolean _ftpIsTempFilename(_str name)
{
   temp_path=_ftpTempPath();
   if( last_char(temp_path)!=FILESEP ) temp_path=temp_path:+FILESEP;

   name_path=_file_case(strip_filename(name,'N'));
   if( _file_case(temp_path)!=name_path ) return(false);

   prefix=FTPTEMP_FILE_PREFIX;
   if( length(prefix)>=8 ) {
      /* This should not happen. Never pick a prefix as large as the
       * name(no extension) part of an 8.3 filename.
       */
      prefix=substr(prefix,1,7);
   }
   prefix_len=length(prefix);
   name_re=_escape_re_chars(prefix);

   maxmajor= (int)substr("",1,8-prefix_len,"9");
   maxminor= (int)substr("",1,3,"9");
   for( i=0;i<length(maxmajor);++i ) {
      name_re=name_re:+':d';
   }
   name_re=name_re:+".";
   for( i=0;i<length(maxminor);++i ) {
      name_re=name_re:+':d';
   }
   name_re=_file_case(name_re);
   if( pos(name_re,strip_filename(_file_case(name),'P'),1,'er')==1 ) return(true);

   return(false);
}

static _str _MaybeLongTo8Dot3(_str filename)
{
   _str new_filename;

   if( filename=="" ) return("");
   new_filename=filename;
   if( _ftpUseShortFilenames ) {
      // Long filenames are not supported, so shorten the filename to 8.3
      if( pos('.',new_filename)!=lastpos('.',new_filename) ) {
         /* There is more than one '.' in the filename, so translate all '.'
          * except the last one (the extension of the file is important
          * for selecting the mode.
          */
         ext=substr(new_filename,lastpos('.',new_filename)+1);
         new_filename=stranslate(substr(new_filename,1,lastpos('.',new_filename)-1),"",".","e");
         new_filename=new_filename:+".":+ext;
      }
      parse new_filename with name '.' ext;
      if( length(name)>8 ) {
         name=substr(name,1,8);
      }
      if( length(ext)>3 ) {
         ext=substr(ext,1,3);
      }
      new_filename=name;
      if( ext!="" ) {
         new_filename=new_filename:+".":+ext;
      }
   }

   return(new_filename);
}

/* This function maps a remote path (host+path), to a local directory
 * The local path is guaranteed to exist when this function returns
 * successfully.
 *
 * Note about 8.3 file systems:
 *  This function does not care if you are on an 8.3 file system and 2
 *  or more distinct ftp host paths map to the same local path. It DOES
 *  care if 2 or more remote filenames map to the same local filename
 *  and will try to generate a unique name in this case.
 */
#if __UNIX__
   #define FTPXLAT_FILENAME_CHARSET "\t"
#else
   #define FTPXLAT_FILENAME_CHARSET "[]:\\/<>|=+;,\t"
#endif
_str _ftpRemoteToLocalPath(ftpConnProfile_t *fcp_p,_str remote_path)
{
   boolean isdir;

   host=fcp_p->Host;
   if( host=="" || remote_path=="" ) return("");
   isdir= (last_char(remote_path)=='/');
   path=_ftpAbsolute(fcp_p,remote_path);
   
   if( fcp_p->RemoteRoot!="" && fcp_p->LocalRoot!="" ) {
      /* This connection profile already has remote-to-local mapping
       * set up, so use it.
       */
      remoteroot=strip(fcp_p->RemoteRoot);
      if( last_char(remoteroot)!='/' ) remoteroot=remoteroot:+'/';
      if( substr(remote_path,1,length(remoteroot))==remoteroot ) {
         // Map it
         localroot=fcp_p->LocalRoot;
         if( last_char(localroot)!=FILESEP ) localroot=localroot:+FILESEP;
         append_path=substr(remote_path,length(remoteroot)+1);
         append_path=stranslate(append_path,FILESEP,'/','');
         return_path=localroot:+append_path;
         
         // Make sure the local path exists
         temp_path=return_path;
         i=lastpos(FILESEP,temp_path);
         if( i ) {
            temp_path=substr(temp_path,1,i-1);
         }
         if( !isdrive(temp_path) && file_match('+d +x -p ':+maybe_quote_filename(temp_path),1)=="" ) {
            // The path is not created yet, so create it
            status=make_path(maybe_quote_filename(temp_path));   // make_path() takes care of multiple directories
            if( status ) {
               _message_box('Unable to create ftp local path "':+temp_path:+'".  ':+get_message(status),FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
               return("");
            }
         }
         
         return(return_path);
      }
   }
   
   root=_MaybeLongTo8Dot3(host);
   if( substr(path,1,1)=='/' ) path=substr(path,2);
   local_path="";
   while( path!="" ) {
      parse path with name '/' path;
      name=_MaybeLongTo8Dot3(name);
      // Translate illegal characters
      name=translate(name,"",FTPXLAT_FILENAME_CHARSET,'_');
      local_path=local_path:+FILESEP:+name;
   }
   local_filename="";
   filename_was_reduced=false;   // This tells us if the filename part was shortened to 8.3
   if( !isdir ) {
      i=lastpos(FILESEP,local_path);
      if( i ) {
         local_filename=substr(local_path,i+1);
         local_path=substr(local_path,1,i);
         i=lastpos(FILESEP,remote_path);
         if( i ) {
            remote_filename=substr(remote_path,i+1);
            if( local_filename!=remote_filename ) {
               filename_was_reduced=true;
            }
         }
      }
   }
   local_path=root:+local_path;

   path=_ftpTempPath();
   if( last_char(path)!=FILESEP ) path=path:+FILESEP;
   local_path=path:+local_path;
   if( last_char(local_path)==FILESEP ) local_path=substr(local_path,1,length(local_path)-1);
   if( file_match('+d +x -p ':+maybe_quote_filename(local_path),1)=="" ) {
      // The path is not created yet, so create it
      //messageNwait('local_path='local_path);
      status=make_path(maybe_quote_filename(local_path));   // make_path() takes care of multiple directories
      if( status ) {
         _message_box('Unable to create ftp local path "':+local_path:+'".  ':+get_message(status),FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
         return("");
      }
   }
   local_path=local_path:+FILESEP;
   return_path=local_path;
   if( local_filename!="" ) {
      return_path=return_path:+local_filename;
      if( filename_was_reduced ) {
         /* The local path name was shortened because we are on an 8.3 file
          * system. We must not blast the file on disk, but rather generate
          * a filename that will be unique.
          */
         _str name,ext,found,filename;
         parse local_filename with name '.' ext;
         filename=return_path;
         found=file_match("-p "maybe_quote_filename(filename),1);
         for( i=0;i<10;++i ) {
            if( found=="" ) break;
            filename=local_path:+strip(substr(name,1,length(name)-1)):+i;
            // The extension is important to selecting the mode, so don't mess with it
            if( ext!="" ) filename=filename:+".":+ext;
            found=file_match("-p "maybe_quote_filename(filename),0);
         }
         if( found!="" ) {
            // Try again
            for( i=10;i<100;++i ) {
               if( found=="" ) break;
               filename=local_path:+strip(substr(name,1,length(name)-2)):+i;
               // The extension is important to selecting the mode, so don't mess with it
               if( ext!="" ) filename=filename:+".":+ext;
               found=file_match("-p "maybe_quote_filename(filename),0);
            }
         }
         if( found!="" ) {
            // Give up
            _message_box("Unable to create ftp local filename.\n\nYou need to clean out the directory:\n\n":+local_path,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
            return("");
         }
         return_path=filename;
      }
   }

   return(return_path);
}

/* This function expects the name of the file, including the full path, to work.
 */
boolean _ftpIsLocalFilename(_str name)
{
   temp_path=_ftpTempPath();
   if( last_char(temp_path)!=FILESEP ) temp_path=temp_path:+FILESEP;
   temp_path=_file_case(temp_path);

   name_path=_file_case(strip_filename(name,'N'));
   if( pos(temp_path,name_path)==1 ) return(true);

   return(false);
}

boolean ftpIsFTPDocname(_str name)
{
   return( lowcase(substr(name,1,length('ftp://')))=='ftp://' );
}

/* Function Name : _exit_ftp()
 *
 * Parameters: none
 *
 * Description:
 *   Called when the editor exits. Closes all current FTP connections. Also
 *   clears out the array of current connections so they are not needlessly
 *   taking up space in the state file. Since the last connections are not
 *   stored in the state file, security-conscious users do not have to worry
 *   about sending us their state file for tech support reasons because we
 *   will have no access to their connection info.
 *
 *   Note:
 *     _cbsave_ftp() and _cbquit_ftp() take care of the user saving and
 *     quitting an FTP file respectively.
 *
 * Returns:
 *   Returns 0.
 */
int _exit_ftp()
{
   _str errors;
   _str excluded;

   /* Now make sure we don't need to upload any buffers and delete any
    * temporary ftp files that might (but should not be), left over.
    */
   /* First build a list of ftp buffers that are active and exclude these
    * from deletion. IF WE DECIDE TO PUT IN AN OPTION NOT TO AUTORESTORE
    * FTP BUFFERS, THEN WE MUST -OR- IN THE THROW_AWAY_CHANGES flag into
    * p_buf_flags.
    */
   excluded=" ";
   first_buf_id=p_buf_id;
   for(;;) {
      if( !(p_buf_flags&HIDE_BUFFER) ) {
         buf_name=p_buf_name;
         document_name=p_DocumentName;
         if( ftpIsFTPDocname(document_name) ) {
            // Check to see if we need to upload it
            if( !p_modify && p_ModifyFlags&MODIFYFLAG_FTP_NEED_TO_SAVE ) {
               /* 1 as third argument forces a prompt-for-save regardless
                * of the global options.
                */
               if( p_buf_flags&FTP_UPLOAD_IN_PROGRESS ) {
                  /* This buffer is currently being uploaded.
                   * That means it is already saved on disk, so it is safe to
                   * quit the buffer.
                   */
                  return(0);
               }
               p_buf_flags |= FTP_UPLOAD_IN_PROGRESS;
               orig_view_id=p_view_id;
               status=_ftpSave(buf_name,document_name,1);
               p_view_id=orig_view_id;
               p_buf_flags &= ~(FTP_UPLOAD_IN_PROGRESS);
            }
            if( _ftpIsTempFilename(buf_name) ) {
               excluded=excluded:+_file_case(buf_name):+" ";
            }
         }
      }
      _next_buffer('HNR');
      if( p_buf_id==first_buf_id ) break;
   }
   errors="";
   temp_path=_ftpTempPath();
   if( last_char(temp_path)!=FILESEP ) temp_path=temp_path:+FILESEP;
   name=file_match("-d ":+maybe_quote_filename(temp_path:+FTPTEMP_FILE_PREFIX:+"*.*"),1);
   while( name!="" ) {
      if( !pos(" ":+_file_case(name):+" ",excluded,1) ) {
         status=delete_file(name);
         if( status ) {
            // Note the error and continue
            if( errors!="" ) errors="\n":+errors;
            errors=errors:+name:+" - ":+get_message(status);
         }
      }
      name=file_match("-d ":+maybe_quote_filename(temp_path:+FTPTEMP_FILE_PREFIX:+"*.*"),0);
   }
   if( errors!="" ) {
      _message_box("Warning:  Unable to delete the following ftp files:\n\n":+
                   errors,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
   }

   // Close down all socket connections gracefully and exit the sockets layer
   i._makeempty();
   _ftpCurrentConnections._nextel(i);
   if( !i._isempty() ) {
      idx=find_index("vssIsInit",PROC_TYPE);
      if( idx && index_callable(idx) ) {
         _ftpCloseAllConnections();
         if( vssIsInit() ) vssExit();   // Exit sockets layer
      }
   }

   // Empty all globals
   _ftpCurrentConnections._makeempty();
   _ftpFileHist._makeempty();
   _ftpQ._makeempty();


   return(0);
}

_command int ResetSockets() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   if( vssIsInit() ) vssExit();   // Exit sockets layer
   status=vssInit(SOCKDEF_CONNECT_TIMEOUT);
   //status=vssInit(5);
   if( status ) {
      _message_box("Unable to initialize sockets layer.  ":+_ftpGetMessage(status),FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return(status);
   }

   return(0);
}

// Callback for starting a connection profile
static void __ftpSaveConnectCB(...)
{
   ftpQEvent_t event;
   ftpConnProfile_t fcp;

   event= *((ftpQEvent_t *)(arg(1)));

   fcp=event.fcp;
   if( event.state==QS_ERROR || event.state==QS_ABORT || event.state==QS_ABORT_WAITING_FOR_REPLY ) {
      // We were starting a connection, so clean up
      _ftpDeleteLogBuffer(&fcp);
      /* We have to do this if the CWD/PWD fails. Otherwise, the queue handler
       * functions take care of it.
       */
      fcp.PostedCB=0;
      if( event.event==QE_CWD || event.event==QE_PWD ) {
         _ftpEnQ(QE_END_CONN_PROFILE,QS_BEGIN,0,&fcp);
      }
      return;
   }
   
   // Now set the local current working direcotry
   cwd=fcp.DefLocalDir;
   if( cwd=="" ) cwd=getcwd();
   cwd=strip(cwd);
   if( last_char(cwd)==FILESEP ) cwd=substr(cwd,1,length(cwd)-1);
   isdir=isdirectory(maybe_quote_filename(cwd));
   if( (isdir=="" || isdir=="0") && !isuncdirectory(cwd) ) {
      // Not a valid local directory
      cwd=getcwd();
      _message_box("Warning: Unable to change to local directory:\n\n":+
                   fcp.DefLocalDir:+"\n\nThe local current working directory is:\n\n":+
                   cwd,"",MB_OK|MB_ICONEXCLAMATION);
   }
   fcp.LocalCWD=cwd;

   fcp.PostedCB=0;   // Paranoid
   _ftpAddCurrentConnProfile(&fcp,htindex);

   return;
}

int _OnUpdate_ftpUpload(CMDUI &cmdui,int target_wid,_str command)
{
   if( !target_wid || !target_wid._isEditorCtl() ) {
      return(MF_GRAYED);
   }
   if( !ftpIsFTPDocname(target_wid.p_DocumentName) ) {
      return(MF_GRAYED);
   }
   
   return(MF_ENABLED);
}

_command int ftpUpload()
{
   if( !ftpIsFTPDocname(p_DocumentName) ) {
      msg="This is not an FTP document!";
      _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return(1);
   }
   
   // Already saved, so upload it
   if( p_buf_flags&FTP_UPLOAD_IN_PROGRESS ) {
      // Currently uploading
      return(0);
   }
   
   if( p_modify ) {
      return(save());
   }
   p_buf_flags |= FTP_UPLOAD_IN_PROGRESS;
   status=_ftpSave(p_buf_name,p_DocumentName,1);   // Third argument forces a prompt
   p_buf_flags &= ~(FTP_UPLOAD_IN_PROGRESS);
   
   return(status);
}

static int _ftpSave(_str local_path,remote_address,...)
{
   ftpConnProfile_t fcp;
   ftpQEvent_t event;
   SendCmd_t scmd;

   if( remote_address=="" ) {
      remote_address=p_DocumentName;
   }
   
   force_prompt= (arg(3)!='' && arg(3));
   if( ftpIsFTPDocname(remote_address) ) {
      p_ModifyFlags |= MODIFYFLAG_FTP_NEED_TO_SAVE;
      ftpOptions_t fo;
      _ftpGetOptions(fo);
      if( fo.put==FTPOPT_ALWAYS_PUT || fo.put==FTPOPT_PROMPTED_PUT || force_prompt ) {
         status=_ftpParseAddress(remote_address,host,port,remote_path);
         if( status ) {
            _message_box(_ftpGetMessage(status),FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
            return(status);
         }
         if( p_binary ) {
            xfer_type=FTPXFER_BINARY;
         } else {
            xfer_type=FTPXFER_ASCII;
         }
         if( fo.put==FTPOPT_PROMPTED_PUT || force_prompt ) {
            xfer_type=show("-modal _ftpUpload_form",remote_address,xfer_type);
            if( xfer_type=="" ) {
               // User cancelled or said "No"
               return(0);
            }
         }
         status=_ftpHHWCreateConnProfile(host,port,&fcp);
         if( status ) {
            if( status!=COMMAND_CANCELLED_RC ) {
               _message_box("Unable to open a connection.  ":+_ftpGetMessage(status),FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
            }
            return(status);
         }
         fcp.XferType=xfer_type;
         scmd._makeempty();

         _str cmdargv[];
         cmdargv._makeempty();
         cmdargv[0]="STOR";
         status=_ftpParseAddress(remote_address,host,port,remote_path);
         if( status ) {
            _message_box('Unable to save "':+remote_address:+'".  ':+_ftpGetMessage(status));
            return(status);
         }
         i=lastpos('/',remote_path);
         if( !i ) {
            _message_box("Invalid remote path:\n\n":+remote_path);
            return(1);
         }
         path=substr(remote_path,1,i);
         filename=substr(remote_path,i+1);
         if( filename=="" ) {
            msg="Invalid remote filename:\n\n":+remote_path;
            _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
            return(1);
         }
         remote_path=path:+_ftpUploadCase(&fcp,filename);
         cmdargv[1]=remote_path;
         scmd.cmdargv=cmdargv;

         scmd.datahost=scmd.dataport="";
         scmd.src=local_path;
         scmd.pasv= (fcp.UseFW && fcp.Options.fwenable && fcp.Options.fwpasv);
         scmd.ProgressCB=_ftpopenProgressDlgCB;
         line=file_match("-p +v "maybe_quote_filename(local_path),1);
         if( line=="" ) {
            msg='The local file "':+local_path:+'" associated with the remote file "':+remote_address:+'" does not exist';
            _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
            return(FILE_NOT_FOUND_RC);
         }
         scmd.size= (int)substr(line,DIR_SIZE_COL,DIR_SIZE_WIDTH);

         success=false;
         gftpAbort=false;
         orig_view_id=p_view_id;
         formWid=show("_ftpProgress_form");
         if( !formWid ) {
            _message_box('Could not show form: "_ftpProgress_form"',FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
            return(1);
         }
         
         // Don't start anything new until the queue empties
         if( _ftpQ._length() ) {
            formWid.p_caption="Waiting for current operation to finish...";
            for(;;) {
               process_events(gftpAbort);
               if( gftpAbort ) break;
               if( _ftpQ._length()<1 ) break;
            }
         }
         if( gftpAbort ) {
            // User did not want to wait for the current operation to finish
            formWid._delete_window();
            return(1);
         }
         
         fcp.PostedCB=0;
         new_connection=false;
         start_caption="";
         if( !vssIsConnectionAlive(fcp.sock) ) {
            // Need to start the connection, so queue it first
            new_connection=true;
            start_caption="Connecting to ":+fcp.ProfileName;
            formWid.p_caption=start_caption;
            fcp.PostedCB=0;
            _ftpEnQ(QE_START_CONN_PROFILE,QS_BEGIN,0,&fcp);
            // QE_SEND_CMD will be queued later
         } else {
            fcp.PostedCB=0;
            _ftpEnQ(QE_SEND_CMD,QS_BEGIN,0,&fcp,scmd);
         }
         if( _ftpQ._length()<1 ) {
            return(1);
         }
         
         ftpQEvent_t lastevent;
         lastevent._makeempty();
         lastevent.event=0;
         lastevent.start=0;
         lastevent.state=0;
         _ftpInitConnProfile(lastevent.fcp);
         for(;;) {
            process_events(gftpAbort);
            if( gftpAbort ) {
               if( _ftpQ._length()<1 ) break;
               event=_ftpQ[0];

               /* Find all events in the queue that match this one and delete them.
                */
               for( i=0;i<_ftpQ._length();++i ) {
                  if( _ftpQ[i].event==event.event ) {
                     _ftpQ._deleteel(i);
                  }
               }

               event.state=QS_ABORT;
               event.start=0;
               /* We queue it this way because the original event might have had
                * optional data in the info field that we don't want to lose.
                */
               _ftpQ[0]=event;
               break;
            }
            if( _ftpQ._length()<1 ) {
               if( lastevent.state==QS_ERROR || lastevent.state==QS_ABORT || lastevent.state==QS_ABORT_WAITING_FOR_REPLY ) {
                  if( event.event!=QE_CWD && event.event!=QE_PWD ) {
                     // Connection failed, so bail out
                     break;
                  }
               }
               // Completed successfully
               success=true;
               break;
            } else {
               /* If the processed event was the last event for that particular
                * connection profile, then we are done
                */
               last=true;
               for( i=0;i<_ftpQ._length();++i ) {
                  if( _ftpQ[i].fcp.ProfileName==fcp.ProfileName &&
                      _ftpQ[i].fcp.Instance==fcp.Instance ) {
                     last=false;
                     break;
                  }
               }
               if( last ) {
                  success=true;
                  break;
               }
            }
            if( new_connection ) {
               /* We were forced to start a connection.
                * IF this event's connection profile matches
                * the one we are concerned with AND we have
                * gotten to the password event AND we don't
                * already have a socket.
                */
               if( _ftpQ[0].fcp.ProfileName==fcp.ProfileName &&
                   _ftpQ[0].event==QE_PWD && _ftpQ[0].state==QS_END &&
                   fcp.sock==INVALID_SOCKET ) {
                  /* We're far enough along to harvest the socket for
                   * the QE_SEND_CMD event.
                   */
                  fcp=_ftpQ[0].fcp;
                  // This callback causes the connection to be added to current connections
                  fcp.PostedCB=__ftpSaveConnectCB;
                  _ftpEnQ(QE_SEND_CMD,QS_BEGIN,0,&fcp,scmd);
               }
            }
            if( machine()=='OS2386' || _win32s() ) {
               /* Windows 95/3.1, OS/2 hack.
                * Windows 95/3.1 and OS/2 performance with tight loops is poor.
                * Putting in this 0.05sec delay actually makes it run
                * about a million times faster.
                */
               delay(5);
            }
            lastevent=_ftpQ[0];
            _ftpQTimerCallback();
         }
         formWid._delete_window();
         p_view_id=orig_view_id;
         if( success ) {
            p_ModifyFlags &= ~(MODIFYFLAG_FTP_NEED_TO_SAVE);
            _MaybeUpdateFTPTab("");
            //_MaybeUpdateFTPClient("");
         }
      }
   }

   return(0);
}

int _cbsave_ftp(...)
{
   if( p_modify ) {
      /* This could happen if the user did a save() to a filename other than
       * the current buffer name. Blow out if this is the case.
       */
      return(0);
   }

   if( p_buf_flags&FTP_UPLOAD_IN_PROGRESS ) {
      // This file is currently being uploaded
      return(0);
   }
   
   if( ftpIsFTPDocname(p_DocumentName) ) {
      p_ModifyFlags |= MODIFYFLAG_FTP_NEED_TO_SAVE;
   }
   
   if( _in_quit ) {
      /* quit() calls save(), so we would end up prompting the user
       * twice with the upload prompt.
       */
      return(0);
   }
   p_buf_flags |= FTP_UPLOAD_IN_PROGRESS;
   orig_view_id=p_view_id;
   status=_ftpSave(p_buf_name,p_DocumentName);
   p_view_id=orig_view_id;
   p_buf_flags &= ~(FTP_UPLOAD_IN_PROGRESS);
   
   return(status);
}

int _cbquit_ftp(int buf_id,_str buf_name,_str document_name,int buf_flags)
{
   int status;
   
   status=0;
   if( ftpIsFTPDocname(document_name) ) {
      /* We don't have to worry about saving because quit() took care of
       * that, but we do have to worry about the buffer not being uploaded
       * yet.
       */
      if( p_ModifyFlags&MODIFYFLAG_FTP_NEED_TO_SAVE ) {
         /* 1 as third argument forces a prompt-for-save regardless
          * of the global options.
          */
         if( p_buf_flags&FTP_UPLOAD_IN_PROGRESS ) {
            /* This buffer is currently being uploaded.
             * We should not attempt to save it again.
             */
            return(0);
         }
         p_buf_flags |= FTP_UPLOAD_IN_PROGRESS;
         orig_view_id=p_view_id;
         status=_ftpSave(buf_name,document_name,1);
         p_view_id=orig_view_id;
         p_buf_flags &= ~(FTP_UPLOAD_IN_PROGRESS);
      }
   }

   return(status);
}

int _cbquit2_ftp(int buf_id,_str buf_name,_str document_name,int buf_flags)
{
   //messageNwait('_cbquit2_ftp: buf_name='buf_name'  document_name='document_name);
   if( ftpIsFTPDocname(document_name) ) {
      /* This test will always short-circuit on _ftpIsLocalFilename() because
       * it only checks the path, but we left in _ftpIsTempFilename() in case
       * _ftpIsLocalFilename() gets more picky later.
       */
      if( _ftpIsLocalFilename(buf_name) || _ftpIsTempFilename(buf_name) ) {
         if( p_buf_flags&FTP_UPLOAD_IN_PROGRESS ) {
            /* This buffer is currently being uploaded.
             * We cannot delete it because we would get "Access denied".
             */
            return(1);
         }
         if( !_in_project_close ) {
            status=delete_file(buf_name);
            if( status && status!=FILE_NOT_FOUND_RC ) {
               _message_box('Warning: Unable to delete the temporary ftp file "':+buf_name:+'"',FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
               return(1);
            }
         }
      }
   }

   return(0);
}

void _ftpEnQ(int e,int state,int start,ftpConnProfile_t *fcp_p,...)
{
   ftpQEvent_t event;

   if( e<=0 || e>QE_LAST ) {
      _message_box("Unknown FTP queue event: ":+e,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return;
   }
   if( state<=0 || state>QS_LAST ) {
      _message_box("Unknown FTP queue event state: ":+state,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return;
   }

   #if 1
   call_list('_ftpQBusy_');
   #else
   if( _ftpQ._length()==0 ) {
      // First event on an idle queue
      call_list('_ftpQBusy_');
   }
   #endif

   event._makeempty();
   event.event=e;
   event.state=state;
   if( fcp_p ) {
      event.fcp= *fcp_p;   // Make a copy because it may not be in _ftpCurrentConnections yet
   }
   if( start>0 ) {
      /* Starting time specified. This usually means we are waiting for
       * something to happen, so we keep track of an original starting
       * time so we can test for a timeout condition.
       */
      event.start=start;
   } else {
      event.start= (int)_time('B');
      /* This is a buffered reply from the ftp server or VSE proxy.
       * We only initialize to "" if we are starting an event.
       * This is most important when re-queueing *_WAITING_FOR_REPLY
       * event states where we want to clear the Reply field when
       * just starting to receive the reply.
       */
      event.fcp.Reply="";
   }
   for( i=5;i<=arg();++i ) {
      event.info[event.info._length()]=arg(i);
   }

   /* The event is always tacked onto the end of the queue with the
    * following exceptions:
    *
    * 1. We are starting a connection with a profile matching event.fcp
    */
   found_it=false;
   for( i=0;i<_ftpQ._length();++i ) {
      // Note that we don't check the Instance field because there is none set yet
      if( _ftpQ[i].fcp.ProfileName==event.fcp.ProfileName ) {
         switch( event.event ) {
         case QE_START_CONN_PROFILE:
         case QE_PROXY_CONNECT:
         case QE_RELAY_CONNECT:
         case QE_PROXY_OPEN:
         case QE_OPEN:
         case QE_USER:
         case QE_PASS:
         //case QE_CWD:
         //case QE_PWD:
            found_it=true;
            break;
         }
         if( found_it ) break;
      }
   }
   if( found_it ) {
      /* Found it. Now shift all elements starting with this one so we can
       * jam this one in.
       */
      for( j=_ftpQ._length()-1;j>=i;--j ) {
         _ftpQ[j+1]=_ftpQ[j];
      }
      _ftpQ[i]=event;
   } else {
      _ftpQ[_ftpQ._length()]=event;
   }

   return;
}

/* Queue the event at the front of the event queue for the connection profile
 * pointed to by fcp_p.
 */
void _ftpReQ(int e,int state,int start,ftpConnProfile_t *fcp_p,...)
{
   ftpQEvent_t event;

   if( e<=0 || e>QE_LAST ) {
      _message_box("Unknown FTP queue event: ":+e,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return;
   }
   if( state<=0 || state>QS_LAST ) {
      _message_box("Unknown FTP queue event state: ":+state,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return;
   }
   event._makeempty();
   event.event=e;
   event.state=state;
   if( fcp_p ) {
      event.fcp= *fcp_p;   // Make a copy because it may not be in _ftpCurrentConnections yet
   }
   if( start>0 ) {
      /* Starting time specified. This usually means we are waiting for
       * something to happen, so we keep track of an original starting
       * time so we can test for a timeout condition.
       */
      event.start=start;
   } else {
      event.start= (int)_time('B');
      /* This is a buffered reply from the ftp server or VSE proxy.
       * We only initialize to "" if we are starting an event.
       * This is most important when re-queueing *_WAITING_FOR_REPLY
       * event states where we want to clear the Reply field when
       * just starting to receive the reply.
       */
      event.fcp.Reply="";
   }
   for( i=5;i<=arg();++i ) {
      event.info[event.info._length()]=arg(i);
   }

   /* Now find the first event in the queue that matches the connection
    * profile pointed to by fcp_p and stick the new event on the front.
    */
   found_it=false;
   for( i=0;i<_ftpQ._length();++i ) {
      if( _ftpQ[i].fcp.ProfileName==fcp_p->ProfileName &&
          _ftpQ[i].fcp.Instance==fcp_p->Instance ) {
         found_it=true;
         break;
      }
   }
   if( found_it ) {
      /* Found it. Now shift all elements starting with this one so we can
       * jam this one in.
       */
      for( j=_ftpQ._length()-1;j>=i;--j ) {
         _ftpQ[j+1]=_ftpQ[j];
      }
      _ftpQ[i]=event;
   } else {
      /* This is the first event in the queue for this connection profile,
       * so just tack it on the end of the queue.
       */
      _ftpQ[_ftpQ._length()]=event;
   }

   return;
}

void _ftpDeQ()
{
   if( _ftpQ._length()>0 ) {
      _ftpQ._deleteel(0);
   }

   return;
}

static int _ftpVSProxyCommand(ftpConnProfile_t *fcp_p,typeless cmd,...)
{
   if( !vssIsConnectionAlive(fcp_p->vsproxy_sock) ) {
      return(FTP_CONNECTION_DEAD_RC);
   }
   if( cmd._varformat()==VF_ARRAY ) {
      // We have an array representing the command and arguments
      line=strip(cmd[0]);
      for( i=1;i<cmd._length();++i ) {
         line=line" "cmd[i];
      }
   } else {
      // Append additional arguments
      line=strip(cmd);
      if( substr(line,length(line),1)=="\n" ) {   // Strip eol
         if( substr(line,length(line)-1,1)=="\r" ) {
            line=substr(line,1,length(line)-2);
         } else {
            line=substr(line,1,length(line)-1);
         }
      }
      for( i=3;i<=arg();++i ) {
         line=line" "arg(i);
      }
   }

   /* Log any responses that may have come in already.
    * This could happen if we aborted a command before we got the
    * response.
    */
   ftpQEvent_t event;   // Fake event
   event._makeempty();
   event.event=0;
   event.fcp= *fcp_p;
   event.start=0;
   event.state=0;
   status=_ftpQCheckResponse(&event,true,dummy,true);
   if( status ) {
      // Don't care
   }

   if( _ftpdebug&FTPDEBUG_LOG_PROXY ) {
      _ftpLog(fcp_p,line);
   }

   line=line:+EOL;
   //messageNwait('line='line);
   status=vssSocketSendZ(fcp_p->vsproxy_sock,line);

   return(status);
}

static int _ftpQCheckResponse(ftpQEvent_t *e_p,boolean quiet,_str &response,boolean vsproxy)
{
   ftpQEvent_t event;
   _str buf;              // Temporary read buffer
   boolean done;

   event= *e_p;   // Make a copy

   if( vsproxy ) {
      if( !vssIsConnectionAlive(event.fcp.vsproxy_sock) ) {
         return(FTP_CONNECTION_DEAD_RC);
      }
   } else {
      if( !vssIsConnectionAlive(event.fcp.sock) ) {
         //say('_ftpQCheckResponse: connection closed');
         return(SOCK_CONNECTION_CLOSED_RC);
      }
   }

   buf="";
   response="";

   elapsed=((int)_time('B')-event.start+1)/1000;   // Seconds

   reply=event.fcp.Reply;
   #if 1
   if( vsproxy ) {
      status=vssSocketRecvToZStr(event.fcp.vsproxy_sock,buf,0,0);
   } else {
      status=vssSocketRecvToZStr(event.fcp.sock,buf,0,0);
   }
   if( status ) {
      return(status);
   }
   reply=reply:+buf;
   #else
   for(;;) {
      /* If the ftp server sends replies in more than 1 send(), then
       * a single recv() on the socket might only retrieve the first
       * send(). Therefore we loop.
       */
      if( vsproxy ) {
         status=vssSocketRecvToZStr(event.fcp.vsproxy_sock,buf,0,0);
      } else {
         status=vssSocketRecvToZStr(event.fcp.sock,buf,0,0);
      }
      if( status ) {
         return(status);
      }
      if( buf=="" ) break;
      reply=reply:+buf;
   }
   #endif

   reply_len=length(reply);
   e_p->fcp.Reply=reply;   // We DO want to pass this back
   if( vsproxy ) {
      if( reply=="" || length(reply)<3 || last_char(reply)!=EOL ) {
         /* Did not get a complete response yet, so re-queue.
          * Unless timed out. We are expecting atleast something
          * like:
          *
          * +ok
          */
         if( elapsed>event.fcp.Timeout ) {
            return(SOCK_TIMED_OUT_RC);
         }
         return(FTP_WAITING_FOR_REPLY_RC);
      }
   } else {
      if( reply=="" || length(reply)<4 || last_char(reply)!=EOL ) {
         /* Did not get a complete response yet, so re-queue.
          * Unless timed out. We are expecting atleast something
          * like:
          *
          * 257-
          */
         if( elapsed>event.fcp.Timeout ) {
            return(SOCK_TIMED_OUT_RC);
         }
         return(FTP_WAITING_FOR_REPLY_RC);
      }
   }

   i=1;
   ch=substr(reply,i,1);
   if( vsproxy ) {
      done=true;   // We don't need this if vsproxy==true
      if( ch=='-' ) {
         status=FTP_BAD_RESPONSE_RC;
      }
   } else {
      done=false;
      if( substr(reply,i+3,1)=='-' ) {
         // A '-' after the code means there is more to follow
         done=false;
      } else {
         done=true;
      }
      if( ch=='4' || ch=='5' ) {
         status=FTP_BAD_RESPONSE_RC;
      }
   }

   // Capture the first line and save it
   line=substr(reply,i);
   p=pos('\13|\10',line,1,'er');
   if( p ) {
      line=substr(line,1,p-1);
   }
   if( !vsproxy ) {
      // We actually do want to store this in the original structure
      if( line!="" ) e_p->fcp.LastStatusLine=line;
   }

   while( i<=reply_len ) {
      if( substr(reply,i,1)=="\n" ) {
         // +1 to skip the newline, +3 to skip the 3 digit code (or "+ok")
         if( (i+1+3)<=reply_len ) {
            // +1 to get the first char after the newline
            ch=substr(reply,i+1,1);
            if( vsproxy ) {
               if( ch=='-' ) {
                  status=FTP_BAD_RESPONSE_RC;
               }
            } else {
               if( substr(reply,i+1+3,1)=='-' ) {
                  // A '-' after the code means there is more to follow
                  done=false;
               } else {
                  done=true;
               }
               if( ch=='4' || ch=='5' ) {
                  status=FTP_BAD_RESPONSE_RC;
               }
            }

            // Capture the first line and save it
            line=substr(reply,i+1);
            p=pos('\13|\10',line,1,'er');
            if( p ) {
               line=substr(line,1,p-1);
            }
            if( !vsproxy ) {
               // We actually do want to store this in the original structure
               if( line!="" ) e_p->fcp.LastStatusLine=line;
            }
         }
      }
      ++i;
   }

   if( !done ) {
      /* We looked at all the data and now we're tossing the results
       * because we're not done yet. Unless we timed out.
       */
      if( elapsed>event.fcp.Timeout ) {
         return(SOCK_TIMED_OUT_RC);
      }
      return(FTP_WAITING_FOR_REPLY_RC);
   }
   e_p->fcp.Reply="";

   if( !quiet || _ftpdebug&FTPDEBUG_LOG_PROXY ) {
      // Log the response from the ftp server/VSE proxy
      _ftpLog(&event.fcp,reply);
   }

   response=reply;

   return(status);
}

static void _ftpQEHandler_StartConnProfile(ftpQEvent_t *e_p)
{
   ftpQEvent_t event;

   event= *e_p;   // Make a copy

   // Start a connection profile
   switch( event.state ) {
   case QS_BEGIN:
      // Event begins

      // Initialize sockets layer
      idx=find_index("vssIsInit",PROC_TYPE);
      if( !idx || !index_callable(idx) ) {
         msg="Could not find vssInit";
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      if( !vssIsInit() ) {
         status=vssInit(SOCKDEF_CONNECT_TIMEOUT);   // Start sockets layer
         if( status ) {
            msg="Could not initialize sockets layer.  ":+_ftpGetMessage(status);
            _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         }
      }

      /* Create a log buffer for this connection (if necessary).
       * If there is already a log buffer associated with this profile, then
       * it normally means that the connection is being restarted.
       */
      if( event.fcp.LogBufName=="" ) {
         log_buf_name=_ftpCreateLogBuffer();
         if( log_buf_name=="" ) {
            // Don't need a message box because _ftpCreateLogBuffer() took care of that
            msg="Unable to create log buffer. Connection is aborted."
            _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
            return;
         }
         event.fcp.LogBufName=log_buf_name;
      }
      _ftpLog(&event.fcp,"*** Log started on ":+_date():+" at ":+_time('M'));
      _ftpEnQ(QE_PROXY_CONNECT,QS_BEGIN,0,&event.fcp);
      return;
      break;
   case QS_ERROR:
      // An error occurred setting up the connection profile to start
      _ftpDeleteLogBuffer(&event.fcp);
      _message_box(event.info[0],FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return;
      break;
   case QS_ABORT:
      // Event aborted
      _ftpDeleteLogBuffer(&event.fcp);
      return;
      break;
   case QS_END:
      // Event ends
      break;
   default:
      // Should never get here
      msg="Unknown FTP queue event state: ":+event.state:+" for event ":+event.event;
      _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      break;
   }

   return;
}

static void _ftpQEHandler_ProxyConnect(ftpQEvent_t *e_p)
{
   ftpQEvent_t event;

   event= *e_p;   // Make a copy

   // Listening for vsproxy to connect a control socket to us
   switch( event.state ) {
   case QS_BEGIN:
      // Event begins
      if( _ftpVSProxyPath=="" ) {
         _ftpVSProxyPath=path_search(VSPROXY_COMMAND,"VSLICKBIN","");
         if( _ftpVSProxyPath=="" ) {
            msg='Cannot find "':+VSPROXY_COMMAND:+" in VSLICKBIN path";
            _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
            return;
         }
      }
      status=vssGetMyHostAddress(temp_host);
      if( status ) {
         msg="Error getting local host info.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      // "0" means to dynamically assign next available port
      status=vssSocketOpen(temp_host,"0",temp_sock,1);
      if( status ) {
         msg="Error listening for a Visual SlickEdit proxy connection.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      // Get the port that was dynamically assigned
      status=vssGetLocalSocketInfo(temp_sock,temp_host,temp_port);
      if( status ) {
         msg="Error retrieving local host info for listen on Visual SlickEdit proxy connection.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      _ftpLog(&event.fcp,"Listening for Visual SlickEdit proxy connection on ":+temp_host:+":":+temp_port);
      //say('QE_PROXY_CONNECT/QS_BEGIN - temp_sock='temp_sock'  temp_host='temp_host'  temp_port='temp_port);
      event.fcp.vsproxy_sock=temp_sock;   // This socket will change once a connection is accepted
      cmdline=maybe_quote_filename(_ftpVSProxyPath);
      cmdline=cmdline:+' ':+temp_port;
      status=shell(cmdline,"QPAN");
      if( status ) {
         msg="Error running Visual SlickEdit proxy.  ":+status;
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      _ftpEnQ(event.event,QS_LISTENING,event.start,&event.fcp);
      return;
      break;
   case QS_LISTENING:
      status=vssSocketAcceptConn(event.fcp.vsproxy_sock);
      if( status ) {
         if( status==SOCK_NO_CONN_PENDING_RC ) {
            elapsed=((int)_time('B')-event.start+1)/1000;   // Seconds
            if( elapsed>FTPDEF_TIMEOUT ) {
               // We timed out
               msg="Timed out waiting for control connection from Visual SlickEdit proxy";
               _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
            } else {
               /* No connection attempt has been made yet, so nothing has
                * changed. Re-queue with the same start time.
                */
               _ftpEnQ(event.event,event.state,event.start,&event.fcp);
            }
            return;
         } else {
            msg="Error waiting for control connection from Visual SlickEdit proxy.  ":+_ftpGetMessage(status);
            _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
            return;
         }
      } else {
         /* We now have a control connection with the VSE proxy.
          * Now we need to open a relay connection for communication
          * directly with the ftp server.
          */
         status=vssGetLocalSocketInfo(event.fcp.vsproxy_sock,temp_host,temp_port);
         if( status ) {
            msg="Error retrieving local host info for connection accept from Visual SlickEdit proxy.  ":+_ftpGetMessage(status);
            _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
            return;
         }
         _ftpLog(&event.fcp,"Connection accepted from Visual SlickEdit proxy on ":+temp_host:+":":+temp_port);
         _ftpEnQ(QE_RELAY_CONNECT,QS_BEGIN,0,&event.fcp);
         return;
      }
      return;
      break;
   case QS_ERROR:
      // An error occurred getting the proxy connection, so clean up
      _ftpDeleteLogBuffer(&event.fcp);
      _message_box(event.info[0],FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return;
      break;
   case QS_ABORT:
      // Event aborted
      _ftpDeleteLogBuffer(&event.fcp);
      return;
      break;
   case QS_END:
      // Event ends
      break;
   default:
      // Should never get here
      msg="Unknown FTP queue event state: ":+event.state:+" for event ":+event.event;
      _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      break;
   }

   return;
}

static void _ftpQEHandler_RelayConnect(ftpQEvent_t *e_p)
{
   ftpQEvent_t event;

   event= *e_p;   // Make a copy

   // Listening for vsproxy to connect a relay socket to us
   switch( event.state ) {
   case QS_BEGIN:
      // Event begins
      status=vssGetLocalSocketInfo(event.fcp.vsproxy_sock,temp_host,temp_port);
      if( status ) {
         msg="Error opening a relay connection.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      status=vssSocketOpen(temp_host,"0",temp_sock,1);
      if( status ) {
         msg="Error opening a relay connection.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      // Get the port that was dynamically assigned
      status=vssGetLocalSocketInfo(temp_sock,temp_host,temp_port);
      if( status ) {
         msg="Error opening a relay connection.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      event.fcp.sock=temp_sock;   // This socket will change once a connection is accepted
      status=_ftpVSProxyCommand(&event.fcp,"OPENRELAY",temp_host,temp_port);
      if( status ) {
         msg="Error opening a relay connection.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      _ftpEnQ(event.event,QS_LISTENING,event.start,&event.fcp);
      return;

      break;
   case QS_LISTENING:
      status=vssSocketAcceptConn(event.fcp.sock);
      if( status ) {
         if( status==SOCK_NO_CONN_PENDING_RC ) {
            elapsed=((int)_time('B')-event.start+1)/1000;   // Seconds
            if( elapsed>FTPDEF_TIMEOUT ) {
               // We timed out
               msg="Timed out waiting for relay connection from Visual SlickEdit proxy";
               _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
            } else {
               /* No connection attempt has been made yet, so nothing has
                * changed. Re-queue with the same start time.
                */
               _ftpEnQ(event.event,event.state,event.start,&event.fcp);
            }
            return;
         } else {
            msg="Error waiting for relay connection from Visual SlickEdit proxy.  ":+_ftpGetMessage(status);
            _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
            return;
         }
         break;
      }
      _ftpEnQ(event.event,QS_WAITING_FOR_REPLY,0,&event.fcp);
      return;
      break;
   case QS_WAITING_FOR_REPLY:
      // Waiting for the OPENRELAY response from the VSE proxy
      status=_ftpQCheckResponse(&event,true,response,true);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp);
         return;
      }
      if( status ) {
         msg="Error with OPENRELAY response from Visual SlickEdit proxy.  ":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      parse response with status .;
      if( status=="+ok" ) {
         /* We now have a relay connection with the VSE proxy.
          * Now we need to open a connection with the ftp server
          * through the control connection.
          */
         _ftpEnQ(QE_PROXY_OPEN,QS_BEGIN,0,&event.fcp);
         return;
      } else {
         // Should never get here
         msg="Unexpected response from Visual SlickEdit proxy:\n\n":+response;
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      break;
   case QS_ERROR:
      // An error occurred getting the relay connection, so clean up
      _ftpDeleteLogBuffer(&event.fcp);
      if( event.fcp.vsproxy_sock!=INVALID_SOCKET ) {
         _ftpVSProxyCommand(&event.fcp,"QUIT");
         vssSocketClose(event.fcp.vsproxy_sock);
         event.fcp.vsproxy_sock=INVALID_SOCKET;
      }
      _message_box(event.info[0],FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      break;
   case QS_ABORT:
      _ftpDeleteLogBuffer(&event.fcp);
      if( event.fcp.vsproxy_sock!=INVALID_SOCKET ) {
         _ftpVSProxyCommand(&event.fcp,"QUIT");
         vssSocketClose(event.fcp.vsproxy_sock);
         event.fcp.vsproxy_sock=INVALID_SOCKET;
      }
      break;
   case QS_END:
      // Event ends
      break;
   default:
      // Should never get here
      msg="Unknown FTP queue event state: ":+event.state:+" for event ":+event.event;
      _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      break;
   }

   return;
}

static void _ftpQEHandler_ProxyOpen(ftpQEvent_t *e_p)
{
   ftpQEvent_t event;

   event= *e_p;   // Make a copy

   // Connection to ftp server is being opened through VSE proxy
   switch( event.state ) {
   case QS_BEGIN:
      // Event begins
      use_firewall= (event.fcp.UseFW && event.fcp.Options.fwenable);
      if( use_firewall ) {
         if( event.fcp.Options.fwtype==FTPOPT_FWTYPE_USERAT ) {
            status=_ftpVSProxyCommand(&event.fcp,"OPEN",event.fcp.Options.fwhost,event.fcp.Options.fwport);
            if( status ) {
               msg="Error OPENing firewall connection: ":+event.fcp.Options.fwhost:+":":+event.fcp.Options.fwport:+".  ":+_ftpGetMessage(status);
               _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
               return;
            }
            _ftpEnQ(event.event,QS_WAITING_FOR_REPLY,0,&event.fcp);
            return;
         } else if( event.fcp.Options.fwtype==FTPOPT_FWTYPE_OPEN ) {
            status=_ftpVSProxyCommand(&event.fcp,"OPEN",event.fcp.Options.fwhost,event.fcp.Options.fwport);
            if( status ) {
               msg="Error OPENing firewall connection: ":+event.fcp.Options.fwhost:+":":+event.fcp.Options.fwport:+".  ":+_ftpGetMessage(status);
               _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
               return;
            }
            _ftpEnQ(event.event,QS_WAITING_FOR_REPLY,0,&event.fcp);
            return;
         } else if( event.fcp.Options.fwtype==FTPOPT_FWTYPE_ROUTER ) {
            /* This is transparent to the VSE proxy and will usually be a
             * router firewall. The only thing unique about a "Router"
             * firewall is that it uses passive (PASV) transfers.
             */
            status=_ftpVSProxyCommand(&event.fcp,"OPEN",event.fcp.Host,event.fcp.Port);
            if( status ) {
               msg="Error OPENing connection: ":+event.fcp.Host:+":":+event.fcp.Port:+".  ":+_ftpGetMessage(status);
               _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
               return;
            }
            _ftpEnQ(event.event,QS_WAITING_FOR_REPLY,0,&event.fcp);
            return;
         } else {
            // This should never happen
            msg="Undefined firewall/proxy type";
            _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
            return;
         }
      } else {
         status=_ftpVSProxyCommand(&event.fcp,"OPEN",event.fcp.Host,event.fcp.Port);
         if( status ) {
            msg="Error OPENing connection: ":+event.fcp.Host:+":":+event.fcp.Port:+".  ":+_ftpGetMessage(status);
            _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
            return;
         }
         _ftpEnQ(event.event,QS_WAITING_FOR_REPLY,0,&event.fcp);
         return;
      }
      break;
   case QS_WAITING_FOR_REPLY:
      // Waiting for the OPEN response from the VSE proxy
      status=_ftpQCheckResponse(&event,true,response,true);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp);
         return;
      }
      if( status ) {
         msg="Error OPENing connection to ftp server from Visual SlickEdit proxy.  ":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      parse response with status .;
      if( status=="+ok" ) {
         // Now we need to check the sign-on response from the ftp server
         _ftpEnQ(QE_OPEN,QS_BEGIN,0,&event.fcp);
         return;
      } else {
         // Should never get here
         msg="Unexpected response from Visual SlickEdit proxy:\n\n":+response;
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      break;
   case QS_ERROR:
      // An error occurred getting the ftp connection through the VSE proxy, so clean up
      _ftpDeleteLogBuffer(&event.fcp);
      if( event.fcp.sock!=INVALID_SOCKET ) {
         vssSocketClose(event.fcp.sock);
         event.fcp.sock=INVALID_SOCKET;
      }
      if( event.fcp.vsproxy_sock!=INVALID_SOCKET ) {
         _ftpVSProxyCommand(&event.fcp,"QUIT");
         vssSocketClose(event.fcp.vsproxy_sock);
         event.fcp.vsproxy_sock=INVALID_SOCKET;
      }
      _message_box(event.info[0],FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return;
      break;
   case QS_ABORT:
      // Event aborted
      _ftpDeleteLogBuffer(&event.fcp);
      if( event.fcp.sock!=INVALID_SOCKET ) {
         vssSocketClose(event.fcp.sock);
         event.fcp.sock=INVALID_SOCKET;
      }
      if( event.fcp.vsproxy_sock!=INVALID_SOCKET ) {
         _ftpVSProxyCommand(&event.fcp,"QUIT");
         vssSocketClose(event.fcp.vsproxy_sock);
         event.fcp.vsproxy_sock=INVALID_SOCKET;
      }
      return;
      break;
   case QS_END:
      // Event ends
      break;
   default:
      // Should never get here
      msg="Unknown FTP queue event state: ":+event.state:+" for event ":+event.event;
      _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return;
   }

   return;
}

static void _ftpQEHandler_Open(ftpQEvent_t *e_p)
{
   ftpQEvent_t event;

   event= *e_p;   // Make a copy

   // Now we are logging on to the ftp server through the relay connection
   switch( event.state ) {
   case QS_BEGIN:
      // Event begins
      // Fall thru to QS_WAITING_FOR_REPLY (they are really the same thing)
      event.state=QS_WAITING_FOR_REPLY;
   case QS_WAITING_FOR_REPLY:
      // Waiting for the connection response from ftp server
      status=_ftpQCheckResponse(&event,false,response,false);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp);
         return;
      }
      if( status ) {
         msg="Error connecting to: ":+event.fcp.Host:+":":+event.fcp.Port:+".  ":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      // Now we must send "USER userid"
      if( event.fcp.SavePassword ) {
         _ftpEnQ(QE_USER,QS_BEGIN,0,&event.fcp);
      } else {
         // User must be prompted
         _ftpEnQ(QE_USER,QS_PROMPT,0,&event.fcp);
      }
      return;
      break;
   case QS_ERROR:
      // An error occurred logging on to ftp server
      _ftpDeleteLogBuffer(&event.fcp);
      if( event.fcp.sock!=INVALID_SOCKET ) {
         vssSocketClose(event.fcp.sock);
         event.fcp.sock=INVALID_SOCKET;
      }
      if( event.fcp.vsproxy_sock!=INVALID_SOCKET ) {
         _ftpVSProxyCommand(&event.fcp,"QUIT");
         vssSocketClose(event.fcp.vsproxy_sock);
         event.fcp.vsproxy_sock=INVALID_SOCKET;
      }
      _message_box(event.info[0],FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return;
   case QS_ABORT:
      // Event aborted
      _ftpDeleteLogBuffer(&event.fcp);
      if( event.fcp.sock!=INVALID_SOCKET ) {
         vssSocketClose(event.fcp.sock);
         event.fcp.sock=INVALID_SOCKET;
      }
      if( event.fcp.vsproxy_sock!=INVALID_SOCKET ) {
         _ftpVSProxyCommand(&event.fcp,"QUIT");
         vssSocketClose(event.fcp.vsproxy_sock);
         event.fcp.vsproxy_sock=INVALID_SOCKET;
      }
      return;
   default:
      // Should never get here
      msg="Unknown FTP queue event state: ":+event.state:+" for event ":+event.event;
      _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return;
   }

   return;
}

static void _ftpQEHandler_User(ftpQEvent_t *e_p)
{
   ftpQEvent_t event;

   event= *e_p;   // Make a copy

   // Sending user id to ftp server
   switch( event.state ) {
   case QS_BEGIN:
      // Event begins
      use_firewall= (event.fcp.UseFW && event.fcp.Options.fwenable);
      if( use_firewall ) {
         if( event.fcp.Options.fwtype==FTPOPT_FWTYPE_USERAT ) {
            fwuser=event.fcp.UserID:+'@':+event.fcp.Host;
            status=_ftpCommand(&event.fcp,false,"USER",fwuser);
            if( status ) {
               msg="Error sending USER to firewall host: ":+event.fcp.Options.fwhost:+":":+event.fcp.Options.fwport:+".  ":+_ftpGetMessage(status);
               _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
               return;
            }
            _ftpEnQ(QE_USER,QS_WAITING_FOR_REPLY,0,&event.fcp);
            return;
         } else if( event.fcp.Options.fwtype==FTPOPT_FWTYPE_OPEN ) {
            status=_ftpCommand(&event.fcp,false,"OPEN",event.fcp.Host);
            if( status ) {
               msg="Error sending OPEN to firewall host: ":+event.fcp.Options.fwhost:+":":+event.fcp.Options.fwport:+".  ":+_ftpGetMessage(status);
               _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
               return;
            }
            return;
         } else if( event.fcp.Options.fwtype==FTPOPT_FWTYPE_ROUTER ) {
            /* Fall thru to sending the "USER" line. The only unique thing
             * about this firewall type is that it requires passive (PASV)
             * transfers (usually through a router).
             */
         } else {
            // This should never happen
            msg="Undefined firewall/proxy type";
            _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
            return;
         }
      }
      /* I hope you can send the "USER" line right after the "OPEN" line
       * for the FTPOPT_FWTYPE_OPEN firewall.
       */
      status=_ftpCommand(&event.fcp,false,"USER",event.fcp.UserID);
      if( status ) {
         msg="Error sending USER to ftp host: ":+event.fcp.Host:+":":+event.fcp.Port:+".  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      _ftpEnQ(QE_USER,QS_WAITING_FOR_REPLY,0,&event.fcp);
      return;
      break;
   case QS_PROMPT:
      // Prompt for userid/password
      _str result:[];
      result._makeempty();
      user=event.fcp.UserID;
      pass=event.fcp.Password;
      if( !event.fcp.Anonymous && pass!="" ) {
         status=vssDecrypt(pass,plain);
         if( status ) {
            event.fcp.Password="";
            msg="Error retrieving password";
            _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
            return;
         }
         pass=plain;
      }
      caption="";
      if( !event.info._isempty() ) {
         caption=event.info[0];   // This is probably a bad response from ftp server
      } else {
      }
      status=show("-modal _ftpUserPass_form",&result,caption,user,pass);
      if( status=='' || status!=0 ) {
         // The use cancelled, so we're done. Now cleanup
         _ftpDeleteLogBuffer(&event.fcp);
         if( event.fcp.sock!=INVALID_SOCKET ) {
            vssSocketClose(event.fcp.sock);
         }
         if( event.fcp.vsproxy_sock!=INVALID_SOCKET ) {
            _ftpVSProxyCommand(&event.fcp,"QUIT");
            vssSocketClose(event.fcp.vsproxy_sock);
            event.fcp.vsproxy_sock=INVALID_SOCKET;
         }
         _ftpEnQ(event.event,QS_ABORT,0,&event.fcp);
         return;
      }
      user=result:["user"];
      pass=result:["pass"];
      event.fcp.UserID=user;
      if( event.fcp.Anonymous ) {
         event.fcp.Password=pass;
      } else {
         if( pass!="" ) {
            status=vssEncrypt(pass,cipher);
            if( status ) {
               event.fcp.Password="";
               msg="Error saving password";
               _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
               return;
            }
            event.fcp.Password=cipher;
         } else {
            event.fcp.Password=pass;
         }
      }
      _ftpEnQ(event.event,QS_BEGIN,0,&event.fcp);
      return;
      break;
   case QS_WAITING_FOR_REPLY:
      // Waiting for the USER response from ftp server
      status=_ftpQCheckResponse(&event,false,response,false);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp);
         return;
      }
      if( status ) {
         if( status==FTP_BAD_RESPONSE_RC ) {
            /* Retry the user/pass.
             * The last argument is an overriding caption for the
             * dialog that prompts for userid/password. This is so
             * the user sees the bad response from the ftp server.
             */
            _ftpEnQ(event.event,QS_PROMPT,0,&event.fcp,event.fcp.LastStatusLine);
            return;
         }
         msg="Error connecting to: ":+event.fcp.Host:+":":+event.fcp.Port:+".  ":+_ftpGetMessage(status);
         if( status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      // Now we must send "PASS password"
      _ftpEnQ(QE_PASS,QS_BEGIN,0,&event.fcp);
      return;
      break;
   case QS_ERROR:
      // An error occurred logging on to ftp server
      _ftpDeleteLogBuffer(&event.fcp);
      if( event.fcp.sock!=INVALID_SOCKET ) {
         vssSocketClose(event.fcp.sock);
         event.fcp.sock=INVALID_SOCKET;
      }
      if( event.fcp.vsproxy_sock!=INVALID_SOCKET ) {
         _ftpVSProxyCommand(&event.fcp,"QUIT");
         vssSocketClose(event.fcp.vsproxy_sock);
         event.fcp.vsproxy_sock=INVALID_SOCKET;
      }
      _message_box(event.info[0],FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return;
      break;
   case QS_ABORT:
      // Event aborted
      _ftpDeleteLogBuffer(&event.fcp);
      if( event.fcp.sock!=INVALID_SOCKET ) {
         vssSocketClose(event.fcp.sock);
         event.fcp.sock=INVALID_SOCKET;
      }
      if( event.fcp.vsproxy_sock!=INVALID_SOCKET ) {
         _ftpVSProxyCommand(&event.fcp,"QUIT");
         vssSocketClose(event.fcp.vsproxy_sock);
         event.fcp.vsproxy_sock=INVALID_SOCKET;
      }
      return;
      break;
   case QS_END:
      // Event ends
      break;
   default:
      // Should never get here
      msg="Unknown FTP queue event state: ":+event.state:+" for event ":+event.event;
      _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      break;
   }

   return;
}

static void _ftpQEHandler_Pass(ftpQEvent_t *e_p)
{
   ftpQEvent_t event;

   event= *e_p;   // Make a copy

   // Sending password to ftp server
   switch( event.state ) {
   case QS_BEGIN:
      // Event begins
      pass=event.fcp.Password;
      if( !event.fcp.Anonymous && pass!="" ) {
         // Must decrypt
         status=vssDecrypt(pass,plain);
         if( status ) {
            msg="Error retrieving password";
            _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
            return;
         }
         pass=plain;
      }
      status=_ftpPass(&event.fcp,pass);
      if( status ) {
         msg="Error sending PASS to ftp host: ":+event.fcp.Host:+":":+event.fcp.Port:+".  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      _ftpEnQ(event.event,QS_WAITING_FOR_REPLY,0,&event.fcp);
      return;
      break;
   case QS_WAITING_FOR_REPLY:
      // Waiting for the PASS response from ftp server
      status=_ftpQCheckResponse(&event,false,response,false);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp);
         return;
      }
      if( status ) {
         if( status==FTP_BAD_RESPONSE_RC ) {
            /* Retry the user/pass.
             * The last argument is an overriding caption for the
             * dialog that prompts for userid/password. This is so
             * the user sees the bad response from the ftp server.
             */
            _ftpEnQ(QE_USER,QS_PROMPT,0,&event.fcp,event.fcp.LastStatusLine);
            return;
         }
         msg="Error connecting to: ":+event.fcp.Host:+":":+event.fcp.Port:+".  ":+_ftpGetMessage(status);
         if( status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      // Now we must set/get the current working directory (CWD)
      _ftpEnQ(QE_CWD,QS_BEGIN,0,&event.fcp,event.fcp.DefRemoteHostDir);
      return;
      break;
   case QS_ERROR:
      // An error occurred logging on to ftp server
      _ftpDeleteLogBuffer(&event.fcp);
      if( event.fcp.sock!=INVALID_SOCKET ) {
         vssSocketClose(event.fcp.sock);
         event.fcp.sock=INVALID_SOCKET;
      }
      if( event.fcp.vsproxy_sock!=INVALID_SOCKET ) {
         _ftpVSProxyCommand(&event.fcp,"QUIT");
         vssSocketClose(event.fcp.vsproxy_sock);
         event.fcp.vsproxy_sock=INVALID_SOCKET;
      }
      _message_box(event.info[0],FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return;
      break;
   case QS_ABORT:
      // Event aborted
      _ftpDeleteLogBuffer(&event.fcp);
      if( event.fcp.sock!=INVALID_SOCKET ) {
         vssSocketClose(event.fcp.sock);
         event.fcp.sock=INVALID_SOCKET;
      }
      if( event.fcp.vsproxy_sock!=INVALID_SOCKET ) {
         _ftpVSProxyCommand(&event.fcp,"QUIT");
         vssSocketClose(event.fcp.vsproxy_sock);
         event.fcp.vsproxy_sock=INVALID_SOCKET;
      }
      return;
      break;
   case QS_END:
      // Event ends
      break;
   default:
      // Should never get here
      msg="Unknown FTP queue event state: ":+event.state:+" for event ":+event.event;
      _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      break;
   }

   return;
}

static void _ftpQEHandler_Cdup(ftpQEvent_t *e_p)
{
   ftpQEvent_t event;

   event= *e_p;   // Make a copy

   // CDUP to the parent directory
   switch( event.state ) {
   case QS_BEGIN:
      // Event begins
      status=_ftpCommand(&event.fcp,false,"CDUP");
      if( status ) {
         msg="Error sending CDUP.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      _ftpEnQ(event.event,QS_WAITING_FOR_REPLY,0,&event.fcp);
      return;
      break;
   case QS_WAITING_FOR_REPLY:
      // Waiting for the CDUP response from ftp server
      status=_ftpQCheckResponse(&event,false,response,false);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp);
         return;
      }
      if( status ) {
         msg="Error changing remote directory.  ":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      /* We are expecting something like:
       *
       * 250 "/pub/demos" is new cwd.
       */

      /* Only use PWD to actually get the current working directory, even after
       * successful CDUP because we could be changing directory on a symbolic link.
       * PWD would return something completely different in this case.  Also can
       * not depend on CDUP to give the new current working directory like PWD.
       */
      _ftpEnQ(QE_PWD,QS_BEGIN,0,&event.fcp);
      return;
      break;
   case QS_ERROR:
      // An error occurred with CDUP
      _message_box(event.info[0],FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return;
      break;
   case QS_ABORT:
      // Event aborted
      return;
      break;
   case QS_END:
      // Event ends
      break;
   default:
      // Should never get here
      msg="Unknown FTP queue event state: ":+event.state:+" for event ":+event.event;
      _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      break;
   }

   return;
}

static void _ftpQEHandler_Cwd(ftpQEvent_t *e_p)
{
   ftpQEvent_t event;

   event= *e_p;   // Make a copy

   switch( event.state ) {
   case QS_BEGIN:
      // Event begins
      if( !event.info[0]._isempty() && event.info[0]!="" ) {
         status=_ftpCommand(&event.fcp,false,"CWD",event.info[0]);
         if( status ) {
            msg="Error sending CWD.  ":+_ftpGetMessage(status);
            _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
            return;
         }
         _ftpEnQ(event.event,QS_WAITING_FOR_REPLY,0,&event.fcp);
      } else {
         // There is no directory to change to, so just get the current working directory
         /* Only use PWD to actually get the current working directory, even after
          * successful CWD because we could be changing directory on a symbolic link.
          * PWD would return something completely different in this case.  Also can
          * not depend on CDUP to give the new current working directory like PWD.
          */
         _ftpEnQ(QE_PWD,QS_BEGIN,0,&event.fcp);
      }
      return;
      break;
   case QS_WAITING_FOR_REPLY:
      // Waiting for the CWD response from ftp server
      status=_ftpQCheckResponse(&event,false,response,false);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp);
         return;
      }
      if( status ) {
         msg="Error changing remote directory.  ":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      /* We are expecting something like:
       *
       * 250 "/home/slick/www-slickedit" is new cwd.
       */

      /* Only use PWD to actually get the current working directory, even after
       * successful CWD because we could be changing directory on a symbolic link.
       * PWD would return something completely different in this case.  Also can
       * not depend on CDUP to give the new current working directory like PWD.
       */
      _ftpEnQ(QE_PWD,QS_BEGIN,0,&event.fcp);
      return;
      break;
   case QS_ERROR:
      // An error occurred with CWD
      _message_box(event.info[0],FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return;
      break;
   case QS_ABORT:
      // Event aborted
      return;
      break;
   case QS_END:
      // Event ends
      break;
   default:
      // Should never get here
      msg="Unknown FTP queue event state: ":+event.state:+" for event ":+event.event;
      _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      break;
   }

   return;
}

static void _ftpQEHandler_Pwd(ftpQEvent_t *e_p)
{
   ftpQEvent_t event;

   event= *e_p;   // Make a copy

   switch( event.state ) {
   case QS_BEGIN:
      // Event begins
      status=_ftpCommand(&event.fcp,false,"PWD");
      if( status ) {
         msg="Error sending PWD.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      _ftpEnQ(event.event,QS_WAITING_FOR_REPLY,0,&event.fcp);
      return;
      break;
   case QS_WAITING_FOR_REPLY:
      // Waiting for the PWD response from ftp server
      status=_ftpQCheckResponse(&event,false,response,false);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp);
         return;
      }
      if( status ) {
         msg="Error getting remote current working directory.  ":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      /* We are expecting something like:
       *
       * 257 "/home/slick/www-slickedit" is cwd.
       */
      parse response with . pwd .;
      pwd=strip(pwd,'B','"');
      if( pwd=="" ) {
         // This should never happen
         msg="Attempt to change working directory failed.\n\n":+
             "PWD returned:\n\n":+'""';
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      event.fcp.RemoteCWD=pwd;
      _ftpEnQ(event.event,QS_END,0,&event.fcp);
      return;
      break;
   case QS_ERROR:
      // An error occurred with PWD
      _message_box(event.info[0],FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return;
      break;
   case QS_ABORT:
      // Event aborted
      return;
      break;
   case QS_END:
      // Event ends
      break;
   default:
      // Should never get here
      msg="Unknown FTP queue event state: ":+event.state:+" for event ":+event.event;
      _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      break;
   }

   return;
}

static void _ftpQEHandler_Syst(ftpQEvent_t *e_p)
{
   ftpQEvent_t event;

   event= *e_p;   // Make a copy

   switch( event.state ) {
   case QS_BEGIN:
      // Event begins
      status=_ftpCommand(&event.fcp,false,"SYST");
      if( status ) {
         msg="Error sending SYST.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      _ftpEnQ(event.event,QS_WAITING_FOR_REPLY,0,&event.fcp);
      return;
      break;
   case QS_WAITING_FOR_REPLY:
      // Waiting for the SYST response from ftp server
      status=_ftpQCheckResponse(&event,false,response,false);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp);
         return;
      }
      if( status ) {
         if( status!=FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg="Error getting system name.\n\n":+event.fcp.LastStatusLine;
            _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         } else {
            // This ftp server does not support the SYST command
            _ftpLog(&event.fcp,"SYST command not supported");
         }
         if( event.fcp.System==FTPOS_AUTO ) {
            // No way of finding out what type of host automatically
            event.fcp.System=FTPOS_DEFAULT;
         }
         return;
      }
      /* We are expecting something like:
       *
       * 215 Windows_NT version 4.0
       */
      parse response with . syst;
      syst=strip(syst,'T',"\n");
      syst=strip(syst,'T',"\r");
      event.fcp.System=FTPOS_DEFAULT;
      if( pos('Windows_NT',syst,1,'i') ) {
         event.fcp.System=FTPOS_WINNT;
      } else if( pos('VOS',syst) ) {
         event.fcp.System=FTPOS_VOS;
      } else if( pos('MVS',syst) ) {
         event.fcp.System=FTPOS_MVS;
      } else {
         event.fcp.System=FTPOS_DEFAULT;
      }
      _ftpEnQ(event.event,QS_END,0,&event.fcp);
      return;
      break;
   case QS_ERROR:
      // An error occurred with SYST
      _message_box(event.info[0],FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return;
      break;
   case QS_ABORT:
      // Event aborted
      return;
      break;
   case QS_END:
      // Event ends
      break;
   default:
      // Should never get here
      msg="Unknown FTP queue event state: ":+event.state:+" for event ":+event.event;
      _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      break;
   }

   return;
}

static void _ftpQEHandler_Mkd(ftpQEvent_t *e_p)
{
   ftpQEvent_t event;

   event= *e_p;   // Make a copy

   switch( event.state ) {
   case QS_BEGIN:
      // Event begins
      if( event.info[0]._isempty() || event.info[0]=="" ) {
         // Nothing to make
         msg="Not enought arguments for MKD";
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      path=event.info[0];
      status=_ftpCommand(&event.fcp,false,"MKD",path);
      if( status ) {
         msg="Error sending MKD.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      _ftpEnQ(event.event,QS_WAITING_FOR_REPLY,0,&event.fcp);
      return;
      break;
   case QS_WAITING_FOR_REPLY:
      // Waiting for the MKD response from ftp server
      status=_ftpQCheckResponse(&event,false,response,false);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp);
         return;
      }
      if( status ) {
         msg="Error making remote directory.  ":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      /* We are expecting something like:
       *
       * 257 MKD command successful.
       */
      return;   // Done
      break;
   case QS_ERROR:
      // An error occurred with MKD
      _message_box(event.info[0],FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return;
      break;
   case QS_ABORT:
      // Event aborted
      return;
      break;
   case QS_END:
      // Event ends
      break;
   default:
      // Should never get here
      msg="Unknown FTP queue event state: ":+event.state:+" for event ":+event.event;
      _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      break;
   }

   return;
}

static void _ftpQEHandler_Dele(ftpQEvent_t *e_p)
{
   ftpQEvent_t event;

   event= *e_p;   // Make a copy

   switch( event.state ) {
   case QS_BEGIN:
      // Event begins
      if( event.info[0]._isempty() || event.info[0]=="" ) {
         // Nothing to delete
         msg="Not enough arguments for DELE";
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      path=event.info[0];
      status=_ftpCommand(&event.fcp,false,"DELE",path);
      if( status ) {
         msg="Error sending DELE.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      _ftpEnQ(event.event,QS_WAITING_FOR_REPLY,0,&event.fcp);
      return;
      break;
   case QS_WAITING_FOR_REPLY:
      // Waiting for the MKD response from ftp server
      status=_ftpQCheckResponse(&event,false,response,false);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp);
         return;
      }
      if( status ) {
         msg="Error deleting file.  ":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      /* We are expecting something like:
       *
       * 250 DELE command successful.
       */
      return;   // Done
      break;
   case QS_ERROR:
      // An error occurred with DELE
      _message_box(event.info[0],FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return;
      break;
   case QS_ABORT:
      // Event aborted
      return;
      break;
   case QS_END:
      // Event ends
      break;
   default:
      // Should never get here
      msg="Unknown FTP queue event state: ":+event.state:+" for event ":+event.event;
      _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      break;
   }

   return;
}

static void _ftpQEHandler_Rmd(ftpQEvent_t *e_p)
{
   ftpQEvent_t event;

   event= *e_p;   // Make a copy

   switch( event.state ) {
   case QS_BEGIN:
      // Event begins
      if( event.info[0]._isempty() || event.info[0]=="" ) {
         // Nothing to delete
         msg="Not enough arguments for RMD";
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      path=event.info[0];
      status=_ftpCommand(&event.fcp,false,"RMD",path);
      if( status ) {
         msg="Error sending RMD.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      _ftpEnQ(event.event,QS_WAITING_FOR_REPLY,0,&event.fcp);
      return;
      break;
   case QS_WAITING_FOR_REPLY:
      // Waiting for the MKD response from ftp server
      status=_ftpQCheckResponse(&event,false,response,false);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp);
         return;
      }
      if( status ) {
         msg="Error removing directory.  ":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      /* We are expecting something like:
       *
       * 250 RMD command successful.
       */
      return;   // Done
      break;
   case QS_ERROR:
      // An error occurred with RMD
      _message_box(event.info[0],FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return;
      break;
   case QS_ABORT:
      // Event aborted
      return;
      break;
   case QS_END:
      // Event ends
      break;
   default:
      // Should never get here
      msg="Unknown FTP queue event state: ":+event.state:+" for event ":+event.event;
      _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      break;
   }

   return;
}

static void _ftpQEHandler_Rename(ftpQEvent_t *e_p)
{
   ftpQEvent_t event;

   event= *e_p;   // Make a copy

   switch( event.state ) {
   case QS_BEGIN:
      // Event begins
      if( event.info._length()<2 ) {
         // Nothing to rename
         msg="Not enough arguments for RENAME";
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      rnfr=event.info[0];
      status=_ftpCommand(&event.fcp,false,"RNFR",rnfr);
      if( status ) {
         msg="Error sending RNFR.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      rnto=event.info[1];
      _ftpEnQ(event.event,QS_RNFR_WAITING_FOR_REPLY,0,&event.fcp,rnto);
      return;
      break;
   case QS_RNFR_WAITING_FOR_REPLY:
      // Waiting for the RNFR response from ftp server
      rnto=event.info[0];   // Passed by QS_RNFR_WAITING_FOR_REPLY
      status=_ftpQCheckResponse(&event,false,response,false);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp,rnto);
         return;
      }
      if( status ) {
         msg="Error with RNFR":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      /* We are expecting something like:
       *
       * 350 File exists, ready for destination name
       */
      status=_ftpCommand(&event.fcp,false,"RNTO",rnto);
      if( status ) {
         msg="Error sending RNTO.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      _ftpEnQ(event.event,QS_RNTO_WAITING_FOR_REPLY,0,&event.fcp);
      return;   // Done
      break;
   case QS_RNTO_WAITING_FOR_REPLY:
      // Waiting for the RNTO response from ftp server
      status=_ftpQCheckResponse(&event,false,response,false);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp);
         return;
      }
      if( status ) {
         msg="Error with RNTO":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      /* We are expecting something like:
       *
       * 250 RNTO command successful.
       */
      return;
      break;
   case QS_ERROR:
      // An error occurred with RENAME
      _message_box(event.info[0],FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return;
      break;
   case QS_ABORT:
      // Event aborted
      return;
      break;
   case QS_END:
      // Event ends
      break;
   default:
      // Should never get here
      msg="Unknown FTP queue event state: ":+event.state:+" for event ":+event.event;
      _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      break;
   }

   return;
}

static void _ftpQEHandler_RecvCmd(ftpQEvent_t *e_p)
{
   ftpQEvent_t event;
   RecvCmd_t rcmd;

   event= *e_p;   // Make a copy

   rcmd= (RecvCmd_t)event.info[0];

   switch( event.state ) {
   case QS_BEGIN:
      // Event begins
      if( rcmd.pasv ) {
         /* Performing a passive transfer. Issue a "PASV" command so the FTP
          * server will return an address and port we can read from. Client
          * (VSE) initiates connection with FTP server.
          */
         _ftpEnQ(event.event,QS_PASV_BEGIN,0,&event.fcp,rcmd);
         return;
      } else {
         /* Active transfer. Issue a "LISTENDATA" command to the VSE proxy
          * to get an available address/port for the FTP server to transfer
          * data to.
          */
         _ftpEnQ(event.event,QS_PROXY_LISTENDATA_BEGIN,0,&event.fcp,rcmd);
         return;
      }
      break;
   case QS_PASV_BEGIN:
      status=_ftpCommand(&event.fcp,false,"PASV");
      if( status ) {
         msg="Error sending PASV.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,rcmd,msg);
         return;
      }
      _ftpEnQ(event.event,QS_PASV_WAITING_FOR_REPLY,0,&event.fcp,rcmd);
      return;
      break;
   case QS_PASV_WAITING_FOR_REPLY:
      // Waiting for the PASV response from ftp server
      status=_ftpQCheckResponse(&event,false,response,false);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp,rcmd);
         return;
      }
      if( status ) {
         msg="Error obtaining PASV response.  ":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
            _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,rcmd,msg);
            return;
         }
      }
      /* We are expecting something like:
       *
       * 227 Entering passive mode (192,168,0,1,16,51)
       */
      i=pos('{#0\(:i\,:i\,:i\,:i\,:i\,:i\)}',response,1,'er');
      if( !i ) {
         msg="Could not determine address/port from PASV";
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,rcmd,msg);
         return;
      }
      parse substr(response,pos('S0'),pos('0')) with '(' a1 ',' a2 ',' a3 ',' a4 ',' p1 ',' p2 ')';
      temp_host=a1'.'a2'.'a3'.'a4;
      temp_port= (p1<<8)+p2;
      rcmd.datahost=temp_host;
      rcmd.dataport=temp_port;
      _ftpEnQ(event.event,QS_PROXY_OPENDATA_BEGIN,0,&event.fcp,rcmd);
      return;
      break;
   case QS_PROXY_OPENDATA_BEGIN:
      status=_ftpVSProxyCommand(&event.fcp,"OPENDATA",rcmd.datahost,rcmd.dataport);
      if( status ) {
         msg="Error sending OPENDATA to Visual SlickEdit proxy.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,rcmd,msg);
         return;
      }
      _ftpEnQ(event.event,QS_PROXY_OPENDATA_WAITING_FOR_REPLY,0,&event.fcp,rcmd);
      return;
      break;
   case QS_PROXY_OPENDATA_WAITING_FOR_REPLY:
      // Waiting for the OPENDATA response from VSE proxy
      status=_ftpQCheckResponse(&event,true,response,true);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp,rcmd);
         return;
      }
      if( status ) {
         msg="Error with OPENDATA response from Visual SlickEdit proxy.  ":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,rcmd,msg);
         return;
      }
      _ftpEnQ(event.event,QS_TYPE_BEGIN,0,&event.fcp,rcmd);
      return;
      break;
   case QS_PROXY_LISTENDATA_BEGIN:
      status=_ftpVSProxyCommand(&event.fcp,"LISTENDATA");
      if( status ) {
         msg="Error sending LISTENDATA to Visual SlickEdit proxy.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,rcmd,msg);
         return;
      }
      _ftpEnQ(event.event,QS_PROXY_LISTENDATA_WAITING_FOR_REPLY,0,&event.fcp,rcmd);
      return;
      break;
   case QS_PROXY_LISTENDATA_WAITING_FOR_REPLY:
      // Waiting for the LISTENDATA response from VSE proxy
      status=_ftpQCheckResponse(&event,true,response,true);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp,rcmd);
         return;
      }
      if( status ) {
         msg="Error with LISTENDATA response from Visual SlickEdit proxy.  ":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,rcmd,msg);
         return;
      }

      /* Expecting something like:
       *
       * +ok Listening at 192.168.0.1:1025 (4,1)
       */
      i=pos(':i.:i.:i.:i\::i',response,1,'er');
      if( !i ) {
         msg="Could not determine address/port from LISTENDATA response:\n\n":+
             response;
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,rcmd,msg);
         return;
      }
      parse substr(response,i) with temp_host ':' temp_port .;
      rcmd.datahost=temp_host;
      rcmd.dataport=temp_port;
      _ftpEnQ(event.event,QS_PORT_BEGIN,0,&event.fcp,rcmd);
      return;
      break;
   case QS_PORT_BEGIN:
      /* Active transfer. Issue a "PORT" command so the FTP server knows
       * where to connect to on the client side (VSE). Firewalls do not
       * like this method because the FTP server initiates the connection
       * to the client (VSE).
       */

      /* Now issue the "PORT" command with the host and port info we got
       * from LISTENDATA, so that the FTP server knows where to connect.
       */
      temp_host=rcmd.datahost;
      temp_port=rcmd.dataport;
      parse temp_host with a1 '.' a2 '.' a3 '.' a4;
      p1= (int)(temp_port>>8) & 0x000000ff;
      p2= temp_port & 0x000000ff;
      info=a1','a2','a3','a4','p1','p2;
      status=_ftpCommand(&event.fcp,false,"PORT",info);
      if( status ) {
         msg="Error sending PORT command.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,rcmd,msg);
         return;
      }
      _ftpEnQ(event.event,QS_PORT_WAITING_FOR_REPLY,0,&event.fcp,rcmd);
      return;
      break;
   case QS_PORT_WAITING_FOR_REPLY:
      // Waiting for the PORT response from the ftp server
      status=_ftpQCheckResponse(&event,false,response,false);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp,rcmd);
         return;
      }
      if( status ) {
         msg="Error with PORT response.  ":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,rcmd,msg);
         return;
      }

      /* Expecting something like:
       *
       * 200 PORT command successful.
       */
      _ftpEnQ(event.event,QS_TYPE_BEGIN,0,&event.fcp,rcmd);
      return;
      break;
   case QS_TYPE_BEGIN:
      status=_ftpType(&event.fcp);
      if( status ) {
         msg="Error sending TYPE.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,rcmd,msg);
         return;
      }
      _ftpEnQ(event.event,QS_TYPE_WAITING_FOR_REPLY,0,&event.fcp,rcmd);
      return;
      break;
   case QS_TYPE_WAITING_FOR_REPLY:
      // Waiting for the TYPE response from ftp server
      status=_ftpQCheckResponse(&event,false,response,false);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp,rcmd);
         return;
      }
      if( status ) {
         msg="Error with TYPE response.  ":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,rcmd,msg);
         return;
      }
      /* We are expecting something like:
       *
       * 200 Type okay.
       */
      _ftpEnQ(event.event,QS_CMD_BEGIN,0,&event.fcp,rcmd);
      return;
      break;
   case QS_CMD_BEGIN:
      status=_ftpCommand(&event.fcp,false,rcmd.cmdargv);
      if( status ) {
         msg="Error sending ":+rcmd.cmdargv[0]:+" command.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,&rmcd,msg);
         return;
      }
      _ftpEnQ(event.event,QS_CMD_WAITING_FOR_REPLY,0,&event.fcp,rcmd);
      return;
      break;
   case QS_CMD_WAITING_FOR_REPLY:
      // Waiting for the command response from ftp server
      status=_ftpQCheckResponse(&event,false,response,false);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp,rcmd);
         return;
      }
      if( status ) {
         msg="Error with ":+rcmd.cmdargv[0]:+" response.  ":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,rcmd,msg);
         return;
      }
      size=0;
      i=pos('\(:i bytes',response,1,'er');
      if( i ) {
         parse substr(response,i) with '(' temp 'bytes' ')';
         if( isinteger(temp) && temp>=0 ) {
            size= (int)temp;
         }
      }
      rcmd.size= (int)size;
      _ftpEnQ(event.event,QS_PROXY_RECVDATA_BEGIN,0,&event.fcp,rcmd);
      return;
      break;
   case QS_PROXY_RECVDATA_BEGIN:
      options="";
      if( event.fcp.XferType==FTPXFER_ASCII ) {
         // Translate newlines into the local newline format
         options=options:+" +L";
      }
      status=_ftpVSProxyCommand(&event.fcp,"RECVDATA",options,maybe_quote_filename(rcmd.dest));
      if( status ) {
         msg="Error sending RECVDATA to Visual SlickEdit proxy.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,rcmd,msg);
         return;
      }
      _ftpEnQ(event.event,QS_PROXY_RECVDATA_WAITING_FOR_REPLY,0,&event.fcp,rcmd);
      return;
      break;
   case QS_PROXY_RECVDATA_WAITING_FOR_REPLY:
      // Waiting for the RECVDATA response from VSE proxy
      status=_ftpQCheckResponse(&event,true,response,true);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp,rcmd);
         return;
      }
      if( status ) {
         msg="Error with RECVDATA response from Visual SlickEdit proxy.  ":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,rcmd,msg);
         return;
      }

      /* Expecting something like:
       *
       * +ok Receiving to file "c:\temp\1110001.4"
       */
      _ftpEnQ(event.event,QS_PROXY_DATASTAT_BEGIN,0,&event.fcp,rcmd);
      return;
      break;
   case QS_PROXY_DATASTAT_BEGIN:
      status=_ftpVSProxyCommand(&event.fcp,"DATASTAT");
      if( status ) {
         msg="Error sending DATASTAT to Visual SlickEdit proxy.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,rcmd,msg);
         return;
      }
      _ftpEnQ(event.event,QS_PROXY_DATASTAT_WAITING_FOR_REPLY,0,&event.fcp,rcmd);
      return;
      break;
   case QS_PROXY_DATASTAT_WAITING_FOR_REPLY:
      // Waiting for the DATASTAT response from VSE proxy
      status=_ftpQCheckResponse(&event,true,response,true);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp,rcmd);
         return;
      }
      if( status ) {
         msg="Error with DATASTAT response from Visual SlickEdit proxy.  ":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,rcmd,msg);
         return;
      }
      /* Expecting something like:
       *
       * +ok 1024
       * OR
       * +ok Done
       */
      i=lastpos('+ok',response);
      if( !i ) {
         msg="Error with DATASTAT response from Visual SlickEdit proxy:\n\n":+
             response;
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,rcmd,msg);
         return;
      }
      parse substr(response,i) with '+ok' status .;
      status=strip(status);
      status=strip(status,'T',"\n");
      status=strip(status,'T',"\r");
      if( lowcase(status)=='done' ) {
         // Transfer complete
         if( rcmd.ProgressCB ) {
            line=rcmd.cmdargv[0];
            for( i=1;i<rcmd.cmdargv._length();++i ) {
               line=line:+" ":+rcmd.cmdargv[i];
            }
            (*rcmd.ProgressCB)(line,rcmd.size,rcmd.size);
         }
         _ftpEnQ(event.event,QS_PROXY_CLOSEDATA_BEGIN,0,&event.fcp,rcmd);
         return;
      } else if( isinteger(status) ) {
         // Transfer still in progress
         if( rcmd.ProgressCB ) {
            line=rcmd.cmdargv[0];
            for( i=1;i<rcmd.cmdargv._length();++i ) {
               line=line:+" ":+rcmd.cmdargv[i];
            }
            (*rcmd.ProgressCB)(line,(int)status,rcmd.size);
         }
         _ftpEnQ(event.event,QS_PROXY_DATASTAT_BEGIN,0,&event.fcp,rcmd);
         return;
      } else {
         // No idea what this is
         //_message_box("status=["status"]\n\nresponse="response);
         msg="Error with DATASTAT response from Visual SlickEdit proxy:\n\n":+
             response;
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,rcmd,msg);
         return;
      }
      break;
   case QS_PROXY_CLOSEDATA_BEGIN:
      status=_ftpVSProxyCommand(&event.fcp,"CLOSEDATA");
      if( status ) {
         msg="Error sending CLOSEDATA to Visual SlickEdit proxy.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,rcmd,msg);
         return;
      }
      _ftpEnQ(event.event,QS_PROXY_CLOSEDATA_WAITING_FOR_REPLY,0,&event.fcp,rcmd);
      return;
      break;
   case QS_PROXY_CLOSEDATA_WAITING_FOR_REPLY:
      // Waiting for the CLOSEDATA response from VSE proxy
      status=_ftpQCheckResponse(&event,true,response,true);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp,rcmd);
         return;
      }
      if( status ) {
         msg="Error with CLOSEDATA response from Visual SlickEdit proxy.  ":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,rcmd,msg);
         return;
      }

      /* Expecting something like:
       *
       * +ok Received 16384 bytes to file "c:\temp\1110001.4"
       */
      _ftpEnQ(event.event,QS_END_TRANSFER_WAITING_FOR_REPLY,0,&event.fcp,rcmd);
      return;
      break;
   case QS_END_TRANSFER_WAITING_FOR_REPLY:
      /* Waiting for the response from ftp server that tells us the transfer
       * is complete.
       */
      prelim_reply=false;
      line=event.fcp.LastStatusLine;
      if( line!="" ) {
         code=substr(line,1,3);
         if( isinteger(code) && substr(code,1,1)==1 ) {
            prelim_reply=true;
         }
         
      }
      if( prelim_reply ) {
         // Still waiting for a reply from the ftp server
         status=_ftpQCheckResponse(&event,false,response,false);
         if( status==FTP_WAITING_FOR_REPLY_RC ) {
            _ftpReQ(event.event,event.state,event.start,&event.fcp,rcmd);
            return;
         }
         if( status ) {
            msg="Error with ":+rcmd.cmdargv[0]:+" response.  ":+_ftpGetMessage(status);
            if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
               msg=msg:+"\n\n":+event.fcp.LastStatusLine;
            }
            _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,rcmd,msg);
            return;
         }
      }
      _ftpEnQ(event.event,QS_END,0,&event.fcp,rcmd);
      return;
      break;
   case QS_ERROR:
      // An error occurred with receving data
      _ftpVSProxyCommand(&event.fcp,"ABORTDATA");
      if( upcase(rcmd.cmdargv[0])=="LIST" ) {
         // Just in case (this will usually fail with FILE_NOT_FOUND_RC)
         delete_file(rcmd.dest);
      }
      _message_box(event.info[1],FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return;
      break;
   case QS_ABORT:
      // Event aborted
      /* We might have gotten a message from the VSE proxy
       * already, so check.
       */
      event.fcp.Reply="";
      event.start=0;
      status=_ftpQCheckResponse(&event,true,response,true);
      //_message_box("1 status="status"  response="response);
      if( status ) {
         // Don't care
      }

      status=_ftpCommand(&event.fcp,false,"ABOR");

      // The VSE proxy gives no response to ABORTDATA
      _ftpVSProxyCommand(&event.fcp,"ABORTDATA");

      //_message_box("ABOR sent");
      if( status ) {
         msg="Error sending ABOR.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,rcmd,msg);
         return;
      }
      _ftpEnQ(event.event,QS_ABORT_WAITING_FOR_REPLY,0,&event.fcp,rcmd);
      return;
      break;
   case QS_ABORT_WAITING_FOR_REPLY:
      /* Waiting for the response from ftp server that tells us the status
       * of the abort.
       */
      status=_ftpQCheckResponse(&event,false,response,false);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp,rcmd);
         return;
      }
      if( status ) {
         msg="Error with ABOR response.  ":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,rcmd,msg);
         return;
      }
      if( upcase(rcmd.cmdargv[0])=="LIST" ) {
         // Just in case (this will usually fail with FILE_NOT_FOUND_RC)
         delete_file(rcmd.dest);
      }
      return;
      break;
   case QS_END:
      // Event ends
      break;
   default:
      // Should never get here
      msg="Unknown FTP queue event state: ":+event.state:+" for event ":+event.event;
      _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      break;
   }

   return;
}

static void _ftpQEHandler_SendCmd(ftpQEvent_t *e_p)
{
   ftpQEvent_t event;
   SendCmd_t scmd;

   event= *e_p;   // Make a copy

   scmd= (SendCmd_t)event.info[0];

   switch( event.state ) {
   case QS_BEGIN:
      // Event begins
      if( scmd.pasv ) {
         /* Performing a passive transfer. Issue a "PASV" command so the FTP
          * server will return an address and port we can send to. Client
          * (VSE) initiates connection with FTP server.
          */
         _ftpEnQ(event.event,QS_PASV_BEGIN,0,&event.fcp,scmd);
         return;
      } else {
         /* Active transfer. Issue a "LISTENDATA" command to the VSE proxy
          * to get an available address/port for the FTP server to receive
          * data from
          */
         _ftpEnQ(event.event,QS_PROXY_LISTENDATA_BEGIN,0,&event.fcp,scmd);
         return;
      }
      break;
   case QS_PASV_BEGIN:
      status=_ftpCommand(&event.fcp,false,"PASV");
      if( status ) {
         msg="Error sending PASV.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,scmd,msg);
         return;
      }
      _ftpEnQ(event.event,QS_PASV_WAITING_FOR_REPLY,0,&event.fcp,scmd);
      return;
      break;
   case QS_PASV_WAITING_FOR_REPLY:
      // Waiting for the PASV response from ftp server
      status=_ftpQCheckResponse(&event,false,response,false);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp,scmd);
         return;
      }
      if( status ) {
         msg="Error obtaining PASV response.  ":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
            _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,scmd,msg);
            return;
         }
      }
      /* We are expecting something like:
       *
       * 227 Entering passive mode (192,168,0,1,16,51)
       */
      i=pos('{#0\(:i\,:i\,:i\,:i\,:i\,:i\)}',response,1,'er');
      if( !i ) {
         msg="Could not determine address/port from PASV";
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,scmd,msg);
         return;
      }
      parse substr(response,pos('S0'),pos('0')) with '(' a1 ',' a2 ',' a3 ',' a4 ',' p1 ',' p2 ')';
      temp_host=a1'.'a2'.'a3'.'a4;
      temp_port= (p1<<8)+p2;
      scmd.datahost=temp_host;
      scmd.dataport=temp_port;
      _ftpEnQ(event.event,QS_PROXY_OPENDATA_BEGIN,0,&event.fcp,scmd);
      return;
      break;
   case QS_PROXY_OPENDATA_BEGIN:
      status=_ftpVSProxyCommand(&event.fcp,"OPENDATA",scmd.datahost,scmd.dataport);
      if( status ) {
         msg="Error sending OPENDATA to Visual SlickEdit proxy.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,scmd,msg);
         return;
      }
      _ftpEnQ(event.event,QS_PROXY_OPENDATA_WAITING_FOR_REPLY,0,&event.fcp,scmd);
      return;
      break;
   case QS_PROXY_OPENDATA_WAITING_FOR_REPLY:
      // Waiting for the OPENDATA response from VSE proxy
      status=_ftpQCheckResponse(&event,true,response,true);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp,scmd);
         return;
      }
      if( status ) {
         msg="Error with OPENDATA response from Visual SlickEdit proxy.  ":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,scmd,msg);
         return;
      }
      _ftpEnQ(event.event,QS_TYPE_BEGIN,0,&event.fcp,scmd);
      return;
      break;
   case QS_PROXY_LISTENDATA_BEGIN:
      //say('event.fcp.vsproxy_sock='event.fcp.vsproxy_sock);
      status=_ftpVSProxyCommand(&event.fcp,"LISTENDATA");
      if( status ) {
         msg="Error sending LISTENDATA to Visual SlickEdit proxy.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,scmd,msg);
         return;
      }
      _ftpEnQ(event.event,QS_PROXY_LISTENDATA_WAITING_FOR_REPLY,0,&event.fcp,scmd);
      return;
      break;
   case QS_PROXY_LISTENDATA_WAITING_FOR_REPLY:
      // Waiting for the LISTENDATA response from VSE proxy
      status=_ftpQCheckResponse(&event,true,response,true);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp,scmd);
         return;
      }
      if( status ) {
         msg="Error with LISTENDATA response from Visual SlickEdit proxy.  ":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,scmd,msg);
         return;
      }

      /* Expecting something like:
       *
       * +ok Listening at 192.168.0.1:1025 (4,1)
       */
      i=pos(':i.:i.:i.:i\::i',response,1,'er');
      if( !i ) {
         msg="Could not determine address/port from LISTENDATA response:\n\n":+
             response;
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,scmd,msg);
         return;
      }
      parse substr(response,i) with temp_host ':' temp_port .;
      scmd.datahost=temp_host;
      scmd.dataport=temp_port;
      _ftpEnQ(event.event,QS_PORT_BEGIN,0,&event.fcp,scmd);
      return;
      break;
   case QS_PORT_BEGIN:
      /* Active transfer. Issue a "PORT" command so the FTP server knows
       * where to connect to on the client side (VSE). Firewalls do not
       * like this method because the FTP server initiates the connection
       * to the client (VSE).
       */

      /* Now issue the "PORT" command with the host and port info we got
       * from LISTENDATA, so that the FTP server knows where to connect.
       */
      temp_host=scmd.datahost;
      temp_port=scmd.dataport;
      parse temp_host with a1 '.' a2 '.' a3 '.' a4;
      p1= (int)(temp_port>>8) & 0x000000ff;
      p2= temp_port & 0x000000ff;
      info=a1','a2','a3','a4','p1','p2;
      status=_ftpCommand(&event.fcp,false,"PORT",info);
      if( status ) {
         msg="Error sending PORT command.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,scmd,msg);
         return;
      }
      _ftpEnQ(event.event,QS_PORT_WAITING_FOR_REPLY,0,&event.fcp,scmd);
      return;
      break;
   case QS_PORT_WAITING_FOR_REPLY:
      // Waiting for the PORT response from the ftp server
      status=_ftpQCheckResponse(&event,false,response,false);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp,scmd);
         return;
      }
      if( status ) {
         msg="Error with PORT response.  ":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,scmd,msg);
         return;
      }

      /* Expecting something like:
       *
       * 200 PORT command successful.
       */
      _ftpEnQ(event.event,QS_TYPE_BEGIN,0,&event.fcp,scmd);
      return;
      break;
   case QS_TYPE_BEGIN:
      status=_ftpType(&event.fcp);
      if( status ) {
         msg="Error sending TYPE.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,scmd,msg);
         return;
      }
      _ftpEnQ(event.event,QS_TYPE_WAITING_FOR_REPLY,0,&event.fcp,scmd);
      return;
      break;
   case QS_TYPE_WAITING_FOR_REPLY:
      // Waiting for the TYPE response from ftp server
      status=_ftpQCheckResponse(&event,false,response,false);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp,scmd);
         return;
      }
      if( status ) {
         msg="Error with TYPE response.  ":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,scmd,msg);
         return;
      }
      /* We are expecting something like:
       *
       * 200 Type okay.
       */
      _ftpEnQ(event.event,QS_CMD_BEGIN,0,&event.fcp,scmd);
      return;
      break;
   case QS_CMD_BEGIN:
      status=_ftpCommand(&event.fcp,false,scmd.cmdargv);
      if( status ) {
         msg="Error sending ":+scmd.cmdargv[0]:+" command.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,&rmcd,msg);
         return;
      }
      _ftpEnQ(event.event,QS_CMD_WAITING_FOR_REPLY,0,&event.fcp,scmd);
      return;
      break;
   case QS_CMD_WAITING_FOR_REPLY:
      // Waiting for the command response from ftp server
      status=_ftpQCheckResponse(&event,false,response,false);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp,scmd);
         return;
      }
      if( status ) {
         msg="Error with ":+scmd.cmdargv[0]:+" response.  ":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,scmd,msg);
         return;
      }
      _ftpEnQ(event.event,QS_PROXY_SENDDATA_BEGIN,0,&event.fcp,scmd);
      return;
      break;
   case QS_PROXY_SENDDATA_BEGIN:
      options="";
      if( event.fcp.XferType==FTPXFER_ASCII ) {
         /* Translate newlines into the NVT newline format (\r\n) before
          * sending. This allows the ftp server to correctly translate
          * newlines into its own local newline format.
          */
         options=options:+" +D";
      }
      status=_ftpVSProxyCommand(&event.fcp,"SENDDATA",options,maybe_quote_filename(scmd.src));
      if( status ) {
         msg="Error sending SENDDATA to Visual SlickEdit proxy.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,scmd,msg);
         return;
      }
      _ftpEnQ(event.event,QS_PROXY_SENDDATA_WAITING_FOR_REPLY,0,&event.fcp,scmd);
      return;
      break;
   case QS_PROXY_SENDDATA_WAITING_FOR_REPLY:
      // Waiting for the SENDDATA response from VSE proxy
      status=_ftpQCheckResponse(&event,true,response,true);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp,scmd);
         return;
      }
      if( status ) {
         msg="Error with SENDDATA response from Visual SlickEdit proxy.  ":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,scmd,msg);
         return;
      }

      /* Expecting something like:
       *
       * +ok Sending from file "c:\temp\1110001.4"
       */
      _ftpEnQ(event.event,QS_PROXY_DATASTAT_BEGIN,0,&event.fcp,scmd);
      return;
      break;
   case QS_PROXY_DATASTAT_BEGIN:
      status=_ftpVSProxyCommand(&event.fcp,"DATASTAT");
      if( status ) {
         msg="Error sending DATASTAT to Visual SlickEdit proxy.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,scmd,msg);
         return;
      }
      _ftpEnQ(event.event,QS_PROXY_DATASTAT_WAITING_FOR_REPLY,0,&event.fcp,scmd);
      return;
      break;
   case QS_PROXY_DATASTAT_WAITING_FOR_REPLY:
      // Waiting for the DATASTAT response from VSE proxy
      status=_ftpQCheckResponse(&event,true,response,true);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp,scmd);
         return;
      }
      if( status ) {
         msg="Error with DATASTAT response from Visual SlickEdit proxy.  ":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,scmd,msg);
         return;
      }
      /* Expecting something like:
       *
       * +ok 1024
       * OR
       * +ok Done
       */
      i=lastpos('+ok',response);
      if( !i ) {
         msg="Error with DATASTAT response from Visual SlickEdit proxy:\n\n":+
             response;
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,scmd,msg);
         return;
      }
      parse substr(response,i) with '+ok' status .;
      status=strip(status);
      status=strip(status,'T',"\n");
      status=strip(status,'T',"\r");
      if( lowcase(status)=='done' ) {
         // Transfer complete
         if( scmd.ProgressCB ) {
            line=scmd.cmdargv[0];
            for( i=1;i<scmd.cmdargv._length();++i ) {
               line=line:+" ":+scmd.cmdargv[i];
            }
            (*scmd.ProgressCB)(line,scmd.size,scmd.size);
         }
         _ftpEnQ(event.event,QS_PROXY_CLOSEDATA_BEGIN,0,&event.fcp,scmd);
         return;
      } else if( isinteger(status) ) {
         // Transfer still in progress
         if( scmd.ProgressCB ) {
            line=scmd.cmdargv[0];
            for( i=1;i<scmd.cmdargv._length();++i ) {
               line=line:+" ":+scmd.cmdargv[i];
            }
            //say('line='line'  status='status'  size='scmd.size);
            (*scmd.ProgressCB)(line,(int)status,scmd.size);
         }
         _ftpEnQ(event.event,QS_PROXY_DATASTAT_BEGIN,0,&event.fcp,scmd);
         return;
      } else {
         // No idea what this is
         //_message_box("status=["status"]\n\nresponse="response);
         msg="Error with DATASTAT response from Visual SlickEdit proxy:\n\n":+
             response;
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,scmd,msg);
         return;
      }
      break;
   case QS_PROXY_CLOSEDATA_BEGIN:
      status=_ftpVSProxyCommand(&event.fcp,"CLOSEDATA");
      if( status ) {
         msg="Error sending CLOSEDATA to Visual SlickEdit proxy.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,scmd,msg);
         return;
      }
      _ftpEnQ(event.event,QS_PROXY_CLOSEDATA_WAITING_FOR_REPLY,0,&event.fcp,scmd);
      return;
      break;
   case QS_PROXY_CLOSEDATA_WAITING_FOR_REPLY:
      // Waiting for the CLOSEDATA response from VSE proxy
      status=_ftpQCheckResponse(&event,true,response,true);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp,scmd);
         return;
      }
      if( status ) {
         msg="Error with CLOSEDATA response from Visual SlickEdit proxy.  ":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,scmd,msg);
         return;
      }

      /* Expecting something like:
       *
       * +ok Received 16384 bytes to file "c:\temp\1110001.4"
       */
      _ftpEnQ(event.event,QS_END_TRANSFER_WAITING_FOR_REPLY,0,&event.fcp,scmd);
      return;
      break;
   case QS_END_TRANSFER_WAITING_FOR_REPLY:
      /* Waiting for the response from ftp server that tells us the transfer
       * is complete.
       */
      prelim_reply=false;
      line=event.fcp.LastStatusLine;
      if( line!="" ) {
         code=substr(line,1,3);
         if( isinteger(code) && substr(code,1,1)==1 ) {
            prelim_reply=true;
         }
         
      }
      if( prelim_reply ) {
         status=_ftpQCheckResponse(&event,false,response,false);
         if( status==FTP_WAITING_FOR_REPLY_RC ) {
            _ftpReQ(event.event,event.state,event.start,&event.fcp,scmd);
            return;
         }
         if( status ) {
            msg="Error with ":+scmd.cmdargv[0]:+" response.  ":+_ftpGetMessage(status);
            if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
               msg=msg:+"\n\n":+event.fcp.LastStatusLine;
            }
            _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,scmd,msg);
            return;
         }
      }
      _ftpEnQ(event.event,QS_END,0,&event.fcp,scmd);
      return;
      break;
   case QS_ERROR:
      // An error occurred with receving data
      _ftpVSProxyCommand(&event.fcp,"ABORTDATA");
      _message_box(event.info[1],FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return;
      break;
   case QS_ABORT:
      // Event aborted
      /* We might have gotten a message from the VSE proxy
       * already, so check.
       */
      event.fcp.Reply="";
      event.start=0;
      status=_ftpQCheckResponse(&event,true,response,true);
      //_message_box("1 status="status"  response="response);
      if( status ) {
         // Don't care
      }

      status=_ftpCommand(&event.fcp,false,"ABOR");

      // The VSE proxy gives no response to ABORTDATA
      _ftpVSProxyCommand(&event.fcp,"ABORTDATA");

      //_message_box("ABOR sent");
      if( status ) {
         msg="Error sending ABOR.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,scmd,msg);
         return;
      }
      _ftpEnQ(event.event,QS_ABORT_WAITING_FOR_REPLY,0,&event.fcp,scmd);
      return;
      break;
   case QS_ABORT_WAITING_FOR_REPLY:
      /* Waiting for the response from ftp server that tells us the status
       * of the abort.
       */
      status=_ftpQCheckResponse(&event,false,response,false);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp,scmd);
         return;
      }
      if( status ) {
         msg="Error with ABOR response.  ":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,scmd,msg);
         return;
      }
      return;
      break;
   case QS_END:
      // Event ends
      break;
   default:
      // Should never get here
      msg="Unknown FTP queue event state: ":+event.state:+" for event ":+event.event;
      _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      break;
   }

   return;
}

static void _ftpQEHandler_EndConnProfile(ftpQEvent_t *e_p)
{
   ftpQEvent_t event;

   event= *e_p;   // Make a copy

   // Ending a connection
   switch( event.state ) {
   case QS_BEGIN:
      // Event begins
      status=_ftpCommand(&event.fcp,false,"QUIT");
      #if 1
      if( status ) {
         // Don't really care. We're blasting out of here
         msg="Error sending QUIT to ftp server.  ":+_ftpGetMessage(status);
         _ftpLog(&event.fcp,msg);
         _ftpEnQ(event.event,QS_END,0,&event.fcp);
         return;
      }
      #else
      if( status ) {
         msg="Error sending QUIT to ftp server.  ":+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      #endif
      event.fcp.Timeout=3;   // Don't wait forever for the sign-off response from ftp server
      _ftpEnQ(event.event,QS_WAITING_FOR_REPLY,0,&event.fcp);
      return;
      break;
   case QS_WAITING_FOR_REPLY:
      // Waiting for the QUIT response from ftp server
      status=_ftpQCheckResponse(&event,false,response,false);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp);
         return;
      }
      #if 1
      if( status ) {
         // Don't really care. We're blasting out of here
         msg="Error with QUIT response.  ":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpLog(&event.fcp,msg);
         _ftpEnQ(event.event,QS_END,0,&event.fcp);
         return;
      }
      #else
      if( status ) {
         msg="Error with QUIT response.  ":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,msg);
         return;
      }
      #endif
      _ftpEnQ(event.event,QS_END,0,&event.fcp);
      return;
      break;
   case QS_ERROR:
      // An error occurred with QUIT
      _message_box(event.info[0],FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      // Fall thru to QS_END
   case QS_ABORT:
      // Event aborted - fall thru to QS_END
   case QS_END:
      // Event ends
      if( event.fcp.sock!=INVALID_SOCKET ) {
         vssSocketClose(event.fcp.sock);
         event.fcp.sock=INVALID_SOCKET;
      }
      // Now we must terminate the VSE proxy application
      _ftpEnQ(QE_PROXY_QUIT,QS_BEGIN,0,&event.fcp);
      return;
      break;
   default:
      // Should never get here
      msg="Unknown FTP queue event state: ":+event.state:+" for event ":+event.event;
      _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      break;
   }

   return;
}

static void _ftpQEHandler_ProxyQuit(ftpQEvent_t *e_p)
{
   ftpQEvent_t event;

   event= *e_p;   // Make a copy

   // Kill the VSE proxy application
   switch( event.state ) {
   case QS_BEGIN:
      // Event begins
      if( event.fcp.sock!=INVALID_SOCKET ) {
         vssSocketClose(event.fcp.sock);
         event.fcp.sock=INVALID_SOCKET;
      }
      if( event.fcp.vsproxy_sock!=INVALID_SOCKET ) {
         // This will terminate the VSE proxy application
         _ftpVSProxyCommand(&event.fcp,"QUIT");
         vssSocketClose(event.fcp.vsproxy_sock);
         event.fcp.vsproxy_sock=INVALID_SOCKET;
      }
      return;
      break;
   case QS_END:
      // Event ends
      break;
   default:
      // Should never get here
      msg="Unknown FTP queue event state: ":+event.state:+" for event ":+event.event;
      _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      break;
   }

   return;
}

static void _ftpQEHandler_KeepAlive(ftpQEvent_t *e_p)
{
   ftpQEvent_t event;

   event= *e_p;   // Make a copy

   switch( event.state ) {
   case QS_BEGIN:
      // Event begins
      status=_ftpCommand(&event.fcp,true,"NOOP");
      if( status ) {
         /* Don't care.
          * Find the matching current connection profile and max out the
          * Idle field so that it will not be idle again.
          */
         for( i._makeempty();; ) {
            _ftpCurrentConnections._nextel(i);
            if( i._isempty() ) break;
            if( event.fcp.ProfileName==_ftpCurrentConnections:[i].ProfileName &&
                event.fcp.Instance==_ftpCurrentConnections:[i].Instance ) {
               // Update last idle time
               _ftpCurrentConnections:[i].Idle=MAXINT;
               break;
            }
         }
         return;
      }
      _ftpEnQ(event.event,QS_WAITING_FOR_REPLY,0,&event.fcp);
      return;
      break;
   case QS_WAITING_FOR_REPLY:
      // Waiting for the NOOP response from ftp server
      status=_ftpQCheckResponse(&event,true,response,false);
      if( status==FTP_WAITING_FOR_REPLY_RC ) {
         _ftpReQ(event.event,event.state,event.start,&event.fcp);
         return;
      }
      for( i._makeempty();; ) {
         _ftpCurrentConnections._nextel(i);
         if( i._isempty() ) break;
         if( event.fcp.ProfileName==_ftpCurrentConnections:[i].ProfileName &&
             event.fcp.Instance==_ftpCurrentConnections:[i].Instance ) {
            // Update last idle time
            if( status ) {
               // Max out the Idle field so that it will not be idle again
               _ftpCurrentConnections:[i].Idle=MAXINT;
            } else {
               _ftpCurrentConnections:[i].Idle= (int)_time('B');
            }
            break;
         }
      }
      if( status ) {
         // Don't care
      }
      return;
      break;
   case QS_ABORT:
      // Event aborted
      break;
   case QS_ERROR:
      // An error occurred with keep alive (NOOP)
      break;
   case QS_END:
      // Event ends
      break;
   default:
      // Should never get here
      msg="Unknown FTP queue event state: ":+event.state:+" for event ":+event.event;
      _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      break;
   }

   return;
}

static void _ftpQEHandler_CustomCmd(ftpQEvent_t *e_p)
{
   ftpQEvent_t event;
   CustomCmd_t ccmd;
   
   event= *e_p;   // Make a copy
   
   ccmd= (CustomCmd_t)event.info[0];
   
   switch( event.state ) {
   case QS_BEGIN:
      // Event begins
      status=_ftpCommand(&event.fcp,false,ccmd.cmdargv);
      if( status ) {
         line=ccmd.cmdargv[0];
         for( i=1;i<ccmd.cmdargv._length();++i ) {
            line=line:+" ":+ccmd.cmdargv[i];
         }
         msg='Error sending command "':+line:+'".  ':+_ftpGetMessage(status);
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,ccmd,msg);
         return;
      }
      _ftpEnQ(event.event,QS_WAITING_FOR_REPLY,0,&event.fcp,ccmd);
      return;
      break;
   case QS_WAITING_FOR_REPLY:
      // Waiting for the custom command response from ftp server
      status=_ftpQCheckResponse(&event,false,response,false);
      if( status ) {
         if( status==FTP_WAITING_FOR_REPLY_RC ) {
            _ftpReQ(event.event,event.state,event.start,&event.fcp,ccmd);
            return;
         }
         msg="Error with ":+ccmd.cmdargv[0]:+" response.  ":+_ftpGetMessage(status);
         if( status==FTP_BAD_RESPONSE_RC || status==FTP_CUSTOM_ERROR_RC ) {
            msg=msg:+"\n\n":+event.fcp.LastStatusLine;
         }
         _ftpEnQ(event.event,QS_ERROR,0,&event.fcp,ccmd,msg);
         return;
      }
      // Done
      return;
   case QS_ABORT:
      // Event aborted
      break;
   case QS_ERROR:
      // Error
      _message_box(event.info[1],FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return;
      break;
   case QS_END:
      // Event ends
      break;
   default:
      // Should never get here
      msg="Unknown FTP queue event state: ":+event.state:+" for event ":+event.event;
      _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      break;
   }
   
   return;
}

void _ftpQKeepAliveCheck()
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fcp;

   for( i._makeempty();; ) {
      _ftpCurrentConnections._nextel(i);
      if( i._isempty() ) break;
      fcp_p=_ftpCurrentConnections._indexin(i);
      if( fcp_p->KeepAlive ) {
         /* Check how long the current connection has been idle
          * and keep it alive (if necessary).
          */
         idle= ((int)_time('B') - fcp_p->Idle)/1000;   // Seconds
         if( idle>KEEP_ALIVE_IDLETIME ) {
            if( _ftpQ._length()>0 ) {
               if( _ftpQ[0].fcp.ProfileName==fcp_p->ProfileName &&
                   _ftpQ[0].fcp.Instance==fcp_p->Instance &&
                   _ftpQ[0].event==QE_KEEP_ALIVE ) {
                  /* We are already in a QE_KEEP_ALIVE event for this
                   * connection profile, so don't do another.
                   */
                  continue;
               }
            }
            fcp= *fcp_p;   // Make a copy
            fcp.PostedCB=0;
            _ftpEnQ(QE_KEEP_ALIVE,QS_BEGIN,0,&fcp);
         }
      }
   }

   return;
}

#if 0
// Check for any spontaneous or left-over messages from the ftp server
void _ftpQIdle_CheckResponse()
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fcp;
   ftpQEvent_t event;

   for( i._makeempty();; ) {
      _ftpCurrentConnections._nextel(i);
      if( i._isempty() ) break;
      fcp_p=_ftpCurrentConnections._indexin(i);
      fcp= *fcp_p;   // Make a copy
      fcp.PostedCB=0;   // Paranoid
      // Fake event
      event._makeempty();
      event.event=0;
      event.state=0;
      event.fcp=fcp;
      event.start=0;
      status=_ftpQCheckResponse(&event,false,dummy,false);
      if( status ) {
         // Don't care
      }
   }

   return;
}
#endif

void _ftpQTimerCallback()
{
   ftpQEvent_t event;

   if( _ftpQ._length()<1 ) {
      _ftpQKeepAliveCheck();
      if( _ftpQ._length()<1 ) return;
   }

   event=_ftpQ[0];   // Make a copy
   _ftpDeQ();
   if( _ftpdebug&FTPDEBUG_SAY_EVENTS ) {
      say(__Qevent2name(event.event)'/'__Qstate2name(event.state));
   }

   // Find the matching connection profile and update its idle time
   for( i._makeempty();; ) {
      _ftpCurrentConnections._nextel(i);
      if( i._isempty() ) break;
      if( event.fcp.ProfileName==_ftpCurrentConnections:[i].ProfileName &&
          event.fcp.Instance==_ftpCurrentConnections:[i].Instance ) {
         // Update last idle time
         _ftpCurrentConnections:[i].Idle= (int)_time('B');
         break;
      }
   }

   switch( event.event ) {
   case QE_START_CONN_PROFILE:
      _ftpQEHandler_StartConnProfile(&event);
      break;
   case QE_PROXY_CONNECT:
      _ftpQEHandler_ProxyConnect(&event);
      break;
   case QE_RELAY_CONNECT:
      _ftpQEHandler_RelayConnect(&event);
      break;
   case QE_PROXY_OPEN:
      _ftpQEHandler_ProxyOpen(&event);
      break;
   case QE_OPEN:
      _ftpQEHandler_Open(&event);
      break;
   case QE_USER:
      _ftpQEHandler_User(&event);
      break;
   case QE_PASS:
      _ftpQEHandler_Pass(&event);
      break;
   case QE_CDUP:
      _ftpQEHandler_Cdup(&event);
      break;
   case QE_CWD:
      _ftpQEHandler_Cwd(&event);
      break;
   case QE_PWD:
      _ftpQEHandler_Pwd(&event);
      break;
   case QE_SYST:
      _ftpQEHandler_Syst(&event);
      break;
   case QE_MKD:
      _ftpQEHandler_Mkd(&event);
      break;
   case QE_DELE:
      _ftpQEHandler_Dele(&event);
      break;
   case QE_RMD:
      _ftpQEHandler_Rmd(&event);
      break;
   case QE_RENAME:
      _ftpQEHandler_Rename(&event);
      break;
   case QE_RECV_CMD:
      _ftpQEHandler_RecvCmd(&event);
      break;
   case QE_SEND_CMD:
      _ftpQEHandler_SendCmd(&event);
      break;
   case QE_END_CONN_PROFILE:
      _ftpQEHandler_EndConnProfile(&event);
      break;
   case QE_PROXY_QUIT:
      _ftpQEHandler_ProxyQuit(&event);
      break;
   case QE_KEEP_ALIVE:
      _ftpQEHandler_KeepAlive(&event);
      break;
   case QE_CUSTOM_CMD:
      _ftpQEHandler_CustomCmd(&event);
      break;
   case QE_ERROR:
      _message_box(event.info[0],FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      break;
   default:
      // Should never get here
      msg="Unknown FTP queue event : ":+event.event;
      _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return;
   }

   if( _ftpQ._length()<1 ) {
      // We just went idle
      call_list('_ftpQIdle_');
   }
   
   if( !event.fcp.PostedCB ) return;   // Done

   if( _ftpQ._length()<1 ) {
      // We are idle, so call any callback functions
      (*event.fcp.PostedCB)(&event);
      return;
   } else {
      /* If the processed event was the last event for that particular
       * connection profile, then call its callback function.
       */
      last=true;
      for( i=0;i<_ftpQ._length();++i ) {
         if( _ftpQ[i].fcp.ProfileName==event.fcp.ProfileName &&
             _ftpQ[i].fcp.Instance==event.fcp.Instance ) {
            last=false;
            break;
         }
      }
      if( last ) {
         (*event.fcp.PostedCB)(&event);
         return;
      }
   }

   return;
}

static _str __Qevent2name(int e)
{
   switch( e ) {
   case QE_START_CONN_PROFILE:
      return("QE_START_CONN_PROFILE");
      break;
   case QE_PROXY_CONNECT:
      return("QE_PROXY_CONNECT");
      break;
   case QE_RELAY_CONNECT:
      return("QE_RELAY_CONNECT");
      break;
   case QE_PROXY_OPEN:
      return("QE_PROXY_OPEN");
      break;
   case QE_OPEN:
      return("QE_OPEN");
      break;
   case QE_SYST:
      return("QE_SYST");
      break;
   case QE_USER:
      return("QE_USER");
      break;
   case QE_PASS:
      return("QE_PASS");
      break;
   case QE_CDUP:
      return("QE_CDUP");
      break;
   case QE_CWD:
      return("QE_CWD");
      break;
   case QE_PWD:
      return("QE_PWD");
      break;
   case QE_DELE:
      return("QE_DELE");
      break;
   case QE_RMD:
      return("QE_RMD");
      break;
   case QE_RENAME:
      return("QE_RENAME");
      break;
   case QE_RECV_CMD:
      return("QE_RECV_CMD");
      break;
   case QE_SEND_CMD:
      return("QE_SEND_CMD");
      break;
   case QE_END_CONN_PROFILE:
      return("QE_END_CONN_PROFILE");
      break;
   case QE_PROXY_QUIT:
      return("QE_PROXY_QUIT");
      break;
   case QE_KEEP_ALIVE:
      return("QE_KEEP_ALIVE");
      break;
   case QE_CUSTOM_CMD:
      return("QE_CUSTOM_CMD");
      break;
   case QE_ERROR:
      return("QE_ERROR");
      break;
   }

   return("UNKNOWN=":+e);
}

static _str __Qstate2name(int s)
{
   switch( s ) {
   case QS_BEGIN:
      return("QS_BEGIN");
      break;
   case QS_WAITING_FOR_REPLY:
      return("QS_WAITING_FOR_REPLY");
      break;
   case QS_LISTENING:
      return("QS_LISTENING");
      break;
   case QS_PROMPT:
      return("QS_PROMPT");
      break;
   case QS_PORT_BEGIN:
      return("QS_PORT_BEGIN");
      break;
   case QS_PORT_WAITING_FOR_REPLY:
      return("QS_PORT_WAITING_FOR_REPLY");
      break;
   case QS_PASV_BEGIN:
      return("QS_PASV_BEGIN");
      break;
   case QS_PASV_WAITING_FOR_REPLY:
      return("QS_PASV_WAITING_FOR_REPLY");
      break;
   case QS_PROXY_OPENDATA_BEGIN:
      return("QS_PROXY_OPENDATA_BEGIN");
      break;
   case QS_PROXY_OPENDATA_WAITING_FOR_REPLY:
      return("QS_PROXY_OPENDATA_WAITING_FOR_REPLY");
      break;
   case QS_PROXY_LISTENDATA_BEGIN:
      return("QS_PROXY_LISTENDATA_BEGIN");
      break;
   case QS_PROXY_LISTENDATA_WAITING_FOR_REPLY:
      return("QS_PROXY_LISTENDATA_WAITING_FOR_REPLY");
      break;
   case QS_TYPE_BEGIN:
      return("QS_TYPE_BEGIN");
      break;
   case QS_TYPE_WAITING_FOR_REPLY:
      return("QS_TYPE_WAITING_FOR_REPLY");
      break;
   case QS_CMD_BEGIN:
      return("QS_CMD_BEGIN");
      break;
   case QS_CMD_WAITING_FOR_REPLY:
      return("QS_CMD_WAITING_FOR_REPLY");
      break;
   case QS_PROXY_RECVDATA_BEGIN:
      return("QS_PROXY_RECVDATA_BEGIN");
      break;
   case QS_PROXY_RECVDATA_WAITING_FOR_REPLY:
      return("QS_PROXY_RECVDATA_WAITING_FOR_REPLY");
      break;
   case QS_PROXY_SENDDATA_BEGIN:
      return("QS_PROXY_SENDDATA_BEGIN");
      break;
   case QS_PROXY_SENDDATA_WAITING_FOR_REPLY:
      return("QS_PROXY_SENDDATA_WAITING_FOR_REPLY");
      break;
   case QS_PROXY_DATASTAT_BEGIN:
      return("QS_PROXY_DATASTAT_BEGIN");
      break;
   case QS_PROXY_DATASTAT_WAITING_FOR_REPLY:
      return("QS_PROXY_DATASTAT_WAITING_FOR_REPLY");
      break;
   case QS_PROXY_CLOSEDATA_BEGIN:
      return("QS_PROXY_CLOSEDATA_BEGIN");
      break;
   case QS_PROXY_CLOSEDATA_WAITING_FOR_REPLY:
      return("QS_PROXY_CLOSEDATA_WAITING_FOR_REPLY");
      break;
   case QS_END_TRANSFER_WAITING_FOR_REPLY:
      return("QS_END_TRANSFER_WAITING_FOR_REPLY");
      break;
   case QS_RNFR_WAITING_FOR_REPLY:
      return("QS_RNFR_WAITING_FOR_REPLY");
      break;
   case QS_RNTO_WAITING_FOR_REPLY:
      return("QS_RNTO_WAITING_FOR_REPLY");
      break;
   case QS_ERROR:
      return("QS_ERROR");
      break;
   case QS_ABORT:
      return("QS_ABORT");
      break;
   case QS_ABORT_WAITING_FOR_REPLY:
      return("QS_ABORT_WAITING_FOR_REPLY");
      break;
   case QS_END:
      return("QS_END");
      break;
   }

   return("UNKNOWN=":+s);
}

static _str _MaybeCreateUserIniFile()
{
   status=0;
   filenopath=FTP_USER_INI_FILENAME;
   filename=_config_path():+filenopath;
   global_filename=slick_path_search(filenopath);
   if( global_filename!="" && file_match("-p "maybe_quote_filename(filename),1)=="" &&
       !file_eq(global_filename,filename) ) {
      // Make copy of global configuration file.
      copy_file(global_filename,filename);
   } else if( file_match("-p "maybe_quote_filename(filename),1)=="" ) {
      // Doesn't exist so create it
      orig_view_id=_create_temp_view(temp_view_id);
      if( orig_view_id=="" ) {
         // Don't display a message because _create_temp_view() already did it
         return("");
      }

      _delete_line();

      // Insert default common options
      insert_line("[options]");
      _insert_text("\n":+FTP_DEFAULT_OPTIONS);
      insert_line("");   // Separate profile sections w/ blank line

      // Insert MicroEdge ftp site info
      insert_line("[profile-":+FTP_MICROEDGE_PROFILE_NAME:+"]");
      /* host=
       * userid=
       * password=
       * anonymous=
       * savepassword=
       * defremotehostdir=
       * deflocaldir=
       * remotefilter=
       * localfilter=
       * xfertype=
       * port=
       * timeout=
       * keepalive=
       * usefw=
       * uploadcase=
       */
      _insert_text("\n":+FTP_MICROEDGE_PROFILE_DATA);
      insert_line("");   // Separate profile sections w/ blank line

      p_buf_name=_config_path():+filenopath;
      status=_save_file('+o');
      if( status ) {
         filename="";
      }
      activate_view(orig_view_id);
      _delete_temp_view(temp_view_id);
   }

   if( status ) {
      return("");
   }
   return(filename);
}

void _ftpInitConnProfile(ftpConnProfile_t &fcp)
{
   ftpOptions_t fo;

   fcp.ProfileName="";
   fcp.Instance=0;
   fcp.Host="";
   fcp.UserID="";
   fcp.Password="";
   fcp.Anonymous=false;
   fcp.SavePassword=true;
   fcp.DefRemoteHostDir="";
   fcp.DefLocalDir="";
   fcp.XferType=FTPXFER_BINARY;
   fcp.Port=FTPDEF_PORT;
   fcp.Timeout=FTPDEF_TIMEOUT;
   fcp.KeepAlive=false;
   fcp.UploadCase=FTPFILECASE_PRESERVE;
   fcp.ResolveLinks=false;
   fcp.UseFW=false;
   fcp.Options._makeempty();
   fcp.LastStatusLine="";
   fcp.sock=INVALID_SOCKET;
   fcp.vsproxy_sock=INVALID_SOCKET;
   fcp.VSProxy=true;
   fcp.LogBufName="";
   fcp.RemoteDir._makeempty();
   fcp.LocalCWD="";
   fcp.RemoteCWD="";
   fcp.CwdHist._makeempty();
   fcp.LocalFileFilter=ALLFILES_RE;
   fcp.RemoteFileFilter=FTP_ALLFILES_RE;
   fcp.RemoteRoot="";
   fcp.LocalRoot="";
   fcp.Reply="";
   fcp.Idle=MAXINT;
   fcp.System=0;
   fcp.PostedCB=0;
   if( !_ftpGetOptions(fo) ) {
      if( fcp.Anonymous ) {
         fcp.UserID=FTPDEF_ANONYMOUS_USERID;
         fcp.Password=fo.email;
      }
      fcp.DefLocalDir=fo.deflocaldir;
      fcp.Port=fo.port;
      fcp.Timeout=fo.timeout;
      fcp.KeepAlive=fo.keepalive;
      fcp.UploadCase=fo.uploadcase;
      fcp.ResolveLinks=fo.resolvelinks;
      fcp.UseFW=fo.fwenable;
      fcp.Options=fo;
   }

   return;
}

/* Used to quickly check if there is a profile by the name ProfileName in the
 * user ftp ini file.
 */
boolean _ftpIsConnProfile(_str ProfileName)
{
   status=_open_temp_view(_ftpUserIniFilename(),temp_view_id,orig_view_id);
   if( status ) {
      _message_box('Error opening profile file "':+_ftpUserIniFilename():+'".  ':+get_message(status),FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return(false);
   }
   p_view_id=temp_view_id;
   top();
   status=search('^\[profile-':+ProfileName:+'\][ \t]@$','er@');
   _delete_temp_view(temp_view_id);
   p_view_id=orig_view_id;   // Just in case
   if( !status ) {
      // Found a match
      return(true);
   }

   return(false);
}

int _ftpOpenConnProfile(_str ProfileName,ftpConnProfile_t *fcp_p)
{
   (*fcp_p)._makeempty();
   _ftpInitConnProfile(*fcp_p);

   orig_view_id=p_view_id;
   status=_ini_get_section(_ftpUserIniFilename(),"profile-":+strip(ProfileName),temp_view_id);
   if( status ) {
      _message_box('Error opening profile "':+ProfileName:+'".  ':+get_message(status),FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return(status);
   }
   p_view_id=temp_view_id;
   fcp_p->ProfileName=ProfileName;
   top();up();
   for( ;; ) {
      if( down() ) break;
      get_line(line);
      if( line=='' ) continue;
      parse line with varble '=' val;
      varble=strip(varble);
      val=strip(val);
      switch( varble ) {
      case 'host':
         fcp_p->Host=val;
         break;
      case 'userid':
         fcp_p->UserID=val;
         break;
      case 'password':
         fcp_p->Password=val;
         break;
      case 'anonymous':
         fcp_p->Anonymous= (isinteger(val) && val);
         break;
      case 'savepassword':
         fcp_p->SavePassword= (isinteger(val) && val);
         break;
      case 'defremotehostdir':
         fcp_p->DefRemoteHostDir=val;
         break;
      case 'deflocaldir':
         fcp_p->DefLocalDir=val;
         break;
      case 'remotefilter':
         fcp_p->RemoteFileFilter=val;
         break;
      case 'localfilter':
         fcp_p->LocalFileFilter=val;
         break;
      case 'remoteroot':
         fcp_p->RemoteRoot=val;
         break;
      case 'localroot':
         fcp_p->LocalRoot=val;
         break;
      case 'xfertype':
         if( !isinteger(val) || val<FTPXFER_ASCII || val>FTPXFER_BINARY ) {
            val=FTPXFER_BINARY;
         }
         fcp_p->XferType= (int)val;
      case 'port':
         if( isinteger(val) && val>0 && val<=65535 ) {
            fcp_p->Port= (int)val;
         }
         break;
      case 'timeout':
         if( isinteger(val) ) {
            fcp_p->Timeout= (int)val;
         }
         break;
      case 'keepalive':
         fcp_p->KeepAlive= (isinteger(val) && val);
         break;
      case 'uploadcase':
         if( isinteger(val) && val>=FTPFILECASE_PRESERVE && val<=FTPFILECASE_UPPER ) {
            fcp_p->UploadCase= (int)val;
         }
         break;
      case 'resolvelinks':
         fcp_p->ResolveLinks= (isinteger(val) && val);
         break;
      case 'usefw':
         fcp_p->UseFW= (isinteger(val) && val);
         break;
      default:
         // Should never get here, but will allow it
         break;
      }
   }
   _delete_temp_view(temp_view_id);
   p_view_id=orig_view_id;   // Just in case

   if( fcp_p->Host=='' ) {
      _message_box('Missing host name for profile "':+fcp_p->ProfileName:+'"',FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return(1);
   }

   return(0);
}

int _ftpSaveConnProfile(ftpConnProfile_t *fcp_p)
{
   orig_view_id=_create_temp_view(temp_view_id)
   if( orig_view_id=="" ) {
      // Don't need to display error because _create_temp_view() already did
      return(1);
   }
   _delete_line();
   insert_line("host=":+fcp_p->Host);
   insert_line("userid=":+fcp_p->UserID);
   insert_line("password=":+fcp_p->Password);   // Password is already encrypted
   insert_line("anonymous=":+fcp_p->Anonymous);
   insert_line("savepassword=":+fcp_p->SavePassword);
   insert_line("defremotehostdir=":+fcp_p->DefRemoteHostDir);
   insert_line("deflocaldir=":+fcp_p->DefLocalDir);
   insert_line("remotefilter=":+fcp_p->RemoteFileFilter);
   insert_line("localfilter=":+fcp_p->LocalFileFilter);
   insert_line("remoteroot=":+fcp_p->RemoteRoot);
   insert_line("localroot=":+fcp_p->LocalRoot);
   insert_line("xfertype=":+fcp_p->XferType);
   insert_line("port=":+fcp_p->Port);
   insert_line("timeout=":+fcp_p->Timeout);
   insert_line("usefw=":+fcp_p->UseFW);
   insert_line("keepalive=":+fcp_p->KeepAlive);
   insert_line("uploadcase=":+fcp_p->UploadCase);
   insert_line("resolvelinks=":+fcp_p->ResolveLinks);
   insert_line("");   // Separate profile sections w/ blank line

   p_view_id=orig_view_id;
   status=_ini_put_section(_ftpUserIniFilename(),"profile-":+strip(fcp_p->ProfileName),temp_view_id);
   p_view_id=orig_view_id;   // Just in case

   return(status);
}

int _ftpDeleteConnProfile(_str ProfileName)
{
   status=_ini_delete_section(_ftpUserIniFilename(),"profile-":+ProfileName);

   return(status);
}

/* Note that the most recent entries are at the end of the array.
 * This makes it easier to add new entries.
 */
int def_maxcombohist;   // Use this to limit the number of entries
int _ftpSaveCwdHist(_str ProfileName,_str CwdHist[])
{
   orig_view_id=p_view_id;
   status=_ini_get_section(_ftpUserIniFilename(),'profile-':+strip(ProfileName),temp_view_id);
   if( status ) return(status);
   p_view_id=temp_view_id;
   
   // Get rid of old history
   top();
   search('^cwdhist:i @=?@\n','@ir','',dummy);
   
   /* Insert the new history.
    * Remember that the most recent entries are at the end, so reverse.
    */
   bottom();
   len=CwdHist._length();
   
   // Upper limit of def_maxcombohist
   first=0;
   if( len>def_maxcombohist ) {
      first=0+(len-def_maxcombohist);
   }
   
   for( i=len-1;i>=first;--i ) {
      cwd=CwdHist[i];
      insert_line('cwdhist':+(len-i-1):+'=':+cwd);
   }
   // _ini_put_section() takes care of deleting the view
   _ini_put_section(_ftpUserIniFilename(),"profile-":+strip(ProfileName),temp_view_id);
   //_delete_temp_view(temp_view_id);
   p_view_id=orig_view_id;
   
   return(0);
}

/* Note that the most recent entries are at the end of the array.
 * This makes it easier to add new entries.
 */
int _ftpGetCwdHist(_str ProfileName,_str (&CwdHist)[])
{
   _str templist[];   // Use a temporary list so we can reverse the order easily
   
   templist._makeempty();
   CwdHist._makeempty();
   
   orig_view_id=p_view_id;
   status=_ini_get_section(_ftpUserIniFilename(),'profile-':+strip(ProfileName),temp_view_id);
   if( status ) return(status);
   p_view_id=temp_view_id;
   
   top();
   status=search('^cwdhist:i','@ir');
   while( !status ) {
      get_line(line);
      parse line with . '=' cwd;
      cwd=strip(cwd);
      if( cwd!="" ) {
         templist[templist._length()]=cwd;
      }
      
      // Upper limit of def_maxcombohist
      if( templist._length() >= def_maxcombohist ) break;
      
      status=repeat_search();
   }
   
   // Now reverse the order because the most recent entries were last
   for( i=templist._length()-1;i>=0;--i ) {
      CwdHist[CwdHist._length()]=templist[i];
   }
   
   return(0);
}

/* Note that the most recent entries are at the end of the array.
 * This makes it easier to add new entries.
 */
void _ftpAddCwdHist(_str (&CwdHist)[],_str Cwd)
{
   if( Cwd=="" ) return;
   
   // Upper limit of def_maxcombohist
   if( CwdHist._length() >= def_maxcombohist ) {
      n=def_maxcombohist-CwdHist._length()+1;
      CwdHist._deleteel(0,n);
   }
   
   // Delete duplicates
   for( i=0;i<CwdHist._length();++i ) {
      if( CwdHist[i]==Cwd ) {
         CwdHist._deleteel(i);
      }
   }
   
   // Add the new entry
   CwdHist[CwdHist._length()]=Cwd;
   
   return;
}

/* Function Name : _ftpHostNameToProfileName(_str Host, _str (&ProfileName)[])
 *
 * Parameters:
 *   Host        - Name of the host to match
 *   ProfileName - Array of profile names matching Host.
 *
 * Description:
 *   Attempts to find FTP connection profile name(s) that match the host name
 *   passed in. The result is an array of strings which represent a list of
 *   all matching FTP connection profile names.
 *
 * Returns:
 *   Returns 0 if match(es) are found. Otherwise non-zero is returned.
 */
int _ftpHostNameToProfileName(_str Host,_str (&ProfileName)[])
{
   _str temparr[];

   status=_open_temp_view(_ftpUserIniFilename(),temp_view_id,orig_view_id);
   if( status ) {
      _message_box('Cannot find configuration file "':+FTP_USER_INI_FILENAME:+'"',FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return(1);
   }
   top();
   temparr._makeempty();
   status=search('^\[','er@');
   while( !status ) {
      get_line(line);
      parse line with '[profile-' profilename ']';
      profilename=strip(profilename);
      if( profilename=='' ) {
         // This should never happen
         status=repeat_search();
         continue;
      }
      for( ;; ) {
         if( down() ) break;
         get_line(line);
         if( substr(line,1,1)=='[' ) {
            up();   /* Get off the section line so the repeat_search() does
                     * not skip over it.
                     */
            break;   // We hit the next section unexpectedly
         }
         parse line with varble '=' val;
         varble=strip(varble);
         val=strip(val);
         if( varble=="host" ) {
            if( val==Host ) {
               temparr[temparr._length()]=profilename;
            }
            break;
         }
      }
      status=repeat_search();
   }
   _delete_temp_view(temp_view_id);
   p_view_id=orig_view_id;

   if( temparr._length() ) {
      ProfileName=temparr;
      return(0);
   }

   return(1);   // No match for Host
}

void _ftpInitOptions(ftpOptions_t &fo)
{
   fo.email=FTPDEF_ANONYMOUS_PASS;
   fo.deflocaldir="";
   fo.put=FTPOPT_EXPLICIT_PUT;
   fo.resolvelinks=false;
   fo.timeout=FTPDEF_TIMEOUT;
   fo.port=FTPDEF_PORT;
   fo.keepalive=false
   fo.uploadcase=FTPFILECASE_PRESERVE;
   fo.fwhost="";
   fo.fwport=FTPDEF_PORT;
   fo.fwuserid="";
   fo.fwpassword="";
   fo.fwtype=FTPOPT_FWTYPE_USERAT;
   fo.fwpasv=false;
   fo.fwenable=false;

   return;
}

int _ftpGetOptions(ftpOptions_t &fo)
{
   status=_open_temp_view(_ftpUserIniFilename(),temp_view_id,orig_view_id);
   p_view_id=temp_view_id;
   if( status ) {
      _message_box('Cannot find configuration file "':+_ftpUserIniFilename():+'"',FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return(1);
   }
   top();
   status=search('^\[options]','er@');
   if( status ) {
      // Did not find an [options] section, so setup some default options
      _ftpInitOptions(fo);

      top();up();
      // Insert default common options
      insert_line("[options]");
      _insert_text("\n":+FTP_DEFAULT_OPTIONS);
      insert_line("");   // Separate profile sections w/ blank line
   } else {
      _ftpInitOptions(fo);   // This will catch any that were not in the ini file
      for( ;; ) {
         if( down() ) break;
         get_line(line);
         if( line=='' ) continue;
         if( substr(line,1,1)=='[' ) break;   // Start of next section
         parse line with varble '=' val;
         varble=strip(varble);
         val=strip(val);
         switch( varble ) {
         case 'email':
            fo.email=val;
            break;
         case 'deflocaldir':
            fo.deflocaldir=val;
            break;
         case 'put':
            fo.put= (int)val;
            break;
         case 'resolvelinks':
            fo.resolvelinks= (isinteger(val) && val);
            break;
         case 'timeout':
            if( !isinteger(val) || val<=0 ) {
               val=FTPDEF_TIMEOUT;
            }
            fo.timeout= (int)val;
            break;
         case 'port':
            if( !isinteger(val) || val<=0 || val>65535 ) {
               val=FTPDEF_PORT;
            }
            fo.port= (int)val;
            break;
         case 'keepalive':
            fo.keepalive= (isinteger(val) && val);
            break;
         case 'uploadcase':
            if( !isinteger(val) || val<FTPFILECASE_PRESERVE || val>FTPFILECASE_UPPER ) {
               val=FTPFILECASE_PRESERVE;
            }
            fo.uploadcase= (int)val;
            break;
         case 'fwhost':
            fo.fwhost=val;
            break;
         case 'fwport':
            if( !isinteger(val) || val<=0 || val>65535 ) {
               val=FTPDEF_PORT;
            }
            fo.fwport= (int) val;
            break;
         case 'fwuserid':
            fo.fwuserid=val;
            break;
         case 'fwpassword':
            fo.fwpassword=val;
            break;
         case 'fwtype':
            if( !isinteger(val) || val<FTPOPT_FWTYPE_USERAT || val>FTPOPT_FWTYPE_ROUTER ) {
               val=FTPOPT_FWTYPE_USERAT;
            }
            fo.fwtype= (int)val;
            break;
         case 'fwpasv':
            fo.fwpasv= (isinteger(val) && val);
            break;
         case 'fwenable':
            fo.fwenable=(isinteger(val) && val);
         default:
            // Should never get here, but will allow it
            break;
         }
      }
   }
   _delete_temp_view(temp_view_id);
   p_view_id=orig_view_id;

   return(0);
}

int _ftpSaveOptions(ftpOptions_t *fo_p)
{
   orig_view_id=_create_temp_view(temp_view_id)
   if( orig_view_id=="" ) {
      // Don't need to display error because _create_temp_view() already did
      return(1);
   }
   _delete_line();
   insert_line("email=":+fo_p->email);
   insert_line("deflocaldir=":+fo_p->deflocaldir);
   insert_line("put=":+fo_p->put);
   val= (int)fo_p->resolvelinks;
   insert_line("resolvelinks=":+val);
   insert_line("timeout=":+fo_p->timeout);
   insert_line("port=":+fo_p->port);
   val= (int)fo_p->keepalive;
   insert_line("keepalive=":+val);
   insert_line("uploadcase=":+fo_p->uploadcase);
   insert_line("fwhost=":+fo_p->fwhost);
   insert_line("fwport=":+fo_p->fwport);
   insert_line("fwuserid=":+fo_p->fwuserid);
   insert_line("fwpassword=":+fo_p->fwpassword);   // Already encrypted
   insert_line("fwtype=":+fo_p->fwtype);
   val= (int)fo_p->fwpasv;
   insert_line("fwpasv=":+val);
   val= (int)fo_p->fwenable;
   insert_line("fwenable=":+val);
   insert_line("");   // Separate profile sections w/ blank line

   p_view_id=orig_view_id;
   status=_ini_put_section(_ftpUserIniFilename(),"options",temp_view_id);
   p_view_id=orig_view_id;   // Just in case

   return(status);
}

/* Function Name : _ftpParseAddress(_str address,_str &host,_str &port,_str &path)
 *
 * Parameters:
 *   address - a string of the form [ftp://] + hostname + [:port] + path
 *   host    - accepts the parsed hostname
 *   port    - accepts the parsed port (can be a port number or named service)
 *   path    - accepts the parsed path
 *
 * Description:
 *   Parses the address string into host, port, and path.
 *
 * Returns:
 *   Returns 0 if successful. Non-zero is returned for a badly formed address.
 */
int _ftpParseAddress(_str address,_str &host,_str &port,_str &path)
{
   parse address with '(ftp\://|)','r' rest;
   parse rest with host '/' +0 path;
   if( host=='' ) {
      return(FTP_INVALID_HOST_RC)
   }
   if( path=='' ) {
      path='.';
   }
   parse host with host ':' port;

   return(0);
}

/* Function Name : _ftpGetMessage(int retcode)
 *
 * Parameters:
 *   retcode - return code from either a macro call, vssock.dll, or the editor
 *
 * Description:
 *   Translates a return code into a message string.
 *
 * Returns:
 *   String representation of the return code retcode.
 */
_str _ftpGetMessage(int retcode)
{
   if( retcode<0 ) {
      if( retcode<=SOCK_FIRST_RC && retcode>=SOCK_LAST_RC ) {
         return(vssErrorMsg(retcode));
      } else {
         return(get_message(retcode));
      }
   } else if( retcode>0 ) {
      switch( retcode ) {
      case FTP_INVALID_HOST_RC:
         return("Invalid host name");
      case FTP_GENERAL_ERROR_RC:
         return("General error");
      case FTP_BAD_RESPONSE_RC:
         return("Bad response from FTP server");
      case FTP_BAD_SOCKET_RC:
         return("Bad socket");
      case FTP_CONNECTION_DEAD_RC:
         return("Connection lost");
      case FTP_ERROR_CREATING_TEMP_FILE_RC:
         return("Error creating temporary file");
      case FTP_ERROR_CREATING_LOCAL_FILE_RC:
         return("Error creating local file");
      case FTP_CANNOT_FIND_PROXY_RC:
         return("Cannot find Visual SlickEdit proxy");
      case FTP_ERROR_RUNNING_PROXY_RC:
         return("Error running Visual SlickEdit proxy");
      case FTP_CUSTOM_ERROR_RC:
         return("");
      default:
         return("Unknown error");
      }
   }

   return("");   // retcode==0
}

void _ftpError(int retcode)
{
   _message_box(_ftpGetMessage(retcode),FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);

   return;
}

#define FTPLOG_BUFNAME_PREFIX ".ftplog"
_str _ftpMkLogName()
{
   prefix=FTPLOG_BUFNAME_PREFIX;

   maxtail=1000;
   pad_len=length(maxtail-1);   // e.g. maxtail=10 gives us 0-9
   for( i=0;i<maxtail;++i ) {
      name=prefix:+substr("",1,pad_len-length(i),"0"):+i;
      if( buf_match(name,1,'HEB')=="" ) {
         return(name);
      }
   }

   return("");   // There are a lot of log buffers if this happens
}

/* Find buffer with p_DocumentName matching exactly document_name.
 * p_buf_name of the matching document is returned on success, otherwise
 * "" is returned.
 */
_str _ftpDocMatch(_str document_name)
{
   buf_name="";
   orig_buf_id=_mdi.p_child.p_buf_id;
   for(;;) {
      if( !(_mdi.p_child.p_buf_flags&HIDE_BUFFER) && _mdi.p_child.p_DocumentName:==document_name ) {
         // Found a match
         buf_name=_mdi.p_child.p_buf_name;
         break;
      }
      _mdi.p_child._next_buffer('HR');
      if( _mdi.p_child.p_buf_id==orig_buf_id ) break;
   }
   _mdi.p_child.p_buf_id=orig_buf_id;
   
   return(buf_name);
}

_str _ftpCreateLogBuffer()
{
   status=0;

   log_name=_ftpMkLogName();
   if( log_name=="" ) {
      _message_box("Unable to create log",FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return("");
   }

   orig_view_id=p_view_id;
   p_view_id=HIDDEN_VIEW_ID;
   status=load_files("+c +t");
   if( status ) {
      p_view_id=orig_view_id;
      _message_box("Unable to create log.  ":+get_message(status),FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return("");
   }
   //log_view_id=p_view_id;
   p_buf_name=log_name;_delete_line();
   p_buf_flags=THROW_AWAY_CHANGES|HIDE_BUFFER|KEEP_ON_QUIT;
   p_readonly_mode=true;
   p_view_id=orig_view_id;

   return(log_name);
}

void _ftpDeleteLogBuffer(ftpConnProfile_t *fcp_p)
{
   log_buf_name=fcp_p->LogBufName;
   if( log_buf_name=="" ) return;
   orig_view_id=p_view_id;
   p_view_id=HIDDEN_VIEW_ID;
   if( !find_view(log_buf_name) ) {
      _delete_buffer();_quit_view();
   }
   p_view_id=orig_view_id;
   fcp_p->LogBufName="";

   return;
}

#define FCPDATAP  _ctl_profile_sstab.p_user
#define FCPFLAGS  _ctl_ok.p_user
#define FCPUSERID _ctl_user.p_user
#define FCPORIG_PROFILENAME _ctl_profile.p_user

_control _ctl_user;
_control _ctl_pass;

#define FCPTAB_GENERAL    (0)
#define FCPTAB_ADVANCED (1)

defeventtab _ftpCreateProfile_form;
static int oncreateGeneral()
{
   ftpConnProfile_t *fcpdata_p;

   fcpdata_p=FCPDATAP;

   _ctl_profile.p_text=fcpdata_p->ProfileName;
   FCPORIG_PROFILENAME=_ctl_profile.p_text;

   _ctl_host.p_text=fcpdata_p->Host;

   _ctl_anonymous.p_value=(int)fcpdata_p->Anonymous;

   if( !_ctl_anonymous.p_value ) _ctl_pass.p_Password=true;

   _ctl_user.p_text=fcpdata_p->UserID;

   if( fcpdata_p->Password!="" ) {
      if( _ctl_pass.p_Password ) {
         pass=fcpdata_p->Password;
         status=vssDecrypt(fcpdata_p->Password,plain);
         if( !status ) {
            _ctl_pass.p_text=plain;
            plain="";
         } else {
            _ctl_pass.p_text="";
            _message_box("Error retrieving password",FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
         }
      } else {
         _ctl_pass.p_text=fcpdata_p->Password;
      }
   } else {
      _ctl_pass.p_text="";
   }

   _ctl_remotedir.p_text=fcpdata_p->DefRemoteHostDir;

   _ctl_localdir.p_text=fcpdata_p->DefLocalDir;

   _ctl_remotefilter.p_text=fcpdata_p->RemoteFileFilter;

   _ctl_localfilter.p_text=fcpdata_p->LocalFileFilter;

   _ctl_xfer_ascii.p_value=_ctl_xfer_binary.p_value=0;
   type=fcpdata_p->XferType;
   if( !isinteger(type) || type<FTPXFER_ASCII || type>FTPXFER_BINARY ) {
      type=FTPXFER_BINARY;
   }
   switch( type ) {
   case FTPXFER_ASCII:
      _ctl_xfer_ascii.p_value=1;
      break;
   case FTPXFER_BINARY:
      _ctl_xfer_binary.p_value=1;
      break;
   }

   _ctl_savepass.p_value=(int)fcpdata_p->SavePassword;

   FCPUSERID="";
   FCPPASS="";

   return(0);
}

static int oncreateAdvanced()
{
   ftpConnProfile_t *fcpdata_p;

   fcpdata_p=FCPDATAP;

   _ctl_timeout.p_text=fcpdata_p->Timeout;

   port=fcpdata_p->Port;
   if( !isinteger(port) || port<=0 || port>65535 ) {
      // This should never happen
      port=FTPDEF_PORT;
   }
   _ctl_port.p_text=fcpdata_p->Port;

   _ctl_keepalive.p_value= (int)fcpdata_p->KeepAlive;

   _ctl_use_fw.p_value= (int)fcpdata_p->UseFW;
   _ctl_use_fw.p_enabled=fcpdata_p->Options.fwenable;

   _ctl_uploadcase_preserve.p_value=_ctl_uploadcase_lower.p_value=_ctl_uploadcase_upper.p_value=0;
   option=fcpdata_p->UploadCase;
   if( !isinteger(option) || option<FTPFILECASE_PRESERVE || option>FTPFILECASE_UPPER ) {
      option=FTPFILECASE_PRESERVE;
   }
   switch( option ) {
   case FTPFILECASE_PRESERVE:
      _ctl_uploadcase_preserve.p_value=1;
      break;
   case FTPFILECASE_LOWER:
      _ctl_uploadcase_lower.p_value=1;
      break;
   case FTPFILECASE_UPPER:
      _ctl_uploadcase_upper.p_value=1;
      break;
   }

   _ctl_resolve_links.p_value= (int)fcpdata_p->ResolveLinks;
   
   _ctl_remote_root.p_text=fcpdata_p->RemoteRoot;
   _ctl_local_root.p_text=fcpdata_p->LocalRoot;

   return(0);
}

void _ctl_ok.on_create()
{
   FCPDATAP=0;
   if( arg()>0 ) {
      FCPDATAP= (ftpConnProfile_t *)arg(1);
   }

   FCPFLAGS=0;
   if( arg()>1 ) {
      FCPFLAGS= (isinteger(arg(2)))?(arg(2)):(0);
   }

   // Login dialog OR profile creation?
   if( FCPFLAGS&FCPFLAG_LOGIN ) {
      caption='Login';
   } else {
      caption='Create FTP Profile';
   }
   p_active_form.p_caption=caption;

   // Allow user to save profile settings?
   if( FCPFLAGS&FCPFLAG_SAVEPROFILEOFF ) {
      _ctl_saveprofile.p_value=0;
   } else {
      _ctl_saveprofile.p_value=1;
   }

   // Hide the "Save profile" checkbox?
   if( FCPFLAGS&FCPFLAG_HIDESAVEPROFILE ) {
      _ctl_saveprofile.p_visible=false;
   } else {
      _ctl_saveprofile.p_visible=true;
   }
   
   // Disable the "Profile name" text box?
   if( FCPFLAGS&FCPFLAG_DISABLEPROFILE ) {
      _ctl_profile.p_enabled=false;
   }

   if( oncreateGeneral() ) {
      p_active_form._delete_window(1);
      return;
   }
   if( oncreateAdvanced() ) {
      p_active_form._delete_window(1);
      return;
   }

   return;
}

_ftpCreateProfile_form.on_load()
{
   if( _ctl_profile.p_text=="" ) {
      p_window_id=_ctl_profile;
      _set_focus();
   } else if( _ctl_host.p_text=="" ) {
      p_window_id=_ctl_host;
      _set_focus();
   } else if( _ctl_user.p_text!="" ) {
      p_window_id=_ctl_pass;
      _set_focus();
   } else {
      p_window_id=_ctl_user;
      _set_focus();
   }
}

static int GetGeneralOptions(ftpConnProfile_t *fcp_p)
{
   profile=_ctl_profile.p_text;
   if( profile=="" ) {
      _ctl_profile_sstab.p_ActiveTab=FCPTAB_GENERAL;
      p_window_id=_ctl_profile;
      _set_focus();
      _message_box('Must have a profile name!',FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return(1);
      //profile=strip(_ctl_host.p_text);
   }

   host=strip(_ctl_host.p_text);
   if( host=="" ) {
      _ctl_profile_sstab.p_ActiveTab=FCPTAB_GENERAL;
      p_window_id=_ctl_host;
      _set_focus();
      _message_box('Must have a host!',FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return(1);
   }

   user=strip(_ctl_user.p_text);
   if( user=='' ) {
      _ctl_profile_sstab.p_ActiveTab=FCPTAB_GENERAL;
      p_window_id=_ctl_user;
      _set_focus();
      _message_box('Must have a user ID!',FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return(1);
   }

   pass=_ctl_pass.p_text;
   if( _ctl_pass.p_Password ) {
      // Encrypt it
      if( !vssEncrypt(pass,cipher) ) {
         pass=cipher;
      } else {
         _message_box("Error saving password",FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
         pass="";
      }
   }

   remotedir=_ctl_remotedir.p_text;

   localdir=_ctl_localdir.p_text;

   remotefilter=_ctl_remotefilter.p_text;

   localfilter=_ctl_localfilter.p_text;

   if( _ctl_xfer_ascii.p_value ) {
      xfertype=FTPXFER_ASCII;
   } else if( _ctl_xfer_binary.p_value ) {
      xfertype=FTPXFER_BINARY;
   } else {
      // This should never happen
      _ctl_profile_sstab.p_ActiveTab=FCPTAB_GENERAL;
      p_window_id=_ctl_user;
      _set_focus();
      _message_box("Must choose a transfer type!",FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return(1);
   }

   anonymous=_ctl_anonymous.p_value;

   savepass=_ctl_savepass.p_value;

   fcp_p->ProfileName=profile;
   fcp_p->Host=host;
   fcp_p->UserID=user;
   fcp_p->Password=pass;
   fcp_p->Anonymous=anonymous;
   fcp_p->SavePassword=savepass;
   fcp_p->DefRemoteHostDir=remotedir;
   fcp_p->DefLocalDir=localdir;
   fcp_p->RemoteFileFilter=remotefilter;
   fcp_p->LocalFileFilter=localfilter;
   fcp_p->XferType=xfertype;

   return(0);
}

static int onokGeneral()
{
   int status;

   status=GetGeneralOptions(FCPDATAP);

   return(status);
}

static int GetAdvancedOptions(ftpConnProfile_t *fcp_p)
{
   timeout=_ctl_timeout.p_text;
   if( !isinteger(timeout) || timeout<1 ) {
      _ctl_profile_sstab.p_ActiveTab=FCPTAB_ADVANCED;
      p_window_id=_ctl_timeout;
      _set_sel(1,length(p_text)+1);
      _set_focus();
      _message_box("Timeout must be a positive integer value",FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return(1);
   }

   port=_ctl_port.p_text;
   if( !isinteger(port) || port<1 ) {
      _ctl_profile_sstab.p_ActiveTab=FCPTAB_ADVANCED;
      p_window_id=_ctl_port;
      _set_sel(1,length(p_text)+1);
      _set_focus();
      _message_box("Port must be a positive integer value",FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return(1);
   }

   keepalive=_ctl_keepalive.p_value;

   usefw= (_ctl_use_fw.p_value && _ctl_use_fw.p_enabled);

   if( _ctl_uploadcase_preserve.p_value ) {
      uploadcase=FTPFILECASE_PRESERVE;
   } else if( _ctl_uploadcase_lower.p_value ) {
      uploadcase=FTPFILECASE_LOWER;
   } else if( _ctl_uploadcase_upper.p_value ) {
      uploadcase=FTPFILECASE_UPPER;
   } else {
      _ctl_profile_sstab.p_ActiveTab=FCPTAB_ADVANCED;
      p_window_id=_ctl_uploadcase_preserve;
      _set_focus();
      _message_box("You must decide how your files will be cased when uploaded!",FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return(1);
   }

   resolvelinks=_ctl_resolve_links.p_value;
   
   remoteroot=strip(_ctl_remote_root.p_text);
   if( remoteroot!="" && substr(remoteroot,1,1)!='/' ) {
      _ctl_profile_sstab.p_ActiveTab=FCPTAB_ADVANCED;
      p_window_id=_ctl_remote_root;
      _set_sel(1,length(p_text)+1);
      _set_focus();
      msg="You must specify an absolute remote path or leave blank!\n\nExample: /my-www-dir/";
      _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return(1);
   }
   localroot=strip(_ctl_local_root.p_text);
   if( localroot!="" ) {
      #if __UNIX__
      if( substr(localroot,1,1)!=FILESEP ) {
         _ctl_profile_sstab.p_ActiveTab=FCPTAB_ADVANCED;
         p_window_id=_ctl_local_root;
         _set_sel(1,length(p_text)+1);
         _set_focus();
         msg="You must specify an absolute local path or leave blank!\n\nExample: /my-www-dir/";
         _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
         return(1);
      }
      #else
      drive=substr(localroot,1,2);
      if( !isdrive(drive) && drive!='\\' ) {
         _ctl_profile_sstab.p_ActiveTab=FCPTAB_ADVANCED;
         p_window_id=_ctl_local_root;
         _set_sel(1,length(p_text)+1);
         _set_focus();
         msg="You must specify an absolute local path or leave blank!\n\nExample: c:\\webdir\\";
         _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
         return(1);
      }
      #endif
   }

   fcp_p->Timeout=timeout;
   fcp_p->Port=port;
   fcp_p->KeepAlive= (keepalive!=0);
   fcp_p->UseFW= (usefw!=0);
   fcp_p->UploadCase=uploadcase;
   fcp_p->ResolveLinks= (resolvelinks!=0);
   fcp_p->RemoteRoot=remoteroot;
   fcp_p->LocalRoot=localroot;

   return(0);
}

static int onokAdvanced()
{
   int status;

   status=GetAdvancedOptions(FCPDATAP);

   return(status);
}

void _ctl_ok.lbutton_up()
{
   ftpConnProfile_t *fcpdata_p;
   ftpConnProfile_t save_fcp;

   fcpdata_p=FCPDATAP;

   if( onokGeneral() ) return;
   if( onokAdvanced() ) return;

   if( (_ctl_saveprofile.p_visible && _ctl_saveprofile.p_value) ||
       !(FCPFLAGS&FCPFLAG_NOSAVEPROFILE) ) {
      if( FCPORIG_PROFILENAME!=fcpdata_p->ProfileName &&
          _ftpIsConnProfile(fcpdata_p->ProfileName) ) {
         // Saving to a new name that already exists
         status=_message_box('Profile "':+fcpdata_p->ProfileName:+'" already exists':+
                      "\n\nOverwrite?","FTP",MB_YESNO|MB_ICONQUESTION);
         if( status!=IDYES ) {
            p_window_id=_ctl_profile;
            _set_sel(1,length(p_text)+1);
            _set_focus();
            return;
         }
      }
      save_fcp= *fcpdata_p;
      if( !save_fcp.SavePassword ) {
         /* If the user did not want to save password then don't. But we still
          * want to pass it back in case the caller needs it for some reason.
          */
         save_fcp.Password="";
      }
      status=_ftpSaveConnProfile(&save_fcp);
      if( status ) {
         _message_box("Unable to save connection profile",FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
         return;
      }
   }
   p_active_form._delete_window(0);

   return;
}

_ctl_anonymous.lbutton_up()
{
   ftpConnProfile_t *fcpdata_p;

   fcpdata_p=FCPDATAP;

   if( p_value ) {
      FCPUSERID=strip(_ctl_user.p_text);
      _ctl_user.p_text=FTPDEF_ANONYMOUS_USERID;
      _ctl_pass.p_Password=false;
      pass=fcpdata_p->Options.email;
      if( pass=="" ) {
         pass=FTPDEF_ANONYMOUS_PASS;
      }
      _ctl_pass.p_text=pass;
   } else {
      if( FCPUSERID!=FTPDEF_ANONYMOUS_USERID ) {
         /* Don't want to revert to previous userid if the user put a
          * userid in other than "anonymous".
          */
         _ctl_user.p_text=FCPUSERID;
      } else {
         _ctl_user.p_text=FTPDEF_ANONYMOUS_USERID;
      }
      _ctl_pass.p_Password=true;
   }
   // Put the focus on the Password field if it is blank
   if( _ctl_pass.p_text=="" ) {
      p_window_id=_ctl_pass;
      _set_focus();
      _set_sel(1,length(p_text));
   }
}

_ctl_cancel.lbutton_up()
{
   p_active_form._delete_window('');
}

#define FTPOPTIONSTAB_GENERAL  (0)
#define FTPOPTIONSTAB_ADVANCED (1)
#define FTPOPTIONSTAB_FIREWALL (2)
defeventtab _ftpOptions_form;
static int oncreateGeneralOptions(ftpOptions_t *fo_p)
{
   _ctl_anon_email.p_text=fo_p->email;

   _ctl_deflocaldir.p_text=fo_p->deflocaldir;

   _ctl_put_option1.p_value=_ctl_put_option2.p_value=_ctl_put_option3.p_value=0;
   option=fo_p->put;
   if( !isinteger(option) || option<FTPOPT_EXPLICIT_PUT || option>FTPOPT_ALWAYS_PUT ) {
      option=FTPOPT_PROMPTED_PUT;
   }
   switch( option ) {
   case FTPOPT_EXPLICIT_PUT:
      _ctl_put_option1.p_value=1;
      break;
   case FTPOPT_PROMPTED_PUT:
      _ctl_put_option2.p_value=1;
      break;
   case FTPOPT_ALWAYS_PUT:
      _ctl_put_option3.p_value=1;
      break;
   }

   _ctl_resolve_links.p_value= (int)fo_p->resolvelinks;

   return(0);
}

static int oncreateAdvancedOptions(ftpOptions_t *fo_p)
{
   timeout=fo_p->timeout;
   if( !isinteger(timeout) || timeout<=0 ) {
      timeout=FTPDEF_TIMEOUT;
   }
   _ctl_timeout.p_text=timeout;

   port=fo_p->port;
   if( !isinteger(port) || port<=0 || port>65535 ) {
      port=FTPDEF_PORT;
   }
   _ctl_port.p_text=port;

   _ctl_keepalive.p_value= (int)fo_p->keepalive;

   _ctl_uploadcase_preserve.p_value=_ctl_uploadcase_lower.p_value=_ctl_uploadcase_upper.p_value=0;
   option=fo_p->uploadcase;
   if( !isinteger(option) || option<FTPFILECASE_PRESERVE || option>FTPFILECASE_UPPER ) {
      option=FTPFILECASE_PRESERVE;
   }
   switch( option ) {
   case FTPFILECASE_PRESERVE:
      _ctl_uploadcase_preserve.p_value=1;
      break;
   case FTPFILECASE_LOWER:
      _ctl_uploadcase_lower.p_value=1;
      break;
   case FTPFILECASE_UPPER:
      _ctl_uploadcase_upper.p_value=1;
      break;
   }

   return(0);
}

static int oncreateFirewallOptions(ftpOptions_t *fo_p)
{
   boolean require_host,require_port,require_user,require_pass;
   
   _ctl_pasv.p_value= (int)fo_p->fwpasv;
   _ctl_pasv.p_user=_ctl_pasv.p_value;
   _ctl_fw_type1.p_value=_ctl_fw_type2.p_value=_ctl_fw_type3.p_value=0;
   type=fo_p->fwtype;
   if( !isinteger(type) || type<FTPOPT_FWTYPE_USERAT || type>FTPOPT_FWTYPE_ROUTER ) {
      type=FTPOPT_FWTYPE_USERAT;
   }
   switch( type ) {
   case FTPOPT_FWTYPE_USERAT:
      _ctl_fw_type1.p_value=1;
      break;
   case FTPOPT_FWTYPE_OPEN:
      _ctl_fw_type2.p_value=1;
      break;
   case FTPOPT_FWTYPE_ROUTER:
      _ctl_fw_type3.p_value=1;
      break;
   }

   _ctl_fw_host.p_text=fo_p->fwhost;

   port=fo_p->fwport;
   if( !isinteger(port) || port<=0 || port >65535 ) {
      port=FTPDEF_PORT;
   }
   _ctl_fw_port.p_text=port;

   _ctl_fw_user.p_text=fo_p->fwuserid;

   _ctl_fw_pass.p_Password=true;
   plain="";
   cipher=fo_p->fwpassword;
   if( cipher!="" ) {
      status=vssDecrypt(cipher,plain);
      if( status ) {
         _message_box("Error retrieving password",FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      }
   }
   _ctl_fw_pass.p_text=plain;

   _ctl_enable_fw.p_value= (int)fo_p->fwenable;
   _ctl_enable_fw.call_event(_ctl_enable_fw,LBUTTON_UP,'W');

   return(0);
}

static int oncreateDebugOptions(ftpOptions_t *fo_p)
{
   if( _ftpdebug&FTPDEBUG_LOG_PROXY ) {
      _ctl_log_proxy.p_value=1;
   }
   if( _ftpdebug&FTPDEBUG_SAY_EVENTS ) {
      _ctl_say_events.p_value=1;
   }
   if( _ftpdebug&FTPDEBUG_SAVE_LOG ) {
      _ctl_save_log.p_value=1;
   }
   if( _ftpdebug&FTPDEBUG_TIME_STAMP ) {
      _ctl_time_stamp.p_value=1;
   }
   if( _ftpdebug&FTPDEBUG_SAVE_LIST ) {
      _ctl_save_list.p_value=1;
   }

   return(0);
}

int _ctl_ok.on_create()
{
   ftpOptions_t fo;

   if( _ftpGetOptions(fo) ) return(1);
   if( oncreateGeneralOptions(&fo) ) return(1);
   if( oncreateAdvancedOptions(&fo) ) return(1);
   if( oncreateFirewallOptions(&fo) ) return(1);
   if( oncreateDebugOptions(&fo) ) return(1);

   return(0);
}

static int onokGeneralOptions(ftpOptions_t *fo_p)
{
   fo_p->email=_ctl_anon_email.p_text;

   fo_p->deflocaldir=_ctl_deflocaldir.p_text;

   if( _ctl_put_option1.p_value ) {
      option=FTPOPT_EXPLICIT_PUT;
   } else if( _ctl_put_option2.p_value ) {
      option=FTPOPT_PROMPTED_PUT;
   } else if( _ctl_put_option3.p_value ) {
      option=FTPOPT_ALWAYS_PUT;
   } else {
      _ctl_options_sstab.p_ActiveTab=FTPOPTIONSTAB_GENERAL;
      p_window_id=_ctl_put_option1;
      _set_focus();
      _message_box("You must decide how your files will be uploaded on save!",FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return(1);
   }
   fo_p->put=option;

   fo_p->resolvelinks= (_ctl_resolve_links.p_value!=0);

   return(0);
}

static int onokAdvancedOptions(ftpOptions_t *fo_p)
{
   timeout=_ctl_timeout.p_text;
   if( !isinteger(timeout) || timeout<=0 ) {
      _ctl_options_sstab.p_ActiveTab=FTPOPTIONSTAB_ADVANCED;
      p_window_id=_ctl_timeout;
      _set_sel(1,length(p_text)+1);
      _set_focus();
      _message_box("Timeout must be a positive integer greater than 0",FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return(1);
   }
   fo_p->timeout=timeout;

   port=_ctl_port.p_text;
   if( !isinteger(port) || port<=0 || port>65535 ) {
      _ctl_options_sstab.p_ActiveTab=FTPOPTIONSTAB_ADVANCED;
      p_window_id=_ctl_port;
      _set_sel(1,length(p_text)+1);
      _set_focus();
      _message_box("Port must be in the range 1-65535",FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return(1);
   }
   fo_p->port=port;

   fo_p->keepalive= (_ctl_keepalive.p_value!=0);

   if( _ctl_uploadcase_preserve.p_value ) {
      option=FTPFILECASE_PRESERVE;
   } else if( _ctl_uploadcase_lower.p_value ) {
      option=FTPFILECASE_LOWER;
   } else if( _ctl_uploadcase_upper.p_value ) {
      option=FTPFILECASE_UPPER;
   } else {
      _ctl_options_sstab.p_ActiveTab=FTPOPTIONSTAB_ADVANCED;
      p_window_id=_ctl_uploadcase_preserve;
      _set_focus();
      _message_box("You must decide how your files will be cased when uploaded!",FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return(1);
   }
   fo_p->uploadcase=option;

   return(0);
}

static int onokFirewallOptions(ftpOptions_t *fo_p)
{
   fo_p->fwenable= (_ctl_enable_fw.p_value!=0);

   if( _ctl_fw_type1.p_value ) {
      type=FTPOPT_FWTYPE_USERAT;
   } else if( _ctl_fw_type2.p_value ) {
      type=FTPOPT_FWTYPE_OPEN;
   } else if( _ctl_fw_type3.p_value ) {
      type=FTPOPT_FWTYPE_ROUTER;
   } else {
      if( fo_p->fwenable ) {
         // Firewall/proxy is enabled, so this has to be correct
         _ctl_options_sstab.p_ActiveTab=FTPOPTIONSTAB_FIREWALL;
         p_window_id=_ctl_fw_type1;
         _set_focus();
         _message_box("You must choose the type of firewall/proxy!",FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
         return(1);
      } else {
         // Firewall/proxy is not enabled, so just set the value to a default
         type=FTPOPT_FWTYPE_USERAT;
      }
   }
   fo_p->fwtype=type;
   require_host= (type==FTPOPT_FWTYPE_USERAT);
   require_port= (type==FTPOPT_FWTYPE_USERAT);
   require_user= false;
   require_pass= false;

   host=_ctl_fw_host.p_text;
   if( fo_p->fwenable && require_host && host=="" ) {
      // Firewall/proxy is enabled, so this has to be correct
      _ctl_options_sstab.p_ActiveTab=FTPOPTIONSTAB_FIREWALL;
      p_window_id=_ctl_fw_host;
      _set_focus();
      _message_box("This firewall/proxy type requires a host!",FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return(1);
   }
   fo_p->fwhost=host;

   port=_ctl_fw_port.p_text;
   if( !isinteger(port) || port<=0 || port>65535 ) {
      if( fo_p->fwenable && require_port ) {
         // Firewall/proxy is enabled, so this has to be correct
         _ctl_options_sstab.p_ActiveTab=FTPOPTIONSTAB_FIREWALL;
         p_window_id=_ctl_port;
         _set_sel(1,length(p_text)+1);
         _set_focus();
         _message_box("Port must be in the range 1-65535",FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
         return(1);
      } else {
         // Firewall/proxy is not enabled, so just set the value to a default
         port=FTPDEF_PORT;
      }
   }
   fo_p->fwport=port;

   user=_ctl_fw_user.p_text;
   if( fo_p->fwenable && require_user && user=="" ) {
      // Firewall/proxy is enabled, so this has to be correct
      _ctl_options_sstab.p_ActiveTab=FTPOPTIONSTAB_FIREWALL;
      p_window_id=_ctl_fw_user;
      _set_focus();
      _message_box("This firewall/proxy type requires a user id!",FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return(1);
   }
   fo_p->fwuserid=user;

   cipher="";
   plain=_ctl_fw_pass.p_text;
   if( plain!="" ) {
      status=vssEncrypt(plain,cipher);
      if( status ) {
         _message_box("Error saving firewall/proxy password",FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
         if( fo_p->fwenable ) {
            // Firewall/proxy is enabled, so this is serious
            return(1);
         }
      }
   }
   fo_p->fwpassword=cipher;

   if( fo_p->fwtype==FTPOPT_FWTYPE_ROUTER ) {
      // Router firewalls ALWAYS use passive transfers
      fo_p->fwpasv=true;
   } else {
      fo_p->fwpasv= (_ctl_pasv.p_value!=0);
   }

   return(0);
}

static int onokDebugOptions(ftpOptions_t *fo_p)
{
   int flags;
   
   flags=0;
   if( _ctl_log_proxy.p_value ) {
      flags |= FTPDEBUG_LOG_PROXY;
   }
   if( _ctl_say_events.p_value ) {
      flags |= FTPDEBUG_SAY_EVENTS
   }
   if( _ctl_save_log.p_value ) {
      flags |= FTPDEBUG_SAVE_LOG;
   }
   if( _ctl_time_stamp.p_value ) {
      flags |= FTPDEBUG_TIME_STAMP;
   }
   if( _ctl_save_list.p_value ) {
      flags |= FTPDEBUG_SAVE_LIST;
   }
   _ftpdebug=flags;
   _config_modify |= CFGMODIFY_DEFVAR;

   return(0);
}

int _ctl_ok.lbutton_up()
{
   ftpOptions_t fo;

   if( onokGeneralOptions(&fo) ) return(1);
   if( onokAdvancedOptions(&fo) ) return(1);
   if( onokFirewallOptions(&fo) ) return(1);
   if( onokDebugOptions(&fo) ) return(1);

   if( _ftpSaveOptions(&fo) ) return(1);

   p_active_form._delete_window(0);

   return(0);
}

void _ctl_cancel.lbutton_up()
{
   p_active_form._delete_window('');
}

void _ctl_fw_type1.lbutton_up()
{
   require_host=true;
   require_port=true;
   require_user=false;
   require_pass=false;
   _ctl_pasv.p_enabled=true;
   _ctl_pasv.p_value=_ctl_pasv.p_user;
   _ctl_fw_host.p_enabled=require_host;
   _ctl_fw_port.p_enabled=require_port;
   _ctl_fw_user.p_enabled=require_user;
   _ctl_fw_pass.p_enabled=require_pass;
   
   return;
}

void _ctl_fw_type2.lbutton_up()
{
   require_host=true;
   require_port=true;
   require_user=false;
   require_pass=false;
   _ctl_pasv.p_enabled=true;
   _ctl_pasv.p_value=_ctl_pasv.p_user;
   _ctl_fw_host.p_enabled=require_host;
   _ctl_fw_port.p_enabled=require_port;
   _ctl_fw_user.p_enabled=require_user;
   _ctl_fw_pass.p_enabled=require_pass;
   
   return;
}

void _ctl_fw_type3.lbutton_up()
{
   // Router based firewalls ALWAYS use PASV transfers
   require_host=true;
   require_port=true;
   require_user=false;
   require_pass=false;
   _ctl_pasv.p_value=1;
   _ctl_pasv.p_enabled=false;
   _ctl_fw_host.p_enabled=require_host;
   _ctl_fw_port.p_enabled=require_port;
   _ctl_fw_user.p_enabled=require_user;
   _ctl_fw_pass.p_enabled=require_pass;
   
   return;
}

void _ctl_pasv.lbutton_up()
{
   /* Used to remember what the previous value was when the user switches to
    * "Router" type, then to some other type.
    */
   p_user=p_value;
}

void _ctl_enable_fw.lbutton_up()
{
   enabled= (p_value!=0);
   _ctl_fw_host.p_enabled=enabled;
   _ctl_fw_port.p_enabled=enabled;
   _ctl_fw_user.p_enabled=enabled;
   _ctl_fw_pass.p_enabled=enabled;
   _ctl_fw_type1.p_enabled=enabled;
   _ctl_fw_type2.p_enabled=enabled;
   _ctl_fw_type3.p_enabled=enabled;
   _ctl_pasv.p_enabled=enabled;
   if( enabled ) {
      if( _ctl_fw_type1.p_value ) {
         _ctl_fw_type1.call_event(_ctl_fw_type1,LBUTTON_UP,'W');
      } else if( _ctl_fw_type2.p_value ) {
         _ctl_fw_type2.call_event(_ctl_fw_type2,LBUTTON_UP,'W');
      } else if( _ctl_fw_type3.p_value ) {
         _ctl_fw_type3.call_event(_ctl_fw_type3,LBUTTON_UP,'W');
      }
   }
   
   return;
}

#define FPMDATAP _ctl_connect.p_user
defeventtab _ftpProfileManager_form;
static int _fpmFillProfileList()
{
   status=_open_temp_view(_ftpUserIniFilename(),temp_view_id,orig_view_id);
   if( status ) {
      return(1);
   }
   p_view_id=temp_view_id;
   top();
   status=search('^\[profile\-','@ir');
   while( !status ) {
      get_line(line);
      parse line with '[profile-' profile ']';
      if( profile=="" ) {
         // This should never happen
         continue;
      }
      p_view_id=orig_view_id;
      _ctl_list._lbadd_item(profile);
      p_view_id=temp_view_id;
      status=repeat_search();
   }
   _delete_temp_view(temp_view_id);
   p_view_id=orig_view_id;
   _ctl_list._lbsort('AI');
   _ctl_list._lbtop();
   //_ctl_list._lbselect_line();

   return(0);
}

void _ctl_connect.on_create()
{
   FPMDATAP=0;
   if( arg()>0 ) {
      FPMDATAP= (ftpConnProfile_t *)arg(1);
   }
   if( !FPMDATAP ) {
      // Only allow the user to add/delete/edit connection profiles
      _ctl_connect.p_enabled=false;
   }

   if( _fpmFillProfileList() ) {
      _message_box("Unable to create connection profile list",FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      p_active_form._delete_window(1);
      return;
   }

   p_window_id=_ctl_list;
   if( p_Noflines ) {
      _lbdeselect_all();
      _lbtop();
      status=_ini_get_value(_ftpUserIniFilename(),"Profile Manager","lastprofile",last_item);
      if( !status ) {
         _lbsearch(last_item,'E');
      }
      _lbselect_line();
   }
   return;
}

#if 0
_ftpProfileManager_form.on_load()
{
   p_window_id=_ctl_list;
   if( p_Noflines ) {
      _lbdeselect_all();
      _lbtop();
      _lbselect_line();
   }
   _set_focus();
}
#endif

void _ctl_connect.lbutton_up()
{
   ftpConnProfile_t *fcpdata_p;

   fcpdata_p=FPMDATAP;

   profile=_ctl_list._lbget_seltext();
   if( profile=="" ) {
      _message_box("Select a profile to connect to","FTP",MB_OK|MB_ICONINFORMATION);
      return;
   }
   status=_ftpOpenConnProfile(profile,fcpdata_p);
   if( !status ) {
      last_item=_ctl_list._lbget_seltext()
      _ini_set_value(_ftpUserIniFilename(),"Profile Manager","lastprofile",last_item);
   }
   
   p_active_form._delete_window(status);

   return;
}

_ctl_list.lbutton_double_click()
{
   if( _ctl_connect.p_enabled ) _ctl_connect.call_event(_ctl_connect,LBUTTON_UP,'W');
}

void _ctl_add.lbutton_up()
{
   ftpConnProfile_t fcp;

   fcp._makeempty();
   _ftpInitConnProfile(fcp);
   status=show("-modal _ftpCreateProfile_form",&fcp,FCPFLAG_HIDESAVEPROFILE);
   if( status ) {
      if( status!="" ) {   // Check for command cancelled
         _message_box("Unable to create connection profile",FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      }
      return;
   }
   if( fcp.ProfileName!="" ) {
      _ctl_list._save_pos2(p);
      _ctl_list._lbadd_item(fcp.ProfileName);
      _ctl_list._lbsort('AI');
      _ctl_list._restore_pos2(p);
      if( _ctl_list.p_line==0 ) _ctl_list._lbtop();
   }

   return;
}

void _ctl_delete.lbutton_up()
{
   profile=_ctl_list._lbget_seltext();
   if( profile!="" ) {
      result=_message_box('Delete profile "':+profile:+'"':+"\n\nAre you sure?","FTP",MB_YESNO|MB_ICONQUESTION);
      if( result!=IDYES ) return;
      status=_ftpDeleteConnProfile(profile);
      if( status ) {
         _message_box("Unable to delete connection profile",FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
         return;
      }
      _ctl_list._lbdelete_item();
   }

   return;
}

void _ctl_edit.lbutton_up()
{
   ftpConnProfile_t fcp;

   profile=_ctl_list._lbget_seltext();
   if( profile!="" ) {
      fcp._makeempty();
      status=_ftpOpenConnProfile(profile,&fcp);
      if( status ) {
         _message_box("Unable to open connection profile",FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
         return;
      }
      flags=FCPFLAG_HIDESAVEPROFILE|FCPFLAG_DISABLEPROFILE;
      status=show("-modal _ftpCreateProfile_form",&fcp,flags);
      if( status ) {
         if( status!="" ) {   // Check for command cancelled
            _message_box("Unable to save connection profile",FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
         }
         return;
      }
   }

   return;
}

void _ctl_rename.lbutton_up()
{
   old_profile=_ctl_list._lbget_seltext();
   if( old_profile!="" ) {
      result=show("-modal _textbox_form","Rename Profile",0,"","","","","New profile name:":+old_profile);
      if( result=="" ) {
         // User cancelled
         return;
      }
      new_profile=strip(_param1);
      if( new_profile=="" ) return;
      status=_open_temp_view(_ftpUserIniFilename(),ini_view_id,orig_view_id);
      if( status ) return;
      p_view_id=ini_view_id;
      top();
      status=search('^\[profile\-':+old_profile,'@ir');
      if( status ) {
         msg='Could not find profile "':+old_profile:+'" in ':+_ftpUserIniFilename();
         _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
         _delete_temp_view(ini_view_id);
         p_view_id=orig_view_id;
         return;
      }
      replace_line('[profile-':+new_profile:+']');
      status=_save_file('+o');
      _delete_temp_view(ini_view_id);
      p_view_id=orig_view_id;
      if( status ) {
         msg='Unable to save "':+_ftpUserIniFilename():+'".  ':+_ftpGetMessage(status);
         _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      } else {
         _ctl_list._lbset_item(new_profile);
         _ctl_list._lbselect_line();
      }
   }

   return;
}

void _ctl_options.lbutton_up()
{
   show("-modal _ftpOptions_form");

   return;
}

void _ctl_close.lbutton_up()
{
   last_item=_ctl_list._lbget_seltext()
   _ini_set_value(_ftpUserIniFilename(),"Profile Manager","lastprofile",last_item);
   p_active_form._delete_window('');
   
   return;
}

defeventtab _ftpLog_form;

// This expects the active window to be an edit control
static void _AttachLog(_str log_buf_name)
{
   /* Attach the log buffer to the edit control on the "Log" tab.
    * Note: Not worrying about getting rid of the original buffer that
    * gets created with an edit control because it will get deleted
    * when ftp client toolbar is destroyed.
    */
   p_visible=true;
   orig_buf_id=p_buf_id;
   for(;;) {
      if( p_buf_name==log_buf_name ) break;
      _next_buffer('HR');
      if( p_buf_id==orig_buf_id ) break;
   }
   if( p_buf_name==log_buf_name ) {
      bottom();
   }
   //p_view_id=orig_view_id;

   return;
}

void _ctl_ok.on_create()
{
   ftpConnProfile_t *fcp_p;

   fcp_p=0;
   if( arg()>0 ) {
      fcp_p= (ftpConnProfile_t *)arg(1);
   }
   if( arg()>1 ) {
      p_active_form.p_caption="FTP Log - ":+strip(arg(2));
   }
   if( fcp_p ) {
      _ctl_log.p_visible=true;
      _ctl_no_log.p_visible=false;
      _ctl_log._AttachLog(fcp_p->LogBufName);
   } else {
      _ctl_log.p_visible=false;
      _ctl_no_log.p_visible=true;
   }

   return;
}

void _ctl_ok.lbutton_up()
{
   p_active_form._delete_window();

   return;
}

_ftpLog_form.on_resize()
{
   formW=_dx2lx(SM_TWIP,p_active_form.p_client_width);
   formH=_dy2ly(SM_TWIP,p_active_form.p_client_height);

   _ctl_log.p_width=formW-2*_ctl_log.p_x;
   _ctl_log.p_height=formH-2*_dy2ly(SM_TWIP,4)-_ctl_ok.p_height;

   _ctl_ok.p_x= (int)(formW-_ctl_ok.p_width)/2;
   _ctl_ok.p_y=_ctl_log.p_y+_ctl_log.p_height+_dy2ly(SM_TWIP,4)-1;
}

defeventtab _ftpProgress_form;
_ctl_abort.on_create()
{
   _ctl_progress.p_value=0;
   _ctl_nofbytes.p_caption="";
   caption=arg(1);
   if( caption!="" ) {
      /* This is a starting caption that will probably get overwritten
       * if there is a callback that updates this form.
       */
      p_active_form.p_caption=caption;
   }
}

_ctl_abort.lbutton_up()
{
   gftpAbort=true;
}

