#include "slick.sh"
#include "sock.sh"
#include "ftp.sh"

_command ftpClient() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   formWid=_find_object("_tbFTPClient_form","N");
   tbShow("_tbFTPClient_form");
   if( formWid ) {
      msg="";
      switch( formWid.p_isbutton_bar ) {
      case BBSIDE_BOTTOM:
         msg="The FTP Client toolbar is already visible at the bottom"
         break;
      case BBSIDE_LEFT:
         msg="The FTP Client toolbar is already visible on the left side"
         break;
      case BBSIDE_RIGHT:
         msg="The FTP Client toolbar is already visible on the right side"
         break;
      case BBSIDE_TOP:
         msg="The FTP Client toolbar is already visible at the top"
         break;
      }
      if( msg!="" ) {
         _message_box(msg,"",MB_OK);
      }
   }
}

#define FTPTOOLTAB_DIR (0)
#define FTPTOOLTAB_LOG (1)
static boolean gchangetab_allowed=true;
static boolean gchangeprofile_allowed=true;
static boolean gchangedrvlist_allowed=true;
static boolean gchangelocalcwd_allowed=true;
static boolean gchangeremotecwd_allowed=true;
#define LOCALCWD _ctl_local_cwd.p_user
#define LOCALFILTER _ctl_local_dir.p_user
defeventtab _tbFTPClient_form;
// This expects the active window to be a combo box
static void _FillProfiles(boolean set_textbox)
{
   oldchangeprofile_allowed=gchangeprofile_allowed;
   gchangeprofile_allowed=false;
   p_cb_list_box._lbclear();
   for( i._makeempty();; ) {
      _ftpCurrentConnections._nextel(i);
      if( i._isempty() ) break;
      p_cb_list_box._lbadd_item(i);
   }
   if( p_cb_list_box.p_Noflines ) {
      p_cb_list_box._lbsort('AI');
      p_cb_list_box._lbselect_line();
      if( set_textbox ) {
         p_text=p_cb_list_box._lbget_seltext();
      }
   }
   gchangeprofile_allowed=oldchangeprofile_allowed;

   return;
}

static void oncreateTabControl()
{
   typeless ht:[];
   int i;
   int tallest,total_width;
   _str info;

   gchangeprofile_allowed=false;
   //ht:["_formW"]=p_active_form.p_width;
   //ht:["_formH"]=p_active_form.p_height;
   //ht:["_ctl_ftp_sstabW"]=p_width;
   //ht:["_ctl_ftp_sstabH"]=p_height;

   // Find tab height and max tabs width
   tallest=0;
   total_width=0;
   for( i=0;i<p_NofTabs;i++ ) {
      info=_getTabInfo(i);
      parse info with enabled order pic partialCaption x1 y1 x2 y2 fa minW maxW theRest;
      tabHeight=_dy2ly(SM_TWIP,y2-y1);
      if( tabHeight>tallest ) tallest=tabHeight;
      total_width += maxW;
   }
   ht:["tabHeight"]=tallest;
   ht:["pictureOnlyW"]=_dx2lx(SM_TWIP,total_width)+_dx2lx(SM_TWIP,4);
   p_user=ht;

   // If active tab is specified as arg(2).  Otherwise, use the saved value.
   if( arg()>0 ) {
      int active;
      active=arg(1);
      p_ActiveTab=active;
   } else {
      _retrieve_value();
   }

   _ctl_profile.p_cb_list_box.p_scroll_bars=SB_BOTH;
   _ctl_profile.p_text="";
   _ctl_profile._FillProfiles(true);
   profile=_ctl_profile._retrieve_value();
   status=_ctl_profile.p_cb_list_box._lbsearch(profile);
   if( !status ) {
      _ctl_profile.p_text=profile;
   }

   gchangeprofile_allowed=true;
   
   _ctl_progress_label1.p_caption="";
   _ctl_progress_label2.p_caption="";
   _ctl_progress.p_value=0;

   return;
}

static void oncreateDirTab()
{
   _ctl_local_dir.p_multi_select=MS_EXTENDED;
   _ctl_remote_dir.p_multi_select=MS_EXTENDED;
   
   _ctl_remote_dir.p_visible=false;
   _ctl_remote_cwd.p_visible=false;
   _ctl_no_connection.p_visible=true;
#if __UNIX__
   _ctl_local_drvlist.p_visible=false;   // Paranoid - this is taken care of in _UpdateSession()
#else
   _ctl_local_drvlist.p_visible=true;
#endif
   LOCALCWD="";
   LOCALFILTER=ALLFILES_RE;

   // Horizontal scroll bars
   val=_retrieve_value("_tbFTPClient_form._ctl_local_dir.p_scroll_bars");
   if( !isinteger(val) || val<SB_NONE || val>SB_BOTH ) val=SB_BOTH;
   _ctl_local_dir.p_scroll_bars= (int)val;
   if( (_ctl_local_dir.p_scroll_bars)&SB_HORIZONTAL ) {
      _ctl_local_dir.p_delay= -1;
   } else {
      _ctl_local_dir.p_delay= 0;
   }
   val=_retrieve_value("_tbFTPClient_form._ctl_remote_dir.p_scroll_bars");
   if( !isinteger(val) || val<SB_NONE || val>SB_BOTH ) val=SB_BOTH;
   _ctl_remote_dir.p_scroll_bars= (int)val;
   if( (_ctl_remote_dir.p_scroll_bars)&SB_HORIZONTAL ) {
      _ctl_remote_dir.p_delay= -1;
   } else {
      _ctl_remote_dir.p_delay= 0;
   }
   
   // Local current working directory history
   gchangelocalcwd_allowed=false;
   _ctl_local_cwd._retrieve_list();
   _ctl_local_cwd.p_cb_list_box._lbtop();
   cwd=_ctl_local_cwd.p_cb_list_box._lbget_text();
   // Used to restore the original local current working directory
   LOCALCWD=cwd;
   gchangelocalcwd_allowed=true;
   
   return;
}

// This expects the active window to be an edit control
static void _AttachLog(_str log_buf_name)
{
   /* Attach the log buffer to the edit control on the "Log" tab.
    * Note: Not worrying about getting rid of the original buffer that
    * gets created with an edit control because it will get deleted
    * when ftp client toolbar is destroyed.
    */
   p_visible=true;
   orig_buf_id=p_buf_id;
   for(;;) {
      if( p_buf_name==log_buf_name ) break;
      _next_buffer('HR');
      if( p_buf_id==orig_buf_id ) break;
   }
   if( p_buf_name==log_buf_name ) {
      bottom();
   }
   //p_view_id=orig_view_id;

   return;
}

static void oncreateLogTab()
{
   _ctl_log.p_visible=false;
   _ctl_no_log.p_visible=true;

   return;
}

void _ctl_ftp_sstab.on_create()
{
   gchangetab_allowed=false;
   _ctl_ftp_sstab.oncreateTabControl();
   _ctl_ftp_sstab.oncreateDirTab();
   _ctl_ftp_sstab.oncreateLogTab();
   gchangetab_allowed=true;

   _ctl_ftp_sstab.call_event(_ctl_ftp_sstab,ON_RESIZE,'W');

   _ctl_profile.call_event(CHANGE_SELECTED,_ctl_profile,ON_CHANGE,'W');

   return;
}

_tbFTPClient_form.on_load()
{
   // Take focus off the toolbar after the on_create()'s are done
   p_window_id=_mdi.p_child;
   _set_focus();
}

void _ctl_ftp_sstab.on_destroy()
{
   // Remember active tab
   val=_ctl_ftp_sstab.p_ActiveTab;
   _append_retrieve(_ctl_ftp_sstab,val);
   
   // Remember the active profile
   _append_retrieve(_ctl_profile,_ctl_profile.p_text);
   
   // Remember horizontal scroll bar settings
   _append_retrieve(0,_ctl_local_dir.p_scroll_bars,"_tbFTPClient_form._ctl_local_dir.p_scroll_bars");
   _append_retrieve(0,_ctl_remote_dir.p_scroll_bars,"_tbFTPClient_form._ctl_remote_dir.p_scroll_bars");
   
   // Remember local current working directory history
   _append_retrieve(_ctl_local_cwd,_ctl_local_cwd.p_text);
   
   return;
}

void _ctl_ftp_sstab.on_change(reason)
{
   if( !gchangetab_allowed ) return;

   if( reason==CHANGE_TABACTIVATED ) {
      // Force a resize
      p_active_form.call_event(p_active_form,ON_RESIZE,'W');
   }
}

void _ctl_profile.on_drop_down(reason)
{
   if( reason!=DROP_DOWN ) return;
   _FillProfiles(false);
}

// This expects the active window to be a combo box
static int _ChangeProfile(...)
{
   ftpConnProfile_t *fcp_p;

   oldchangeprofile_allowed=gchangeprofile_allowed;
   gchangeprofile_allowed=false;
   if( arg()>0 ) {
      profile_name=arg(1);
   } else {
      // Get the profile in the text box
      profile_name=p_text;
   }

   if( profile_name=="" ) {
      // This should only happen when there are no connections
      if( !p_cb_list_box.p_Noflines ) _FillProfiles(false);
      if( p_cb_list_box.p_Noflines ) {
         p_cb_list_box._lbtop();
         profile_name=p_cb_list_box._lbget_text();
      }
      if( profile_name=="" ) {
         p_text="";
         gchangeprofile_allowed=oldchangeprofile_allowed;
         return(0);
      }
   }

   //messageNwait(_ftpCurrentConnections._isempty()'  '_ftpCurrentConnections._indexin(profile_name));
   //messageNwait('profile_name='profile_name);
   if( !_ftpCurrentConnections._indexin(profile_name) ) {
      // Remove this profile from the combo box
      _FillProfiles(false);
      p_cb_list_box._lbtop();
      p_cb_list_box._lbselect_line();
      p_text=p_cb_list_box._lbget_seltext();
      profile_name=p_text;
   } else {
      // Always find the profile name in case the user just opened a new connection
      status=p_cb_list_box._lbsearch(profile_name,'i');
      if( status ) {
         // This normally happens when user connects with "Connect..." button
         _FillProfiles(false);
         p_cb_list_box._lbsearch(profile_name,'i');
      }
      p_cb_list_box._lbselect_line();
      p_text=p_cb_list_box._lbget_seltext();
   }
   fcp_p=_ftpCurrentConnections._indexin(profile_name);
   if( fcp_p ) {
      formWid=_find_object("_tbFTPClient_form","N");
      if( formWid ) {
         asciiWid=formWid._find_control("_ctl_ascii");
         binWid=formWid._find_control("_ctl_binary");
         if( asciiWid && binWid ) {
            switch( fcp_p->XferType ) {
            case FTPXFER_ASCII:
               asciiWid.p_value=1;
               asciiWid.call_event(asciiWid,LBUTTON_UP,'W');
               break;
            case FTPXFER_BINARY:
               binWid.p_value=1;
               binWid.call_event(binWid,LBUTTON_UP,'W');
               break;
            default:
               // This should never happen
               asciiWid.p_value=0;
               binWid.p_value=0;
            }
         }
      }

      if( fcp_p->LogBufName=="" ) {
         _message_box('Warning:  Forced to create a log for profile "':+profile_name:+'"',FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
         log_buf_name=_ftpCreateLogBuffer();
         if( log_buf_name=="" ) {
            // _ftpCreateLogBuffer() will take care of error messages to user
            gchangeprofile_allowed=oldchangeprofile_allowed;
            return(1);
         }
         fcp_p->LogBufName=log_buf_name;
         _ftpLog(fcp_p,"*** Log started on ":+_date():+" at ":+_time('M'));
      }
   }
   gchangeprofile_allowed=oldchangeprofile_allowed;

   return(0);
}

/* This expects the active window to be a tree view.
 * Sets up column widths in the directory listing.
 */
//#define isvalid_field_width(w) (isinteger(w) && w>0)
#define FTPDIR_FIELDGAP (300)
static void _RefreshLocalDirFields()
{
   /* Right now this just calls the refresh for the ftp directory listing,
    * but it might change in the future if the format of the local listing
    * becomes different from the remote listing.
    */
   _RefreshRemoteDirFields();
}

/* This expects the active window to be a tree view.
 */
static int _RefreshLocalDir(ftpConnProfile_t *fcp_p,...)
{
   if( !fcp_p ) return(1);

   quiet= (arg(2)!="" && arg(2));

   // Generate a temp view with the local file listing
   tree_view_id=p_view_id;
   if( _create_temp_view(temp_view_id)=="" ) {
      // _create_temp_view() took care of error messages
      if( !quiet ) {
         _message_box("Unable to retrieve local directory list",FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      }
      return(1);
   }
   _delete_line();
   cwd=fcp_p->LocalCWD;
   if( cwd=="" ) {
      cwd=getcwd();
      fcp_p->LocalCWD=cwd;
   }
   /* User might have setup "." or some relative path as the current
    * local working directory, so resolve it.
    */
   orig_cwd=cwd;
   cwd=isdirectory(maybe_quote_filename(cwd),1);
   if( cwd=="" || cwd=="0" ) {
      _delete_temp_view(temp_view_id);
      p_view_id=tree_view_id;
      cwd=getcwd();
      if( !quiet ) {
         _message_box("The following directory does not exist:\n\n":+
                      orig_cwd:+"\n\nThe new local working directory is:\n\n":+
                      cwd,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      }
   }
   fcp_p->LocalCWD=cwd;
   if( last_char(cwd)!=FILESEP ) cwd=cwd:+FILESEP;
   filespec=cwd:+ALLFILES_RE;
   status=insert_file_list(maybe_quote_filename(filespec):+' +ADV');
   if( status ) {
      _delete_temp_view(temp_view_id);
      p_view_id=tree_view_id;
      if( !quiet ) {
         _message_box("Unable to retrieve local directory list.  ":+get_message(status),"",MB_OK|MB_ICONEXCLAMATION);
      }
      return(status);
   }

   /* Fill in the file list. The format is:
    *
    * 11444   7-15-1997  10:15p ----A  ftp.c
    */
   filter=fcp_p->LocalFileFilter;
   if( filter=="" ) filter=ALLFILES_RE;
   top();up();
   p_view_id=tree_view_id;
   _TreeDelete(TREE_ROOT_INDEX,"C");   // Clear the tree out
   for(;;) {
      p_view_id=temp_view_id;
      if( down() ) break;
      if( _line_length(1)==_line_length(0) ) break;
      get_line(line);
      parse line with size date time attribs filename;
      if( filename=="." || filename==".." ) {
         continue;
      }
      if( !pos('d',lowcase(attribs),1,'e') &&
          filter!=ALLFILES_RE ) {
         match=false;
         list=filter;
         while( list!="" ) {
            filespec=parse_file(list);
            filespec=strip(filespec,'B','"');
            if( filespec=="" ) continue;
            if( _FilespecMatches(filespec,filename,_fpos_case) ) {
               // Found a match
               match=true;
               break;
            }
         }
         if( !match ) continue;
      }
      if( !isinteger(size) ) {
         // Probably the "<DIR>" of a directory
         size=0;
      }

      p_view_id=tree_view_id;
      picidx=_pic_ftpfile;
      if( pos('d',lowcase(attribs),1,'e') ) {
         picidx=_pic_ftpfold;
      }
      caption=filename"\t"size"\t"date"\t"time"\t"attribs;
      idx=_TreeAddItem(TREE_ROOT_INDEX,caption,TREE_ADD_AS_CHILD,picidx,picidx,-1,0);
      _TreeSetUserInfo(idx,"");
      if( pos('d',lowcase(attribs),1,'e') ) {
         // Directory name
         _TreeSetUserInfo(idx,"D");   // Use this for primary/secondary sort on directories
      } else {
         // File name
         _TreeSetUserInfo(idx,"F");   // Use this for primary/secondary sort on directories
      }
   }
   _delete_temp_view(temp_view_id);
   p_view_id=tree_view_id;
   _TreeSortUserInfo(TREE_ROOT_INDEX,"","FE");   // Primary sort directories / secondary sort filenames
   idx=_TreeGetFirstChildIndex(TREE_ROOT_INDEX);
   if( idx<0 ) {
      // No children, just add ".."
      _TreeAddItem(TREE_ROOT_INDEX,"..",TREE_ADD_AS_CHILD,_pic_ftpcdup,_pic_ftpcdup,-1,0);   // Add the up-one-level ".."
   } else {
      _TreeAddItem(idx,"..",TREE_ADD_BEFORE,_pic_ftpcdup,_pic_ftpcdup,-1,0);
   }
   _RefreshLocalDirFields();
   _TreeTop();

   return(0);
}

/* This expects the active window to be a tree view.
 * Sets up column widths in the directory listing.
 */
//#define isvalid_field_width(w) (isinteger(w) && w>0)
#define FTPDIR_FIELDGAP (300)
static void _RefreshRemoteDirFields()
{
   if( _TreeGetDepth(TREE_ROOT_INDEX) ) return;   // Nothing to process

   #if 0
   nofargs=arg();
   if( nofargs>0 && isvalid_dirfield_width(arg(1)) ) filename_width=arg(1);
   if( nofargs>1 && isvalid_dirfield_width(arg(2)) ) size_width=arg(2);
   if( nofargs>2 && isvalid_dirfield_width(arg(3)) ) date_width=arg(3);
   if( nofargs>3 && isvalid_dirfield_width(arg(4)) ) time_width=arg(4);
   if( nofargs>4 && isvalid_dirfield_width(arg(5)) ) attribs_width=arg(5);
   #endif

   filename_width=size_width=date_width=time_width=attribs_width=0;
   idx=_TreeGetFirstChildIndex(TREE_ROOT_INDEX);
   for(;;) {
      caption=_TreeGetCaption(idx);
      parse caption with filename "\t" size "\t" date "\t" time "\t" attribs;

      // Find the longest widths for each field in the tree
      width=_text_width(filename);
      if( width>filename_width ) filename_width=width;
      width=_text_width(size);
      if( width>size_width ) size_width=width;
      width=_text_width(date);
      if( width>date_width ) date_width=width;
      width=_text_width(time);
      if( width>time_width ) time_width=width;
      width=_text_width(attribs);
      if( width>attribs_width ) attribs_width=width;

      idx=_TreeGetNextSiblingIndex(idx);
      if(idx<0) break;
   }

   _col_width(0,filename_width+FTPDIR_FIELDGAP);
   _col_width(1,size_width+FTPDIR_FIELDGAP);
   _col_width(2,date_width+FTPDIR_FIELDGAP);
   _col_width(3,time_width+FTPDIR_FIELDGAP);
   _col_width(4,attribs_width+FTPDIR_FIELDGAP);

   return;
}

/* This expects the active window to be a tree view.
 * If force is true then it forces this function to get a new directory
 * listing even if there is already one present for this connection.
 */
static int _RefreshRemoteDir(ftpConnProfile_t *fcp_p)
{
   ftpFile_t files[];

   if( !fcp_p ) return(1);

   // Fill in the file list
   _TreeDelete(TREE_ROOT_INDEX,"C");   // Clear the tree out
   files=fcp_p->RemoteDir.files;
   filename_width=size_width=date_width=time_width=attribs_width=0;
   for( i=0;i<files._length();++i ) {
      if( files[i].filename=="." || files[i].filename==".." ) {
         continue;
      }
      picidx=_pic_ftpfile;
      type=files[i].type;
      if( type&FTPFILETYPE_DIR ) {
         if( type&FTPFILETYPE_LINK ) {
            picidx=_pic_ftplfol;
         } else {
            picidx=_pic_ftpfold;
         }
      } else if( type&FTPFILETYPE_LINK ) {
         picidx=_pic_ftplfil;
      }
      filename=files[i].filename;
      size=files[i].size
      date=files[i].month' 'files[i].day' 'files[i].year;
      time=files[i].time;
      attribs=files[i].attribs;
      caption=filename"\t"size"\t"date"\t"time"\t"attribs;
      idx=_TreeAddItem(TREE_ROOT_INDEX,caption,TREE_ADD_AS_CHILD,picidx,picidx,-1,0);
      _TreeSetUserInfo(idx,"");
      if( type&FTPFILETYPE_DIR ) {
         // Directory name
         info="D";
         if( type&FTPFILETYPE_LINK ) {
            info=info:+"L";
         }
         _TreeSetUserInfo(idx,info);   // Use this for primary/secondary sort on directories/files
      } else {
         // File name
         _TreeSetUserInfo(idx,"F");   // Use this for primary/secondary sort on directories/files
      }
   }
   _TreeSortUserInfo(TREE_ROOT_INDEX,"","FE");   // Primary sort directories / secondary sort filenames
   idx=_TreeGetFirstChildIndex(TREE_ROOT_INDEX);
   if( idx<0 ) {
      // No children, just add ".."
      _TreeAddItem(TREE_ROOT_INDEX,"..",TREE_ADD_AS_CHILD,_pic_ftpcdup,_pic_ftpcdup,-1,0);   // Add the up-one-level ".."
   } else {
      _TreeAddItem(idx,"..",TREE_ADD_BEFORE,_pic_ftpcdup,_pic_ftpcdup,-1,0);
   }
   _RefreshRemoteDirFields();
   _TreeTop();

   return(0);
}

static ftpConnProfile_t *GetCurrentConnProfile()
{
   ftpConnProfile_t *fcp_p;

   fcp_p=0;
   profile=_ctl_profile.p_text;
   if( profile!="" && !_ftpCurrentConnections._isempty() && _ftpCurrentConnections._indexin(profile) ) {
      fcp_p=_ftpCurrentConnections._indexin(profile);
   }

   return(fcp_p);
}

static int _UpdateLocalSession()
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fake;   // Used when there is no current connection

   fcp_p=GetCurrentConnProfile();
   if( fcp_p ) {
      cwd=fcp_p->LocalCWD;
   } else {
      // There is no current connection, so fake one
      cwd=LOCALCWD;
      if( cwd=="" ) {
         cwd=getcwd();
         LOCALCWD=cwd;
      }
      _ftpInitConnProfile(fake);
      fake.LocalCWD=cwd;
      fake.LocalFileFilter=LOCALFILTER;
      fcp_p=&fake;
   }

   // Generate local directory list
   if( !_ctl_local_dir._RefreshLocalDir(fcp_p) ) {
      cwd=fcp_p->LocalCWD;
      LOCALCWD=cwd;
      gchangelocalcwd_allowed=false;
      status=_ctl_local_cwd.p_cb_list_box._lbsearch(cwd,_fpos_case);
      if( !status ) {
         _ctl_local_cwd.p_cb_list_box._lbselect_line();
         _ctl_local_cwd.p_cb_list_box._lbdelete_item();
      }
      // Add the directory to the top of the list box
      _ctl_local_cwd.p_cb_list_box._lbdeselect_line();
      _ctl_local_cwd.p_cb_list_box.p_line=0;
      _ctl_local_cwd.p_cb_list_box._lbadd_item(cwd);
      _ctl_local_cwd.p_text=cwd;
      /* Remember local current working directory history.
       * Must do this here because exiting the editor does not call a control's
       * ON_DESTROY event.
       */
      _append_retrieve(_ctl_local_cwd,_ctl_local_cwd.p_text);
      gchangelocalcwd_allowed=true;

#if !__UNIX__
      cwd=fcp_p->LocalCWD;
      gchangedrvlist_allowed=false;
      if( substr(cwd,1,2)=='\\' ) {
         // A UNC path is the local current working directory
         parse cwd with '\\' server '\' root '\' .;
         uncroot='\\':+server:+'\':+root;
         _ctl_local_drvlist._dvldrive(lowcase(uncroot));
      } else {
         drive=substr(cwd,1,2);
         _ctl_local_drvlist._dvldrive(lowcase(drive));
      }
      gchangedrvlist_allowed=true;
#endif
      return(0);
   }

   return(1);
}

void _ftpclientProgressCB(_str operation,int nofbytes,int total_nofbytes)
{
   int formWid,label1Wid,label2Wid,gaugeWid;
   _str caption;
   _str nofbytes_text,total_nofbytes_text;
   
   formWid=_find_object("_tbFTPClient_form","N");
   if( !formWid ) return;
   label1Wid=formWid._find_control("_ctl_progress_label1");
   if( !label1Wid ) return;
   label2Wid=formWid._find_control("_ctl_progress_label2");
   if( !label2Wid ) return;
   gaugeWid=formWid._find_control("_ctl_progress");
   if( !gaugeWid ) return;
   groupWid=formWid._find_control("_ctl_group1");
   if( !groupWid ) return;
   buttonWid=formWid._find_control("_ctl_abort");
   if( !buttonWid ) return;
   //say('nofbytes='nofbytes'  total_nofbytes='total_nofbytes);
   
   // Max the label widths
   max1_width= (buttonWid.p_x-groupWid.p_x)-2*_dx2lx(SM_TWIP,4);
   if( max1_width<0 ) max1_width=0;
   label1Wid.p_x=groupWid.p_x;
   label1Wid.p_width=max1_width;
   max2_width= (gaugeWid.p_x-groupWid.p_x)-2*_dx2lx(SM_TWIP,4);
   if( max2_width<0 ) max2_width=0;
   label2Wid.p_x=label1Wid.p_x;
   label2Wid.p_width=max2_width;
   
   label1_text=strip(operation);
   //label1_text="Really long long long long long long operation";
   if( nofbytes==total_nofbytes ) {
      label2_text="Complete";
      gaugeWid.p_value=100;
   } else if( nofbytes>=0 && total_nofbytes>0 && nofbytes<=total_nofbytes ) {
      nofbytes_text=nofbytes;
      if( nofbytes>1024 ) {
         nofbytes_text= nofbytes/1024;
         nofbytes_text=nofbytes_text:+"K";
      }
      if( total_nofbytes>1024 ) {
         total_nofbytes_text= total_nofbytes/1024;
         total_nofbytes_text=total_nofbytes_text:+"K";
      }
      label2_text=nofbytes_text:+" / ":+total_nofbytes_text;
      
      val= (int)(100*nofbytes/total_nofbytes);
      gaugeWid.p_value=val;
   } else {
      label2_text=nofbytes:+" bytes";
      gaugeWid.p_value=0;
   }
   
   #if 0
   progress_width=label1Wid._text_width(" ":+progress_text);
   caption_width=label1Wid._text_width(caption);
   if( caption_width>(max_width-progress_width) ) {
      // We have to shrink the caption
      caption=_ShrinkFilename(caption,max_width-progress_width);
   }
   #endif
   label1Wid.p_caption=label1_text;
   label2Wid.p_caption=label2_text;
   
   return;
}

void __ftpclientUpdateRemoteSessionCB(...)
{
   ftpQEvent_t event;
   RecvCmd_t rcmd;
   ftpConnProfile_t fcp;
   ftpConnProfile_t *fcp_p;

   event= *((ftpQEvent_t *)(arg(1)));
   rcmd= (RecvCmd_t)event.info[0];
   fcp=event.fcp;

   if( event.state==QS_ERROR || event.state==QS_ABORT || event.state==QS_ABORT_WAITING_FOR_REPLY ) {
      // Nothing to do
      return;
   }
   
   if( event.event==QE_PWD ) {
      /* We just printed the current working directory.
       * Now we must list its contents.
       */
       
      /*
      typedef struct RecvCmd_s {
         boolean pasv;
         _str cmdargv[];
         _str dest;
         _str datahost;
         _str dataport;
         int  size;
         pfnProgressCallback_tp ProgressCB;
      } RecvCmd_t;
      */
      fcp.PostedCB=__ftpclientUpdateRemoteSessionCB;
      pasv= (fcp.UseFW && fcp.Options.fwenable && fcp.Options.fwpasv );
      rcmd.pasv=pasv;
      cmdargv._makeempty();
      cmdargv[0]="LIST";
      if( fcp.ResolveLinks ) {
         cmdargv[cmdargv._length()]="-L";
      }
      rcmd.cmdargv=cmdargv;
      dest=mktemp();
      if( dest=="" ) {
         msg="Unable to create temp file for remote directory listing";
         _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
         return;
      }
      rcmd.dest=dest;
      datahost=dataport="";
      size=0;
      fcp.XferType=FTPXFER_ASCII;   // Always transfer listings ASCII
      rcmd.ProgressCB=_ftpclientProgressCB;
      _ftpEnQ(QE_RECV_CMD,QS_BEGIN,0,&fcp,rcmd);
      return;
   }
   
   status=_ftpCreateDir(&fcp,rcmd.dest);
   if( _ftpdebug&FTPDEBUG_SAVE_LIST ) {
      // Make a copy of the raw listing
      copy_file(rcmd.dest,'$list');
   }
   status2=delete_file(rcmd.dest);
   if( status2 && status2!=FILE_NOT_FOUND_RC && status2!=PATH_NOT_FOUND_RC ) {
      msg='Warning: Could not delete temp file "':+rcmd.dest:+'".  ':+_ftpGetMessage(status2);
      _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
   }
   if( status ) {
      formWid=_find_object("_tbFTPClient_form","N");
      if( !formWid ) return;
      noconnWid=formWid._find_control("_ctl_no_connection");
      if( noconnWid ) {
         noconnWid.p_caption="(No listing)";
      }
      msg="Could not create remote directory listing";
      _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return;
   }
   
   /* Find the matching connection profile in current connections
    * so we can update its stored remote directory listing.
    */
   fcp_p=0;
   for( i._makeempty();; ) {
      _ftpCurrentConnections._nextel(i);
      if( i._isempty() ) break;
      currentconn=_ftpCurrentConnections:[i];
      if( _ftpCurrentConnections:[i].ProfileName==fcp.ProfileName &&
          _ftpCurrentConnections:[i].Instance==fcp.Instance ) {
         // Found it
         fcp_p= &(_ftpCurrentConnections:[i]);
         break;
      }
   }
   if( !fcp_p ) {
      // We didn't find the matching connection profile, so bail out
      return;
   }
   fcp_p->RemoteDir=fcp.RemoteDir;

   formWid=_find_object("_tbFTPClient_form","N");
   if( !formWid ) return;
   if( _ftpclientFindAllControls(formWid,sstabWid,profileWid,localWid,remoteWid) ) {
      // This should never happen
      return;
   }
   remotecwdWid=formWid._find_control("_ctl_remote_cwd");
   if( !remotecwdWid ) return;
   noconnWid=formWid._find_control("_ctl_no_connection");
   if( !noconnWid ) return;
   logWid=formWid._find_control("_ctl_log");
   if( !logWid ) return;
   nologWid=formWid._find_control("_ctl_no_log");
   if( !nologWid ) return;
   
   if( !remoteWid._RefreshRemoteDir(fcp_p) ) {
      remoteWid.p_visible=true;
      remotecwdWid.p_visible=true;
      cwd=fcp_p->RemoteCWD;
      gchangeremotecwd_allowed=false;
      _ftpAddCwdHist(fcp_p->CwdHist,cwd);
      remotecwdWid.p_text=cwd;
      gchangeremotecwd_allowed=true;
   }
   noconnWid.p_visible= !remoteWid.p_visible;

   // Attach the current connection profile's log buffer to the "Log" tab
   if( fcp_p->LogBufName!="" ) {
      logWid.p_visible=true;
      nologWid.p_visible=false;
      logWid._AttachLog(fcp_p->LogBufName);
   } else {
      logWid.p_visible=false;
      nologWid.p_visible=true;
   }
   
   _MaybeUpdateFTPTab(profileWid.p_text);
   
   return;
}

/* Attach the current connection profile's directory listing, log buffer,etc.
 * Note: force=true means force a refresh of the current connection
 */
static void _UpdateRemoteSession(boolean force)
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fcp;

   fcp_p=GetCurrentConnProfile();
   if( fcp_p ) {
      
      if( force || fcp_p->RemoteDir._isempty() ) {
         fcp= *fcp_p;   // Make a copy
         fcp.PostedCB=__ftpclientUpdateRemoteSessionCB;
         _ftpEnQ(QE_PWD,QS_BEGIN,0,&fcp);
         return;
      }

      // Generate remote directory list
      if( !_ctl_remote_dir._RefreshRemoteDir(fcp_p) ) {
         _ctl_remote_dir.p_visible=true;
         _ctl_remote_cwd.p_visible=true;
         cwd=fcp_p->RemoteCWD;
         gchangeremotecwd_allowed=false;
         _ftpAddCwdHist(fcp_p->CwdHist,cwd);
         _ctl_remote_cwd.p_text=cwd;
         gchangeremotecwd_allowed=true;
      }
      _ctl_no_connection.p_visible= !_ctl_remote_dir.p_visible;

      // Attach the current connection profile's log buffer to the "Log" tab
      if( fcp_p->LogBufName!="" ) {
         _ctl_log.p_visible=true;
         _ctl_no_log.p_visible=false;
         _ctl_log._AttachLog(fcp_p->LogBufName);
      } else {
         _ctl_log.p_visible=false;
         _ctl_no_log.p_visible=true;
      }
      return;
   } else {
      _ctl_remote_dir.p_visible=false;
      _ctl_remote_cwd.p_visible=false;
      _ctl_no_connection.p_visible=true;
      _ctl_log.p_visible=false;
      _ctl_no_log.p_visible=true;
   }

   _MaybeUpdateFTPTab(_ctl_profile.p_text);
   
   return;
}

static void _UpdateSession(boolean force)
{
   _UpdateLocalSession();
   _UpdateRemoteSession(force);
}

void _ctl_profile.on_change(int reason)
{
   if( !gchangeprofile_allowed ) return;

   _ctl_profile._ChangeProfile();
   /* Remember current profile.
    * Must do this here because exiting the editor does not call a control's
    * ON_DESTROY event.
    */
   _append_retrieve(_ctl_profile,_ctl_profile.p_text);
   _ctl_profile._UpdateSession(false);

   return;
}

void __ftpclientConnectCB(...)
{
   ftpQEvent_t event;
   ftpConnProfile_t fcp;
   _str CwdHist[];

   event= *((ftpQEvent_t *)(arg(1)));

   fcp=event.fcp;
   fcp.PostedCB=0;   // Paranoid
   formWid=_find_object("_tbFTPClient_form","N");
   if( formWid ) {
      profileWid=formWid._find_control("_ctl_profile");
      label1Wid=formWid._find_control("_ctl_progress_label1");
      label2Wid=formWid._find_control("_ctl_progress_label2");
      progressWid=formWid._find_control("_ctl_progress");
   }
   
   if( event.state==QS_ERROR || event.state==QS_ABORT || event.state==QS_ABORT_WAITING_FOR_REPLY ) {
      if( event.event!=QE_CWD && event.event!=QE_PWD && event.event!=QE_SYST ) {
         label1Wid.p_caption="";
         label2Wid.p_caption="";
         progressWid.p_value=0;
         return;
      }
      /* The only thing that failed is:
       *   Changing directory, so use '/'
       *   OR
       *   Issuing the SYST command to get the operating system name
       */
      if( event.event==QE_CWD || event.event==QE_PWD ) {
         fcp.RemoteCWD="/";
      }
   }
   
   if( event.event==QE_CWD || event.event==QE_PWD ) {
      // Still need to get operating system name
      fcp.PostedCB=__ftpclientConnectCB;
      _ftpEnQ(QE_SYST,QS_BEGIN,0,&fcp);
      return;
   }
   
   // Now set the local current working direcotry
   cwd=fcp.DefLocalDir;
   cwd=strip(cwd);
   if( cwd=="" ) cwd=getcwd();
   if( last_char(cwd)==FILESEP ) cwd=substr(cwd,1,length(cwd)-1);
   isdir=isdirectory(maybe_quote_filename(cwd));
   if( (isdir=="" || isdir=="0") && !isuncdirectory(cwd) ) {
      // Not a valid local directory
      cwd=getcwd();
      _message_box("Warning: Unable to change to local directory:\n\n":+
                   fcp.DefLocalDir:+"\n\nThe local current working directory is:\n\n":+
                   cwd,"",MB_OK|MB_ICONEXCLAMATION);
   }
   fcp.LocalCWD=cwd;

   _ftpGetCwdHist(fcp.ProfileName,CwdHist);
   fcp.CwdHist=CwdHist;
   _ftpAddCurrentConnProfile(&fcp,htindex);

   if( !formWid ) {
      /* This could happen if user closes FTP Client toolbar in the middle
       * of the connection attempt.
       */
      return;
   }
   profileWid._FillProfiles(true);
   profileWid._ChangeProfile(htindex);
   formWid._UpdateSession(true);

   label1Wid.p_caption="Connected";
   label2Wid.p_caption="";
   progressWid.p_value=100;

   return;
}

void _ctl_connect.lbutton_up()
{
   ftpConnProfile_t fcp;

   fcp._makeempty();
   status=show("-modal _ftpProfileManager_form",&fcp);
   if( status ) {
      return;
   }

   _ctl_progress_label1.p_caption="Connecting...";
   _ctl_progress_label2.p_caption="";
   _ctl_progress.p_value=0;
   fcp.PostedCB= __ftpclientConnectCB;
   _ftpEnQ(QE_START_CONN_PROFILE,QS_BEGIN,0,&fcp);
   
   return;
}

void __ftpclientDisconnectCB(...)
{
   ftpQEvent_t event;

   event= *((ftpQEvent_t *)(arg(1)));

   _ftpDeleteLogBuffer(&event.fcp);   // Paranoid
   _ftpRemoveCurrentConnProfile(&event.fcp);
   
   formWid=_find_object("_tbFTPClient_form","N");
   if( !formWid ) {
      /* This could happen if user closes FTP Client toolbar in the middle
       * of the connection attempt.
       */
      return;
   }
   profileWid=formWid._find_control("_ctl_profile");
   label1Wid=formWid._find_control("_ctl_progress_label1");
   label2Wid=formWid._find_control("_ctl_progress_label2");
   gaugeWid=formWid._find_control("_ctl_progress");
   
   profileWid._FillProfiles(true);
   profileWid._ChangeProfile();
   
   if( formWid._ctl_profile.p_text=="" ) {
      // No more connections, so leave a final message
      label1Wid.p_caption="Disconnected";
      label2Wid.p_caption="";
      gaugeWid.p_value=0;
   } else {
      label1Wid.p_caption="";
      label2Wid.p_caption="";
      gaugeWid.p_value=0;
   }
   
   profileWid._UpdateSession(false);

   return;
}

void _ctl_disconnect.lbutton_up()
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fcp;

   fcp_p=GetCurrentConnProfile();
   if( fcp_p ) {
      _ftpSaveCwdHist(fcp_p->ProfileName,fcp_p->CwdHist);
      _ctl_progress_label1.p_caption="Disconnecting...";
      _ctl_progress_label2.p_caption="";
      _ctl_progress.p_value=0;
      fcp_p->PostedCB= __ftpclientDisconnectCB;
      _ftpEnQ(QE_END_CONN_PROFILE,QS_BEGIN,0,fcp_p);
      return;
   }
   _ctl_profile._ChangeProfile();
   _ctl_profile._UpdateSession(false);

   return;
}

static void _UpdateFTPTabXferType()
{
   ftpConnProfile_t *fcp_p;
   int formWid;
   int asciiWid;
   int binWid;
   int xfer_type;
   
   formWid=_find_object("_tbFTPClient_form","N");
   if( !formWid ) return;
   fcp_p=formWid.GetCurrentConnProfile();
   if( !fcp_p ) return;
   profileWid=formWid._find_control("_ctl_profile");
   if( !profileWid ) return;
   thisprofile=profileWid.p_text;
   
   formWid=_find_object("_tbproject_form","N");
   if( !formWid ) return;
   profileWid=formWid._find_control("_ctl_profile");
   if( !profileWid ) return;
   
   if( thisprofile!=profileWid.p_text ) return;
   
   xfer_type=fcp_p->XferType;   // This had better match what is displayed
   
   asciiWid=formWid._find_control("_ctl_ascii");
   if( !asciiWid ) return;   // This should never happen
   binWid=formWid._find_control("_ctl_binary");
   if( !binWid ) return;   // This should never happen
   asciiWid.p_value=binWid.p_value=0;
   if( xfer_type==FTPXFER_ASCII ) {
      asciiWid.p_value=1;
      binWid.p_value=0;
   } else if( xfer_type==FTPXFER_BINARY ) {
      asciiWid.p_value=0;
      binWid.p_value=1;
   }
   
   return;
}

void _ctl_ascii.lbutton_up()
{
   ftpConnProfile_t *fcp_p;

   // Both ASCII and Binary cannot be on at the same time
   _ctl_binary.p_value= (int)(p_value==0);

   fcp_p=GetCurrentConnProfile();
   if( fcp_p ) {
      if( p_value ) {
         fcp_p->XferType=FTPXFER_ASCII;
      } else {
         fcp_p->XferType=FTPXFER_BINARY;
      }
   }
   
   _UpdateFTPTabXferType();

   return;
}

void _ctl_binary.lbutton_up()
{
   ftpConnProfile_t *fcp_p;

   // Both ASCII and Binary cannot be on at the same time
   _ctl_ascii.p_value= (int)(p_value==0);

   fcp_p=GetCurrentConnProfile();
   if( fcp_p ) {
      if( p_value ) {
         fcp_p->XferType=FTPXFER_BINARY;
      } else {
         fcp_p->XferType=FTPXFER_ASCII;
      }
   }

   _UpdateFTPTabXferType();
   
   return;
}

void __ftpclientAbortCB(...)
{
   ftpQEvent_t event;
   ftpConnProfile_t fcp;

   event= *((ftpQEvent_t *)(arg(1)));

   fcp=event.fcp;
   if( event.state!=QS_ERROR ) {
      formWid=_find_object("_tbFTPClient_form","N");
      if( !formWid ) return;
      label1Wid=formWid._find_control("_ctl_progress_label1");
      if( !label1Wid ) return;
      label2Wid=formWid._find_control("_ctl_progress_label2");
      if( !label2Wid ) return;
      progressWid=formWid._find_control("_ctl_progress");
      if( !progressWid ) return;
      label1Wid.p_caption="Aborted";
      label2Wid.p_caption="";
      progressWid.p_value=0;
   }

   return;
}

void _ctl_abort.lbutton_up()
{
   ftpQEvent_t event;
   
   if( _ftpQ._length()<1 ) return;
   event=_ftpQ[0];
   
   /* Find all events in the queue that match this one and delete them.
    */
   for( i=0;i<_ftpQ._length();++i ) {
      if( _ftpQ[i].event==event.event ) {
         _ftpQ._deleteel(i);
      }
   }
   
   if( event.state==QS_ABORT_WAITING_FOR_REPLY ) {
      // The user wants to abort the abort
      return;
   }
   
   /* We queue it this way because the original event might have had
    * optional data in the info field that we don't want to lose.
    */
   event.state=QS_ABORT;
   event.start=0;
   _ctl_progress_label1.p_caption="Aborting...";
   _ctl_progress_label2.p_caption="";
   _ctl_progress.p_value=0;
   event.fcp.PostedCB=__ftpclientAbortCB;
   _ftpQ[0]=event;
   
   return;
}

static int _ftpclientFindAllControls(int formWid,
                                     int &sstabWid,
                                     int &profilecbWid,
                                     int &localtreeWid,
                                     int &remotetreeWid)
{
   sstabWid=formWid._find_control("_ctl_ftp_sstab");
   if( !sstabWid ) return(1);
   profilecbWid=formWid._find_control("_ctl_profile");
   if( !profilecbWid ) return(1);
   localtreeWid=sstabWid._find_control("_ctl_local_dir");
   if( !localtreeWid ) return(1);
   remotetreeWid=sstabWid._find_control("_ctl_remote_dir");
   if( !remotetreeWid ) return(1);

   return(0);
}

#if 0
static void _CreateLocalDir(ftpFile_t &files[],_str path)
{
   files._makeempty();
   filespec=path;
   if( filespec!="" ) {
      filespec=filespec:+FILESEP;
   }
   filespec=filespec:+ALLFILES_RE;
   line=file_match('+DV ':+maybe_quote_filename(filespec),1);
   while( filename!="" ) {
      file.filename=substr(line,DIR_FILE_COL);
      if( file.filename=="." || file.filename==".." ) {
         line=file_match('+DV ':+maybe_quote_filename(filespec),0);
         continue;
      }
      file.attribs=substr(line,DIR_ATTR_COL,DIR_ATTR_WIDTH);
      date=substr(line,DIR_DATE_COL,DIR_DATE_WIDTH);
      parse date with month '-' day '-' year;
      file.month=month;
      file.day= (int)day;
      file.year= (int)year;
      file.time=substr(line,DIR_TIME_COL,DIR_TIME_WIDTH);
      size=substr(line,DIR_SIZE_COL,DIR_SIZE_WIDTH);
      file.type=0;
      if( size=="<DIR>" ) {
         file.type=FTPFILETYPE_DIR;
         size=0;
      }
      file.size= (int)size;
      file.group="";
      file.owner="";
      file.refs=0;
      files[files._length()]=file;
      
      line=file_match('+DV ':+maybe_quote_filename(filespec),0);
   }
   
   return;
}
#endif

void __ftpclientUploadCB(...)
{
   ftpQEvent_t event;
   ftpConnProfile_t fcp;
   SendCmd_t scmd;
   int formWid;

   event= *((ftpQEvent_t *)(arg(1)));
   fcp=event.fcp;
   fcp.PostedCB=0;

   if( event.state==QS_ERROR || event.state==QS_ABORT || event.state==QS_ABORT_WAITING_FOR_REPLY ) {
      // Nothing to do
      return;
   }
   
   idx=_ftpTodoFindNext();
   while( idx>0 ) {
      _ftpTodoGetCaption(caption);
      parse caption with filename "\t" .;
      if( filename==".." ) {
         idx=_ftpTodoFindNext();
         continue;
      } else {
         fcp.PostedCB=__ftpclientUploadCB;
         _ftpTodoGetUserInfo(info);
         info=lowcase(info);
         if( info=="f" ) {
            // File
            _str cmdargv[];
            cmdargv._makeempty();
            cmdargv[0]="STOR";
            cmdargv[1]=_ftpUploadCase(&fcp,filename);
            scmd.cmdargv=cmdargv;
            scmd.datahost=scmd.dataport="";
            src=fcp.LocalCWD;
            if( last_char(src)!=FILESEP ) src=src:+FILESEP;
            src=src:+filename;
            // Double check to see if exists and to get size for progress gauge
            line=file_match('-P +V ':+maybe_quote_filename(src),1);
            if( line=="" ) {
               _message_box("The following file does not exist:\n\n":+src,
                            FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
               return;
               
            }
            scmd.src=src;
            size=substr(line,DIR_SIZE_COL,DIR_SIZE_WIDTH);
            if( !isinteger(size) ) {
               // This should never happen
               size=0;
            }
            scmd.size= (int)size;
            scmd.pasv= (fcp.UseFW && fcp.Options.fwenable && fcp.Options.fwpasv);
            scmd.ProgressCB=_ftpclientProgressCB;
            _ftpEnQ(QE_SEND_CMD,QS_BEGIN,0,&fcp,scmd);
         } else if( pos("d",info) ) {
            // Directory
            _ftpEnQ(QE_MKD,QS_BEGIN,0,&fcp,filename);
         }
         return;
      }
   }
   formWid=_find_object("_tbFTPClient_form","N");
   if( formWid ) {
      formWid._UpdateRemoteSession(true);
   }
   
   return;
}

_command void ftpclientUpload() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   ftpConnProfile_t *fcp_p;
   int formWid;

   formWid=_find_object("_tbFTPClient_form","N");
   if( !formWid ) return;
   if( _ftpclientFindAllControls(formWid,sstabWid,profileWid,localWid,remoteWid) ) return;
   fcp_p=formWid.GetCurrentConnProfile();
   if( !fcp_p ) return;
   _ftpTodoGetList(localWid);
   idx=_ftpTodoFindNext();
   while( idx>0 ) {
      _ftpTodoGetCaption(caption);
      parse caption with filename "\t" .;
      if( filename==".." ) {
         idx=_ftpTodoFindNext();
         continue;
      } else {
         ftpConnProfile_t fcp;
         fcp= *fcp_p;   // Make a copy
         fcp.PostedCB=__ftpclientUploadCB;
         _ftpTodoGetUserInfo(info);
         info=lowcase(info);
         if( info=="f" ) {
            // File
            SendCmd_t scmd;
            _str cmdargv[];
            cmdargv._makeempty();
            cmdargv[0]="STOR";
            cmdargv[1]=_ftpUploadCase(&fcp,filename);
            scmd.cmdargv=cmdargv;
            scmd.datahost=scmd.dataport="";
            src=fcp.LocalCWD;
            if( last_char(src)!=FILESEP ) src=src:+FILESEP;
            src=src:+filename;
            // Double check to see if exists and to get size for progress gauge
            line=file_match('-P +V ':+maybe_quote_filename(src),1);
            if( line=="" ) {
               _message_box("The following file does not exist:\n\n":+src,
                            FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
               return;
               
            }
            scmd.src=src;
            size=substr(line,DIR_SIZE_COL,DIR_SIZE_WIDTH);
            if( !isinteger(size) ) {
               // This should never happen
               size=0;
            }
            scmd.size= (int)size;
            scmd.pasv= (fcp.UseFW && fcp.Options.fwenable && fcp.Options.fwpasv);
            scmd.ProgressCB=_ftpclientProgressCB;
            _ftpEnQ(QE_SEND_CMD,QS_BEGIN,0,&fcp,scmd);
         } else if( pos("d",info) ) {
            // Directory
            _ftpEnQ(QE_MKD,QS_BEGIN,0,&fcp,filename);
         }
         return;
      }
      idx=_ftpTodoFindNext();
   }

   return;
}

_command void ftpclientOpenLocalFile() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fake;
   int formWid;

   formWid=_find_object("_tbFTPClient_form","N");
   if( !formWid ) return;
   if( _ftpclientFindAllControls(formWid,sstabWid,profileWid,localWid,remoteWid) ) return;
   fcp_p=formWid.GetCurrentConnProfile();
   if( !fcp_p ) {
      // We have no current connection, so fake one
      _ftpInitConnProfile(fake);
      fake.LocalCWD=LOCALCWD;
      fake.LocalFileFilter=LOCALFILTER;
      fcp_p=&fake;
   }
   localWid._TreeGetSelInfo(nofselected,firstidx,lastidx);
   if( !nofselected ) return;
   mou_hour_glass(1);
   idx=localWid._TreeFindSelected(1);
   while( idx>=0 ) {
      caption=localWid._TreeGetCaption(idx);
      parse caption with filename "\t" .;
      if( filename==".." ) {
         idx=localWid._TreeFindSelected(0);
         continue;
      } else {
         info=localWid._TreeGetUserInfo(idx);
         info=lowcase(info);
         if( info=="f" ) {
            // We have a file so open it
            cwd=fcp_p->LocalCWD;
            if( last_char(cwd)!=FILESEP ) cwd=cwd:+FILESEP;
            path=cwd:+filename;
            status=edit(maybe_quote_filename(path));
            if( status ) {
               msg='Error opening file "':+filename:+'".  ':+_ftpGetMessage(status);
               _message_box(msg,"",MB_OK|MB_ICONEXCLAMATION);
               break;
            }
         } else if( pos("d",info) ) {
            // Directory
            idx=localWid._TreeFindSelected(0);
            continue;
         }
      }
      idx=localWid._TreeFindSelected(0);
   }
   refresh();

   return;
}

_command void ftpclientViewLocalFile() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fake;
   int formWid;

   formWid=_find_object("_tbFTPClient_form","N");
   if( !formWid ) return;
   if( _ftpclientFindAllControls(formWid,sstabWid,profileWid,localWid,remoteWid) ) return;
   fcp_p=formWid.GetCurrentConnProfile();
   if( !fcp_p ) {
      // We have no current connection, so fake one
      _ftpInitConnProfile(fake);
      fake.LocalCWD=LOCALCWD;
      fake.LocalFileFilter=LOCALFILTER;
      fcp_p=&fake;
   }
   localWid._TreeGetSelInfo(nofselected,firstidx,lastidx);
   if( !nofselected ) return;
   mou_hour_glass(1);
   idx=localWid._TreeFindSelected(1);
   while( idx>=0 ) {
      caption=localWid._TreeGetCaption(idx);
      parse caption with filename "\t" .;
      if( filename==".." ) {
         idx=localWid._TreeFindSelected(0);
         continue;
      } else {
         info=localWid._TreeGetUserInfo(idx);
         info=lowcase(info);
         if( info=="f" ) {
            // We have a file so open it
            cwd=fcp_p->LocalCWD;
            if( last_char(cwd)!=FILESEP ) cwd=cwd:+FILESEP;
            path=cwd:+filename;
            status=NTShellExecute("open",path,"","");
            if( status<=32 ) {
               msg='Error viewing file "':+filename
               _message_box(msg,"",MB_OK|MB_ICONEXCLAMATION);
               break;
            }
         } else if( pos("d",info) ) {
            // Directory
            idx=localWid._TreeFindSelected(0);
            continue;
         }
      }
      idx=localWid._TreeFindSelected(0);
   }
   refresh();

   return;
}

_command void ftpclientChangeLocalDir() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fake;   // Used when there is no connection
   int formWid;

   formWid=_find_object("_tbFTPClient_form","N");
   if( !formWid ) return;
   cwd=arg(1);
   if( cwd=="" ) {
      // Prompt for the local directory
      result=show("-modal _textbox_form","Change local directory",0,"","?Type the local directory you would like to change to","","","Directory");
      if( result=="" ) {
         // User cancelled
         return;
      }
      cwd=strip(_param1);
      if( cwd=="" ) return;
   }
   fcp_p=GetCurrentConnProfile();
   if( !fcp_p ) {
      // There is currently no connection, so make a fake connection profile
      _ftpInitConnProfile(fake);
      fake.LocalCWD=LOCALCWD;
      if( fake.LocalCWD=="" ) {
         fake.LocalCWD=getcwd();
      }
      fake.LocalFileFilter=LOCALFILTER;
      fcp_p=&fake;
   }
   #if __UNIX__
   if( substr(cwd,1,1)!=FILESEP ) {
      // Relative to local current working directory
      path=fcp_p->LocalCWD;
      if( last_char(path)!=FILESEP ) {
         path=path:+FILESEP;
      }
      cwd=path:+cwd;
   }
   #else
   drive=substr(cwd,1,2);
   if( !isdrive(drive) && drive!='\\' ) {
      // Relative to local current working directory
      path=fcp_p->LocalCWD;
      if( last_char(path)!=FILESEP ) {
         path=path:+FILESEP;
      }
      cwd=path:+cwd;
   }
   #endif
   orig_cwd=cwd;
   cwd=isdirectory(maybe_quote_filename(cwd),1);   // Resolve
   if( (cwd=="" || cwd=="0") && !isuncdirectory(orig_cwd) ) {
      _message_box("Unable to change the local working directory",
                   "",MB_OK|MB_ICONEXCLAMATION);
      return;
   }
   old_LocalCWD=fcp_p->LocalCWD;
   LOCALCWD=cwd;
   fcp_p->LocalCWD=cwd;
   mou_hour_glass(1);
   if( _UpdateLocalSession() ) {
      LOCALCWD=old_LocalCWD;
      fcp_p->LocalCWD=old_LocalCWD;
   }

   return;
}

_command void ftpclientMkLocalDir() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fake;   // Used when there is no connection
   int formWid;

   formWid=_find_object("_tbFTPClient_form","N");
   if( !formWid ) return;
   path=arg(1);
   if( path=="" ) {
      // Prompt for the local directory to make
      result=show("-modal _textbox_form","Make local directory",0,"","?Type the local directory you would like to make","","","Directory");
      if( result=="" ) {
         // User cancelled
         return;
      }
      path=_param1;
      if( path=="" ) return;
   }
   fcp_p=formWid.GetCurrentConnProfile();
   if( !fcp_p ) {
      // There is no connection, so fake it
      _ftpInitConnProfile(fake);
      fake.LocalCWD=LOCALCWD;
      fake.LocalFileFilter=LOCALFILTER;
      fcp_p=&fake;
   }
   // This test is ok under UNIX
   if( !isdrive(substr(path,1,2)) && substr(path,1,2)!='\\' ) {
      // We have a relative path, so make it absolute
      cwd=fcp_p->LocalCWD;
      if( last_char(cwd)!=FILESEP ) cwd=cwd:+FILESEP;
      #if __UNIX__
      if( substr(path,1,1)!=FILESEP ) {
         path=cwd:+path;
      }
      #else
      if( substr(path,1,1)==FILESEP ) {
         // Relative to the current drive
         if( substr(cwd,1,2)=='\\' ) {
            // UNC path
            parse cwd with '\\' server '\' share '\';
            path='\\':+server:+'\':+share:+path;
         } else {
            drive=substr(cwd,1,2);
            path=drive:+path;
         }
      } else {
         path=cwd:+path;
      }
      #endif
   }
   mou_hour_glass(1);
   status=make_path(path);
   if( status ) {
      _message_box("Unable to make local working directory.  ":+_ftpGetMessage(status),
                   "",MB_OK|MB_ICONEXCLAMATION);
      return;
   }
   _UpdateLocalSession();

   return;
}

_command void ftpclientDelLocalFile() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fake;   // When we have no remote connection
   int formWid;

   formWid=_find_object("_tbFTPClient_form","N");
   if( !formWid ) return;
   if( _ftpclientFindAllControls(formWid,sstabWid,profileWid,localWid,remoteWid) ) return;
   fcp_p=formWid.GetCurrentConnProfile();
   if( !fcp_p ) {
      // We have no current connection, so fake one
      _ftpInitConnProfile(fake);
      fake.LocalCWD=LOCALCWD;
      fake.LocalFileFilter=LOCALFILTER;
      fcp_p=&fake;
   }
   localWid._TreeGetSelInfo(nofselected,firstidx,lastidx);
   if( !nofselected ) return;
   status=_message_box("Delete ":+nofselected:+" files/directories?","FTP",MB_YESNO|MB_ICONQUESTION);
   if( status!=IDYES ) return;
   mou_hour_glass(1);
   idx=localWid._TreeFindSelected(1);
   while( idx>=0 ) {
      caption=localWid._TreeGetCaption(idx);
      parse caption with filename "\t" .;
      if( filename==".." ) {
         idx=localWid._TreeFindSelected(0);
         continue;
      } else {
         info=localWid._TreeGetUserInfo(idx);
         info=lowcase(info);
         if( info=="f" ) {
            // We have a file so delete it
            cwd=fcp_p->LocalCWD;
            if( last_char(cwd)!=FILESEP ) cwd=cwd:+FILESEP;
            path=cwd:+filename;
            status=delete_file(path);
            if( status ) {
               msg='Error deleting file "':+filename:+'".  ':+_ftpGetMessage(status);
               _message_box(msg,"",MB_OK|MB_ICONEXCLAMATION);
               break;
            }
         } else if( pos("d",info) ) {
            // We have a directory so recursively delete it and its contents
            cwd=fcp_p->LocalCWD;
            if( last_char(cwd)!=FILESEP ) cwd=cwd:+FILESEP;
            path=cwd:+filename;
            status=rmdir(path);
            if( status ) {
               msg='Error removing directory "':+filename:+'"';
               if( status==PATH_NOT_FOUND_RC && (isdirectory(maybe_quote_filename(path)) || isuncdirectory(path)) ) {
                  // I wish rmdir() returned a better rc in this case
                  msg=msg:+".  Directory not empty";
               } else {
                  msg=msg:+".  ":+_ftpGetMessage(status);
               }
               _message_box(msg,"",MB_OK|MB_ICONEXCLAMATION);
               break;
            }
         }
      }
      idx=localWid._TreeFindSelected(0);
   }
   formWid._UpdateLocalSession();

   return;
}

_command void ftpclientRenameLocalFile() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fake;
   int formWid;

   formWid=_find_object("_tbFTPClient_form","N");
   if( !formWid ) return;
   if( _ftpclientFindAllControls(formWid,sstabWid,profileWid,localWid,remoteWid) ) return;
   fcp_p=formWid.GetCurrentConnProfile();
   if( !fcp_p ) {
      // There is currently no connection, so make a fake connection profile
      _ftpInitConnProfile(fake);
      fake.LocalCWD=LOCALCWD;
      fake.LocalFileFilter=LOCALFILTER;
      fcp_p=&fake;
   }
   localWid._TreeGetSelInfo(nofselected,firstidx,lastidx);
   if( !nofselected || nofselected>1 ) return;
   idx=localWid._TreeCurIndex();
   if( idx<0 ) return;
   caption=localWid._TreeGetCaption(idx);
   parse caption with rnfr "\t" .;
   if( rnfr==".." ) {
      return;
   } else {
      local_path=fcp_p->LocalCWD;
      if( last_char(local_path)!=FILESEP ) local_path:+FILESEP;
      rnfr=local_path:+rnfr;
      status=show("-modal _textbox_form","Rename ":+rnfr:+" to...",0,"","?Specify a filename to rename to","","","Rename to:":+rnfr);
      if( status=="" ) {
         // User cancelled
         return;
      }
      rnto=_param1;
      if( rnto=="" ) {
         return;
      }
      /* If the user did not give an absolute path, then assume it is
       * relative to the local current working directory of the current
       * session.
       */
      #if __UNIX__
      if( substr(rnto,1,1)!=FILESEP ) {
         rnto=local_path:+rnto;
      }
      #else
      if( substr(rnto,1,1)==FILESEP ) {
         // Assume relative to current drive
         drive=_ctl_local_drvlist.p_text;
         if( drive=="" ) {
            // This should never happen
            _message_box("No relative drive!",FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
            return;
         }
         rnto=drive:+rnto;
      } else if( !isdrive(substr(rnto,1,2)) && substr(rnto,1,2)!='\\' ) {
         rnto=local_path:+rnto;
      }
      #endif
      rnto_dir=strip_filename(rnto,'N');
      rnto_filename=strip_filename(rnto,'P');
      orig_rnto_dir=rnto_dir;
      rnto_dir=isdirectory(rnto_dir);
      if( rnto_dir=="" || rnto_dir=="0" ) {
         _message_box("Directory:\n\n":+orig_rnto_dir:+"\n\nDoes not exist!",FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
         return;
      }
      if( last_char(rnto_dir)!=FILESEP ) rnto_dir=rnto_dir:+FILESEP;
      rnto=rnto_dir:+rnto_filename;
      //_message_box("rnfr="rnfr"\n\nrnto="rnto);
      status=_file_move(rnto,rnfr);
      if( status ) {
         _message_box('Failed to rename "':+rnfr:+'".  ':+_ftpGetMessage(status),FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
         return;
      }
      _UpdateLocalSession();
      return;
   }
   
   return;
}

_command void ftpclientLocalHScrollbar() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   int formWid;
   
   formWid=_find_object("_tbFTPClient_form","N");
   if( !formWid ) return;
   if( _ftpclientFindAllControls(formWid,sstabWid,profileWid,localWid,remoteWid) ) return;
   scroll_bars=localWid.p_scroll_bars;
   if( scroll_bars&SB_HORIZONTAL ) {
      // Turn horizontal scroll bar OFF, turn popup ON
      localWid.p_scroll_bars &= ~(SB_HORIZONTAL);
      localWid.p_delay=0;
   } else {
      // Turn horizontal scroll bar ON, turn popup OFF
      localWid.p_scroll_bars |= SB_HORIZONTAL;
      localWid.p_delay= -1;
   }
   /* Remember horizontal scroll bar settings.
    * Must do this here because exiting the editor does not call a control's
    * ON_DESTROY event.
    */
   _append_retrieve(0,_ctl_local_dir.p_scroll_bars,"_tbFTPClient_form._ctl_local_dir.p_scroll_bars");
   
   return;
}

_command void ftpclientRefreshLocalSession() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   int formWid;
   
   formWid=_find_object("_tbFTPClient_form","N");
   if( !formWid ) return;
   formWid._UpdateLocalSession();

   return;
}

_command void ftpclientLocalFilter() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   ftpConnProfile_t *fcp_p;
   int formWid;
   
   formWid=_find_object("_tbFTPClient_form","N");
   if( !formWid ) return;
   filter=LOCALFILTER;
   if( filter=="" ) filter=ALLFILES_RE;
   status=show("-modal _textbox_form","Local file filter",TB_RETRIEVE|TB_RETRIEVE_INIT,"","?Specify the file filter for file listings. Separate multiple filters with a space.\n\nExample: *.html *.shtml","","ftpFilter","Filter:":+filter);
   if( status=="" ) {
      // User cancelled
      return;
   }
   filter=_param1;
   if( filter=="" ) return;
   fcp_p=formWid.GetCurrentConnProfile();
   LOCALFILTER=filter;
   if( fcp_p ) {
      fcp_p->LocalFileFilter=filter;
   }
   formWid._UpdateLocalSession();

   return;
}

#if 1
static boolean __DownloadLinks=false;
void __ftpclientDownloadCB(...)
{
   ftpQEvent_t event;
   ftpConnProfile_t fcp;
   SendCmd_t scmd;
   ftpFile_t file;
   ftpFile_t files[];
   ftpFile_t next_file;
   int formWid;

   event= *((ftpQEvent_t *)(arg(1)));
   fcp=event.fcp;
   fcp.PostedCB=0;
   
   if( event.state==QS_ERROR || event.state==QS_ABORT || event.state==QS_ABORT_WAITING_FOR_REPLY ) {
      // Nothing to do
      return;
   }
   
   idx=_ftpTodoFindNext();
   //say('_ftpTodoFindNext - idx='idx);
   while( idx>0 ) {
      _ftpTodoGetCaption(caption);
      parse caption with filename "\t" .;
      if( filename==".." ) {
         idx=_ftpTodoFindNext();
         continue;
      } else {
         _ftpTodoGetUserInfo(info);
         info=lowcase(info);
         if( info=="f" || (__DownloadLinks && pos("l",info)) ) {
            // File
            fcp.PostedCB=__ftpclientDownloadCB;
            RecvCmd_t rcmd;
            _str cmdargv[];
            cmdargv._makeempty();
            cmdargv[0]="RETR";
            cmdargv[1]=filename;
            rcmd.cmdargv=cmdargv;
            rcmd.datahost=rcmd.dataport="";
            dest=fcp.LocalCWD;
            if( last_char(dest)!=FILESEP ) dest=dest:+FILESEP;
            dest=dest:+filename;
            rcmd.dest=dest;
            rcmd.pasv= (fcp.UseFW && fcp.Options.fwenable && fcp.Options.fwpasv);
            rcmd.ProgressCB=_ftpclientProgressCB;
            rcmd.size=0;
            _ftpEnQ(QE_RECV_CMD,QS_BEGIN,0,&fcp,rcmd);
            return;
         } else if( pos("d",info) ) {
            // Directory
            local_path=fcp.LocalCWD;
            if( last_char(local_path)!=FILESEP ) local_path=local_path:+FILESEP;
            local_path=local_path:+filename;
            path=isdirectory(maybe_quote_filename(local_path));
            if( path=="" || path=="0" ) {
               status=make_path(local_path);
               if( status ) {
                  msg='Unable to create local directory "':+local_path:+'".  ':+
                      _ftpGetMessage(status);
                  _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
                  return;
               }
            }
         }
      }
      idx=_ftpTodoFindNext();
   }
   formWid=_find_object("_tbFTPClient_form","N");
   if( formWid ) {
      formWid._UpdateLocalSession();
   }
   
   return;
}

_command void ftpclientDownload(...) name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fcp;
   boolean download_links;   // Download folder links as files?
   int formWid;

   formWid=_find_object("_tbFTPClient_form","N");
   if( !formWid ) return;
   if( _ftpclientFindAllControls(formWid,sstabWid,profileWid,localWid,remoteWid) ) return;
   fcp_p=formWid.GetCurrentConnProfile();
   if( !fcp_p ) return;
   __DownloadLinks= (arg(1)!="" && arg(1));
   _ftpTodoGetList(remoteWid);
   idx=_ftpTodoFindNext();
   while( idx>0 ) {
      _ftpTodoGetCaption(caption);
      parse caption with filename "\t" .;
      if( filename==".." ) {
         idx=_ftpTodoFindNext();
         continue;
      } else {
         _ftpTodoGetUserInfo(info);
         info=lowcase(info);
         fcp= *fcp_p;   // Make a copy
         fcp.PostedCB=0;
         if( info=="f" || (__DownloadLinks && pos("l",info)) ) {
            // File
            fcp.PostedCB=__ftpclientDownloadCB;
            RecvCmd_t rcmd;
            _str cmdargv[];
            cmdargv._makeempty();
            cmdargv[0]="RETR";
            cmdargv[1]=filename;
            rcmd.cmdargv=cmdargv;
            rcmd.datahost=rcmd.dataport="";
            dest=fcp.LocalCWD;
            if( last_char(dest)!=FILESEP ) dest=dest:+FILESEP;
            dest=dest:+filename;
            rcmd.dest=dest;
            rcmd.pasv= (fcp.UseFW && fcp.Options.fwenable && fcp.Options.fwpasv);
            rcmd.ProgressCB=_ftpclientProgressCB;
            rcmd.size=0;
            _ftpEnQ(QE_RECV_CMD,QS_BEGIN,0,&fcp,rcmd);
            return;
         } else if( pos("d",info) ) {
            // Directory
            local_path=fcp.LocalCWD;
            if( last_char(local_path)!=FILESEP ) local_path=local_path:+FILESEP;
            local_path=local_path:+filename;
            path=isdirectory(maybe_quote_filename(local_path));
            if( path=="" || path=="0" ) {
               status=make_path(local_path);
               if( status ) {
                  msg='Unable to create local directory "':+local_path:+'".  ':+
                      _ftpGetMessage(status);
                  _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
                  return;
               }
            }
         }
      }
      idx=_ftpTodoFindNext();
   }
   formWid._UpdateLocalSession();

   return;
}

_command void ftpclientDownloadLinks() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   ftpclientDownload(1);
}

#else
typedef struct __dirstackEntry_s {
   _str LocalCWD;
   _str RemoteCWD;
   _str last_filename;
   ftpFile_t remote_files[];
   ftpFile_t local_files[];   // Used when uploading
} __dirstackEntry_t;
static __dirstackEntry_t dirstack[];
void __ftpclientDownload2CB(...);
void __ftpclientDownload1CB(...)
{
   ftpQEvent_t event;
   ftpConnProfile_t fcp;
   RecvCmd_t rcmd;
   ftpFile_t files[];
   ftpFile_t next_file;

   event= *((ftpQEvent_t *)(arg(1)));
   fcp=event.fcp;
   fcp.PostedCB=0;

   if( event.state==QS_ERROR ) {
      /* Something went wrong, so attempt to put everything back to the
       * way it was.
       */
      tos=dirstack._length()-1;
      if( tos>=0 ) {
         old_LocalCWD=dirstack[0].LocalCWD;
         old_RemoteCWD=dirstack[0].RemoteCWD;
         dirstack._makeempty();
         fcp.LocalCWD=old_LocalCWD;
         if( old_RemoteCWD!=fcp.RemoteCWD ) {
            _ftpEnQ(QE_CWD,QS_BEGIN,0,&fcp,old_RemoteCWD);
            return;
         }
      }
      return;
   } else if( event.state==QS_ABORT || event.state==QS_ABORT || event.state==QS_ABORT_WAITING_FOR_REPLY ) {
      return;
   }
   
   next_file._makeempty();
   tos=dirstack._length()-1;
   if( tos>0 ) {   // Remember: The first stack entry is fake
      // Find the next file at this level
      files=dirstack[tos].remote_files;
      last_filename=dirstack[tos].last_filename;
      if( last_filename=="" ) {
         // Take the first file
         next_file=files[0];
      } else {
         for( i=0;i<files._length();++i ) {
            if( files[i].filename==last_filename ) {
               if( files[i+1]._isempty() ) break;
               next_file=files[i+1];
               break;
            }
         }
      }
   }
   if( next_file._isempty() ) {
      /* We processed the last file for this directory.
       * Pop back to the previous directory and continue processing
       * where we left off at that level.
       */
      tos=dirstack._length()-1;
      if( tos==0 ) {   // Remember: The first stack entry is fake
         /* We are done.
          * Find the next selected file/directory.
          */
         ftpConnProfile_t *fcp_p;
         formWid=_find_object("_tbFTPClient_form","N");
         if( !formWid ) return;   // This should never happen
         if( _ftpclientFindAllControls(formWid,sstabWid,profileWid,localWid,remoteWid) ) {
            return;
         }
         fcp_p=formWid.GetCurrentConnProfile();
         if( !fcp_p ) {
            // This should never happen
            return;
         }
         fcp= *fcp_p;   // Make a copy
         fcp.PostedCB=0;
         remoteWid._TreeGetSelInfo(nofselected,firstidx,lastidx);
         if( !nofselected ) {
            /* This could happen if the user docked/undocked/killed
             * the FTP Client toolbar in the middle of transferring.
             */
            dirstack._makeempty();
            formWid._UpdateLocalSession();
            return;
         }
         idx=_ftpTodoFindNext();
         while( idx>0 ) {
            _ftpTodoGetCaption(caption);
            parse caption with filename "\t" .;
            if( filename!=".." ) {
               _ftpTodoGetUserInfo(info);
               info=lowcase(info);
               if( info=="f" ) {
                  // File
                  fcp.PostedCB=__ftpclientDownload1CB;
                  RecvCmd_t rcmd;
                  _str cmdargv[];
                  cmdargv._makeempty();
                  cmdargv[0]="RETR";
                  cmdargv[1]=filename;
                  rcmd.cmdargv=cmdargv;
                  rcmd.datahost=rcmd.dataport="";
                  dest=fcp_p->LocalCWD;
                  if( last_char(dest)!=FILESEP ) dest=dest:+FILESEP;
                  dest=dest:+filename;
                  rcmd.dest=dest;
                  rcmd.pasv= (fcp.UseFW && fcp.Options.fwenable && fcp.Options.fwpasv);
                  rcmd.ProgressCB=0;
                  rcmd.size=0;
                  _ftpEnQ(QE_RECV_CMD,QS_BEGIN,0,&fcp,rcmd);
               } else if( pos("d",info) ) {
                  // Directory
                  fcp.PostedCB=__ftpclientDownload2CB;
                  _ftpEnQ(QE_CWD,QS_BEGIN,0,&fcp,filename);
               }
               return;
            }
         }
         // That was the last selected file/directory
         dirstack._makeempty();
         formWid._UpdateLocalSession();
         return;
      }
      // Back up to previous directory and continue processing at that level
      dirstack._deleteel(tos);
      --tos;
      prev_LocalCWD=dirstack[tos].LocalCWD;
      prev_RemoteCWD=dirstack[tos].RemoteCWD;
      fcp.LocalCWD=prev_LocalCWD;
      fcp.PostedCB=__ftpclientDownload1CB;
      _ftpEnQ(QE_CWD,QS_BEGIN,0,&fcp,prev_RemoteCWD);
      return;
   }
   
   tos=dirstack._length()-1;
   dirstack[tos].last_filename=next_file.filename;
   if( next_file.type&FTPFILETYPE_DIR ) {
      // Directory, so start to push another level
      fcp.PostedCB=__ftpclientDownload2CB;
      _ftpEnQ(QE_CWD,QS_BEGIN,0,&fcp,next_file.filename);
      return;
   } else {
      // File, so RETR it
      _str cmdargv[];
      fcp.PostedCB=__ftpclientDownload1CB;
      /*
      typedef struct RecvCmd_s {
         boolean pasv;
         _str cmdargv[];
         _str dest;
         _str datahost;
         _str dataport;
         int  size;
         pfnProgressCallback_tp ProgressCB;
      } RecvCmd_t;
      */
      pasv= (fcp.UseFW && fcp.Options.fwenable && fcp.Options.fwpasv );
      rcmd.pasv=pasv;
      cmdargv._makeempty();
      cmdargv[0]="RETR";
      cmdargv[1]=next_file.filename;
      rcmd.cmdargv=cmdargv;
      dest=fcp.LocalCWD;
      if( last_char(dest)!=FILESEP ) dest=dest:+FILESEP;
      dest=dest:+next_file.filename;
      rcmd.dest=dest;
      datahost=dataport="";
      size=next_file.size;
      rcmd.ProgressCB=_ftpclientProgressCB;
      _ftpEnQ(QE_RECV_CMD,QS_BEGIN,0,&fcp,rcmd);
      return;
   }
   
   return;
}
void __ftpclientDownload2CB(...)
{
   ftpQEvent_t event;
   ftpConnProfile_t fcp;
   RecvCmd_t rcmd;

   event= *((ftpQEvent_t *)(arg(1)));
   fcp=event.fcp;
   fcp.PostedCB=0;

   if( event.state==QS_ERROR ) {
      /* Something went wrong, so attempt to put everything back to the
       * way it was.
       */
      tos=dirstack._length()-1;
      if( tos>=0 ) {
         old_LocalCWD=dirstack[0].LocalCWD;
         old_RemoteCWD=dirstack[0].RemoteCWD;
         dirstack._makeempty();
         fcp.LocalCWD=old_LocalCWD;
         if( old_RemoteCWD!=fcp.RemoteCWD ) {
            _ftpEnQ(QE_CWD,QS_BEGIN,0,&fcp,old_RemoteCWD);
            return;
         }
      }
      return;
   } else if( event.state==QS_ABORT || event.state==QS_ABORT_WAITING_FOR_REPLY ) {
      return;
   }
   
   if( event.event==QE_PWD ) {
      /* We just finished changing directory.
       * Now we need to create the matching local directory (if necessary)
       * and make it the local current working directory.
       */
      local_path=fcp.LocalCWD;
      if( last_char(local_path)!=FILESEP ) local_path=local_path:+FILESEP;
      dirname=fcp.RemoteCWD;
      if( last_char(dirname)=='/' ) dirname=substr(dirname,1,length(dirname)-1);
      i=lastpos('/',dirname);
      if( i ) {
         dirname=substr(dirname,i+1);
      }
      local_path=local_path:+dirname;
      path=isdirectory(maybe_quote_filename(local_path));   // Resolve
      if( path=="" || path=="0" ) {
         status=make_path(local_path);
         if( status ) {
            msg='Unable to create local directory "':+local_path:+'".  ':+
                _ftpGetMessage(status);
            _message_box(msg,"",MB_OK|MB_ICONEXCLAMATION);
            // Cleanup
            event.state=QS_ERROR;
            __ftpclientDownload2CB(&event);
            return;
         }
      }

      // Change to the local directory
      fcp.LocalCWD=local_path;

      /* Now we need the directory listing for the new remote current
       * working directory.
       */
      _str cmdargv[];
      fcp.PostedCB=__ftpclientDownload2CB;
      /*
      typedef struct RecvCmd_s {
         boolean pasv;
         _str cmdargv[];
         _str dest;
         _str datahost;
         _str dataport;
         int  size;
         pfnProgressCallback_tp ProgressCB;
      } RecvCmd_t;
      */
      pasv= (fcp.UseFW && fcp.Options.fwenable && fcp.Options.fwpasv);
      rcmd.pasv=pasv;
      cmdargv._makeempty();
      cmdargv[0]="LIST";
      if( fcp.ResolveLinks ) {
         cmdargv[1]="-L";
      }
      rcmd.cmdargv=cmdargv;
      dest=mktemp();
      if( dest=="" ) {
         msg="Unable to create temp file for remote directory listing";
         _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
         return;
      }
      rcmd.dest=dest;
      datahost=dataport="";
      size=0;
      fcp.XferType=FTPXFER_ASCII;   // Always transfer listings ASCII
      rcmd.ProgressCB=_ftpclientProgressCB;
      _ftpEnQ(QE_RECV_CMD,QS_BEGIN,0,&fcp,rcmd);
      return;
   } else if( event.event==QE_RECV_CMD ) {
      ftpFile_t next_file;
      next_file._makeempty();
      rcmd= (RecvCmd_t)event.info[0];
      action=upcase(rcmd.cmdargv[0]);
      if( action=="LIST" ) {
         /* We just created a directory listing.
          * Push the remote directory listing on the stack and start
          * processing the first file/directory.
          */
         status=_ftpCreateDir(&fcp,rcmd.dest);
         status2=delete_file(rcmd.dest);
         if( status2 && status2!=FILE_NOT_FOUND_RC && status2!=PATH_NOT_FOUND_RC ) {
            msg='Warning: Could not delete temp file "':+rcmd.dest:+'".  ':+_ftpGetMessage(status2);
            _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
         }
         if( status ) return;
         if( fcp.RemoteDir._isempty() ) {
            /* There are no files, so do not push a new directory level
             * and revert back to the previous direcotry.
             */
            tos=dirstack._length()-1;
            if( tos<0 ) {
               // This should never happen
               _message_box("Directory stack is empty",FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
               return;
            }
            fcp.LocalCWD=dirstack[tos].LocalCWD;
            fcp.PostedCB=__ftpclientDownload1CB;
            _ftpEnQ(QE_CWD,QS_BEGIN,0,&fcp,dirstack[tos].RemoteCWD);
            return;
         }
         tos=dirstack._length();   // New top-of-stack
         dirstack[tos].LocalCWD=fcp.LocalCWD;
         dirstack[tos].RemoteCWD=fcp.RemoteCWD;
         dirstack[tos].remote_files=fcp.RemoteDir.files;
         dirstack[tos].last_filename="";
         /* Make a fake event so __ftpclientDownload1CB() will start
          * processing the directory's files.
          */
         event.event=0;
         event.fcp=fcp;
         event.info._makeempty();
         event.start=0;
         event.state=0;
         __ftpclientDownload1CB(&event);
         return;
      } else {
         // This should never happen
         _message_box('Invalid action for __ftpclientDownload2CB: "':+action:+'"',FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
         return;
      }
   } else {
      // This should never happen
      _message_box('Invalid callback event: ':+event.event,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return;
   }
   
   return;
}

_command void ftpclientDownload() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fcp;

   formWid=_find_object("_tbFTPClient_form","N");
   if( !formWid ) return;
   if( _ftpclientFindAllControls(formWid,sstabWid,profileWid,localWid,remoteWid) ) return;
   fcp_p=formWid.GetCurrentConnProfile();
   if( !fcp_p ) return;
   _ftpTodoGetList(remoteWid);
   idx=_ftpTodoFindNext();
   while( idx>0 ) {
      _ftpTodoGetCaption(caption);
      parse caption with filename "\t" .;
      if( filename==".." ) {
         idx=_ftpTodoFindNext();
         continue;
      } else {
         _ftpTodoGetUserInfo(info);
         info=lowcase(info);
         fcp= *fcp_p;   // Make a copy
         fcp.PostedCB=0;
         dirstack._makeempty();
         /* We use this initial stack entry to get back to the original
          * remote working directory after we finish.
          */
         dirstack[0].last_filename="";
         dirstack[0].LocalCWD=fcp.LocalCWD;
         dirstack[0].RemoteCWD=fcp.RemoteCWD;
         if( info=="f" ) {
            // File
            fcp.PostedCB=__ftpclientDownload1CB;
            RecvCmd_t rcmd;
            _str cmdargv[];
            cmdargv._makeempty();
            cmdargv[0]="RETR";
            cmdargv[1]=filename;
            rcmd.cmdargv=cmdargv;
            rcmd.datahost=rcmd.dataport="";
            dest=fcp_p->LocalCWD;
            if( last_char(dest)!=FILESEP ) dest=dest:+FILESEP;
            dest=dest:+filename;
            rcmd.dest=dest;
            rcmd.pasv= (fcp.UseFW && fcp.Options.fwenable && fcp.Options.fwpasv);
            rcmd.ProgressCB=_ftpclientProgressCB;
            rcmd.size=0;
            _ftpEnQ(QE_RECV_CMD,QS_BEGIN,0,&fcp,rcmd);
         } else if( pos("d",info) ) {
            // Directory
            fcp.PostedCB=__ftpclientDownload2CB;
            _ftpEnQ(QE_CWD,QS_BEGIN,0,&fcp,filename);
         }
         return;
      }
      idx=_ftpTodoFindNext();
   }

   return;
}
#endif

void __ftpclientManualDownloadCB(...)
{
   ftpQEvent_t event;
   ftpConnProfile_t fcp;

   event= *((ftpQEvent_t *)(arg(1)));

   fcp=event.fcp;
   if( event.state!=QS_ERROR && event.state!=QS_ABORT && event.state!=QS_ABORT_WAITING_FOR_REPLY ) {
      formWid=_find_object("_tbFTPClient_form","N");
      if( !formWid ) return;
      formWid._UpdateLocalSession();
      return;
   }

   return;
}

_command void ftpclientManualDownload() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fcp;
   
   formWid=_find_object("_tbFTPClient_form","N");
   if( !formWid ) return;
   fcp_p=formWid.GetCurrentConnProfile();
   if( !fcp_p ) return;
   fcp= *fcp_p;   // Make a copy
   
   // Prompt for the remote path
   result=show("-modal _textbox_form","Manual Download",0,"","","","","Remote filename");
   if( result=="" ) {
      // User cancelled
      return;
   }
   remote_path=strip(_param1);
   if( remote_path=="" ) return;
   
   
   fcp.PostedCB=__ftpclientManualDownloadCB;
   RecvCmd_t rcmd;
   _str cmdargv[];
   cmdargv._makeempty();
   cmdargv[0]="RETR";
   cmdargv[1]=remote_path;
   rcmd.cmdargv=cmdargv;
   rcmd.datahost=rcmd.dataport="";
   if( substr(remote_path,1,1)!='/' ) {
      // Relative path, make it absolute
      remote_path=_ftpAbsolute(&fcp,remote_path);
   }
   filename=remote_path;
   i=lastpos('/',filename);
   if( i ) {
      filename=substr(filename,i+1);
   }
   if( filename=="" ) {
      msg="Invalid remote filename";
      _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return;
   }
   dest=fcp.LocalCWD;
   if( last_char(dest)!=FILESEP ) dest=dest:+FILESEP;
   dest=dest:+filename;
   rcmd.dest=dest;
   rcmd.pasv= (fcp.UseFW && fcp.Options.fwenable && fcp.Options.fwpasv);
   rcmd.ProgressCB=_ftpclientProgressCB;
   rcmd.size=0;
   _ftpEnQ(QE_RECV_CMD,QS_BEGIN,0,&fcp,rcmd);
   
   return;
}

void __ftpclientChangeRemoteDirCB(...)
{
   ftpQEvent_t event;
   ftpConnProfile_t fcp;
   int formWid;

   event= *((ftpQEvent_t *)(arg(1)));

   fcp=event.fcp;   // Make a copy
   
   if( event.state!=QS_ERROR && event.state!=QS_ABORT && event.state!=QS_ABORT_WAITING_FOR_REPLY ) {
      formWid=_find_object("_tbFTPClient_form","N");
      if( !formWid ) return;
      formWid._UpdateRemoteSession(true);
      return;
   }
   
   return;
}

void __ftpclientCwdCB(...);
_command void ftpclientChangeRemoteDir() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fcp;
   int formWid;

   formWid=_find_object("_tbFTPClient_form","N");
   if( !formWid ) return;
   fcp_p=formWid.GetCurrentConnProfile();
   if( !fcp_p ) return;
   cwd=arg(1);
   if( cwd=="" ) {
      // Prompt for the remote directory
      result=show("-modal _textbox_form","Change remote directory",0,"","?Type the remote directory you would like to change to","","","Directory");
      if( result=="" ) {
         // User cancelled
         return;
      }
      cwd=_param1;
      if( cwd=="" ) return;
   }
   fcp= *fcp_p;   // Make a copy
   fcp.PostedCB=__ftpclientCwdCB;
   _ftpEnQ(QE_CWD,QS_BEGIN,0,&fcp,cwd);

   return;
}

void __ftpclientMkRemoteDirCB(...)
{
   ftpQEvent_t event;
   ftpConnProfile_t fcp;
   int formWid;

   event= *((ftpQEvent_t *)(arg(1)));

   fcp=event.fcp;
   if( event.state==QS_ERROR || event.state==QS_ABORT || event.state==QS_ABORT_WAITING_FOR_REPLY ) {
      // Nothing to do
      return;
   }
   
   // _UpdateRemoteSession() will take care of asynchronous refresh
   formWid=_find_object("_tbFTPClient_form","N");
   if( !formWid ) return;
   formWid._UpdateRemoteSession(true);

   return;
}

_command void ftpclientMkRemoteDir() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fcp;
   int formWid;

   formWid=_find_object("_tbFTPClient_form","N");
   if( !formWid ) return;
   fcp_p=formWid.GetCurrentConnProfile();
   if( !fcp_p ) return;
   path=arg(1);
   if( path=="" ) {
      // Prompt for the remote directory to make
      result=show("-modal _textbox_form","Make remote directory",0,"","?Type the remote directory you would like to make","","","Directory");
      if( result=="" ) {
         // User cancelled
         return;
      }
      path=_param1;
      if( path=="" ) return;
   }
   fcp= *fcp_p;   // Make a copy
   fcp.PostedCB=__ftpclientMkRemoteDirCB;
   _ftpEnQ(QE_MKD,QS_BEGIN,0,&fcp,path);

   return;
}

void __ftpclientDelRemoteFileCB(...)
{
   ftpQEvent_t event;
   ftpConnProfile_t fcp;
   int formWid;

   event= *((ftpQEvent_t *)(arg(1)));

   fcp=event.fcp;
   if( event.state!=QS_ERROR && event.state!=QS_ABORT && event.state!=QS_ABORT_WAITING_FOR_REPLY ) {
      #if 1
      idx=_ftpTodoFindNext();
      while( idx>0 ) {
         _ftpTodoGetCaption(caption);
         parse caption with filename "\t" .;
         if( filename==".." ) {
            idx=_ftpTodoFindNext();
            continue;
         }
         _ftpTodoGetUserInfo(info);
         info=lowcase(info);
         fcp.PostedCB=__ftpclientDelRemoteFileCB;
         if( info=="f" ) {
            _ftpEnQ(QE_DELE,QS_BEGIN,0,&fcp,filename);
         } else if( pos("d",info) ) {
            _ftpEnQ(QE_RMD,QS_BEGIN,0,&fcp,filename);
         }
         return;
      }
      formWid=_find_object("_tbFTPClient_form","N");
      if( formWid ) {
         formWid._UpdateRemoteSession(true);
      }
      #else
      // Find the next selected file/directory in the tree
      formWid=_find_object("_tbFTPClient_form","N");
      if( !formWid ) return;
      if( _ftpclientFindAllControls(formWid,sstabWid,profileWid,localWid,remoteWid) ) {
         // This should never happen
         return;
      }
      remoteWid._TreeGetSelInfo(nofselected,firstidx,lastidx);
      if( !nofselected ) {
         /* This could happen if the user docked/undocked/killed
          * the FTP Client toolbar in the middle of transferring.
          */
         formWid._UpdateRemoteSession(true);
         return;
      }
      idx=remoteWid._TreeFindSelected(0);
      while( idx>=0 ) {
         caption=remoteWid._TreeGetCaption(idx);
         parse caption with filename "\t" .;
         if( filename==".." ) {
            idx=remoteWid._TreeFindSelected(0);
            continue;
         }
         info=remoteWid._TreeGetUserInfo(idx);
         info=lowcase(info);
         fcp.PostedCB=__ftpclientDelRemoteFileCB;
         if( info=="f" ) {
            _ftpEnQ(QE_DELE,QS_BEGIN,0,&fcp,filename);
         } else if( pos("d",info) ) {
            _ftpEnQ(QE_RMD,QS_BEGIN,0,&fcp,filename);
         }
         return;
      }
      // _UpdateRemoteSession() will take care of asynchronous refresh
      formWid._UpdateRemoteSession(true);
      #endif
      return;
   }
   
   return;
}

_command void ftpclientDelRemoteFile() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fcp;
   int formWid;

   formWid=_find_object("_tbFTPClient_form","N");
   if( !formWid ) return;
   if( _ftpclientFindAllControls(formWid,sstabWid,profileWid,localWid,remoteWid) ) return;
   fcp_p=formWid.GetCurrentConnProfile();
   if( !fcp_p ) return;
   _TreeGetSelInfo(nofselected,firstidx,lastidx);
   if( !nofselected ) return;
   status=_message_box("Delete ":+nofselected:+" files/directories?","FTP",MB_YESNO|MB_ICONQUESTION);
   if( status!=IDYES ) return;
   #if 1
   _ftpTodoGetList(remoteWid);
   idx=_ftpTodoFindNext();
   while( idx>0 ) {
      _ftpTodoGetCaption(caption);
      parse caption with filename "\t" .;
      if( filename==".." ) {
         idx=_ftpTodoFindNext();
         continue;
      } else {
         _ftpTodoGetUserInfo(info);
         info=lowcase(info);
         fcp= *fcp_p;   // Make a copy
         fcp.PostedCB=__ftpclientDelRemoteFileCB;
         if( info=="f" ) {
            _ftpEnQ(QE_DELE,QS_BEGIN,0,&fcp,filename);
         } else if( pos("d",info) ) {
            _ftpEnQ(QE_RMD,QS_BEGIN,0,&fcp,filename);
         }
         return;
      }
      idx=_ftpTodoFindNext();
   }
   #else
   idx=remoteWid._TreeFindSelected(1);
   while( idx>=0 ) {
      caption=remoteWid._TreeGetCaption(idx);
      parse caption with filename "\t" .;
      if( filename==".." ) {
         idx=remoteWid._TreeFindSelected(0);
         continue;
      } else {
         info=remoteWid._TreeGetUserInfo(idx);
         info=lowcase(info);
         fcp= *fcp_p;   // Make a copy
         fcp.PostedCB=__ftpclientDelRemoteFileCB;
         if( info=="f" ) {
            _ftpEnQ(QE_DELE,QS_BEGIN,0,&fcp,filename);
         } else if( pos("d",info) ) {
            _ftpEnQ(QE_RMD,QS_BEGIN,0,&fcp,filename);
         }
         return;
      }
      idx=remoteWid._TreeFindSelected(0);
   }
   #endif

   return;
}

void __ftpclientRenameRemoteFileCB(...)
{
   ftpQEvent_t event;
   ftpConnProfile_t fcp;
   int formWid;

   event= *((ftpQEvent_t *)(arg(1)));

   fcp=event.fcp;
   if( event.state==QS_ERROR || event.state==QS_ABORT || event.state==QS_ABORT_WAITING_FOR_REPLY ) {
      // Nothing to do
      return;
   }
   
   formWid=_find_object("_tbFTPClient_form","N");
   if( !formWid ) return;
   // _UpdateRemoteSession() will take care of asynchronous refresh
   formWid._UpdateRemoteSession(true);

   return;
}

_command void ftpclientRenameRemoteFile() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fcp;
   int formWid;

   formWid=_find_object("_tbFTPClient_form","N");
   if( !formWid ) return;
   if( _ftpclientFindAllControls(formWid,sstabWid,profileWid,localWid,remoteWid) ) return;
   fcp_p=formWid.GetCurrentConnProfile();
   if( !fcp_p ) return;
   remoteWid._TreeGetSelInfo(nofselected,firstidx,lastidx);
   if( !nofselected || nofselected>1 ) return;
   idx=remoteWid._TreeCurIndex();
   if( idx<0 ) return;
   caption=remoteWid._TreeGetCaption(idx);
   parse caption with rnfr "\t" .;
   if( rnfr==".." ) {
      return;
   } else {
      status=show("-modal _textbox_form","Rename ":+rnfr:+" to...",0,"","?Specify a filename to rename to","","","Rename to:":+rnfr);
      if( status=="" ) {
         // User cancelled
         return;
      }
      rnto=_param1;
      if( rnto=="" ) {
         return;
      }
      fcp= *fcp_p;   // Make a copy
      fcp.PostedCB=__ftpclientRenameRemoteFileCB;
      _ftpEnQ(QE_RENAME,QS_BEGIN,0,&fcp,rnfr,rnto);
      return;
   }
   
   return;
}

void __ftpclientCustomCmdCB(...)
{
   ftpQEvent_t event;
   ftpConnProfile_t fcp;
   CustomCmd_t ccmd;

   event= *((ftpQEvent_t *)(arg(1)));

   fcp=event.fcp;
   fcp.PostedCB=__ftpclientCustomCmdCB;   // Paranoid
   ccmd= (CustomCmd_t)event.info[0];
   if( event.state!=QS_ERROR && event.state!=QS_ABORT && event.state!=QS_ABORT_WAITING_FOR_REPLY ) {
      pattern=ccmd.pattern;
      if( pos('%f',pattern) ) {
         idx=_ftpTodoFindNext();
         if( idx>=0 ) {
            _ftpTodoGetCaption(caption);
            parse caption with filename "\t" size "\t" date "\t" time "\t" attribs;
            cmdline=stranslate(pattern,filename,'%f','');
            if( cmdline=="" ) {
               msg='Your custom command evaluates to ""';
               _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
               return;
            }
            ccmd.cmdargv[0]=cmdline;
            _ftpEnQ(QE_CUSTOM_CMD,QS_BEGIN,0,&fcp,ccmd);
            return;
         }
         // That was the last one
      } else {
         // The command was only sent once, so we are done
      }
   }
   
   if( pos('%f',ccmd.pattern) ) {
      // We were operating on files, so refresh the remote listing
      formWid=_find_object("_tbFTPClient_form","N");
      if( formWid ) {
         formWid._UpdateRemoteSession(true);
      }
   }

   return;
}

_command void ftpclientCustomCmd() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fcp;
   int formWid;
   CustomCmd_t ccmd;

   formWid=_find_object("_tbFTPClient_form","N");
   if( !formWid ) return;
   treeWid=formWid._find_control("_ctl_remote_dir");
   if( !treeWid ) return;
   fcp_p=formWid.GetCurrentConnProfile();
   if( !fcp_p ) return;
   /* We use the fake name ftpCustomCmd to keep track of retrieve info.
    * Because we use the same retrieve name for both the FTP Client toolbar
    * and the FTP open tab, they share retrieve history.
    */
   status=show("-modal _textbox_form","FTP Custom Command",TB_RETRIEVE|TB_RETRIEVE_INIT,"","?Substitutions:\n\n%f - Remote filename (no path)\n\nExample: To give full permissions to selected files in the tree, issue the command:\n\nSITE CHMOD 777 %f","","ftpCustomCmd","Command");
   if( status=="" ) {
      // User cancelled
      return;
   }
   pattern=_param1;
   if( pattern=="" ) {
      return;
   }
   ccmd._makeempty();
   ccmd.pattern=pattern;
   fcp= *fcp_p;   // Make a copy
   fcp.PostedCB=__ftpclientCustomCmdCB;
   if( pos('%f',pattern) ) {
      // We are acting on selected files in the tree
      treeWid._TreeGetSelInfo(nofselected,firstidx,lastidx);
      if( nofselected ) {
         _ftpTodoGetList(treeWid);
         idx=_ftpTodoFindNext();
         if( idx>=0 ) {
            _ftpTodoGetCaption(caption);
            parse caption with filename "\t" size "\t" date "\t" time "\t" attribs;
            cmdline=stranslate(pattern,filename,'%f','');
            if( cmdline=="" ) {
               msg='Your custom command evaluates to ""';
               _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
               return;
            }
            ccmd.cmdargv[0]=cmdline;
            _ftpEnQ(QE_CUSTOM_CMD,QS_BEGIN,0,&fcp,ccmd);
         }
      } else {
         msg="Your custom command requires atleast one file to be selected";
         _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      }
   } else {
      // Send the command line once
      ccmd.cmdargv[0]=ccmd.pattern;
      _ftpEnQ(QE_CUSTOM_CMD,QS_BEGIN,0,&fcp,ccmd);
   }
   
   return;
}

_command void ftpclientRemoteHScrollbar() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   int formWid;
   
   formWid=_find_object("_tbFTPClient_form","N");
   if( !formWid ) return;
   if( _ftpclientFindAllControls(formWid,sstabWid,profileWid,localWid,remoteWid) ) return;
   scroll_bars=remoteWid.p_scroll_bars;
   if( scroll_bars&SB_HORIZONTAL ) {
      // Turn horizontal scroll bar OFF, turn popup ON
      remoteWid.p_scroll_bars &= ~(SB_HORIZONTAL);
      remoteWid.p_delay=0;
   } else {
      // Turn horizontal scroll bar ON, turn popup OFF
      remoteWid.p_scroll_bars |= SB_HORIZONTAL;
      remoteWid.p_delay= -1;
   }
   /* Remember horizontal scroll bar settings.
    * Must do this here because exiting the editor does not call a control's
    * ON_DESTROY event.
    */
   _append_retrieve(0,_ctl_remote_dir.p_scroll_bars,"_tbFTPClient_form._ctl_remote_dir.p_scroll_bars");
   
   return;
}

_command void ftpclientRemoteFilter() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   ftpConnProfile_t *fcp_p;
   int formWid;
   
   formWid=_find_object("_tbFTPClient_form","N");
   if( !formWid ) return;
   fcp_p=formWid.GetCurrentConnProfile();
   if( !fcp_p ) return;
   filter=fcp_p->RemoteFileFilter;
   if( filter=="" ) filter=FTP_ALLFILES_RE;
   status=show("-modal _textbox_form","Remote file filter",TB_RETRIEVE|TB_RETRIEVE_INIT,"","?Specify the file filter for file listings. Separate multiple filters with a space.\n\nExample: *.html *.shtml","","ftpFilter","Filter:":+filter);
   if( status=="" ) {
      // User cancelled
      return;
   }
   filter=_param1;
   if( filter=="" ) return;
   fcp_p->RemoteFileFilter=filter;
   formWid._UpdateRemoteSession(true);

   return;
}

_command void ftpclientRefreshRemoteSession() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   int formWid;
   
   formWid=_find_object("_tbFTPClient_form","N");
   if( !formWid ) return;
   
   formWid._UpdateRemoteSession(true);

   return;
}

void _ctl_local_dir.rbutton_down()
{
   _TreeGetSelInfo(nofselected,firstidx,lastidx);
   x=mou_last_x();
   y=mou_last_y();
   idx=_TreeGetIndexFromPoint(x,y,'P');
   if( idx>=0 ) {
      firstline=MAXINT;
      if( firstidx>=0 ) _TreeGetInfo(firstidx,state,bm1,bm2,flags,firstline);
      lastline=-1;
      if( lastidx>=0 ) _TreeGetInfo(lastidx,state,bm1,bm2,flags,lastline);
      _TreeGetInfo(idx,state,bm1,bm2,flags,line);
      if( !nofselected || line<firstline || line>lastline ) {
         // First deselect any lines
         i=_TreeFindSelected(1);
         while( i>=0 ) {
            _TreeGetInfo(i,state,bm1,bm2,flags);
            _TreeSetInfo(i,state,bm1,bm2,flags&~(TREENODE_SELECTED));
            i=_TreeFindSelected(0);
         }
         _TreeSetCurIndex(idx);
         _TreeGetInfo(idx,state,bm1,bm2,flags);
         _TreeSetInfo(idx,state,bm1,bm2,flags|TREENODE_SELECTED);
      }
   }
   
   return;
}

void _ctl_local_dir.rbutton_up()
{
   ftpConnProfile_t *fcp_p;
   int formWid;
   
   menu_name="_FTPClient_localdir_menu";
   idx=find_index(menu_name,oi2type(OI_MENU))
   if( !idx ) {
      return;
   }
   mh=p_active_form._menu_load(idx,'P');
   if( mh<0) {
      _message_box('Unable to load menu: "':+menu_name:+'"',"",MB_OK|MB_ICONEXCLAMATION);
      return;
   }

   formWid=_find_object("_tbFTPClient_form","N");
   if( !formWid ) return;
   treeWid=formWid._find_control("_ctl_local_dir");
   if( !treeWid ) return;   // Should never happen
   fcp_p=formWid.GetCurrentConnProfile();

   // If local file(s) not selected then disable file operations
   noffiles=0;
   nofdirs=0;
   treeWid._TreeGetSelInfo(nofselected,firstidx,lastidx);
   if( nofselected ) {
      idx=treeWid._TreeFindSelected(1);
      while( idx>=0 ) {
         caption=treeWid._TreeGetCaption(idx);
         parse caption with filename "\t" size "\t" date "\t" time "\t" attribs;
         if( filename!=".." ) {
            userinfo=treeWid._TreeGetUserInfo(idx);
            userinfo=lowcase(userinfo);
            // Filename OR directory
            if( userinfo=="f" ) {
               ++noffiles;
            }
            if( pos("d",userinfo) ) {
               ++nofdirs;
            }
         }
         idx=treeWid._TreeFindSelected(0);
      }
   }
   if( !fcp_p ) {
      _menu_set_state(mh,"ftpclientUpload",MF_GRAYED,'M');
   }
   if( !noffiles || nofdirs ) {
      _menu_set_state(mh,"ftpclientOpenLocalFile",MF_GRAYED,'M');
      _menu_set_state(mh,"ftpclientViewLocalFile",MF_GRAYED,'M');
   }
   // Associated files only supported on Windows
   if( substr(machine(),1,2)!='NT' ) {
      status=_menu_find(mh,"ftpclientViewLocalFile",output_mh,mpos,"M");
      if( !status ) _menu_delete(output_mh,mpos);

   }
   if( !noffiles && !nofdirs ) {
      _menu_set_state(mh,"ftpclientUpload",MF_GRAYED,'M');
      _menu_set_state(mh,"ftpclientDelLocalFile",MF_GRAYED,'M');
   }
   if( (noffiles+nofdirs)!=1 ) {
      _menu_set_state(mh,"ftpclientRenameLocalFile",MF_GRAYED,'M');
   }
   on=treeWid.p_scroll_bars&SB_HORIZONTAL;
   if( on ) {
      _menu_set_state(mh,"ftpclientLocalHScrollbar",MF_CHECKED,'M');
   } else {
      _menu_set_state(mh,"ftpclientLocalHScrollbar",MF_UNCHECKED,'M');
   }

   // Show the menu:
   x=100;y=100;
   x=mou_last_x('M')-x;y=mou_last_y('M')-y;
   _lxy2dxy(p_scale_mode,x,y);
   _map_xy(p_window_id,0,x,y,SM_PIXEL);
   flags=VPM_LEFTALIGN|VPM_RIGHTBUTTON;
   status=_menu_show(mh,flags,x,y);
   _menu_destroy(mh);
}

void _ctl_local_dir.'F5'()
{
   ftpclientRefreshLocalSession();
   
   return;
}

void _ctl_remote_dir.rbutton_down()
{
   call_event(_ctl_local_dir,RBUTTON_DOWN,'W');
   
   return;
}

void _ctl_remote_dir.rbutton_up()
{
   int formWid;
   
   menu_name="_FTPClient_remotedir_menu";
   idx=find_index(menu_name,oi2type(OI_MENU))
   if( !idx ) {
      return;
   }
   mh=p_active_form._menu_load(idx,'P');
   if( mh<0) {
      _message_box('Unable to load menu: "':+menu_name:+'"',"",MB_OK|MB_ICONEXCLAMATION);
      return;
   }

   formWid=_find_object("_tbFTPClient_form","N");
   if( !formWid ) return;
   treeWid=formWid._find_control("_ctl_remote_dir");
   if( !treeWid ) return;   // Should never happen

   // If a remote file/directory is not selected then disable file operations
   noffiles=0;
   nofdirs=0;
   noflinks=0;
   treeWid._TreeGetSelInfo(nofselected,firstidx,lastidx);
   if( nofselected ) {
      idx=treeWid._TreeFindSelected(1);
      while( idx>=0 ) {
         caption=treeWid._TreeGetCaption(idx);
         parse caption with filename "\t" size "\t" date "\t" time "\t" attribs;
         if( filename!=".." ) {
            userinfo=treeWid._TreeGetUserInfo(idx);
            userinfo=lowcase(userinfo);
            // Filename OR directory
            if( userinfo=="f" ) {
               ++noffiles;
            }
            if( pos("d",userinfo) ) {
               ++nofdirs;
            }
            if( pos("l",userinfo) ) {
               ++noflinks;
            }
         }
         idx=treeWid._TreeFindSelected(0);
      }
   }
   if( !noffiles && !nofdirs ) {
      _menu_set_state(mh,"ftpclientDownload",MF_GRAYED,'M');
      _menu_set_state(mh,"ftpclientDelRemoteFile",MF_GRAYED,'M');
   }
   if( (noffiles+nofdirs)!=1 ) {
      _menu_set_state(mh,"ftpclientRenameRemoteFile",MF_GRAYED,'M');
   }
   if( !noflinks ) {
      _menu_set_state(mh,"ftpclientDownloadLinks",MF_GRAYED,'M');
   }
   on=treeWid.p_scroll_bars&SB_HORIZONTAL;
   if( on ) {
      _menu_set_state(mh,"ftpclientRemoteHScrollbar",MF_CHECKED,'M');
   } else {
      _menu_set_state(mh,"ftpclientRemoteHScrollbar",MF_UNCHECKED,'M');
   }

   // Show the menu:
   x=100;y=100;
   x=mou_last_x('M')-x;y=mou_last_y('M')-y;
   _lxy2dxy(p_scale_mode,x,y);
   _map_xy(p_window_id,0,x,y,SM_PIXEL);
   flags=VPM_LEFTALIGN|VPM_RIGHTBUTTON;
   status=_menu_show(mh,flags,x,y);
   _menu_destroy(mh);
}

void _ctl_remote_dir.'F5'()
{
   ftpclientRefreshRemoteSession();
   
   return;
}

void _ctl_local_drvlist.on_change(int reason)
{
#if !__UNIX__
   if( reason!=CHANGE_DRIVE ) return;
   if( !gchangedrvlist_allowed ) return;

   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fake;   // Used when there is no connection

   fcp_p=GetCurrentConnProfile();
   if( !fcp_p ) {
      // There is no current connection, so fake one
      cwd=LOCALCWD;
      if( cwd=="" ) {
         cwd=getcwd();
      }
      _ftpInitConnProfile(fake);
      fake.LocalCWD=cwd;
      fake.LocalFileFilter=LOCALFILTER;
      fcp_p=&fake;
   }
   localdrive="";
   localcwd=fcp_p->LocalCWD;
   if( substr(localcwd,1,2)!='\\' && substr(localcwd,2,1)==':' ) {
      // We have a drive letter
      localdrive=substr(localcwd,1,1);   // Just the drive letter
   }
   drive=p_text;
   if( substr(drive,1,2)!='\\' ) {
      drive=substr(drive,1,1);   // Just the drive letter
   }
   // Change to the current working directory of drive
   if( substr(drive,1,2)=='\\' ) {
      cwd=drive;
   } else {
      cwd=getcwd(drive);
   }
   temp=cwd;
   if( last_char(temp)!=FILESEP ) temp=temp:+FILESEP;
   temp=temp:+ALLFILES_RE;
   if( file_match('+d 'maybe_quote_filename(temp),1)=="" ) {
      // This path no longer exists
      _message_box("The following directory does not exist:\n\n":+cwd,"",MB_OK|MB_ICONEXCLAMATION);
      // Try to change back to the old directory
      temp=fcp_p->LocalCWD;
      if( last_char(temp)!=FILESEP ) temp=temp:+FILESEP;
      temp=temp:+ALLFILES_RE;
      if( file_match('+d 'maybe_quote_filename(temp),1)=="" ) {
         // Wow! The old directory no longer exists
         cwd=getcwd();
      } else {
         cwd=fcp_p->LocalCWD;
      }
      if( substr(cwd,1,2)=='\\' ) {
         parse cwd with '\\' root '\' share '\' .;
         drive='\\':+root:+'\':+share;
      } else {
         parse cwd with drive ':' .;
         drive=lowcase(drive):+':';
      }
      gchangedrvlist_allowed=false;
      status=p_cb_list_box._lbsearch(drive);
      p_cb_list_box._lbselect_line();
      p_text=drive;
      gchangedrvlist_allowed=true;
      drive=p_cb_list_box._lbget_text();
      if( substr(drive,1,2)!='\\' ) {
         drive=substr(drive,1,1);   // Just the drive letter
      }
      cwd=getcwd(drive);
   }
   old_LocalCWD=fcp_p->LocalCWD;
   LOCALCWD=cwd;
   fcp_p->LocalCWD=cwd;
   if( _UpdateLocalSession() ) {
      LOCALCWD=old_LocalCWD;
      fcp_p->LocalCWD=old_LocalCWD;
   }
#endif
}

void _ctl_local_cwd.on_change(int reason)
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fake;   // Used when there is no current connection

   if( !gchangelocalcwd_allowed ) return;

   cwd="";
   old_LocalCWD=""
   fcp_p=GetCurrentConnProfile();
   if( !fcp_p ) {
      _ftpInitConnProfile(fake);
      fake.LocalFileFilter=LOCALFILTER;
      fcp_p=&fake;
      old_LocalCWD=LOCALCWD;
      if( old_LocalCWD=="" ) {
         // This should never happen
         old_LocalCWD=getcwd();
      }
      cwd=p_text;
      if( cwd=="" ) {
         // This should never happen
         cwd=old_LocalCWD;
      }
   } else {
      old_LocalCWD=fcp_p->LocalCWD;
      if( old_LocalCWD=="" ) {
         // This should never happen
         old_LocalCWD=getcwd();
      }
      cwd=p_text;
      if( cwd=="" ) {
         // This should never happen
         cwd=old_LocalCWD;
      }
   }
   temp=cwd;
   if( last_char(temp)==FILESEP ) temp=substr(temp,1,length(temp)-1);
   temp=temp:+ALLFILES_RE;
   if( file_match('+d 'maybe_quote_filename(temp),1)=="" ) {
      // This path no longer exists
      cwd=getcwd();
   }
   LOCALCWD=cwd;
   fcp_p->LocalCWD=cwd;
   if( _UpdateLocalSession() ) {
      LOCALCWD=old_LocalCWD;
      fcp_p->LocalCWD=old_LocalCWD;
   }
}

void _ctl_local_dir.lbutton_double_click()
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fake;   // Used when there is no connection

   fcp_p=GetCurrentConnProfile();
   if( !fcp_p ) {
      // There is currently no connection, so make a fake connection profile
      cwd=LOCALCWD;
      if( cwd=="" ) {
         cwd=getcwd();
      }
      _ftpInitConnProfile(fake);
      fake.LocalCWD=cwd;
      fake.LocalFileFilter=LOCALFILTER;
      fcp_p=&fake;
   }

   idx=_TreeCurIndex();
   caption=_TreeGetCaption(idx);
   parse caption with filename "\t" .;
   filename=strip(filename);
   if( filename==".." ) {
      cwd=fcp_p->LocalCWD;
      if( last_char(cwd)!=FILESEP ) cwd=cwd:+FILESEP;
      cwd=cwd:+"..";
      orig_cwd=cwd;
      cwd=isdirectory(maybe_quote_filename(cwd),1);   // Resolve
      if( (cwd=="" || cwd=="0") && isuncdirectory(orig_cwd) ) {
         cwd=orig_cwd;
         parse cwd with '\\' server '\' sharename '\' path '\..';
         path=substr(path,1,lastpos('\',path,1,'e')-1);   // Strip off 1 directory
         cwd='\\':+server:+'\':+sharename:+'\':+path;
      }
      if( cwd=="" ) {
         // The current working directory might be really screwed up
         cwd=getcwd();
         _message_box("Unable to change the local working directory to:\n\n":+
                      orig_cwd:+"\n\nThe new local working directory is:\n\n":+
                      cwd,"",MB_OK|MB_ICONEXCLAMATION);
      }
      old_LocalCWD=fcp_p->LocalCWD;
      fcp_p->LocalCWD=cwd;
      LOCALCWD=cwd;
      mou_hour_glass(1);
      if( _UpdateLocalSession() ) {
         LOCALCWD=old_LocalCWD;
         fcp_p->LocalCWD=old_LocalCWD;
      }
   } else {
      info=_TreeGetUserInfo(idx);
      info=lowcase(info);
      if( info=="f" ) {
         /* We have a file so transfer it.
          * Note that ftpclientUpload() will take care of all
          * asynchronous operations.
          */
         ftpclientUpload();
      } else if( pos("d",info) ) {
         // We have a directory so change to it
         cwd=fcp_p->LocalCWD;
         if( last_char(cwd)!=FILESEP ) cwd=cwd:+FILESEP;
         cwd=cwd:+filename;
         orig_cwd=cwd;
         cwd=isdirectory(maybe_quote_filename(cwd),1);   // Resolve
         if( (cwd=="" || cwd=="0") && isuncdirectory(orig_cwd) ) {
            cwd=orig_cwd;
            parse cwd with '\\' server '\' sharename '\' path '\..';
            path=substr(path,1,lastpos('\',path,1,'e')-1);   // Strip off 1 directory
            cwd='\\':+server:+'\':+sharename:+'\':+path;
         }
         if( cwd=="" ) {
            // The current working directory might be really screwed up
            cwd=getcwd();
            _message_box("Unable to change the local working directory to:\n\n":+
                         orig_cwd:+"\n\nThe new local working directory is:\n\n":+
                         cwd,"",MB_OK|MB_ICONEXCLAMATION);
         }
         old_LocalCWD=fcp_p->LocalCWD;
         LOCALCWD=cwd;
         fcp_p->LocalCWD=cwd;
         mou_hour_glass(1);
         if( _UpdateLocalSession() ) {
            LOCALCWD=old_LocalCWD;
            fcp_p->LocalCWD=old_LocalCWD;
         }
      }
   }
}

void _ctl_remote_cwd.on_drop_down(reason)
{
   ftpConnProfile_t *fcp_p;

   if( reason!=DROP_DOWN ) return;
   
   fcp_p=GetCurrentConnProfile();
   if( !fcp_p ) return;   // This should never happen
   
   gchangeremotecwd_allowed=false;
   p_cb_list_box._lbclear();
   len=fcp_p->CwdHist._length();
   for( i=len-1;i>=0;--i ) {
      p_cb_list_box._lbadd_item(fcp_p->CwdHist[i]);
   }
   gchangeremotecwd_allowed=true;
   
   return;
}

void _ctl_remote_cwd.on_change(int reason)
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fcp;

   if( !gchangeremotecwd_allowed ) return;

   fcp_p=GetCurrentConnProfile();
   if( !fcp_p ) return;   // This should never happen

   old_RemoteCWD=fcp_p->RemoteCWD;
   if( old_RemoteCWD=="" ) {
      // This should never happen
      old_RemoteCWD='/';
   }
   cwd=p_text;
   if( cwd=="" ) {
      // This should never happen
      cwd=old_RemoteCWD;
   }
   fcp= *fcp_p;   // Make a copy
   fcp.PostedCB=__ftpclientCwdCB;
   _ftpEnQ(QE_CWD,QS_BEGIN,0,&fcp,cwd);
   return;
}

void __ftpclientDoubleClick(...)
{
   ftpQEvent_t event;
   ftpConnProfile_t fcp;
   ftpConnProfile_t *fcp_p;
   int formWid;
   
   formWid=_find_object("_tbFTPClient_form","N");
   if( !formWid ) return;   // This should never happen
   
   event= *((ftpQEvent_t *)(arg(1)));
   fcp=event.fcp;
   //message("event.fcp.RemoteCWD="event.fcp.RemoteCWD);
   
   action= upcase(arg(arg()));   // Action word is always last
   if( action!="CDUP" && action!="CWD" ) {
      // This should never happen
      _message_box('Invalid action: "':+action:+'"',FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return;
   }
   
   if( event.state!=QS_ERROR && event.state!=QS_ABORT && event.state!=QS_ABORT_WAITING_FOR_REPLY ) {
      /* Find the matching connection profile in current connections
       * so we can update its stored remote current working directory.
       */
      fcp_p=0;
      for( i._makeempty();; ) {
         _ftpCurrentConnections._nextel(i);
         if( i._isempty() ) break;
         currentconn=_ftpCurrentConnections:[i];
         if( _ftpCurrentConnections:[i].ProfileName==fcp.ProfileName &&
             _ftpCurrentConnections:[i].Instance==fcp.Instance ) {
            // Found it
            fcp_p= &(_ftpCurrentConnections:[i]);
            break;
         }
      }
      if( !fcp_p ) {
         // We didn't find the matching connection profile, so bail out
         return;
      }
      fcp_p->RemoteCWD=fcp.RemoteCWD;
      
      // _UpdateRemoteSession() already handles asynchronous operations
      formWid._UpdateRemoteSession(true);
      return;
   }
   
   return;
}
void __ftpclientCdupCB(...)
{
   __ftpclientDoubleClick(arg(1),"CDUP");
   
   return;
}
void __ftpclientCwdCB(...)
{
   __ftpclientDoubleClick(arg(1),"CWD");
   
   return;
}

void _ctl_remote_dir.lbutton_double_click()
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fcp;

   fcp_p=GetCurrentConnProfile();
   if( !fcp_p ) return;   // This should never happen

   idx=_TreeCurIndex();
   caption=_TreeGetCaption(idx);
   parse caption with filename "\t" .;
   fcp= *fcp_p;   // Make a copy
   fcp.PostedCB=0;
   if( filename==".." ) {
      fcp.PostedCB=__ftpclientCdupCB;
      _ftpEnQ(QE_CDUP,QS_BEGIN,0,&fcp);
      return;
   } else {
      info=_TreeGetUserInfo(idx);
      info=lowcase(info);
      if( info=="f" ) {
         /* We have a file so transfer it.
          * Note that ftpclientDownload() will take care of asynchronous
          * operations.
          */
         ftpclientDownload();
      } else if( pos("d",info) ) {
         // We have a directory so CWD to it
         fcp.PostedCB=__ftpclientCwdCB;
         _ftpEnQ(QE_CWD,QS_BEGIN,0,&fcp,filename);
         return;
      }
   }
}

static void getNewSSTabWH(typeless &ht,int formWid,int sstWid,int &sstabW,
                          int &sstabH,int &tabHeight)
{
   tabHeight=ht:["tabHeight"];
   // Want same gap on left and right
   sstabW=_dx2lx(SM_TWIP,formWid.p_client_width)-2*sstWid.p_x;
   // Adjust height to account for controls on top
   vgap=_dy2ly(SM_TWIP,4);
   sstabH=_dy2ly(SM_TWIP,formWid.p_client_height)-sstWid.p_y-vgap;
}

static void onresizeTabControl(typeless &ht)
{
   int sstabW,sstabH,tabHeight;
   getNewSSTabWH(ht,p_active_form,p_window_id,sstabW,sstabH,tabHeight);
   p_width=sstabW;
   p_height=sstabH;
   //ht:["sstabW"]=sstabW;
   //ht:["sstabH"]=sstabH;

   #if 0
   // Toggle tab control to display tab with text and images or just images
   if( sstabW<ht:["pictureOnlyW"] ) {
      if( p_PictureOnly!=TRUE ) {
         p_PictureOnly=TRUE;
      }
   } else {
      if( p_PictureOnly!=FALSE ) {
         p_PictureOnly=FALSE;
      }
   }
   #endif

   // Position the lefmost buttons
   _ctl_disconnect.p_x= _ctl_connect.p_x+_ctl_connect.p_width+_dx2lx(SM_TWIP,4);
   _ctl_divider1.p_x= _ctl_disconnect.p_x+_ctl_disconnect.p_width+_dx2lx(SM_TWIP,4);
   _ctl_divider1.p_height=_ctl_disconnect.p_height;
   _ctl_ascii.p_x= _ctl_divider1.p_x+_ctl_divider1.p_width+_dx2lx(SM_TWIP,4);
   _ctl_binary.p_x= _ctl_ascii.p_x+_ctl_ascii.p_width+_dx2lx(SM_TWIP,2);
   _ctl_divider2.p_x= _ctl_binary.p_x+_ctl_binary.p_width+_dx2lx(SM_TWIP,4);
   _ctl_divider2.p_height=_ctl_divider1.p_height;
   
   // Position the rightmost controls
   _ctl_progress.p_visible=false;
   _ctl_progress_label1.p_visible=false;
   _ctl_progress_label2.p_visible=false;
   
   // Abort button
   new_x=(p_x+p_width)-_ctl_abort.p_width-_dx2lx(SM_TWIP,3);
   _ctl_abort.p_x=new_x;
   
   // Progress gauge
   new_x=_ctl_abort.p_x-_ctl_progress.p_width-_dx2lx(SM_TWIP,4);
   _ctl_progress.p_x=new_x;
   
   // Byte count label
   new_width= _ctl_progress.p_x-(_ctl_group1.p_x+_ctl_group1.p_width)-2*_dx2lx(SM_TWIP,4);
   if( new_width<0 ) new_width=0;
   new_x=_ctl_group1.p_x+_ctl_group1.p_width+_dx2lx(SM_TWIP,4);
   _ctl_progress_label2.p_x=new_x;
   _ctl_progress_label2.p_width=new_width;
   
   // Operation label
   new_width=_ctl_abort.p_x-(_ctl_group1.p_x+_ctl_group1.p_width)-2*_dx2lx(SM_TWIP,4);
   if( new_width<0 ) new_width=0;
   new_x=_ctl_group1.p_x+_ctl_group1.p_width+_dx2lx(SM_TWIP,4);
   _ctl_progress_label1.p_x=new_x;
   _ctl_progress_label1.p_width=new_width;
   
   _ctl_progress.p_visible=true;
   _ctl_progress_label1.p_visible=true;
   _ctl_progress_label2.p_visible=true;

   return;
}

static void onresizeDirTab(typeless &ht)
{
   int sstabW,sstabH,tabHeight;
   int new_x,new_y,new_width,new_height;

   if( p_ActiveTab!=FTPTOOLTAB_DIR ) return;
   getNewSSTabWH(ht,p_active_form,p_window_id,sstabW,sstabH,tabHeight);

   // Resize horizontal postion and widths
   // Gap between the outer edges of the directory lists and the left/right edge of the "Dir" tab
   rgap=lgap=_ctl_local_dir.p_x+1;
   // Gap between the local and remote directory lists
   mgap=_dx2lx(SM_TWIP,6);
   // First take care of the local directory
   new_width=sstabW/2-lgap-mgap/2;
   _ctl_local_dir.p_width=new_width;
   // Now the local cwd combo box width
#if __UNIX__
   // Unix does not have drives, so we don't need the drive list
   _ctl_local_drvlist.p_visible=false;   // Paranoid
   _ctl_local_cwd.p_x=_ctl_local_dir.p_x;
   _ctl_local_cwd.p_width=_ctl_local_dir.p_width;
#else
   _ctl_local_cwd.p_width=new_width-(_ctl_local_cwd.p_x-_ctl_local_drvlist.p_x);
#endif
   // Now the remote directory
   _ctl_remote_dir.p_width=new_width;
   new_x=sstabW/2-1+mgap/2;
   _ctl_remote_dir.p_x=new_x;
   // Now the remote cwd combo box x and width
   _ctl_remote_cwd.p_x=_ctl_remote_dir.p_x;
   _ctl_remote_cwd.p_width=_ctl_remote_dir.p_width;

   // Resize height
   vgap=_ctl_local_dir.p_y-(_ctl_local_drvlist.p_y+_ctl_local_drvlist.p_height-1);
   new_height=sstabH-_ctl_local_dir.p_y-tabHeight-vgap;
   _ctl_local_dir.p_height=new_height;
   _ctl_remote_dir.p_height=new_height;

   // Center the "(No connection)" message that is normally obscured behind the remote directory list
   new_x= _ctl_remote_dir.p_x + (_ctl_remote_dir.p_width-_ctl_no_connection.p_width)/2;
   _ctl_no_connection.p_x=new_x;
   new_y= (sstabH-tabHeight-_ctl_no_connection.p_height)/2;
   _ctl_no_connection.p_y=new_y;

   return;
}

static void onresizeLogTab(typeless &ht)
{
   int sstabW,sstabH,tabHeight;
   int new_x,new_y,new_width,new_height;

   if( p_ActiveTab!=FTPTOOLTAB_LOG ) return;
   getNewSSTabWH(ht,p_active_form,p_window_id,sstabW,sstabH,tabHeight);

   // Resize width
   new_width=sstabW-2*_ctl_log.p_x-_dx2lx(SM_TWIP,3);
   _ctl_log.p_width=new_width;

   // Resize height
   new_height=sstabH-_ctl_log.p_y-tabHeight-_ctl_log.p_x-_dy2ly(SM_TWIP,4);
   _ctl_log.p_height=new_height;

   // Center the "(No log)" message that is normally obscured behind the log
   new_x= (sstabW-_ctl_no_log.p_width)/2;
   _ctl_no_log.p_x=new_x;
   new_y= (sstabH-tabHeight-_ctl_no_log.p_height)/2;
   _ctl_no_log.p_y=new_y;

   return;
}

void _tbFTPClient_form.on_resize()
{
   typeless lastW,lastH;
   typeless ht:[];
   _str info;

   ht=_ctl_ftp_sstab.p_user;
   if( ht._indexin("formWH") ) {
      info=ht:["formWH"];
      parse info with lastW lastH;
      if( lastW==p_width && lastH==p_height ) return;
   } else {
      ht:["formWH"]=p_width:+" ":+p_height;
      _ctl_ftp_sstab.p_user=ht;
      return;
   }

   _ctl_ftp_sstab.onresizeTabControl(ht);
   _ctl_ftp_sstab.onresizeDirTab(ht);
   _ctl_ftp_sstab.onresizeLogTab(ht);

   return;
}

/* Gets called when the queue is processing events.
 */
static boolean _busy_override=false;
void _ftpQBusy_ftpclient()
{
   if( _busy_override ) return;
   
   _enable_ftpclient(false);
   
   return;
}

/* Gets called when the queue is idle.
 */
static boolean _idle_override=false;
void _ftpQIdle_ftpclient()
{
   ftpConnProfile_t *fcp_p;
   
   if( _idle_override ) return;
   
   _enable_ftpclient(true);
   
   
   return;
}

static void _enable_children(int parent,boolean enable)
{
   int firstwid,wid;
   
   if( !parent ) return;
   
   firstwid=parent.p_child;
   if( !firstwid ) return;
   wid=firstwid;
   for(;;) {
      if( wid.p_object!=OI_FORM &&   /* Don't mess with child forms that are modal */
          wid.p_name!="_ctl_abort" ) {
         if( enable ) {
            if( wid.p_mouse_pointer!=MP_DEFAULT ) wid.p_mouse_pointer=MP_DEFAULT;
         } else {
            if( wid.p_mouse_pointer!=MP_HOUR_GLASS ) wid.p_mouse_pointer=MP_HOUR_GLASS;
         }
      }
      if( wid.p_object!=OI_FORM &&   /* Don't want to enable child forms that are modal */
          wid.p_name!="_ctl_abort" && wid.p_name!="_ctl_ftp_sstab" &&
          wid.p_name!="_ctl_progress_label1" && wid.p_name!="_ctl_progress_label2" &&
          wid.p_name!="_ctl_progress" && wid.p_name!="_ctl_log" &&
          wid.p_object!=OI_HSCROLL_BAR && wid.p_object!=OI_VSCROLL_BAR ) {
         if( wid.p_enabled!=enable ) wid.p_enabled=enable;
      }
      // This allows user to view log while an operation is in progress
      if( wid.p_object!=OI_FORM &&   /* Don't mess with child forms that are modal */
          wid.p_name!="_ctl_log" && wid.p_object!=OI_HSCROLL_BAR && wid.p_object!=OI_VSCROLL_BAR ) {
         _enable_children(wid,enable);
      }
      wid=wid.p_next;
      if( wid==firstwid ) break;
   }
   
   return;
}

static void _enable_ftpclient(boolean enable)
{
   int formWid;
   
   formWid=_find_object("_tbFTPClient_form","N");
   if( !formWid ) return;
   
   /* I have to set p_mouse_pointer for the form for this to
    * work reliably. Shouldn't have to do this though.
    */
   if( enable ) {
      formWid.p_mouse_pointer=MP_DEFAULT;
   } else {
      formWid.p_mouse_pointer=MP_HOUR_GLASS;
   }
   _enable_children(formWid,enable);
   
   sstabWid=formWid._find_control("_ctl_ftp_sstab");
   //if( sstabWid ) sstabWid.p_enabled=enable;
   profileWid=formWid._find_control("_ctl_profile");
   //if( profileWid ) profileWid.p_enabled=enable;
   groupWid=formWid._find_control("_ctl_group1");
   if( groupWid ) {
      if( enable ) {
         label1Wid=formWid._find_control("_ctl_progress_label1");
         label2Wid=formWid._find_control("_ctl_progress_label2");
         gaugeWid=formWid._find_control("_ctl_progress");
         if( label1Wid && label2Wid && gaugeWid && groupWid ) {
            // Shrink/position the labels so it does not overlap _ctl_group1
            label1Wid.p_x=groupWid.p_x+groupWid.p_width+_dx2lx(SM_TWIP,4);
            label1Wid.p_width= (gaugeWid.p_x+gaugeWid.p_width-1)-label1Wid.p_x;
            label2Wid.p_x=label1Wid.p_x;
            label2Wid.p_width=gaugeWid.p_x-label2Wid.p_x-_dx2lx(SM_TWIP,4);
         }
      }
      groupWid.p_visible=enable;
   }
   
   return;
}

