/*
$VerboseHistory: ini.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:09:29a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 09:29a
 * Comment:
 * Added support for editor control.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:34p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:43p
 * Comment:
 * Adding new 3.0 stuff
*/
#include 'slick.sh'

/*

    _BufEdit should only be used when opening buffers on dialog
    boxes.
    
    load_options may be "" or only may contain the following
      +bi <buf_id
      +d
      +b

*/
int _BufEdit(_str filename,_str load_options,int IgnoreNotFound,_str load_options2,int quiet)
{
   get_view_id(orig_view_id);
   if (filename=='') {
      return(FILE_NOT_FOUND_RC);
   }
   parse load_options with '+bi 'buf_id;

   activate_view(HIDDEN_VIEW_ID);
   _safe_hidden_window();
   buffer_already_exists=(lowcase(load_options)!='+d' &&
                         buf_match(filename,1,'hx')!='') || buf_id!='';
   if (buf_id!='') {
      status=load_files(' +q +c +m 'load_options' 'load_options2' 'filename);
   } else if (load_options=='+b') {
      status=load_files(' +q +m 'load_options' 'load_options2' 'filename);
   } else {
      /*parse def_max_loadall with on size;
      TempNoLoad="";
      if (on && isinteger(size) && size > 0 &&
          _filesize(filename) > size * 1024) {
         TempNoLoad='-L ';
      }
      */
      load_options=build_load_options(filename)" "/*TempNoLoad:+*/load_options:+' 'load_options2;
      mou_hour_glass(1);
      status=load_files(' +q +m 'load_options' 'maybe_quote_filename(filename));
      mou_hour_glass(0);
   }
   if (status && !(status==NEW_FILE_RC && IgnoreNotFound)) {
      if(status==NEW_FILE_RC) {
         _delete_buffer();
         status=FILE_NOT_FOUND_RC;
      }
      _safe_hidden_window();
      activate_view(orig_view_id);
      return(status)
   }
   buf_id=p_buf_id;
   p_buf_flags=p_buf_flags | DELETE_BUFFER_ON_CLOSE;
   if (!buffer_already_exists) {
      p_buf_flags=p_buf_flags | HIDE_BUFFER;
   }
   if ( p_readonly_mode && block_was_read()>1 ) {
      read_only_status=block_was_read();
      command='read-only-mode';
      if (!quiet) {
         if ( read_only_status==3 ) {
            message(nls('Warning:  You have read only access to this file'));
         } else {
            message(nls('Warning:  Another process has read access'));
         }
      }
      select_edit_mode();
      call_list('_buffer_add_',p_buf_id,p_buf_name,p_buf_flags);
      _restore_filepos(p_buf_name);
      if ( index_callable(find_index(command,COMMAND_TYPE)) ) {
         execute(command,"");
      }
   } else if ( _modename_eq(p_mode_name,'Fundamental')) {
      if (block_was_read() || status==NEW_FILE_RC) {
          select_edit_mode();
          call_list('_buffer_add_',p_buf_id,p_buf_name,p_buf_flags);
          _restore_filepos(p_buf_name);
      }
   }
   _safe_hidden_window();
   activate_view(orig_view_id);
   return(buf_id);
}
/*
    temp_option
    +t
    +tu
    +tm
    +td
    
    load_options
      +70
    
*/
int _BufCreate(_str temp_option,_str load_options,int reserved)
{
   get_view_id(orig_view_id);

   activate_view(HIDDEN_VIEW_ID);
   _safe_hidden_window();
   status=load_files(' +q 'def_load_options' 'load_options' 'temp_option);
   if (status) {
      _safe_hidden_window();
      activate_view(orig_view_id);
      return(status)
   }
   buf_id=p_buf_id;
   p_buf_flags=p_buf_flags | DELETE_BUFFER_ON_CLOSE;
   p_buf_flags=p_buf_flags | HIDE_BUFFER;
   select_edit_mode();
   call_list('_buffer_add_',p_buf_id,p_buf_name,p_buf_flags);
   _safe_hidden_window();
   activate_view(orig_view_id);
   return(buf_id);
}
/*
   WARNING: If you specify the +b option, you can not specify other options.
   
   
   load_options may be "" or only may contain the following
      +bi <buf_id>
      +d
      +b

*/
int _open_temp_view(_str filename,int &temp_view_id,int &orig_view_id,_str load_options="")
{
   parse load_options with '+bi 'buf_id;
   get_view_id(orig_view_id);
   if (filename=='' && buf_id=='') {
      return(FILE_NOT_FOUND_RC);
   }
   activate_view(HIDDEN_VIEW_ID);
   buffer_already_exists=1;
   if (buf_id!='') {
      status=load_files(' +q +c +m 'load_options' 'filename);
   } else if (load_options=='+b' || buf_id!='') {
     status=load_files(' +q +c 'load_options' 'filename);
   } else {
      buffer_already_exists=
         (lowcase(load_options)!='+d' && 
          buf_match(absolute(filename),1,'hx')!=''
         );
      status=load_files(' +q +c 'load_options' 'maybe_quote_filename(filename));
   }
   if (status) {
      if(status==NEW_FILE_RC) {
         _delete_buffer;_quit_view
         status=FILE_NOT_FOUND_RC;
      }
      activate_view(orig_view_id);
      return(status)
   }
   get_view_id(temp_view_id);
   if (!buffer_already_exists) {
      p_buf_flags=p_buf_flags | HIDE_BUFFER;
   }
   return(0);
}

int _ini_get_section(_str filename,_str section_name,int &temp_view_id)
{
   status=_open_temp_view(filename,ini_view_id,view_id,'+d')
   if (status){
      return(status);
   }
   status=_ini_get_section2(section_name,temp_view_id);
   _delete_temp_view(ini_view_id)
   activate_view(view_id);
   return(status)
}

static int _ini_get_section2(_str section_name,int &temp_view_id)
{
   get_view_id(ini_view_id);
   view_id=_create_temp_view(temp_view_id);
   activate_view(ini_view_id);
   status=_ini_find_section(section_name);
   if (status) {
      _delete_temp_view(temp_view_id);
      return(status);
   }
   down();
   get_line(line);
   if (substr(line,1,1)=='[') {
      return(0);// Nothing was in the section, but I guess we were still technically
   }            // succesful.
   mark_id=_alloc_selection();
   _select_line(mark_id);
   if (_ini_find_section('')) {
      bottom();
   }else{
      up();
   }
   _select_line(mark_id);
   activate_view(temp_view_id);
   _copy_to_cursor(mark_id);
   p_line=1;
   _free_selection(mark_id);

   // Remove blank lines:
   top();
   up();
   while (!down()) {
      _str line;
      get_line(line);
      if (line=="") {
         delete_line();
         up();
      }
   }
   p_line=1;

   return(0);
}

int _ini_create_section(_str filename, _str section_name)
{
   view_id=_create_temp_view(ini_view_id);
   p_buf_name=absolute(filename);
   get_view_id(orig_view_id);
   activate_view(ini_view_id);
   bottom();
   insert_line('['section_name']');
   status=_save_file("+o");
   if (status) {
      activate_view(orig_view_id);
      _delete_temp_view(ini_view_id);
      return(status);
   }
   activate_view(orig_view_id);
   _delete_temp_view(ini_view_id);
   return(0);
}

int _ini_replace_section(_str filename,_str section_name,int temp_view_id)
{
   /* Just adds the section if it doesn't already exist */
   status=_open_temp_view(filename, ini_view_id, view_id,'+d');
   if (status==FILE_NOT_FOUND_RC) {
      view_id=_create_temp_view(ini_view_id);
      p_buf_name=absolute(filename);
      status=0;
   }
   if (status) {
      return(status);
   }
   activate_view(ini_view_id);
   _ini_replace_section2(section_name, temp_view_id);
   _delete_temp_view(ini_view_id);
   _delete_temp_view(temp_view_id);
   if (view_id!=temp_view_id) {
      activate_view(view_id);
   }
   return(0);
}

int _ini_put_section(_str filename,_str section_name,int temp_view_id)
{
   /* Just adds the section if it doesn't already exist */
   /* Had to write this to put in filenames(logic for adding in var=val form messed up
      searching for filenames */
   status=_open_temp_view(filename, ini_view_id, view_id,'+d');
   if (status==FILE_NOT_FOUND_RC) {
      view_id=_create_temp_view(ini_view_id);
      p_buf_name=absolute(filename);
      status=0;
   }
   if (status) {
      return(status);
   }
   activate_view(ini_view_id);
   status=_ini_put_section2(section_name, temp_view_id);
   _delete_temp_view(ini_view_id);
   _delete_temp_view(temp_view_id);
   if (view_id!=temp_view_id) {
      activate_view(view_id);
   }
   return(status);
}

int _ini_put_section2(_str section_name,int temp_view_id)
{
   get_view_id(ini_view_id);
   top();
   status=_ini_find_section(section_name);
   if (status) {
      bottom();
      insert_line('['section_name']');
   } else {
      // Delete contents of section
      // Cursor should be placed on header.
      _ini_delete_section3(0);
   }
   activate_view(temp_view_id);
   mark_id=_alloc_selection();
   top();
   _select_line(mark_id);
   bottom();
   status=_select_line(mark_id);
   if (status) {
      clear_message
      activate_view(ini_view_id);
      return(_save_file("+o"))//Nothing in temp_view_id
   }
   activate_view(ini_view_id);
   _copy_to_cursor(mark_id);
   _free_selection(mark_id);
   return(_save_file("+o"));
}

static int _ini_replace_section2(_str section_name,int temp_view_id)
{
   get_view_id(ini_view_id);
   status=_ini_find_section(section_name);
   if (status) {
      insert_line('['section_name']');
      activate_view(temp_view_id);
      mark_id=_alloc_selection();
      top();
      _select_line(mark_id);
      bottom();
      _select_line(mark_id);
      activate_view(ini_view_id);
      _copy_to_cursor(mark_id);
      _free_selection(mark_id);
      return(_save_file("+o"));
   }
   save_search(a,b,c,d);
   _end_line();
   // We are sitting on the section name at end of line
   save_pos(p);
   activate_view(temp_view_id);
   get_line(line);
   top();up();
   for (;;) {
      activate_view(temp_view_id);
      if (down()) {
         break;
      }
      get_line(line);
      parse line with var_name '=' +0 equalsign;
      if (equalsign!='') {
         parse equalsign with '=' value;
      }else{
         value='';
      }
      activate_view(ini_view_id);
      restore_pos(p);
      if (equalsign=='') {
         // Searching for a filename
         status=search('^('_escape_re_chars(var_name)'$|\[)','r@'((_fpos_case=='')?'e':'i'));
         if (status) {
            bottom();
            insert_line(var_name);
            continue;
         }else{
            get_line(line);
            if (substr(line,1,1)=='[') {
               up();
               insert_line(var_name);
            } else {
               replace_line(var_name);
            }
            continue;
         }
      }
      // We are sitting on the section name at end of line
      status=search('^('var_name'=|\[)','ri@');
      if (status) {
         insert_line(var_name'='value);
         continue;
      }
      get_line(line);
      if (substr(line,1,1)=='[') {
         up();
         insert_line(var_name '=' value);
         continue;
      }
      //parse line with old_name '=' old_val;
      replace_line(var_name '=' value);
   }
   activate_view(ini_view_id);
   restore_search(a,b,c,d);
   return(_save_file("+o"));
}

int _ini_set_value(_str filename,_str section_name,_str field_name,_str new_value)
{
   status=_open_temp_view(filename,ini_view_id, view_id,'+d')
   if (status) {
      if (status==FILE_NOT_FOUND_RC && filename!="") {
         view_id=_create_temp_view(ini_view_id);
         p_buf_name=absolute(filename);
         status=0;
      } else {
         return(status);
      }
   }
   get_view_id(orig_view_id);
   activate_view(ini_view_id);
   status=_ini_set_value2(section_name,field_name,new_value);
   activate_view(orig_view_id);
   _delete_temp_view(ini_view_id);
   activate_view(view_id);
   return(status);
}

static int _ini_set_value2(_str section_name,_str field_name,_str new_value)
{
   status=_ini_find_section(section_name);
   if (status) {
      // IF trying to delete this field
      if (new_value._isempty()) {
         return(0);
      }
      insert_line('['section_name']');
      insert_line(field_name'='new_value);
      /* a little useless cleanup */
      down();
      get_line(line);
      if (line=='') {
         _delete_line();
      }
      status=_save_file("+o");
      //messageNwait('h4 status='status' 'p_buf_name);
      return(status);
   }
   _end_line();
   save_search(a,b,c,d);
   status=search('^('field_name'=|\[)', 'ri@');
   restore_search(a,b,c,d);
   if (status) {
      // IF trying to delete this field
      if (new_value._isempty()) {
         return(0);
      }
      insert_line(field_name'='new_value);
      status=_save_file("+o");
      //messageNwait('h3 status='status' 'p_buf_name);
      return(status);
   }
   get_line(line);
   if (substr(line,1,1)=='[') {
      // IF trying to delete this field
      if (new_value._isempty()) {
         return(0);
      }
      up();
      insert_line(field_name'='new_value);
      status=_save_file("+o");
      //messageNwait('status='status' 'p_buf_name);
      return(status);
   }
   parse line with old_fname '=' old_value;
   // IF trying to delete this field
   if (new_value._isempty()) {
      _delete_line();
   } else {
      replace_line(field_name'='new_value);
   }
   status=_save_file("+o");
   //messageNwait('h2 status='status' 'p_buf_name);
   return(status);
}

/*
    default_value has no effect on ini file.  It only affects return
    value when section name or field name does not exist.
*/
int _ini_get_value(_str filename,_str section_name,_str field_name,_str &result /*,default_value*/)
{
   status=_open_temp_view(filename,ini_view_id,view_id,'+d');
   if (status) {
      activate_view(view_id);
      result=arg(5);
      return(status);
   }
   get_view_id(orig_view_id);
   activate_view(ini_view_id);
   // If section_name or field_name not found, arg(5) is returned
   // actual value in file not changed.
   status=_ini_get_value2(section_name,field_name,result,arg(5))

   activate_view(orig_view_id);
   _delete_temp_view(ini_view_id);
   activate_view(view_id);
   return(status);
}

int _ini_delete_section(_str filename,_str section_name)
{
   status=_open_temp_view(filename,ini_view_id,view_id,'+d');
   if (status) return(status);
   get_view_id(orig_view_id);
   activate_view(ini_view_id);
   status=_ini_delete_section2(section_name);

   activate_view(orig_view_id);
   _delete_temp_view(ini_view_id);
   activate_view(view_id);
   return(status);
}

/*
   Call this function with cursor sitting on
   section header line [...]
*/
static void _ini_delete_section3(DeleteHeader)
{
   mark_id=_alloc_selection();
   if (DeleteHeader) {
      _select_line(mark_id);
      status=down();
      if (!status) {
         status=_ini_find_section('');
      }
   } else {
      status=down();
      if (status) {
         _free_selection(mark_id);
         return;
      }
      _select_line(mark_id);
      linenum=p_line;
      status=_ini_find_section('');
      // Nothing to delete
      if (!status) {
         if (linenum==p_line) {
            up();
            _free_selection(mark_id);
            return;
         }
      }
   }
   if (status) {
      bottom();
   }else{
      up();
   }
   _select_line(mark_id);
   if (!DeleteHeader) {
      // Place cursor on header line
      _begin_select(mark_id);up();
   }
   _delete_selection(mark_id);
   _free_selection(mark_id);
}
int _ini_delete_section2(_str section_name)
{
   status=_ini_find_section(section_name);
   if (status) {
      return(status);
   }
   _ini_delete_section3(1);
   return(_save_file("+o"));
}

static int _ini_get_value2(_str section_name,_str  field_name, _str &result)
{
   if (_ini_find_section(section_name)) {
      result=arg(4);
      return(1);  // String not found in section
   }
   _end_line();
   save_search(a,b,c,d);
   status=search('^('field_name'=|\[)', 'ri@');
   restore_search(a,b,c,d);
   if (status) {
      result=arg(4);
      return(STRING_NOT_FOUND_RC);
   }
   get_line(line);
   if (substr(line,1,1)=='[') {
      result=arg(4);
      return(STRING_NOT_FOUND_RC);
   }
   parse line with section_name'='result;
   return(0);
}

int _ini_parse_line(int ini_view, _str &field_name, _str &info/*, first*/)
{
/*  ini_view is a view of an ini file. */
/*  the name of the field in the current line is returned in field name */
/*  the value of the field at the current line is returned in info */

   get_view_id(view_id);
   activate_view(ini_view);
   if (arg(4)==1) {
      top();up();
   }
   if (down()) {
      _delete_buffer();
      _quit_view();
      activate_view(view_id);
      return(1);
   }
   get_line(line);
   parse line with field_name '=' info;
   activate_view(view_id);
   return(0);
}

/*
   Note: we don't start searching from top here so that
   we can use this function to find the start of the
   next section (section_name=="").
*/
int _ini_find_section(_str section_name)
{
   /* Searches for [section_name] at the begining of a line in the current buffer */
   /* If no search string is specifed, just finds the next section */
   section_name=_escape_re_chars(section_name);
   if (section_name!='') {
      top();up();
   }
   if (section_name=='') {
      search_string='^\[';
   }else{
      search_string='^\['section_name'\]?@$'
   }
   save_search(a,b,c,d);
   status=search(search_string,'ri@');
   restore_search(a,b,c,d);
   return(status);
}

int _ini_list_sections(_str filename)
{
   /* Operates on a listbox */
   status=_open_temp_view(filename,ini_view_id,view_id, '+d')
   if (status) return(status);
   get_view_id(orig_view_id);
   activate_view(ini_view_id);
   _ini_list_sections2(view_id);
   activate_view(orig_view_id);
   _delete_temp_view(ini_view_id);
   activate_view(view_id);
   return(0);
}

static void _ini_list_sections2(int lb_view_id)
{
   top();
   status=0;
   get_view_id(ini_view);
   save_search(a,b,c,d);
   while (!status) {
      status=search('^\[','r@');
      if (!status) {
         get_line(line);
         parse line with '[' name ']';
         if (name != '') {
            activate_view(lb_view_id);
            _lbadd_item(name);
            activate_view(ini_view);
         }
         if (down()) break;
      }
   }
   restore_search(a,b,c,d);
}
boolean _isfile_loaded(_str filename)
{
   status=_open_temp_view(absolute(filename),temp_view_id,orig_view_id,'+b');
   file_already_loaded=!status;
   if (!status) {
      _quit_view();
      activate_view(orig_view_id);
   }
   return(file_already_loaded);
}
int _ini_append_section(_str filename,_str section_name, _str new_string,_str ignorecase /* 'I' or '' */)
{
   orig_view_id = p_view_id;                                         //Switch to list buffer
   status =_ini_get_section(_project_name,section_name,listviewid);
   if (status) {
      if (status!=STRING_NOT_FOUND_RC) {
         return(status);
      }
      orig_view_id = p_view_id;                                      //Switch to list buffer
      _create_temp_view(listviewid);
      p_view_id = orig_view_id;                                      //Switch views
   }
   p_view_id = listviewid;                                           //Place temp View into focus
   if(!(search('^'_escape_re_chars(new_string)'$','r@'ignorecase))){
      return(0);               
   }

   bottom();                                                         //Move to the bottom of the buffer
   insert_line(new_string);                                          //Insert new material
   p_view_id = orig_view_id;                                         //Switch views
   status = _ini_put_section(_project_name,section_name,listviewid); //Insert new list into file
   return (status);
}

